<?php

// Log file path
$log_file = '/home/xui/binario_update.log';

// Function to log each execution
function log_execution($message) {
    global $log_file;
    $current_time = date('Y-m-d H:i:s');
    $log_message = "[" . $current_time . "] " . $message . "\n";
    file_put_contents($log_file, $log_message, FILE_APPEND);
}

if (posix_getpwuid(posix_geteuid())['name'] == 'root') {
    if ($argc) {
        register_shutdown_function('shutdown');
        require str_replace('\\', '/', dirname($argv[0])) . '/../../www/init.php';
        $f754bccbb574b7c6 = '/home/xui/bin/';
        $Ecd3e6ce0c91ac70 = 'https://update.xui.one/binaries/';
        $B2ff75c438fb3031 = '0755';

        // Log that the script has been executed
        log_execution("Binary executed: update script started");

        // Uncomment the function call if needed
        // fdc97512d22b990e();
    } else {
        exit(0);
    }
} else {
    exit('Please run as root!' . "\n");
}

/*
function fdc97512d22B990e()
{
    global $Ecd3e6ce0c91ac70;
    global $B2ff75c438fb3031;
    global $f754bccbb574b7c6;

    if (!shell_exec('which apparmor_status')) {
        // AppArmor not found
    } else {
        exec('sudo apparmor_status', $f8f232d4b4fc2860);

        if (strtolower(trim($f8f232d4b4fc2860[0])) != 'apparmor module is loaded.') {
            // AppArmor module is not loaded
        } else {
            exec('sudo systemctl is-active apparmor', $Ba23222f3ed2dc08);

            if (strtolower(trim($Ba23222f3ed2dc08[0])) != 'active') {
                // AppArmor is not active
            } else {
                echo 'AppArmor is loaded! Disabling...' . "\n";
                shell_exec('sudo systemctl stop apparmor');
                shell_exec('sudo systemctl disable apparmor');
            }
        }
    }

    $Daac4839c825e134 = $A8cd97ab4e563b9a = false;
    exec('sudo lsb_release -r -s', $C7c3a31e5980aa3d);
    $c85ed032f7e37367 = json_decode(file_get_contents(($Ecd3e6ce0c91ac70 . '?version=' . XUI_VERSION . '&ubv=' . floatval($C7c3a31e5980aa3d[0]) ?: '')), true);

    if (!is_array($c85ed032f7e37367)) {
        // Error in the update JSON
    } else {
        foreach ($c85ed032f7e37367['files'] as $e2f848a82a80c113) {
            if (file_exists($e2f848a82a80c113['path']) && md5_file($e2f848a82a80c113['path']) == $e2f848a82a80c113['md5']) {
                // File already up-to-date
            } else {
                $d46fb6a8e0e4684f = pathinfo($e2f848a82a80c113['path'])['dirname'] . '/';

                if (!file_exists($d46fb6a8e0e4684f)) {
                    shell_exec('sudo mkdir -p "' . $d46fb6a8e0e4684f . '"');
                }

                $c88afcbaf19918af = curl_init();
                curl_setopt($c88afcbaf19918af, CURLOPT_URL, $Ecd3e6ce0c91ac70 . $e2f848a82a80c113['md5']);
                curl_setopt($c88afcbaf19918af, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($c88afcbaf19918af, CURLOPT_CONNECTTIMEOUT, 30);
                curl_setopt($c88afcbaf19918af, CURLOPT_TIMEOUT, 300);
                $a27e64cc6ce01033 = curl_exec($c88afcbaf19918af);
                $Ba344b2758e3e955 = md5($a27e64cc6ce01033);

                if ($e2f848a82a80c113['md5'] != $Ba344b2758e3e955) {
                    // Error: File checksum does not match
                } else {
                    echo 'Updated binary: ' . $e2f848a82a80c113['path'] . "\n";
                    shell_exec('sudo rm -rf "' . $e2f848a82a80c113['path'] . '"');
                    file_put_contents($e2f848a82a80c113['path'], $a27e64cc6ce01033);
                    shell_exec('sudo chown xui:xui "' . $e2f848a82a80c113['path'] . '"');
                    shell_exec('sudo chmod ' . $B2ff75c438fb3031 . ' "' . $e2f848a82a80c113['path'] . '"');
                    $A8cd97ab4e563b9a = true;

                    if (substr(basename($e2f848a82a80c113['path']), 0, 3) != 'php') {
                        // Not a PHP binary
                    } else {
                        $Daac4839c825e134 = true;
                    }
                }
            }
        }
    }

    if ($A8cd97ab4e563b9a) {
        shell_exec('sudo chown -R xui:xui "' . $f754bccbb574b7c6 . '"');
    }

    if ($Daac4839c825e134) {
        $Db3333007923d513 = (array(72 => '7.2', 74 => '7.4')[XUI::$rServers[SERVER_ID]['php_version']] ?: '7.4');
        shell_exec('sudo ln -sfn ' . PHP_BIN . '_' . $Db3333007923d513 . ' ' . PHP_BIN);
        shell_exec('sudo ln -sfn ' . BIN_PATH . 'php/sbin/php-fpm_' . $Db3333007923d513 . ' ' . BIN_PATH . 'php/sbin/php-fpm');
        shell_exec('sudo chown -R xui:xui ' . BIN_PATH . 'php');
        shell_exec('sudo service xuione restart');
    }
}
*/

function shutdown()
{
    global $Fee0d5a474c96306;

    if (!is_object($Fee0d5a474c96306)) {
        // Log the shutdown event
        log_execution("Shutdown function executed");
    } else {
        $Fee0d5a474c96306->close_mysql();
        log_execution("Shutdown function executed and MySQL connection closed");
    }
}
