<?php

class XUI
{
	static public $db;
	static public $redis;
	static public $rRequest = [];
	static public $rConfig = [];
	static public $rSettings = [];
	static public $rBouquets = [];
	static public $rServers = [];
	static public $rSegmentSettings = [];
	static public $rBlockedUA = [];
	static public $rBlockedISP = [];
	static public $rBlockedIPs = [];
	static public $rBlockedServers = [];
	static public $rAllowedIPs = [];
	static public $rProxies = [];
	static public $rAllowedDomains = [];
	static public $rCategories = [];
	static public $rFFMPEG_CPU;
	static public $rFFMPEG_GPU;
	static public $rFFPROBE;
	static public $rCached;

    public static function init($Cc9585ca17bcaccf = false)
    {
        if(empty($_GET)) {
        } else {
            self::ac2B5dF0DB5256A6($_GET);
        }

        if(empty($_POST)) {
        } else {
            self::ac2b5df0db5256a6($_POST);
        }

        if(empty($_SESSION)) {
        } else {
            self::Ac2b5dF0Db5256A6($_SESSION);
        }

        if(empty($_COOKIE)) {
        } else {
            self::Ac2b5dF0dB5256A6($_COOKIE);
        }

        $Ed11f31c83568d44 = @self::ff9e13b7096801cB($_GET, array(  ));
        self::$rRequest = @self::FF9e13B7096801cB($_POST, $Ed11f31c83568d44);
        self::$rConfig = parse_ini_file(CONFIG_PATH . "config.ini");
        if(defined("SERVER_ID")) {
        } else {
            define("SERVER_ID", intval(self::$rConfig["server_id"]));
        }

        if($Cc9585ca17bcaccf) {
            self::$rSettings = self::B8E8a18b5bFfaaC0("settings");
        } else {
            self::$rSettings = self::c79A63BBCAD82975();
        }

        if(empty(self::$rSettings["default_timezone"])) {
        } else {
            date_default_timezone_set(self::$rSettings["default_timezone"]);
        }

        if(self::$rSettings["on_demand_wait_time"] != 0) {
        } else {
            self::$rSettings["on_demand_wait_time"] = 15;
        }

        self::$rSegmentSettings = array( "seg_type" => self::$rSettings["segment_type"], "seg_time" => intval(self::$rSettings["seg_time"]), "seg_list_size" => intval(self::$rSettings["seg_list_size"]), "seg_delete_threshold" => intval(self::$rSettings["seg_delete_threshold"]) );
        switch(self::$rSettings["ffmpeg_cpu"]) {
	case "7.1":
        self::$rFFMPEG_CPU = FFMPEG_BIN_71;
        self::$rFFPROBE = FFPROBE_BIN_71;
        break;
	case "7.0":
        self::$rFFMPEG_CPU = FFMPEG_BIN_70;
        self::$rFFPROBE = FFPROBE_BIN_70;
        break;
    case "6.1":
        self::$rFFMPEG_CPU = FFMPEG_BIN_61;
        self::$rFFPROBE = FFPROBE_BIN_61;
        break;
    case "6.0":
        self::$rFFMPEG_CPU = FFMPEG_BIN_60;
        self::$rFFPROBE = FFPROBE_BIN_60;
        break;
    case "5.1":
        self::$rFFMPEG_CPU = FFMPEG_BIN_51;
        self::$rFFPROBE = FFPROBE_BIN_51;
        break;
    case "5.0":
        self::$rFFMPEG_CPU = FFMPEG_BIN_50;
        self::$rFFPROBE = FFPROBE_BIN_50;
        break;
    case "4.4":
        self::$rFFMPEG_CPU = FFMPEG_BIN_44;
        self::$rFFPROBE = FFPROBE_BIN_44;
        break;
    case "4.3":
        self::$rFFMPEG_CPU = FFMPEG_BIN_43;
        self::$rFFPROBE = FFPROBE_BIN_43;
        break;
    case "4.2":
        self::$rFFMPEG_CPU = FFMPEG_BIN_42;
        self::$rFFPROBE = FFPROBE_BIN_42;
        break;
    default:
        self::$rFFMPEG_CPU = FFMPEG_BIN_40;
        self::$rFFPROBE = FFPROBE_BIN_40;
        break;
}
        self::$rFFMPEG_GPU = FFMPEG_BIN_40;
        self::$rCached = self::$rSettings["enable_cache"];
        if( $Cc9585ca17bcaccf ) 
        {
            self::$rServers = self::b8e8a18b5BfFaAC0("servers");
            self::$rBouquets = self::B8E8a18b5bfFaac0("bouquets");
            self::$rBlockedUA = self::B8e8A18b5bFfaac0("blocked_ua");
            self::$rBlockedISP = self::B8e8a18b5bfFAac0("blocked_isp");
            self::$rBlockedIPs = self::b8E8A18b5BFFaaC0("blocked_ips");
            self::$rProxies = self::B8e8a18B5BFFAAC0("proxy_servers");
            self::$rBlockedServers = self::b8e8A18B5bffAAc0("blocked_servers");
            self::$rAllowedDomains = self::B8E8a18B5bFFaaC0("allowed_domains");
            self::$rAllowedIPs = self::b8E8A18b5BFFAAc0("allowed_ips");
            self::$rCategories = self::b8e8a18b5bFFaAc0("categories");
        }
        else
        {
            self::$rServers = self::B0d77D8CFf33C5c1();
            self::$rBouquets = self::Dc58273695e31551();
            self::$rBlockedUA = self::E1BB309B36e1A6EF();
            self::$rBlockedISP = self::CF0c3a7B6f789d33();
            self::$rBlockedIPs = self::c71682CE1c489336();
            self::$rProxies = self::CA6f48F4C6a80e3B();
            self::$rBlockedServers = self::C5F0E058dC3E0cF7();
            self::$rAllowedDomains = self::aa6C34E7d4Ea4608();
            self::$rAllowedIPs = self::bc3b5F6b7e95eC13();
            self::$rCategories = self::e117150acff7C7d6();
            self::e80449d3bb723838();
        }
   }

    public static function C517638D206554D9($B9d167891d59963c)
    {
        $d7695fed28e44076 = new DateTime("UTC", new DateTimeZone(date_default_timezone_get()));
        $Bc0d5534b7179307 = new DateTime("UTC", new DateTimeZone($B9d167891d59963c));
        return $Bc0d5534b7179307->getTimestamp() - $d7695fed28e44076->getTimestamp();
    }

    public static function aa6C34e7d4Ea4608($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8E8a18b5BFfaAc0("allowed_domains", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $D06b68b88f202d75 = array( "127.0.0.1", "localhost" );
        self::$db->query("SELECT `server_ip`, `private_ip`, `domain_name` FROM `servers` WHERE `enabled` = 1;");
        foreach(self::$db->get_rows() as $e6002db131ca9d50) {
            foreach(explode(",", $e6002db131ca9d50["domain_name"]) as $c4537dbba77895b5) {
                $D06b68b88f202d75[] = $c4537dbba77895b5;
            }
            if(!$e6002db131ca9d50["server_ip"]) {
            } else {
                $D06b68b88f202d75[] = $e6002db131ca9d50["server_ip"];
            }

            if(!$e6002db131ca9d50["private_ip"]) {
            } else {
                $D06b68b88f202d75[] = $e6002db131ca9d50["private_ip"];
            }

        }
        self::$db->query("SELECT `reseller_dns` FROM `users` WHERE `status` = 1;");
        foreach(self::$db->get_rows() as $e6002db131ca9d50) {
            if(!$e6002db131ca9d50["reseller_dns"]) {
            } else {
                $D06b68b88f202d75[] = $e6002db131ca9d50["reseller_dns"];
            }

        }
        $D06b68b88f202d75 = array_filter(array_unique($D06b68b88f202d75));
        self::F57d63497771d13e("allowed_domains", $D06b68b88f202d75);
        return $D06b68b88f202d75;
    }

    public static function ca6f48f4c6a80e3B($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::B8E8a18B5BFFAac0("proxy_servers", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $B3dd6de7b6ec6ab8 = array(  );
        foreach(self::$rServers as $e5a4b7c8f931534f) {
            if($e5a4b7c8f931534f["server_type"] != 1) {
            } else {
                $B3dd6de7b6ec6ab8[$e5a4b7c8f931534f["server_ip"]] = $e5a4b7c8f931534f;
                if(!$e5a4b7c8f931534f["private_ip"]) {
                } else {
                    $B3dd6de7b6ec6ab8[$e5a4b7c8f931534f["private_ip"]] = $e5a4b7c8f931534f;
                }

            }

        }
        self::F57d63497771D13E("proxy_servers", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function F9db160fA0ACe822($f948824c538b45fa)
    {
        if(!isset(self::$rProxies[$f948824c538b45fa])) {
        } else {
            return self::$rProxies[$f948824c538b45fa];
        }
		return NULL;
    }

    public static function E1bB309B36e1A6Ef($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8E8a18b5bffAaC0("blocked_ua", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        self::$db->query("SELECT id,exact_match,LOWER(user_agent) as blocked_ua FROM `blocked_uas`");
        $B3dd6de7b6ec6ab8 = self::$db->get_rows(true, "id");
        self::f57D63497771d13E("blocked_ua", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function c71682Ce1c489336($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8e8a18B5BFfAAc0("blocked_ips", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $B3dd6de7b6ec6ab8 = array(  );
        self::$db->query("SELECT `ip` FROM `blocked_ips`");
        foreach(self::$db->get_rows() as $e6002db131ca9d50) {
            $B3dd6de7b6ec6ab8[] = $e6002db131ca9d50["ip"];
        }
        self::f57D63497771d13e("blocked_ips", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function cF0c3A7b6f789d33($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::B8E8A18b5BfFAac0("blocked_isp", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        self::$db->query("SELECT id,isp,blocked FROM `blocked_isps`");
        $B3dd6de7b6ec6ab8 = self::$db->get_rows();
        self::f57d63497771d13E("blocked_isp", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function c5F0e058DC3e0cf7($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8e8a18B5BfFAAc0("blocked_servers", 20);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $B3dd6de7b6ec6ab8 = array(  );
        self::$db->query("SELECT `asn` FROM `blocked_asns` WHERE `blocked` = 1;");
        foreach(self::$db->get_rows() as $e6002db131ca9d50) {
            $B3dd6de7b6ec6ab8[] = $e6002db131ca9d50["asn"];
        }
        self::F57D63497771d13e("blocked_servers", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function DC58273695E31551($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8E8A18b5BffaAc0("bouquets", 60);
            if(empty($A1a1fb89e05ece47)) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $B3dd6de7b6ec6ab8 = array(  );
        self::$db->query("SELECT *, IF(`bouquet_order` > 0, `bouquet_order`, 999) AS `order` FROM `bouquets` ORDER BY `order` ASC;");
        foreach(self::$db->get_rows(true, "id") as $A76532e4f616ce0c => $E9b30925ed9ebdc3) {
            $B3dd6de7b6ec6ab8[$A76532e4f616ce0c]["streams"] = array_merge(json_decode($E9b30925ed9ebdc3["bouquet_channels"], true), json_decode($E9b30925ed9ebdc3["bouquet_movies"], true), json_decode($E9b30925ed9ebdc3["bouquet_radios"], true));
            $B3dd6de7b6ec6ab8[$A76532e4f616ce0c]["series"] = json_decode($E9b30925ed9ebdc3["bouquet_series"], true);
            $B3dd6de7b6ec6ab8[$A76532e4f616ce0c]["channels"] = json_decode($E9b30925ed9ebdc3["bouquet_channels"], true);
            $B3dd6de7b6ec6ab8[$A76532e4f616ce0c]["movies"] = json_decode($E9b30925ed9ebdc3["bouquet_movies"], true);
            $B3dd6de7b6ec6ab8[$A76532e4f616ce0c]["radios"] = json_decode($E9b30925ed9ebdc3["bouquet_radios"], true);
        }
        self::f57d63497771D13e("bouquets", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function C79a63BbcaD82975($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8e8a18B5bffaac0("settings", 20);
            if(empty($A1a1fb89e05ece47)) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $B3dd6de7b6ec6ab8 = array(  );
        self::$db->query("SELECT * FROM `settings`");
        $Fdb08a8c6c6e3410 = self::$db->get_row();
        foreach($Fdb08a8c6c6e3410 as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
            $B3dd6de7b6ec6ab8[$A6236b8f3b6a4fa6] = $fff0f0d8088c1ce3;
        }
        $B3dd6de7b6ec6ab8["allow_countries"] = json_decode($B3dd6de7b6ec6ab8["allow_countries"], true);
        $B3dd6de7b6ec6ab8["allowed_stb_types"] = array_map("strtolower", json_decode($B3dd6de7b6ec6ab8["allowed_stb_types"], true));
        $B3dd6de7b6ec6ab8["stalker_lock_images"] = json_decode($B3dd6de7b6ec6ab8["stalker_lock_images"], true);
        if(!array_key_exists("bouquet_name", $B3dd6de7b6ec6ab8)) {
        } else {
            $B3dd6de7b6ec6ab8["bouquet_name"] = str_replace(" ", "_", $B3dd6de7b6ec6ab8["bouquet_name"]);
        }

        $B3dd6de7b6ec6ab8["api_ips"] = explode(",", $B3dd6de7b6ec6ab8["api_ips"]);
        $B3dd6de7b6ec6ab8["live_streaming_pass"] = md5(sha1(self::$rSettings["license"] . ((self::$rSettings["security_key"] ?: ""))) . OPENSSL_EXTRA);
        self::f57D63497771d13e("settings", $B3dd6de7b6ec6ab8);
        return $B3dd6de7b6ec6ab8;
    }

    public static function F57d63497771D13e($A1a1fb89e05ece47, $C9340e84b67c26bc)
    {
        $C9340e84b67c26bc = igbinary_serialize($C9340e84b67c26bc);
        file_put_contents(CACHE_TMP_PATH . $A1a1fb89e05ece47, $C9340e84b67c26bc, LOCK_EX);
    }

    public static function B8e8a18B5bFfAAC0($A1a1fb89e05ece47, $Ff9f678c048b6c89 = null)
    {
        if(!file_exists(CACHE_TMP_PATH . $A1a1fb89e05ece47)) {
        } else {
            if($Ff9f678c048b6c89 && time() - filemtime(CACHE_TMP_PATH . $A1a1fb89e05ece47) >= $Ff9f678c048b6c89) {
            } else {
                $C9340e84b67c26bc = file_get_contents(CACHE_TMP_PATH . $A1a1fb89e05ece47);
                return igbinary_unserialize($C9340e84b67c26bc);
            }

        }

        return false;
    }

    public static function b0D77d8cff33C5c1($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::B8e8a18B5BffAaC0("servers", 10);
            if(empty($A1a1fb89e05ece47)) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        if(!empty($_SERVER["REQUEST_SCHEME"])) {
        } else {
            $_SERVER["REQUEST_SCHEME"] = "http";
        }

        self::$db->query("SELECT * FROM `servers`");
        $ca897b151051c2d0 = array(  );
        $c25e8a3da98583db = array( 1 );
        foreach(self::$db->get_rows() as $e6002db131ca9d50) {
            if(empty($e6002db131ca9d50["domain_name"])) {
                $C872016bcd6efd74 = escapeshellcmd($e6002db131ca9d50["server_ip"]);
            } else {
                $C872016bcd6efd74 = str_replace(array( "http://", "/", "https://" ), "", escapeshellcmd(explode(",", $e6002db131ca9d50["domain_name"])[0]));
            }

            if($e6002db131ca9d50["enable_https"] == 1) {
                $Eb49e051e67718d4 = "https";
            } else {
                $Eb49e051e67718d4 = "http";
            }

            $D1643ee37ff42c56 = ($Eb49e051e67718d4 == "http" ? intval($e6002db131ca9d50["http_broadcast_port"]) : intval($e6002db131ca9d50["https_broadcast_port"]));
            $e6002db131ca9d50["server_protocol"] = $Eb49e051e67718d4;
            $e6002db131ca9d50["request_port"] = $D1643ee37ff42c56;
            $e6002db131ca9d50["site_url"] = $Eb49e051e67718d4 . "://" . $C872016bcd6efd74 . ":" . $D1643ee37ff42c56 . "/";
            $e6002db131ca9d50["http_url"] = "http://" . $C872016bcd6efd74 . ":" . intval($e6002db131ca9d50["http_broadcast_port"]) . "/";
            $e6002db131ca9d50["https_url"] = "https://" . $C872016bcd6efd74 . ":" . intval($e6002db131ca9d50["https_broadcast_port"]) . "/";
            $e6002db131ca9d50["rtmp_server"] = "rtmp://" . $C872016bcd6efd74 . ":" . intval($e6002db131ca9d50["rtmp_port"]) . "/live/";
            $e6002db131ca9d50["domains"] = array( "protocol" => $Eb49e051e67718d4, "port" => $D1643ee37ff42c56, "urls" => array_filter(array_map("escapeshellcmd", explode(",", $e6002db131ca9d50["domain_name"]))) );
            $e6002db131ca9d50["rtmp_mport_url"] = "http://127.0.0.1:31210/";
            $e6002db131ca9d50["api_url_ip"] = "http://" . escapeshellcmd($e6002db131ca9d50["server_ip"]) . ":" . intval($e6002db131ca9d50["http_broadcast_port"]) . "/api?password=" . urlencode(self::$rSettings["live_streaming_pass"]);
            $e6002db131ca9d50["api_url"] = $e6002db131ca9d50["api_url_ip"];
            $e6002db131ca9d50["site_url_ip"] = $Eb49e051e67718d4 . "://" . escapeshellcmd($e6002db131ca9d50["server_ip"]) . ":" . $D1643ee37ff42c56 . "/";
            $e6002db131ca9d50["private_url_ip"] = (!empty($e6002db131ca9d50["private_ip"]) ? "http://" . escapeshellcmd($e6002db131ca9d50["private_ip"]) . ":" . intval($e6002db131ca9d50["http_broadcast_port"]) . "/" : null);
            $e6002db131ca9d50["public_url_ip"] = "http://" . escapeshellcmd($e6002db131ca9d50["server_ip"]) . ":" . intval($e6002db131ca9d50["http_broadcast_port"]) . "/";
            $e6002db131ca9d50["geoip_countries"] = (empty($e6002db131ca9d50["geoip_countries"]) ? array(  ) : json_decode($e6002db131ca9d50["geoip_countries"], true));
            $e6002db131ca9d50["isp_names"] = (empty($e6002db131ca9d50["isp_names"]) ? array(  ) : json_decode($e6002db131ca9d50["isp_names"], true));
            if(is_numeric($e6002db131ca9d50["parent_id"])) {
                $e6002db131ca9d50["parent_id"] = array( intval($e6002db131ca9d50["parent_id"]) );
            } else {
                $e6002db131ca9d50["parent_id"] = array_map("intval", json_decode($e6002db131ca9d50["parent_id"], true));
            }

            if($e6002db131ca9d50["enable_https"] == 2) {
                $e6002db131ca9d50["allow_http"] = false;
            } else {
                $e6002db131ca9d50["allow_http"] = true;
            }

            if($e6002db131ca9d50["server_type"] == 1) {
                $Bde2c2b368d16bd0 = 180;
            } else {
                $Bde2c2b368d16bd0 = 90;
            }

            $e6002db131ca9d50["watchdog"] = json_decode($e6002db131ca9d50["watchdog_data"], true);
            $e6002db131ca9d50["server_online"] = $e6002db131ca9d50["enabled"] && in_array($e6002db131ca9d50["status"], $c25e8a3da98583db) && time() - $e6002db131ca9d50["last_check_ago"] <= $Bde2c2b368d16bd0 || SERVER_ID == $e6002db131ca9d50["id"];
            $ca897b151051c2d0[intval($e6002db131ca9d50["id"])] = $e6002db131ca9d50;
        }
        self::f57d63497771d13e("servers", $ca897b151051c2d0);
        return $ca897b151051c2d0;
    }

    public static function f48f0BB7120C7Efb($E0a0508e8cc01c8b, $b1a25aefe46c59b7 = null, $d5433a391c26a830 = 5)
    {
        if(empty($E0a0508e8cc01c8b)) {
            return array(  );
        }

        $c6eacfa4f04ceb05 = array(  );
        $f6ff5524c7f94bba = array(  );
        $Cba70d6d90f5ab9b = array(  );
        $E19f83e1ea54eb2d = curl_multi_init();
        foreach($E0a0508e8cc01c8b as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
            if(self::$rServers[$A6236b8f3b6a4fa6]["server_online"]) {
                $f6ff5524c7f94bba[$A6236b8f3b6a4fa6] = curl_init();
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_URL, $fff0f0d8088c1ce3["url"]);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_RETURNTRANSFER, true);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_CONNECTTIMEOUT, 5);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_TIMEOUT, $d5433a391c26a830);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_SSL_VERIFYPEER, 0);
                if($fff0f0d8088c1ce3["postdata"] == null) {
                } else {
                    curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_POST, true);
                    curl_setopt($f6ff5524c7f94bba[$A6236b8f3b6a4fa6], CURLOPT_POSTFIELDS, http_build_query($fff0f0d8088c1ce3["postdata"]));
                }

                curl_multi_add_handle($E19f83e1ea54eb2d, $f6ff5524c7f94bba[$A6236b8f3b6a4fa6]);
            } else {
                $c6eacfa4f04ceb05[] = $A6236b8f3b6a4fa6;
            }

        }
        $d3e709dbb375e76e = null;
        do {
            $fe2010331a8355be = curl_multi_exec($E19f83e1ea54eb2d, $d3e709dbb375e76e);
        } while($fe2010331a8355be == CURLM_CALL_MULTI_PERFORM);
		
        while($d3e709dbb375e76e && $fe2010331a8355be == CURLM_OK) {
            /*while*/ if(curl_multi_select($E19f83e1ea54eb2d) == -1) {
                usleep(50000);
            }
            do {
                $fe2010331a8355be = curl_multi_exec($E19f83e1ea54eb2d, $d3e709dbb375e76e);
            } while($fe2010331a8355be == CURLM_CALL_MULTI_PERFORM);
        }
        foreach($f6ff5524c7f94bba as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
            $Cba70d6d90f5ab9b[$A6236b8f3b6a4fa6] = curl_multi_getcontent($fff0f0d8088c1ce3);
            if($b1a25aefe46c59b7 == null) {
            } else {
                $Cba70d6d90f5ab9b[$A6236b8f3b6a4fa6] = call_user_func($b1a25aefe46c59b7, $Cba70d6d90f5ab9b[$A6236b8f3b6a4fa6], true);
            }

            curl_multi_remove_handle($E19f83e1ea54eb2d, $fff0f0d8088c1ce3);
        }
        foreach($c6eacfa4f04ceb05 as $A6236b8f3b6a4fa6) {
            $Cba70d6d90f5ab9b[$A6236b8f3b6a4fa6] = false;
        }
        curl_multi_close($E19f83e1ea54eb2d);
        return $Cba70d6d90f5ab9b;
    }

    public static function ac2B5Df0Db5256a6(&$C9340e84b67c26bc, $B43d05579f40b76c = 0)
    {
        if(10 > $B43d05579f40b76c) {
            foreach($C9340e84b67c26bc as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
                if(is_array($fff0f0d8088c1ce3)) {
                    self::ac2b5DF0dB5256a6($C9340e84b67c26bc[$A6236b8f3b6a4fa6], ++$B43d05579f40b76c);
                } else {
					$fff0f0d8088c1ce3 = str_replace(chr('0'), '', $fff0f0d8088c1ce3);
					$fff0f0d8088c1ce3 = str_replace("\0", '', $fff0f0d8088c1ce3);
					$fff0f0d8088c1ce3 = str_replace("\0", '', $fff0f0d8088c1ce3);
					$fff0f0d8088c1ce3 = str_replace('../', '&#46;&#46;/', $fff0f0d8088c1ce3);
                    $fff0f0d8088c1ce3 = str_replace("&#8238;", "", $fff0f0d8088c1ce3);
                    $C9340e84b67c26bc[$A6236b8f3b6a4fa6] = $fff0f0d8088c1ce3;
                }

            }
        } else {
            return null;
        }

    }

    public static function fF9e13b7096801cb(&$C9340e84b67c26bc, $Ed11f31c83568d44 = array(  ), $B43d05579f40b76c = 0)
    {
        if(20 > $B43d05579f40b76c) {
            if(is_array($C9340e84b67c26bc)) {
                foreach($C9340e84b67c26bc as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
                    if(is_array($fff0f0d8088c1ce3)) {
                        $Ed11f31c83568d44[$A6236b8f3b6a4fa6] = self::ff9E13B7096801CB($C9340e84b67c26bc[$A6236b8f3b6a4fa6], array(  ), $B43d05579f40b76c + 1);
                    } else {
                        $A6236b8f3b6a4fa6 = self::fAAe929cff4f4D78($A6236b8f3b6a4fa6);
                        $fff0f0d8088c1ce3 = self::a558190e79E7Cc31($fff0f0d8088c1ce3);
                        $Ed11f31c83568d44[$A6236b8f3b6a4fa6] = $fff0f0d8088c1ce3;
                    }

                }
                return $Ed11f31c83568d44;
            } else {
                return $Ed11f31c83568d44;
            }

        } else {
            return $Ed11f31c83568d44;
        }

    }

    public static function fAAE929cfF4f4D78($A6236b8f3b6a4fa6)
    {
        if($A6236b8f3b6a4fa6 !== "") {
            $A6236b8f3b6a4fa6 = htmlspecialchars(urldecode($A6236b8f3b6a4fa6));
            $A6236b8f3b6a4fa6 = str_replace("..", "", $A6236b8f3b6a4fa6);
            $A6236b8f3b6a4fa6 = preg_replace("/\\_\\_(.+?)\\_\\_/", "", $A6236b8f3b6a4fa6);
            return preg_replace("/^([\\w\\.\\-\\_]+)\$/", "\$1", $A6236b8f3b6a4fa6);
        }

        return "";
    }

    public static function a558190E79E7CC31($fff0f0d8088c1ce3)
    {
        if($fff0f0d8088c1ce3 != "") {
            $fff0f0d8088c1ce3 = str_replace("&#032;", " ", stripslashes($fff0f0d8088c1ce3));
            $fff0f0d8088c1ce3 = str_replace(array( "\r\n", "\n\r", "\r" ), "\n", $fff0f0d8088c1ce3);
            $fff0f0d8088c1ce3 = str_replace("<!--", "&#60;&#33;--", $fff0f0d8088c1ce3);
            $fff0f0d8088c1ce3 = str_replace("-->", "--&#62;", $fff0f0d8088c1ce3);
            $fff0f0d8088c1ce3 = str_ireplace("<script", "&#60;script", $fff0f0d8088c1ce3);
            $fff0f0d8088c1ce3 = preg_replace("/&amp;#([0-9]+);/s", "&#\\1;", $fff0f0d8088c1ce3);
            $fff0f0d8088c1ce3 = preg_replace("/&#(\\d+?)([^\\d;])/i", "&#\\1;\\2", $fff0f0d8088c1ce3);
            return trim($fff0f0d8088c1ce3);
        }

        return "";
    }

    public static function dbf4D5DCe07924f0($b3b256939cb18212, $d885249f9649b505, $Fc14a82c38b5593d = "", $Fcb66b83cdf12a23 = 0)
    {
        if(!(stripos($Fc14a82c38b5593d, "panel_logs") === false && stripos($d885249f9649b505, "timeout exceeded") === false && stripos($d885249f9649b505, "lock wait timeout") === false && stripos($d885249f9649b505, "duplicate entry") === false)) {
        } else {
            panelLog($b3b256939cb18212, $d885249f9649b505, $Fc14a82c38b5593d, $Fcb66b83cdf12a23);
        }

    }

    public static function b26F2f65F074e0A3($b9b41cf583b179db = 10)
    {
        $Ab0b6d1f1f2d4681 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789qwertyuiopasdfghjklzxcvbnm";
        $fda7b8636303d40b = "";
        $ccb4b8a47a816c79 = strlen($Ab0b6d1f1f2d4681) - 1;
        $bb850694dd82a471 = 0;
        while($bb850694dd82a471 < $b9b41cf583b179db) {
            $fda7b8636303d40b .= $Ab0b6d1f1f2d4681[rand(0, $ccb4b8a47a816c79)];
            $bb850694dd82a471++;
        }
        return $fda7b8636303d40b;
    }

    public static function a269Ecd38dd4B0C0($D2b5504b90a32341)
    {
        if(is_array($D2b5504b90a32341)) {
            $b0908c0981ba582e = array(  );
            foreach($D2b5504b90a32341 as $fff0f0d8088c1ce3) {
                if(is_scalar($fff0f0d8088c1ce3) || is_resource($fff0f0d8088c1ce3)) {
                    $b0908c0981ba582e[] = $fff0f0d8088c1ce3;
                } else {
                    if(!is_array($fff0f0d8088c1ce3)) {
                    } else {
                        $b0908c0981ba582e = array_merge($b0908c0981ba582e, self::a269eCD38dd4b0c0($fff0f0d8088c1ce3));
                    }

                }

            }
            return $b0908c0981ba582e;
        } else {
            return $D2b5504b90a32341;
        }

    }

    public static function Df0BF15AA5A2Ddc7()
    {
        $E75b237805610d13 = 0;
        exec("df | grep tmpfs", $B3dd6de7b6ec6ab8);
        foreach($B3dd6de7b6ec6ab8 as $Fcb66b83cdf12a23) {
            $D401f744de8fd552 = explode(" ", preg_replace("!\\s+!", " ", $Fcb66b83cdf12a23));
            if($D401f744de8fd552[0] != "tmpfs") {
            } else {
                $E75b237805610d13 += intval($D401f744de8fd552[2]);
            }

        }
        return $E75b237805610d13;
    }

    public static function A3E7874De0140fA7()
    {
        $ddc9bd810c3acdba = array(  );
        $ddc9bd810c3acdba["cpu"] = round(self::Ad755BE4EFEbA2f2(), 2);
        $ddc9bd810c3acdba["cpu_cores"] = intval(shell_exec("cat /proc/cpuinfo | grep \"^processor\" | wc -l"));
        $ddc9bd810c3acdba["cpu_avg"] = round((sys_getloadavg()[0] * 100) / (($ddc9bd810c3acdba["cpu_cores"] ?: 1)), 2);
        $ddc9bd810c3acdba["cpu_name"] = trim(shell_exec("cat /proc/cpuinfo | grep 'model name' | uniq | awk -F: '{print \$2}'"));
        if(100 >= $ddc9bd810c3acdba["cpu_avg"]) {
        } else {
            $ddc9bd810c3acdba["cpu_avg"] = 100;
        }

        $e17a771a2c240920 = explode("\n", trim(shell_exec("free")));
        $e2d176ddfdea7e92 = preg_split("/[\\s]+/", $e17a771a2c240920[1]);
        $ec5cf40108ee051b = intval($e2d176ddfdea7e92[2]);
        $bf93ac7f732555e5 = intval($e2d176ddfdea7e92[1]);
        $ddc9bd810c3acdba["total_mem"] = $bf93ac7f732555e5;
        $ddc9bd810c3acdba["total_mem_free"] = $bf93ac7f732555e5 - $ec5cf40108ee051b;
        $ddc9bd810c3acdba["total_mem_used"] = $ec5cf40108ee051b + self::Df0bf15aa5A2DdC7();
        $ddc9bd810c3acdba["total_mem_used_percent"] = round($ddc9bd810c3acdba["total_mem_used"] / $ddc9bd810c3acdba["total_mem"] * 100, 2);
        $ddc9bd810c3acdba["total_disk_space"] = disk_total_space(XUI_HOME);
        $ddc9bd810c3acdba["free_disk_space"] = disk_free_space(XUI_HOME);
        $ddc9bd810c3acdba["kernel"] = trim(shell_exec("uname -r"));
        $ddc9bd810c3acdba["uptime"] = self::C35b0C1Ea821c567();
        $ddc9bd810c3acdba["total_running_streams"] = (int) trim(shell_exec("ps ax | grep -v grep | grep -c ffmpeg"));
        $ddc9bd810c3acdba["bytes_sent"] = 0;
        $ddc9bd810c3acdba["bytes_sent_total"] = 0;
        $ddc9bd810c3acdba["bytes_received"] = 0;
        $ddc9bd810c3acdba["bytes_received_total"] = 0;
        $ddc9bd810c3acdba["network_speed"] = 0;
        $ddc9bd810c3acdba["interfaces"] = self::C1490399465149d8();
        $ddc9bd810c3acdba["network_speed"] = 0;
        if(100 >= $ddc9bd810c3acdba["cpu"]) {
        } else {
            $ddc9bd810c3acdba["cpu"] = 100;
        }

        if($ddc9bd810c3acdba["total_mem"] >= $ddc9bd810c3acdba["total_mem_used"]) {
        } else {
            $ddc9bd810c3acdba["total_mem_used"] = $ddc9bd810c3acdba["total_mem"];
        }

        if(100 >= $ddc9bd810c3acdba["total_mem_used_percent"]) {
        } else {
            $ddc9bd810c3acdba["total_mem_used_percent"] = 100;
        }

        $ddc9bd810c3acdba["network_info"] = XUI::getNetwork((self::$rServers[SERVER_ID]["network_interface"] == "auto" ? null : self::$rServers[SERVER_ID]["network_interface"]));
        foreach($ddc9bd810c3acdba["network_info"] as $ee53d31b15f1303b => $C9340e84b67c26bc) {
            if(!file_exists("/sys/class/net/" . $ee53d31b15f1303b . "/speed")) {
            } else {
                $C696cb814accf36f = intval(file_get_contents("/sys/class/net/" . $ee53d31b15f1303b . "/speed"));
                if(!(0 < $C696cb814accf36f && $ddc9bd810c3acdba["network_speed"] == 0)) {
                } else {
                    $ddc9bd810c3acdba["network_speed"] = $C696cb814accf36f;
                }

            }

            $ddc9bd810c3acdba["bytes_sent_total"] = (intval(trim(file_get_contents("/sys/class/net/" . $ee53d31b15f1303b . "/statistics/tx_bytes"))) ?: 0);
            $ddc9bd810c3acdba["bytes_received_total"] = (intval(trim(file_get_contents("/sys/class/net/" . $ee53d31b15f1303b . "/statistics/tx_bytes"))) ?: 0);
            $ddc9bd810c3acdba["bytes_sent"] += $C9340e84b67c26bc["out_bytes"];
            $ddc9bd810c3acdba["bytes_received"] += $C9340e84b67c26bc["in_bytes"];
        }
        $ddc9bd810c3acdba["audio_devices"] = array(  );
        $ddc9bd810c3acdba["video_devices"] = $ddc9bd810c3acdba["audio_devices"];
        $ddc9bd810c3acdba["gpu_info"] = $ddc9bd810c3acdba["video_devices"];
        $ddc9bd810c3acdba["iostat_info"] = $ddc9bd810c3acdba["gpu_info"];
        if(!shell_exec("which iostat")) {
        } else {
            $ddc9bd810c3acdba["iostat_info"] = self::D7a84352f551eA10();
        }

        if(!shell_exec("which nvidia-smi")) {
        } else {
            $ddc9bd810c3acdba["gpu_info"] = self::bc7fd47dbfCdCc18();
        }

        if(!shell_exec("which v4l2-ctl")) {
        } else {
            $ddc9bd810c3acdba["video_devices"] = self::dd858439da4502bB();
        }

        if(!shell_exec("which arecord")) {
        } else {
            $ddc9bd810c3acdba["audio_devices"] = self::b60E57f3821E9591();
        }

        list($ddc9bd810c3acdba["cpu_load_average"]) = sys_getloadavg();
        return $ddc9bd810c3acdba;
    }

    public static function c1490399465149d8()
    {
        $F0e839083d6bad06 = array(  );
        exec("ls /sys/class/net/", $B3dd6de7b6ec6ab8, $B02d3144ed68be42);
        foreach($B3dd6de7b6ec6ab8 as $ee53d31b15f1303b) {
            $ee53d31b15f1303b = trim(rtrim($ee53d31b15f1303b, ":"));
            if(!($ee53d31b15f1303b != "lo" && substr($ee53d31b15f1303b, 0, 4) != "bond")) {
            } else {
                $F0e839083d6bad06[] = $ee53d31b15f1303b;
            }

        }
        return $F0e839083d6bad06;
    }

    public static function dD858439dA4502bb()
    {
        $F0e839083d6bad06 = array(  );
        $A76532e4f616ce0c = 0;
        try {
            $eae7888b2e728725 = array_values(array_filter(explode("\n", shell_exec("v4l2-ctl --list-devices"))));
            if(!is_array($eae7888b2e728725)) {
            } else {
                foreach($eae7888b2e728725 as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
                    if($A6236b8f3b6a4fa6 % 2 != 0) {
                    } else {
                        $F0e839083d6bad06[$A76532e4f616ce0c]["name"] = $fff0f0d8088c1ce3;
                        list(, $F0e839083d6bad06[$A76532e4f616ce0c]["video_device"]) = explode("/dev/", $eae7888b2e728725[$A6236b8f3b6a4fa6 + 1]);
                        $A76532e4f616ce0c++;
                    }

                }
            }

        } catch(Exception $B2ccc338b087b443) {
        }
        return $F0e839083d6bad06;
    }

    public static function B60E57F3821e9591()
    {
        try {
            return array_filter(explode("\n", shell_exec("arecord -L | grep \"hw:CARD=\"")));
        } catch(Exception $B2ccc338b087b443) {
            return array(  );
        }
    }

    public static function d7a84352F551Ea10()
    {
        exec("iostat -o JSON -m", $B3dd6de7b6ec6ab8, $B02d3144ed68be42);
        $B3dd6de7b6ec6ab8 = implode("", $B3dd6de7b6ec6ab8);
        $ddc9bd810c3acdba = json_decode($B3dd6de7b6ec6ab8, true);
        if(isset($ddc9bd810c3acdba["sysstat"])) {
            return $ddc9bd810c3acdba["sysstat"]["hosts"][0]["statistics"][0];
        }

        return array(  );
    }

    public static function BC7FD47dbfcdCC18()
    {
        exec("nvidia-smi -x -q", $B3dd6de7b6ec6ab8, $B02d3144ed68be42);
        $B3dd6de7b6ec6ab8 = implode("", $B3dd6de7b6ec6ab8);
        if(stripos($B3dd6de7b6ec6ab8, "<?xml") === false) {
        } else {
            $ddc9bd810c3acdba = json_decode(json_encode(simplexml_load_string($B3dd6de7b6ec6ab8)), true);
            if(!isset($ddc9bd810c3acdba["driver_version"])) {
            } else {
                $C14fed47680a0e6b = array( "attached_gpus" => $ddc9bd810c3acdba["attached_gpus"], "driver_version" => $ddc9bd810c3acdba["driver_version"], "cuda_version" => $ddc9bd810c3acdba["cuda_version"], "gpus" => array(  ) );
                if(!isset($ddc9bd810c3acdba["gpu"]["board_id"])) {
                } else {
                    $ddc9bd810c3acdba["gpu"] = array( $ddc9bd810c3acdba["gpu"] );
                }

                foreach($ddc9bd810c3acdba["gpu"] as $cc552b85fa2347d9) {
                    $D2b5504b90a32341 = array( "name" => $cc552b85fa2347d9["product_name"], "power_readings" => $cc552b85fa2347d9["power_readings"], "utilisation" => $cc552b85fa2347d9["utilization"], "memory_usage" => $cc552b85fa2347d9["fb_memory_usage"], "fan_speed" => $cc552b85fa2347d9["fan_speed"], "temperature" => $cc552b85fa2347d9["temperature"], "clocks" => $cc552b85fa2347d9["clocks"], "uuid" => $cc552b85fa2347d9["uuid"], "id" => intval($cc552b85fa2347d9["pci"]["pci_device"]), "processes" => array(  ) );
                    foreach($cc552b85fa2347d9["processes"]["process_info"] as $c1ee87fab767ddf8) {
                        $D2b5504b90a32341["processes"][] = array( "pid" => intval($c1ee87fab767ddf8["pid"]), "memory" => $c1ee87fab767ddf8["used_memory"] );
                    }
                    $C14fed47680a0e6b["gpus"][] = $D2b5504b90a32341;
                }
                return $C14fed47680a0e6b;
            }

        }

        return array(  );
    }

    public static function b970DE2baDCa8a55($D2b5504b90a32341, $A6236b8f3b6a4fa6, $fff0f0d8088c1ce3)
    {
        $Cba70d6d90f5ab9b = array(  );
        self::bd780C608DC201f8($D2b5504b90a32341, $A6236b8f3b6a4fa6, $fff0f0d8088c1ce3, $Cba70d6d90f5ab9b);
        return $Cba70d6d90f5ab9b;
    }

    public static function BD780c608dc201F8($D2b5504b90a32341, $A6236b8f3b6a4fa6, $fff0f0d8088c1ce3, &$Cba70d6d90f5ab9b)
    {
        if(is_array($D2b5504b90a32341)) {
            if(!(isset($D2b5504b90a32341[$A6236b8f3b6a4fa6]) && $D2b5504b90a32341[$A6236b8f3b6a4fa6] == $fff0f0d8088c1ce3)) {
            } else {
                $Cba70d6d90f5ab9b[] = $D2b5504b90a32341;
            }

            foreach($D2b5504b90a32341 as $B4fee15183d97484) {
                self::bd780c608DC201f8($B4fee15183d97484, $A6236b8f3b6a4fa6, $fff0f0d8088c1ce3, $Cba70d6d90f5ab9b);
            }
        } else {
            return null;
        }

    }

    public static function Fdf0e07eF7646ED9($ef05f681c33d575c, $ba0e000b3ce55b83 = 1800)
    {
        if(!file_exists($ef05f681c33d575c)) {
        } else {
            $C9bc783135eb4c9a = trim(file_get_contents($ef05f681c33d575c));
            if(!file_exists("/proc/" . $C9bc783135eb4c9a)) {
            } else {
                if(time() - filemtime($ef05f681c33d575c) >= $ba0e000b3ce55b83) {
                    if(!(is_numeric($C9bc783135eb4c9a) && 0 < $C9bc783135eb4c9a)) {
                    } else {
                        posix_kill($C9bc783135eb4c9a, 9);
                    }

                } else {
                    exit("Running...");
                }

            }

        }

        file_put_contents($ef05f681c33d575c, getmypid());
        return false;
    }

    public static function Bcaec70b1bf6b984($f948824c538b45fa = null)
    {
        if(self::$rSettings["flood_limit"] != 0) {
            if($f948824c538b45fa) {
            } else {
                $f948824c538b45fa = self::e5Fae7E1F73587E9();
            }

            if(!(empty($f948824c538b45fa) || in_array($f948824c538b45fa, self::$rAllowedIPs))) {
                $c60c280543a58d19 = array_filter(array_unique(explode(",", self::$rSettings["flood_ips_exclude"])));
                if(!in_array($f948824c538b45fa, $c60c280543a58d19)) {
                    $Ce923b7d0fdd3031 = FLOOD_TMP_PATH . $f948824c538b45fa;
                    if(file_exists($Ce923b7d0fdd3031)) {
                        $B04f310379ef63c4 = json_decode(file_get_contents($Ce923b7d0fdd3031), true);
                        $c10534e6def8bc1b = self::$rSettings["flood_seconds"];
                        $ae5173988fdc4f17 = self::$rSettings["flood_limit"];
                        if(time() - $B04f310379ef63c4["last_request"] <= $c10534e6def8bc1b) {
                            $B04f310379ef63c4["requests"]++;
                            if($ae5173988fdc4f17 > $B04f310379ef63c4["requests"]) {
                                $B04f310379ef63c4["last_request"] = time();
                                file_put_contents($Ce923b7d0fdd3031, json_encode($B04f310379ef63c4), LOCK_EX);
                            } else {
                                if(in_array($f948824c538b45fa, self::$rBlockedIPs)) {
                                } else {
                                    self::$db->query("INSERT INTO `blocked_ips` (`ip`,`notes`,`date`) VALUES(?,?,?)", $f948824c538b45fa, "FLOOD ATTACK", time());
                                    self::$rBlockedIPs = self::C71682CE1c489336();
                                }

                                touch(FLOOD_TMP_PATH . "block_" . $f948824c538b45fa);
                                unlink($Ce923b7d0fdd3031);
                                return null;
                            }

                        } else {
                            $B04f310379ef63c4["requests"] = 0;
                            $B04f310379ef63c4["last_request"] = time();
                            file_put_contents($Ce923b7d0fdd3031, json_encode($B04f310379ef63c4), LOCK_EX);
                        }

                    } else {
                        file_put_contents($Ce923b7d0fdd3031, json_encode(array( "requests" => 0, "last_request" => time() )), LOCK_EX);
                    }

                } else {
                    return null;
                }

            } else {
                return null;
            }

        } else {
            return null;
        }

    }

    public static function f1c9Fe84BE079352($f948824c538b45fa = null, $e6f94ebbdd60ec68 = null, $acbe824e2ac9c0ee = null)
    {
        if($e6f94ebbdd60ec68 || $acbe824e2ac9c0ee) {
            if(!($e6f94ebbdd60ec68 && self::$rSettings["bruteforce_mac_attempts"] == 0)) {
                if(!($acbe824e2ac9c0ee && self::$rSettings["bruteforce_username_attempts"] == 0)) {
                    if($f948824c538b45fa) {
                    } else {
                        $f948824c538b45fa = self::e5FAe7E1f73587E9();
                    }

                    if(!(empty($f948824c538b45fa) || in_array($f948824c538b45fa, self::$rAllowedIPs))) {
                        $c60c280543a58d19 = array_filter(array_unique(explode(",", self::$rSettings["flood_ips_exclude"])));
                        if(!in_array($f948824c538b45fa, $c60c280543a58d19)) {
                            $D1865f605e68bcb8 = (!is_null($e6f94ebbdd60ec68) ? "mac" : "user");
                            $d361ac4ee74f3e85 = (!is_null($e6f94ebbdd60ec68) ? $e6f94ebbdd60ec68 : $acbe824e2ac9c0ee);
                            $Ce923b7d0fdd3031 = FLOOD_TMP_PATH . $f948824c538b45fa . "_" . $D1865f605e68bcb8;
                            if(file_exists($Ce923b7d0fdd3031)) {
                                $B04f310379ef63c4 = json_decode(file_get_contents($Ce923b7d0fdd3031), true);
                                $c10534e6def8bc1b = intval(self::$rSettings["bruteforce_frequency"]);
                                $ae5173988fdc4f17 = intval(self::$rSettings[["mac" => "bruteforce_mac_attempts", "user" => "bruteforce_username_attempts"][$D1865f605e68bcb8]]);
                                $B04f310379ef63c4["attempts"] = self::Ebe4bF8d5981f479($B04f310379ef63c4["attempts"], $c10534e6def8bc1b);
                                if(in_array($d361ac4ee74f3e85, array_keys($B04f310379ef63c4["attempts"]))) {
                                } else {
                                    $B04f310379ef63c4["attempts"][$d361ac4ee74f3e85] = time();
                                    if($ae5173988fdc4f17 > count($B04f310379ef63c4["attempts"])) {
                                        file_put_contents($Ce923b7d0fdd3031, json_encode($B04f310379ef63c4), LOCK_EX);
                                    } else {
                                        self::$db->query("INSERT INTO `blocked_ips` (`ip`,`notes`,`date`) VALUES(?,?,?)", $f948824c538b45fa, "BRUTEFORCE " . strtoupper($D1865f605e68bcb8) . " ATTACK", time());
                                        touch(FLOOD_TMP_PATH . "block_" . $f948824c538b45fa);
                                        unlink($Ce923b7d0fdd3031);
                                        return null;
                                    }

                                }

                            } else {
                                $B04f310379ef63c4 = array( "attempts" => array( $d361ac4ee74f3e85 => time() ) );
                                file_put_contents($Ce923b7d0fdd3031, json_encode($B04f310379ef63c4), LOCK_EX);
                            }

                        } else {
                            return null;
                        }

                    } else {
                        return null;
                    }

                } else {
                    return null;
                }

            } else {
                return null;
            }

        } else {
            return null;
        }

    }

    public static function EbE4BF8d5981F479($ba0edd92bb7be891, $D47aeaa327781663, $F2b28dd0e1bcb1b5 = false)
    {
        $Fae9163c8f70d180 = array(  );
        $ba0e000b3ce55b83 = time();
        if($F2b28dd0e1bcb1b5) {
            foreach($ba0edd92bb7be891 as $Cfb51f70d2945f0b) {
                if($ba0e000b3ce55b83 - $Cfb51f70d2945f0b > $D47aeaa327781663) {
                } else {
                    $Fae9163c8f70d180[] = $Cfb51f70d2945f0b;
                }

            }
        } else {
            foreach($ba0edd92bb7be891 as $fdf877e8e1cb2b02 => $Cfb51f70d2945f0b) {
                if($ba0e000b3ce55b83 - $Cfb51f70d2945f0b > $D47aeaa327781663) {
                } else {
                    $Fae9163c8f70d180[$fdf877e8e1cb2b02] = $Cfb51f70d2945f0b;
                }

            }
        }

        return $Fae9163c8f70d180;
    }

    public static function Ad755BE4EFEBa2f2()
    {
        $C8d15e5d6ee6a1a7 = 0;
        exec("ps -Ao pid,pcpu", $df7bbd500295176c);
        foreach($df7bbd500295176c as $F541f7fc1c7c2ff3) {
            $B581e650ea1fa7ab = explode(" ", preg_replace("!\\s+!", " ", trim($F541f7fc1c7c2ff3)));
            $C8d15e5d6ee6a1a7 += floatval($B581e650ea1fa7ab[1]);
        }
        return $C8d15e5d6ee6a1a7 / intval(shell_exec("grep -P '^processor' /proc/cpuinfo|wc -l"));
    }

    public static function E117150ACFf7C7d6($b3b256939cb18212 = null, $Ccab564379a6ea90 = false)
    {
        if(is_string($b3b256939cb18212)) {
            self::$db->query("SELECT t1.* FROM `streams_categories` t1 WHERE t1.category_type = ? GROUP BY t1.id ORDER BY t1.cat_order ASC", $b3b256939cb18212);
            return (0 < self::$db->num_rows() ? self::$db->get_rows(true, "id") : array(  ));
        }

        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8E8A18b5BfFAAc0("categories", 20);
            if(empty($A1a1fb89e05ece47)) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        self::$db->query("SELECT t1.* FROM `streams_categories` t1 ORDER BY t1.cat_order ASC");
        $A9e6fe0d86f7f7f1 = (0 < self::$db->num_rows() ? self::$db->get_rows(true, "id") : array(  ));
        self::F57D63497771D13E("categories", $A9e6fe0d86f7f7f1);
        return $A9e6fe0d86f7f7f1;
    }

    public static function B347c1f8DEAd67e0()
    {
        return substr(md5(self::$rSettings["live_streaming_pass"]), 0, 15);
    }

    public static function c46b177a61dbBDD6($d7fc8e8f38c4af97)
    {
        $F0e839083d6bad06 = array(  );
        $a00c3f35d74bbd03 = 0;
        while($a00c3f35d74bbd03 < strlen($d7fc8e8f38c4af97)) {
            if(strstr(substr($d7fc8e8f38c4af97, $a00c3f35d74bbd03), "|")) {
                $B60c2bd29485749f = strpos($d7fc8e8f38c4af97, "|", $a00c3f35d74bbd03);
                $b53ed24d2937bc7c = $B60c2bd29485749f - $a00c3f35d74bbd03;
                $A262a428ad3ec00b = substr($d7fc8e8f38c4af97, $a00c3f35d74bbd03, $b53ed24d2937bc7c);
                $a00c3f35d74bbd03 += $b53ed24d2937bc7c + 1;
                $C9340e84b67c26bc = igbinary_unserialize(substr($d7fc8e8f38c4af97, $a00c3f35d74bbd03));
                $F0e839083d6bad06[$A262a428ad3ec00b] = $C9340e84b67c26bc;
                $a00c3f35d74bbd03 += strlen(igbinary_serialize($C9340e84b67c26bc));
            } else {
                return array(  );
            }

        }
        return $F0e839083d6bad06;
    }

    public static function f4CFAf02984127fF($Fa6244f1eb01dd64, $F60190803094c363, $Aebf90d693118138 = "ts", $a424608985fbfb08 = null, $a2b3ccf47281a27a = false, $bba4824306df4e1f = false)
    {
        if(!empty($F60190803094c363)) {
            if($Aebf90d693118138 != "mpegts") {
            } else {
                $Aebf90d693118138 = "ts";
            }

            if($Aebf90d693118138 != "hls") {
            } else {
                $Aebf90d693118138 = "m3u8";
            }

            if(empty($Aebf90d693118138)) {
                self::$db->query("SELECT t1.output_ext FROM `output_formats` t1 INNER JOIN `output_devices` t2 ON t2.default_output = t1.access_output_id AND `device_key` = ?", $F60190803094c363);
            } else {
                self::$db->query("SELECT t1.output_ext FROM `output_formats` t1 WHERE `output_key` = ?", $Aebf90d693118138);
            }

            if(self::$db->num_rows() > 0) {
                $Ce582801323c962b = $Fa6244f1eb01dd64["id"] . "_" . $F60190803094c363 . "_" . $Aebf90d693118138 . "_" . implode("_", ($a424608985fbfb08 ?: array(  )));
                $A3686f871d75917b = self::$db->get_col();
                $fd9b24bc089fff80 = ($Fa6244f1eb01dd64["is_restreamer"] ? self::$rSettings["encrypt_playlist_restreamer"] : self::$rSettings["encrypt_playlist"]);
                if(!$Fa6244f1eb01dd64["is_stalker"]) {
                } else {
                    $fd9b24bc089fff80 = false;
                }

                $c3c1da44b0098211 = self::EB628ac1fd062456();
                if($c3c1da44b0098211) {
                    if(!$bba4824306df4e1f) {
                        $B2c945a6d734f301 = array(  );
                        if($Aebf90d693118138 != "rtmp") {
                        } else {
                            self::$db->query("SELECT t1.id,t2.server_id FROM `streams` t1 INNER JOIN `streams_servers` t2 ON t2.stream_id = t1.id WHERE t1.rtmp_output = 1");
                            $B2c945a6d734f301 = self::$db->get_rows(true, "id", false, "server_id");
                        }

                    } else {
                        if($Aebf90d693118138 != "rtmp") {
                        } else {
                            $Aebf90d693118138 = "ts";
                        }

                    }

                    if(!empty($A3686f871d75917b)) {
                    } else {
                        $A3686f871d75917b = "ts";
                    }

                    self::$db->query("SELECT t1.*,t2.* FROM `output_devices` t1 LEFT JOIN `output_formats` t2 ON t2.access_output_id = t1.default_output WHERE t1.device_key = ? LIMIT 1", $F60190803094c363);
                    if(0 >= self::$db->num_rows()) {
                        return false;
                    }

                    $Aa41bca410057b67 = self::$db->get_row();
                    if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                        $ef05f681c33d575c = str_replace("{USERNAME}", $Fa6244f1eb01dd64["access_token"], $Aa41bca410057b67["device_filename"]);
                    } else {
                        $ef05f681c33d575c = str_replace("{USERNAME}", $Fa6244f1eb01dd64["username"], $Aa41bca410057b67["device_filename"]);
                    }

                    if(!(0 < self::$rSettings["cache_playlists"] && !$a2b3ccf47281a27a && file_exists(PLAYLIST_PATH . md5($Ce582801323c962b)))) {
                        $C9340e84b67c26bc = "";
                        $Be139e9c40df24a9 = $f61d039b7f1a78fb = $f06a26a5bb951504 = array(  );
                        $Fa6244f1eb01dd64["episode_ids"] = array(  );
                        if(0 >= count($Fa6244f1eb01dd64["series_ids"])) {
                        } else {
                            if(self::$rCached) {
                                foreach($Fa6244f1eb01dd64["series_ids"] as $B23a102201b6cf2a) {
                                    $f06a26a5bb951504[$B23a102201b6cf2a] = igbinary_unserialize(file_get_contents(SERIES_TMP_PATH . "series_" . intval($B23a102201b6cf2a)));
                                    $e48c8d12f2fb60d2 = igbinary_unserialize(file_get_contents(SERIES_TMP_PATH . "episodes_" . intval($B23a102201b6cf2a)));
                                    foreach($e48c8d12f2fb60d2 as $c90f1d01f9b19870 => $eea2d390b2c133f2) {
                                        foreach($eea2d390b2c133f2 as $f003b451da3daa0e) {
                                            $f61d039b7f1a78fb[$f003b451da3daa0e["stream_id"]] = array( $c90f1d01f9b19870, $f003b451da3daa0e["episode_num"] );
                                            $Be139e9c40df24a9[$f003b451da3daa0e["stream_id"]] = $B23a102201b6cf2a;
                                            $Fa6244f1eb01dd64["episode_ids"][] = $f003b451da3daa0e["stream_id"];
                                        }
                                    }
                                }
                            } else {
                                self::$db->query("SELECT * FROM `streams_series` WHERE `id` IN (" . implode(",", $Fa6244f1eb01dd64["series_ids"]) . ")");
                                $f06a26a5bb951504 = self::$db->get_rows(true, "id");
                                if(0 >= count($Fa6244f1eb01dd64["series_ids"])) {
                                } else {
                                    self::$db->query("SELECT stream_id, series_id, season_num, episode_num FROM `streams_episodes` WHERE series_id IN (" . implode(",", $Fa6244f1eb01dd64["series_ids"]) . ") ORDER BY FIELD(series_id," . implode(",", $Fa6244f1eb01dd64["series_ids"]) . "), season_num ASC, episode_num ASC");
                                    foreach(self::$db->get_rows(true, "series_id", false) as $B23a102201b6cf2a => $eea2d390b2c133f2) {
                                        foreach($eea2d390b2c133f2 as $f003b451da3daa0e) {
                                            $f61d039b7f1a78fb[$f003b451da3daa0e["stream_id"]] = array( $f003b451da3daa0e["season_num"], $f003b451da3daa0e["episode_num"] );
                                            $Be139e9c40df24a9[$f003b451da3daa0e["stream_id"]] = $B23a102201b6cf2a;
                                            $Fa6244f1eb01dd64["episode_ids"][] = $f003b451da3daa0e["stream_id"];
                                        }
                                    }
                                }

                            }

                        }

                        if(0 >= count($Fa6244f1eb01dd64["episode_ids"])) {
                        } else {
                            $Fa6244f1eb01dd64["channel_ids"] = array_merge($Fa6244f1eb01dd64["channel_ids"], $Fa6244f1eb01dd64["episode_ids"]);
                        }

                        $Cfe1fe762b64b1c9 = array(  );
                        $fdd40afb969bad71 = false;
                        if($a424608985fbfb08) {
                            foreach($a424608985fbfb08 as $b3b256939cb18212) {
                                switch($b3b256939cb18212) {
                                    case "live":
                                    case "created_live":
                                        if(!$fdd40afb969bad71) {
                                            $Cfe1fe762b64b1c9 = array_merge($Cfe1fe762b64b1c9, $Fa6244f1eb01dd64["live_ids"]);
                                            $fdd40afb969bad71 = true;
                                            break;
                                        }

                                        break;
                                    case "movie":
                                        $Cfe1fe762b64b1c9 = array_merge($Cfe1fe762b64b1c9, $Fa6244f1eb01dd64["vod_ids"]);
                                        break;
                                    case "radio_streams":
                                        $Cfe1fe762b64b1c9 = array_merge($Cfe1fe762b64b1c9, $Fa6244f1eb01dd64["radio_ids"]);
                                        break;
                                    case "series":
                                        $Cfe1fe762b64b1c9 = array_merge($Cfe1fe762b64b1c9, $Fa6244f1eb01dd64["episode_ids"]);
                                        break;
                                }
                            }
                        } else {
                            $Cfe1fe762b64b1c9 = $Fa6244f1eb01dd64["channel_ids"];
                        }

                        if(!in_array(self::$rSettings["channel_number_type"], array( "bouquet_new", "manual" ))) {
                        } else {
                            $Cfe1fe762b64b1c9 = self::dCa780D586619068($Cfe1fe762b64b1c9);
                        }

                        unset($Fa6244f1eb01dd64["live_ids"]);
                        unset($Fa6244f1eb01dd64["vod_ids"]);
                        unset($Fa6244f1eb01dd64["radio_ids"]);
                        unset($Fa6244f1eb01dd64["episode_ids"]);
                        unset($Fa6244f1eb01dd64["channel_ids"]);
                        $c5996e9663fbe65e = null;
                        header("Content-Description: File Transfer");
                        header("Content-Type: application/octet-stream");
                        header("Expires: 0");
                        header("Cache-Control: must-revalidate");
                        header("Pragma: public");
                        if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                            header("Content-Disposition: attachment; filename=\"" . str_replace("{USERNAME}", $Fa6244f1eb01dd64["access_token"], $Aa41bca410057b67["device_filename"]) . "\"");
                        } else {
                            header("Content-Disposition: attachment; filename=\"" . str_replace("{USERNAME}", $Fa6244f1eb01dd64["username"], $Aa41bca410057b67["device_filename"]) . "\"");
                        }

                        if(0 >= self::$rSettings["cache_playlists"]) {
                        } else {
                            $d85e3b3d07e9aa96 = PLAYLIST_PATH . md5($Ce582801323c962b) . ".write";
                            $c5996e9663fbe65e = fopen($d85e3b3d07e9aa96, "w");
                        }

                        if($F60190803094c363 == "starlivev5") {
                            $B3dd6de7b6ec6ab8 = array(  );
                            $B3dd6de7b6ec6ab8["iptvstreams_list"] = array(  );
                            $B3dd6de7b6ec6ab8["iptvstreams_list"]["@version"] = 1;
                            $B3dd6de7b6ec6ab8["iptvstreams_list"]["group"] = array(  );
                            $B3dd6de7b6ec6ab8["iptvstreams_list"]["group"]["name"] = "IPTV";
                            $B3dd6de7b6ec6ab8["iptvstreams_list"]["group"]["channel"] = array(  );
                            foreach(array_chunk($Cfe1fe762b64b1c9, 1000) as $F47abf765a227a00) {
                                if(self::$rSettings["playlist_from_mysql"] || !self::$rCached) {
                                    $Df166a11586c1244 = "FIELD(`t1`.`id`," . implode(",", $F47abf765a227a00) . ")";
                                    self::$db->query("SELECT t1.id,t1.channel_id,t1.year,t1.movie_properties,t1.stream_icon,t1.custom_sid,t1.category_id,t1.stream_display_name,t2.type_output,t2.type_key,t1.target_container,t2.live FROM `streams` t1 INNER JOIN `streams_types` t2 ON t2.type_id = t1.type WHERE `t1`.`id` IN (" . implode(",", array_map("intval", $F47abf765a227a00)) . ") ORDER BY " . $Df166a11586c1244 . ";");
                                    $Fdb08a8c6c6e3410 = self::$db->get_rows();
                                } else {
                                    $Fdb08a8c6c6e3410 = array(  );
                                    foreach($F47abf765a227a00 as $A76532e4f616ce0c) {
                                        $Fdb08a8c6c6e3410[] = igbinary_unserialize(file_get_contents(STREAMS_TMP_PATH . "stream_" . intval($A76532e4f616ce0c)))["info"];
                                    }
                                }

                                foreach($Fdb08a8c6c6e3410 as $A315b65e3e162b2f) {
                                    if(!$a424608985fbfb08 || in_array($A315b65e3e162b2f["type_output"], $a424608985fbfb08)) {
                                        if($A315b65e3e162b2f["target_container"]) {
                                        } else {
                                            $A315b65e3e162b2f["target_container"] = "mp4";
                                        }

                                        $E1fabe3ea4db7828 = (!is_array($A315b65e3e162b2f["movie_properties"]) ? json_decode($A315b65e3e162b2f["movie_properties"], true) : $A315b65e3e162b2f["movie_properties"]);
                                        if($A315b65e3e162b2f["type_key"] == "series") {
                                            $B23a102201b6cf2a = $Be139e9c40df24a9[$A315b65e3e162b2f["id"]];
                                            $A315b65e3e162b2f["live"] = 0;
                                            $A315b65e3e162b2f["stream_display_name"] = $f06a26a5bb951504[$B23a102201b6cf2a]["title"] . " S" . sprintf("%02d", $f61d039b7f1a78fb[$A315b65e3e162b2f["id"]][0]) . "E" . sprintf("%02d", $f61d039b7f1a78fb[$A315b65e3e162b2f["id"]][1]);
                                            $A315b65e3e162b2f["movie_properties"] = array( "movie_image" => (!empty($E1fabe3ea4db7828["movie_image"]) ? $E1fabe3ea4db7828["movie_image"] : $f06a26a5bb951504["cover"]) );
                                            $A315b65e3e162b2f["type_output"] = "series";
                                            $A315b65e3e162b2f["category_id"] = $f06a26a5bb951504[$B23a102201b6cf2a]["category_id"];
                                        } else {
                                            $A315b65e3e162b2f["stream_display_name"] = self::Db3B1De54Fcf2e58($A315b65e3e162b2f["stream_display_name"], $A315b65e3e162b2f["year"]);
                                        }

                                        if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                                            $C872016bcd6efd74 = $c3c1da44b0098211 . $A315b65e3e162b2f["type_output"] . "/" . $Fa6244f1eb01dd64["access_token"] . "/";
                                            if($A315b65e3e162b2f["live"] == 0) {
                                                $C872016bcd6efd74 .= $A315b65e3e162b2f["id"] . "." . $A315b65e3e162b2f["target_container"];
                                            } else {
                                                if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                    $C872016bcd6efd74 .= $A315b65e3e162b2f["id"];
                                                } else {
                                                    $C872016bcd6efd74 .= $A315b65e3e162b2f["id"] . "." . $A3686f871d75917b;
                                                }

                                            }

                                        } else {
                                            if($fd9b24bc089fff80) {
                                                $a1e7e290e7fbc441 = $A315b65e3e162b2f["type_output"] . "/" . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/";
                                                if($A315b65e3e162b2f["live"] == 0) {
                                                    $a1e7e290e7fbc441 .= $A315b65e3e162b2f["id"] . "/" . $A315b65e3e162b2f["target_container"];
                                                } else {
                                                    if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                        $a1e7e290e7fbc441 .= $A315b65e3e162b2f["id"];
                                                    } else {
                                                        $a1e7e290e7fbc441 .= $A315b65e3e162b2f["id"] . "/" . $A3686f871d75917b;
                                                    }

                                                }

                                                $fd6433a6c4ad29ac = Xui\Functions::encrypt($a1e7e290e7fbc441, self::$rSettings["live_streaming_pass"], OPENSSL_EXTRA);
                                                $C872016bcd6efd74 = $c3c1da44b0098211 . "play/" . $fd6433a6c4ad29ac;
                                                if($A315b65e3e162b2f["live"] != 0) {
                                                } else {
                                                    $C872016bcd6efd74 .= "#." . $A315b65e3e162b2f["target_container"];
                                                }

                                            } else {
                                                $C872016bcd6efd74 = $c3c1da44b0098211 . $A315b65e3e162b2f["type_output"] . "/" . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/";
                                                if($A315b65e3e162b2f["live"] == 0) {
                                                    $C872016bcd6efd74 .= $A315b65e3e162b2f["id"] . "." . $A315b65e3e162b2f["target_container"];
                                                } else {
                                                    if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                        $C872016bcd6efd74 .= $A315b65e3e162b2f["id"];
                                                    } else {
                                                        $C872016bcd6efd74 .= $A315b65e3e162b2f["id"] . "." . $A3686f871d75917b;
                                                    }

                                                }

                                            }

                                        }

                                        if($A315b65e3e162b2f["live"] == 0) {
                                            if(empty($E1fabe3ea4db7828["movie_image"])) {
                                            } else {
                                                $c6b0cf6e95d54220 = $E1fabe3ea4db7828["movie_image"];
                                            }

                                        } else {
                                            $c6b0cf6e95d54220 = $A315b65e3e162b2f["stream_icon"];
                                        }

                                        $Ae72bc7c3409fc14 = array(  );
                                        $Ae72bc7c3409fc14["name"] = $A315b65e3e162b2f["stream_display_name"];
                                        $Ae72bc7c3409fc14["icon"] = self::fee5178736BD8E11($c6b0cf6e95d54220);
                                        $Ae72bc7c3409fc14["stream_url"] = $C872016bcd6efd74;
                                        $Ae72bc7c3409fc14["stream_type"] = 0;
                                        $B3dd6de7b6ec6ab8["iptvstreams_list"]["group"]["channel"][] = $Ae72bc7c3409fc14;
                                    }

                                }
                                unset($Fdb08a8c6c6e3410);
                            }
                            $C9340e84b67c26bc = json_encode((object) $B3dd6de7b6ec6ab8);
                        } else {
                            if(empty($Aa41bca410057b67["device_header"])) {
                            } else {
                                $c2bca4da3b6ea0b7 = ($Aa41bca410057b67["device_header"] == "#EXTM3U" ? "\n" . "#EXT-X-SESSION-DATA:DATA-ID=\"com.xui." . str_replace(".", "_", XUI_VERSION) . ((XUI_REVISION ? "r" . XUI_REVISION : "")) . "\"" : "");
                                $C9340e84b67c26bc = str_replace(array( "&lt;", "&gt;" ), array( "<", ">" ), str_replace(array( "{BOUQUET_NAME}", "{USERNAME}", "{PASSWORD}", "{SERVER_URL}", "{OUTPUT_KEY}" ), array( self::$rSettings["server_name"], $Fa6244f1eb01dd64["username"], $Fa6244f1eb01dd64["password"], $c3c1da44b0098211, $Aebf90d693118138 ), $Aa41bca410057b67["device_header"] . $c2bca4da3b6ea0b7)) . "\n";
                                if(!$c5996e9663fbe65e) {
                                } else {
                                    fwrite($c5996e9663fbe65e, $C9340e84b67c26bc);
                                }

                                echo $C9340e84b67c26bc;
                                unset($C9340e84b67c26bc);
                            }

                            if(empty($Aa41bca410057b67["device_conf"])) {
                            } else {
                                if(preg_match("/\\{URL\\#(.*?)\\}/", $Aa41bca410057b67["device_conf"], $B450ac40aba9585c)) {
                                    $B450e34c7398f63f = str_split($B450ac40aba9585c[1]);
                                    $cb1ab16263efe52e = $B450ac40aba9585c[0];
                                } else {
                                    $B450e34c7398f63f = array(  );
                                    $cb1ab16263efe52e = "{URL}";
                                }

                                foreach(array_chunk($Cfe1fe762b64b1c9, 1000) as $F47abf765a227a00) {
                                    if(self::$rSettings["playlist_from_mysql"] || !self::$rCached) {
                                        $Df166a11586c1244 = "FIELD(`t1`.`id`," . implode(",", $F47abf765a227a00) . ")";
                                        self::$db->query("SELECT t1.id,t1.channel_id,t1.year,t1.movie_properties,t1.stream_icon,t1.custom_sid,t1.category_id,t1.stream_display_name,t2.type_output,t2.type_key,t1.target_container,t2.live,t1.tv_archive_duration,t1.tv_archive_server_id FROM `streams` t1 INNER JOIN `streams_types` t2 ON t2.type_id = t1.type WHERE `t1`.`id` IN (" . implode(",", array_map("intval", $F47abf765a227a00)) . ") ORDER BY " . $Df166a11586c1244 . ";");
                                        $Fdb08a8c6c6e3410 = self::$db->get_rows();
                                    } else {
                                        $Fdb08a8c6c6e3410 = array(  );
                                        foreach($F47abf765a227a00 as $A76532e4f616ce0c) {
                                            $Fdb08a8c6c6e3410[] = igbinary_unserialize(file_get_contents(STREAMS_TMP_PATH . "stream_" . intval($A76532e4f616ce0c)))["info"];
                                        }
                                    }

                                    foreach($Fdb08a8c6c6e3410 as $Ae72bc7c3409fc14) {
                                        if($a424608985fbfb08 && !in_array($Ae72bc7c3409fc14["type_output"], $a424608985fbfb08)) {
                                        } else {
                                            if($Ae72bc7c3409fc14["target_container"]) {
                                            } else {
                                                $Ae72bc7c3409fc14["target_container"] = "mp4";
                                            }

                                            $B4be4a8f577f2584 = $Aa41bca410057b67["device_conf"];
                                            if($Aa41bca410057b67["device_key"] != "m3u_plus") {
                                            } else {
                                                if($Ae72bc7c3409fc14["live"]) {
                                                } else {
                                                    $B4be4a8f577f2584 = str_replace("tvg-id=\"{CHANNEL_ID}\" ", "", $B4be4a8f577f2584);
                                                }

                                                if($fd9b24bc089fff80) {
                                                } else {
                                                    $B4be4a8f577f2584 = str_replace("xui-id=\"{XUI_ID}\" ", "", $B4be4a8f577f2584);
                                                }

                                                if(!(0 < $Ae72bc7c3409fc14["tv_archive_server_id"] && 0 < $Ae72bc7c3409fc14["tv_archive_duration"])) {
                                                } else {
                                                    $B4be4a8f577f2584 = str_replace("#EXTINF:-1 ", "#EXTINF:-1 timeshift=\"" . intval($Ae72bc7c3409fc14["tv_archive_duration"]) . "\" ", $B4be4a8f577f2584);
                                                }

                                            }

                                            $E1fabe3ea4db7828 = (!is_array($Ae72bc7c3409fc14["movie_properties"]) ? json_decode($Ae72bc7c3409fc14["movie_properties"], true) : $Ae72bc7c3409fc14["movie_properties"]);
                                            if($Ae72bc7c3409fc14["type_key"] == "series") {
                                                $B23a102201b6cf2a = $Be139e9c40df24a9[$Ae72bc7c3409fc14["id"]];
                                                $Ae72bc7c3409fc14["live"] = 0;
                                                $Ae72bc7c3409fc14["stream_display_name"] = $f06a26a5bb951504[$B23a102201b6cf2a]["title"] . " S" . sprintf("%02d", $f61d039b7f1a78fb[$Ae72bc7c3409fc14["id"]][0]) . "E" . sprintf("%02d", $f61d039b7f1a78fb[$Ae72bc7c3409fc14["id"]][1]);
                                                $Ae72bc7c3409fc14["movie_properties"] = array( "movie_image" => (!empty($E1fabe3ea4db7828["movie_image"]) ? $E1fabe3ea4db7828["movie_image"] : $f06a26a5bb951504["cover"]) );
                                                $Ae72bc7c3409fc14["type_output"] = "series";
                                                $Ae72bc7c3409fc14["category_id"] = $f06a26a5bb951504[$B23a102201b6cf2a]["category_id"];
                                            } else {
                                                $Ae72bc7c3409fc14["stream_display_name"] = self::db3b1DE54Fcf2E58($Ae72bc7c3409fc14["stream_display_name"], $Ae72bc7c3409fc14["year"]);
                                            }

                                            if($Ae72bc7c3409fc14["live"] == 0) {
                                                if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                                                    $C872016bcd6efd74 = $c3c1da44b0098211 . $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["access_token"] . "/" . $Ae72bc7c3409fc14["id"] . "." . $Ae72bc7c3409fc14["target_container"];
                                                } else {
                                                    if($fd9b24bc089fff80) {
                                                        $a1e7e290e7fbc441 = $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/" . $Ae72bc7c3409fc14["id"] . "/" . $Ae72bc7c3409fc14["target_container"];
                                                        $fd6433a6c4ad29ac = Xui\Functions::encrypt($a1e7e290e7fbc441, self::$rSettings["live_streaming_pass"], OPENSSL_EXTRA);
                                                        $C872016bcd6efd74 = $c3c1da44b0098211 . "play/" . $fd6433a6c4ad29ac . "#." . $Ae72bc7c3409fc14["target_container"];
                                                    } else {
                                                        $C872016bcd6efd74 = $c3c1da44b0098211 . $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/" . $Ae72bc7c3409fc14["id"] . "." . $Ae72bc7c3409fc14["target_container"];
                                                    }

                                                }

                                                if(empty($E1fabe3ea4db7828["movie_image"])) {
                                                } else {
                                                    $c6b0cf6e95d54220 = $E1fabe3ea4db7828["movie_image"];
                                                }

                                            } else {
                                                if($Aebf90d693118138 != "rtmp" || !array_key_exists($Ae72bc7c3409fc14["id"], $B2c945a6d734f301)) {
                                                    if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                                                        if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                            $C872016bcd6efd74 = $c3c1da44b0098211 . $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["access_token"] . "/" . $Ae72bc7c3409fc14["id"];
                                                        } else {
                                                            $C872016bcd6efd74 = $c3c1da44b0098211 . $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["access_token"] . "/" . $Ae72bc7c3409fc14["id"] . "." . $A3686f871d75917b;
                                                        }

                                                    } else {
                                                        if($fd9b24bc089fff80) {
                                                            $a1e7e290e7fbc441 = $Ae72bc7c3409fc14["type_output"] . "/" . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/" . $Ae72bc7c3409fc14["id"];
                                                            $fd6433a6c4ad29ac = Xui\Functions::encrypt($a1e7e290e7fbc441, self::$rSettings["live_streaming_pass"], OPENSSL_EXTRA);
                                                            if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                                $C872016bcd6efd74 = $c3c1da44b0098211 . "play/" . $fd6433a6c4ad29ac;
                                                            } else {
                                                                $C872016bcd6efd74 = $c3c1da44b0098211 . "play/" . $fd6433a6c4ad29ac . "/" . $A3686f871d75917b;
                                                            }

                                                        } else {
                                                            if(self::$rSettings["cloudflare"] && $A3686f871d75917b == "ts") {
                                                                $C872016bcd6efd74 = $c3c1da44b0098211 . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/" . $Ae72bc7c3409fc14["id"];
                                                            } else {
                                                                $C872016bcd6efd74 = $c3c1da44b0098211 . $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"] . "/" . $Ae72bc7c3409fc14["id"] . "." . $A3686f871d75917b;
                                                            }

                                                        }

                                                    }

                                                } else {
                                                    $C1217050a9dd86bf = array_values(array_keys($B2c945a6d734f301[$Ae72bc7c3409fc14["id"]]));
                                                    if(in_array($Fa6244f1eb01dd64["force_server_id"], $C1217050a9dd86bf)) {
                                                        $Febabbe2c8824ef7 = $Fa6244f1eb01dd64["force_server_id"];
                                                    } else {
                                                        if(self::$rSettings["rtmp_random"] == 1) {
                                                            $Febabbe2c8824ef7 = $C1217050a9dd86bf[array_rand($C1217050a9dd86bf, 1)];
                                                        } else {
                                                            $Febabbe2c8824ef7 = $C1217050a9dd86bf[0];
                                                        }

                                                    }

                                                    if(strlen($Fa6244f1eb01dd64["access_token"]) == 32) {
                                                        $C872016bcd6efd74 = self::$rServers[$Febabbe2c8824ef7]["rtmp_server"] . $Ae72bc7c3409fc14["id"] . "?token=" . $Fa6244f1eb01dd64["access_token"];
                                                    } else {
                                                        if($fd9b24bc089fff80) {
                                                            $a1e7e290e7fbc441 = $Fa6244f1eb01dd64["username"] . "/" . $Fa6244f1eb01dd64["password"];
                                                            $fd6433a6c4ad29ac = Xui\Functions::encrypt($a1e7e290e7fbc441, self::$rSettings["live_streaming_pass"], OPENSSL_EXTRA);
                                                            $C872016bcd6efd74 = self::$rServers[$Febabbe2c8824ef7]["rtmp_server"] . $Ae72bc7c3409fc14["id"] . "?token=" . $fd6433a6c4ad29ac;
                                                        } else {
                                                            $C872016bcd6efd74 = self::$rServers[$Febabbe2c8824ef7]["rtmp_server"] . $Ae72bc7c3409fc14["id"] . "?username=" . $Fa6244f1eb01dd64["username"] . "&password=" . $Fa6244f1eb01dd64["password"];
                                                        }

                                                    }

                                                }

                                                $c6b0cf6e95d54220 = $Ae72bc7c3409fc14["stream_icon"];
                                            }

                                            $e22df129608c00e2 = ($Ae72bc7c3409fc14["live"] == 1 ? 1 : 4097);
                                            $B5ccae4b329390ad = (!empty($Ae72bc7c3409fc14["custom_sid"]) ? $Ae72bc7c3409fc14["custom_sid"] : ":0:1:0:0:0:0:0:0:0:");
                                            $d5b4b70ea0a4facc = json_decode($Ae72bc7c3409fc14["category_id"], true);
                                            foreach($d5b4b70ea0a4facc as $Ba22d9bda24c2f34) {
                                                if(!isset(self::$rCategories[$Ba22d9bda24c2f34])) {
                                                } else {
                                                    $C9340e84b67c26bc = str_replace(array( "&lt;", "&gt;" ), array( "<", ">" ), str_replace(array( $cb1ab16263efe52e, "{ESR_ID}", "{SID}", "{CHANNEL_NAME}", "{CHANNEL_ID}", "{XUI_ID}", "{CATEGORY}", "{CHANNEL_ICON}" ), array( str_replace($B450e34c7398f63f, array_map("urlencode", $B450e34c7398f63f), $C872016bcd6efd74), $e22df129608c00e2, $B5ccae4b329390ad, $Ae72bc7c3409fc14["stream_display_name"], $Ae72bc7c3409fc14["channel_id"], $Ae72bc7c3409fc14["id"], self::$rCategories[$Ba22d9bda24c2f34]["category_name"], self::fEE5178736Bd8E11($c6b0cf6e95d54220) ), $B4be4a8f577f2584)) . "\r\n";
                                                    if(!$c5996e9663fbe65e) {
                                                    } else {
                                                        fwrite($c5996e9663fbe65e, $C9340e84b67c26bc);
                                                    }

                                                    echo $C9340e84b67c26bc;
                                                    unset($C9340e84b67c26bc);
                                                    if(stripos($Aa41bca410057b67["device_conf"], "{CATEGORY}") !== false) {
                                                    } else {
                                                        break;
                                                    }

                                                }

                                            }
                                        }

                                    }
                                    unset($Fdb08a8c6c6e3410);
                                }
                                $C9340e84b67c26bc = trim(str_replace(array( "&lt;", "&gt;" ), array( "<", ">" ), $Aa41bca410057b67["device_footer"]));
                                if(!$c5996e9663fbe65e) {
                                } else {
                                    fwrite($c5996e9663fbe65e, $C9340e84b67c26bc);
                                }

                                echo $C9340e84b67c26bc;
                                unset($C9340e84b67c26bc);
                            }

                        }

                        if(!$c5996e9663fbe65e) {
                        } else {
                            fclose($c5996e9663fbe65e);
                            rename(PLAYLIST_PATH . md5($Ce582801323c962b) . ".write", PLAYLIST_PATH . md5($Ce582801323c962b));
                        }

                        exit();
                    } else {
                        header("Content-Description: File Transfer");
                        header("Content-Type: audio/mpegurl");
                        header("Expires: 0");
                        header("Cache-Control: must-revalidate");
                        header("Pragma: public");
                        header("Content-Disposition: attachment; filename=\"" . $ef05f681c33d575c . "\"");
                        header("Content-Length: " . filesize(PLAYLIST_PATH . md5($Ce582801323c962b)));
                        readfile(PLAYLIST_PATH . md5($Ce582801323c962b));
                        exit();
                    }

                } else {
                    exit();
                }

            } else {
                return false;
            }

        } else {
            return false;
        }

    }

    public static function e80449d3BB723838()
    {
        if(!file_exists(TMP_PATH . "crontab")) {
            $d47a08e723749bb6 = array(  );
            self::$db->query("SELECT * FROM `crontab` WHERE `enabled` = 1;");
            foreach(self::$db->get_rows() as $e6002db131ca9d50) {
                $a60e992fd36d6c13 = CRON_PATH . $e6002db131ca9d50["filename"];
                if(!(pathinfo($a60e992fd36d6c13, PATHINFO_EXTENSION) == "php" && file_exists($a60e992fd36d6c13))) {
                } else {
                    $d47a08e723749bb6[] = $e6002db131ca9d50["time"] . " " . PHP_BIN . " " . $a60e992fd36d6c13 . " # XUI";
                }

            }
            shell_exec("crontab -r");
            $d65c1cbbaf0318b6 = tempnam("/tmp", "crontab");
            $D9f5b5efd31dac51 = fopen($d65c1cbbaf0318b6, "w");
            fwrite($D9f5b5efd31dac51, implode("\n", $d47a08e723749bb6) . "\n");
            fclose($D9f5b5efd31dac51);
            shell_exec("crontab -u xui " . $d65c1cbbaf0318b6);
            @unlink($d65c1cbbaf0318b6);
            file_put_contents(TMP_PATH . "crontab", 1);
            return true;
        } else {
            return false;
        }

    }

    public static function C35B0c1EA821c567()
    {
        if(!(file_exists("/proc/uptime") && is_readable("/proc/uptime"))) {
            return "";
        }

        $B301f490721ab11b = explode(" ", file_get_contents("/proc/uptime"));
        return self::b591Cb4c525399F2(intval($B301f490721ab11b[0]));
    }

    public static function B591Cb4c525399f2($de738fc3e952e6db, $E9c59de9d6f737b6 = true)
    {
        $c642e35f66dad168 = 60;
        $F4cb62b000c90fc8 = 60 * $c642e35f66dad168;
        $E4850b9cf4b6332d = 24 * $F4cb62b000c90fc8;
        $a3e0f67255a4a1ab = (int) floor($de738fc3e952e6db / (($E4850b9cf4b6332d ?: 1)));
        $C15d1a24e5d9b38f = $de738fc3e952e6db % $E4850b9cf4b6332d;
        $b9820ae02333c553 = (int) floor($C15d1a24e5d9b38f / (($F4cb62b000c90fc8 ?: 1)));
        $cf445a5a2bdb3bf2 = $C15d1a24e5d9b38f % $F4cb62b000c90fc8;
        $faf04b21ea07ead2 = (int) floor($cf445a5a2bdb3bf2 / (($c642e35f66dad168 ?: 1)));
        $Bf470979b27d36ad = $cf445a5a2bdb3bf2 % $c642e35f66dad168;
        $Ff9f678c048b6c89 = (int) ceil($Bf470979b27d36ad);
        $B3dd6de7b6ec6ab8 = "";
        if($a3e0f67255a4a1ab == 0) {
        } else {
            $B3dd6de7b6ec6ab8 .= $a3e0f67255a4a1ab . "d ";
        }

        if($b9820ae02333c553 == 0) {
        } else {
            $B3dd6de7b6ec6ab8 .= $b9820ae02333c553 . "h ";
        }

        if($faf04b21ea07ead2 == 0) {
        } else {
            $B3dd6de7b6ec6ab8 .= $faf04b21ea07ead2 . "m ";
        }

        if(!$E9c59de9d6f737b6) {
        } else {
            $B3dd6de7b6ec6ab8 .= $Ff9f678c048b6c89 . "s";
        }

        return $B3dd6de7b6ec6ab8;
    }

    public static function CAD2511E6ce617eE($Ae61b2c2e8236f08, $b572978c16e12aab, $D65d9f41c5e6bd3a)
    {
        if(is_array($Ae61b2c2e8236f08)) {
        } else {
            $Ae61b2c2e8236f08 = array( intval($Ae61b2c2e8236f08) );
        }

        $b572978c16e12aab = array_map("intval", $b572978c16e12aab);
        $B3dd6de7b6ec6ab8 = array(  );
        foreach($Ae61b2c2e8236f08 as $Febabbe2c8824ef7) {
            if(array_key_exists($Febabbe2c8824ef7, self::$rServers)) {
                $D6e4a78203de4e0e = self::a992109e43fB0808($Febabbe2c8824ef7, self::$rServers[$Febabbe2c8824ef7]["api_url_ip"] . "&action=pidsAreRunning", array( "program" => $D65d9f41c5e6bd3a, "pids" => $b572978c16e12aab ));
                if($D6e4a78203de4e0e) {
                    $B3dd6de7b6ec6ab8[$Febabbe2c8824ef7] = array_map("trim", json_decode($D6e4a78203de4e0e, true));
                } else {
                    $B3dd6de7b6ec6ab8[$Febabbe2c8824ef7] = false;
                }

            }

        }
        return $B3dd6de7b6ec6ab8;
    }

    public static function A730814016cD104F($Febabbe2c8824ef7, $C9bc783135eb4c9a, $D65d9f41c5e6bd3a)
    {
        if(!is_null($C9bc783135eb4c9a) && is_numeric($C9bc783135eb4c9a) && array_key_exists($Febabbe2c8824ef7, self::$rServers)) {
            if(!($B3dd6de7b6ec6ab8 = self::Cad2511e6ce617ee($Febabbe2c8824ef7, array( $C9bc783135eb4c9a ), $D65d9f41c5e6bd3a))) {
                return false;
            }

            return $B3dd6de7b6ec6ab8[$Febabbe2c8824ef7][$C9bc783135eb4c9a];
        }

        return false;
    }

    public static function a992109e43fB0808($Febabbe2c8824ef7, $C872016bcd6efd74, $F2e60add041eb72e = array(  ))
    {
        if(self::$rServers[$Febabbe2c8824ef7]["server_online"]) {
            $B3dd6de7b6ec6ab8 = false;
            $bb850694dd82a471 = 1;
            while($bb850694dd82a471 <= 2) {
                $f6ff5524c7f94bba = curl_init();
                curl_setopt($f6ff5524c7f94bba, CURLOPT_URL, $C872016bcd6efd74);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:9.0) Gecko/20100101 Firefox/9.0");
                curl_setopt($f6ff5524c7f94bba, CURLOPT_HEADER, 0);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_CONNECTTIMEOUT, 10);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_TIMEOUT, 10);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_FRESH_CONNECT, true);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_FORBID_REUSE, true);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_SSL_VERIFYPEER, 0);
                if(empty($F2e60add041eb72e)) {
                } else {
                    curl_setopt($f6ff5524c7f94bba, CURLOPT_POST, true);
                    curl_setopt($f6ff5524c7f94bba, CURLOPT_POSTFIELDS, http_build_query($F2e60add041eb72e));
                }

                $B3dd6de7b6ec6ab8 = curl_exec($f6ff5524c7f94bba);
                $Ee90ad2877d1a5a5 = curl_getinfo($f6ff5524c7f94bba, CURLINFO_HTTP_CODE);
                $a64de38e252cce42 = curl_errno($f6ff5524c7f94bba);
                @curl_close($f6ff5524c7f94bba);
                if($a64de38e252cce42 != 0 || $Ee90ad2877d1a5a5 != 200) {
                    $bb850694dd82a471++;
                    break;
                }

            }
            return $B3dd6de7b6ec6ab8;
        }

        return false;
    }

    public static function cD63A8B8D7dEE0ca($ee4476870c959e0f)
    {
        if(!empty($ee4476870c959e0f)) {
            foreach($ee4476870c959e0f as $a3139b983eda1cac) {
                if(!file_exists(CACHE_TMP_PATH . md5($a3139b983eda1cac))) {
                } else {
                    unlink(CACHE_TMP_PATH . md5($a3139b983eda1cac));
                }

            }
        } else {
            return null;
        }

    }

    public static function queueChannel($F406b49979220eef, $Febabbe2c8824ef7 = null)
    {
        if($Febabbe2c8824ef7) {
        } else {
            $Febabbe2c8824ef7 = SERVER_ID;
        }

        self::$db->query("SELECT `id` FROM `queue` WHERE `stream_id` = ? AND `server_id` = ?;", $F406b49979220eef, $Febabbe2c8824ef7);
        if(self::$db->num_rows() != 0) {
        } else {
            self::$db->query("INSERT INTO `queue`(`type`, `stream_id`, `server_id`, `added`) VALUES('channel', ?, ?, ?);", $F406b49979220eef, $Febabbe2c8824ef7, time());
        }

    }

    public static function c0359Be4fFf3B375($F406b49979220eef)
    {
        shell_exec(PHP_BIN . " " . CLI_PATH . "created.php " . intval($F406b49979220eef) . " >/dev/null 2>/dev/null &");
        return true;
    }

    public static function cBdEb5484A33f270($F406b49979220eef, $a3139b983eda1cac)
    {
        $ec86abab8d64506a = array(  );
        self::$db->query("SELECT * FROM `streams` t1 INNER JOIN `streams_types` t2 ON t2.type_id = t1.type AND t1.type = 3 LEFT JOIN `profiles` t4 ON t1.transcode_profile_id = t4.profile_id WHERE t1.direct_source = 0 AND t1.id = ?", $F406b49979220eef);
        if(self::$db->num_rows() > 0) {
            $ec86abab8d64506a["stream_info"] = self::$db->get_row();
            self::$db->query("SELECT * FROM `streams_servers` WHERE stream_id  = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
            if(self::$db->num_rows() > 0) {
                $ec86abab8d64506a["server_info"] = self::$db->get_row();
                $f8c7b836c46127ac = md5($a3139b983eda1cac);
                if(substr($a3139b983eda1cac, 0, 2) == "s:") {
                    $D401f744de8fd552 = explode(":", $a3139b983eda1cac, 3);
                    $Febabbe2c8824ef7 = intval($D401f744de8fd552[1]);
                    if($Febabbe2c8824ef7 != SERVER_ID) {
                        $ea566fc082a4907b = self::$rServers[$Febabbe2c8824ef7]["api_url"] . "&action=getFile&filename=" . urlencode($D401f744de8fd552[2]);
                    } else {
                        $ea566fc082a4907b = $D401f744de8fd552[2];
                    }

                } else {
                    $Febabbe2c8824ef7 = SERVER_ID;
                    $ea566fc082a4907b = $a3139b983eda1cac;
                }

                if($Febabbe2c8824ef7 == SERVER_ID && $ec86abab8d64506a["stream_info"]["movie_symlink"] == 1) {
                    $fd63fe799d5bb48b = pathinfo($a3139b983eda1cac)["extension"];
                    if(strlen($fd63fe799d5bb48b) != 0) {
                    } else {
                        $fd63fe799d5bb48b = "mp4";
                    }

                    $ee09c213e06fb6a4 = "ln -sfn " . escapeshellarg($ea566fc082a4907b) . " \"" . CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . "." . escapeshellcmd($fd63fe799d5bb48b) . "\" >/dev/null 2>/dev/null & echo \$! > \"" . CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . ".pid\"";
                } else {
                    $ec86abab8d64506a["stream_info"]["transcode_attributes"] = json_decode($ec86abab8d64506a["stream_info"]["profile_options"], true);
                    $Dd38b5440b2a8e5e = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"][16]) && !$eeb8e40a633650b2 ? $ec86abab8d64506a["stream_info"]["transcode_attributes"][16]["cmd"] : "");
                    $dc24c4d060ea41d1 = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? $ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]["cmd"] : "");
                    $cf6b5aed6b8efff3 = "";
                    if(empty($dc24c4d060ea41d1)) {
                    } else {
                        $a78b1adac3f9cef3 = self::D7037C5D36De007b($ea566fc082a4907b);
                        if(!in_array($a78b1adac3f9cef3["codecs"]["video"]["codec_name"], array( "h264", "hevc", "mjpeg", "mpeg1", "mpeg2", "mpeg4", "vc1", "vp8", "vp9" ))) {
                        } else {
                            $cf6b5aed6b8efff3 = "-c:v " . $a78b1adac3f9cef3["codecs"]["video"]["codec_name"] . "_cuvid";
                        }

                    }

                    $ee09c213e06fb6a4 = ((isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? self::$rFFMPEG_GPU : self::$rFFMPEG_CPU)) . " -y -nostdin -hide_banner -loglevel " . ((self::$rSettings["ffmpeg_warnings"] ? "warning" : "error")) . " -err_detect ignore_err {GPU} -fflags +genpts -async 1 {DRM} -i {STREAM_SOURCE} {LOGO} ";
                    if(array_key_exists("-acodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-acodec"] = "copy";
                    }

                    if(array_key_exists("-vcodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-vcodec"] = "copy";
                    }

                    if(!isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"])) {
                    } else {
                        $ee09c213e06fb6a4 .= "-gpu " . intval($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]["device"]) . " ";
                    }

                    $ee09c213e06fb6a4 .= implode(" ", self::B48A07A014B415ae($ec86abab8d64506a["stream_info"]["transcode_attributes"])) . " ";
                    $ee09c213e06fb6a4 .= "-strict -2 -mpegts_flags +initial_discontinuity -f mpegts \"" . CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . ".ts\"";
                    $ee09c213e06fb6a4 .= " >/dev/null 2>\"" . CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . ".errors\" & echo \$! > \"" . CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . ".pid\"";
                    //$ee09c213e06fb6a4 = str_replace(array( "{GPU}", "{INPUT_CODEC}", "{LOGO}", "{STREAM_SOURCE}" ), array( $dc24c4d060ea41d1, $cf6b5aed6b8efff3, $Dd38b5440b2a8e5e, escapeshellarg($ea566fc082a4907b) ), $ee09c213e06fb6a4);
					$ee09c213e06fb6a4 = str_replace(
						array('{GPU}', '{INPUT_CODEC}', '{LOGO}', '{STREAM_SOURCE}'),
						array($dc24c4d060ea41d1, $cf6b5aed6b8efff3, $Dd38b5440b2a8e5e, escapeshellarg($ea566fc082a4907b)),
						$ee09c213e06fb6a4
					);
					
                }

                shell_exec($ee09c213e06fb6a4);
                return intval(file_get_contents(CREATED_PATH . intval($F406b49979220eef) . "_" . $f8c7b836c46127ac . ".pid"));
            }

            return false;
        }

        return false;
    }

    public static function extractSubtitle($F406b49979220eef, $b3a05ae46919fd6e, $cc825482497e483e)
    {
        $d5433a391c26a830 = 10;
        $ee09c213e06fb6a4 = "timeout " . $d5433a391c26a830 . " " . self::$rFFMPEG_CPU . " -y -nostdin -hide_banner -loglevel " . ((self::$rSettings["ffmpeg_warnings"] ? "warning" : "error")) . " -err_detect ignore_err -i \"" . $b3a05ae46919fd6e . "\" -map 0:s:" . intval($cc825482497e483e) . " " . VOD_PATH . intval($F406b49979220eef) . "_" . intval($cc825482497e483e) . ".srt";
        exec($ee09c213e06fb6a4, $B3dd6de7b6ec6ab8);
        if(file_exists(VOD_PATH . intval($F406b49979220eef) . "_" . intval($cc825482497e483e) . ".srt")) {
            if(filesize(VOD_PATH . intval($F406b49979220eef) . "_" . intval($cc825482497e483e) . ".srt") != 0) {
                return true;
            }

            unlink(VOD_PATH . intval($F406b49979220eef) . "_" . intval($cc825482497e483e) . ".srt");
            return false;
        }

        return false;
    }

    public static function D7037C5D36De007b($b3a05ae46919fd6e, $Dc603b015b3a343c = array(  ), $F58c369d60d4e3dc = "", $Def3ae284f8b5f66 = true, $force_ffmpeg_ver = null)
    {
		if(!is_null($force_ffmpeg_ver) && strlen($force_ffmpeg_ver) > 0) {
			if(defined($force_ffmpeg_ver))
			{
				self::$rFFPROBE = constant($force_ffmpeg_ver);
			}
		}
		
        $dc5ab72097861ad6 = abs(intval(self::$rSettings["stream_max_analyze"]));
        $Cf6c40b018022973 = abs(intval(self::$rSettings["probesize"]));
        $d5433a391c26a830 = intval($dc5ab72097861ad6 / 1000000) + self::$rSettings["probe_extra_wait"];
        $ee09c213e06fb6a4 = $F58c369d60d4e3dc . "timeout " . $d5433a391c26a830 . " " . self::$rFFPROBE . " -probesize " . $Cf6c40b018022973 . " -analyzeduration " . $dc5ab72097861ad6 . " " . implode(" ", $Dc603b015b3a343c) . " -i \"" . $b3a05ae46919fd6e . "\" -v quiet -print_format json -show_streams -show_format";
        exec($ee09c213e06fb6a4, $F0e839083d6bad06);
        $D72d82a260ff647a = implode("\n", $F0e839083d6bad06);
        if($Def3ae284f8b5f66) {
            return self::aE00150202Bd6cdE(json_decode($D72d82a260ff647a, true));
        }

        return json_decode($D72d82a260ff647a, true);
    }

    public static function AE00150202BD6Cde($B8338319bd5de630)
    {
        if(empty($B8338319bd5de630)) {
            return false;
        }

        if(empty($B8338319bd5de630["codecs"])) {
            $B3dd6de7b6ec6ab8 = array(  );
            $B3dd6de7b6ec6ab8["codecs"]["video"] = "";
            $B3dd6de7b6ec6ab8["codecs"]["audio"] = "";
            $B3dd6de7b6ec6ab8["container"] = $B8338319bd5de630["format"]["format_name"];
            $B3dd6de7b6ec6ab8["filename"] = $B8338319bd5de630["format"]["filename"];
            $B3dd6de7b6ec6ab8["bitrate"] = (!empty($B8338319bd5de630["format"]["bit_rate"]) ? $B8338319bd5de630["format"]["bit_rate"] : null);
            $B3dd6de7b6ec6ab8["of_duration"] = (!empty($B8338319bd5de630["format"]["duration"]) ? $B8338319bd5de630["format"]["duration"] : "N/A");
            $B3dd6de7b6ec6ab8["duration"] = (!empty($B8338319bd5de630["format"]["duration"]) ? gmdate("H:i:s", intval($B8338319bd5de630["format"]["duration"])) : "N/A");
            foreach($B8338319bd5de630["streams"] as $D9c58e437d913885) {
                if(isset($D9c58e437d913885["codec_type"]) && !($D9c58e437d913885["codec_type"] != "audio" && $D9c58e437d913885["codec_type"] != "video" && $D9c58e437d913885["codec_type"] != "subtitle")) {
                    if($D9c58e437d913885["codec_type"] == "audio" || $D9c58e437d913885["codec_type"] == "video") {
                        if(!empty($B3dd6de7b6ec6ab8["codecs"][$D9c58e437d913885["codec_type"]])) {
                        } else {
                            $B3dd6de7b6ec6ab8["codecs"][$D9c58e437d913885["codec_type"]] = $D9c58e437d913885;
                        }

                    } else {
                        if($D9c58e437d913885["codec_type"] != "subtitle") {
                        } else {
                            if(isset($B3dd6de7b6ec6ab8["codecs"][$D9c58e437d913885["codec_type"]])) {
                            } else {
                                $B3dd6de7b6ec6ab8["codecs"][$D9c58e437d913885["codec_type"]] = array(  );
                            }

                            $B3dd6de7b6ec6ab8["codecs"][$D9c58e437d913885["codec_type"]][] = $D9c58e437d913885;
                        }

                    }

                }

            }
            return $B3dd6de7b6ec6ab8;
        } else {
            return $B8338319bd5de630;
        }

    }

    public static function c1EEc84E975aA00e($F406b49979220eef, $B86f06bbb496ab46 = false)
    {
        if(file_exists(STREAMS_PATH . $F406b49979220eef . "_.monitor")) {
            $Dab883aef98438b9 = intval(file_get_contents(STREAMS_PATH . $F406b49979220eef . "_.monitor"));
        } else {
            self::$db->query("SELECT `monitor_pid` FROM `streams_servers` WHERE `server_id` = ? AND `stream_id` = ? LIMIT 1;", SERVER_ID, $F406b49979220eef);
            $Dab883aef98438b9 = intval(self::$db->get_row()["monitor_pid"]);
        }

        if(0 >= $Dab883aef98438b9) {
        } else {
            if(!(self::f23950AE3556E0a2($Dab883aef98438b9, array( "XUI[" . $F406b49979220eef . "]", "XUIProxy[" . $F406b49979220eef . "]" )) && is_numeric($Dab883aef98438b9) && 0 < $Dab883aef98438b9)) {
            } else {
                posix_kill($Dab883aef98438b9, 9);
            }

        }

        if(file_exists(STREAMS_PATH . $F406b49979220eef . "_.pid")) {
            $C9bc783135eb4c9a = intval(file_get_contents(STREAMS_PATH . $F406b49979220eef . "_.pid"));
        } else {
            self::$db->query("SELECT `pid` FROM `streams_servers` WHERE `server_id` = ? AND `stream_id` = ? LIMIT 1;", SERVER_ID, $F406b49979220eef);
            $C9bc783135eb4c9a = intval(self::$db->get_row()["pid"]);
        }

        if(0 >= $C9bc783135eb4c9a) {
        } else {
            if(!(self::F23950aE3556E0a2($C9bc783135eb4c9a, array( $F406b49979220eef . "_.m3u8", $F406b49979220eef . "_%d.ts", "LLOD[" . $F406b49979220eef . "]", "XUIProxy[" . $F406b49979220eef . "]", "Loopback[" . $F406b49979220eef . "]" )) && is_numeric($C9bc783135eb4c9a) && 0 < $C9bc783135eb4c9a)) {
            } else {
                posix_kill($C9bc783135eb4c9a, 9);
            }

        }

        if(!file_exists(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef))) {
        } else {
            unlink(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef));
        }

        self::D6Ff2E80EA1135Cc($F406b49979220eef, SERVER_ID, "STREAM_STOP");
        shell_exec("rm -f " . STREAMS_PATH . intval($F406b49979220eef) . "_*");
        if(!$B86f06bbb496ab46) {
        } else {
            shell_exec("rm -f " . DELAY_PATH . intval($F406b49979220eef) . "_*");
            self::$db->query("UPDATE `streams_servers` SET `bitrate` = NULL,`current_source` = NULL,`to_analyze` = 0,`pid` = NULL,`stream_started` = NULL,`stream_info` = NULL,`audio_codec` = NULL,`video_codec` = NULL,`resolution` = NULL,`compatible` = 0,`stream_status` = 0,`monitor_pid` = NULL WHERE `stream_id` = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
            self::f4b3E09bf5bd2d1A($F406b49979220eef);
        }

    }

    public static function F23950ae3556e0A2($C9bc783135eb4c9a, $aaf96afd2da2676d)
    {
        if(is_array($aaf96afd2da2676d)) {
        } else {
            $aaf96afd2da2676d = array( $aaf96afd2da2676d );
        }

        if(!file_exists("/proc/" . $C9bc783135eb4c9a)) {
        } else {
            $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
            foreach($aaf96afd2da2676d as $d361ac4ee74f3e85) {
                if(!stristr($ee09c213e06fb6a4, $d361ac4ee74f3e85)) {
                } else {
                    return true;
                }

            }
        }

        return false;
    }

    public static function d75d35E466Dac2b5($F406b49979220eef, $de7ad8e97ef6f8dd = 0)
    {
        shell_exec(PHP_BIN . " " . CLI_PATH . "monitor.php " . intval($F406b49979220eef) . " " . intval($de7ad8e97ef6f8dd) . " >/dev/null 2>/dev/null &");
        return true;
    }

    public static function startProxy($F406b49979220eef)
    {
        shell_exec(PHP_BIN . " " . CLI_PATH . "proxy.php " . intval($F406b49979220eef) . " >/dev/null 2>/dev/null &");
        return true;
    }

    public static function BFEA096feaa65371($F406b49979220eef)
    {
        shell_exec(PHP_BIN . " " . CLI_PATH . "thumbnail.php " . intval($F406b49979220eef) . " >/dev/null 2>/dev/null &");
        return true;
    }

    public static function CC1B7a834e94E7eA($F406b49979220eef, $Ccab564379a6ea90 = false)
    {
        shell_exec("kill -9 `ps -ef | grep '/" . intval($F406b49979220eef) . ".' | grep -v grep | awk '{print \$2}'`;");
        if($Ccab564379a6ea90) {
            exec("rm " . XUI_HOME . "content/vod/" . intval($F406b49979220eef) . ".*");
        } else {
            self::$db->query("INSERT INTO `signals`(`server_id`, `time`, `custom_data`, `cache`) VALUES(?, ?, ?, 1);", SERVER_ID, time(), json_encode(array( "type" => "delete_vod", "id" => $F406b49979220eef )));
        }

        self::$db->query("UPDATE `streams_servers` SET `bitrate` = NULL,`current_source` = NULL,`to_analyze` = 0,`pid` = NULL,`stream_started` = NULL,`stream_info` = NULL,`audio_codec` = NULL,`video_codec` = NULL,`resolution` = NULL,`compatible` = 0,`stream_status` = 0 WHERE `stream_id` = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
        self::F4B3E09bf5bD2D1A($F406b49979220eef);
    }

    public static function queueMovie($F406b49979220eef, $Febabbe2c8824ef7 = null)
    {
        if($Febabbe2c8824ef7) {
        } else {
            $Febabbe2c8824ef7 = SERVER_ID;
        }

        self::$db->query("DELETE FROM `queue` WHERE `stream_id` = ? AND `server_id` = ?;", $F406b49979220eef, $Febabbe2c8824ef7);
        self::$db->query("INSERT INTO `queue`(`type`, `stream_id`, `server_id`, `added`) VALUES('movie', ?, ?, ?);", $F406b49979220eef, $Febabbe2c8824ef7, time());
    }

    public static function queueMovies($E08d14aeb9b1814a, $Febabbe2c8824ef7 = null)
    {
        if($Febabbe2c8824ef7) {
        } else {
            $Febabbe2c8824ef7 = SERVER_ID;
        }

        if(0 >= count($E08d14aeb9b1814a)) {
        } else {
            self::$db->query("DELETE FROM `queue` WHERE `stream_id` IN (" . implode(",", array_map("intval", $E08d14aeb9b1814a)) . ") AND `server_id` = ?;", $Febabbe2c8824ef7);
            $E84548734e5d92a1 = "";
            foreach($E08d14aeb9b1814a as $F406b49979220eef) {
                if(0 >= $F406b49979220eef) {
                } else {
                    $E84548734e5d92a1 .= "('movie', " . intval($F406b49979220eef) . ", " . intval($Febabbe2c8824ef7) . ", " . time() . "),";
                }

            }
            if(empty($E84548734e5d92a1)) {
            } else {
                $E84548734e5d92a1 = rtrim($E84548734e5d92a1, ",");
                self::$db->query("INSERT INTO `queue`(`type`, `stream_id`, `server_id`, `added`) VALUES " . $E84548734e5d92a1 . ";");
            }

        }

    }

    public static function refreshMovies($b1ed70b00f55cad9, $b3b256939cb18212 = 1)
    {
        if(0 >= count($b1ed70b00f55cad9)) {
        } else {
            self::$db->query("DELETE FROM `watch_refresh` WHERE `type` = ? AND `stream_id` IN (" . implode(",", array_map("intval", $b1ed70b00f55cad9)) . ");", $b3b256939cb18212);
            $E84548734e5d92a1 = "";
            foreach($b1ed70b00f55cad9 as $A76532e4f616ce0c) {
                if(0 >= $A76532e4f616ce0c) {
                } else {
                    $E84548734e5d92a1 .= "(" . intval($b3b256939cb18212) . ", " . intval($A76532e4f616ce0c) . ", 0),";
                }

            }
            if(empty($E84548734e5d92a1)) {
            } else {
                $E84548734e5d92a1 = rtrim($E84548734e5d92a1, ",");
                self::$db->query("INSERT INTO `watch_refresh`(`type`, `stream_id`, `status`) VALUES " . $E84548734e5d92a1 . ";");
            }

        }

    }

    public static function dc4Cb6dC26f326B1($F406b49979220eef)
    {
        $ec86abab8d64506a = array(  );
        self::$db->query("SELECT * FROM `streams` t1 INNER JOIN `streams_types` t2 ON t2.type_id = t1.type AND t2.live = 0 LEFT JOIN `profiles` t4 ON t1.transcode_profile_id = t4.profile_id WHERE t1.direct_source = 0 AND t1.id = ?", $F406b49979220eef);
        if(self::$db->num_rows() > 0) {
            $ec86abab8d64506a["stream_info"] = self::$db->get_row();
            self::$db->query("SELECT * FROM `streams_servers` WHERE stream_id  = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
            if(self::$db->num_rows() > 0) {
                $ec86abab8d64506a["server_info"] = self::$db->get_row();
                self::$db->query("SELECT t1.*, t2.* FROM `streams_options` t1, `streams_arguments` t2 WHERE t1.stream_id = ? AND t1.argument_id = t2.id", $F406b49979220eef);
                $ec86abab8d64506a["stream_arguments"] = self::$db->get_rows();
                list($Ec8b1368ea3efc46) = json_decode($ec86abab8d64506a["stream_info"]["stream_source"], true);
                if(substr($Ec8b1368ea3efc46, 0, 2) == "s:") {
                    $a69e8f0ca35febcf = explode(":", $Ec8b1368ea3efc46, 3);
                    $bd4118260b53e9fa = $a69e8f0ca35febcf[1];
                    if($bd4118260b53e9fa != SERVER_ID) {
                        $f416076b81cc3cff = self::$rServers[$bd4118260b53e9fa]["api_url"] . "&action=getFile&filename=" . urlencode($a69e8f0ca35febcf[2]);
                    } else {
                        $f416076b81cc3cff = $a69e8f0ca35febcf[2];
                    }

                    $Eb49e051e67718d4 = null;
                } else {
                    if(substr($Ec8b1368ea3efc46, 0, 1) == "/") {
                        $bd4118260b53e9fa = SERVER_ID;
                        $f416076b81cc3cff = $Ec8b1368ea3efc46;
                        $Eb49e051e67718d4 = null;
                    } else {
                        $Eb49e051e67718d4 = substr($Ec8b1368ea3efc46, 0, strpos($Ec8b1368ea3efc46, "://"));
                        $f416076b81cc3cff = str_replace(" ", "%20", $Ec8b1368ea3efc46);
                        $ebc25dac16a0b737 = implode(" ", self::d35eB0cAf279F87a($ec86abab8d64506a["stream_arguments"], $Eb49e051e67718d4, "fetch"));
                    }

                }

                if((isset($bd4118260b53e9fa) && $bd4118260b53e9fa == SERVER_ID || file_exists($f416076b81cc3cff)) && $ec86abab8d64506a["stream_info"]["movie_symlink"] == 1) {
                    $Da09a93dae0132d2 = "ln -sfn " . escapeshellarg($f416076b81cc3cff) . " " . VOD_PATH . intval($F406b49979220eef) . "." . escapeshellcmd(pathinfo($f416076b81cc3cff)["extension"]) . " >/dev/null 2>/dev/null & echo \$! > " . VOD_PATH . intval($F406b49979220eef) . "_.pid";
                } else {
                    $a572a69cd2cab751 = json_decode($ec86abab8d64506a["stream_info"]["movie_subtitles"], true);
                    $b9dd8ae36bea7461 = "";
                    for($bb850694dd82a471 = 0; $bb850694dd82a471 < count($a572a69cd2cab751["files"]); $bb850694dd82a471++) {
                        $a2b284188efd42b8 = escapeshellarg($a572a69cd2cab751["files"][$bb850694dd82a471]);
                        $A9e739b30c7e8af6 = escapeshellarg($a572a69cd2cab751["charset"][$bb850694dd82a471]);
                        if($a572a69cd2cab751["location"] == SERVER_ID) {
                            $b9dd8ae36bea7461 .= "-sub_charenc " . $A9e739b30c7e8af6 . " -i " . $a2b284188efd42b8 . " ";
                        } else {
                            $b9dd8ae36bea7461 .= "-sub_charenc " . $A9e739b30c7e8af6 . " -i \"" . self::$rServers[$a572a69cd2cab751["location"]]["api_url"] . "&action=getFile&filename=" . urlencode($a2b284188efd42b8) . "\" ";
                        }

                    }
                    $ea37cfc79420f9a0 = "";
                    for($bb850694dd82a471 = 0; $bb850694dd82a471 < count($a572a69cd2cab751["files"]); $bb850694dd82a471++) {
                        $ea37cfc79420f9a0 .= "-map " . ($bb850694dd82a471 + 1) . " -metadata:s:s:" . $bb850694dd82a471 . " title=" . escapeshellcmd($a572a69cd2cab751["names"][$bb850694dd82a471]) . " -metadata:s:s:" . $bb850694dd82a471 . " language=" . escapeshellcmd($a572a69cd2cab751["names"][$bb850694dd82a471]) . " ";
                    }
                    if($ec86abab8d64506a["stream_info"]["read_native"] == 1) {
                        $c912f2883c281a40 = "-re";
                    } else {
                        $c912f2883c281a40 = "";
                    }

                    if($ec86abab8d64506a["stream_info"]["enable_transcode"] == 1) {
                        if($ec86abab8d64506a["stream_info"]["transcode_profile_id"] == -1) {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"] = array_merge(self::d35Eb0caF279F87a($ec86abab8d64506a["stream_arguments"], $Eb49e051e67718d4, "transcode"), json_decode($ec86abab8d64506a["stream_info"]["transcode_attributes"], true));
                        } else {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"] = json_decode($ec86abab8d64506a["stream_info"]["profile_options"], true);
                        }

                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"] = array(  );
                    }

                    $Dd38b5440b2a8e5e = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"][16]) && !$eeb8e40a633650b2 ? $ec86abab8d64506a["stream_info"]["transcode_attributes"][16]["cmd"] : "");
                    $dc24c4d060ea41d1 = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? $ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]["cmd"] : "");
                    $cf6b5aed6b8efff3 = "";
                    if(empty($dc24c4d060ea41d1)) {
                    } else {
                        $a78b1adac3f9cef3 = self::d7037C5D36DE007B($f416076b81cc3cff);
                        if(!in_array($a78b1adac3f9cef3["codecs"]["video"]["codec_name"], array( "h264", "hevc", "mjpeg", "mpeg1", "mpeg2", "mpeg4", "vc1", "vp8", "vp9" ))) {
                        } else {
                            $cf6b5aed6b8efff3 = "-c:v " . $a78b1adac3f9cef3["codecs"]["video"]["codec_name"] . "_cuvid";
                        }

                    }

                    $Da09a93dae0132d2 = ((isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? self::$rFFMPEG_GPU : self::$rFFMPEG_CPU)) . " -y -nostdin -hide_banner -loglevel " . ((self::$rSettings["ffmpeg_warnings"] ? "warning" : "error")) . " -err_detect ignore_err {GPU} {FETCH_OPTIONS} -fflags +genpts -async 1 {DRM} {READ_NATIVE} -i {STREAM_SOURCE} {LOGO} " . $b9dd8ae36bea7461;
                    $ba788faef875d62c = "-map 0 -copy_unknown ";
                    if(!empty($ec86abab8d64506a["stream_info"]["custom_map"])) {
                        $ba788faef875d62c = escapeshellcmd($ec86abab8d64506a["stream_info"]["custom_map"]) . " -copy_unknown ";
                    } else {
                        if($ec86abab8d64506a["stream_info"]["remove_subtitles"] != 1) {
                        } else {
                            $ba788faef875d62c = "-map 0:a -map 0:v";
                        }

                    }

                    if(array_key_exists("-acodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-acodec"] = "copy";
                    }

                    if(array_key_exists("-vcodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-vcodec"] = "copy";
                    }

                    if($ec86abab8d64506a["stream_info"]["target_container"] == "mp4") {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-scodec"] = "mov_text";
                    } else {
                        if($ec86abab8d64506a["stream_info"]["target_container"] == "mkv") {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-scodec"] = "srt";
                        } else {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-scodec"] = "copy";
                        }

                    }

                    $f6fbf57e195f24fc = array(  );
                    $f6fbf57e195f24fc[$ec86abab8d64506a["stream_info"]["target_container"]] = "-movflags +faststart -dn " . $ba788faef875d62c . " -ignore_unknown " . $ea37cfc79420f9a0 . " " . VOD_PATH . intval($F406b49979220eef) . "." . escapeshellcmd($ec86abab8d64506a["stream_info"]["target_container"]);
                    foreach($f6fbf57e195f24fc as $Aebf90d693118138 => $c4240c857bdde1c3) {
                        $Da09a93dae0132d2 .= implode(" ", self::B48A07a014b415ae($ec86abab8d64506a["stream_info"]["transcode_attributes"])) . " ";
                        $Da09a93dae0132d2 .= $c4240c857bdde1c3;
                    }
                    $Da09a93dae0132d2 .= " >/dev/null 2>" . VOD_PATH . intval($F406b49979220eef) . ".errors & echo \$! > " . VOD_PATH . intval($F406b49979220eef) . "_.pid";
                    $Da09a93dae0132d2 = str_replace(array( "{GPU}", "{INPUT_CODEC}", "{LOGO}", "{FETCH_OPTIONS}", "{STREAM_SOURCE}", "{READ_NATIVE}" ), array( $dc24c4d060ea41d1, $cf6b5aed6b8efff3, $Dd38b5440b2a8e5e, (empty($ebc25dac16a0b737) ? "" : $ebc25dac16a0b737), escapeshellarg($f416076b81cc3cff), (empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"]) ? $c912f2883c281a40 : "") ), $Da09a93dae0132d2);
                }

                shell_exec($Da09a93dae0132d2);
                file_put_contents(VOD_PATH . $F406b49979220eef . "_.ffmpeg", $Da09a93dae0132d2);
                $C9bc783135eb4c9a = intval(file_get_contents(VOD_PATH . $F406b49979220eef . "_.pid"));
                self::$db->query("UPDATE `streams_servers` SET `to_analyze` = 1,`stream_started` = ?,`stream_status` = 0,`pid` = ? WHERE `stream_id` = ? AND `server_id` = ?", time(), $C9bc783135eb4c9a, $F406b49979220eef, SERVER_ID);
                self::F4B3E09bF5bd2D1a($F406b49979220eef);
                return $C9bc783135eb4c9a;
            }

            return false;
        }

        return false;
    }

    public static function c6450632b43A00AB($e541595cf7b8b3f7)
    {
        $Ad98ad71c0ef6ccc = false;
        $c4537dbba77895b5 = false;
        $D401f744de8fd552 = explode(";", $e541595cf7b8b3f7);
        foreach($D401f744de8fd552 as $d5a07dd3390f90bc) {
            list($A6236b8f3b6a4fa6, $fff0f0d8088c1ce3) = explode("=", $d5a07dd3390f90bc, 1);
            if(strtolower($A6236b8f3b6a4fa6) == "path") {
                $Ad98ad71c0ef6ccc = true;
            } else {
                if(strtolower($A6236b8f3b6a4fa6) != "domain") {
                } else {
                    $c4537dbba77895b5 = true;
                }

            }

        }
        if(!substr($e541595cf7b8b3f7, -1) != ";") {
        } else {
            $e541595cf7b8b3f7 .= ";";
        }

        if($Ad98ad71c0ef6ccc) {
        } else {
            $e541595cf7b8b3f7 .= "path=/;";
        }

        if($c4537dbba77895b5) {
        } else {
            $e541595cf7b8b3f7 .= "domain=;";
        }

        return $e541595cf7b8b3f7;
    }

    public static function eB64cCfba5D66445($F406b49979220eef)
    {
    }

    public static function Fc5522A902Fe906d($F406b49979220eef, $e411f47b616cff3c, $Be5910385ec0d65a, $C96a9905ecb1b4c1 = null)
    {
        shell_exec("rm -f " . STREAMS_PATH . intval($F406b49979220eef) . "_*.ts");
        if(!file_exists(STREAMS_PATH . $F406b49979220eef . "_.pid")) {
        } else {
            unlink(STREAMS_PATH . $F406b49979220eef . "_.pid");
        }

        $ee4476870c959e0f = ($C96a9905ecb1b4c1 ? array( $C96a9905ecb1b4c1 ) : json_decode($e411f47b616cff3c["stream_source"], true));
        $C4ddc56c0c64d362 = array(  );
        foreach($Be5910385ec0d65a as $d8a914b48528d80b) {
            $C4ddc56c0c64d362[$d8a914b48528d80b["argument_key"]] = array( "value" => $d8a914b48528d80b["value"], "argument_default_value" => $d8a914b48528d80b["argument_default_value"] );
        }
        shell_exec(PHP_BIN . " " . CLI_PATH . "llod.php " . intval($F406b49979220eef) . " \"" . base64_encode(json_encode($ee4476870c959e0f)) . "\" \"" . base64_encode(json_encode($C4ddc56c0c64d362)) . "\" >/dev/null 2>/dev/null & echo \$! > " . STREAMS_PATH . intval($F406b49979220eef) . "_.pid");
        $C9bc783135eb4c9a = intval(file_get_contents(STREAMS_PATH . $F406b49979220eef . "_.pid"));
        $A6236b8f3b6a4fa6 = openssl_random_pseudo_bytes(16);
        file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.key", $A6236b8f3b6a4fa6);
        $d1a68a552c331e27 = openssl_cipher_iv_length("AES-128-CBC");
        $Edea45df53db7e29 = openssl_random_pseudo_bytes($d1a68a552c331e27);
        file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.iv", $Edea45df53db7e29);
        self::$db->query("UPDATE `streams_servers` SET `delay_available_at` = ?,`to_analyze` = 0,`stream_started` = ?,`stream_info` = ?,`stream_status` = 2,`pid` = ?,`progress_info` = ?,`current_source` = ? WHERE `stream_id` = ? AND `server_id` = ?", null, time(), null, $C9bc783135eb4c9a, json_encode(array(  )), $ee4476870c959e0f[0], $F406b49979220eef, SERVER_ID);
        self::F4b3E09BF5bD2d1A($F406b49979220eef);
        return array( "main_pid" => $C9bc783135eb4c9a, "stream_source" => $ee4476870c959e0f[0], "delay_enabled" => false, "parent_id" => 0, "delay_start_at" => null, "playlist" => STREAMS_PATH . $F406b49979220eef . "_.m3u8", "transcode" => false, "offset" => 0 );
    }

    public static function startLoopback($F406b49979220eef)
    {
        shell_exec("rm -f " . STREAMS_PATH . intval($F406b49979220eef) . "_*.ts");
        if(!file_exists(STREAMS_PATH . $F406b49979220eef . "_.pid")) {
        } else {
            unlink(STREAMS_PATH . $F406b49979220eef . "_.pid");
        }

        $ec86abab8d64506a = array(  );
        self::$db->query("SELECT * FROM `streams` WHERE direct_source = 0 AND id = ?", $F406b49979220eef);
        if(self::$db->num_rows() > 0) {
            $ec86abab8d64506a["stream_info"] = self::$db->get_row();
            self::$db->query("SELECT * FROM `streams_servers` WHERE stream_id  = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
            if(self::$db->num_rows() > 0) {
                $ec86abab8d64506a["server_info"] = self::$db->get_row();
                if($ec86abab8d64506a["server_info"]["parent_id"] != 0) {
                    shell_exec(PHP_BIN . " " . CLI_PATH . "loopback.php " . intval($F406b49979220eef) . " " . intval($ec86abab8d64506a["server_info"]["parent_id"]) . " >/dev/null 2>/dev/null & echo \$! > " . STREAMS_PATH . intval($F406b49979220eef) . "_.pid");
                    $C9bc783135eb4c9a = intval(file_get_contents(STREAMS_PATH . $F406b49979220eef . "_.pid"));
                    $A6236b8f3b6a4fa6 = openssl_random_pseudo_bytes(16);
                    file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.key", $A6236b8f3b6a4fa6);
                    $d1a68a552c331e27 = openssl_cipher_iv_length("AES-128-CBC");
                    $Edea45df53db7e29 = openssl_random_pseudo_bytes($d1a68a552c331e27);
                    file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.iv", $Edea45df53db7e29);
                    self::$db->query("UPDATE `streams_servers` SET `delay_available_at` = ?,`to_analyze` = 0,`stream_started` = ?,`stream_info` = ?,`stream_status` = 2,`pid` = ?,`progress_info` = ?,`current_source` = ? WHERE `stream_id` = ? AND `server_id` = ?", null, time(), null, $C9bc783135eb4c9a, json_encode(array(  )), $ee4476870c959e0f[0], $F406b49979220eef, SERVER_ID);
                    self::f4B3E09Bf5bD2d1a($F406b49979220eef);
                    $c7e21e610aa25149 = (!is_null(self::$rServers[SERVER_ID]["private_url_ip"]) && !is_null(self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["private_url_ip"]) ? self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["private_url_ip"] : self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["public_url_ip"]);
                    return array( "main_pid" => $C9bc783135eb4c9a, "stream_source" => $c7e21e610aa25149 . "admin/live?stream=" . intval($F406b49979220eef) . "&password=" . urlencode(self::$rSettings["live_streaming_pass"]) . "&extension=ts", "delay_enabled" => false, "parent_id" => 0, "delay_start_at" => null, "playlist" => STREAMS_PATH . $F406b49979220eef . "_.m3u8", "transcode" => false, "offset" => 0 );
                }

                return 0;
            }

            return false;
        }

        return false;
    }

    public static function F725a757418c7E83($F406b49979220eef, $Eb22e2ca555a4bf7 = false, $C96a9905ecb1b4c1 = null, $aa1abdbb1a2f954b = false, $D3e9c0dccde58a18 = 0)
    {
        if(!file_exists(STREAMS_PATH . $F406b49979220eef . "_.pid")) {
        } else {
            unlink(STREAMS_PATH . $F406b49979220eef . "_.pid");
        }

        $ec86abab8d64506a = array(  );
        self::$db->query("SELECT * FROM `streams` t1 INNER JOIN `streams_types` t2 ON t2.type_id = t1.type AND t2.live = 1 LEFT JOIN `profiles` t4 ON t1.transcode_profile_id = t4.profile_id WHERE t1.direct_source = 0 AND t1.id = ?", $F406b49979220eef);
        if(self::$db->num_rows() > 0) {
            $ec86abab8d64506a["stream_info"] = self::$db->get_row();
            self::$db->query("SELECT * FROM `streams_servers` WHERE stream_id  = ? AND `server_id` = ?", $F406b49979220eef, SERVER_ID);
            if(self::$db->num_rows() > 0) {
                $ec86abab8d64506a["server_info"] = self::$db->get_row();
                self::$db->query("SELECT t1.*, t2.* FROM `streams_options` t1, `streams_arguments` t2 WHERE t1.stream_id = ? AND t1.argument_id = t2.id", $F406b49979220eef);
                $ec86abab8d64506a["stream_arguments"] = self::$db->get_rows();
                if($ec86abab8d64506a["server_info"]["on_demand"] == 1) {
                    $Cf6c40b018022973 = intval($ec86abab8d64506a["stream_info"]["probesize_ondemand"]);
                    $dc5ab72097861ad6 = "10000000";
                } else {
                    $dc5ab72097861ad6 = abs(intval(self::$rSettings["stream_max_analyze"]));
                    $Cf6c40b018022973 = abs(intval(self::$rSettings["probesize"]));
                }
				
				//Custom FFMPEG for Stream
				if (isset($ec86abab8d64506a['stream_info']['force_ffmpeg_ver']) && strlen($ec86abab8d64506a['stream_info']['force_ffmpeg_ver']) > 0) {
					$streamForceFFmpeg = $ec86abab8d64506a['stream_info']['force_ffmpeg_ver'];
					$forceFFVersion = intval(str_replace('.', '', $streamForceFFmpeg));
					$streamForceFFmpeg = "FFMPEG_BIN_" . $forceFFVersion;
					$streamForceFFprobe = "FFPROBE_BIN_" . $forceFFVersion;
					if(defined($streamForceFFmpeg)) {
						self::$rFFMPEG_CPU = constant($streamForceFFmpeg);
						self::$rFFMPEG_GPU = constant($streamForceFFmpeg);
					}
					if(defined($streamForceFFprobe)) {
						self::$rFFPROBE = constant($streamForceFFprobe);
					}
				}
				//END

                $d5433a391c26a830 = intval($dc5ab72097861ad6 / 1000000) + self::$rSettings["probe_extra_wait"];
                $Ab2279ae0b6e7299 = "timeout " . $d5433a391c26a830 . " " . self::$rFFPROBE . " {FETCH_OPTIONS} -probesize " . $Cf6c40b018022973 . " -analyzeduration " . $dc5ab72097861ad6 . " {CONCAT} -i {STREAM_SOURCE} -v quiet -print_format json -show_streams -show_format";
                $ebc25dac16a0b737 = array(  );
                $eeb8e40a633650b2 = false;
                $a00c3f35d74bbd03 = 0;
                if(!$ec86abab8d64506a["server_info"]["parent_id"]) {
                    if($ec86abab8d64506a["stream_info"]["type_key"] == "created_live") {
                        $ee4476870c959e0f = array( CREATED_PATH . $F406b49979220eef . "_.list" );
                        if(0 >= $D3e9c0dccde58a18) {
                        } else {
                            $a0a74be2ecca4d8e = array(  );
                            $ead75be0f7a1f946 = array(  );
                            $a93d925e57458ec2 = json_decode($ec86abab8d64506a["server_info"]["cc_info"], true);
                            foreach($a93d925e57458ec2 as $cc896abcf1aeace3) {
                                $ead75be0f7a1f946[$cc896abcf1aeace3["path"]] = intval(explode(".", $cc896abcf1aeace3["seconds"])[0]);
                            }
                            $be3202c34e66f2c3 = 0;
                            $ce5a2905353dc3b7 = true;
                            foreach(explode("\n", file_get_contents(CREATED_PATH . $F406b49979220eef . "_.list")) as $cc896abcf1aeace3) {
                                list($Ad98ad71c0ef6ccc) = explode("'", explode("file '", $cc896abcf1aeace3)[1]);
                                if(!$Ad98ad71c0ef6ccc) {
                                } else {
                                    if($ead75be0f7a1f946[$Ad98ad71c0ef6ccc]) {
                                        $d9d40ef4e8254497 = $ead75be0f7a1f946[$Ad98ad71c0ef6ccc];
                                        if($be3202c34e66f2c3 <= $D3e9c0dccde58a18 && $D3e9c0dccde58a18 < $be3202c34e66f2c3 + $d9d40ef4e8254497) {
                                            $a00c3f35d74bbd03 = $be3202c34e66f2c3;
                                            $a0a74be2ecca4d8e[] = $Ad98ad71c0ef6ccc;
                                        } else {
                                            if($D3e9c0dccde58a18 >= $be3202c34e66f2c3 + $d9d40ef4e8254497) {
                                            } else {
                                                $a0a74be2ecca4d8e[] = $Ad98ad71c0ef6ccc;
                                            }

                                        }

                                        $be3202c34e66f2c3 += $d9d40ef4e8254497;
                                    } else {
                                        $ce5a2905353dc3b7 = false;
                                    }

                                }

                            }
                            if(!$ce5a2905353dc3b7) {
                            } else {
                                $ee4476870c959e0f = array( CREATED_PATH . $F406b49979220eef . "_.tlist" );
                                $C3238b6d4d4ff05b = "";
                                foreach($a0a74be2ecca4d8e as $cc896abcf1aeace3) {
                                    $C3238b6d4d4ff05b .= "file '" . $cc896abcf1aeace3 . "'" . "\n";
                                }
                                file_put_contents(CREATED_PATH . $F406b49979220eef . "_.tlist", $C3238b6d4d4ff05b);
                            }

                        }

                    } else {
                        $ee4476870c959e0f = json_decode($ec86abab8d64506a["stream_info"]["stream_source"], true);
                    }

                    if(0 >= count($ee4476870c959e0f)) {
                    } else {
                        if(!empty($C96a9905ecb1b4c1)) {
                            $ee4476870c959e0f = array( $C96a9905ecb1b4c1 );
                        } else {
                            if(self::$rSettings["priority_backup"] == 1 || $ec86abab8d64506a["stream_info"]["priority_backup"] == 1) {
                            } else {
                                if(empty($ec86abab8d64506a["server_info"]["current_source"])) {
                                } else {
                                    $ffba388d0f06d9bc = array_search($ec86abab8d64506a["server_info"]["current_source"], $ee4476870c959e0f);
                                    if($ffba388d0f06d9bc === false) {
                                    } else {
                                        $bb850694dd82a471 = 0;
                                        while($bb850694dd82a471 <= $ffba388d0f06d9bc) {
                                            $eafcd05c9770647c = $ee4476870c959e0f[$bb850694dd82a471];
                                            unset($ee4476870c959e0f[$bb850694dd82a471]);
                                            array_push($ee4476870c959e0f, $eafcd05c9770647c);
                                            $bb850694dd82a471++;
                                        }
                                        $ee4476870c959e0f = array_values($ee4476870c959e0f);
                                    }

                                }

                            }

                        }

                    }

                } else {
                    $eeb8e40a633650b2 = true;
                    if(!$ec86abab8d64506a["server_info"]["on_demand"]) {
                    } else {
                        $aa1abdbb1a2f954b = true;
                    }

                    $c7e21e610aa25149 = (!is_null(self::$rServers[SERVER_ID]["private_url_ip"]) && !is_null(self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["private_url_ip"]) ? self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["private_url_ip"] : self::$rServers[$ec86abab8d64506a["server_info"]["parent_id"]]["public_url_ip"]);
                    $ee4476870c959e0f = array( $c7e21e610aa25149 . "admin/live?stream=" . intval($F406b49979220eef) . "&password=" . urlencode(self::$rSettings["live_streaming_pass"]) . "&extension=ts" );
                }

                if(!$ec86abab8d64506a["server_info"]["on_demand"]) {
                } else {
                    self::$rSegmentSettings["seg_type"] = 1;
                }

                if(!($ec86abab8d64506a["stream_info"]["type_key"] == "created_live" && file_exists(CREATED_PATH . $F406b49979220eef . "_.info"))) {
                } else {
                    self::$db->query("UPDATE `streams_servers` SET `cc_info` = ? WHERE `server_id` = ? AND `stream_id` = ?;", file_get_contents(CREATED_PATH . $F406b49979220eef . "_.info"), SERVER_ID, $F406b49979220eef);
                }

                if($Eb22e2ca555a4bf7) {
                } else {
                    self::CD63a8B8d7dee0Ca($ee4476870c959e0f);
                }

                foreach($ee4476870c959e0f as $a3139b983eda1cac) {
                    $A977ba7e516ed568 = false;
                    $B4a9521e91817105 = $a3139b983eda1cac;
                    $Ec8b1368ea3efc46 = self::f1E1b9F66064Da62($a3139b983eda1cac);
                    echo "Checking source: " . $a3139b983eda1cac . "\n";
                    $b743aade3eeb09d7 = parse_url($Ec8b1368ea3efc46);
                    $b5d88cf2cf968589 = ($eeb8e40a633650b2 ? true : self::b0FfB302984A63F4($Ec8b1368ea3efc46));
                    if(!($b5d88cf2cf968589 && !$eeb8e40a633650b2 && self::$rSettings["send_xui_header"])) {
                    } else {
                        foreach(array_keys($ec86abab8d64506a["stream_arguments"]) as $A76532e4f616ce0c) {
                            if($ec86abab8d64506a["stream_arguments"][$A76532e4f616ce0c]["argument_key"] != "headers") {
                            } else {
                                $ec86abab8d64506a["stream_arguments"][$A76532e4f616ce0c]["value"] .= "\r\n" . "X-XUI-Detect:1";
                                $A977ba7e516ed568 = true;
                            }

                        }
                        if($A977ba7e516ed568) {
                        } else {
                            $ec86abab8d64506a["stream_arguments"][] = array( "value" => "X-XUI-Detect:1", "argument_key" => "headers", "argument_cat" => "fetch", "argument_wprotocol" => "http", "argument_type" => "text", "argument_cmd" => "-headers '%s" . "\r\n" . "'" );
                        }

                    }

                    $ae5b48826e79170c = $ec86abab8d64506a["stream_arguments"];
                    if(!($b5d88cf2cf968589 && $ec86abab8d64506a["server_info"]["on_demand"] == 1 && self::$rSettings["request_prebuffer"] == 1)) {
                    } else {
                        foreach(array_keys($ec86abab8d64506a["stream_arguments"]) as $A76532e4f616ce0c) {
                            if($ec86abab8d64506a["stream_arguments"][$A76532e4f616ce0c]["argument_key"] != "headers") {
                            } else {
                                $ec86abab8d64506a["stream_arguments"][$A76532e4f616ce0c]["value"] .= "\r\n" . "X-XUI-Prebuffer:1";
                                $A977ba7e516ed568 = true;
                            }

                        }
                        if($A977ba7e516ed568) {
                        } else {
                            $ec86abab8d64506a["stream_arguments"][] = array( "value" => "X-XUI-Prebuffer:1", "argument_key" => "headers", "argument_cat" => "fetch", "argument_wprotocol" => "http", "argument_type" => "text", "argument_cmd" => "-headers '%s" . "\r\n" . "'" );
                        }

                    }

                    foreach(array_keys($ae5b48826e79170c) as $A76532e4f616ce0c) {
                        if($ae5b48826e79170c[$A76532e4f616ce0c]["argument_key"] != "headers") {
                        } else {
                            $ae5b48826e79170c[$A76532e4f616ce0c]["value"] .= "\r\n" . "X-XUI-Prebuffer:1";
                            $A977ba7e516ed568 = true;
                        }

                    }
                    if($A977ba7e516ed568) {
                    } else {
                        $ae5b48826e79170c[] = array( "value" => "X-XUI-Prebuffer:1", "argument_key" => "headers", "argument_cat" => "fetch", "argument_wprotocol" => "http", "argument_type" => "text", "argument_cmd" => "-headers '%s" . "\r\n" . "'" );
                    }

                    $Eb49e051e67718d4 = strtolower(substr($Ec8b1368ea3efc46, 0, strpos($Ec8b1368ea3efc46, "://")));
                    $e0d2eb3ea563f6d5 = implode(" ", self::d35Eb0CAf279F87A($ae5b48826e79170c, $Eb49e051e67718d4, "fetch"));
                    $ebc25dac16a0b737 = implode(" ", self::D35EB0Caf279F87A($ec86abab8d64506a["stream_arguments"], $Eb49e051e67718d4, "fetch"));
                    if($Eb22e2ca555a4bf7 && file_exists(CACHE_TMP_PATH . md5($a3139b983eda1cac)) && time() - filemtime(CACHE_TMP_PATH . md5($a3139b983eda1cac)) <= 300) {
                        $a78b1adac3f9cef3 = igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . md5($Ec8b1368ea3efc46)));
                        if(!($a78b1adac3f9cef3 && (isset($a78b1adac3f9cef3["streams"]) || isset($a78b1adac3f9cef3["codecs"])))) {
                        } else {
                            echo "Got stream information via cache" . "\n";
                            goto label501;
                        }

                    } else {
                        if(!($Eb22e2ca555a4bf7 && file_exists(CACHE_TMP_PATH . md5($a3139b983eda1cac)))) {
                        } else {
                            $Eb22e2ca555a4bf7 = false;
                        }

                    }

                    if($ec86abab8d64506a["server_info"]["on_demand"] && $aa1abdbb1a2f954b) {
                    } else {
                        if(!($b5d88cf2cf968589 && self::$rSettings["api_probe"])) {
                        } else {
                            $ee597aaf39f30ad6 = $b743aade3eeb09d7["scheme"] . "://" . $b743aade3eeb09d7["host"] . ":" . $b743aade3eeb09d7["port"] . "/probe/" . base64_encode($b743aade3eeb09d7["path"]);
                            $a78b1adac3f9cef3 = json_decode(self::a6b36277Fd1b5f7B($ee597aaf39f30ad6), true);
                            if(!($a78b1adac3f9cef3 && isset($a78b1adac3f9cef3["codecs"]))) {
                            } else {
                                echo "Got stream information via API" . "\n";
                                goto label501;
                            }

                        }

                        $a78b1adac3f9cef3 = json_decode(shell_exec(str_replace(array( "{FETCH_OPTIONS}", "{CONCAT}", "{STREAM_SOURCE}" ), array( $e0d2eb3ea563f6d5, ($ec86abab8d64506a["stream_info"]["type_key"] == "created_live" && !$ec86abab8d64506a["server_info"]["parent_id"] ? "-safe 0 -f concat" : ""), escapeshellarg($Ec8b1368ea3efc46) ), $Ab2279ae0b6e7299)), true);
                        if(!($a78b1adac3f9cef3 && isset($a78b1adac3f9cef3["streams"]))) {
                        } else {
                            echo "Got stream information via ffprobe" . "\n";
                            goto label501;
                        }

                    }

                }
label501:
                if($ec86abab8d64506a["server_info"]["on_demand"] && $aa1abdbb1a2f954b) {
                } else {
                    if(isset($a78b1adac3f9cef3["codecs"])) {
                    } else {
                        $a78b1adac3f9cef3 = self::aE00150202Bd6cdE($a78b1adac3f9cef3);
                    }

                    if(empty($a78b1adac3f9cef3)) {
                        self::$db->query("UPDATE `streams_servers` SET `progress_info` = '',`to_analyze` = 0,`pid` = -1,`stream_status` = 1 WHERE `server_id` = ? AND `stream_id` = ?", SERVER_ID, $F406b49979220eef);
                        return 0;
                    }

                    if($Eb22e2ca555a4bf7) {
                    } else {
                        file_put_contents(CACHE_TMP_PATH . md5($a3139b983eda1cac), igbinary_serialize($a78b1adac3f9cef3));
                    }

                }

                $b244cfce07f88f57 = json_decode($ec86abab8d64506a["stream_info"]["external_push"], true);
                $ba3256bde24d2913 = "http://127.0.0.1:" . intval(self::$rServers[SERVER_ID]["http_broadcast_port"]) . "/progress?stream_id=" . intval($F406b49979220eef);
                if(empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"])) {
                    if($eeb8e40a633650b2) {
                        $F139f8d6c957719c = "{FETCH_OPTIONS}";
                    } else {
                        $F139f8d6c957719c = "{GPU} {FETCH_OPTIONS}";
                    }
					
					$ffmpegCommand = "";
					if (($ec86abab8d64506a["stream_info"]["is_drm"] && !is_null($ec86abab8d64506a["stream_info"]["drm_key"]))) {
						$drmKey = $ec86abab8d64506a["stream_info"]["drm_key"];
						if (strpos($drmKey, ':') !== false) {
							list($kid, $key) = explode(':', $drmKey, 2);
							$ffmpegCommand = "-cenc_decryption_key $key ";
						} else {
							$key = $drmKey;
							$ffmpegCommand = "-cenc_decryption_key $key ";
						}
					}

                    if($ec86abab8d64506a["stream_info"]["stream_all"] == 1) {
                        $ba788faef875d62c = "-map 0 -copy_unknown ";
                    } else {
                        if(!empty($ec86abab8d64506a["stream_info"]["custom_map"])) {
                            $ba788faef875d62c = escapeshellcmd($ec86abab8d64506a["stream_info"]["custom_map"]) . " -copy_unknown ";
                        } else {
                            if($ec86abab8d64506a["stream_info"]["type_key"] == "radio_streams") {
                                $ba788faef875d62c = "-map 0:a? ";
                            } else {
                                $ba788faef875d62c = "";
                            }

                        }

                    }

                    if(($ec86abab8d64506a["stream_info"]["gen_timestamps"] == 1 || empty($Eb49e051e67718d4)) && $ec86abab8d64506a["stream_info"]["type_key"] != "created_live") {
                        $f162d58da2774327 = "-fflags +genpts -async 1";
                    } else {
                        if(!(in_array($a78b1adac3f9cef3["codecs"]["audio"]["codec_name"], array( "ac3", "eac3" )) && self::$rSettings["dts_legacy_ffmpeg"])) {
                        } else {
                            self::$rFFMPEG_CPU = FFMPEG_BIN_40;
                            self::$rFFPROBE = FFPROBE_BIN_40;
                        }

                        $bb9dd8021356ba5e = (self::$rFFMPEG_CPU == FFMPEG_BIN_40 ? "-nofix_dts" : "");
                        $f162d58da2774327 = $bb9dd8021356ba5e . " -start_at_zero -copyts -vsync 0 -correct_ts_overflow 0 -avoid_negative_ts disabled -max_interleave_delta 0";
                    }

                    if(!$ec86abab8d64506a["server_info"]["parent_id"] && ($ec86abab8d64506a["stream_info"]["read_native"] == 1 || stristr($a78b1adac3f9cef3["container"], "hls") && self::$rSettings["read_native_hls"] || empty($Eb49e051e67718d4) || stristr($a78b1adac3f9cef3["container"], "mp4") || stristr($a78b1adac3f9cef3["container"], "matroska"))) {
                        $c912f2883c281a40 = "-re";
                    } else {
                        $c912f2883c281a40 = "";
                    }
					
					$ffmpegCommand = "";
					if (($ec86abab8d64506a["stream_info"]["is_drm"] && !is_null($ec86abab8d64506a["stream_info"]["drm_key"]))) {
						$drmKey = $ec86abab8d64506a["stream_info"]["drm_key"];
						if (strpos($drmKey, ':') !== false) {
							list($kid, $key) = explode(':', $drmKey, 2);
							$ffmpegCommand = "-cenc_decryption_key $key ";
						} else {
							$key = $drmKey;
							$ffmpegCommand = "-cenc_decryption_key $key ";
						}
					}

                    if(!$ec86abab8d64506a["server_info"]["parent_id"] && $ec86abab8d64506a["stream_info"]["enable_transcode"] == 1 && $ec86abab8d64506a["stream_info"]["type_key"] != "created_live") {
                        if($ec86abab8d64506a["stream_info"]["transcode_profile_id"] == -1) {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"] = array_merge(self::d35eB0cAf279F87a($ec86abab8d64506a["stream_arguments"], $Eb49e051e67718d4, "transcode"), json_decode($ec86abab8d64506a["stream_info"]["transcode_attributes"], true));
                        } else {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"] = json_decode($ec86abab8d64506a["stream_info"]["profile_options"], true);
                        }

                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"] = array(  );
                    }

                    $Da09a93dae0132d2 = ((isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? self::$rFFMPEG_GPU : self::$rFFMPEG_CPU)) . " -y -nostdin -hide_banner -loglevel " . ((self::$rSettings["ffmpeg_warnings"] ? "warning" : "error")) . " -err_detect ignore_err " . $F139f8d6c957719c . " {GEN_PTS} {READ_NATIVE} -probesize " . $Cf6c40b018022973 . " -analyzeduration " . $dc5ab72097861ad6 . " -progress \"" . $ba3256bde24d2913 . "\" {CONCAT} {DRM} -i {STREAM_SOURCE} {LOGO} ";
                    if(array_key_exists("-acodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-acodec"] = "copy";
                    }

                    if(array_key_exists("-vcodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-vcodec"] = "copy";
                    }

                    if(array_key_exists("-scodec", $ec86abab8d64506a["stream_info"]["transcode_attributes"])) {
                    } else {
                        if(self::$rSegmentSettings["seg_type"] == 0) {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-sn"] = "";
                        } else {
                            $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-scodec"] = "copy";
                        }

                    }

                } else {
                    $ec86abab8d64506a["stream_info"]["transcode_attributes"] = array(  );
                    $Da09a93dae0132d2 = ((stripos($ec86abab8d64506a["stream_info"]["custom_ffmpeg"], "nvenc") !== false ? self::$rFFMPEG_GPU : self::$rFFMPEG_CPU)) . " -y -nostdin -hide_banner -loglevel " . ((self::$rSettings["ffmpeg_warnings"] ? "warning" : "error")) . " -progress \"" . $ba3256bde24d2913 . "\" " . $ec86abab8d64506a["stream_info"]["custom_ffmpeg"];
                }

                $a9e3903534330054 = ($aa1abdbb1a2f954b && !$eeb8e40a633650b2 ? "-fflags nobuffer -flags low_delay -strict experimental" : "");
                $f6fbf57e195f24fc = array(  );
                if($eeb8e40a633650b2) {
                    $F139f8d6c957719c = "{MAP}";
                    $Adf023809ade7fe1 = "{MAP}";
                    $ba788faef875d62c = "-map 0 -copy_unknown ";
                } else {
                    $F139f8d6c957719c = "{MAP} {LLOD}";
                    $Adf023809ade7fe1 = "{MAP} {AAC_FILTER}";
                }

                if(self::$rSegmentSettings["seg_type"] == 0) {
                    $F22254450190e388 = (self::$rSettings["ignore_keyframes"] ? "+split_by_time" : "");
                    $f6fbf57e195f24fc["mpegts"][] = $F139f8d6c957719c . " -individual_header_trailer 0 -f hls -hls_time " . intval(self::$rSegmentSettings["seg_time"]) . " -hls_list_size " . intval(self::$rSegmentSettings["seg_list_size"]) . " -hls_delete_threshold " . intval(self::$rSegmentSettings["seg_delete_threshold"]) . " -hls_flags delete_segments+discont_start+omit_endlist" . $F22254450190e388 . " -hls_segment_type mpegts -hls_segment_filename \"" . STREAMS_PATH . intval($F406b49979220eef) . "_%d.ts\" \"" . STREAMS_PATH . intval($F406b49979220eef) . "_.m3u8\" ";
                } else {
                    $F22254450190e388 = (self::$rSettings["ignore_keyframes"] ? " -break_non_keyframes 1" : "");
                    $f6fbf57e195f24fc["mpegts"][] = $F139f8d6c957719c . " -individual_header_trailer 0 -f segment -segment_format mpegts -segment_time " . intval(self::$rSegmentSettings["seg_time"]) . " -segment_list_size " . intval(self::$rSegmentSettings["seg_list_size"]) . " -segment_format_options \"mpegts_flags=+initial_discontinuity:mpegts_copyts=1\" -segment_list_type m3u8 -segment_list_flags +live+delete" . $F22254450190e388 . " -segment_list \"" . STREAMS_PATH . intval($F406b49979220eef) . "_.m3u8\" \"" . STREAMS_PATH . intval($F406b49979220eef) . "_%d.ts\" ";
                }

                if($ec86abab8d64506a["stream_info"]["rtmp_output"] != 1) {
                } else {
                    $f6fbf57e195f24fc["flv"][] = $Adf023809ade7fe1 . " -f flv -flvflags no_duration_filesize rtmp://127.0.0.1:" . intval(self::$rServers[$ec86abab8d64506a["server_info"]["server_id"]]["rtmp_port"]) . "/live/" . intval($F406b49979220eef) . "?password=" . urlencode(self::$rSettings["live_streaming_pass"]) . " ";
                }

                if(empty($b244cfce07f88f57[SERVER_ID])) {
                } else {
                    foreach($b244cfce07f88f57[SERVER_ID] as $D2024d6d35bbb588) {
                        $f6fbf57e195f24fc["flv"][] = $Adf023809ade7fe1 . " -f flv -flvflags no_duration_filesize " . escapeshellarg($D2024d6d35bbb588) . " ";
                    }
                }

                $Dd38b5440b2a8e5e = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"][16]) && !$eeb8e40a633650b2 ? $ec86abab8d64506a["stream_info"]["transcode_attributes"][16]["cmd"] : "");
                $dc24c4d060ea41d1 = (isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]) ? $ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]["cmd"] : "");
                $cf6b5aed6b8efff3 = "";
                if(empty($dc24c4d060ea41d1) || !in_array($a78b1adac3f9cef3["codecs"]["video"]["codec_name"], array( "h264", "hevc", "mjpeg", "mpeg1", "mpeg2", "mpeg4", "vc1", "vp8", "vp9" ))) {
                } else {
                    $cf6b5aed6b8efff3 = "-c:v " . $a78b1adac3f9cef3["codecs"]["video"]["codec_name"] . "_cuvid";
                }

                if(0 >= $ec86abab8d64506a["stream_info"]["delay_minutes"] || $ec86abab8d64506a["server_info"]["parent_id"]) {
                    foreach($f6fbf57e195f24fc as $Aebf90d693118138 => $bd29cdc290f510dd) {
                        foreach($bd29cdc290f510dd as $c4240c857bdde1c3) {
                            if(!isset($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"])) {
                            } else {
                                $Da09a93dae0132d2 .= "-gpu " . intval($ec86abab8d64506a["stream_info"]["transcode_attributes"]["gpu"]["device"]) . " ";
                            }

                            $Da09a93dae0132d2 .= implode(" ", self::b48a07A014B415aE($ec86abab8d64506a["stream_info"]["transcode_attributes"])) . " ";
                            $Da09a93dae0132d2 .= $c4240c857bdde1c3;
                        }
                    }
                } else {
                    $A39be01b3516c1f6 = 0;
                    if(!file_exists(DELAY_PATH . $F406b49979220eef . "_.m3u8")) {
                    } else {
                        $c1fae1225d7a1a4b = file(DELAY_PATH . $F406b49979220eef . "_.m3u8");
                        if(stristr($c1fae1225d7a1a4b[count($c1fae1225d7a1a4b) - 1], $F406b49979220eef . "_")) {
                            if(!preg_match("/\\_(.*?)\\.ts/", $c1fae1225d7a1a4b[count($c1fae1225d7a1a4b) - 1], $B450ac40aba9585c)) {
                            } else {
                                $A39be01b3516c1f6 = intval($B450ac40aba9585c[1]) + 1;
                            }

                        } else {
                            if(!preg_match("/\\_(.*?)\\.ts/", $c1fae1225d7a1a4b[count($c1fae1225d7a1a4b) - 2], $B450ac40aba9585c)) {
                            } else {
                                $A39be01b3516c1f6 = intval($B450ac40aba9585c[1]) + 1;
                            }

                        }

                        if(file_exists(DELAY_PATH . $F406b49979220eef . "_.m3u8_old")) {
                            file_put_contents(DELAY_PATH . $F406b49979220eef . "_.m3u8_old", file_get_contents(DELAY_PATH . $F406b49979220eef . "_.m3u8_old") . file_get_contents(DELAY_PATH . $F406b49979220eef . "_.m3u8"));
                            shell_exec("sed -i '/EXTINF\\|.ts/!d' " . DELAY_PATH . intval($F406b49979220eef) . "_.m3u8_old");
                        } else {
                            copy(DELAY_PATH . $F406b49979220eef . "_.m3u8", DELAY_PATH . intval($F406b49979220eef) . "_.m3u8_old");
                        }

                    }

                    $Da09a93dae0132d2 .= implode(" ", self::B48a07A014B415ae($ec86abab8d64506a["stream_info"]["transcode_attributes"])) . " ";
                    if(self::$rSegmentSettings["seg_type"] == 0) {
                        $Da09a93dae0132d2 .= "{MAP} -individual_header_trailer 0 -f hls -hls_time " . intval(self::$rSegmentSettings["seg_time"]) . " -hls_list_size " . intval($ec86abab8d64506a["stream_info"]["delay_minutes"]) * 6 . " -hls_delete_threshold 4 -start_number " . $A39be01b3516c1f6 . " -hls_flags delete_segments+discont_start+omit_endlist -hls_segment_type mpegts -hls_segment_filename \"" . DELAY_PATH . intval($F406b49979220eef) . "_%d.ts\" \"" . DELAY_PATH . intval($F406b49979220eef) . "_.m3u8\" ";
                    } else {
                        $Da09a93dae0132d2 .= "{MAP} -individual_header_trailer 0 -f segment -segment_format mpegts -segment_time " . intval(self::$rSegmentSettings["seg_time"]) . " -segment_list_size " . intval($ec86abab8d64506a["stream_info"]["delay_minutes"]) * 6 . " -segment_start_number " . $A39be01b3516c1f6 . " -segment_format_options \"mpegts_flags=+initial_discontinuity:mpegts_copyts=1\" -segment_list_type m3u8 -segment_list_flags +live+delete -segment_list \"" . DELAY_PATH . intval($F406b49979220eef) . "_.m3u8\" \"" . DELAY_PATH . intval($F406b49979220eef) . "_%d.ts\" ";
                    }

                    $D9b987f651b8748e = $ec86abab8d64506a["stream_info"]["delay_minutes"] * 60;
                    if(0 >= $A39be01b3516c1f6) {
                    } else {
                        $D9b987f651b8748e -= ($A39be01b3516c1f6 - 1) * 10;
                        if($D9b987f651b8748e > 0) {
                        } else {
                            $D9b987f651b8748e = 0;
                        }

                    }

                }

                $Da09a93dae0132d2 .= " >/dev/null 2>>" . STREAMS_PATH . intval($F406b49979220eef) . ".errors & echo \$! > " . STREAMS_PATH . intval($F406b49979220eef) . "_.pid";
                $Da09a93dae0132d2 = str_replace(array( "{FETCH_OPTIONS}", "{GEN_PTS}", "{STREAM_SOURCE}", "{DRM}", "{MAP}", "{READ_NATIVE}", "{CONCAT}", "{AAC_FILTER}", "{GPU}", "{INPUT_CODEC}", "{LOGO}", "{LLOD}" ), array( (empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"]) ? $ebc25dac16a0b737 : ""), (empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"]) ? $f162d58da2774327 : ""), escapeshellarg($Ec8b1368ea3efc46), (empty($ec86abab8d64506a['stream_info']['custom_ffmpeg']) ? $ffmpegCommand : ''), (empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"]) ? $ba788faef875d62c : ""), (empty($ec86abab8d64506a["stream_info"]["custom_ffmpeg"]) ? $c912f2883c281a40 : ""), ($ec86abab8d64506a["stream_info"]["type_key"] == "created_live" && !$ec86abab8d64506a["server_info"]["parent_id"] ? "-safe 0 -f concat" : ""), (!stristr($a78b1adac3f9cef3["container"], "flv") && $a78b1adac3f9cef3["codecs"]["audio"]["codec_name"] == "aac" && $ec86abab8d64506a["stream_info"]["transcode_attributes"]["-acodec"] == "copy" ? "-bsf:a aac_adtstoasc" : ""), $dc24c4d060ea41d1, $cf6b5aed6b8efff3, $Dd38b5440b2a8e5e, $a9e3903534330054 ), $Da09a93dae0132d2);
                shell_exec($Da09a93dae0132d2);
                file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.ffmpeg", $Da09a93dae0132d2);
                $A6236b8f3b6a4fa6 = openssl_random_pseudo_bytes(16);
                file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.key", $A6236b8f3b6a4fa6);
                $d1a68a552c331e27 = openssl_cipher_iv_length("AES-128-CBC");
                $Edea45df53db7e29 = openssl_random_pseudo_bytes($d1a68a552c331e27);
                file_put_contents(STREAMS_PATH . $F406b49979220eef . "_.iv", $Edea45df53db7e29);
                $C9bc783135eb4c9a = intval(file_get_contents(STREAMS_PATH . $F406b49979220eef . "_.pid"));
                if($ec86abab8d64506a["stream_info"]["tv_archive_server_id"] != SERVER_ID) {
                } else {
                    shell_exec(PHP_BIN . " " . CLI_PATH . "archive.php " . intval($F406b49979220eef) . " >/dev/null 2>/dev/null & echo \$!");
                }

                if($ec86abab8d64506a["stream_info"]["vframes_server_id"] != SERVER_ID) {
                } else {
                    self::BFea096FeAA65371($F406b49979220eef);
                }

                $ec827caf57be6a8c = 0 < $ec86abab8d64506a["stream_info"]["delay_minutes"] && !$ec86abab8d64506a["server_info"]["parent_id"];
                $B3f129c174d3e629 = ($ec827caf57be6a8c ? time() + $D9b987f651b8748e : 0);
                if(!$ec86abab8d64506a["stream_info"]["enable_transcode"]) {
                } else {
                    $a78b1adac3f9cef3 = array(  );
                }

                $Ad02ae10bac3dcf8 = 0;
                $dd0f4f3fe359e5ed = $C9a0c05f77ac7134 = $ad32affe4034958a = null;
                if(!$a78b1adac3f9cef3) {
                } else {
                    $Ad02ae10bac3dcf8 = intval(self::Bac7c5E5598B5bE9($a78b1adac3f9cef3));
                    $dd0f4f3fe359e5ed = ($a78b1adac3f9cef3["codecs"]["audio"]["codec_name"] ?: null);
                    $C9a0c05f77ac7134 = ($a78b1adac3f9cef3["codecs"]["video"]["codec_name"] ?: null);
                    $ad32affe4034958a = ($a78b1adac3f9cef3["codecs"]["video"]["height"] ?: null);
                    if(!$ad32affe4034958a) {
                    } else {
                        $ad32affe4034958a = self::DeAAAe249682c563(array( 240, 360, 480, 576, 720, 1080, 1440, 2160 ), $ad32affe4034958a);
                    }

                }

                self::$db->query("UPDATE `streams_servers` SET `delay_available_at` = ?,`to_analyze` = 0,`stream_started` = ?,`stream_info` = ?,`audio_codec` = ?, `video_codec` = ?, `resolution` = ?,`compatible` = ?,`stream_status` = 2,`pid` = ?,`progress_info` = ?,`current_source` = ? WHERE `stream_id` = ? AND `server_id` = ?", $B3f129c174d3e629, time(), json_encode($a78b1adac3f9cef3), $dd0f4f3fe359e5ed, $C9a0c05f77ac7134, $ad32affe4034958a, $Ad02ae10bac3dcf8, $C9bc783135eb4c9a, json_encode(array(  )), $a3139b983eda1cac, $F406b49979220eef, SERVER_ID);
                self::f4B3E09bF5Bd2D1a($F406b49979220eef);
                $ceab2b4321bbd078 = (!$ec827caf57be6a8c ? STREAMS_PATH . $F406b49979220eef . "_.m3u8" : DELAY_PATH . $F406b49979220eef . "_.m3u8");
                return array( "main_pid" => $C9bc783135eb4c9a, "stream_source" => $B4a9521e91817105, "delay_enabled" => $ec827caf57be6a8c, "parent_id" => $ec86abab8d64506a["server_info"]["parent_id"], "delay_start_at" => $B3f129c174d3e629, "playlist" => $ceab2b4321bbd078, "transcode" => $ec86abab8d64506a["stream_info"]["enable_transcode"], "offset" => $a00c3f35d74bbd03 );
            } else {
                return false;
            }

        } else {
            return false;
        }

    }

    public static function a115Ad222b4807c6($C8bc0687ba286e27, $fa0a01276df197ee)
    {
        if(substr($C8bc0687ba286e27, 0, 3) == "-i ") {
            return -1;
        }

        return 1;
    }

    public static function d35eb0cAf279f87A($e1b26b4f192006ab, $Eb49e051e67718d4, $b3b256939cb18212)
    {
        $F0e839083d6bad06 = array(  );
        if(empty($e1b26b4f192006ab)) {
        } else {
            foreach($e1b26b4f192006ab as $ae7a5eddfc2bd505 => $b63baafc65051506) {
                if($b63baafc65051506["argument_cat"] == $b3b256939cb18212 && (is_null($b63baafc65051506["argument_wprotocol"]) || stristr($Eb49e051e67718d4, $b63baafc65051506["argument_wprotocol"]) || is_null($Eb49e051e67718d4))) {
                    if($b63baafc65051506["argument_key"] != "cookie") {
                    } else {
                        $b63baafc65051506["value"] = self::C6450632B43A00Ab($b63baafc65051506["value"]);
                    }

                    if($b63baafc65051506["argument_type"] == "text") {
                        $F0e839083d6bad06[] = sprintf($b63baafc65051506["argument_cmd"], $b63baafc65051506["value"]);
                    } else {
                        $F0e839083d6bad06[] = $b63baafc65051506["argument_cmd"];
                    }

                }

            }
        }

        return $F0e839083d6bad06;
    }

    public static function B48a07A014b415AE($C0bfb6f59411e70d)
    {
        $e79e964422a7dd43 = array(  );
        foreach($C0bfb6f59411e70d as $A6236b8f3b6a4fa6 => $b63baafc65051506) {
            if(!($A6236b8f3b6a4fa6 == "gpu" || $A6236b8f3b6a4fa6 == "software_decoding" || $A6236b8f3b6a4fa6 == "16")) {
                if(!isset($b63baafc65051506["cmd"])) {
                } else {
                    $C0bfb6f59411e70d[$A6236b8f3b6a4fa6] = $b63baafc65051506 = $b63baafc65051506["cmd"];
                }

                if(!preg_match("/-filter_complex \"(.*?)\"/", $b63baafc65051506, $B450ac40aba9585c)) {
                } else {
                    $C0bfb6f59411e70d[$A6236b8f3b6a4fa6] = trim(str_replace($B450ac40aba9585c[0], "", $C0bfb6f59411e70d[$A6236b8f3b6a4fa6]));
                    $e79e964422a7dd43[] = $B450ac40aba9585c[1];
                }

            }

        }
        if(empty($e79e964422a7dd43)) {
        } else {
            $C0bfb6f59411e70d[] = "-filter_complex \"" . implode(",", $e79e964422a7dd43) . "\"";
        }

        $e3e38557f6e0ca65 = array(  );
        foreach($C0bfb6f59411e70d as $A6236b8f3b6a4fa6 => $f246735a0eff9a0b) {
            if($A6236b8f3b6a4fa6 != "gpu" && $A6236b8f3b6a4fa6 != "software_decoding") {
                if(is_numeric($A6236b8f3b6a4fa6)) {
                    $e3e38557f6e0ca65[] = $f246735a0eff9a0b;
                } else {
                    $e3e38557f6e0ca65[] = $A6236b8f3b6a4fa6 . " " . $f246735a0eff9a0b;
                }

            }

        }
        $e3e38557f6e0ca65 = array_filter($e3e38557f6e0ca65);
        uasort($e3e38557f6e0ca65, array( "XUI", "customOrder" ));
        return array_map("trim", array_values(array_filter($e3e38557f6e0ca65)));
    }

    public static function f1e1B9F66064Da62($C872016bcd6efd74)
    {
        $Eb49e051e67718d4 = strtolower(substr($C872016bcd6efd74, 0, 4));
        if($Eb49e051e67718d4 == "rtmp") {
            if(!stristr($C872016bcd6efd74, "\$OPT")) {
            } else {
                $cb1ab16263efe52e = "rtmp://\$OPT:rtmp-raw=";
                $C872016bcd6efd74 = trim(substr($C872016bcd6efd74, stripos($C872016bcd6efd74, $cb1ab16263efe52e) + strlen($cb1ab16263efe52e)));
            }

            $C872016bcd6efd74 .= " live=1 timeout=10";
        } else {
            if($Eb49e051e67718d4 != "http") {
            } else {
                $E03e20a23373e0a1 = array( "livestream.com", "ustream.tv", "twitch.tv", "vimeo.com", "facebook.com", "dailymotion.com", "cnn.com", "edition.cnn.com", "youtube.com", "youtu.be" );
                $cda4942f6a29dde9 = str_ireplace("www.", "", parse_url($C872016bcd6efd74, PHP_URL_HOST));
                if(!in_array($cda4942f6a29dde9, $E03e20a23373e0a1)) {
                } else {
                    $E0a0508e8cc01c8b = trim(shell_exec(YOUTUBE_BIN . " " . escapeshellarg($C872016bcd6efd74) . " -q --get-url --skip-download -f best"));
                    list($C872016bcd6efd74) = explode("\n", $E0a0508e8cc01c8b);
                }

            }

        }

        return $C872016bcd6efd74;
    }

    public static function B0FfB302984A63F4($C872016bcd6efd74)
    {
        $Ad98ad71c0ef6ccc = parse_url($C872016bcd6efd74)["path"];
        $Dc149bf66b1a1417 = count(explode("/", $Ad98ad71c0ef6ccc));
        $Ab166a4b016aeac0 = array( "/\\/auth\\/(.*)\$/m" => 3, "/\\/play\\/(.*)\$/m" => 3, "/\\/play\\/(.*)\\/(.*)\$/m" => 4, "/\\/live\\/(.*)\\/(\\d+)\$/m" => 4, "/\\/live\\/(.*)\\/(\\d+)\\.(.*)\$/m" => 4, "/\\/(.*)\\/(.*)\\/(\\d+)\\.(.*)\$/m" => 4, "/\\/(.*)\\/(.*)\\/(\\d+)\$/m" => 4, "/\\/live\\/(.*)\\/(.*)\\/(\\d+)\\.(.*)\$/m" => 5, "/\\/live\\/(.*)\\/(.*)\\/(\\d+)\$/m" => 5 );
        foreach($Ab166a4b016aeac0 as $E84548734e5d92a1 => $Ea294bdc5b3574e7) {
            if($Dc149bf66b1a1417 != $Ea294bdc5b3574e7) {
            } else {
                preg_match($E84548734e5d92a1, $Ad98ad71c0ef6ccc, $B450ac40aba9585c);
                if(0 >= count($B450ac40aba9585c)) {
                } else {
                    return true;
                }

            }

        }
        return false;
    }

    public static function bc3B5F6b7E95EC13($Ccab564379a6ea90 = false)
    {
        if($Ccab564379a6ea90) {
        } else {
            $A1a1fb89e05ece47 = self::b8E8A18B5BFfaAc0("allowed_ips", 60);
            if($A1a1fb89e05ece47 === false) {
            } else {
                return $A1a1fb89e05ece47;
            }

        }

        $A928ec3c1450a252 = array( "127.0.0.1", $_SERVER["SERVER_ADDR"] );
        foreach(self::$rServers as $Febabbe2c8824ef7 => $D389304b0aa961c7) {
            if(empty($D389304b0aa961c7["whitelist_ips"])) {
            } else {
                $A928ec3c1450a252 = array_merge($A928ec3c1450a252, json_decode($D389304b0aa961c7["whitelist_ips"], true));
            }

            $A928ec3c1450a252[] = $D389304b0aa961c7["server_ip"];
            if(!$D389304b0aa961c7["private_ip"]) {
            } else {
                $A928ec3c1450a252[] = $D389304b0aa961c7["private_ip"];
            }

            foreach(explode(",", $D389304b0aa961c7["domain_name"]) as $f948824c538b45fa) {
                if(!filter_var($f948824c538b45fa, FILTER_VALIDATE_IP)) {
                } else {
                    $A928ec3c1450a252[] = $f948824c538b45fa;
                }

            }
        }
        if(empty(self::$rSettings["allowed_ips_admin"])) {
        } else {
            $A928ec3c1450a252 = array_merge($A928ec3c1450a252, explode(",", self::$rSettings["allowed_ips_admin"]));
        }

        self::f57D63497771D13E("allowed_ips", $A928ec3c1450a252);
        return array_unique($A928ec3c1450a252);
    }

    public static function da777e161952e14e($bd1be39635484df0 = null, $acbe824e2ac9c0ee = null, $Bd77acd7832839eb = null, $dbb984847b00fe78 = false, $f4ebadb1ab5af3eb = false, $f948824c538b45fa = "")
    {
        $Fa6244f1eb01dd64 = null;
        if(self::$rCached) {
            if(empty($Bd77acd7832839eb) && empty($bd1be39635484df0) && strlen($acbe824e2ac9c0ee) == 32) {
                if(self::$rSettings["case_sensitive_line"]) {
                    $bd1be39635484df0 = intval(file_get_contents(LINES_TMP_PATH . "line_t_" . $acbe824e2ac9c0ee));
                } else {
                    $bd1be39635484df0 = intval(file_get_contents(LINES_TMP_PATH . "line_t_" . strtolower($acbe824e2ac9c0ee)));
                }

            } else {
                if(!empty($acbe824e2ac9c0ee) && !empty($Bd77acd7832839eb)) {
                    if(self::$rSettings["case_sensitive_line"]) {
                        $bd1be39635484df0 = intval(file_get_contents(LINES_TMP_PATH . "line_c_" . $acbe824e2ac9c0ee . "_" . $Bd77acd7832839eb));
                    } else {
                        $bd1be39635484df0 = intval(file_get_contents(LINES_TMP_PATH . "line_c_" . strtolower($acbe824e2ac9c0ee) . "_" . strtolower($Bd77acd7832839eb)));
                    }

                } else {
                    if(!empty($bd1be39635484df0)) {
                    } else {
                        return false;
                    }

                }

            }

            if(!$bd1be39635484df0) {
            } else {
                $Fa6244f1eb01dd64 = igbinary_unserialize(file_get_contents(LINES_TMP_PATH . "line_i_" . $bd1be39635484df0));
            }

        } else {
            if(empty($Bd77acd7832839eb) && empty($bd1be39635484df0) && strlen($acbe824e2ac9c0ee) == 32) {
                self::$db->query("SELECT * FROM `lines` WHERE `is_mag` = 0 AND `is_e2` = 0 AND `access_token` = ? AND LENGTH(`access_token`) = 32", $acbe824e2ac9c0ee);
            } else {
                if(!empty($acbe824e2ac9c0ee) && !empty($Bd77acd7832839eb)) {
                    self::$db->query("SELECT `lines`.*, `mag_devices`.`token` AS `mag_token` FROM `lines` LEFT JOIN `mag_devices` ON `mag_devices`.`user_id` = `lines`.`id` WHERE `username` = ? AND `password` = ? LIMIT 1", $acbe824e2ac9c0ee, $Bd77acd7832839eb);
                } else {
                    if(!empty($bd1be39635484df0)) {
                        self::$db->query("SELECT `lines`.*, `mag_devices`.`token` AS `mag_token` FROM `lines` LEFT JOIN `mag_devices` ON `mag_devices`.`user_id` = `lines`.`id` WHERE `id` = ?", $bd1be39635484df0);
                    } else {
                        return false;
                    }

                }

            }

            if(0 >= self::$db->num_rows()) {
            } else {
                $Fa6244f1eb01dd64 = self::$db->get_row();
            }

        }

        if(!$Fa6244f1eb01dd64) {
            return false;
        }

        if(!self::$rCached) {
        } else {
            if(empty($Bd77acd7832839eb) && empty($bd1be39635484df0) && strlen($acbe824e2ac9c0ee) == 32) {
                if($acbe824e2ac9c0ee == $Fa6244f1eb01dd64["access_token"]) {
                } else {
                    return false;
                }

            } else {
                if(empty($acbe824e2ac9c0ee) || empty($Bd77acd7832839eb)) {
                } else {
                    if(!($acbe824e2ac9c0ee != $Fa6244f1eb01dd64["username"] || $Bd77acd7832839eb != $Fa6244f1eb01dd64["password"])) {
                    } else {
                        return false;
                    }

                }

            }

        }

        if(!(self::$rSettings["county_override_1st"] == 1 && empty($Fa6244f1eb01dd64["forced_country"]) && !empty($f948824c538b45fa) && $Fa6244f1eb01dd64["max_connections"] == 1)) {
        } else {
            $Fa6244f1eb01dd64["forced_country"] = self::cC702A498b38A03e($f948824c538b45fa)["registered_country"]["iso_code"];
            if(self::$rCached) {
                self::FED9AA3BEE0408a2("forced_country/" . $Fa6244f1eb01dd64["id"], $Fa6244f1eb01dd64["forced_country"]);
            } else {
                self::$db->query("UPDATE `lines` SET `forced_country` = ? WHERE `id` = ?", $Fa6244f1eb01dd64["forced_country"], $Fa6244f1eb01dd64["id"]);
            }

        }

        $Fa6244f1eb01dd64["bouquet"] = json_decode($Fa6244f1eb01dd64["bouquet"], true);
        $Fa6244f1eb01dd64["allowed_ips"] = @array_filter(@array_map("trim", @json_decode($Fa6244f1eb01dd64["allowed_ips"], true)));
        $Fa6244f1eb01dd64["allowed_ua"] = @array_filter(@array_map("trim", @json_decode($Fa6244f1eb01dd64["allowed_ua"], true)));
        $Fa6244f1eb01dd64["allowed_outputs"] = array_map("intval", json_decode($Fa6244f1eb01dd64["allowed_outputs"], true));
        $Fa6244f1eb01dd64["output_formats"] = array(  );
        if(self::$rCached) {
            foreach(igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . "output_formats")) as $e6002db131ca9d50) {
                if(!in_array(intval($e6002db131ca9d50["access_output_id"]), $Fa6244f1eb01dd64["allowed_outputs"])) {
                } else {
                    $Fa6244f1eb01dd64["output_formats"][] = $e6002db131ca9d50["output_key"];
                }

            }
        } else {
            self::$db->query("SELECT `access_output_id`, `output_key` FROM `output_formats`;");
            foreach(self::$db->get_rows() as $e6002db131ca9d50) {
                if(!in_array(intval($e6002db131ca9d50["access_output_id"]), $Fa6244f1eb01dd64["allowed_outputs"])) {
                } else {
                    $Fa6244f1eb01dd64["output_formats"][] = $e6002db131ca9d50["output_key"];
                }

            }
        }

        $Fa6244f1eb01dd64["con_isp_name"] = null;
        $Fa6244f1eb01dd64["isp_violate"] = 0;
        $Fa6244f1eb01dd64["isp_is_server"] = 0;
        if(self::$rSettings["show_isps"] != 1 || empty($f948824c538b45fa)) {
        } else {
            $F8ab19fd2429e672 = self::F286bE61Ff7929A5($f948824c538b45fa);
            if(!is_array($F8ab19fd2429e672)) {
            } else {
                if(empty($F8ab19fd2429e672["isp"])) {
                } else {
                    $Fa6244f1eb01dd64["con_isp_name"] = $F8ab19fd2429e672["isp"];
                    $Fa6244f1eb01dd64["isp_asn"] = $F8ab19fd2429e672["autonomous_system_number"];
                    $Fa6244f1eb01dd64["isp_violate"] = self::fEC8B525D7C2E3f2($Fa6244f1eb01dd64["con_isp_name"]);
                    if(self::$rSettings["block_svp"] != 1) {
                    } else {
                        $Fa6244f1eb01dd64["isp_is_server"] = intval(self::dc36537082Dfa860($Fa6244f1eb01dd64["isp_asn"]));
                    }

                }

            }

            if(!(!empty($Fa6244f1eb01dd64["con_isp_name"]) && self::$rSettings["enable_isp_lock"] == 1 && $Fa6244f1eb01dd64["is_stalker"] == 0 && $Fa6244f1eb01dd64["is_isplock"] == 1 && !empty($Fa6244f1eb01dd64["isp_desc"]) && strtolower($Fa6244f1eb01dd64["con_isp_name"]) != strtolower($Fa6244f1eb01dd64["isp_desc"]))) {
            } else {
                $Fa6244f1eb01dd64["isp_violate"] = 1;
            }

            if(!($Fa6244f1eb01dd64["isp_violate"] == 0 && strtolower($Fa6244f1eb01dd64["con_isp_name"]) != strtolower($Fa6244f1eb01dd64["isp_desc"]))) {
            } else {
                if(self::$rCached) {
                    self::FED9aa3beE0408A2("isp/" . $Fa6244f1eb01dd64["id"], json_encode(array( $Fa6244f1eb01dd64["con_isp_name"], $Fa6244f1eb01dd64["isp_asn"] )));
                } else {
                    self::$db->query("UPDATE `lines` SET `isp_desc` = ?, `as_number` = ? WHERE `id` = ?", $Fa6244f1eb01dd64["con_isp_name"], $Fa6244f1eb01dd64["isp_asn"], $Fa6244f1eb01dd64["id"]);
                }

            }

        }

        if(!$dbb984847b00fe78) {
        } else {
            $Be0c57ff33e795f9 = $d250cc1a8c616de7 = $f2fabd8f5c740af1 = $d5b4b70ea0a4facc = $Cfe1fe762b64b1c9 = $Db3c237a21ef88ad = array(  );
            foreach($Fa6244f1eb01dd64["bouquet"] as $A76532e4f616ce0c) {
                if(!isset(self::$rBouquets[$A76532e4f616ce0c]["streams"])) {
                } else {
                    $Cfe1fe762b64b1c9 = array_merge($Cfe1fe762b64b1c9, self::$rBouquets[$A76532e4f616ce0c]["streams"]);
                }

                if(!isset(self::$rBouquets[$A76532e4f616ce0c]["series"])) {
                } else {
                    $Db3c237a21ef88ad = array_merge($Db3c237a21ef88ad, self::$rBouquets[$A76532e4f616ce0c]["series"]);
                }

                if(!isset(self::$rBouquets[$A76532e4f616ce0c]["channels"])) {
                } else {
                    $Be0c57ff33e795f9 = array_merge($Be0c57ff33e795f9, self::$rBouquets[$A76532e4f616ce0c]["channels"]);
                }

                if(!isset(self::$rBouquets[$A76532e4f616ce0c]["movies"])) {
                } else {
                    $d250cc1a8c616de7 = array_merge($d250cc1a8c616de7, self::$rBouquets[$A76532e4f616ce0c]["movies"]);
                }

                if(!isset(self::$rBouquets[$A76532e4f616ce0c]["radios"])) {
                } else {
                    $f2fabd8f5c740af1 = array_merge($f2fabd8f5c740af1, self::$rBouquets[$A76532e4f616ce0c]["radios"]);
                }

            }
            $Fa6244f1eb01dd64["channel_ids"] = array_map("intval", array_unique($Cfe1fe762b64b1c9));
            $Fa6244f1eb01dd64["series_ids"] = array_map("intval", array_unique($Db3c237a21ef88ad));
            $Fa6244f1eb01dd64["vod_ids"] = array_map("intval", array_unique($d250cc1a8c616de7));
            $Fa6244f1eb01dd64["live_ids"] = array_map("intval", array_unique($Be0c57ff33e795f9));
            $Fa6244f1eb01dd64["radio_ids"] = array_map("intval", array_unique($f2fabd8f5c740af1));
        }

        $d48241a1d624496d = array(  );
        $F8e9444a5424b11c = igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . "category_map"));
        foreach($Fa6244f1eb01dd64["bouquet"] as $A76532e4f616ce0c) {
            $d48241a1d624496d = array_merge($d48241a1d624496d, ($F8e9444a5424b11c[$A76532e4f616ce0c] ?: array(  )));
        }
        $Fa6244f1eb01dd64["category_ids"] = array_values(array_unique($d48241a1d624496d));
        return $Fa6244f1eb01dd64;
    }

    public static function f3634Fe0Ad8FD43e()
    {
        $F0e839083d6bad06 = array(  );
        foreach(self::$rCategories as $Ca013c9cbacd21bb) {
            if(!$Ca013c9cbacd21bb["is_adult"]) {
            } else {
                $F0e839083d6bad06[] = intval($Ca013c9cbacd21bb["id"]);
            }

        }
        return $F0e839083d6bad06;
    }

    public static function a6BFF4BFB148007F($a3c11ac8e04f6243 = null, $e6f94ebbdd60ec68 = null, $dbb984847b00fe78 = false, $f2d284a41b72bcc2 = false, $f4ebadb1ab5af3eb = false)
    {
        if(empty($a3c11ac8e04f6243)) {
            self::$db->query("SELECT * FROM `mag_devices` WHERE `mac` = ?", base64_encode($e6f94ebbdd60ec68));
        } else {
            self::$db->query("SELECT * FROM `mag_devices` WHERE `mag_id` = ?", $a3c11ac8e04f6243);
        }

        if(0 >= self::$db->num_rows()) {
            return false;
        }

        $ffe47cf98f07c4ec = array(  );
        $ffe47cf98f07c4ec["mag_device"] = self::$db->get_row();
        $ffe47cf98f07c4ec["mag_device"]["mac"] = base64_decode($ffe47cf98f07c4ec["mag_device"]["mac"]);
        $ffe47cf98f07c4ec["user_info"] = array(  );
        if(!($Fa6244f1eb01dd64 = self::DA777E161952e14E($ffe47cf98f07c4ec["mag_device"]["user_id"], null, null, $dbb984847b00fe78, $f4ebadb1ab5af3eb))) {
        } else {
            $ffe47cf98f07c4ec["user_info"] = $Fa6244f1eb01dd64;
        }

        $ffe47cf98f07c4ec["pair_line_info"] = array(  );
        if(empty($ffe47cf98f07c4ec["user_info"])) {
        } else {
            $ffe47cf98f07c4ec["pair_line_info"] = array(  );
            if(is_null($ffe47cf98f07c4ec["user_info"]["pair_id"])) {
            } else {
                if(!($Fa6244f1eb01dd64 = self::da777E161952e14E($ffe47cf98f07c4ec["user_info"]["pair_id"], null, null, $dbb984847b00fe78, $f4ebadb1ab5af3eb))) {
                } else {
                    $ffe47cf98f07c4ec["pair_line_info"] = $Fa6244f1eb01dd64;
                }

            }

        }

        return $ffe47cf98f07c4ec;
    }

    public static function Dc57f48fbA2571De($e8a5b1f0a94ba857, $dbb984847b00fe78 = false, $f2d284a41b72bcc2 = false, $f4ebadb1ab5af3eb = false)
    {
        if(empty($e8a5b1f0a94ba857["device_id"])) {
            self::$db->query("SELECT * FROM `enigma2_devices` WHERE `mac` = ?", $e8a5b1f0a94ba857["mac"]);
        } else {
            self::$db->query("SELECT * FROM `enigma2_devices` WHERE `device_id` = ?", $e8a5b1f0a94ba857["device_id"]);
        }

        if(0 >= self::$db->num_rows()) {
            return false;
        }

        $F0e839083d6bad06 = array(  );
        $F0e839083d6bad06["enigma2"] = self::$db->get_row();
        $F0e839083d6bad06["user_info"] = array(  );
        if(!($Fa6244f1eb01dd64 = self::Da777E161952e14E($F0e839083d6bad06["enigma2"]["user_id"], null, null, $dbb984847b00fe78, $f4ebadb1ab5af3eb))) {
        } else {
            $F0e839083d6bad06["user_info"] = $Fa6244f1eb01dd64;
        }

        $F0e839083d6bad06["pair_line_info"] = array(  );
        if(empty($F0e839083d6bad06["user_info"])) {
        } else {
            $F0e839083d6bad06["pair_line_info"] = array(  );
            if(is_null($F0e839083d6bad06["user_info"]["pair_id"])) {
            } else {
                if(!($Fa6244f1eb01dd64 = self::dA777e161952E14E($F0e839083d6bad06["user_info"]["pair_id"], null, null, $dbb984847b00fe78, $f4ebadb1ab5af3eb))) {
                } else {
                    $F0e839083d6bad06["pair_line_info"] = $Fa6244f1eb01dd64;
                }

            }

        }

        return $F0e839083d6bad06;
    }

    public static function BB64267BDacD3eD3()
    {
        $C872016bcd6efd74 = self::$rServers[SERVER_ID]["rtmp_mport_url"] . "stat";
        $bfc74934344829d1 = stream_context_create(array( "http" => array( "timeout" => 1 ) ));
        $cd5c6c29e7f82ba1 = file_get_contents($C872016bcd6efd74, false, $bfc74934344829d1);
        return json_decode(json_encode(simplexml_load_string($cd5c6c29e7f82ba1, "SimpleXMLElement", LIBXML_NOCDATA)), true);
    }

    public static function aF5402f6c7640d77($Aca7d30698e4aee9, $dfb3b943ccd19427 = true, $D8cf92ea98f77000 = true)
    {
        if(!empty($Aca7d30698e4aee9)) {
            if(!self::$rSettings["redis_handler"] || is_object(self::$redis)) {
            } else {
                self::B1Fa34C33256656C();
            }

            if(is_array($Aca7d30698e4aee9)) {
            } else {
                if(!self::$rSettings["redis_handler"]) {
                    if(strlen(strval($Aca7d30698e4aee9)) == 32) {
                        self::$db->query("SELECT * FROM `lines_live` WHERE `uuid` = ?", $Aca7d30698e4aee9);
                    } else {
                        self::$db->query("SELECT * FROM `lines_live` WHERE `activity_id` = ?", $Aca7d30698e4aee9);
                    }

                    $Aca7d30698e4aee9 = self::$db->get_row();
                } else {
                    $Aca7d30698e4aee9 = igbinary_unserialize(self::$redis->get($Aca7d30698e4aee9));
                }

            }

            if(is_array($Aca7d30698e4aee9)) {
                if($Aca7d30698e4aee9["container"] == "rtmp") {
                    if($Aca7d30698e4aee9["server_id"] == SERVER_ID) {
                        shell_exec("wget --timeout=2 -O /dev/null -o /dev/null \"" . self::$rServers[SERVER_ID]["rtmp_mport_url"] . "control/drop/client?clientid=" . intval($Aca7d30698e4aee9["pid"]) . "\" >/dev/null 2>/dev/null &");
                    } else {
                        if(self::$rSettings["redis_handler"]) {
                            self::dECa5A90130d62fB($Aca7d30698e4aee9["pid"], $Aca7d30698e4aee9["server_id"], 1);
                        } else {
                            self::$db->query("INSERT INTO `signals` (`pid`,`server_id`,`rtmp`,`time`) VALUES(?,?,?,UNIX_TIMESTAMP())", $Aca7d30698e4aee9["pid"], $Aca7d30698e4aee9["server_id"], 1);
                        }

                    }

                } else {
                    if($Aca7d30698e4aee9["container"] == "hls") {
                        if(!(!$dfb3b943ccd19427 && $D8cf92ea98f77000 && $Aca7d30698e4aee9["hls_end"] == 0)) {
                        } else {
                            if(self::$rSettings["redis_handler"]) {
                                self::EC3b97C9c9D6DE75($Aca7d30698e4aee9, array(  ), "close");
                            } else {
                                self::$db->query("UPDATE `lines_live` SET `hls_end` = 1 WHERE `activity_id` = ?", $Aca7d30698e4aee9["activity_id"]);
                            }

                            @unlink(CONS_TMP_PATH . $Aca7d30698e4aee9["stream_id"] . "/" . $Aca7d30698e4aee9["uuid"]);
                        }

                    } else {
                        if($Aca7d30698e4aee9["server_id"] == SERVER_ID) {
                            if(!($Aca7d30698e4aee9["pid"] != getmypid() && is_numeric($Aca7d30698e4aee9["pid"]) && 0 < $Aca7d30698e4aee9["pid"])) {
                            } else {
                                posix_kill(intval($Aca7d30698e4aee9["pid"]), 9);
                            }

                        } else {
                            if(self::$rSettings["redis_handler"]) {
                                self::DEca5A90130D62fb($Aca7d30698e4aee9["pid"], $Aca7d30698e4aee9["server_id"], 0);
                            } else {
                                self::$db->query("INSERT INTO `signals` (`pid`,`server_id`,`time`) VALUES(?,?,UNIX_TIMESTAMP())", $Aca7d30698e4aee9["pid"], $Aca7d30698e4aee9["server_id"]);
                            }

                        }

                    }

                }

                if($Aca7d30698e4aee9["server_id"] != SERVER_ID) {
                } else {
                    @unlink(CONS_TMP_PATH . $Aca7d30698e4aee9["uuid"]);
                }

                if(!$dfb3b943ccd19427) {
                } else {
                    if($Aca7d30698e4aee9["server_id"] != SERVER_ID) {
                    } else {
                        @unlink(CONS_TMP_PATH . $Aca7d30698e4aee9["stream_id"] . "/" . $Aca7d30698e4aee9["uuid"]);
                    }

                    if(self::$rSettings["redis_handler"]) {
                        $D29a485fe871ffa7 = self::$redis->multi();
                        $D29a485fe871ffa7->zRem("LINE#" . $Aca7d30698e4aee9["identity"], $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->zRem("LINE_ALL#" . $Aca7d30698e4aee9["identity"], $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->zRem("STREAM#" . $Aca7d30698e4aee9["stream_id"], $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->zRem("SERVER#" . $Aca7d30698e4aee9["server_id"], $Aca7d30698e4aee9["uuid"]);
                        if(!$Aca7d30698e4aee9["user_id"]) {
                        } else {
                            $D29a485fe871ffa7->zRem("SERVER_LINES#" . $Aca7d30698e4aee9["server_id"], $Aca7d30698e4aee9["uuid"]);
                        }

                        if(!$Aca7d30698e4aee9["proxy_id"]) {
                        } else {
                            $D29a485fe871ffa7->zRem("PROXY#" . $Aca7d30698e4aee9["proxy_id"], $Aca7d30698e4aee9["uuid"]);
                        }

                        $D29a485fe871ffa7->del($Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->zRem("CONNECTIONS", $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->zRem("LIVE", $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->sRem("ENDED", $Aca7d30698e4aee9["uuid"]);
                        $D29a485fe871ffa7->exec();
                    } else {
                        self::$db->query("DELETE FROM `lines_live` WHERE `activity_id` = ?", $Aca7d30698e4aee9["activity_id"]);
                    }

                }

                self::B030a003e5121Bb9($Aca7d30698e4aee9["server_id"], $Aca7d30698e4aee9["proxy_id"], $Aca7d30698e4aee9["user_id"], $Aca7d30698e4aee9["stream_id"], $Aca7d30698e4aee9["date_start"], $Aca7d30698e4aee9["user_agent"], $Aca7d30698e4aee9["user_ip"], $Aca7d30698e4aee9["container"], $Aca7d30698e4aee9["geoip_country_code"], $Aca7d30698e4aee9["isp"], $Aca7d30698e4aee9["external_device"], $Aca7d30698e4aee9["divergence"], $Aca7d30698e4aee9["hmac_id"], $Aca7d30698e4aee9["hmac_identifier"]);
                return true;
            }

            return false;
        }

        return false;
    }

    public static function b030A003E5121bb9($Febabbe2c8824ef7, $D87e787493e333c9, $bd1be39635484df0, $F406b49979220eef, $C44790c0f26a1be9, $Aad6c6e14125eaaf, $f948824c538b45fa, $fd63fe799d5bb48b, $C631ef3bc70e8162, $e1d468af55c05d13, $F8adc44356eb6883 = "", $B7a36a864a079f85 = 0, $bdb2ddd4ecdd1b80 = null, $b8dd59035d02db34 = "")
    {
        if(self::$rSettings["save_closed_connection"] != 0) {
            if(!($Febabbe2c8824ef7 && $bd1be39635484df0 && $F406b49979220eef)) {
            } else {
                $Aca7d30698e4aee9 = array( "user_id" => intval($bd1be39635484df0), "stream_id" => intval($F406b49979220eef), "server_id" => intval($Febabbe2c8824ef7), "proxy_id" => intval($D87e787493e333c9), "date_start" => intval($C44790c0f26a1be9), "user_agent" => $Aad6c6e14125eaaf, "user_ip" => htmlentities($f948824c538b45fa), "date_end" => time(), "container" => $fd63fe799d5bb48b, "geoip_country_code" => $C631ef3bc70e8162, "isp" => $e1d468af55c05d13, "external_device" => htmlentities($F8adc44356eb6883), "divergence" => intval($B7a36a864a079f85), "hmac_id" => $bdb2ddd4ecdd1b80, "hmac_identifier" => $b8dd59035d02db34 );
                file_put_contents(LOGS_TMP_PATH . "activity", base64_encode(json_encode($Aca7d30698e4aee9)) . "\n", FILE_APPEND | LOCK_EX);
            }

        } else {
            return null;
        }

    }

    public static function d6fF2E80Ea1135Cc($F406b49979220eef, $Febabbe2c8824ef7, $D8c713e735e3b9e9, $a3139b983eda1cac = "")
    {
        if(self::$rSettings["save_restart_logs"] != 0) {
            $C9340e84b67c26bc = array( "server_id" => $Febabbe2c8824ef7, "stream_id" => $F406b49979220eef, "action" => $D8c713e735e3b9e9, "source" => $a3139b983eda1cac, "time" => time() );
            file_put_contents(LOGS_TMP_PATH . "stream_log.log", base64_encode(json_encode($C9340e84b67c26bc)) . "\n", FILE_APPEND);
        } else {
            return null;
        }

    }

    public static function c7C5a996e94Deb7a($ceab2b4321bbd078, $Fa384802c78a5242 = 0, $D9743a9ccbe477bc = 10)
    {
        if(!file_exists($ceab2b4321bbd078)) {
        } else {
            $a3139b983eda1cac = file_get_contents($ceab2b4321bbd078);
            if(!preg_match_all("/(.*?).ts/", $a3139b983eda1cac, $B450ac40aba9585c)) {
            } else {
                if(0 < $Fa384802c78a5242) {
                    $D96fa3e9ea424411 = intval($Fa384802c78a5242 / (($D9743a9ccbe477bc ?: 1)));
                    return array_slice($B450ac40aba9585c[0], -1 * $D96fa3e9ea424411);
                }

                if($Fa384802c78a5242 == -1) {
                    return $B450ac40aba9585c[0];
                }

                preg_match("/_(.*)\\./", array_pop($B450ac40aba9585c[0]), $D7ddbe3499948206);
                return $D7ddbe3499948206[1];
            }

        }

    }

    public static function A6ca77820D2C9BFA($A9d6d84e421fd1b6, $Bd77acd7832839eb, $F406b49979220eef, $f1904f9127c5a5f7)
    {
        if(!file_exists($A9d6d84e421fd1b6)) {
        } else {
            $a3139b983eda1cac = file_get_contents($A9d6d84e421fd1b6);
            if(!preg_match_all("/(.*?)\\.ts/", $a3139b983eda1cac, $B450ac40aba9585c)) {
            } else {
                foreach($B450ac40aba9585c[0] as $ac494ebf186f351d) {
                    if($f1904f9127c5a5f7) {
                        $a3139b983eda1cac = str_replace($ac494ebf186f351d, "/admin/live?extension=m3u8&segment=" . $ac494ebf186f351d . "&uitoken=" . $f1904f9127c5a5f7, $a3139b983eda1cac);
                    } else {
                        $a3139b983eda1cac = str_replace($ac494ebf186f351d, "/admin/live?password=" . $Bd77acd7832839eb . "&extension=m3u8&segment=" . $ac494ebf186f351d . "&stream=" . $F406b49979220eef, $a3139b983eda1cac);
                    }

                }
                return $a3139b983eda1cac;
            }

        }

        return false;
    }

    public static function f3C7bb9C3857ACC1($Aad6c6e14125eaaf, $F0e839083d6bad06 = false)
    {
        $Aad6c6e14125eaaf = strtolower($Aad6c6e14125eaaf);
        $f68edb23af34b180 = false;
        foreach(self::$rBlockedUA as $A6236b8f3b6a4fa6 => $E6e28fc55c49c83e) {
            if($E6e28fc55c49c83e["exact_match"] == 1) {
                if($E6e28fc55c49c83e["blocked_ua"] != $Aad6c6e14125eaaf) {
                } else {
                    $f68edb23af34b180 = $A6236b8f3b6a4fa6;
                    goto label62;
                }

            } else {
                if(!stristr($Aad6c6e14125eaaf, $E6e28fc55c49c83e["blocked_ua"])) {
                } else {
                    $f68edb23af34b180 = $A6236b8f3b6a4fa6;
                    goto label62;
                }

            }

        }
label62:
        if(0 >= $f68edb23af34b180) {
        } else {
            self::$db->query("UPDATE `blocked_uas` SET `attempts_blocked` = `attempts_blocked`+1 WHERE `id` = ?", $f68edb23af34b180);
            if($F0e839083d6bad06) {
                return true;
            }

            exit();
        }

    }

    public static function F2Ff8fEb7bE42950($C9bc783135eb4c9a, $F406b49979220eef, $D65d9f41c5e6bd3a = PHP_BIN)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe") && strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), basename($D65d9f41c5e6bd3a)) === 0)) {
            } else {
                $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
                if(!($ee09c213e06fb6a4 == "XUI[" . $F406b49979220eef . "]" || $ee09c213e06fb6a4 == "XUIProxy[" . $F406b49979220eef . "]")) {
                } else {
                    return true;
                }

            }

            return false;
        }

        return false;
    }

    public static function cbD4B957Eb668be1($C9bc783135eb4c9a, $F406b49979220eef, $D65d9f41c5e6bd3a = PHP_BIN)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe") && strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), basename($D65d9f41c5e6bd3a)) === 0)) {
            } else {
                $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
                if($ee09c213e06fb6a4 != "Thumbnail[" . $F406b49979220eef . "]") {
                } else {
                    return true;
                }

            }

            return false;
        }

        return false;
    }

    public static function A09664FEef64CAf6($C9bc783135eb4c9a, $F406b49979220eef, $D65d9f41c5e6bd3a = PHP_BIN)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe") && strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), basename($D65d9f41c5e6bd3a)) === 0)) {
            } else {
                $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
                if($ee09c213e06fb6a4 != "TVArchive[" . $F406b49979220eef . "]") {
                } else {
                    return true;
                }

            }

            return false;
        }

        return false;
    }

    public static function eC0f11398c70CF9b($C9bc783135eb4c9a, $F406b49979220eef)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe"))) {
            } else {
                $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
                if($ee09c213e06fb6a4 != "XUIDelay[" . $F406b49979220eef . "]") {
                } else {
                    return true;
                }

            }

            return false;
        }

        return false;
    }

    public static function C1881793892D8aAa($C9bc783135eb4c9a, $F406b49979220eef)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe"))) {
            } else {
                if(strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), "ffmpeg") === 0) {
                    $ee09c213e06fb6a4 = trim(file_get_contents("/proc/" . $C9bc783135eb4c9a . "/cmdline"));
                    if(!(stristr($ee09c213e06fb6a4, "/" . $F406b49979220eef . "_.m3u8") || stristr($ee09c213e06fb6a4, "/" . $F406b49979220eef . "_%d.ts"))) {
                    } else {
                        return true;
                    }

                }
				//FIX: no else here
				{
                    if(strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), "php") !== 0) {
                    } else {
                        return true;
                    }

                }

            }

            return false;
        }

        return false;
    }

    public static function b4e6aedDB0556B50($C9bc783135eb4c9a, $D65d9f41c5e6bd3a = null)
    {
        if(!empty($C9bc783135eb4c9a)) {
            clearstatcache(true);
            if(!(file_exists("/proc/" . $C9bc783135eb4c9a) && is_readable("/proc/" . $C9bc783135eb4c9a . "/exe") && strpos(basename(readlink("/proc/" . $C9bc783135eb4c9a . "/exe")), basename($D65d9f41c5e6bd3a)) === 0) && $D65d9f41c5e6bd3a) {
                return false;
            }

            return true;
        }

        return false;
    }

    public static function f193794b89895e30($ceab2b4321bbd078, $C9bc783135eb4c9a)
    {
        return (self::b4e6AEddB0556B50($C9bc783135eb4c9a, "ffmpeg") || self::B4E6AedDB0556B50($C9bc783135eb4c9a, "php")) && file_exists($ceab2b4321bbd078);
    }

    public static function findKeyframe($Cbe369c06b885f65)
    {
        $a08482baba738caa = 188;
        $d50149f2fef22214 = $D93a5566c25b5f9e = 0;
        $C82217e74ea57551 = false;
        if(!file_exists($Cbe369c06b885f65)) {
        } else {
            $B46437bb4ca294b7 = fopen($Cbe369c06b885f65, "rb");
            if(!$B46437bb4ca294b7) {
            } else {
                while(!feof($B46437bb4ca294b7)) {
                    if($C82217e74ea57551) {
                    } else {
                        $A62f806280db460c = fread($B46437bb4ca294b7, $a08482baba738caa);
                        $e1c8d7424985c883 = fread($B46437bb4ca294b7, $a08482baba738caa);
						for ($bb850694dd82a471 = 0; $bb850694dd82a471 < strlen($A62f806280db460c); $bb850694dd82a471++) {
							$D2b5a2e9bd249da9 = unpack('N', substr($A62f806280db460c, $bb850694dd82a471, 4))[1];
							$fea2b57023b37241 = unpack('N', substr($e1c8d7424985c883, $bb850694dd82a471, 4))[1];
							$bb6905283150c8e4 = ((($D2b5a2e9bd249da9 >> 24) & 255) == 71) && ((($fea2b57023b37241 >> 24) & 255) == 71);

							if ($bb6905283150c8e4) {
								$C82217e74ea57551 = true;
								$D93a5566c25b5f9e = $bb850694dd82a471;
								fseek($B46437bb4ca294b7, $bb850694dd82a471);

								break;
							}
						}
                    }

                    $D09119fd1170a002 .= fread($B46437bb4ca294b7, $a08482baba738caa * 64 - strlen($D09119fd1170a002));
                    if(empty($D09119fd1170a002)) {
                    } else {
                        foreach(str_split($D09119fd1170a002, $a08482baba738caa) as $ef6d4591ba3f5353) {
							$dbe1856fcb506541 = unpack('N', substr($ef6d4591ba3f5353, 0, 4))[1];
							$bb6905283150c8e4 = ($dbe1856fcb506541 >> 24) & 255;
                            if($bb6905283150c8e4 != 71) {
                            } else {
                                if(substr($ef6d4591ba3f5353, 6, 4) == "\xb0" . '' . "\r" . '' . "\0" . '' . "\x1") {
                                    $d50149f2fef22214 = $D93a5566c25b5f9e;
                                } else {
                                    $Acf2d89c7b556743 = $dbe1856fcb506541 >> 4 & 3;
									if (($Acf2d89c7b556743 & 2) === 2 && 0 < $d50149f2fef22214 && unpack('C', $ef6d4591ba3f5353[4])[1] == 7 && substr($ef6d4591ba3f5353, 4, 2) == "\x07" . 'P') {
										goto label35;
									}
                                }
                            }
                            $D93a5566c25b5f9e += strlen($ef6d4591ba3f5353);
                        }
                    }
                    $D09119fd1170a002 = "";
                }
label35:                fclose($B46437bb4ca294b7);
            }
        }
        return $d50149f2fef22214;
    }

    public static function E5FaE7E1F73587E9()
    {
        return $_SERVER["REMOTE_ADDR"];
    }

    public static function C8E00a77ad9a4Df7($b3b256939cb18212, $Ad98ad71c0ef6ccc, $Dedae48122a41b6d = null)
    {
        clearstatcache();
        if(file_exists($Ad98ad71c0ef6ccc)) {
            switch($b3b256939cb18212) {
                case "movie":
                    if(is_null($Dedae48122a41b6d)) {
                    } else {
                        sscanf($Dedae48122a41b6d, "%d:%d:%d", $b9820ae02333c553, $faf04b21ea07ead2, $Ff9f678c048b6c89);
                        $ba0e000b3ce55b83 = (isset($Ff9f678c048b6c89) ? $b9820ae02333c553 * 3600 + $faf04b21ea07ead2 * 60 + $Ff9f678c048b6c89 : $b9820ae02333c553 * 60 + $faf04b21ea07ead2);
                        $Bb025a725052941c = round((filesize($Ad98ad71c0ef6ccc) * 0.008) / (($ba0e000b3ce55b83 ?: 1)));
                    }

                    break;
                case "live":
                    $B46437bb4ca294b7 = fopen($Ad98ad71c0ef6ccc, "r");
                    $db270cd50d0d944e = array(  );
                    while(!feof($B46437bb4ca294b7)) {
                        $Fcb66b83cdf12a23 = trim(fgets($B46437bb4ca294b7));
                        if(!stristr($Fcb66b83cdf12a23, "EXTINF")) {
                        } else {
                            list($D84298ab90023fb2, $Ff9f678c048b6c89) = explode(":", $Fcb66b83cdf12a23);
                            $Ff9f678c048b6c89 = rtrim($Ff9f678c048b6c89, ",");
                            if($Ff9f678c048b6c89 > 0) {
                                $f3eaf2a4536fe012 = trim(fgets($B46437bb4ca294b7));
                                if(file_exists(dirname($Ad98ad71c0ef6ccc) . "/" . $f3eaf2a4536fe012)) {
                                    $Feb95145fac6ad11 = filesize(dirname($Ad98ad71c0ef6ccc) . "/" . $f3eaf2a4536fe012) * 0.008;
                                    $db270cd50d0d944e[] = $Feb95145fac6ad11 / (($Ff9f678c048b6c89 ?: 1));
                                } else {
                                    fclose($B46437bb4ca294b7);
                                    return false;
                                }

                            }

                        }

                    }
                    fclose($B46437bb4ca294b7);
                    $Bb025a725052941c = (0 < count($db270cd50d0d944e) ? round(array_sum($db270cd50d0d944e) / count($db270cd50d0d944e)) : 0);
                    break;
            }
            return (0 < $Bb025a725052941c ? $Bb025a725052941c : false);
        }

        return false;
    }

    public static function f286be61FF7929A5($f948824c538b45fa)
    {
        if(!empty($f948824c538b45fa)) {
            if(!file_exists(CONS_TMP_PATH . md5($f948824c538b45fa) . "_isp")) {
                $C631ef3bc70e8162 = new MaxMind\Db\Reader(GEOISP_BIN);
                $D6e4a78203de4e0e = $C631ef3bc70e8162->get($f948824c538b45fa);
                $C631ef3bc70e8162->close();
                if(!$D6e4a78203de4e0e) {
                } else {
                    file_put_contents(CONS_TMP_PATH . md5($f948824c538b45fa) . "_isp", json_encode($D6e4a78203de4e0e));
                }

                return $D6e4a78203de4e0e;
            }

            return json_decode(file_get_contents(CONS_TMP_PATH . md5($f948824c538b45fa) . "_isp"), true);
        }

        return false;
    }

    public static function fEC8b525D7C2e3F2($Cd9807eaa9e37044)
    {
        foreach(self::$rBlockedISP as $e1d468af55c05d13) {
            if(strtolower($Cd9807eaa9e37044) != strtolower($e1d468af55c05d13["isp"])) {
            } else {
                return intval($e1d468af55c05d13["blocked"]);
            }

        }
        return 0;
    }

    public static function dC36537082Dfa860($F2707498525e66ec)
    {
        return in_array($F2707498525e66ec, self::$rBlockedServers);
    }

    public static function cc702a498b38A03E($f948824c538b45fa)
    {
        if(!empty($f948824c538b45fa)) {
            if(!file_exists(CONS_TMP_PATH . md5($f948824c538b45fa) . "_geo2")) {
                $C631ef3bc70e8162 = new MaxMind\Db\Reader(GEOLITE2_BIN);
                $D6e4a78203de4e0e = $C631ef3bc70e8162->get($f948824c538b45fa);
                $C631ef3bc70e8162->close();
                if(!$D6e4a78203de4e0e) {
                } else {
                    file_put_contents(CONS_TMP_PATH . md5($f948824c538b45fa) . "_geo2", json_encode($D6e4a78203de4e0e));
                }

                return $D6e4a78203de4e0e;
            }

            return json_decode(file_get_contents(CONS_TMP_PATH . md5($f948824c538b45fa) . "_geo2"), true);
        }

        return false;
    }

    public static function cFd51fD9192f29B4()
    {
        $dd0cf46f6bb530d6 = 0;
        exec("ps -fp \$(pgrep -u xui)", $B3dd6de7b6ec6ab8, $B02d3144ed68be42);
        foreach($B3dd6de7b6ec6ab8 as $c1ee87fab767ddf8) {
            $D401f744de8fd552 = explode(" ", preg_replace("!\\s+!", " ", trim($c1ee87fab767ddf8)));
            if(!($D401f744de8fd552[8] == "nginx:" && $D401f744de8fd552[9] == "master")) {
            } else {
                $dd0cf46f6bb530d6++;
            }

        }
        return 0 < $dd0cf46f6bb530d6;
    }

    public static function B71932026503Ff64($be5ba4cadfaa9e4e = null)
    {
        $F0e839083d6bad06 = array( "serial" => null, "expiration" => null, "subject" => null, "path" => null );
        if($be5ba4cadfaa9e4e) {
        } else {
            $B4be4a8f577f2584 = explode("\n", file_get_contents(BIN_PATH . "nginx/conf/ssl.conf"));
            foreach($B4be4a8f577f2584 as $Fcb66b83cdf12a23) {
                if(stripos($Fcb66b83cdf12a23, "ssl_certificate ") === false) {
                } else {
                    $be5ba4cadfaa9e4e = rtrim(trim(explode("ssl_certificate ", $Fcb66b83cdf12a23)[1]), ";");
                    break;
                }

            }
        }

        if(!$be5ba4cadfaa9e4e) {
        } else {
            $F0e839083d6bad06["path"] = pathinfo($be5ba4cadfaa9e4e)["dirname"];
            exec("openssl x509 -serial -enddate -subject -noout -in " . escapeshellarg($be5ba4cadfaa9e4e), $B3dd6de7b6ec6ab8, $B02d3144ed68be42);
            foreach($B3dd6de7b6ec6ab8 as $Fcb66b83cdf12a23) {
                if(stripos($Fcb66b83cdf12a23, "serial=") !== false) {
                    $F0e839083d6bad06["serial"] = trim(explode("serial=", $Fcb66b83cdf12a23)[1]);
                } else {
                    if(stripos($Fcb66b83cdf12a23, "subject=") !== false) {
                        $F0e839083d6bad06["subject"] = trim(explode("subject=", $Fcb66b83cdf12a23)[1]);
                    } else {
                        if(stripos($Fcb66b83cdf12a23, "notAfter=") === false) {
                        } else {
                            $F0e839083d6bad06["expiration"] = strtotime(trim(explode("notAfter=", $Fcb66b83cdf12a23)[1]));
                        }

                    }

                }

            }
        }

        return $F0e839083d6bad06;
    }

    public static function B72de7d5cceb6457($d7fe474a085c0a96, $b3b256939cb18212 = null)
    {
        if(!(0 < strlen($d7fe474a085c0a96) && substr(strtolower($d7fe474a085c0a96), 0, 4) == "http")) {
        } else {
            $cd451bbbad23b46c = pathinfo($d7fe474a085c0a96);
            $C9230cd5475b7a37 = $cd451bbbad23b46c["extension"];
            if($C9230cd5475b7a37) {
            } else {
                $Cfbe9ac6ba1cbbf1 = getimagesize($d7fe474a085c0a96);
                if(!$Cfbe9ac6ba1cbbf1["mime"]) {
                } else {
                    list(, $C9230cd5475b7a37) = explode("/", $Cfbe9ac6ba1cbbf1["mime"]);
                }

            }

            if(!in_array(strtolower($C9230cd5475b7a37), array( "jpg", "jpeg", "png" ))) {
            } else {
                $ef05f681c33d575c = Xui\Functions::encrypt($d7fe474a085c0a96, self::$rSettings["live_streaming_pass"], OPENSSL_EXTRA);
                $eddf479125d28564 = IMAGES_PATH . $ef05f681c33d575c . "." . $C9230cd5475b7a37;
                if(file_exists($eddf479125d28564)) {
                    return "s:" . SERVER_ID . ":/images/" . $ef05f681c33d575c . "." . $C9230cd5475b7a37;
                }

                $f6ff5524c7f94bba = curl_init();
                curl_setopt($f6ff5524c7f94bba, CURLOPT_URL, $d7fe474a085c0a96);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_CONNECTTIMEOUT, 5);
                curl_setopt($f6ff5524c7f94bba, CURLOPT_TIMEOUT, 5);
                $C9340e84b67c26bc = curl_exec($f6ff5524c7f94bba);
                if(0 >= strlen($C9340e84b67c26bc)) {
                } else {
                    $Ad98ad71c0ef6ccc = IMAGES_PATH . $ef05f681c33d575c . "." . $C9230cd5475b7a37;
                    file_put_contents($Ad98ad71c0ef6ccc, $C9340e84b67c26bc);
                    if(!file_exists($Ad98ad71c0ef6ccc)) {
                    } else {
                        return "s:" . SERVER_ID . ":/images/" . $ef05f681c33d575c . "." . $C9230cd5475b7a37;
                    }

                }

            }

        }

        return $d7fe474a085c0a96;
    }

    public static function DaF4f1f157471512($B4028729cdacb3d8, $aaacfe063ab10d32, $a6f0d681acf1fe52, $F6a8f43749f8584e)
    {
        if($a6f0d681acf1fe52 != 0) {
        } else {
            $a6f0d681acf1fe52 = $B4028729cdacb3d8;
        }

        if($F6a8f43749f8584e != 0) {
        } else {
            $F6a8f43749f8584e = $aaacfe063ab10d32;
        }

        $a04474f023dc1c68 = $a6f0d681acf1fe52 / (($B4028729cdacb3d8 ?: 1));
        $cf7d15a29948dacf = $F6a8f43749f8584e / (($aaacfe063ab10d32 ?: 1));
        $Fb15a5fdf99b1796 = min($a04474f023dc1c68, $cf7d15a29948dacf);
        if($Fb15a5fdf99b1796 < 1) {
            $Ceedda0ddac3db37 = (int) $B4028729cdacb3d8 * $Fb15a5fdf99b1796;
            $ae0dbad44eb1a940 = (int) $aaacfe063ab10d32 * $Fb15a5fdf99b1796;
        } else {
            $ae0dbad44eb1a940 = $aaacfe063ab10d32;
            $Ceedda0ddac3db37 = $B4028729cdacb3d8;
        }

        return array( "height" => round($ae0dbad44eb1a940, 0), "width" => round($Ceedda0ddac3db37, 0) );
    }

    public static function aeA25BDfDDa27923($C872016bcd6efd74)
    {
        $cb1ab16263efe52e = "/^(?:ftp|https?|feed)?:?\\/\\/(?:(?:(?:[\\w\\.\\-\\+!\$&'\\(\\)*\\+,;=]|%[0-9a-f]{2})+:)*" . "\n" . "        (?:[\\w\\.\\-\\+%!\$&'\\(\\)*\\+,;=]|%[0-9a-f]{2})+@)?(?:" . "\n" . "        (?:[a-z0-9\\-\\.]|%[0-9a-f]{2})+|(?:\\[(?:[0-9a-f]{0,4}:)*(?:[0-9a-f]{0,4})\\]))(?::[0-9]+)?(?:[\\/|\\?]" . "\n" . "        (?:[\\w#!:\\.\\?\\+\\|=&@\$'~*,;\\/\\(\\)\\[\\]\\-]|%[0-9a-f]{2})*)?\$/xi";
        return (bool) preg_match($cb1ab16263efe52e, $C872016bcd6efd74);
    }

    public static function aA4519454537FB39($d7fe474a085c0a96, $b3b256939cb18212)
    {
        if($b3b256939cb18212 == 1 || $b3b256939cb18212 == 5 || $b3b256939cb18212 == 4) {
            $a5b1327eb00169dd = 96;
            $c0eaf12fec828c61 = 32;
        } else {
            if($b3b256939cb18212 == 2) {
                $a5b1327eb00169dd = 58;
                $c0eaf12fec828c61 = 32;
            } else {
                if($b3b256939cb18212 == 5) {
                    $a5b1327eb00169dd = 32;
                    $c0eaf12fec828c61 = 64;
                } else {
                    return false;
                }

            }

        }

        list($fd63fe799d5bb48b) = explode(".", strtolower(pathinfo($d7fe474a085c0a96)["extension"]));
        if(!in_array($fd63fe799d5bb48b, array( "png", "jpg", "jpeg" ))) {
        } else {
            $ec584ff5df0d2c13 = IMAGES_PATH . "admin/" . md5($d7fe474a085c0a96) . "_" . $a5b1327eb00169dd . "_" . $c0eaf12fec828c61 . "." . $fd63fe799d5bb48b;
            if(file_exists($ec584ff5df0d2c13)) {
            } else {
                if(self::aeA25BdFDDA27923($d7fe474a085c0a96)) {
                    $f1b61b29b87aad5e = $d7fe474a085c0a96;
                } else {
                    $f1b61b29b87aad5e = IMAGES_PATH . basename($d7fe474a085c0a96);
                }

                list($c0a5726982ae6fd3, $E2f04f5fc09f138e) = getimagesize($f1b61b29b87aad5e);
                $fd0b8f34873ae10a = self::DAF4F1f157471512($c0a5726982ae6fd3, $E2f04f5fc09f138e, $a5b1327eb00169dd, $c0eaf12fec828c61);
                if(!($fd0b8f34873ae10a["width"] && $fd0b8f34873ae10a["height"])) {
                } else {
                    $ea0d6d14f5c69211 = imagecreatetruecolor($fd0b8f34873ae10a["width"], $fd0b8f34873ae10a["height"]);
                    if($fd63fe799d5bb48b == "png") {
                        $d7fe474a085c0a96 = imagecreatefrompng($f1b61b29b87aad5e);
                    } else {
                        $d7fe474a085c0a96 = imagecreatefromjpeg($f1b61b29b87aad5e);
                    }

                    imagealphablending($ea0d6d14f5c69211, false);
                    imagesavealpha($ea0d6d14f5c69211, true);
                    imagecopyresampled($ea0d6d14f5c69211, $d7fe474a085c0a96, 0, 0, 0, 0, $fd0b8f34873ae10a["width"], $fd0b8f34873ae10a["height"], $c0a5726982ae6fd3, $E2f04f5fc09f138e);
                    imagepng($ea0d6d14f5c69211, $ec584ff5df0d2c13);
                }

            }

            if(!file_exists($ec584ff5df0d2c13)) {
            } else {
                return true;
            }

        }

        return false;
    }

    public static function FEe5178736bD8E11($C872016bcd6efd74, $F1dd6518cbef6692 = null)
    {
        if(substr($C872016bcd6efd74, 0, 2) == "s:") {
            $D401f744de8fd552 = explode(":", $C872016bcd6efd74, 3);
            $cb5ca3f1650dc050 = self::e8690349a9A3Be1F(intval($D401f744de8fd552[1]), $F1dd6518cbef6692);
            if($cb5ca3f1650dc050) {
                return $cb5ca3f1650dc050 . "images/" . basename($C872016bcd6efd74);
            }

            return "";
        }

        return $C872016bcd6efd74;
    }

    public static function f6263D88491cb16F($F406b49979220eef, $B580e3ab58bec516 = false)
    {
        self::$db->query("SELECT `type`,`movie_propeties`,`epg_id`,`channel_id` FROM `streams` WHERE `id` = ?", $F406b49979220eef);
        if(0 >= self::$db->num_rows()) {
            return array(  );
        }

        $C9340e84b67c26bc = self::$db->get_row();
        if($C9340e84b67c26bc["type"] != 2) {
            if($B580e3ab58bec516) {
                self::$db->query("SELECT * FROM `epg_data` WHERE `epg_id` = ? AND `channel_id` = ? AND `end` >= ?;", $C9340e84b67c26bc["epg_id"], $C9340e84b67c26bc["channel_id"], date("Y-m-d H:i:00"));
            } else {
                self::$db->query("SELECT * FROM `epg_data` WHERE `epg_id` = ? AND `channel_id` = ?;", $C9340e84b67c26bc["epg_id"], $C9340e84b67c26bc["channel_id"]);
            }

            return self::$db->get_rows();
        }

        return json_decode($C9340e84b67c26bc["movie_propeties"], true);
    }

    public static function E8690349a9a3Be1f($Febabbe2c8824ef7 = null, $F1dd6518cbef6692 = null)
    {
        $a4e3d2574fdc3312 = null;
        if(isset($Febabbe2c8824ef7)) {
        } else {
            $Febabbe2c8824ef7 = SERVER_ID;
        }

        if($F1dd6518cbef6692) {
            $Eb49e051e67718d4 = $F1dd6518cbef6692;
        } else {
            if(isset($_SERVER["SERVER_PORT"]) && self::$rSettings["keep_protocol"]) {
                $Eb49e051e67718d4 = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https" : "http");
            } else {
                $Eb49e051e67718d4 = self::$rServers[$Febabbe2c8824ef7]["server_protocol"];
            }

        }

        if(!self::$rServers[$Febabbe2c8824ef7]) {
        } else {
            if(!self::$rServers[$Febabbe2c8824ef7]["enable_proxy"]) {
            } else {
                $b58bd05c3af64fc0 = array_keys(self::getProxies($Febabbe2c8824ef7));
                if(count($b58bd05c3af64fc0) != 0) {
                } else {
                    $b58bd05c3af64fc0 = array_keys(self::getProxies($Febabbe2c8824ef7, false));
                }

                if(count($b58bd05c3af64fc0) != 0) {
                    $a4e3d2574fdc3312 = $Febabbe2c8824ef7;
                    $Febabbe2c8824ef7 = $b58bd05c3af64fc0[array_rand($b58bd05c3af64fc0)];
                } else {
                    return "";
                }

            }

            $cda4942f6a29dde9 = (defined("host") ? HOST : null);
            if($cda4942f6a29dde9 && in_array(strtolower($cda4942f6a29dde9), array_map("strtolower", self::$rServers[$Febabbe2c8824ef7]["domains"]["urls"]))) {
                $c4537dbba77895b5 = $cda4942f6a29dde9;
            } else {
                $c4537dbba77895b5 = (empty(self::$rServers[$Febabbe2c8824ef7]["domain_name"]) ? self::$rServers[$Febabbe2c8824ef7]["server_ip"] : explode(",", self::$rServers[$Febabbe2c8824ef7]["domain_name"])[0]);
            }

            $cb5ca3f1650dc050 = $Eb49e051e67718d4 . "://" . $c4537dbba77895b5 . ":" . self::$rServers[$Febabbe2c8824ef7][$Eb49e051e67718d4 . "_broadcast_port"] . "/";
            if(!(self::$rServers[$Febabbe2c8824ef7]["server_type"] == 1 && $a4e3d2574fdc3312 && self::$rServers[$a4e3d2574fdc3312]["is_main"] == 0)) {
            } else {
                $cb5ca3f1650dc050 .= md5($Febabbe2c8824ef7 . "_" . $a4e3d2574fdc3312 . "_" . OPENSSL_EXTRA) . "/";
            }

            return $cb5ca3f1650dc050;
        }

    }

    public static function a6b36277FD1b5f7b($C872016bcd6efd74, $cf167c76be4869e6 = true)
    {
        $f74067e3e6261c8c = curl_init();
        curl_setopt($f74067e3e6261c8c, CURLOPT_CONNECTTIMEOUT, 3);
        curl_setopt($f74067e3e6261c8c, CURLOPT_TIMEOUT, 3);
        curl_setopt($f74067e3e6261c8c, CURLOPT_URL, $C872016bcd6efd74);
        curl_setopt($f74067e3e6261c8c, CURLOPT_USERAGENT, "XUI/" . XUI_VERSION);
        curl_setopt($f74067e3e6261c8c, CURLOPT_RETURNTRANSFER, $cf167c76be4869e6);
        $F0e839083d6bad06 = curl_exec($f74067e3e6261c8c);
        curl_close($f74067e3e6261c8c);
        return $F0e839083d6bad06;
    }

    public static function D4FD267729BE0B4c($b3b256939cb18212, $b5a737ca72e39dd3, $A9bf46153aca78f8)
    {
        $ae5173988fdc4f17 = intval(self::$rSettings["max_simultaneous_downloads"]);
        if($ae5173988fdc4f17 != 0) {
            if(!$b5a737ca72e39dd3["is_restreamer"]) {
                $c1fae1225d7a1a4b = FLOOD_TMP_PATH . $b5a737ca72e39dd3["id"] . "_downloads";
                if(file_exists($c1fae1225d7a1a4b) && time() - filemtime($c1fae1225d7a1a4b) < 10) {
                    $B04f310379ef63c4[$b3b256939cb18212] = array(  );
                    foreach(json_decode(file_get_contents($c1fae1225d7a1a4b), true)[$b3b256939cb18212] as $C9bc783135eb4c9a) {
                        if(!(self::b4e6aEDdB0556B50($C9bc783135eb4c9a, "php-fpm") && $C9bc783135eb4c9a != $A9bf46153aca78f8)) {
                        } else {
                            $B04f310379ef63c4[$b3b256939cb18212][] = $C9bc783135eb4c9a;
                        }

                    }
                } else {
                    $B04f310379ef63c4 = array( "epg" => array(  ), "playlist" => array(  ) );
                }

                $dc7eee7b027e9581 = false;
                if(count($B04f310379ef63c4[$b3b256939cb18212]) >= $ae5173988fdc4f17) {
                } else {
                    $B04f310379ef63c4[$b3b256939cb18212][] = $A9bf46153aca78f8;
                    $dc7eee7b027e9581 = true;
                }

                file_put_contents($c1fae1225d7a1a4b, json_encode($B04f310379ef63c4), LOCK_EX);
                return $dc7eee7b027e9581;
            } else {
                return true;
            }

        } else {
            return true;
        }

    }

    public static function dD2e270D6Ca444bD($b3b256939cb18212, $b5a737ca72e39dd3, $A9bf46153aca78f8)
    {
        if(intval(self::$rSettings["max_simultaneous_downloads"]) != 0) {
            if(!$b5a737ca72e39dd3["is_restreamer"]) {
                $c1fae1225d7a1a4b = FLOOD_TMP_PATH . $b5a737ca72e39dd3["id"] . "_downloads";
                if(file_exists($c1fae1225d7a1a4b)) {
                    $B04f310379ef63c4[$b3b256939cb18212] = array(  );
                    foreach(json_decode(file_get_contents($c1fae1225d7a1a4b), true)[$b3b256939cb18212] as $C9bc783135eb4c9a) {
                        if(!(self::B4E6aEdDb0556b50($C9bc783135eb4c9a, "php-fpm") && $C9bc783135eb4c9a != $A9bf46153aca78f8)) {
                        } else {
                            $B04f310379ef63c4[$b3b256939cb18212][] = $C9bc783135eb4c9a;
                        }

                    }
                } else {
                    $B04f310379ef63c4 = array( "epg" => array(  ), "playlist" => array(  ) );
                }

                file_put_contents($c1fae1225d7a1a4b, json_encode($B04f310379ef63c4), LOCK_EX);
            } else {
                return null;
            }

        } else {
            return null;
        }

    }

    public static function d807F63b50Bfc5aB($b5a737ca72e39dd3, $f948824c538b45fa = null)
    {
        if(self::$rSettings["auth_flood_limit"] != 0) {
            if(!$b5a737ca72e39dd3["is_restreamer"]) {
                if($f948824c538b45fa) {
                } else {
                    $f948824c538b45fa = self::e5Fae7e1f73587e9();
                }

                if(!(empty($f948824c538b45fa) || in_array($f948824c538b45fa, self::$rAllowedIPs))) {
                    $c60c280543a58d19 = array_filter(array_unique(explode(",", self::$rSettings["flood_ips_exclude"])));
                    if(!in_array($f948824c538b45fa, $c60c280543a58d19)) {
                        $D40a5f410da95611 = FLOOD_TMP_PATH . intval($b5a737ca72e39dd3["id"]) . "_" . $f948824c538b45fa;
                        if(file_exists($D40a5f410da95611)) {
                            $B04f310379ef63c4 = json_decode(file_get_contents($D40a5f410da95611), true);
                            if(!(isset($B04f310379ef63c4["block_until"]) && time() < $B04f310379ef63c4["block_until"])) {
                            } else {
                                sleep(intval(self::$rSettings["auth_flood_sleep"]));
                            }

                            $c10534e6def8bc1b = self::$rSettings["auth_flood_seconds"];
                            $ae5173988fdc4f17 = self::$rSettings["auth_flood_limit"];
                            $B04f310379ef63c4["attempts"] = self::EBE4bF8d5981F479($B04f310379ef63c4["attempts"], $c10534e6def8bc1b, true);
                            if($ae5173988fdc4f17 > count($B04f310379ef63c4["attempts"])) {
                            } else {
                                $B04f310379ef63c4["block_until"] = time() + intval(self::$rSettings["auth_flood_seconds"]);
                            }

                            $B04f310379ef63c4["attempts"][] = time();
                            file_put_contents($D40a5f410da95611, json_encode($B04f310379ef63c4), LOCK_EX);
                        } else {
                            file_put_contents($D40a5f410da95611, json_encode(array( "attempts" => array( time() ) )), LOCK_EX);
                        }

                    } else {
                        return null;
                    }

                } else {
                    return null;
                }

            } else {
                return null;
            }

        } else {
            return null;
        }

    }

    public static function C050e1dfF2eBf708($bba4824306df4e1f = false)
    {
        $c1fae1225d7a1a4b = ($bba4824306df4e1f ? "proxy_capacity" : "servers_capacity");
        if(!(self::$rSettings["redis_handler"] && $bba4824306df4e1f && self::$rSettings["split_by"] == "maxclients")) {
        } else {
            self::$rSettings["split_by"] == "guar_band";
        }

        if(self::$rSettings["redis_handler"]) {
            $Fdb08a8c6c6e3410 = array(  );
            $E19f83e1ea54eb2d = self::$redis->multi();
            foreach(array_keys(self::$rServers) as $Febabbe2c8824ef7) {
                if(!self::$rServers[$Febabbe2c8824ef7]["server_online"]) {
                } else {
                    $E19f83e1ea54eb2d->zCard((($bba4824306df4e1f ? "PROXY#" : "SERVER#")) . $Febabbe2c8824ef7);
                }

            }
            $Cba70d6d90f5ab9b = $E19f83e1ea54eb2d->exec();
            $bb850694dd82a471 = 0;
            foreach(array_keys(self::$rServers) as $Febabbe2c8824ef7) {
                if(!self::$rServers[$Febabbe2c8824ef7]["server_online"]) {
                } else {
                    $Fdb08a8c6c6e3410[$Febabbe2c8824ef7] = array( "online_clients" => ($Cba70d6d90f5ab9b[$bb850694dd82a471] ?: 0) );
                    $bb850694dd82a471++;
                }

            }
        } else {
            if($bba4824306df4e1f) {
                self::$db->query("SELECT `proxy_id`, COUNT(*) AS `online_clients` FROM `lines_live` WHERE `proxy_id` <> 0 AND `hls_end` = 0 GROUP BY `proxy_id`;");
                $Fdb08a8c6c6e3410 = self::$db->get_rows(true, "proxy_id");
            } else {
                self::$db->query("SELECT `server_id`, COUNT(*) AS `online_clients` FROM `lines_live` WHERE `server_id` <> 0 AND `hls_end` = 0 GROUP BY `server_id`;");
                $Fdb08a8c6c6e3410 = self::$db->get_rows(true, "server_id");
            }

        }

        if(self::$rSettings["split_by"] == "band") {
            $bf6ee92193de1b66 = array(  );
            foreach(array_keys(self::$rServers) as $Febabbe2c8824ef7) {
                $E52db2a0b5fc557f = json_decode(self::$rServers[$Febabbe2c8824ef7]["server_hardware"], true);
                if(!empty($E52db2a0b5fc557f["network_speed"])) {
                    $bf6ee92193de1b66[$Febabbe2c8824ef7] = (float) $E52db2a0b5fc557f["network_speed"];
                } else {
                    if(0 < self::$rServers[$Febabbe2c8824ef7]["network_guaranteed_speed"]) {
                        $bf6ee92193de1b66[$Febabbe2c8824ef7] = self::$rServers[$Febabbe2c8824ef7]["network_guaranteed_speed"];
                    } else {
                        $bf6ee92193de1b66[$Febabbe2c8824ef7] = 1000;
                    }

                }

            }
            foreach($Fdb08a8c6c6e3410 as $Febabbe2c8824ef7 => $e6002db131ca9d50) {
                $E4885505579adcbd = intval(self::$rServers[$Febabbe2c8824ef7]["watchdog"]["bytes_sent"] / 125000);
                $Fdb08a8c6c6e3410[$Febabbe2c8824ef7]["capacity"] = (float) ($E4885505579adcbd / (($bf6ee92193de1b66[$Febabbe2c8824ef7] ?: 1000)));
            }
        } else {
            if(self::$rSettings["split_by"] == "maxclients") {
                foreach($Fdb08a8c6c6e3410 as $Febabbe2c8824ef7 => $e6002db131ca9d50) {
                    $Fdb08a8c6c6e3410[$Febabbe2c8824ef7]["capacity"] = (float) ($e6002db131ca9d50["online_clients"] / ((self::$rServers[$Febabbe2c8824ef7]["total_clients"] ?: 1)));
                }
            } else {
                if(self::$rSettings["split_by"] == "guar_band") {
                    foreach($Fdb08a8c6c6e3410 as $Febabbe2c8824ef7 => $e6002db131ca9d50) {
                        $E4885505579adcbd = intval(self::$rServers[$Febabbe2c8824ef7]["watchdog"]["bytes_sent"] / 125000);
                        $Fdb08a8c6c6e3410[$Febabbe2c8824ef7]["capacity"] = (float) ($E4885505579adcbd / ((self::$rServers[$Febabbe2c8824ef7]["network_guaranteed_speed"] ?: 1)));
                    }
                } else {
                    foreach($Fdb08a8c6c6e3410 as $Febabbe2c8824ef7 => $e6002db131ca9d50) {
                        $Fdb08a8c6c6e3410[$Febabbe2c8824ef7]["capacity"] = $e6002db131ca9d50["online_clients"];
                    }
                }

            }

        }

        file_put_contents(CACHE_TMP_PATH . $c1fae1225d7a1a4b, json_encode($Fdb08a8c6c6e3410), LOCK_EX);
        return $Fdb08a8c6c6e3410;
    }

    public static function BB8Dfc5ad7CE5245($Febabbe2c8824ef7 = null, $bd1be39635484df0 = null, $F406b49979220eef = null)
    {
        if(!self::$rSettings["redis_handler"] || is_object(self::$redis)) {
        } else {
            self::B1FA34C33256656c();
        }

        if(self::$rSettings["redis_handler"]) {
            if($Febabbe2c8824ef7) {
                $bcab5dbc46da608d = self::$redis->zRangeByScore("SERVER#" . $Febabbe2c8824ef7, "-inf", "+inf");
            } else {
                if($bd1be39635484df0) {
                    $bcab5dbc46da608d = self::$redis->zRangeByScore("LINE#" . $bd1be39635484df0, "-inf", "+inf");
                } else {
                    if($F406b49979220eef) {
                        $bcab5dbc46da608d = self::$redis->zRangeByScore("STREAM#" . $F406b49979220eef, "-inf", "+inf");
                    } else {
                        $bcab5dbc46da608d = self::$redis->zRangeByScore("LIVE", "-inf", "+inf");
                    }

                }

            }

            if(0 >= count($bcab5dbc46da608d)) {
            } else {
                return array( $bcab5dbc46da608d, array_map("igbinary_unserialize", self::$redis->mGet($bcab5dbc46da608d)) );
            }

        } else {
            $e5a7a21f7f0d12c1 = array(  );
            if(empty($Febabbe2c8824ef7)) {
            } else {
                $e5a7a21f7f0d12c1[] = "t1.server_id = " . intval($Febabbe2c8824ef7);
            }

            if(empty($bd1be39635484df0)) {
            } else {
                $e5a7a21f7f0d12c1[] = "t1.user_id = " . intval($bd1be39635484df0);
            }

            $Fc14a82c38b5593d = "";
            if(0 >= count($e5a7a21f7f0d12c1)) {
            } else {
                $Fc14a82c38b5593d = "WHERE " . implode(" AND ", $e5a7a21f7f0d12c1);
            }

            $E84548734e5d92a1 = "SELECT t2.*,t3.*,t5.bitrate,t1.*,t1.uuid AS `uuid` FROM `lines_live` t1 LEFT JOIN `lines` t2 ON t2.id = t1.user_id LEFT JOIN `streams` t3 ON t3.id = t1.stream_id LEFT JOIN `streams_servers` t5 ON t5.stream_id = t1.stream_id AND t5.server_id = t1.server_id " . $Fc14a82c38b5593d . " ORDER BY t1.activity_id ASC";
            self::$db->query($E84548734e5d92a1);
            return self::$db->get_rows(true, "user_id", false);
        }

    }

    public static function getEnded()
    {
        if(is_object(self::$redis)) {
        } else {
            self::B1fa34c33256656C();
        }

        $bcab5dbc46da608d = self::$redis->sMembers("ENDED");
        if(0 >= count($bcab5dbc46da608d)) {
        } else {
            return array_map("igbinary_unserialize", self::$redis->mGet($bcab5dbc46da608d));
        }

    }

    public static function getBouquetMap($F406b49979220eef)
    {
        $A403ecc4ef694984 = igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . "bouquet_map"));
        $F0e839083d6bad06 = ($A403ecc4ef694984[$F406b49979220eef] ?: array(  ));
        unset($A403ecc4ef694984);
        return $F0e839083d6bad06;
    }

    public static function F4B3E09Bf5BD2D1A($F406b49979220eef, $Ccab564379a6ea90 = false)
    {
        if(self::$rCached) {
            self::$db->query("SELECT COUNT(*) AS `count` FROM `signals` WHERE `server_id` = ? AND `cache` = 1 AND `custom_data` = ?;", self::Cb9035eA20EE71A8(), json_encode(array( "type" => "update_stream", "id" => $F406b49979220eef )));
            if(self::$db->get_row()["count"] != 0) {
            } else {
                self::$db->query("INSERT INTO `signals`(`server_id`, `cache`, `time`, `custom_data`) VALUES(?, 1, ?, ?);", self::cB9035ea20eE71a8(), time(), json_encode(array( "type" => "update_stream", "id" => $F406b49979220eef )));
            }

            return true;
        }

        return false;
    }

    public static function updateStreams($E08d14aeb9b1814a)
    {
        if(self::$rCached) {
            self::$db->query("SELECT COUNT(*) AS `count` FROM `signals` WHERE `server_id` = ? AND `cache` = 1 AND `custom_data` = ?;", self::cb9035eA20Ee71A8(), json_encode(array( "type" => "update_streams", "id" => $E08d14aeb9b1814a )));
            if(self::$db->get_row()["count"] != 0) {
            } else {
                self::$db->query("INSERT INTO `signals`(`server_id`, `cache`, `time`, `custom_data`) VALUES(?, 1, ?, ?);", self::Cb9035EA20eE71A8(), time(), json_encode(array( "type" => "update_streams", "id" => $E08d14aeb9b1814a )));
            }

            return true;
        }

        return false;
    }

    public static function cD019EDaeeFC8e27($bd1be39635484df0, $Ccab564379a6ea90 = false)
    {
        self::CFBB7666Af3e96b3($bd1be39635484df0, $Ccab564379a6ea90);
    }

    public static function deleteLines($D63d516e302507f5, $Ccab564379a6ea90 = false)
    {
        self::updateLines($D63d516e302507f5);
    }

    public static function cFBB7666aF3e96B3($bd1be39635484df0, $Ccab564379a6ea90 = false)
    {
        if(self::$rCached) {
            self::$db->query("SELECT COUNT(*) AS `count` FROM `signals` WHERE `server_id` = ? AND `cache` = 1 AND `custom_data` = ?;", self::CB9035eA20EE71A8(), json_encode(array( "type" => "update_line", "id" => $bd1be39635484df0 )));
            if(self::$db->get_row()["count"] != 0) {
            } else {
                self::$db->query("INSERT INTO `signals`(`server_id`, `cache`, `time`, `custom_data`) VALUES(?, 1, ?, ?);", self::CB9035EA20ee71a8(), time(), json_encode(array( "type" => "update_line", "id" => $bd1be39635484df0 )));
            }

            return true;
        }

        return false;
    }

    public static function updateLines($D63d516e302507f5)
    {
        if(self::$rCached) {
            self::$db->query("SELECT COUNT(*) AS `count` FROM `signals` WHERE `server_id` = ? AND `cache` = 1 AND `custom_data` = ?;", self::cB9035EA20Ee71a8(), json_encode(array( "type" => "update_lines", "id" => $D63d516e302507f5 )));
            if(self::$db->get_row()["count"] != 0) {
            } else {
                self::$db->query("INSERT INTO `signals`(`server_id`, `cache`, `time`, `custom_data`) VALUES(?, 1, ?, ?);", self::Cb9035EA20ee71a8(), time(), json_encode(array( "type" => "update_lines", "id" => $D63d516e302507f5 )));
            }

            return true;
        }

        return false;
    }

    public static function CB9035EA20ee71A8()
    {
        foreach(self::$rServers as $Febabbe2c8824ef7 => $e5a4b7c8f931534f) {
            if(!$e5a4b7c8f931534f["is_main"]) {
            } else {
                return $Febabbe2c8824ef7;
            }

        }
    }

    public static function c2E3a0c6f300075B($F406b49979220eef, $D78f8663d9ca3249)
    {
        $Fe60432f29968ade = $b572978c16e12aab = array(  );
        if(!file_exists(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef))) {
        } else {
            $b572978c16e12aab = igbinary_unserialize(file_get_contents(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef)));
        }

        foreach($b572978c16e12aab as $C9bc783135eb4c9a) {
            if(!self::b4E6aeDDB0556B50($C9bc783135eb4c9a, "php-fpm")) {
            } else {
                $Fe60432f29968ade[] = $C9bc783135eb4c9a;
            }

        }
        if(in_array($Fe60432f29968ade, $D78f8663d9ca3249)) {
        } else {
            $Fe60432f29968ade[] = $D78f8663d9ca3249;
        }

        file_put_contents(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef), igbinary_serialize($Fe60432f29968ade));
    }

    public static function Ff8AB8D97E7272E6($F406b49979220eef, $C9bc783135eb4c9a)
    {
        $Fe60432f29968ade = array(  );
        foreach((igbinary_unserialize(file_get_contents(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef))) ?: array(  )) as $Cacd938c24b4cb33) {
            if(!(self::b4E6AeDdB0556B50($Cacd938c24b4cb33, "php-fpm") && $C9bc783135eb4c9a != $Cacd938c24b4cb33)) {
            } else {
                $Fe60432f29968ade[] = $Cacd938c24b4cb33;
            }

        }
        if(0 < count($Fe60432f29968ade)) {
            file_put_contents(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef), igbinary_serialize($Fe60432f29968ade));
        } else {
            unlink(SIGNALS_TMP_PATH . "queue_" . intval($F406b49979220eef));
        }

    }

    public static function c281b26D66Ce5fcF($Febabbe2c8824ef7)
    {
        return (array_rand(array_keys(self::getProxies($Febabbe2c8824ef7, false))) ?: null);
    }

    public static function db3B1De54fcF2e58($E5a93b03617ebdd7, $C822794f4d7621d3)
    {
        if(!(is_numeric($C822794f4d7621d3) && 1900 <= $C822794f4d7621d3 && $C822794f4d7621d3 <= intval(date("Y") + 1))) {
        } else {
            if(self::$rSettings["movie_year_append"] == 0) {
                return trim($E5a93b03617ebdd7) . " (" . $C822794f4d7621d3 . ")";
            }

            if(self::$rSettings["movie_year_append"] != 0) {
            } else {
                return trim($E5a93b03617ebdd7) . " - " . $C822794f4d7621d3;
            }

        }

        return $E5a93b03617ebdd7;
    }

    public static function dCa780d586619068($E9b30925ed9ebdc3)
    {
        if(!(0 < count($E9b30925ed9ebdc3) && file_exists(CACHE_TMP_PATH . "channel_order") && self::$rSettings["channel_number_type"] != "bouquet")) {
        } else {
            $Df166a11586c1244 = igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . "channel_order"));
            $E9b30925ed9ebdc3 = array_flip($E9b30925ed9ebdc3);
            $Ad4b1d7a58ac4e98 = array(  );
            foreach($Df166a11586c1244 as $A76532e4f616ce0c) {
                if(!isset($E9b30925ed9ebdc3[$A76532e4f616ce0c])) {
                } else {
                    $Ad4b1d7a58ac4e98[] = $A76532e4f616ce0c;
                }

            }
            if(0 >= count($Ad4b1d7a58ac4e98)) {
            } else {
                return $Ad4b1d7a58ac4e98;
            }

        }

        return $E9b30925ed9ebdc3;
    }

    public static function sortSeries($ce8264ba7b4b75b7)
    {
        if(!(0 < count($ce8264ba7b4b75b7) && file_exists(CACHE_TMP_PATH . "series_order"))) {
        } else {
            $Df166a11586c1244 = igbinary_unserialize(file_get_contents(CACHE_TMP_PATH . "series_order"));
            $ce8264ba7b4b75b7 = array_flip($ce8264ba7b4b75b7);
            $Ad4b1d7a58ac4e98 = array(  );
            foreach($Df166a11586c1244 as $A76532e4f616ce0c) {
                if(!isset($ce8264ba7b4b75b7[$A76532e4f616ce0c])) {
                } else {
                    $Ad4b1d7a58ac4e98[] = $A76532e4f616ce0c;
                }

            }
            if(0 >= count($Ad4b1d7a58ac4e98)) {
            } else {
                return $Ad4b1d7a58ac4e98;
            }

        }

        return $ce8264ba7b4b75b7;
    }

    public static function fEd9aa3BeE0408A2($A6236b8f3b6a4fa6, $C9340e84b67c26bc)
    {
        file_put_contents(SIGNALS_TMP_PATH . "cache_" . md5($A6236b8f3b6a4fa6), json_encode(array( $A6236b8f3b6a4fa6, $C9340e84b67c26bc )));
    }

    public static function B1Fa34c33256656c()
    {
        if(is_object(self::$redis)) {
        } else {
            try {
                self::$redis = new Redis();
                self::$redis->connect(self::$rConfig["hostname"], 6379);
                self::$redis->auth(self::$rSettings["redis_password"]);
            } catch(Exception $B2ccc338b087b443) {
                self::$redis = null;
                return false;
            }
        }

        return true;
    }

    public static function Ec3b97C9c9D6de75($C9340e84b67c26bc, $fb95270d1f588ee1 = array(  ), $E9c65027146a2965 = null)
    {
        if(is_object(self::$redis)) {
        } else {
            self::B1fa34c33256656C();
        }

        $f1f1d1b4d2609d34 = $C9340e84b67c26bc;
        foreach($fb95270d1f588ee1 as $A6236b8f3b6a4fa6 => $fff0f0d8088c1ce3) {
            $C9340e84b67c26bc[$A6236b8f3b6a4fa6] = $fff0f0d8088c1ce3;
        }
        $D29a485fe871ffa7 = self::$redis->multi();
        if($E9c65027146a2965 == "open") {
            $D29a485fe871ffa7->sRem("ENDED", $C9340e84b67c26bc["uuid"]);
            $D29a485fe871ffa7->zAdd("LIVE", $C9340e84b67c26bc["date_start"], $C9340e84b67c26bc["uuid"]);
            $D29a485fe871ffa7->zAdd("LINE#" . $C9340e84b67c26bc["identity"], $C9340e84b67c26bc["date_start"], $C9340e84b67c26bc["uuid"]);
            $D29a485fe871ffa7->zAdd("STREAM#" . $C9340e84b67c26bc["stream_id"], $C9340e84b67c26bc["date_start"], $C9340e84b67c26bc["uuid"]);
            $D29a485fe871ffa7->zAdd("SERVER#" . $C9340e84b67c26bc["server_id"], $C9340e84b67c26bc["date_start"], $C9340e84b67c26bc["uuid"]);
            if(!$C9340e84b67c26bc["proxy_id"]) {
            } else {
                $D29a485fe871ffa7->zAdd("PROXY#" . $C9340e84b67c26bc["proxy_id"], $C9340e84b67c26bc["date_start"], $C9340e84b67c26bc["uuid"]);
            }

            if($C9340e84b67c26bc["hls_end"] != 1) {
            } else {
                $C9340e84b67c26bc["hls_end"] = 0;
                if(!$C9340e84b67c26bc["user_id"]) {
                } else {
                    $D29a485fe871ffa7->zAdd("SERVER_LINES#" . $C9340e84b67c26bc["server_id"], $C9340e84b67c26bc["user_id"], $C9340e84b67c26bc["uuid"]);
                }

            }

        } else {
            if($E9c65027146a2965 != "close") {
            } else {
                $D29a485fe871ffa7->sAdd("ENDED", $C9340e84b67c26bc["uuid"]);
                $D29a485fe871ffa7->zRem("LIVE", $C9340e84b67c26bc["uuid"]);
                $D29a485fe871ffa7->zRem("LINE#" . $f1f1d1b4d2609d34["identity"], $C9340e84b67c26bc["uuid"]);
                $D29a485fe871ffa7->zRem("STREAM#" . $f1f1d1b4d2609d34["stream_id"], $C9340e84b67c26bc["uuid"]);
                $D29a485fe871ffa7->zRem("SERVER#" . $f1f1d1b4d2609d34["server_id"], $C9340e84b67c26bc["uuid"]);
                if(!$C9340e84b67c26bc["proxy_id"]) {
                } else {
                    $D29a485fe871ffa7->zRem("PROXY#" . $f1f1d1b4d2609d34["proxy_id"], $C9340e84b67c26bc["uuid"]);
                }

                if($C9340e84b67c26bc["hls_end"] != 0) {
                } else {
                    $C9340e84b67c26bc["hls_end"] = 1;
                    if(!$C9340e84b67c26bc["user_id"]) {
                    } else {
                        $D29a485fe871ffa7->zRem("SERVER_LINES#" . $f1f1d1b4d2609d34["server_id"], $C9340e84b67c26bc["uuid"]);
                    }

                }

            }

        }

        $D29a485fe871ffa7->set($C9340e84b67c26bc["uuid"], igbinary_serialize($C9340e84b67c26bc));
        if($D29a485fe871ffa7->exec()) {
            return $C9340e84b67c26bc;
        }

        return null;
    }

    public static function Deca5a90130d62fB($C9bc783135eb4c9a, $Febabbe2c8824ef7, $Ecb2a72ea446f892, $e8a6b114d8508c3b = null)
    {
        if(is_object(self::$redis)) {
        } else {
            self::B1fa34c33256656C();
        }

        $A6236b8f3b6a4fa6 = "SIGNAL#" . md5($Febabbe2c8824ef7 . "#" . $C9bc783135eb4c9a . "#" . $Ecb2a72ea446f892);
        $C9340e84b67c26bc = array( "pid" => $C9bc783135eb4c9a, "server_id" => $Febabbe2c8824ef7, "rtmp" => $Ecb2a72ea446f892, "time" => time(), "custom_data" => $e8a6b114d8508c3b, "key" => $A6236b8f3b6a4fa6 );
        return self::$redis->multi()->sAdd("SIGNALS#" . $Febabbe2c8824ef7, $A6236b8f3b6a4fa6)->set($A6236b8f3b6a4fa6, igbinary_serialize($C9340e84b67c26bc))->exec();
    }

    public static function fD53968E413cC1A0($D63d516e302507f5, $Ea294bdc5b3574e7 = false, $E0a4b0e97c210570 = false)
    {
        if(is_object(self::$redis)) {
        } else {
            self::b1fA34C33256656C();
        }

        $D29a485fe871ffa7 = self::$redis->multi();
        foreach($D63d516e302507f5 as $bd1be39635484df0) {
            $D29a485fe871ffa7->zRevRangeByScore("LINE#" . $bd1be39635484df0, "+inf", "-inf");
        }
        $e1510716ea53e2d4 = $D29a485fe871ffa7->exec();
        $E194daf631222caf = $Ba3c44335cc4c23a = array(  );
        foreach($e1510716ea53e2d4 as $B338558bc4c0ea65 => $bcab5dbc46da608d) {
            if($Ea294bdc5b3574e7) {
                $E194daf631222caf[$D63d516e302507f5[$B338558bc4c0ea65]] = count($bcab5dbc46da608d);
            } else {
                if(0 >= count($bcab5dbc46da608d)) {
                } else {
                    $Ba3c44335cc4c23a = array_merge($Ba3c44335cc4c23a, $bcab5dbc46da608d);
                }

            }

        }
        $Ba3c44335cc4c23a = array_unique($Ba3c44335cc4c23a);
        if(!$E0a4b0e97c210570) {
            if($Ea294bdc5b3574e7) {
            } else {
                foreach(self::$redis->mGet($Ba3c44335cc4c23a) as $e6002db131ca9d50) {
                    $e6002db131ca9d50 = igbinary_unserialize($e6002db131ca9d50);
                    $E194daf631222caf[$e6002db131ca9d50["user_id"]][] = $e6002db131ca9d50;
                }
            }

            return $E194daf631222caf;
        }

        return $Ba3c44335cc4c23a;
    }

    public static function getServerConnections($A64596fe62ff1266, $bba4824306df4e1f = false, $Ea294bdc5b3574e7 = false, $E0a4b0e97c210570 = false)
    {
        if(is_object(self::$redis)) {
        } else {
            self::B1FA34c33256656C();
        }

        $D29a485fe871ffa7 = self::$redis->multi();
        foreach($A64596fe62ff1266 as $Febabbe2c8824ef7) {
            $D29a485fe871ffa7->zRevRangeByScore(($bba4824306df4e1f ? "PROXY#" . $Febabbe2c8824ef7 : "SERVER#" . $Febabbe2c8824ef7), "+inf", "-inf");
        }
        $e1510716ea53e2d4 = $D29a485fe871ffa7->exec();
        $E194daf631222caf = $Ba3c44335cc4c23a = array(  );
        foreach($e1510716ea53e2d4 as $B338558bc4c0ea65 => $bcab5dbc46da608d) {
            if($Ea294bdc5b3574e7) {
                $E194daf631222caf[$A64596fe62ff1266[$B338558bc4c0ea65]] = count($bcab5dbc46da608d);
            } else {
                if(0 >= count($bcab5dbc46da608d)) {
                } else {
                    $Ba3c44335cc4c23a = array_merge($Ba3c44335cc4c23a, $bcab5dbc46da608d);
                }

            }

        }
        $Ba3c44335cc4c23a = array_unique($Ba3c44335cc4c23a);
        if(!$E0a4b0e97c210570) {
            if($Ea294bdc5b3574e7) {
            } else {
                foreach(self::$redis->mGet($Ba3c44335cc4c23a) as $e6002db131ca9d50) {
                    $e6002db131ca9d50 = igbinary_unserialize($e6002db131ca9d50);
                    $E194daf631222caf[$e6002db131ca9d50["server_id"]][] = $e6002db131ca9d50;
                }
            }

            return $E194daf631222caf;
        }

        return $Ba3c44335cc4c23a;
    }

    public static function getFirstConnection($D63d516e302507f5)
    {
        if(is_object(self::$redis)) {
        } else {
            self::B1FA34C33256656C();
        }

        $D29a485fe871ffa7 = self::$redis->multi();
        foreach($D63d516e302507f5 as $bd1be39635484df0) {
            $D29a485fe871ffa7->zRevRangeByScore("LINE#" . $bd1be39635484df0, "+inf", "-inf", array( "limit" => array( 0, 1 ) ));
        }
        $e1510716ea53e2d4 = $D29a485fe871ffa7->exec();
        $E194daf631222caf = $Ba3c44335cc4c23a = array(  );
        foreach($e1510716ea53e2d4 as $B338558bc4c0ea65 => $bcab5dbc46da608d) {
            if(0 >= count($bcab5dbc46da608d)) {
            } else {
                $Ba3c44335cc4c23a[] = $bcab5dbc46da608d[0];
            }

        }
        foreach(self::$redis->mGet(array_unique($Ba3c44335cc4c23a)) as $e6002db131ca9d50) {
            $e6002db131ca9d50 = igbinary_unserialize($e6002db131ca9d50);
            $E194daf631222caf[$e6002db131ca9d50["user_id"]] = $e6002db131ca9d50;
        }
        return $E194daf631222caf;
    }

    public static function getStreamConnections($E08d14aeb9b1814a, $E0b889ed888068b5 = true, $Ea294bdc5b3574e7 = false)
    {
        if(is_object(self::$redis)) {
        } else {
            self::b1fa34C33256656c();
        }

        $D29a485fe871ffa7 = self::$redis->multi();
        foreach($E08d14aeb9b1814a as $F406b49979220eef) {
            $D29a485fe871ffa7->zRevRangeByScore("STREAM#" . $F406b49979220eef, "+inf", "-inf");
        }
        $e1510716ea53e2d4 = $D29a485fe871ffa7->exec();
        $E194daf631222caf = $Ba3c44335cc4c23a = array(  );
        foreach($e1510716ea53e2d4 as $B338558bc4c0ea65 => $bcab5dbc46da608d) {
            if($Ea294bdc5b3574e7) {
                $E194daf631222caf[$E08d14aeb9b1814a[$B338558bc4c0ea65]] = count($bcab5dbc46da608d);
            } else {
                if(0 >= count($bcab5dbc46da608d)) {
                } else {
                    $Ba3c44335cc4c23a = array_merge($Ba3c44335cc4c23a, $bcab5dbc46da608d);
                }

            }

        }
        if($Ea294bdc5b3574e7) {
        } else {
            foreach(self::$redis->mGet(array_unique($Ba3c44335cc4c23a)) as $e6002db131ca9d50) {
                $e6002db131ca9d50 = igbinary_unserialize($e6002db131ca9d50);
                if($E0b889ed888068b5) {
                    $E194daf631222caf[$e6002db131ca9d50["stream_id"]][] = $e6002db131ca9d50;
                } else {
                    $E194daf631222caf[$e6002db131ca9d50["stream_id"]][$e6002db131ca9d50["server_id"]][] = $e6002db131ca9d50;
                }

            }
        }

        return $E194daf631222caf;
    }

    public static function dA9DB292BC671bd4($bd1be39635484df0 = null, $Febabbe2c8824ef7 = null, $F406b49979220eef = null, $B4723a9eead0a918 = false, $edbbd39f38e16c0d = false, $E0b889ed888068b5 = true, $ebdf6d691f814664 = false)
    {
        $F0e839083d6bad06 = ($edbbd39f38e16c0d ? array( 0, 0 ) : array(  ));
        if(is_object(self::$redis)) {
        } else {
            self::b1Fa34c33256656C();
        }

        $Bf5799bd92b145e9 = array(  );
        $bd1be39635484df0 = (0 < intval($bd1be39635484df0) ? intval($bd1be39635484df0) : null);
        $Febabbe2c8824ef7 = (0 < intval($Febabbe2c8824ef7) ? intval($Febabbe2c8824ef7) : null);
        $F406b49979220eef = (0 < intval($F406b49979220eef) ? intval($F406b49979220eef) : null);
        if($bd1be39635484df0) {
            $bcab5dbc46da608d = self::$redis->zRangeByScore("LINE#" . $bd1be39635484df0, "-inf", "+inf");
        } else {
            if($F406b49979220eef) {
                $bcab5dbc46da608d = self::$redis->zRangeByScore("STREAM#" . $F406b49979220eef, "-inf", "+inf");
            } else {
                if($Febabbe2c8824ef7) {
                    $bcab5dbc46da608d = self::$redis->zRangeByScore("SERVER#" . $Febabbe2c8824ef7, "-inf", "+inf");
                } else {
                    $bcab5dbc46da608d = self::$redis->zRangeByScore("LIVE", "-inf", "+inf");
                }

            }

        }

        if(0 >= count($bcab5dbc46da608d)) {
        } else {
            foreach(self::$redis->mGet(array_unique($bcab5dbc46da608d)) as $e6002db131ca9d50) {
                $e6002db131ca9d50 = igbinary_unserialize($e6002db131ca9d50);
                if(!($Febabbe2c8824ef7 && $Febabbe2c8824ef7 != $e6002db131ca9d50["server_id"]) && !($F406b49979220eef && $F406b49979220eef != $e6002db131ca9d50["stream_id"]) && !($bd1be39635484df0 && $bd1be39635484df0 != $e6002db131ca9d50["user_id"]) && !($ebdf6d691f814664 && $e6002db131ca9d50["container"] == "hls")) {
                    $D2fa3489fd3a403d = ($e6002db131ca9d50["user_id"] ?: $e6002db131ca9d50["hmac_id"] . "_" . $e6002db131ca9d50["hmac_identifier"]);
                    if($edbbd39f38e16c0d) {
                        $F0e839083d6bad06[0]++;
                        $Bf5799bd92b145e9[] = $D2fa3489fd3a403d;
                    } else {
                        if($E0b889ed888068b5) {
                            if(isset($F0e839083d6bad06[$D2fa3489fd3a403d])) {
                            } else {
                                $F0e839083d6bad06[$D2fa3489fd3a403d] = array(  );
                            }

                            $F0e839083d6bad06[$D2fa3489fd3a403d][] = $e6002db131ca9d50;
                        } else {
                            $F0e839083d6bad06[] = $e6002db131ca9d50;
                        }

                    }

                }

            }
        }

        if(!$edbbd39f38e16c0d) {
        } else {
            $F0e839083d6bad06[1] = count(array_unique($Bf5799bd92b145e9));
        }

        return $F0e839083d6bad06;
    }

    public static function eB628Ac1FD062456($F7969195259678ba = false)
    {
        $a4e3d2574fdc3312 = null;
        $Febabbe2c8824ef7 = SERVER_ID;
        if($F7969195259678ba) {
            $Eb49e051e67718d4 = "https";
        } else {
            if(isset($_SERVER["SERVER_PORT"]) && self::$rSettings["keep_protocol"]) {
                $Eb49e051e67718d4 = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https" : "http");
            } else {
                $Eb49e051e67718d4 = self::$rServers[$Febabbe2c8824ef7]["server_protocol"];
            }

        }

        $D72aea184131f57d = self::$rServers[$Febabbe2c8824ef7]["enable_proxy"];
        if(!$D72aea184131f57d) {
        } else {
            $b58bd05c3af64fc0 = array_keys(self::getProxies($Febabbe2c8824ef7));
            if(count($b58bd05c3af64fc0) != 0) {
            } else {
                $b58bd05c3af64fc0 = array_keys(self::getProxies($Febabbe2c8824ef7, false));
            }

            if(count($b58bd05c3af64fc0) != 0) {
                $a4e3d2574fdc3312 = $Febabbe2c8824ef7;
                $Febabbe2c8824ef7 = $b58bd05c3af64fc0[array_rand($b58bd05c3af64fc0)];
            } else {
                return "";
            }

        }

        list($c4537dbba77895b5, $f524bde81e8371c2) = explode(":", $_SERVER["HTTP_HOST"]);
        if(!($D72aea184131f57d || self::$rSettings["use_mdomain_in_lists"] == 1)) {
        } else {
            if(in_array(strtolower($c4537dbba77895b5), (self::b8E8A18B5bFFAac0("reseller_domains") ?: array(  )))) {
            } else {
                if(empty(self::$rServers[$Febabbe2c8824ef7]["domain_name"])) {
                    $c4537dbba77895b5 = escapeshellcmd(self::$rServers[$Febabbe2c8824ef7]["server_ip"]);
                } else {
                    $c4537dbba77895b5 = str_replace(array( "http://", "/", "https://" ), "", escapeshellcmd(explode(",", self::$rServers[$Febabbe2c8824ef7]["domain_name"])[0]));
                }

            }

        }

        $cb5ca3f1650dc050 = $Eb49e051e67718d4 . "://" . $c4537dbba77895b5 . ":" . self::$rServers[$Febabbe2c8824ef7][$Eb49e051e67718d4 . "_broadcast_port"] . "/";
        if(!(self::$rServers[$Febabbe2c8824ef7]["server_type"] == 1 && $a4e3d2574fdc3312 && self::$rServers[$a4e3d2574fdc3312]["is_main"] == 0)) {
        } else {
            $cb5ca3f1650dc050 .= md5($Febabbe2c8824ef7 . "_" . $a4e3d2574fdc3312 . "_" . OPENSSL_EXTRA) . "/";
        }

        return $cb5ca3f1650dc050;
    }

    public static function Bac7c5e5598B5be9($C9340e84b67c26bc)
    {
        if(is_array($C9340e84b67c26bc)) {
        } else {
            $C9340e84b67c26bc = json_decode($C9340e84b67c26bc, true);
        }

        $Cf9e5fd19ec75131 = array( "aac", "libfdk_aac", "opus", "vorbis", "pcm_s16le", "mp2", "mp3", "flac", null );
        $d18d3f9ac206d45a = array( "h264", "vp8", "vp9", "ogg", "av1", null );
        if(!self::$rSettings["player_allow_hevc"]) {
        } else {
            $d18d3f9ac206d45a[] = "hevc";
            $d18d3f9ac206d45a[] = "h265";
            $Cf9e5fd19ec75131[] = "ac3";
        }

        return ($C9340e84b67c26bc["codecs"]["audio"]["codec_name"] || $C9340e84b67c26bc["codecs"]["video"]["codec_name"]) && in_array(strtolower($C9340e84b67c26bc["codecs"]["audio"]["codec_name"]), $Cf9e5fd19ec75131) && in_array(strtolower($C9340e84b67c26bc["codecs"]["video"]["codec_name"]), $d18d3f9ac206d45a);
    }

    public static function DEaAAE249682c563($eb683a07cc637504, $e6a33f1d8a33bbcd)
    {
        $af1de363a6f2af4b = null;
        foreach($eb683a07cc637504 as $ad925905541b050d) {
            if(!($af1de363a6f2af4b === null || abs($ad925905541b050d - $e6a33f1d8a33bbcd) < abs($e6a33f1d8a33bbcd - $af1de363a6f2af4b))) {
            } else {
                $af1de363a6f2af4b = $ad925905541b050d;
            }

        }
        return $af1de363a6f2af4b;
    }

    public static function submitPanelLogs()
    {
        ini_set("default_socket_timeout", 60);
        self::$db->query("SELECT `type`, `log_message`, `log_extra`, `line`, `date` FROM `panel_logs` WHERE `type` <> 'epg' GROUP BY CONCAT(`type`, `log_message`, `log_extra`) ORDER BY `date` DESC LIMIT 1000;");
        $F8cc47ef68ac5339 = "https://xui.one/report.php";
        $C9340e84b67c26bc = array( "errors" => self::$db->get_rows(), "license" => self::$rConfig["license"], "version" => XUI_VERSION, "revision" => XUI_REVISION );
        $cbd7166f1adc3461 = http_build_query($C9340e84b67c26bc);
        self::$db->query("TRUNCATE `panel_logs`;");
        $f74067e3e6261c8c = curl_init();
        curl_setopt($f74067e3e6261c8c, CURLOPT_URL, $F8cc47ef68ac5339);
        curl_setopt($f74067e3e6261c8c, CURLOPT_POST, true);
        curl_setopt($f74067e3e6261c8c, CURLOPT_POSTFIELDS, $cbd7166f1adc3461);
        curl_setopt($f74067e3e6261c8c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($f74067e3e6261c8c, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($f74067e3e6261c8c, CURLOPT_TIMEOUT, 60);
        return curl_exec($f74067e3e6261c8c);
    }

    public static function confirmIDs($b1ed70b00f55cad9)
    {
        $F0e839083d6bad06 = array(  );
        foreach($b1ed70b00f55cad9 as $A76532e4f616ce0c) {
            if(0 >= intval($A76532e4f616ce0c)) {
            } else {
                $F0e839083d6bad06[] = $A76532e4f616ce0c;
            }

        }
        return $F0e839083d6bad06;
    }

    public static function getTSInfo($ef05f681c33d575c)
    {
        return json_decode(shell_exec(BIN_PATH . "tsinfo " . escapeshellarg($ef05f681c33d575c)), true);
    }

    public static function getEPG($F406b49979220eef, $A4f4d14785e99971 = null, $ea7f05d6f5494437 = null, $Ee6bd903e29494c1 = false)
    {
        $F0e839083d6bad06 = array(  );
        $C9340e84b67c26bc = (file_exists(EPG_PATH . "stream_" . $F406b49979220eef) ? igbinary_unserialize(file_get_contents(EPG_PATH . "stream_" . $F406b49979220eef)) : array(  ));
        foreach($C9340e84b67c26bc as $cc896abcf1aeace3) {
            if($A4f4d14785e99971 && !($A4f4d14785e99971 < $cc896abcf1aeace3["end"] && $cc896abcf1aeace3["start"] < $ea7f05d6f5494437)) {
            } else {
                if($Ee6bd903e29494c1) {
                    $F0e839083d6bad06[$cc896abcf1aeace3["id"]] = $cc896abcf1aeace3;
                } else {
                    $F0e839083d6bad06[] = $cc896abcf1aeace3;
                }

            }

        }
        return $F0e839083d6bad06;
    }

    public static function A91eD35b483a6e7f($E08d14aeb9b1814a, $A4f4d14785e99971 = null, $ea7f05d6f5494437 = null)
    {
        $F0e839083d6bad06 = array(  );
        foreach($E08d14aeb9b1814a as $F406b49979220eef) {
            $F0e839083d6bad06[$F406b49979220eef] = self::getEPG($F406b49979220eef, $A4f4d14785e99971, $ea7f05d6f5494437);
        }
        return $F0e839083d6bad06;
    }

    public static function getProgramme($F406b49979220eef, $A90fd2b604d78e93)
    {
        $C9340e84b67c26bc = self::getEPG($F406b49979220eef, null, null, true);
        if(!isset($C9340e84b67c26bc[$A90fd2b604d78e93])) {
        } else {
            return $C9340e84b67c26bc[$A90fd2b604d78e93];
        }

    }

    public static function getNetwork($ee53d31b15f1303b = null)
    {
        $F0e839083d6bad06 = array(  );
        if(!file_exists(LOGS_TMP_PATH . "network")) {
        } else {
            $e253263dcbb7e904 = json_decode(file_get_contents(LOGS_TMP_PATH . "network"), true);
            foreach($e253263dcbb7e904 as $Fcb66b83cdf12a23) {
                if(!($ee53d31b15f1303b && $Fcb66b83cdf12a23[0] != $ee53d31b15f1303b) && !($Fcb66b83cdf12a23[0] == "lo" || !$ee53d31b15f1303b && substr($Fcb66b83cdf12a23[0], 0, 4) == "bond")) {
                    $F0e839083d6bad06[$Fcb66b83cdf12a23[0]] = array( "in_bytes" => intval($Fcb66b83cdf12a23[1] / 2), "in_packets" => $Fcb66b83cdf12a23[2], "in_errors" => $Fcb66b83cdf12a23[3], "out_bytes" => intval($Fcb66b83cdf12a23[4] / 2), "out_packets" => $Fcb66b83cdf12a23[5], "out_errors" => $Fcb66b83cdf12a23[6] );
                }

            }
        }

        return $F0e839083d6bad06;
    }

    public static function getProxies($Febabbe2c8824ef7, $A07954820d4440a0 = true)
    {
        $F0e839083d6bad06 = array(  );
        foreach(self::$rServers as $D87e787493e333c9 => $D389304b0aa961c7) {
            if(!($D389304b0aa961c7["server_type"] == 1 && in_array($Febabbe2c8824ef7, $D389304b0aa961c7["parent_id"]) && ($D389304b0aa961c7["server_online"] || !$A07954820d4440a0))) {
            } else {
                $F0e839083d6bad06[$D87e787493e333c9] = $D389304b0aa961c7;
            }

        }
        return $F0e839083d6bad06;
    }

}
