<?php include 'session.php';
include 'functions.php';
$_TITLE = 'Edit Profile';
include 'header.php'; ?>
<div class="wrapper boxed-layout" <?php if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
                                        echo ' style="display: none;"';
                                    } ?>>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title"><?php echo ucfirst($rUserInfo['username']); ?></h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <?php if (isset($_STATUS) && $_STATUS == STATUS_SUCCESS) { ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <?php echo $language::get('profile_success'); ?>
                    </div>
                <?php } ?>
                <div class="card">
                    <div class="card-body">
                        <form onSubmit="return false;" action="#" method="POST" data-parsley-validate="">
                            <div id="basicwizard">
                                <ul class="nav nav-pills bg-light nav-justified form-wizard-header mb-4">
                                    <li class="nav-item">
                                        <a href="#user-details" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                            <i class="mdi mdi-account-card-details-outline mr-1"></i>
                                            <span class="d-none d-sm-inline"><?php echo $language::get('details'); ?></span>
                                        </a>
                                    </li>
                                </ul>
                                <div class="tab-content b-0 mb-0 pt-0">
                                    <div class="tab-pane" id="user-details">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="password"><?php echo $language::get('change_password'); ?></label>
                                                    <div class="col-md-8">
                                                        <input type="text" class="form-control" id="password" name="password" value="">
                                                    </div>
                                                </div>
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="email"><?php echo $language::get('email_address'); ?></label>
                                                    <div class="col-md-8">
                                                        <input type="email" id="email" class="form-control" name="email" value="<?php echo htmlspecialchars($rUserInfo['email']); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="timezone">Timezone</label>
                                                    <div class="col-md-8">
                                                        <select name="timezone" id="timezone" class="form-control" data-toggle="select2">
                                                            <option <?php if (empty($rUserInfo['timezone'])) {
                                                                        echo 'selected ';
                                                                    } ?>value="">Server Default</option>
                                                            <?php foreach (TimeZoneList() as $rValue) { ?>
                                                                <option <?php if ($rUserInfo['timezone'] == $rValue['zone']) {
                                                                            echo 'selected ';
                                                                        } ?>value="<?php echo $rValue['zone']; ?>"><?php echo $rValue['zone'] . " " . $rValue['diff_from_GMT']; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="theme">System Theme</label>
                                                    <div class="col-md-8">
                                                        <select name="theme" id="theme" class="form-control" data-toggle="select2">
                                                            <?php foreach ($rThemes as $rValue => $rArray) { ?>
                                                                <option <?php if ($rUserInfo['theme'] == $rValue) {
                                                                            echo 'selected ';
                                                                        } ?>value="<?php echo $rValue; ?>"><?php echo $rArray['name']; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="hue">Topbar Theme</label>
                                                    <div class="col-md-8">
                                                        <select name="hue" id="hue" class="form-control" data-toggle="select2">
                                                            <?php foreach ($rHues as $rValue => $rText) { ?>
                                                                <option <?php if ($rUserInfo['hue'] == $rValue) {
                                                                            echo 'selected ';
                                                                        } ?>value="<?php echo $rValue; ?>"><?php echo $rText; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row mb-4">
                                                    <label class="col-md-4 col-form-label" for="lang">Language</label>
                                                    <div class="col-md-8">
                                                        <select name="lang" id="lang" class="form-control" data-toggle="select2">
                                                            <?php foreach ($allowedLangs as $rText) { ?>
                                                                <option <?php if ($rUserInfo['lang'] == $rText) {
                                                                            echo 'selected ';
                                                                        } ?>value="<?php echo $rText; ?>"><?php echo $rText; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <?php foreach (getcodes() as $rCode) {
                                                    if ($rCode['type'] == 3 && in_array($rUserInfo['member_group_id'], json_decode($rCode['groups'], true))) { ?>
                                                        <div class="form-group row mb-4">
                                                            <label class="col-md-4 col-form-label" for="api_key">API Key <i title="API URL:<br/><?php echo CoreUtilities::$rServers[SERVER_ID]['site_url'] . $rCode['code']; ?>/" class="tooltip text-secondary far fa-circle"></i></label>
                                                            <div class="col-md-8 input-group">
                                                                <input readonly type="text" maxlength="32" class="form-control" id="api_key" name="api_key" value="<?php echo htmlspecialchars($rUserInfo['api_key']); ?>">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-danger waves-effect waves-light" onClick="clearCode();" type="button"><i class="mdi mdi-close"></i></button>
                                                                    <button class="btn btn-info waves-effect waves-light" onClick="generateCode();" type="button"><i class="mdi mdi-refresh"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                <?php break;
                                                    }
                                                } ?>
                                            </div>
                                        </div>
                                        <ul class="list-inline wizard mb-0">
                                            <li class="list-inline-item float-right">
                                                <input name="submit_profile" type="submit" class="btn btn-primary" value="<?php echo $language::get('save_profile'); ?>" />
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>

<script id="scripts">
    var resizeObserver = new ResizeObserver(entries => $(window).scroll());
    $(document).ready(function() {
        resizeObserver.observe(document.body)
        $("form").attr('autocomplete', 'off');
        $(document).keypress(function(event) {
            if (event.which == 13 && event.target.nodeName != "TEXTAREA") return false;
        });
        $.fn.dataTable.ext.errMode = 'none';
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        elems.forEach(function(html) {
            var switchery = new Switchery(html, {
                'color': '#414d5f'
            });
            window.rSwitches[$(html).attr("id")] = switchery;
        });
        setTimeout(pingSession, 30000);
        <?php if (!$rMobile && $rSettings['header_stats']): ?>
            headerStats();
        <?php endif; ?>
        bindHref();
        refreshTooltips();
        $(window).scroll(function() {
            if ($(this).scrollTop() > 200) {
                if ($(document).height() > $(window).height()) {
                    $('#scrollToBottom').fadeOut();
                }
                $('#scrollToTop').fadeIn();
            } else {
                $('#scrollToTop').fadeOut();
                if ($(document).height() > $(window).height()) {
                    $('#scrollToBottom').fadeIn();
                } else {
                    $('#scrollToBottom').hide();
                }
            }
        });
        $("#scrollToTop").unbind("click");
        $('#scrollToTop').click(function() {
            $('html, body').animate({
                scrollTop: 0
            }, 800);
            return false;
        });
        $("#scrollToBottom").unbind("click");
        $('#scrollToBottom').click(function() {
            $('html, body').animate({
                scrollTop: $(document).height()
            }, 800);
            return false;
        });
        $(window).scroll();
        $(".nextb").unbind("click");
        $(".nextb").click(function() {
            var rPos = 0;
            var rActive = null;
            $(".nav .nav-item").each(function() {
                if ($(this).find(".nav-link").hasClass("active")) {
                    rActive = rPos;
                }
                if (rActive !== null && rPos > rActive && !$(this).find("a").hasClass("disabled") && $(this).is(":visible")) {
                    $(this).find(".nav-link").trigger("click");
                    return false;
                }
                rPos += 1;
            });
        });
        $(".prevb").unbind("click");
        $(".prevb").click(function() {
            var rPos = 0;
            var rActive = null;
            $($(".nav .nav-item").get().reverse()).each(function() {
                if ($(this).find(".nav-link").hasClass("active")) {
                    rActive = rPos;
                }
                if (rActive !== null && rPos > rActive && !$(this).find("a").hasClass("disabled") && $(this).is(":visible")) {
                    $(this).find(".nav-link").trigger("click");
                    return false;
                }
                rPos += 1;
            });
        });
        (function($) {
            $.fn.inputFilter = function(inputFilter) {
                return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
                    if (inputFilter(this.value)) {
                        this.oldValue = this.value;
                        this.oldSelectionStart = this.selectionStart;
                        this.oldSelectionEnd = this.selectionEnd;
                    } else if (this.hasOwnProperty("oldValue")) {
                        this.value = this.oldValue;
                        this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                    }
                });
            };
        }(jQuery));
        <?php if ($rSettings['js_navigate']): ?>
            $(".navigation-menu li").mouseenter(function() {
                $(this).find(".submenu").show();
            });
            delParam("status");
            $(window).on("popstate", function() {
                if (window.rRealURL) {
                    if (window.rRealURL.split("/").reverse()[0].split("?")[0].split(".")[0] != window.location.href.split("/").reverse()[0].split("?")[0].split(".")[0]) {
                        navigate(window.location.href.split("/").reverse()[0]);
                    }
                }
            });
        <?php endif; ?>
        $(document).keydown(function(e) {
            if (e.keyCode == 16) {
                window.rShiftHeld = true;
            }
        });
        $(document).keyup(function(e) {
            if (e.keyCode == 16) {
                window.rShiftHeld = false;
            }
        });
        document.onselectstart = function() {
            if (window.rShiftHeld) {
                return false;
            }
        }
    });

    function generateCode() {
        var result = '';
        var characters = 'ABCDEF0123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < 32; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        $("#api_key").val(result);
    }

    function clearCode() {
        $("#api_key").val("");
    }
    $(document).ready(function() {
        $('select').select2({
            width: '100%'
        });
        $("form").submit(function(e) {
            e.preventDefault();
            $(':input[type="submit"]').prop('disabled', true);
            submitForm(window.rCurrentPage, new FormData($("form")[0]));
        });
    });
    <?php if (CoreUtilities::$rSettings['enable_search']): ?>
        $(document).ready(function() {
            initSearch();
        });
    <?php endif; ?>
</script>
<script src="assets/js/listings.js"></script>
</body>

</html>