<?php

include 'session.php';
include 'functions.php';

if (!checkPermissions()) {
    goHome();
}

if (!isset(CoreUtilities::$rRequest['server']) || !isset($rServers[CoreUtilities::$rRequest['server']])) {
    CoreUtilities::$rRequest['server'] = SERVER_ID;
}

if (isset(CoreUtilities::$rRequest['clear'])) {
    freeTemp(CoreUtilities::$rRequest['server']);
    header('Location: ./process_monitor?server=' . CoreUtilities::$rRequest['server']);
    exit();
}

if (isset(CoreUtilities::$rRequest['clear_s'])) {
    freeStreams(CoreUtilities::$rRequest['server']);
    header('Location: ./process_monitor?server=' . CoreUtilities::$rRequest['server']);
    exit();
}


$rStreams = getStreamPIDs(CoreUtilities::$rRequest['server']) ?: array();
$rFS = getFreeSpace(CoreUtilities::$rRequest['server']) ?: array();
$rProcesses = getPIDs(CoreUtilities::$rRequest['server']) ?: array();
$rStatus = array('D' => 'Uninterruptible Sleep', 'I' => 'Idle', 'R' => 'Running', 'S' => 'Interruptible Sleep', 'T' => 'Stopped', 'W' => 'Paging', 'X' => 'Dead', 'Z' => 'Zombie');
$_TITLE = 'Process Monitor';
include 'header.php'; ?>
<div class="wrapper" <?= empty($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest' ? '' : ' style="display: none;"' ?>>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li>
                                <a href="process_monitor?server=<?= intval(CoreUtilities::$rRequest['server']) ?>" style="margin-right:10px;">
                                    <button type="button" class="btn btn-dark waves-effect waves-light btn-sm">
                                        <i class="mdi mdi-refresh"></i> <?= $language::get('refresh') ?>
                                    </button>
                                </a>
                            </li>
                        </ol>
                    </div>
                    <h4 class="page-title"><?= $language::get('process_monitor') ?></h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <?php if (!$rMobile) { ?>
                    <?php if (count($rFS) > 0) { ?>
                        <div class="card">
                            <div class="card-body" style="overflow-x:auto;">
                                <table class="table table-borderless mb-0">
                                    <thead class="thead-light">
                                        <tr>
                                            <th><?= $language::get('mount_point') ?></th>
                                            <th class="text-center"><?= $language::get('size') ?></th>
                                            <th class="text-center"><?= $language::get('used') ?></th>
                                            <th class="text-center"><?= $language::get('available') ?></th>
                                            <th class="text-center"><?= $language::get('used') ?> %</th>
                                            <th class="text-center"><?= $language::get('actions') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($rFS as $fs) {
                                            if ($fs['percentage'] >= 80) {
                                                $_STATUS = STATUS_SPACE_ISSUE;
                                            } ?>
                                            <tr>
                                                <td><?= $fs['mount'] ?></td>
                                                <td class="text-center"><?= $fs['size'] ?></td>
                                                <td class="text-center"><?= $fs['used'] ?></td>
                                                <td class="text-center"><?= $fs['avail'] ?></td>
                                                <td class="text-center">
                                                    <?php if (intval(rtrim($fs['percentage'], '%')) >= 80) {
                                                        echo "<span class='text-danger'>" . $fs['percentage'] . '</span>';
                                                    } else {
                                                        echo $fs['percentage'];
                                                    } ?>
                                                </td>
                                                <td class="text-center">
                                                    <div class="btn-group">
                                                        <?php if (substr($fs['mount'], -3) == 'tmp') { ?>
                                                            <a href="./process_monitor?server=<?= intval(CoreUtilities::$rRequest['server']) ?>&clear">
                                                                <button data-toggle="tooltip" data-placement="top" title="<?= $language::get('clear_temp') ?>" type="button" class="btn btn-light waves-effect waves-light btn-xs">
                                                                    <i class="mdi mdi-close"></i>
                                                                </button>
                                                            </a>
                                                        <?php } elseif (substr($fs['mount'], -7) == 'streams') { ?>
                                                            <a href="./process_monitor?server=<?= intval(CoreUtilities::$rRequest['server']) ?>&clear_s">
                                                                <button data-toggle="tooltip" data-placement="top" title="<?= $language::get('clear_streams') ?>" type="button" class="btn btn-light waves-effect waves-light btn-xs">
                                                                    <i class="mdi mdi-close"></i>
                                                                </button>
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php if (isset($_STATUS) && $_STATUS == STATUS_SPACE_ISSUE) { ?>
                            <div class="alert alert-danger text-center" role="alert">
                                <strong>You are running out of space on one or more of your mount points. You should resolve this before issues occur.</strong>
                            </div>
                        <?php }
                        $ramdiskUsage = getStreamsRamdisk(CoreUtilities::$rRequest['server']);
                        $db->query('SELECT `stream_id`, `stream_display_name`, `bitrate` FROM `streams_servers` LEFT JOIN `streams` ON `streams`.`id` = `streams_servers`.`stream_id` WHERE `server_id` = ? AND `pid` > 0;', CoreUtilities::$rRequest['server']);
                        $rStreamNames = $db->get_rows(true, 'stream_id');
                        $streamUsage = array();
                        foreach ($ramdiskUsage as $rStreamID => $rUsage) {
                            if (isset($rStreamNames[$rStreamID])) {
                                $streamUsage[$rStreamID] = $rUsage;
                            }
                        }
                        asort($streamUsage);
                        $streamUsage = array_reverse($streamUsage, true);
                        $halfCount = ceil(count($streamUsage) / 2);
                        if ($halfCount > 10) {
                            $halfCount = 10;
                        }
                        $topUsage = array_slice($streamUsage, 0, $halfCount, true);
                        $bottomUsage = array_slice($streamUsage, $halfCount, $halfCount, true);
                        if ($halfCount > 0) { ?>
                            <div class="row" style="overflow-x:auto;">
                                <div class="col-md-6">
                                    <div class="card-box">
                                        <table class="table table-borderless mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th class="text-center">Stream ID</th>
                                                    <th>Stream Name</th>
                                                    <th class="text-center">Bitrate</th>
                                                    <th class="text-center">Mount Usage</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($topUsage as $rStreamID => $rUsage) { ?>
                                                    <tr>
                                                        <td class="text-center"><a class="text-dark" href="stream_view?id=<?= $rStreamID ?>"><?= $rStreamID ?></a></td>
                                                        <td><a class="text-dark" href="stream_view?id=<?= $rStreamID ?>"><?= $rStreamNames[$rStreamID]['stream_display_name'] ?></a></td>
                                                        <td class="text-center"><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed-min"><?= number_format($rStreamNames[$rStreamID]['bitrate'], 0) ?> Kbps</button></td>
                                                        <td class="text-center"><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed-min"><?= number_format($rUsage / 1024 / 1024, 0) ?> MB</button></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card-box">
                                        <table class="table table-borderless mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th class="text-center">Stream ID</th>
                                                    <th>Stream Name</th>
                                                    <th class="text-center">Bitrate</th>
                                                    <th class="text-center">Mount Usage</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($bottomUsage as $rStreamID => $rUsage) { ?>
                                                    <tr>
                                                        <td class="text-center"><a class="text-dark" href="stream_view?id=<?= $rStreamID ?>"><?= $rStreamID ?></a></td>
                                                        <td><a class="text-dark" href="stream_view?id=<?= $rStreamID ?>"><?= $rStreamNames[$rStreamID]['stream_display_name'] ?></a></td>
                                                        <td class="text-center"><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed-min"><?= number_format($rStreamNames[$rStreamID]['bitrate'], 0) ?> Kbps</button></td>
                                                        <td class="text-center"><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed-min"><?= number_format($rUsage / 1024 / 1024, 0) ?> MB</button></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <!-- Tabela de processos - sempre exibida -->
                    <div class="card">
                        <div class="card-body" style="overflow-x:auto;">
                            <form id="line_activity_search">
                                <div class="form-group row mb-4">
                                    <div class="col-md-6">
                                        <input type="text" class="form-control" id="live_search" value="" placeholder="<?= $language::get('search_processes') ?>...">
                                    </div>
                                    <label class="col-md-1 col-form-label text-center" for="live_filter"><?= $language::get('server') ?></label>
                                    <div class="col-md-3">
                                        <select id="live_filter" class="form-control" data-toggle="select2">
                                            <?php foreach ($rServers as $rServer) { ?>
                                                <option value="<?= $rServer['id'] ?>" <?= CoreUtilities::$rRequest['server'] == $rServer['id'] ? ' selected' : '' ?>><?= $rServer['server_name'] ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <label class="col-md-1 col-form-label text-center" for="live_show_entries"><?= $language::get('show') ?></label>
                                    <div class="col-md-1">
                                        <select id="live_show_entries" class="form-control" data-toggle="select2">
                                            <?php foreach (array(10, 25, 50, 250, 500, 1000) as $rShow) { ?>
                                                <option value="<?= $rShow ?>" <?= $rSettings['default_entries'] == $rShow ? ' selected' : '' ?>><?= $rShow ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </form>
                            <?php if (empty($rProcesses)): ?>
                                <div class="alert alert-warning text-center">
                                    <i class="mdi mdi-alert-circle-outline"></i> Unable to retrieve process list. The server API may be temporarily unavailable. Please try refreshing the page.
                                </div>
                            <?php endif; ?>
                            <table id="datatable-activity" class="table table-striped table-borderless dt-responsive nowrap">
                                <thead>
                                    <tr>
                                        <th><?= $language::get('pid') ?></th>
                                        <th><?= $language::get('type') ?></th>
                                        <th style="max-width: 100px !important;"><?= $language::get('process') ?></th>
                                        <th><?= $language::get('cpu_%') ?></th>
                                        <th><?= $language::get('mem_mb') ?></th>
                                        <th>Runtime</th>
                                        <th>CPU Time</th>
                                        <th><?= $language::get('actions') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($rProcesses as $rProcess) {
                                        // Calculate Uptime
                                        $uptime = (int) $rProcess['etime'];

                                        $days    = intdiv($uptime, 86400);
                                        $hours   = intdiv($uptime, 3600) % 24;
                                        $minutes = intdiv($uptime, 60) % 60;
                                        $seconds = $uptime % 60;

                                        $uptime = $uptime >= 86400 ? sprintf('%02dd %02dh %02dm', $days, $hours, $minutes) : sprintf('%02dh %02dm %02ds', $hours, $minutes, $seconds);

                                        // Calculate CPU Time
                                        $cpuTime = (int) $rProcess['time'];

                                        $days    = intdiv($cpuTime, 86400);
                                        $hours   = intdiv($cpuTime, 3600) % 24;
                                        $minutes = intdiv($cpuTime, 60) % 60;
                                        $seconds = $cpuTime % 60;

                                        $cpuTime = $cpuTime >= 86400 ? sprintf('%02dd %02dh %02dm', $days, $hours, $minutes) : sprintf('%02dh %02dm %02ds', $hours, $minutes, $seconds);

                                        $A134afcd6d59abf6 = array('proxy' => 'Live Proxy', 'llod' => 'LLOD', 'loopback' => 'Loopback', 'queue' => 'VOD Queue', 'ondemand' => 'On-Demand Instant Off', 'plex_item' => 'Plex Item Scan', 'watch_item' => 'Watch Item Scan', 'cache_handler' => 'Cache Handler', 'certbot' => 'Certbot SSL Automation', 'closed_cons' => 'Closed Connection Handler', 'signals' => 'Signal Handler', 'watchdog' => 'Server Watchdog');
                                        $rCrons = array('plex' => 'Plex Sync', 'cache_engine' => 'Cache Generator', 'activity' => 'Activity Cron', 'backups' => 'Backup Cron', 'cache' => 'Cache Cron', 'epg' => 'EPG Cron', 'lines_logs' => 'Line Logging Cron', 'root_signals' => 'Root Signal Cron', 'series' => 'Series Cron', 'servers' => 'Servers Cron', 'stats' => 'Stats Cron', 'streams' => 'Streams Cron', 'streams_logs' => 'Stream Logging Cron', 'tmdb' => 'TMDb Refresh Cron', 'tmp' => 'Temp Cron', 'users' => 'Users Cron', 'vod' => 'VOD Cron', 'watch' => 'Watch Folder Cron');

                                        if (isset($A134afcd6d59abf6[basename(explode(' ', trim(explode('#', $rProcess['command'])[0]))[0], '.php')])) {
                                            $rProcess['command'] = $A134afcd6d59abf6[basename(explode(' ', trim(explode('#', $rProcess['command'])[0]))[0], '.php')];
                                            $rType = 'streamera CLI';
                                        } else {
                                            if (isset($A134afcd6d59abf6[basename(trim(explode('#', $rProcess['command'])[0]), '.php')])) {
                                                $rProcess['command'] = $A134afcd6d59abf6[basename(trim(explode('#', $rProcess['command'])[0]), '.php')];
                                                $rType = 'streamera CLI';
                                            } else {
                                                if (isset($rCrons[basename(explode(' ', trim(explode('#', $rProcess['command'])[0]))[0], '.php')])) {
                                                    $rProcess['command'] = $rCrons[basename(explode(' ', trim(explode('#', $rProcess['command'])[0]))[0], '.php')];
                                                    $rType = 'streamera Cron';
                                                } else {
                                                    if (stripos($rProcess['command'], 'nginx: master process') !== false) {
                                                        $rProcess['command'] = 'NGINX Master Process';
                                                        $rType = 'NGINX Master';
                                                    } else {
                                                        if (stripos($rProcess['command'], 'nginx: worker process') !== false) {
                                                            $rProcess['command'] = 'NGINX Worker Process';
                                                            $rType = 'NGINX Pool';
                                                        } else {
                                                            if (stripos($rProcess['command'], 'php-fpm: master process') !== false) {
                                                                $rProcess['command'] = 'PHP Master Process';
                                                                $rType = 'PHP Master';
                                                            } else {
                                                                if (stripos($rProcess['command'], 'redis-server') !== false) {
                                                                    $rProcess['command'] = 'Redis Server';
                                                                    $rType = 'Redis';
                                                                } else {
                                                                    $rProcess['command'] = 'Command: ' . $rProcess['command'];
                                                                    $rType = array('pid' => $language::get('main') . ' - ', 'vframes' => $language::get('thumbnail') . ' - ', 'monitor_pid' => $language::get('monitor') . ' - ', 'delay_pid' => $language::get('delayed') . ' - ', 'activity' => $language::get('line_activity') . ' - ', 'timeshift' => $language::get('timeshift') . ' - ', null => '')[$rStreams[$rProcess['pid']]['pid_type'] ?? null] . array(1 => $language::get('stream'), 2 => $language::get('movie'), 3 => $language::get('created_channel'), 4 => $language::get('radio'), 5 => $language::get('episode'), null => $language::get('system'))[$rStreams[$rProcess['pid']]['type'] ?? null];
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    ?>

                                        <tr>
                                            <td><?= $rProcess['pid'] ?></td>
                                            <td><?= $rType ?></td>
                                            <td style="max-width: 700px !important; overflow: hidden;"><?= $rProcess['command'] ?></td>
                                            <td><button type="button" class="btn btn-light btn-xs waves-effect waves-light"><?= number_format($rProcess['cpu'], 2) ?>%</button><br /><small>avg: <?= number_format($rProcess['load_average'], 2) ?>%</small></td>
                                            <td><button type="button" class="btn btn-light btn-xs waves-effect waves-light"><?= number_format($rProcess['rss'] / 1024, 0) ?></button></td>
                                            <td><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed"><?= $uptime ?></button></td>
                                            <td><button type="button" class="btn btn-light btn-xs waves-effect waves-light btn-fixed"><?= $cpuTime ?></button></td>
                                            <td>
                                                <div class="btn-group">
                                                    <?php if (isset($rStreams[$rProcess['pid']])) { ?>
                                                        <a href="<?= array(1 => 'stream_view', 2 => 'stream_view', 3 => 'stream_view', 4 => 'stream_view', 5 => 'stream_view')[$rStreams[$rProcess['pid']]['type']] . '?id=' . $rStreams[$rProcess['pid']]['id'] ?>">
                                                            <button data-toggle="tooltip" data-placement="top" title="<?= $language::get('view') ?>" type="button" class="btn btn-light waves-effect waves-light btn-xs"><i class="mdi mdi-eye"></i></button>
                                                        </a>
                                                    <?php } else { ?>
                                                        <button disabled type="button" class="btn btn-light waves-effect waves-light btn-xs"><i class="mdi mdi-eye"></i></button>
                                                    <?php } ?>
                                                    <button data-toggle="tooltip" data-placement="top" title="<?= $language::get('kill_process_info') ?>" type="button" class="btn btn-light waves-effect waves-light btn-xs" onClick="kill(<?= intval(CoreUtilities::$rRequest['server']) ?>, <?= $rProcess['pid'] ?>);"><i class="mdi mdi-close"></i></button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>
<script id="scripts">
    var resizeObserver = new ResizeObserver(entries => $(window).scroll());
    $(document).ready(function() {
        resizeObserver.observe(document.body)
        $("form").attr('autocomplete', 'off');
        $(document).keypress(function(event) {
            if (event.which == 13 && event.target.nodeName != "TEXTAREA") return false;
        });
        $.fn.dataTable.ext.errMode = 'none';
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        elems.forEach(function(html) {
            var switchery = new Switchery(html, {
                'color': '#414d5f'
            });
            window.rSwitches[$(html).attr("id")] = switchery;
        });
        setTimeout(pingSession, 30000);
        <?php if (!$rMobile && $rSettings['header_stats']): ?>
            headerStats();
        <?php endif; ?>
        bindHref();
        refreshTooltips();
        $(window).scroll(function() {
            if ($(this).scrollTop() > 200) {
                if ($(document).height() > $(window).height()) {
                    $('#scrollToBottom').fadeOut();
                }
                $('#scrollToTop').fadeIn();
            } else {
                $('#scrollToTop').fadeOut();
                if ($(document).height() > $(window).height()) {
                    $('#scrollToBottom').fadeIn();
                } else {
                    $('#scrollToBottom').hide();
                }
            }
        });
        $("#scrollToTop").unbind("click");
        $('#scrollToTop').click(function() {
            $('html, body').animate({
                scrollTop: 0
            }, 800);
            return false;
        });
        $("#scrollToBottom").unbind("click");
        $('#scrollToBottom').click(function() {
            $('html, body').animate({
                scrollTop: $(document).height()
            }, 800);
            return false;
        });
        $(window).scroll();
        $(".nextb").unbind("click");
        $(".nextb").click(function() {
            var rPos = 0;
            var rActive = null;
            $(".nav .nav-item").each(function() {
                if ($(this).find(".nav-link").hasClass("active")) {
                    rActive = rPos;
                }
                if (rActive !== null && rPos > rActive && !$(this).find("a").hasClass("disabled") && $(this).is(":visible")) {
                    $(this).find(".nav-link").trigger("click");
                    return false;
                }
                rPos += 1;
            });
        });
        $(".prevb").unbind("click");
        $(".prevb").click(function() {
            var rPos = 0;
            var rActive = null;
            $($(".nav .nav-item").get().reverse()).each(function() {
                if ($(this).find(".nav-link").hasClass("active")) {
                    rActive = rPos;
                }
                if (rActive !== null && rPos > rActive && !$(this).find("a").hasClass("disabled") && $(this).is(":visible")) {
                    $(this).find(".nav-link").trigger("click");
                    return false;
                }
                rPos += 1;
            });
        });
        (function($) {
            $.fn.inputFilter = function(inputFilter) {
                return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
                    if (inputFilter(this.value)) {
                        this.oldValue = this.value;
                        this.oldSelectionStart = this.selectionStart;
                        this.oldSelectionEnd = this.selectionEnd;
                    } else if (this.hasOwnProperty("oldValue")) {
                        this.value = this.oldValue;
                        this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                    }
                });
            };
        }(jQuery));
        <?php if ($rSettings['js_navigate']): ?>
            $(".navigation-menu li").mouseenter(function() {
                $(this).find(".submenu").show();
            });
            delParam("status");
            $(window).on("popstate", function() {
                if (window.rRealURL) {
                    if (window.rRealURL.split("/").reverse()[0].split("?")[0].split(".")[0] != window.location.href.split("/").reverse()[0].split("?")[0].split(".")[0]) {
                        navigate(window.location.href.split("/").reverse()[0]);
                    }
                }
            });
        <?php endif; ?>
        $(document).keydown(function(e) {
            if (e.keyCode == 16) {
                window.rShiftHeld = true;
            }
        });
        $(document).keyup(function(e) {
            if (e.keyCode == 16) {
                window.rShiftHeld = false;
            }
        });
        document.onselectstart = function() {
            if (window.rShiftHeld) {
                return false;
            }
        }
    });

    <?php
    echo '        ' . "\r\n\t\t" . 'function kill(rServerID, rID) {' . "\r\n\t\t\t" . '$.getJSON("./api?action=process&pid=" + rID + "&server=" + rServerID, function(data) {' . "\r\n\t\t\t\t" . 'if (data.result === true) {' . "\r\n\t\t\t\t\t" . '$.toast("';
    echo $language::get('process_has_been_killed_wait');
    echo '");' . "\r\n\t\t\t\t" . '} else {' . "\r\n\t\t\t\t\t" . '$.toast("';
    echo $language::get('error_occured');
    echo '");' . "\r\n\t\t\t\t" . '}' . "\r\n\t\t\t" . '});' . "\r\n\t\t" . '}' . "\r\n\t\t" . '$(document).ready(function() {' . "\r\n\t\t\t" . "\$('select').select2({width: '100%'});" . "\r\n\t\t\t" . 'if ($("#datatable-activity").length) {' . "\r\n\t\t\t\t" . '$("#datatable-activity").DataTable({' . "\r\n\t\t\t\t\t" . 'language: {' . "\r\n\t\t\t\t\t\t" . 'paginate: {' . "\r\n\t\t\t\t\t\t\t" . "previous: \"<i class='mdi mdi-chevron-left'>\"," . "\r\n\t\t\t\t\t\t\t" . "next: \"<i class='mdi mdi-chevron-right'>\"" . "\r\n\t\t\t\t\t\t" . '},' . "\r\n\t\t\t\t\t\t" . 'infoFiltered: ""' . "\r\n\t\t\t\t\t" . '},' . "\r\n\t\t\t\t\t" . 'drawCallback: function() {' . "\r\n\t\t\t\t\t\t" . 'bindHref(); refreshTooltips();' . "\r\n\t\t\t\t\t" . '},' . "\r\n\t\t\t\t\t" . 'responsive: false,' . "\r\n\t\t\t\t\t" . 'processing: true,' . "\r\n\t\t\t\t\t" . 'columnDefs: [' . "\r\n\t\t\t\t\t\t" . '{"className": "dt-center", "targets": [0,3,4,5,6]}' . "\r\n\t\t\t\t\t" . '],' . "\r\n\t\t\t\t\t";

    if (isset(CoreUtilities::$rRequest['mem'])) {
        echo 'order: [[ 4, "desc" ]],' . "\r\n\t\t\t\t\t";
    } else {
        echo 'order: [[ 3, "desc" ]],' . "\r\n\t\t\t\t\t";
    }

    echo 'pageLength: ';
    echo (intval($rSettings['default_entries']) ?: 10);
    echo ',' . "\r\n\t\t\t\t\t" . 'lengthMenu: [10, 25, 50, 250, 500, 1000]' . "\r\n\t\t\t\t" . '});' . "\r\n\t\t\t\t" . '$("#datatable-activity").css("width", "100%");' . "\r\n\t\t\t\t" . "\$('#live_search').keyup(function(){" . "\r\n\t\t\t\t\t" . "\$('#datatable-activity').DataTable().search(\$(this).val()).draw();" . "\r\n\t\t\t\t" . '});' . "\r\n\t\t\t\t" . "\$('#live_show_entries').change(function(){" . "\r\n\t\t\t\t\t" . "\$('#datatable-activity').DataTable().page.len(\$(this).val()).draw();" . "\r\n\t\t\t\t" . '});' . "\r\n\t\t\t\t" . "\$('#live_filter').change(function(){" . "\r\n\t\t\t\t\t" . 'navigate("./process_monitor?server=" + $(this).val());' . "\r\n\t\t\t\t" . '});' . "\r\n\t\t\t\t" . "\$('#datatable-activity').DataTable().search(\$('#live_search').val()).draw();" . "\r\n\t\t\t" . '}' . "\r\n\t\t" . '});' . "\r\n" . '        ' . "\r\n" . '        ';
    ?>
    <?php if (CoreUtilities::$rSettings['enable_search']): ?>
        $(document).ready(function() {
            initSearch();
        });
    <?php endif; ?>
</script>
<script src="assets/js/listings.js"></script>
</body>

</html>

?>