SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- --------------------------------------------------------

--
-- Table structure for table `access_codes`
--

CREATE TABLE IF NOT EXISTS `access_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` tinyint(4) DEFAULT '0',
  `enabled` tinyint(4) DEFAULT '0',
  `groups` mediumtext COLLATE utf8_unicode_ci,
  `whitelist` mediumtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blocked_asns`
--

CREATE TABLE IF NOT EXISTS `blocked_asns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asn` int(5) DEFAULT '0',
  `isp` varchar(256) DEFAULT NULL,
  `domain` varchar(256) DEFAULT NULL,
  `country` varchar(16) DEFAULT NULL,
  `num_ips` int(16) DEFAULT '0',
  `type` varchar(64) DEFAULT NULL,
  `allocated` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `blocked` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `asn` (`asn`)
) ENGINE=InnoDB AUTO_INCREMENT=68952 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `blocked_asns`
--

INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(1, 1, 'Level 3 Parent, LLC', 'level3.com', 'US', 11520, 'isp', '2001-09-20 00:00:00', 0),
(2, 10, 'CSNET Coordination and Information Center (CSNET-CIC)', 'genuity.com', 'US', 3072, 'business', '0000-00-00 00:00:00', 0),
(3, 100, 'FMC Central Engineering Laboratories', 'fmc.com', 'US', 1536, 'isp', '1987-02-26 00:00:00', 0),
(4, 10000, 'Nagasaki Cable Media Inc.', 'cncm.ne.jp', 'JP', 69632, 'isp', '0000-00-00 00:00:00', 0),
(5, 10001, 'Mics Network Corporation', 'catvmics.ne.jp', 'JP', 37120, 'isp', '0000-00-00 00:00:00', 0),
(6, 10002, 'IGAUENO CABLE TELEVISION CO.,LTD', 'ict.ne.jp', 'JP', 24576, 'isp', '0000-00-00 00:00:00', 0),
(7, 10003, 'Ogaki Cable Television Co.,Inc.', 'ogaki-tv.co.jp', 'JP', 36864, 'isp', '0000-00-00 00:00:00', 0),
(8, 10004, 'JIN Office Service Inc.', 'None', 'JP', 20992, 'isp', '0000-00-00 00:00:00', 0),
(9, 10006, 'SECOM Trust Systems Co.,Ltd.', 'secomtrust.net', 'JP', 59392, 'isp', '0000-00-00 00:00:00', 0),
(10, 1001, 'GONET', 'go-net.co.id', 'CA', 1536, 'isp', '1990-08-07 00:00:00', 0),
(11, 10010, 'TOKAI Communications Corporation', 'tokai.or.jp', 'JP', 1429760, 'isp', '0000-00-00 00:00:00', 0),
(12, 10011, 'advanscope.inc', 'catv-ads.jp', 'JP', 18432, 'isp', '0000-00-00 00:00:00', 0),
(13, 10012, 'Rakuten Mobile, Inc.', 'rakuten.co.jp', 'JP', 24576, 'isp', '0000-00-00 00:00:00', 0),
(14, 10013, 'FreeBit Co.,Ltd.', 'freebit.com', 'JP', 1863168, 'isp', '0000-00-00 00:00:00', 0),
(15, 10014, 'Nihon University', 'nihon-u.ac.jp', 'JP', 65536, 'education', '0000-00-00 00:00:00', 0),
(16, 10015, 'Cyber Wave Japan Co., Ltd.', 'cwj.jp', 'JP', 6400, 'hosting', '0000-00-00 00:00:00', 0),
(17, 10016, 'Minaminihon Information Processing Center Co Ltd', 'None', 'JP', 4096, 'hosting', '0000-00-00 00:00:00', 0),
(18, 10019, 'Matsusaka Cable-TV Station Inc.', 'mctv.jp', 'JP', 40960, 'isp', '0000-00-00 00:00:00', 0),
(19, 10021, 'KVH Co.,Ltd', 'kvh.ne.jp', 'JP', 125952, 'isp', '0000-00-00 00:00:00', 0),
(20, 10022, 'Internet access for Datacom Systems Auckland', 'datacom.co.nz', 'NZ', 16640, 'isp', '0000-00-00 00:00:00', 0),
(21, 10023, 'Vixtel Pty Ltd Ineternet Service Provider Australia', 'vixtel.com.au', 'AU', 8192, 'business', '0000-00-00 00:00:00', 0),
(22, 10024, 'LGA International', 'lga.net.sg', 'SG', 23552, 'isp', '0000-00-00 00:00:00', 0),
(23, 10025, 'The IUSN Foundation', 'niue.nu', 'NU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(24, 10026, 'Telstra Global Internet Services Network Blocks', 'telstra.com.au', 'JP', 435200, 'isp', '0000-00-00 00:00:00', 0),
(25, 10029, 'SHYAM SPECTRA PVT LTD', 'spectra.co', 'IN', 125952, 'isp', '0000-00-00 00:00:00', 0),
(26, 10030, 'Celcom Axiata Berhad', 'celcom.com.my', 'MY', 74752, 'isp', '0000-00-00 00:00:00', 0),
(27, 10031, 'WEBSATMEDIA PTE LTD, Satellite Over IP, Singapore', 'websatmedia.com', 'SG', 9984, 'business', '0000-00-00 00:00:00', 0),
(28, 10032, 'HGC Global Communications Limited', 'hgc.com.hk', 'HK', 17408, 'isp', '0000-00-00 00:00:00', 0),
(29, 10034, 'SEOUL AGRICULTURAL   MARINE PRODUCTS CORP.', 'garak.co.kr', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(30, 10035, 'Hyundai Department Store Co., Ltd.', 'ehyundai.com', 'KR', 2304, 'business', '0000-00-00 00:00:00', 0),
(31, 10036, 'DLIVE', 'dlive.kr', 'KR', 831488, 'isp', '0000-00-00 00:00:00', 0),
(32, 10037, 'LG HelloVision Corp.', 'lghellovision.net', 'KR', 50432, 'isp', '0000-00-00 00:00:00', 0),
(33, 10038, 'NHN PlayMuseum', 'nhn.com', 'KR', 256, 'isp', '0000-00-00 00:00:00', 0),
(34, 10039, 'Korea Health Industry Development Institute', 'khidi.or.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(35, 10040, 'NICE Information   Telecommunication, Inc', 'nicevan.co.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(36, 10041, 'ShinhanCapital', 'shinhan.com', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(37, 10042, 'SUSEONG COLLEGE', 'sc.ac.kr', 'KR', 2048, 'education', '0000-00-00 00:00:00', 0),
(38, 10043, 'Ministry of Science and ICT', 'msip.go.kr', 'KR', 512, 'isp', '0000-00-00 00:00:00', 0),
(39, 10044, 'Rural Development Administration (RDA)', 'korea.kr', 'KR', 1792, 'isp', '0000-00-00 00:00:00', 0),
(40, 10045, 'Hanbat National University', 'hanbat.ac.kr', 'KR', 9728, 'education', '0000-00-00 00:00:00', 0),
(41, 10047, 'Namseoul university', 'nsu.ac.kr', 'KR', 2048, 'education', '0000-00-00 00:00:00', 0),
(42, 10049, 'SK Co.,', 'sk.com', 'KR', 131072, 'isp', '0000-00-00 00:00:00', 0),
(43, 10050, 'The National Library of Korea', 'korea.kr', 'KR', 768, 'isp', '0000-00-00 00:00:00', 0),
(44, 10051, 'Korea Post Information Center', 'korea.kr', 'KR', 768, 'isp', '0000-00-00 00:00:00', 0),
(45, 10052, 'Kyungpook National University', 'knu.ac.kr', 'KR', 67584, 'education', '0000-00-00 00:00:00', 0),
(46, 10053, 'yeonsung University', 'yeonsung.ac.kr', 'KR', 5120, 'education', '0000-00-00 00:00:00', 0),
(47, 10054, 'CMB Kwangju Broadcasting', 'cmb.co.kr', 'KR', 76800, 'isp', '0000-00-00 00:00:00', 0),
(48, 10055, 'Korean National Railroad Administration', 'korail.com', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(49, 10056, 'Hyundai Marin   Fire Insurance', 'hi.co.kr', 'KR', 1280, 'business', '0000-00-00 00:00:00', 0),
(50, 10057, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 256, 'business', '1998-11-03 00:00:00', 0),
(51, 10058, 'NACUFOK', 'cu.co.kr', 'KR', 1280, 'business', '0000-00-00 00:00:00', 0),
(52, 10059, 'LG DACOM KIDC', 'kidc.net', 'KR', 256, 'business', '0000-00-00 00:00:00', 0),
(53, 10060, 'YONSEI UNIVERSITY HEALTH SYSTEM', 'yuhs.ac', 'KR', 5376, 'education', '0000-00-00 00:00:00', 0),
(54, 10062, 'Branksome Hall Asia', 'branksome.asia', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(55, 10063, 'Korea Meteorological Administration', 'korea.kr', 'KR', 2560, 'isp', '0000-00-00 00:00:00', 0),
(56, 10064, 'GEPS Cheonan Sagnokresort', 'nate.com', 'KR', 512, 'isp', '0000-00-00 00:00:00', 0),
(57, 10065, 'NICE TCM', 'nicetcm.co.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(58, 10066, 'LG HelloVision Corp.', 'lghellovision.net', 'KR', 139520, 'isp', '0000-00-00 00:00:00', 0),
(59, 10069, 'Seoul Metro', 'seoulmetro.co.kr', 'KR', 768, 'education', '0000-00-00 00:00:00', 0),
(60, 10070, 'KRISS SubDAEJONnetworks connected to backbone', 'kriss.re.kr', 'KR', 4096, 'business', '0000-00-00 00:00:00', 0),
(61, 10071, 'anyang University', 'anyang.ac.kr', 'KR', 6656, 'education', '0000-00-00 00:00:00', 0),
(62, 10072, 'Shinhan Bank', 'shinhan.com', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(63, 10073, 'Korea National Open University', 'knou.ac.kr', 'KR', 4864, 'education', '0000-00-00 00:00:00', 0),
(64, 10074, 'iBasis Singapore ICO', 'ibasis.net', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(65, 10075, 'Fiber@Home Global Limited', 'fiberathome.net', 'BD', 3328, 'business', '0000-00-00 00:00:00', 0),
(66, 10076, 'ERDEMNET Mongolian National Research and Education Network', 'erdemnet.mn', 'MN', 4096, 'education', '0000-00-00 00:00:00', 0),
(67, 10080, 'B.L NANKIVELL & R.G NANKIVELL T/A RBE INTERNET SERVICES', 'rbe.net.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(68, 10081, 'DiGi Telecommunications Sdn Bhd', 'digi.com.my', 'MY', 40960, 'isp', '0000-00-00 00:00:00', 0),
(69, 10082, 'Morgan Stanley Asia Limited', 'morganstanley.com', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(70, 10083, 'Cynergic Internet', 'cynergic.net', 'AU', 5888, 'business', '0000-00-00 00:00:00', 0),
(71, 10084, 'Western Australian Internet Association', 'internet.asn.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(72, 10085, 'PEER WITH OVERSEA ISP', 'chief.com.tw', 'TW', 16640, 'isp', '0000-00-00 00:00:00', 0),
(73, 10087, 'Printed Circuits Manufacturer', 'topsearch.com.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(74, 10088, 'KWANGWOON UNIVERSITY', 'kw.ac.kr', 'KR', 20992, 'education', '0000-00-00 00:00:00', 0),
(75, 10089, 'Total Access Communication PLC.', 'dtac.co.th', 'TH', 2304, 'isp', '0000-00-00 00:00:00', 0),
(76, 10094, 'Unified National Networks', 'unn.com.bn', 'BN', 117248, 'isp', '0000-00-00 00:00:00', 0),
(77, 10096, 'Easycall Communications Phils., Inc.', 'eperformax.com', 'PH', 8192, 'business', '0000-00-00 00:00:00', 0),
(78, 10097, 'FLOWCOM', 'None', 'AU', 4096, 'hosting', '0000-00-00 00:00:00', 0),
(79, 10098, 'Towngas Telecommunications Fixed Network Ltd', 'towngastelecom.com', 'HK', 19456, 'isp', '0000-00-00 00:00:00', 0),
(80, 10099, 'China Unicom Global', 'chinaunicom.cn', 'HK', 23808, 'isp', '0000-00-00 00:00:00', 0),
(81, 101, 'University of Washington', 'washington.edu', 'US', 5120, 'education', '1987-03-31 00:00:00', 0),
(82, 10100, 'UBS Group AG', 'ubs.com', 'CH', 15616, 'business', '0000-00-00 00:00:00', 0),
(83, 10101, 'UNN-BN', 'unn.com.bn', 'BN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(84, 10102, '1Asia Communication Pte Ltd', '1asia-ahl.com', 'SG', 4096, 'business', '0000-00-00 00:00:00', 0),
(85, 10103, 'HK Broadband Network Ltd.', 'hkbn.com.hk', 'HK', 116480, 'isp', '0000-00-00 00:00:00', 0),
(86, 10105, 'OMNIconnect Pty Ltd', 'omniconnect.com.au', 'AU', 8192, 'hosting', '0000-00-00 00:00:00', 0),
(87, 10106, 'Federation Training', 'federationtraining.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(88, 10108, 'DRESDNER KLEINWORT WASSERSTEIN,', 'drkw.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(89, 10109, 'Topica LLC, Internet Service Provider,Ulaanbaatar, Mongolia', 'topica.mn', 'MN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(90, 10110, 'Manukau Institute of Technology', 'manukau.ac.nz', 'NZ', 768, 'education', '0000-00-00 00:00:00', 0),
(91, 10111, 'Zeofast Network', 'zeofast.cn', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(92, 10112, 'THE VALUE HOSTED (PVT.) LIMITED', 'valuehosted.com', 'PK', 512, 'hosting', '0000-00-00 00:00:00', 0),
(93, 10113, 'Eftel Limited.', 'eftel.com', 'AU', 60416, 'isp', '0000-00-00 00:00:00', 0),
(94, 10115, 'Australian Taxation OAffice', 'ato.gov.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(95, 10116, 'Hutchison Telephone Company Limited', 'hknet.com', 'HK', 2304, 'business', '0000-00-00 00:00:00', 0),
(96, 10118, 'Hutchison Telephone Company Limited', 'hthk.com', 'HK', 46080, 'isp', '0000-00-00 00:00:00', 0),
(97, 10120, 'IBM Sinapore Server Farm', 'ibm.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(98, 10121, 'RISK MANAGEMENT SOLUTIONS INDIA PRIVATE LIMITED', 'rms.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(99, 10122, 'BIGO TECHNOLOGY PTE. LTD.', 'bigo.sg', 'SG', 26112, 'business', '0000-00-00 00:00:00', 0),
(100, 10123, 'Flytxt Mobile Solutions Pvt Ltd', 'flytxt.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(101, 10125, 'INTERGLOBE IS A LARGE BPO AND IT COMPANY IN TRAVEL DOMAIN', 'interglobetechnologies.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(102, 10126, 'Taiwan Internet Gateway', 'chti.com.tw', 'TW', 34816, 'isp', '0000-00-00 00:00:00', 0),
(103, 10127, 'CLSA Ltd', 'clsa.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(104, 10128, 'Optus Customer Network', 'optus.net.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(105, 10129, 'Salomon Smith Barney Australia Pty Ltd', 'ssmb.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(106, 1013, 'GONET', 'ontario.ca', 'CA', 256, 'isp', '1990-08-07 00:00:00', 0),
(107, 10131, 'Telecom Cook Islands', 'telecom.co.ck', 'CK', 6912, 'isp', '0000-00-00 00:00:00', 0),
(108, 10132, 'Towngas Telecommunications Fixed Network Ltdetwork Ltd', 'towngastelecom.com', 'HK', 32768, 'isp', '0000-00-00 00:00:00', 0),
(109, 10133, 'Chief Telecom Inc.', 'chief.com.tw', 'TW', 512, 'isp', '0000-00-00 00:00:00', 0),
(110, 10135, 'EASPNET Inc.', 'twnic.net.tw', 'TW', 16384, 'isp', '0000-00-00 00:00:00', 0),
(111, 10137, 'Patrakom Internet Service Provider', 'patrakom.co.id', 'ID', 11264, 'isp', '0000-00-00 00:00:00', 0),
(112, 10138, 'iBasis-Sydney ICO', 'ibasis.net', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(113, 10139, 'Smart Broadband, Inc.', 'smart.com.ph', 'PH', 176384, 'isp', '0000-00-00 00:00:00', 0),
(114, 10141, 'DFNN Group of Companies', 'dfnn.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(115, 10143, 'Exetel Pty Ltd', 'exetel.com.au', 'AU', 174592, 'isp', '0000-00-00 00:00:00', 0),
(116, 10145, 'SecureIP', 'secureip.net.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(117, 10146, 'Ford Motor Company', 'ford.com', 'SG', 4352, 'business', '0000-00-00 00:00:00', 0),
(118, 10148, 'The University of Melbourne, Melbourne, Victoria', 'unimelb.edu.au', 'AU', 80896, 'education', '0000-00-00 00:00:00', 0),
(119, 10150, 'Optus Customer Network', 'optus.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(120, 10151, 'IT One Co., Ltd.', 'itoneco.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(121, 10152, 'NEC Australia Pty Ltd', 'nec.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(122, 10155, 'KOSME', 'kosme.or.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(123, 10156, 'Seoul National University of Education', 'snue.ac.kr', 'KR', 1280, 'education', '0000-00-00 00:00:00', 0),
(124, 10157, 'NHN Bugs', 'bugs.co.kr', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(125, 10158, 'Kakao Corp', 'kakaocorp.com', 'KR', 5376, 'isp', '0000-00-00 00:00:00', 0),
(126, 10159, 'HANKUK Aviation University', 'hau.ac.kr', 'KR', 10496, 'education', '0000-00-00 00:00:00', 0),
(127, 10160, 'KDDI KOREA', 'kddi.co.kr', 'KR', 16384, 'business', '0000-00-00 00:00:00', 0),
(128, 10161, 'QIA', 'korea.kr', 'KR', 256, 'isp', '0000-00-00 00:00:00', 0),
(129, 10162, 'SNUH', 'snuh.org', 'KR', 4352, 'business', '0000-00-00 00:00:00', 0),
(130, 10164, 'T Broad', 'tbroad.com', 'KR', 69632, 'isp', '0000-00-00 00:00:00', 0),
(131, 10165, 'KOREA CUSTOMS SERVICE', 'customs.go.kr', 'KR', 1536, 'business', '0000-00-00 00:00:00', 0),
(132, 10166, 'Korea Water Resources Corporation', 'kwater.or.kr', 'KR', 8192, 'business', '0000-00-00 00:00:00', 0),
(133, 10167, 'HANVIT BANK', 'woorifis.com', 'KR', 1792, 'business', '0000-00-00 00:00:00', 0),
(134, 10169, 'AMOREPACIFIC', 'amorepacific.com', 'KR', 2048, 'business', '0000-00-00 00:00:00', 0),
(135, 10170, 'The Bank of Korea', 'bok.or.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(136, 10171, 'SKTelink', 'sk.com', 'KR', 86016, 'isp', '0000-00-00 00:00:00', 0),
(137, 10173, 'KSNET.Inc', 'ksnet.co.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(138, 10174, 'Munhwa Broadcasting Corporation', 'mbc.co.kr', 'KR', 8192, 'business', '0000-00-00 00:00:00', 0),
(139, 10175, 'Kumho Cable', 'hcn.co.kr', 'KR', 46080, 'isp', '0000-00-00 00:00:00', 0),
(140, 10176, 'Daejon Metropolitan Office of Education', 'korea.kr', 'KR', 27648, 'isp', '0000-00-00 00:00:00', 0),
(141, 10177, 'FUBON HYUNDAI LIFE INSURANCE CO.,LTD', 'fubonhyundai.com', 'KR', 256, 'business', '0000-00-00 00:00:00', 0),
(142, 10179, 'Daehan Investment Trust Securities', 'hanafn.com', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(143, 10180, 'Duksung Womens University', 'duksung.ac.kr', 'KR', 4096, 'education', '0000-00-00 00:00:00', 0),
(144, 10182, 'Korea Shipping Association', 'oo.kr', 'KR', 768, 'business', '0000-00-00 00:00:00', 0),
(145, 10183, 'Korea Culture Information Service Agency', 'kcisa.kr', 'KR', 768, 'business', '0000-00-00 00:00:00', 0),
(146, 10184, 'Korean Federation of Community Credit Cooperatives', 'kfcc.co.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(147, 10185, 'Hana Bank Co.', 'hanabank.com', 'KR', 5632, 'business', '0000-00-00 00:00:00', 0),
(148, 10186, 'Korean Red Cross', 'redcross.or.kr', 'KR', 1280, 'business', '0000-00-00 00:00:00', 0),
(149, 10187, 'Korea Information Society Developement Institute', 'kisdi.re.kr', 'KR', 1792, 'business', '0000-00-00 00:00:00', 0),
(150, 10188, 'Songdo Chadwick international School', 'chadwickschool.org', 'KR', 1024, 'education', '0000-00-00 00:00:00', 0),
(151, 10189, 'Hyundai Movex', 'hyundaimovex.com', 'KR', 7936, 'business', '0000-00-00 00:00:00', 0),
(152, 10190, 'Joongbu University', 'joongbu.ac.kr', 'KR', 9984, 'education', '0000-00-00 00:00:00', 0),
(153, 10191, 'SEEGENE MEDICAL FOUNDATION', 'seegene.com', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(154, 10192, 'kiwoom Securities.co.,Ltd', 'kiwoom.com', 'KR', 256, 'business', '0000-00-00 00:00:00', 0),
(155, 10193, 'BUSANBANK', 'busanbank.co.kr', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(156, 10194, 'Doosan Heavy Industries   Construction Co.Ltd', 'doosan.com', 'KR', 16384, 'business', '0000-00-00 00:00:00', 0),
(157, 10195, 'HAIonNet', 'haion.net', 'KR', 1280, 'business', '0000-00-00 00:00:00', 0),
(158, 10196, 'KOOKMIN BANK', 'kbstar.com', 'KR', 1536, 'business', '0000-00-00 00:00:00', 0),
(159, 10197, 'Chonnam National University', 'jnu.ac.kr', 'KR', 65536, 'education', '0000-00-00 00:00:00', 0),
(160, 10198, 'Catholic University of Pusan', 'cup.ac.kr', 'KR', 2560, 'education', '0000-00-00 00:00:00', 0),
(161, 10199, 'Tata Communications Ltd', 'tatacommunications.com', 'IN', 219648, 'isp', '0000-00-00 00:00:00', 0),
(162, 102, 'National Science Foundation', 'nsf.gov', 'US', 66048, 'business', '1987-03-31 00:00:00', 0),
(163, 10200, 'Web hosting provider and ISP connectivity.', 'kc.net.nz', 'NZ', 1536, 'isp', '0000-00-00 00:00:00', 0),
(164, 10201, 'Dishnet Wireless Limited. Broadband Wireless', 'aircel.co.in', 'IN', 2304, 'business', '0000-00-00 00:00:00', 0),
(165, 10202, 'BOC International Holdings Limited', 'bociholdings.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(166, 10204, 'Arcnet NTT MSC ISP', 'ntt.com', 'MY', 18176, 'isp', '0000-00-00 00:00:00', 0),
(167, 10205, 'ON.CC(HK) LIMITED', 'on.cc', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(168, 10206, 'China Unicom Zhongwei Cloud', 'chinaunicom.cn', 'CN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(169, 10207, 'Intervolve Pty Ltd', 'intervolve.com.au', 'AU', 3328, 'isp', '0000-00-00 00:00:00', 0),
(170, 10208, 'PT. Millenium Internetindo', 'the.net.id', 'ID', 5632, 'business', '0000-00-00 00:00:00', 0),
(171, 10209, 'Japan HUB and Data Center', 'synopsys.com', 'JP', 768, 'business', '0000-00-00 00:00:00', 0),
(172, 10212, 'China Enterprise ICT Solutions Limited', 'china-entercom.net', 'CN', 94208, 'isp', '0000-00-00 00:00:00', 0),
(173, 10213, 'Workcover Corporation', 'workcover.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(174, 10214, 'Pentanet Pty Ltd - bringing Perth\'s internet up to speed', 'pentanet.com.au', 'AU', 6912, 'isp', '0000-00-00 00:00:00', 0),
(175, 10215, 'Microland Limited. IT Infra Service Provider. India', 'microland.net', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(176, 10217, 'PT. NTT Indonesia', 'ntt.net.id', 'ID', 40960, 'isp', '0000-00-00 00:00:00', 0),
(177, 10218, 'Optus Customer Network', 'optus.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(178, 10219, 'SKYMEDIA CORPORATION LLC', 'skymedia.mn', 'MN', 11008, 'isp', '0000-00-00 00:00:00', 0),
(179, 10220, 'PT. Sejahtera  Globalindo', 'snet.net.id', 'ID', 2816, 'business', '0000-00-00 00:00:00', 0),
(180, 10221, 'Multi-homed connections to multiple ISP\'s providing', 'cwo.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(181, 10222, 'Multibyte Info Technology Limited', 'multi-byte.com', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(182, 10223, 'Uecomm Ltd', 'uecomm.net.au', 'AU', 68864, 'isp', '0000-00-00 00:00:00', 0),
(183, 10225, 'Nettlinx Limited', 'nettlinx.com', 'IN', 7680, 'isp', '0000-00-00 00:00:00', 0),
(184, 10226, 'Enterprise of Telecommunications Lao', 'etllao.com', 'LA', 10240, 'isp', '0000-00-00 00:00:00', 0),
(185, 10227, 'Institute Rajabhat Suandusit', 'dusit.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(186, 10229, 'Internet Content Provider', 'yahoo-inc.com', 'TW', 27392, 'isp', '0000-00-00 00:00:00', 0),
(187, 10230, 'internet content provider', 'yahoo-inc.com', 'US', 768, 'isp', '0000-00-00 00:00:00', 0),
(188, 10231, 'Tech-trans System Ltd.', 'tech-trans.com', 'HK', 1792, 'business', '0000-00-00 00:00:00', 0),
(189, 10232, 'Hutchison Priceline HK', 'hpcln.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(190, 10234, 'Zurich Financial Services Australia', 'zurich.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(191, 10235, 'National Australia Bank Limited', 'nab.com.au', 'AU', 139776, 'business', '0000-00-00 00:00:00', 0),
(192, 10236, 'AXA Technology Services Asia (HK) Limited', 'axa-tech.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(193, 10238, 'Cyber Channel International Ltd', 'cyberchn.com.hk', 'HK', 4096, 'isp', '0000-00-00 00:00:00', 0),
(194, 10240, 'The Motley Fool, Inc.', 'fool.com', 'US', 1024, 'business', '1997-05-19 00:00:00', 0),
(195, 10242, 'US Internet Corp', 'usinternet.com', 'US', 88320, 'isp', '1997-05-19 00:00:00', 0),
(196, 10248, 'BAY BANKS OF VIRGINIA', 'baybanks.com', 'US', 256, 'business', '2013-09-30 00:00:00', 0),
(197, 10249, 'RedZone Wireless, LLC', 'redzonewireless.com', 'US', 10240, 'business', '2015-01-09 00:00:00', 0),
(198, 10250, 'INet Solutions', 'datafivetech.com', 'US', 65536, 'business', '1997-05-22 00:00:00', 0),
(199, 10255, 'Sinister Networks', 'sinister.com', 'US', 67328, 'business', '1997-05-23 00:00:00', 0),
(200, 10263, 'MatchMaker/DFW-ISP', 'dfwisp.net', 'US', 8192, 'business', '1997-05-28 00:00:00', 0),
(201, 10264, 'Scotia McLeod Inc.', 'scotiacapital.com', 'CA', 4608, 'business', '1997-05-28 00:00:00', 0),
(202, 10265, 'Seneca College of Applied Arts and Technology', 'senecacollege.ca', 'CA', 65536, 'education', '2006-12-14 00:00:00', 0),
(203, 10266, 'Onepath', '1path.com', 'US', 512, 'business', '1997-05-30 00:00:00', 0),
(204, 10269, 'Belize Telemedia Limited', 'btl.net', 'BZ', 66560, 'isp', '1997-06-03 00:00:00', 0),
(205, 10271, 'Meganet Communications', 'meganet.net', 'US', 16640, 'business', '1997-06-03 00:00:00', 0),
(206, 10273, 'Florida Power & Light Company', 'fpl.com', 'US', 131072, 'business', '1997-06-03 00:00:00', 0),
(207, 10274, 'Mercury Network Corporation', 'mercury.net', 'US', 8192, 'business', '1997-06-03 00:00:00', 0),
(208, 10277, 'Ministerio de Cultura y Educacion', 'educacion.gob.ar', 'AR', 6912, 'education', '1997-06-04 00:00:00', 0),
(209, 10278, 'Cable & Wireless (Barbados) Limited', 'cwc.com', 'BB', 3072, 'isp', '1997-06-05 00:00:00', 0),
(210, 10279, 'West Carolina Communications, LLC', 'wctel.com', 'US', 27136, 'isp', '2012-09-19 00:00:00', 0),
(211, 10282, 'GLOBAL ONE', 'globalone.bg', 'US', 256, 'business', '1997-06-11 00:00:00', 0),
(212, 10292, 'Cable & Wireless Jamaica', 'cwjamaica.com', 'JM', 19456, 'isp', '1997-06-13 00:00:00', 0),
(213, 10294, 'Coast Community College District', 'cccd.edu', 'US', 65536, 'education', '1997-06-16 00:00:00', 0),
(214, 10297, 'eNET Inc.', 'ee.net', 'US', 90112, 'hosting', '1997-06-16 00:00:00', 0),
(215, 10298, 'CACI Inc., Federal', 'caci.com', 'US', 2560, 'business', '1997-06-19 00:00:00', 0),
(216, 10299, 'EMPRESAS MUNICIPALES DE CALI E.I.C.E. E.S.P.', 'emcali.net.co', 'CO', 95232, 'isp', '1997-06-20 00:00:00', 0),
(217, 103, 'Northwestern University', 'northwestern.edu', 'US', 150528, 'education', '1987-04-09 00:00:00', 0),
(218, 10302, 'SNAPPYDSL.NET', 'snapp.fr', 'US', 7680, 'isp', '1997-06-20 00:00:00', 0),
(219, 10308, 'Northeastern Illinois University', 'neiu.edu', 'US', 256, 'education', '1997-06-23 00:00:00', 0),
(220, 10309, 'County of Marin', 'marin.ca.us', 'US', 8960, 'business', '1997-06-23 00:00:00', 0),
(221, 10310, 'Oath Holdings Inc.', 'oath.com', 'US', 4398080, 'business', '2001-11-14 00:00:00', 0),
(222, 10317, 'Cuc International', 'trilegiant.com', 'US', 256, 'business', '1997-06-25 00:00:00', 0),
(223, 10318, 'Telecom Argentina S.A.', 'telecom.com.ar', 'AR', 2124288, 'isp', '1997-06-25 00:00:00', 0),
(224, 10320, 'Internet Services Provider Network', 'ispn.net', 'US', 4096, 'business', '1997-06-25 00:00:00', 0),
(225, 10322, 'Ercot Independent System Operations', 'ercot.com', 'US', 1024, 'business', '1997-06-25 00:00:00', 0),
(226, 10325, 'Ingram Micro Inc.', 'ingrammicro.com', 'US', 1024, 'business', '1997-06-26 00:00:00', 0),
(227, 10326, 'Worcester Polytechnic Institute', 'wpi.edu', 'US', 67584, 'education', '1997-06-26 00:00:00', 0),
(228, 10329, 'CoreLAN Communications, Inc.', 'corelan.com', 'CA', 2048, 'business', '1997-06-27 00:00:00', 0),
(229, 10333, 'Digital Insight Corporation', 'digitalinsight.com', 'US', 9984, 'business', '1997-06-27 00:00:00', 0),
(230, 10337, 'IBM AS/400 Division', 'ibm.com', 'US', 768, 'business', '1997-07-01 00:00:00', 0),
(231, 10340, 'TELE-TECH CO. INC.', 'tele-tech-inc.com', 'US', 3072, 'business', '1997-07-01 00:00:00', 0),
(232, 10343, 'National Aeronautics and Space Administration', 'nasa.gov', 'US', 132096, 'business', '1997-07-01 00:00:00', 0),
(233, 10347, 'Rand McNally', 'randmcnally.com', 'US', 256, 'business', '1997-07-03 00:00:00', 0),
(234, 10348, 'High Technology Development Corporation', 'htdc.org', 'US', 32768, 'business', '1997-07-07 00:00:00', 0),
(235, 10349, 'Tulane University', 'tulane.edu', 'US', 66560, 'education', '1997-07-07 00:00:00', 0),
(236, 10352, 'Solarus', 'wctc.net', 'US', 32768, 'isp', '1997-07-07 00:00:00', 0),
(237, 10355, 'Digital Service Consultants', 'dscga.com', 'US', 24832, 'business', '1997-07-09 00:00:00', 0),
(238, 10357, 'James Madison University', 'jmu.edu', 'US', 65536, 'education', '1997-07-09 00:00:00', 0),
(239, 10359, 'Epic Systems Corporation', 'epic.com', 'US', 1280, 'hosting', '2010-04-12 00:00:00', 0),
(240, 10360, 'AARP', 'aarp.org', 'US', 5120, 'business', '2020-07-22 00:00:00', 0),
(241, 10361, 'Bloomberg, LP', 'bloomberg.com', 'US', 20992, 'business', '1997-07-11 00:00:00', 0),
(242, 10362, 'UBIK DO BRASIL SOL TECNOLOGIA LTDA.', 'ubik.com.br', 'BR', 8192, 'business', '1999-11-16 00:00:00', 0),
(243, 10364, 'University of Alabama in Huntsville', 'uah.edu', 'US', 66048, 'education', '1997-07-11 00:00:00', 0),
(244, 10367, 'Fibercast Corporation', 'fibercast.net', 'US', 8448, 'business', '1997-07-14 00:00:00', 0),
(245, 10370, 'Northwest Airlines', 'delta.com', 'US', 131584, 'business', '1997-07-14 00:00:00', 0),
(246, 10377, 'Sound Choice Communications LLC', 'soundchoicecomm.com', 'US', 5120, 'business', '1997-07-15 00:00:00', 0),
(247, 10379, 'Deluxe Corporation', 'deluxe.com', 'US', 768, 'business', '1997-07-16 00:00:00', 0),
(248, 10381, 'Southwest Cyberport, Inc.', 'swcp.com', 'US', 22016, 'business', '1997-07-17 00:00:00', 0),
(249, 10384, 'Tennessee Valley Authority', 'tva.gov', 'US', 131072, 'business', '1997-07-21 00:00:00', 0),
(250, 10386, 'Internet Connections, Inc.', 'internet-connections.net', 'US', 8192, 'business', '1997-07-21 00:00:00', 0),
(251, 10388, 'NETinc', 'oneunified.net', 'BM', 1024, 'business', '1997-07-22 00:00:00', 0),
(252, 10390, 'TeleCheck International, Inc.', 'telecheck.com', 'US', 256, 'business', '1997-07-23 00:00:00', 0),
(253, 10391, 'InteRED Panama', 'intered.org.pa', 'PA', 512, 'business', '1997-07-23 00:00:00', 0),
(254, 10392, 'New Source Broadband', 'newsourcebroadband.com', 'US', 3840, 'business', '2011-05-18 00:00:00', 0),
(255, 10393, 'Dimension Data (Pty) Ltd - Optinet', 'optinet.net', 'ZA', 4864, 'isp', '1997-07-24 00:00:00', 0),
(256, 10396, 'DATACOM CARIBE, INC.', 'datacom.bg', 'PR', 270336, 'isp', '1997-07-11 00:00:00', 0),
(257, 10397, 'SinglePipe LLC', 'singlepipecom.com', 'US', 36096, 'business', '1997-07-11 00:00:00', 0),
(258, 10399, 'Waller Creek Communications', 'dbcity.com', 'US', 256, 'business', '1997-07-24 00:00:00', 0),
(259, 104, 'University of Colorado at Boulder', 'colorado.edu', 'US', 75520, 'education', '1987-04-09 00:00:00', 0),
(260, 10400, 'Toronto Star', 'thestar.ca', 'CA', 2048, 'business', '1997-07-24 00:00:00', 0),
(261, 10402, 'Harrison School District Two', 'hsd2.org', 'US', 512, 'education', '1997-07-24 00:00:00', 0),
(262, 10405, 'Union Pacific Railroad Company', 'up.com', 'US', 229376, 'isp', '1997-07-25 00:00:00', 0),
(263, 10406, 'Tektronix, Inc.', 'tek.com', 'US', 3072, 'business', '1997-07-25 00:00:00', 0),
(264, 10411, 'Environmental Systems Research Institute', 'esri.com', 'US', 2304, 'business', '1997-07-29 00:00:00', 0),
(265, 10412, 'CIA. DE TECNOL. DA INFOR. E COMUNICAÇÃO DO PARANÁ', 'None', 'BR', 32768, 'hosting', '1999-11-17 00:00:00', 0),
(266, 10417, 'Fundação de Desenvolvimento da Pesquisa', 'ufmg.br', 'BR', 32768, 'business', '2000-02-15 00:00:00', 0),
(267, 10420, 'Banco de Mexico', 'banxico.org.mx', 'MX', 65536, 'isp', '1997-07-31 00:00:00', 0),
(268, 10421, 'Texas Tech University', 'ttu.edu', 'US', 82432, 'education', '1997-07-31 00:00:00', 0),
(269, 10423, 'Spartan-Net', 'spartan-net.net', 'US', 16384, 'business', '2005-05-04 00:00:00', 0),
(270, 10425, 'Boingo_Wireless', 'boingo.com', 'None', 1280, 'isp', '2017-10-03 00:00:00', 0),
(271, 10429, 'TELEFÔNICA BRASIL S.A', 'telefonica.com.br', 'BR', 2661120, 'isp', '1999-11-16 00:00:00', 0),
(272, 10430, 'Washington State K-20 Telecommunications Network', 'washington.edu', 'US', 647936, 'education', '1997-08-01 00:00:00', 0),
(273, 10436, 'Instituto Tecnológico y de Estudios Superiores de Monterrey', 'tec.mx', 'MX', 73728, 'business', '1997-08-05 00:00:00', 0),
(274, 10439, 'CariNet, Inc.', 'cari.net', 'US', 106752, 'hosting', '1997-08-05 00:00:00', 0),
(275, 10440, 'Merkle Inc.', 'merkleinc.com', 'US', 1536, 'business', '2010-12-03 00:00:00', 0),
(276, 10441, 'CH2M HILL', 'ch2m.com', 'US', 67328, 'business', '1997-08-05 00:00:00', 0),
(277, 10444, 'ZB, National Association', 'zionsbancorp.com', 'US', 8192, 'business', '1997-08-05 00:00:00', 0),
(278, 10445, 'Huntleigh Telcom', 'rr.com', 'US', 4096, 'business', '1997-08-05 00:00:00', 0),
(279, 10446, 'Zero Error Networks', 'astute.net', 'US', 768, 'business', '1997-08-06 00:00:00', 0),
(280, 10448, 'Villanova University', 'villanova.edu', 'US', 65536, 'education', '1997-08-06 00:00:00', 0),
(281, 10451, 'Warpdrive Networks', 'ar.com', 'US', 1280, 'business', '1997-08-07 00:00:00', 0),
(282, 10452, 'FritzWare S.R.L.', 'fritzware.com.ar', 'AR', 256, 'business', '1997-08-07 00:00:00', 0),
(283, 10453, 'CREATIVE NETWORK INNOVATIONS, INC.', 'cniweb.net', 'US', 7424, 'business', '1997-08-07 00:00:00', 0),
(284, 10455, 'Alcatel-Lucent', 'alcatel-lucent.com', 'US', 4591104, 'isp', '1997-08-08 00:00:00', 0),
(285, 10457, 'Refinitiv US LLC', 'refinitiv.com', 'US', 3328, 'business', '1997-08-08 00:00:00', 0),
(286, 10461, 'Eze Castle Software LLC', 'ezecastlesoftware.com', 'US', 7168, 'business', '1997-08-11 00:00:00', 0),
(287, 10464, 'Team Technologies, LLC', 'teamtech.com', 'US', 26880, 'business', '1997-08-12 00:00:00', 0),
(288, 10466, 'MAGPI c/o University of Pennsylvania', 'magpi.net', 'US', 1280, 'education', '1997-08-13 00:00:00', 0),
(289, 10469, 'FIRST Inc.', 'first.gr', 'US', 4864, 'business', '1997-08-14 00:00:00', 0),
(290, 10474, 'Dimension Data (Pty) Ltd - Optinet', 'optinet.net', 'ZA', 1445376, 'isp', '1997-08-18 00:00:00', 0),
(291, 10475, 'North Sonoma County Healthcare District', 'nschd.org', 'US', 256, 'business', '2020-02-13 00:00:00', 0),
(292, 10479, 'Instituto Tecnológico y de Estudios Superiores de Monterrey', 'tec.mx', 'MX', 9216, 'business', '1997-08-20 00:00:00', 0),
(293, 10480, 'HIVELOCITY, Inc.', 'hivelocity.net', 'US', 2048, 'hosting', '2011-12-19 00:00:00', 0),
(294, 10481, 'Telecom Argentina S.A.', 'telecom.com.ar', 'AR', 3229952, 'isp', '1997-08-20 00:00:00', 0),
(295, 10488, 'tfm associates', 'tfm.net', 'US', 2048, 'business', '1997-08-26 00:00:00', 0),
(296, 10489, 'Armour Cloud, LLC', 'armourcloud.io', 'US', 8192, 'business', '1997-08-26 00:00:00', 0),
(297, 10490, 'Georgia Institute of Technology', 'gatech.edu', 'US', 512, 'education', '1997-08-26 00:00:00', 0),
(298, 10493, 'Grand Central Networks Inc.', 'grand-central.net', 'US', 3328, 'business', '1997-08-27 00:00:00', 0),
(299, 10494, 'Accurate Automation, Inc.', 'accurate-automation.com', 'US', 768, 'business', '1997-08-27 00:00:00', 0),
(300, 10497, 'The World Bank Group', 'worldbankgroup.org', 'US', 134144, 'business', '1997-08-27 00:00:00', 0),
(301, 10499, 'Rochester Gas and Electric Corporation', 'rge.com', 'US', 65536, 'business', '1997-08-27 00:00:00', 0),
(302, 10506, 'Evergreen Public Schools', 'evergreenps.org', 'US', 9728, 'education', '2018-08-24 00:00:00', 0),
(303, 10507, 'Sprint Personal Communications Systems', 'sprint.net', 'US', 10301184, 'business', '1997-08-29 00:00:00', 0),
(304, 10508, 'University of Arkansas', 'uark.edu', 'US', 65536, 'education', '1997-08-29 00:00:00', 0),
(305, 10511, 'CC Services, Inc', 'countryfinancial.com', 'US', 2304, 'business', '2005-05-04 00:00:00', 0),
(306, 10515, 'VeriSign Infrastructure & Operations', 'verisign.com', 'US', 4352, 'business', '1997-08-29 00:00:00', 0),
(307, 10524, 'GOYA DE PUERTO RICO', 'goyapr.com', 'PR', 256, 'business', '2008-12-04 00:00:00', 0),
(308, 10531, 'Terra Networks Brasil S.A.', 'terra.com.br', 'BR', 1536, 'business', '1999-11-18 00:00:00', 0),
(309, 10532, 'Rackspace Hosting', 'rackspace.com', 'US', 512, 'hosting', '2002-07-12 00:00:00', 0),
(310, 10538, 'TelAlaska', 'telalaska.com', 'US', 12800, 'business', '2002-11-14 00:00:00', 0),
(311, 10545, 'Lynchburg College', 'lynchburg.edu', 'US', 65536, 'education', '1997-09-09 00:00:00', 0),
(312, 10546, 'Mississippi State University', 'msstate.edu', 'US', 73472, 'education', '1997-09-11 00:00:00', 0),
(313, 10551, 'Rapid City Regional Hospital, Inc.', 'regionalhealth.com', 'US', 256, 'business', '2005-05-04 00:00:00', 0),
(314, 10554, 'WESTERN UNIVERSITY OF HEALTH SCIENCES', 'westernu.edu', 'US', 768, 'education', '2011-03-30 00:00:00', 0),
(315, 10557, 'Connect Northwest Internet Services, LLC', 'connect.ge', 'US', 1024, 'business', '1997-09-12 00:00:00', 0),
(316, 10558, 'Biola University, Inc.', 'biola.edu', 'US', 1024, 'education', '2010-07-23 00:00:00', 0),
(317, 10560, 'Instituto Tecnológico y de Estudios Superiores de Monterrey', 'tec.mx', 'MX', 14336, 'business', '1997-09-12 00:00:00', 0),
(318, 10561, 'Brandeis University', 'brandeis.edu', 'US', 65536, 'education', '1997-09-15 00:00:00', 0),
(319, 10564, 'ROCKET SOFTWARE INC', 'rocketsoftware.com', 'US', 7680, 'business', '1997-09-15 00:00:00', 0),
(320, 10569, 'Red CENIAInternet', 'ceniai.inf.cu', 'CU', 65536, 'isp', '1997-09-18 00:00:00', 0),
(321, 10578, 'Harvard University', 'harvard.edu', 'US', 24832, 'education', '1997-09-19 00:00:00', 0),
(322, 10580, 'ARRIS Technology, Inc.', 'arris.com', 'US', 1024, 'business', '2010-11-02 00:00:00', 0),
(323, 10583, 'Connecticut Hospital Assoc.', 'cthosp.org', 'US', 66048, 'business', '1997-09-29 00:00:00', 0),
(324, 10584, 'TradeWeb, LLC', 'tradeweb.com', 'US', 4864, 'business', '1997-09-24 00:00:00', 0),
(325, 10586, 'OSI de Guatemala', 'osint.net', 'GT', 3584, 'business', '1997-09-29 00:00:00', 0),
(326, 10587, 'Fiberpipe Inc.', 'fiberpipe.net', 'US', 28416, 'isp', '1997-09-29 00:00:00', 0),
(327, 10594, 'Cutting Edge Communications, Inc.', 'cuttingedgecomm.com', 'US', 26624, 'isp', '1997-09-30 00:00:00', 0),
(328, 10595, 'Mauswerks, LLC.', 'mauswerks.net', 'US', 512, 'business', '1997-09-30 00:00:00', 0),
(329, 10596, 'Jet.Net Internet Services', 'jet.net', 'US', 2816, 'business', '1997-09-30 00:00:00', 0),
(330, 10599, 'McKesson Corp.', 'mckesson.com', 'US', 148736, 'business', '1997-09-30 00:00:00', 0),
(331, 106, 'General Dynamics Mission Systems, Inc.', 'gdmissionsystems.com', 'US', 12544, 'business', '1987-04-28 00:00:00', 0),
(332, 10602, 'The Diamond Lane', 'tdl.com', 'US', 4096, 'business', '1997-09-30 00:00:00', 0),
(333, 10615, 'UBS AG', 'ubs.com', 'US', 16128, 'business', '1997-10-06 00:00:00', 0),
(334, 10616, 'National Technical Information Service', 'ntis.gov', 'US', 2048, 'business', '1997-10-06 00:00:00', 0),
(335, 10617, 'SION S.A', 'sion.com', 'AR', 50944, 'isp', '1997-10-06 00:00:00', 0),
(336, 10620, 'Telmex Colombia S.A.', 'telmexla.net.co', 'CO', 2168832, 'isp', '1997-10-06 00:00:00', 0),
(337, 10625, 'Interactive Data RTS', 'interactivedata-rts.com', 'US', 2560, 'business', '1997-10-06 00:00:00', 0),
(338, 10627, 'Critical Path, LLC', 'cp.net', 'US', 768, 'business', '1997-10-06 00:00:00', 0),
(339, 10631, 'Georgia State University', 'gsu.edu', 'US', 65536, 'education', '1997-10-08 00:00:00', 0),
(340, 10632, 'Puget Sound Energy', 'pse.com', 'US', 2048, 'business', '1997-10-08 00:00:00', 0),
(341, 10634, 'iNET Computers, Inc.', 'inet-pc.com', 'US', 768, 'business', '2008-12-04 00:00:00', 0),
(342, 10647, 'Nicholas Applegate', 'nacm.com', 'US', 1024, 'business', '1997-10-15 00:00:00', 0),
(343, 10650, 'Extreme Internet', 'extremezone.com', 'US', 8192, 'business', '1997-10-16 00:00:00', 0),
(344, 10653, 'USAI.NET', 'usai.net', 'US', 5632, 'business', '1997-10-16 00:00:00', 0),
(345, 10655, 'BUREAU OF NATIONAL AFFAIRS, INC.', 'bna.com', 'US', 4864, 'business', '1997-10-16 00:00:00', 0),
(346, 10660, 'SYSNET Communications', 'sysnet.net', 'US', 2560, 'business', '1997-10-17 00:00:00', 0),
(347, 10661, 'Steadfast Financial LP', 'steadfast.com', 'US', 256, 'business', '2009-11-04 00:00:00', 0),
(348, 10662, 'Norfolk Southern Corporation', 'nscorp.com', 'US', 65536, 'business', '1997-10-17 00:00:00', 0),
(349, 10666, 'Allergan, Inc.', 'allergan.com', 'US', 3072, 'business', '1997-10-20 00:00:00', 0),
(350, 10668, 'Lee Enterprises, Inc.', 'lee.net', 'US', 11520, 'isp', '1997-10-21 00:00:00', 0),
(351, 10670, 'COMPANHIA DE TECNOLOGIA DA INFORMAÇÃO ESTADO MG', 'prodemge.gov.br', 'BR', 16384, 'business', '1999-11-17 00:00:00', 0),
(352, 10671, 'Comision Nacional de Actividades Espaciales', 'conae.gov.ar', 'AR', 1024, 'business', '1997-10-21 00:00:00', 0),
(353, 10674, 'Gainesville Regional Utilities', 'gru.net', 'US', 32512, 'isp', '1997-10-21 00:00:00', 0),
(354, 10676, 'IBM', 'ibm.com', 'US', 12288, 'business', '1997-10-22 00:00:00', 0),
(355, 10678, '@trends.ca', 'trends.ca', 'CA', 512, 'business', '1997-10-22 00:00:00', 0),
(356, 10680, 'Indiana University', 'iu.edu', 'US', 10240, 'education', '1997-10-22 00:00:00', 0),
(357, 10685, 'A5.COM', 'a5.com', 'US', 12288, 'business', '1997-10-24 00:00:00', 0),
(358, 10688, 'ISM AUTOMACAO S.A.', 'ism.com.br', 'BR', 8192, 'business', '1999-11-18 00:00:00', 0),
(359, 10689, 'Fox Valley Internet, Inc.', 'foxvalley.net', 'US', 8192, 'isp', '1997-10-28 00:00:00', 0),
(360, 10690, 'NETSCOUT SYSTEMS INC.', 'netscout.com', 'US', 2304, 'business', '1997-10-28 00:00:00', 0),
(361, 10692, 'DLS Internet Services, Inc', 'dls.net', 'US', 36864, 'business', '1997-10-28 00:00:00', 0),
(362, 10694, 'Monster Worldwide, Inc.', 'monster.com', 'US', 1280, 'business', '1997-10-28 00:00:00', 0),
(363, 10695, 'Wal-Mart Stores, Inc.', 'wal-mart.com', 'US', 1704448, 'business', '1997-10-29 00:00:00', 0),
(364, 10697, 'Interlink S.R.L.', 'interlink.com.ar', 'AR', 4096, 'isp', '1997-10-29 00:00:00', 0),
(365, 10700, 'TECINFO, Inc.', 'tecinfo.net', 'US', 8192, 'business', '1997-10-30 00:00:00', 0),
(366, 10701, 'Fiber Plus, Inc', 'fiberplusinc.com', 'US', 256, 'business', '1997-10-31 00:00:00', 0),
(367, 10702, 'Idaho National Laboratory', 'inl.gov', 'US', 131072, 'business', '1997-10-31 00:00:00', 0),
(368, 10704, 'ML Telecom', 'metropop.com.br', 'BR', 22784, 'business', '2000-09-14 00:00:00', 0),
(369, 10706, 'YUVOX S.A DE C.V', 'yuvox.net', 'MX', 3584, 'isp', '1997-10-31 00:00:00', 0),
(370, 10708, 'SelectNet Internet Services', 'select.net', 'US', 4608, 'business', '1997-10-31 00:00:00', 0),
(371, 10713, 'Insync Internet Services, Inc.', 'insync.net', 'US', 16384, 'business', '1997-11-03 00:00:00', 0),
(372, 10715, 'Universidade Federal de Santa Catarina', 'ufsc.br', 'BR', 73728, 'education', '2000-02-16 00:00:00', 0),
(373, 10717, 'Scholastic Inc.', 'scholastic.com', 'US', 2048, 'business', '1997-11-05 00:00:00', 0),
(374, 10718, 'Conseco Companies', 'conseco.com', 'US', 1280, 'business', '1997-11-05 00:00:00', 0),
(375, 10721, 'The Andersons Inc', 'andersonsinc.com', 'US', 512, 'business', '2011-02-04 00:00:00', 0),
(376, 10723, 'Meritage Group LP', 'meritagegroup.com', 'US', 768, 'business', '2010-10-18 00:00:00', 0),
(377, 10725, 'Genentech, Inc.', 'gene.com', 'US', 1024, 'business', '1997-11-05 00:00:00', 0),
(378, 10730, 'Syndeo Networks, Inc', 'syndeonetwork.com', 'US', 256, 'isp', '1997-11-07 00:00:00', 0),
(379, 10732, 'TierraNet Inc.', 'tierra.net', 'US', 17920, 'hosting', '1997-11-11 00:00:00', 0),
(380, 10733, 'DC MATRIX INTERNET S/A', 'matrix.com.br', 'BR', 32768, 'business', '1999-11-17 00:00:00', 0),
(381, 10736, 'International Telcom, Ltd.', 'itltd.net', 'US', 8192, 'business', '1997-11-13 00:00:00', 0),
(382, 10745, 'ARIN Operations', 'arin.net', 'US', 512, 'business', '1997-11-14 00:00:00', 0),
(383, 10747, 'Epic Hosting, LLC', 'epic.com', 'US', 1536, 'hosting', '2016-08-08 00:00:00', 0),
(384, 1075, 'GONET', 'go-net.co.id', 'CA', 256, 'isp', '1990-08-07 00:00:00', 0),
(385, 10750, 'Mark Twain Rural Telephone Co.', 'marktwain.net', 'US', 4608, 'business', '2018-06-19 00:00:00', 0),
(386, 10753, 'Level 3 Parent, LLC', 'level3.com', 'US', 425472, 'isp', '1997-11-18 00:00:00', 0),
(387, 10754, 'Federal Reserve Board', 'frb.gov', 'US', 67840, 'business', '1997-11-18 00:00:00', 0),
(388, 10755, 'Dartmouth College', 'dartmouth.edu', 'US', 65536, 'education', '1997-11-18 00:00:00', 0),
(389, 10758, 'INWave Internet, Inc', 'inwave.com', 'US', 4096, 'business', '1997-11-19 00:00:00', 0),
(390, 10764, 'National Center for Supercomputing Applications', 'illinois.edu', 'US', 512, 'education', '1997-11-20 00:00:00', 0),
(391, 10765, 'CloudNet', 'cloudnetinc.com', 'US', 3840, 'business', '1997-11-20 00:00:00', 0),
(392, 10770, 'AT&T Corp.', 'att.com', 'US', 3072, 'isp', '1997-11-21 00:00:00', 0),
(393, 10774, 'AT&T Corp.', 'att.com', 'US', 1280, 'isp', '1997-11-21 00:00:00', 0),
(394, 10778, 'MCL Internet', 'netglobalis.net', 'CL', 34560, 'isp', '1997-11-21 00:00:00', 0),
(395, 10780, 'Pure Storage, INC.', 'purestorage.com', 'US', 5120, 'business', '2014-05-28 00:00:00', 0),
(396, 10782, 'Hewlett-Packard Company', 'hp.com', 'US', 411648, 'business', '1997-11-24 00:00:00', 0),
(397, 10784, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 512, 'isp', '2001-12-27 00:00:00', 0),
(398, 10786, 'Chartway Federal Credit Union', 'chartway.com', 'US', 256, 'business', '2005-02-08 00:00:00', 0),
(399, 10788, 'CDW LLC', 'cdw.com', 'US', 2816, 'business', '1997-12-01 00:00:00', 0),
(400, 10794, 'Bank of America, National Association', 'bankofamerica.com', 'US', 123392, 'business', '1997-12-01 00:00:00', 0),
(401, 10796, 'Charter Communications Inc', 'charter.com', 'US', 7977728, 'isp', '2000-06-09 00:00:00', 0),
(402, 10798, 'The Standard Bank of South Africa (Proprietary) Limited', 'standardbank.co.za', 'ZA', 19968, 'business', '2019-08-15 00:00:00', 0),
(403, 10801, 'REGIONS FINANCIAL CORPORATION', 'regions.com', 'US', 28672, 'business', '2001-11-08 00:00:00', 0),
(404, 10803, 'The Immedia Ecosystem (Pty) Ltd', 'immedia.co.za', 'ZA', 8192, 'isp', '1997-12-02 00:00:00', 0),
(405, 10806, 'AGENCE FRANCE PRESSE', 'afp.com', 'US', 46848, 'business', '1997-12-02 00:00:00', 0),
(406, 10808, 'The Globe and Mail', 'theglobeandmail.com', 'CA', 1536, 'business', '1997-12-03 00:00:00', 0),
(407, 10809, 'North Country Internet Access', 'ncia.net', 'US', 2048, 'business', '1997-12-04 00:00:00', 0),
(408, 10812, 'University of Texas System', 'utsystem.edu', 'US', 12288, 'education', '1997-12-04 00:00:00', 0),
(409, 10818, 'Fullnet Communications', 'fullnet.net', 'US', 4608, 'business', '1997-12-05 00:00:00', 0),
(410, 10819, 'IFWORLD Inc.', 'ifworld.com', 'US', 2304, 'business', '1997-12-05 00:00:00', 0),
(411, 10821, 'The Pioneer Telephone Association, Inc.', 'pioncomm.net', 'US', 24576, 'isp', '1997-12-05 00:00:00', 0),
(412, 10823, 'NetCarrier, Inc.', 'netcarrier.com', 'US', 66048, 'isp', '1997-12-08 00:00:00', 0),
(413, 10834, 'Telefonica de Argentina', 'telefonica.com.ar', 'AR', 386816, 'isp', '1997-12-08 00:00:00', 0),
(414, 10835, 'Visionary Communications, Inc.', 'visioncommunications.com', 'US', 111360, 'isp', '1997-12-08 00:00:00', 0),
(415, 10837, 'Wells Fargo & Company', 'wellsfargo.com', 'US', 59904, 'business', '1997-12-09 00:00:00', 0),
(416, 10838, 'Charter Communications Inc', 'charter.com', 'US', 160512, 'isp', '1997-12-09 00:00:00', 0),
(417, 10843, 'Advanced Internet Technologies', 'ait.com', 'US', 29696, 'hosting', '1997-12-09 00:00:00', 0),
(418, 10844, 'Vastnet Corp', 'vastnet.net', 'US', 4096, 'business', '1997-12-10 00:00:00', 0),
(419, 10846, 'Deere & Company', 'johndeere.com', 'US', 205824, 'business', '1997-12-10 00:00:00', 0),
(420, 10847, 'Podernet, S.A. de C.V.', 'podernet.com.mx', 'MX', 8192, 'business', '1997-12-10 00:00:00', 0),
(421, 10848, 'NTT DATA Services, LLC', 'nttdata.com', 'US', 32768, 'business', '2001-02-28 00:00:00', 0),
(422, 10849, 'Dallas County Community College District', 'dcccd.edu', 'US', 65536, 'education', '1997-12-11 00:00:00', 0),
(423, 10855, 'AUTO BY TEL', 'autobytel.com', 'US', 512, 'business', '1997-12-12 00:00:00', 0),
(424, 10857, 'JCPenney Co., Inc.', 'jcpenney.com', 'US', 65536, 'business', '1997-12-12 00:00:00', 0),
(425, 10858, 'Hypertherm Inc.', 'hypertherm.com', 'US', 256, 'business', '2008-07-01 00:00:00', 0),
(426, 10859, 'CSRA LLC', 'csra.com', 'US', 768, 'business', '1997-12-12 00:00:00', 0),
(427, 10865, 'Services Internet Abacom', 'abacom.com', 'CA', 8704, 'isp', '1997-12-12 00:00:00', 0),
(428, 10867, 'Foothill-DeAnza Community College District', 'deanza.edu', 'US', 65536, 'education', '1997-12-12 00:00:00', 0),
(429, 10868, 'DownCity LLC', 'downcity.net', 'US', 2048, 'business', '1997-12-15 00:00:00', 0),
(430, 10879, 'Unitedhealthcare', 'uhc.com', 'US', 146688, 'business', '1997-12-17 00:00:00', 0),
(431, 10880, 'Oath Holdings Inc.', 'oath.com', 'US', 768, 'business', '2006-05-05 00:00:00', 0),
(432, 10881, 'FUNPAR - Fundacao da UFPR para o DCTC', 'ufpr.br', 'BR', 114688, 'isp', '1999-12-15 00:00:00', 0),
(433, 10882, 'Clarity Connect Inc', 'clarityconnect.com', 'US', 4352, 'business', '1997-12-17 00:00:00', 0),
(434, 10883, 'Comspan Communications Inc.', 'comspan.com', 'US', 2048, 'business', '1997-12-17 00:00:00', 0),
(435, 10886, 'University of Maryland', 'umd.edu', 'US', 4864, 'education', '1997-12-17 00:00:00', 0),
(436, 10890, 'Philadelphia Newspapers Incorporated', 'phillynews.com', 'US', 1024, 'business', '1997-12-17 00:00:00', 0),
(437, 10891, 'Universal Tax Systems Inc', 'taxwise.com', 'US', 256, 'business', '1997-12-18 00:00:00', 0),
(438, 10896, 'Verifone, Inc.', 'verifone.com', 'US', 1024, 'business', '1997-12-19 00:00:00', 0),
(439, 10897, 'Camara dos Deputados', 'camara.gov.br', 'BR', 1024, 'business', '1999-11-18 00:00:00', 0),
(440, 109, 'Cisco Systems, Inc.', 'cisco.com', 'US', 1149952, 'isp', '1987-05-06 00:00:00', 0),
(441, 10905, 'Mobile Technology Ventures Inc', 'mtviinc.com', 'US', 768, 'business', '2018-06-19 00:00:00', 0),
(442, 10906, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 512, 'business', '1999-11-16 00:00:00', 0),
(443, 10908, 'CloudfloorDNS', 'cloudfloordns.com', 'US', 1024, 'business', '2011-03-14 00:00:00', 0),
(444, 10910, 'Internap Holding LLC', 'inap.com', 'US', 73984, 'isp', '1998-01-20 00:00:00', 0),
(445, 10912, 'Internap Holding LLC', 'inap.com', 'US', 70400, 'isp', '1998-01-20 00:00:00', 0),
(446, 10913, 'Internap Holding LLC', 'inap.com', 'US', 51712, 'isp', '1998-01-20 00:00:00', 0),
(447, 10915, 'CQL Incorporated', 'cqlcorp.com', 'US', 1024, 'business', '1998-01-20 00:00:00', 0),
(448, 10916, 'First Volunteer Bank', 'firstvolunteer.com', 'US', 256, 'business', '2014-09-17 00:00:00', 0),
(449, 10919, 'Troy Corporation', 'troycorp.com', 'US', 256, 'business', '2010-02-01 00:00:00', 0),
(450, 10921, 'Commonwealth of KentuckyDepartment of Information Systems', 'state.ky.us', 'US', 164352, 'business', '1998-01-26 00:00:00', 0),
(451, 10925, 'Snowbound Software Corporation', 'snowbound.com', 'US', 256, 'business', '2013-10-29 00:00:00', 0),
(452, 10926, 'California Emergency Management Agency - CALEMA', 'ca.gov', 'US', 256, 'isp', '2009-10-22 00:00:00', 0),
(453, 10929, 'eStruxture Data Centers Inc.', 'estruxture.com', 'CA', 63232, 'hosting', '2005-03-11 00:00:00', 0),
(454, 10930, 'Nova Internet Services, Inc.', 'novaone.net', 'US', 2048, 'business', '1998-01-30 00:00:00', 0),
(455, 10931, 'affiliated computer services, inc. - NWDC', 'nwdc.net', 'US', 768, 'business', '2005-04-18 00:00:00', 0),
(456, 10934, 'JPMorgan Chase & Co.', 'jpmorganchase.com', 'US', 3584, 'business', '1998-02-02 00:00:00', 0),
(457, 10935, 'RLC INTERNET', 'rlc.net', 'US', 256, 'business', '1998-02-03 00:00:00', 0),
(458, 10936, 'Marnell Corrao Assoc.', 'marnellcorrao.com', 'US', 1024, 'business', '2006-10-16 00:00:00', 0),
(459, 10938, 'AGENCIA ESTADUAL DE TECNOLOGIA DA INFORMACAO - ATI', 'ati.pe.gov.br', 'BR', 28672, 'business', '2000-02-16 00:00:00', 0),
(460, 10943, 'OLD REPUBLIC NATIONAL TITLE INSURANCE CO.', 'oldrepublictitle.com', 'US', 256, 'business', '2014-03-04 00:00:00', 0),
(461, 10944, 'Association of Bay Area Governments', 'ca.gov', 'US', 1024, 'isp', '2006-10-17 00:00:00', 0),
(462, 10945, 'ROI Solutions, LLC', 'roicallcentersolutions.com', 'US', 256, 'business', '2018-12-18 00:00:00', 0),
(463, 10947, 'Mountain West Technologies Corporation', 'mwtcorp.net', 'US', 5888, 'business', '1998-02-09 00:00:00', 0),
(464, 10949, 'Smart City Networks, L.P.', 'smartcity.com', 'US', 1280, 'business', '2007-01-03 00:00:00', 0),
(465, 10951, 'MGA ENTERTAINMENT INC.', 'mgae.com', 'US', 256, 'business', '2007-05-18 00:00:00', 0),
(466, 10952, 'East Carolina University', 'ecu.edu', 'US', 65536, 'education', '2007-05-11 00:00:00', 0),
(467, 10953, 'Exelon Corporation', 'constellation.com', 'US', 65536, 'business', '1998-02-10 00:00:00', 0),
(468, 10954, 'SERVICO FEDERAL DE PROCESSAMENTO DE DADOS - SERPRO', 'serpro.gov.br', 'BR', 147456, 'isp', '1999-11-17 00:00:00', 0),
(469, 10955, 'WILLIAM PATERSON UNIVERSITY', 'wpunj.edu', 'US', 65536, 'education', '1998-02-11 00:00:00', 0),
(470, 10958, 'Royell Communications, Inc.', 'royell.net', 'US', 9472, 'isp', '2007-07-12 00:00:00', 0),
(471, 10959, 'Bank of America, National Association', 'bankofamerica.com', 'US', 512, 'business', '1998-02-26 00:00:00', 0),
(472, 10961, 'Boston GigaPoP', 'bu.edu', 'US', 2304, 'education', '1998-02-27 00:00:00', 0),
(473, 10962, 'Cerner Corporation', 'cerner.com', 'US', 26112, 'business', '1998-02-27 00:00:00', 0),
(474, 10963, 'PROTERRA, Inc.', 'proterraonline.com', 'US', 256, 'business', '2018-04-04 00:00:00', 0),
(475, 10964, 'Banco Credicoop Cooperativo Limitado', 'bancocredicoop.coop', 'AR', 4864, 'business', '1998-02-17 00:00:00', 0),
(476, 10965, 'MRNet', 'mrnet.mb.ca', 'CA', 3328, 'business', '1998-02-17 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(477, 10966, 'Alaska Airlines, Inc.', 'alaskaair.com', 'US', 768, 'business', '1998-02-17 00:00:00', 0),
(478, 10967, 'The Home Depot', 'homedepot.com', 'US', 163840, 'business', '1998-02-17 00:00:00', 0),
(479, 10968, 'Cargill Incorporated', 'cargill.com', 'US', 67584, 'business', '1998-02-18 00:00:00', 0),
(480, 10969, 'Transcendent, LLC', 't-llc.com', 'US', 1024, 'business', '2012-06-28 00:00:00', 0),
(481, 10971, 'Cass Cable TV, Inc.', 'casscomm.com', 'US', 21760, 'isp', '2012-06-04 00:00:00', 0),
(482, 10972, 'Memorial University, NF CAnet 2 gigaPOP', 'mun.ca', 'CA', 256, 'education', '1998-02-18 00:00:00', 0),
(483, 10973, 'Scatter Creek InfoNet, Inc.', 'scattercreek.com', 'US', 4096, 'isp', '1998-02-18 00:00:00', 0),
(484, 10974, 'CUsource, LLC', 'cusource.com', 'US', 1024, 'business', '2007-05-17 00:00:00', 0),
(485, 10975, 'American International Group Data Center, Inc.', 'aig.com', 'US', 13056, 'business', '1998-02-19 00:00:00', 0),
(486, 10979, 'INSURANCE COMPANY OF THE WEST', 'icwgroup.com', 'US', 768, 'business', '2009-06-17 00:00:00', 0),
(487, 10980, 'Stafford Communications, Inc.', 'staffcomm.com', 'CA', 3072, 'isp', '2012-10-03 00:00:00', 0),
(488, 10981, 'The Oklahoma Publishing Company', 'opubco.com', 'US', 256, 'business', '1998-02-23 00:00:00', 0),
(489, 10982, 'TiVo, Inc.', 'tivo.com', 'US', 4608, 'business', '2006-10-17 00:00:00', 0),
(490, 10984, 'Uniti Fiber Holdings Inc.', 'uniti.com', 'US', 8704, 'isp', '1998-02-24 00:00:00', 0),
(491, 10985, 'Curtis Instruments, Inc.', 'curtisinst.com', 'US', 512, 'business', '2010-07-23 00:00:00', 0),
(492, 10986, 'Desarrollos Digitales de Pulsar Consulting', 'pulsarconsulting.net', 'AR', 36864, 'business', '1998-02-25 00:00:00', 0),
(493, 10988, 'College of Western Idaho', 'cwidaho.cc', 'US', 256, 'education', '2015-02-09 00:00:00', 0),
(494, 10990, 'Tulix Systems, Inc.', 'tulix.com', 'US', 1024, 'business', '2007-05-24 00:00:00', 0),
(495, 10991, 'Capgemini U.S. LLC', 'capgemini.com', 'US', 10496, 'business', '2006-10-17 00:00:00', 0),
(496, 10993, 'Aerioconnect', 'aerioconnect.net', 'US', 37632, 'isp', '1998-03-02 00:00:00', 0),
(497, 10995, 'PNC Bank N.A.', 'pnc.com', 'US', 131072, 'business', '1998-03-02 00:00:00', 0),
(498, 10996, 'Concorde inc.', 'vif.com', 'CA', 21504, 'isp', '1998-03-03 00:00:00', 0),
(499, 10998, 'Bank of America, National Association', 'bankofamerica.com', 'US', 13824, 'business', '1998-03-03 00:00:00', 0),
(500, 11003, 'The Procter and Gamble Company', 'pg.com', 'US', 3105280, 'business', '1998-03-04 00:00:00', 0),
(501, 11009, 'Carlow University', 'carlow.edu', 'US', 256, 'education', '2012-10-26 00:00:00', 0),
(502, 1101, 'SURFnet bv', 'surf.nl', 'NL', 1838592, 'isp', '2002-08-21 16:06:20', 0),
(503, 11011, 'DuPont Fabros Technology LP', 'dft.com', 'US', 512, 'business', '2005-02-18 00:00:00', 0),
(504, 11012, 'The Digital Design Company', 'ddc.net', 'US', 1792, 'business', '1998-03-09 00:00:00', 0),
(505, 11013, 'WideOpenWest Finance LLC', 'wowway.com', 'US', 12544, 'isp', '2007-03-05 00:00:00', 0),
(506, 11014, 'CPS', 'cps.com.ar', 'AR', 47360, 'isp', '1998-03-09 00:00:00', 0),
(507, 11015, 'Texas Children\'s Hospital', 'texaschildrens.org', 'US', 8448, 'business', '2008-09-04 00:00:00', 0),
(508, 11016, 'Experian', 'experian.com', 'US', 256, 'business', '1998-03-09 00:00:00', 0),
(509, 11017, 'CSN Support Services', 'cisco.com', 'US', 7680, 'isp', '2010-12-20 00:00:00', 0),
(510, 11019, 'HAProxy Technologies, Inc.', 'haproxy.com', 'US', 5120, 'business', '2014-04-09 00:00:00', 0),
(511, 1102, 'SURFnet bv', 'surf.nl', 'NL', 768, 'isp', '2002-08-21 16:06:21', 0),
(512, 11020, 'Quantum Networking Solutions, Inc.', 'qnet.com', 'US', 8704, 'business', '1998-03-11 00:00:00', 0),
(513, 11021, 'AutoTrader.com, Inc.', 'autotrader.com', 'US', 768, 'business', '2014-03-04 00:00:00', 0),
(514, 11022, 'Alabanza, Inc.', 'alabanza.com', 'US', 377856, 'business', '1998-03-11 00:00:00', 0),
(515, 11023, 'System Source', 'systemssourceinc.com', 'US', 4096, 'business', '1998-03-11 00:00:00', 0),
(516, 11025, 'Comcast Cable Communications, LLC', 'comcast.com', 'US', 40960, 'isp', '2005-04-28 00:00:00', 0),
(517, 1103, 'SURFnet bv', 'surf.nl', 'NL', 6227712, 'isp', '2002-09-23 12:44:58', 0),
(518, 11030, 'Qualcomm, Inc.', 'qualcomm.com', 'US', 76800, 'business', '1998-03-13 00:00:00', 0),
(519, 11031, 'Orbis Investments (Canada) Limited', 'orbis.com', 'CA', 3328, 'business', '2013-07-11 00:00:00', 0),
(520, 11032, 'Universite du Quebec', 'uquebec.ca', 'CA', 8704, 'education', '2005-10-28 00:00:00', 0),
(521, 11035, 'The Raymond F. Kravis Center for the Performing Arts, Inc.', 'kravis.org', 'US', 512, 'business', '2006-09-05 00:00:00', 0),
(522, 11036, 'Signal Perfection, Ltd., Inc.', 'splis.com', 'US', 3072, 'business', '2013-12-30 00:00:00', 0),
(523, 11038, 'Salish Networks, Inc.', 'salishnetworks.com', 'US', 5888, 'business', '2006-10-18 00:00:00', 0),
(524, 11039, 'The George Washington University', 'gwu.edu', 'US', 131072, 'education', '1998-03-17 00:00:00', 0),
(525, 1104, 'Stichting Nederlandse Wetenschappelijk Onderzoek Instituten', 'nikhef.nl', 'NL', 75264, 'business', '2001-12-03 16:45:26', 0),
(526, 11042, 'NETWORK TRANSIT HOLDINGS LLC', 'networktransit.net', 'US', 106496, 'hosting', '2010-12-03 00:00:00', 0),
(527, 11044, 'Harvey Public Library District', 'harvey.lib.il.us', 'US', 768, 'business', '1998-03-19 00:00:00', 0),
(528, 11045, 'Sterling Communications, Inc.', 'sterlingpr.com', 'US', 10752, 'isp', '1998-03-19 00:00:00', 0),
(529, 11046, 'Little Apple Technologies', 'littleappletech.com', 'US', 2048, 'business', '2005-10-31 00:00:00', 0),
(530, 11047, 'Hartford Hospital', 'harthosp.org', 'US', 2816, 'business', '2006-07-12 00:00:00', 0),
(531, 11048, 'DigitalStakeout', 'digitalstakeout.com', 'US', 256, 'business', '2020-02-07 00:00:00', 0),
(532, 11049, 'Oracle Corporation', 'oracle.com', 'US', 7168, 'business', '2010-12-03 00:00:00', 0),
(533, 11050, 'Kent State University', 'kent.edu', 'US', 65536, 'education', '1998-03-23 00:00:00', 0),
(534, 11051, 'Evocative, Inc.', 'evocative.com', 'US', 34816, 'hosting', '1998-03-23 00:00:00', 0),
(535, 11052, 'Intermountain Health Care', 'intermountainhealthcare.org', 'US', 67328, 'business', '1998-03-23 00:00:00', 0),
(536, 11054, 'LivePerson, Inc.', 'liveperson.com', 'US', 9472, 'business', '2008-04-02 00:00:00', 0),
(537, 11056, 'Berger Montague', 'bm.net', 'US', 256, 'business', '2020-06-05 00:00:00', 0),
(538, 11057, 'J. Walter Thompson', 'jwt.com', 'US', 1024, 'business', '1998-03-24 00:00:00', 0),
(539, 11061, 'Antelecom, Inc.', 'antelecom.net', 'US', 12288, 'business', '1998-03-27 00:00:00', 0),
(540, 11062, 'MTCO Communications', 'mtco.com', 'US', 34560, 'isp', '1998-03-27 00:00:00', 0),
(541, 11066, 'Con-way, Inc.', 'con-way.com', 'US', 3328, 'business', '1998-03-30 00:00:00', 0),
(542, 11067, 'Panhandle Telecommunications Systems, INC.', 'ptsi.net', 'US', 20480, 'business', '1998-03-30 00:00:00', 0),
(543, 11068, 'Hanna, Brophy, MacLean, McAleer & Jensen, L.L.P', 'hannabrophy.com', 'US', 512, 'business', '2015-02-09 00:00:00', 0),
(544, 11069, 'Egix, Inc.', 'egix.com', 'US', 65536, 'business', '1998-03-30 00:00:00', 0),
(545, 11070, 'Metanet Communications, Inc.', 'gometanet.com', 'US', 4096, 'business', '2013-09-19 00:00:00', 0),
(546, 11071, 'InfoWest, Inc.', 'infowest.com', 'US', 32000, 'isp', '1998-03-30 00:00:00', 0),
(547, 11072, 'Redflex Traffic Systems, Inc.', 'redflex.com', 'US', 256, 'business', '2009-02-05 00:00:00', 0),
(548, 11073, 'Minnesota Public Radio', 'mpr.org', 'US', 256, 'business', '2010-12-06 00:00:00', 0),
(549, 11074, 'Sidera Networks LLC', 'sidera.net', 'US', 6144, 'business', '2007-07-12 00:00:00', 0),
(550, 11076, 'COMMUNITY COMPUTER SERVICE INC', 'medent.com', 'US', 256, 'business', '2007-05-11 00:00:00', 0),
(551, 11077, 'XBASE Technologies Corp.', 'xbase.com', 'CA', 1024, 'business', '2005-06-10 00:00:00', 0),
(552, 11078, 'Brown University', 'brown.edu', 'US', 131328, 'education', '1998-04-02 00:00:00', 0),
(553, 11079, 'Allstream Corp.', 'allstream.com', 'CA', 1024, 'isp', '2001-10-10 00:00:00', 0),
(554, 11080, 'Yellowknife Wireless Company, LLC', 'nmedia.net', 'US', 2816, 'business', '2005-06-13 00:00:00', 0),
(555, 11081, 'United Telecommunication Services (UTS)', 'uts.cw', 'CW', 102912, 'isp', '1998-04-02 00:00:00', 0),
(556, 11082, 'Eastman Chemical Company', 'eastman.com', 'US', 512, 'business', '2020-01-22 00:00:00', 0),
(557, 11084, 'Huron Telecommunications Cooperative Limited', 'hurontel.on.ca', 'CA', 30720, 'isp', '1998-04-03 00:00:00', 0),
(558, 11085, 'Premier Designs, Inc', 'premierdesigns.com', 'US', 256, 'business', '2012-09-20 00:00:00', 0),
(559, 11086, 'Pitney Bowes Incorporated', 'pb.com', 'US', 5632, 'business', '1998-04-06 00:00:00', 0),
(560, 11088, 'iConnect', 'iconnect-corp.com', 'US', 256, 'business', '2007-05-18 00:00:00', 0),
(561, 11089, 'ERGON', 'ergon.com', 'US', 256, 'business', '2005-06-22 00:00:00', 0),
(562, 1109, 'Universitaet Salzburg', 'sbg.ac.at', 'AT', 65536, 'education', '2002-08-21 16:42:01', 0),
(563, 11090, 'Matanuska Telephone Association, Inc.', 'mtasolutions.com', 'US', 36096, 'isp', '1998-04-06 00:00:00', 0),
(564, 11091, 'Schryver Medical Sales and Marketing, Inc.', 'schryvermedical.com', 'US', 256, 'business', '2013-11-06 00:00:00', 0),
(565, 11092, 'Hevanet', 'hevanet.com', 'US', 256, 'business', '1998-04-06 00:00:00', 0),
(566, 11093, 'Dataway', 'dataway.com', 'US', 4096, 'business', '1998-04-06 00:00:00', 0),
(567, 11094, 'Rutgers University', 'rutgers.edu', 'US', 66048, 'education', '1998-04-07 00:00:00', 0),
(568, 11096, 'FloridaNet', 'valueweb.com', 'US', 7424, 'business', '1998-04-07 00:00:00', 0),
(569, 11097, 'EMPRESA BRASILEIRA DE PESQUISA AGROPECUARIA', 'embrapa.br', 'BR', 17152, 'business', '1999-11-17 00:00:00', 0),
(570, 11098, 'SBC Communications, Inc.', 'sbc.com', 'US', 256, 'business', '1998-04-08 00:00:00', 0),
(571, 111, 'Boston University', 'bu.edu', 'US', 199168, 'education', '1987-05-11 00:00:00', 0),
(572, 1110, 'University of Innsbruck', 'uibk.ac.at', 'AT', 65536, 'education', '2002-08-21 16:42:02', 0),
(573, 11101, 'Palmetto Health', 'palmettohealth.org', 'US', 66816, 'business', '2005-02-15 00:00:00', 0),
(574, 11102, 'VYANET', 'vyanet.com', 'US', 3328, 'business', '1998-04-08 00:00:00', 0),
(575, 11105, 'Simon Fraser University', 'sfu.ca', 'CA', 94976, 'education', '2007-05-11 00:00:00', 0),
(576, 11106, 'Wolfram Research, Inc.', 'wolfram.com', 'US', 20480, 'business', '1998-04-09 00:00:00', 0),
(577, 11109, 'State of Alabama, Office of Information Technology', 'alabama.gov', 'US', 4096, 'business', '1998-04-10 00:00:00', 0),
(578, 1111, 'Universitaet Klagenfurt', 'uni-klu.ac.at', 'AT', 65536, 'education', '2002-08-21 16:42:02', 0),
(579, 11114, 'Wintek Corporation', 'wintek.com', 'US', 21248, 'isp', '1998-04-13 00:00:00', 0),
(580, 11115, 'Online Tech, LLC', 'onlinetech.com', 'US', 9728, 'business', '1998-04-14 00:00:00', 0),
(581, 11118, 'ComTeck', 'comteck.com', 'US', 4096, 'business', '1998-04-15 00:00:00', 0),
(582, 1112, 'Montanuniversitaet Leoben', 'unileoben.ac.at', 'AT', 256, 'education', '2002-08-21 16:42:03', 0),
(583, 11120, 'WidePoint Integrated Solutions Corp.', 'widepoint.com', 'US', 256, 'business', '2008-12-04 00:00:00', 0),
(584, 11121, 'FIRST DATA CORPORATION', 'firstdata.com', 'US', 512, 'business', '1998-04-15 00:00:00', 0),
(585, 11123, 'Ultimate Internet Access, Inc', 'uia.net', 'US', 69888, 'isp', '1998-04-17 00:00:00', 0),
(586, 11124, 'Friedkin Companies, Inc.', 'monster.com', 'US', 512, 'business', '2012-01-31 00:00:00', 0),
(587, 11126, 'Carle Clinic Association', 'carle.com', 'US', 1024, 'business', '1998-04-17 00:00:00', 0),
(588, 11127, 'Globecomm Network Services Corporation', 'globecomm.com', 'US', 29440, 'isp', '1998-04-17 00:00:00', 0),
(589, 11128, 'Berry College', 'berry.edu', 'US', 512, 'education', '2006-09-18 00:00:00', 0),
(590, 1113, 'Technische Universitaet Graz', 'tugraz.at', 'AT', 65536, 'education', '0000-00-00 00:00:00', 0),
(591, 11131, 'University of Maryland Baltimore County (UMBC)', 'umbc.edu', 'US', 81920, 'education', '1998-04-20 00:00:00', 0),
(592, 11132, 'JDA eHealth Systems, Inc.', 'jdaehealth.com', 'US', 256, 'business', '2011-07-19 00:00:00', 0),
(593, 11133, 'Sorenson Communications, Inc.', 'sorenson.com', 'US', 5632, 'business', '2007-05-17 00:00:00', 0),
(594, 11134, 'WebFire Internet Services', 'webfire.ca', 'US', 4096, 'business', '1998-04-20 00:00:00', 0),
(595, 11135, 'Cross Development/Montgomery LP', 'westlandbunker.com', 'US', 4608, 'business', '2005-08-08 00:00:00', 0),
(596, 11136, 'Instituto Tecnológico y de Estudios Superiores de Monterrey', 'tec.mx', 'MX', 19712, 'business', '1998-04-20 00:00:00', 0),
(597, 11138, 'BEK Communications Cooperative', 'bektel.com', 'US', 14848, 'isp', '2005-05-05 00:00:00', 0),
(598, 11139, 'Cable & Wireless Dominica', 'cwdom.dm', 'DM', 117248, 'isp', '1998-04-21 00:00:00', 0),
(599, 1114, 'Universitaet Graz', 'uni-graz.at', 'AT', 65536, 'education', '0000-00-00 00:00:00', 0),
(600, 11140, 'Behr Process', 'behr.com', 'US', 1024, 'business', '2005-08-08 00:00:00', 0),
(601, 11142, 'Precision Data Solutions, LLC', 'precisionds.com', 'US', 4096, 'business', '2012-06-08 00:00:00', 0),
(602, 11143, 'OEConnection, LLC', 'oeconnection.com', 'US', 1024, 'business', '2012-09-17 00:00:00', 0),
(603, 11144, 'Advent Software', 'advent.com', 'US', 3328, 'business', '1998-04-24 00:00:00', 0),
(604, 1115, 'Austrian Academy of Sciences', 'None', 'AT', 256, 'education', '0000-00-00 00:00:00', 0),
(605, 11152, 'Waverly Hall Telephone, LLC.', 'ryetelephone.com', 'US', 2048, 'business', '2013-03-27 00:00:00', 0),
(606, 11153, 'Corporate Support & Fulfillment LLC', 'corpsupportusa.com', 'US', 256, 'business', '2018-01-04 00:00:00', 0),
(607, 11157, 'Electronic laboratory Services Pty Ltd', 'lancet.co.za', 'ZA', 256, 'business', '1998-04-29 00:00:00', 0),
(608, 11158, 'NTT America, Inc.', 'ntt.com', 'US', 2048, 'isp', '1998-04-30 00:00:00', 0),
(609, 11159, 'Los Angeles Public Library', 'lapl.org', 'US', 1792, 'business', '1998-04-30 00:00:00', 0),
(610, 11160, 'COSTAR GROUP', 'costargroup.com', 'US', 768, 'business', '1998-05-01 00:00:00', 0),
(611, 11162, 'Los Nettos', 'ln.net', 'US', 1024, 'business', '2005-04-28 00:00:00', 0),
(612, 11163, 'Atlantix Global Systems, LLC', 'atlantixglobal.com', 'US', 256, 'business', '2014-02-18 00:00:00', 0),
(613, 11164, 'Internet2', 'internet2.edu', 'US', 1536, 'education', '2014-07-11 00:00:00', 0),
(614, 11165, 'Toppan Photomasks, Inc.', 'photomask.com', 'US', 256, 'business', '1998-05-04 00:00:00', 0),
(615, 11166, 'J2 Cloud Services, LLC', 'j2global.com', 'US', 1024, 'business', '1998-05-04 00:00:00', 0),
(616, 11167, 'GOGO, LLC', 'aircell.com', 'US', 6400, 'business', '2017-12-11 00:00:00', 0),
(617, 11168, 'SMART CHOICE COMMUNICATIONS, LLC', 'smartchoiceus.com', 'US', 11264, 'business', '2005-06-23 00:00:00', 0),
(618, 11169, 'Secure Foundations', 'securefoundations.com', 'US', 512, 'business', '2009-01-26 00:00:00', 0),
(619, 1117, 'Universitaet fur Bodenkultur, Wien', 'boku.ac.at', 'AT', 65536, 'education', '0000-00-00 00:00:00', 0),
(620, 11170, 'Roller Network LLC', 'rollernet.us', 'US', 4096, 'business', '2005-05-05 00:00:00', 0),
(621, 11171, 'Autonation, Inc', 'autonation.com', 'US', 2048, 'business', '1998-05-05 00:00:00', 0),
(622, 11172, 'Alestra, S. de R.L. de C.V.', 'alestra.com.mx', 'MX', 456192, 'isp', '1998-05-05 00:00:00', 0),
(623, 11174, 'Athenahealth', 'athenahealth.com', 'US', 2560, 'business', '2007-05-11 00:00:00', 0),
(624, 11176, 'Smart City Networks, L.P.', 'smartcity.com', 'US', 1792, 'business', '2007-01-03 00:00:00', 0),
(625, 11177, 'Questar', 'questarusa.com', 'US', 512, 'business', '1998-05-07 00:00:00', 0),
(626, 11178, 'AccessPlus Communications, Inc.', 'accesspluscom.com', 'US', 3584, 'business', '2011-01-18 00:00:00', 0),
(627, 11179, 'Aryaka Networks, Inc.', 'aryaka.com', 'US', 23040, 'business', '2010-12-06 00:00:00', 0),
(628, 11180, 'CX-DATA INC.', 'tierpoint.com', 'US', 512, 'isp', '2006-05-01 00:00:00', 0),
(629, 11181, 'Vaxxine Computer Systems Inc.', 'vaxxine.com', 'CA', 12288, 'isp', '2005-05-05 00:00:00', 0),
(630, 11183, 'Mount Horeb Telephone Co', 'mhtc.net', 'US', 12288, 'business', '1998-05-11 00:00:00', 0),
(631, 11187, 'Global Web Solutions, Inc.', 'globalweb.net', 'US', 2048, 'business', '2007-01-09 00:00:00', 0),
(632, 11188, 'LOS ANGELES COUNTY - INTERNAL SERVICESDIVISION', 'lacounty.gov', 'US', 197376, 'business', '1998-05-12 00:00:00', 0),
(633, 11189, 'Caliber Home Loans, Inc.', 'caliberhomeloans.com', 'US', 2048, 'business', '2010-01-25 00:00:00', 0),
(634, 11190, 'Silicon Connections, LLC.', 'silcon.com', 'US', 2048, 'business', '1998-05-12 00:00:00', 0),
(635, 11191, 'Cal.net, Inc.', 'cal.net', 'US', 25600, 'isp', '1998-05-12 00:00:00', 0),
(636, 11192, 'Smart City Networks, L.P.', 'smartcity.com', 'US', 3072, 'business', '2007-01-03 00:00:00', 0),
(637, 11193, 'COMNET S.A.', 'comnetsa.com', 'AR', 2816, 'isp', '1998-05-12 00:00:00', 0),
(638, 11194, 'NuNet Inc.', 'ncxcloud.com', 'US', 73728, 'isp', '1998-05-13 00:00:00', 0),
(639, 11195, 'Whiz to Coho, Inc.', 'coho.net', 'US', 6144, 'business', '1998-05-14 00:00:00', 0),
(640, 11196, 'Nestle USA', 'nestleusa.com', 'US', 256, 'business', '1998-05-14 00:00:00', 0),
(641, 11197, 'Dartmouth-Hitchcock Medical Center', 'dartmouth-hitchcock.org', 'US', 65536, 'isp', '1998-05-14 00:00:00', 0),
(642, 11198, 'Schneider Electric IT Corporation', 'schneider-electric.com', 'US', 256, 'business', '1998-05-14 00:00:00', 0),
(643, 11199, 'showNets LLC', 'shownets.net', 'US', 512, 'business', '2007-05-21 00:00:00', 0),
(644, 112, 'DNS-OARC', 'dns-oarc.net', 'US', 512, 'business', '2002-03-19 00:00:00', 0),
(645, 1120, 'ACONET', 'aco.net', 'EU', 512, 'isp', '2002-08-08 14:44:16', 0),
(646, 11200, 'Regis University', 'regis.edu', 'US', 512, 'education', '2010-12-06 00:00:00', 0),
(647, 11203, 'CalDSL', 'caldsl.com', 'US', 2304, 'business', '2012-10-26 00:00:00', 0),
(648, 11205, 'City of Philadelphia', 'phila.gov', 'US', 65536, 'business', '1998-05-18 00:00:00', 0),
(649, 11206, 'Ferris State University', 'ferris.edu', 'US', 65536, 'education', '2006-09-13 00:00:00', 0),
(650, 11207, 'The Boston Globe', 'globe.com', 'US', 1536, 'business', '1998-05-18 00:00:00', 0),
(651, 11208, 'HALL CAPITAL PARTNERS, LLC', 'hallcapital.com', 'US', 256, 'business', '2010-12-06 00:00:00', 0),
(652, 11211, 'NCIC Operator Services', 'ncic.com', 'US', 512, 'business', '2007-03-05 00:00:00', 0),
(653, 11212, 'COUNTY OF SONOMA', 'sonoma-county.org', 'US', 1024, 'business', '2007-05-21 00:00:00', 0),
(654, 11213, 'Level 3 Parent, LLC', 'level3.com', 'US', 512, 'isp', '1998-05-19 00:00:00', 0),
(655, 11214, 'University of North Florida', 'unf.edu', 'US', 65536, 'education', '2005-03-11 00:00:00', 0),
(656, 11215, 'Logix', 'logix-usa.com', 'US', 150272, 'business', '1998-05-20 00:00:00', 0),
(657, 11217, 'Carter Ledyard & Milburn LLP', 'clm.com', 'US', 256, 'business', '2006-09-29 00:00:00', 0),
(658, 11218, 'Ted Moudis Associates, Inc.', 'tedmoudis.com', 'US', 256, 'business', '2006-04-07 00:00:00', 0),
(659, 11219, 'James R. Glidewell Dental Ceramics Inc.', 'glidewelldental.com', 'US', 256, 'business', '2010-06-14 00:00:00', 0),
(660, 11221, 'WHRO', 'whro.net', 'US', 5888, 'business', '1998-05-21 00:00:00', 0),
(661, 11222, 'Polo Ralph Lauren', 'poloralphlauren.com', 'US', 768, 'business', '2009-04-30 00:00:00', 0),
(662, 11223, 'Mechoshade Systems INC', 'mechoshade.com', 'US', 512, 'business', '2010-03-05 00:00:00', 0),
(663, 11227, 'Morningstar, Inc.', 'morningstar.com', 'US', 1536, 'business', '2007-05-11 00:00:00', 0),
(664, 11228, 'ARINC, Inc.', 'arinc.net', 'US', 5120, 'business', '1998-05-22 00:00:00', 0),
(665, 11230, 'Managed Hosting Services, LLC', 'netengadv.com', 'US', 768, 'hosting', '2014-01-23 00:00:00', 0),
(666, 11231, 'GETTYSBURG COLLEGE', 'gettysburg.edu', 'US', 65536, 'education', '1998-05-22 00:00:00', 0),
(667, 11232, 'Midcontinent Communications', 'midco.com', 'US', 653824, 'isp', '1998-05-22 00:00:00', 0),
(668, 11233, 'Gorge Networks Inc.', 'gorge.net', 'US', 12288, 'isp', '1998-05-26 00:00:00', 0),
(669, 11235, 'Itron-Hosting', 'itron.com', 'US', 1024, 'business', '2008-12-18 00:00:00', 0),
(670, 11236, 'MailAnyone.net', 'mailanyone.net', 'US', 256, 'business', '2006-09-18 00:00:00', 0),
(671, 11237, 'UNIVERSIDAD EAFIT', 'eafit.edu.co', 'CO', 3072, 'education', '1998-05-26 00:00:00', 0),
(672, 11238, 'NetWest Online, Inc.', 'netwest.com', 'US', 8192, 'isp', '1998-05-26 00:00:00', 0),
(673, 11239, 'Skycomp Solutions Inc.', 'skycomp.ca', 'CA', 2048, 'business', '2011-06-27 00:00:00', 0),
(674, 1124, 'Universiteit van Amsterdam', 'uva.nl', 'NL', 196608, 'education', '2002-08-27 13:40:04', 0),
(675, 11240, 'AccessATC', 'accesscommunity.org', 'US', 14592, 'isp', '1998-05-27 00:00:00', 0),
(676, 11241, 'Transera Communications, Inc.', 'transerainc.com', 'US', 1536, 'business', '2007-04-27 00:00:00', 0),
(677, 11242, 'Universidade Federal de Santa Catarina', 'ufsc.br', 'BR', 8192, 'education', '2000-02-16 00:00:00', 0),
(678, 11243, 'Halaris Associates Inc.', 'atgnet.com', 'US', 256, 'business', '2007-05-24 00:00:00', 0),
(679, 11244, 'AMAG Pharmaceuticals, Inc', 'amagpharma.com', 'US', 256, 'business', '2008-08-21 00:00:00', 0),
(680, 11245, 'The Goodyear Tire & Rubber Company', 'goodyear.com', 'US', 3840, 'business', '2017-05-05 00:00:00', 0),
(681, 11247, 'Internet Business Services, Inc.', '4ibs.com', 'US', 8192, 'business', '1998-05-29 00:00:00', 0),
(682, 11248, 'Multi Service', 'multiservice.com', 'US', 1280, 'business', '1998-05-29 00:00:00', 0),
(683, 11250, 'Tri-State Generation and Transmission Association Inc.', 'tristategt.org', 'US', 2560, 'business', '1998-06-01 00:00:00', 0),
(684, 11251, 'Disney Streaming Services', 'disneystreaming.com', 'US', 4608, 'business', '2018-02-01 00:00:00', 0),
(685, 11252, 'Idaho State University', 'isu.edu', 'US', 67584, 'education', '1998-06-01 00:00:00', 0),
(686, 11253, 'BMW of Manahattan, Inc', 'muratek.com', 'US', 256, 'business', '2012-09-17 00:00:00', 0),
(687, 11255, 'Screamin\' Banshee Technologies', 'sbt.net', 'US', 5120, 'business', '1998-06-01 00:00:00', 0),
(688, 11257, 'University of Lethbridge', 'uleth.ca', 'CA', 65536, 'education', '1998-06-03 00:00:00', 0),
(689, 11259, 'Angola Telecom', 'angolatelecom.com', 'AO', 271616, 'isp', '1998-06-04 00:00:00', 0),
(690, 1126, 'Vancis Advanced ICT Services', 'vancis.nl', 'NL', 13312, 'business', '2002-02-13 09:26:40', 0),
(691, 11260, 'EastLink', 'eastlink.ca', 'CA', 314368, 'isp', '1998-06-04 00:00:00', 0),
(692, 11261, 'eHealthInsurance Services Inc.', 'ehealthinsurance.com', 'US', 1792, 'business', '2006-09-11 00:00:00', 0),
(693, 11262, 'W.H. Trading, L.L.C.', 'whtrading.com', 'US', 256, 'business', '2010-09-16 00:00:00', 0),
(694, 11264, 'LIQUIDNET HOLDINGS INC.', 'liquidnet.com', 'US', 1024, 'business', '2006-08-15 00:00:00', 0),
(695, 11267, 'Peirce-Phelps, Inc.', 'peirce.com', 'US', 256, 'business', '2010-04-16 00:00:00', 0),
(696, 11269, 'LinkBermuda LTD', 'link.bm', 'BM', 15104, 'isp', '1998-06-05 00:00:00', 0),
(697, 11270, 'TwinStar Credit Union', 'twinstarcu.com', 'US', 256, 'business', '2017-12-05 00:00:00', 0),
(698, 11271, 'BT Latam Brasil Ltda', 'btlatam.com.br', 'BR', 25600, 'business', '1999-11-18 00:00:00', 0),
(699, 11272, 'C Spire Fiber', 'cspire.com', 'US', 203264, 'isp', '1998-06-08 00:00:00', 0),
(700, 11273, 'FIRST DATA CORPORATION', 'firstdata.com', 'US', 134400, 'business', '1998-06-08 00:00:00', 0),
(701, 11274, 'TierPoint, LLC', 'tierpoint.com', 'US', 24064, 'isp', '1998-06-08 00:00:00', 0),
(702, 11275, 'NBH Holdings Corporation', 'bankmw.com', 'US', 512, 'business', '2012-06-05 00:00:00', 0),
(703, 11276, 'DataHUB, Inc.', 'data-hub.ch', 'US', 256, 'business', '1998-06-09 00:00:00', 0),
(704, 11277, 'NiSource Corporate Services Company', 'nisource.com', 'US', 1280, 'business', '1998-06-10 00:00:00', 0),
(705, 11278, 'Nintendo Of America inc.', 'nintendo.com', 'US', 3072, 'business', '1998-06-10 00:00:00', 0),
(706, 11279, 'George Mason University', 'gmu.edu', 'US', 66048, 'education', '1998-06-10 00:00:00', 0),
(707, 1128, 'SURFnet bv', 'surf.nl', 'NL', 196608, 'isp', '2002-09-20 11:12:04', 0),
(708, 11280, 'SNAPPYDSL.NET', 'snappydsl.net', 'US', 13568, 'isp', '2008-07-01 00:00:00', 0),
(709, 11281, 'Roblox', 'roblox.com', 'US', 1024, 'isp', '2017-10-18 00:00:00', 0),
(710, 11282, 'SERVERYOU INC', 'serveryou.com', 'US', 65536, 'hosting', '2012-06-08 00:00:00', 0),
(711, 11283, 'Costco, Inc.', 'costco.com', 'US', 10752, 'isp', '1998-06-11 00:00:00', 0),
(712, 11284, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 512, 'business', '1999-11-17 00:00:00', 0),
(713, 11285, 'K W Corporation, Inc.', 'kw-corp.com', 'US', 256, 'business', '2013-10-02 00:00:00', 0),
(714, 11286, 'KeyBank National Association', 'keybank.com', 'US', 65792, 'business', '1998-06-15 00:00:00', 0),
(715, 11287, 'Mitchell Seaforth Cable T. V. Ltd.', 'ezlink.ca', 'CA', 12288, 'isp', '2016-05-25 00:00:00', 0),
(716, 11288, 'InfraDMS', 'infradms.com', 'US', 3328, 'business', '2009-03-04 00:00:00', 0),
(717, 11290, 'Cogeco Connexion inc', 'cogeco.ca', 'CA', 255232, 'isp', '1998-06-16 00:00:00', 0),
(718, 11291, 'Eplexity LLC', 'eplexity.com', 'US', 256, 'business', '2018-10-01 00:00:00', 0),
(719, 11292, 'Live Nation Entertainment, Inc.', 'livenationentertainment.com', 'US', 4096, 'business', '2016-05-13 00:00:00', 0),
(720, 11293, 'University of California - Office of the President', 'ucop.edu', 'US', 67840, 'education', '1998-06-17 00:00:00', 0),
(721, 11294, 'Lifetouch Inc', 'lifetouch.com', 'US', 512, 'business', '2012-12-18 00:00:00', 0),
(722, 11296, 'Independent Health Association, Inc.', 'independenthealth.com', 'US', 1024, 'business', '2011-04-04 00:00:00', 0),
(723, 11297, 'Lipscomb University', 'lipscomb.edu', 'US', 1024, 'education', '2008-12-04 00:00:00', 0),
(724, 11298, 'Renew Data Corp.', 'renewdata.com', 'US', 512, 'business', '2007-03-06 00:00:00', 0),
(725, 11300, 'Globecomm Services Maryland LLC', 'globecomm.com', 'US', 9984, 'isp', '1998-06-19 00:00:00', 0),
(726, 11302, 'IGT Global Solutions Corporation', 'igt.com', 'US', 3072, 'business', '1998-06-22 00:00:00', 0),
(727, 11303, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 103424, 'isp', '1998-06-22 00:00:00', 0),
(728, 11304, 'Blount Memorial Hospital, Inc.', 'blountmemorial.org', 'US', 256, 'business', '2009-11-11 00:00:00', 0),
(729, 11307, 'Recreational Equipment Inc.', 'rei.com', 'US', 2048, 'business', '1998-06-22 00:00:00', 0),
(730, 11308, 'The Rockefeller Group', 'rgts.com', 'US', 256, 'business', '2008-05-21 00:00:00', 0),
(731, 11309, 'International Monetary Fund', 'imf.org', 'US', 67584, 'business', '1998-06-23 00:00:00', 0),
(732, 11312, 'York Telecom Corporation', 'yorktel.com', 'US', 768, 'business', '2006-02-08 00:00:00', 0),
(733, 11313, 'Fannie Mae', 'fanniemae.com', 'US', 11776, 'business', '1998-06-24 00:00:00', 0),
(734, 11315, 'Telefónica Móviles Argentina S.A. (Movistar Argentina)', 'telefonica.com', 'AR', 311040, 'isp', '1998-06-25 00:00:00', 0),
(735, 11316, 'NORTH-1', 'nerc.net', 'None', 1792, 'business', '2013-01-14 00:00:00', 0),
(736, 11317, 'Great Plains Network', 'greatplains.net', 'US', 512, 'business', '1998-06-25 00:00:00', 0),
(737, 11318, 'Georgetown University', 'georgetown.edu', 'US', 65536, 'education', '1998-06-26 00:00:00', 0),
(738, 11319, 'Deseret Digital Media, Inc.', 'deseretdigital.com', 'US', 8960, 'business', '2006-10-17 00:00:00', 0),
(739, 1132, 'SURFnet bv', 'surf.nl', 'NL', 256, 'isp', '2002-08-21 16:06:36', 0),
(740, 11320, 'LightEdge Solutions', 'lightedge.com', 'US', 93184, 'isp', '1998-06-29 00:00:00', 0),
(741, 11322, 'Thibodaux Regional Medical Center', 'thibodaux.com', 'US', 256, 'business', '2013-03-27 00:00:00', 0),
(742, 11323, 'Getty Images', 'gettyimages.in', 'US', 2304, 'business', '1998-06-30 00:00:00', 0),
(743, 11324, 'BRFHH SHREVEPORT, L.L.C.', 'uhsystem.com', 'US', 1024, 'business', '2014-08-20 00:00:00', 0),
(744, 11325, 'Altus Communications Inc.', 'altuscgi.com', 'US', 37888, 'business', '2008-05-22 00:00:00', 0),
(745, 11326, 'Eastman Chemical Company', 'eastman.com', 'US', 1536, 'business', '1998-07-02 00:00:00', 0),
(746, 11327, 'NCI Group, Inc.', 'ncilp.com', 'US', 768, 'business', '2005-10-31 00:00:00', 0),
(747, 11328, 'Bio-Rad Laboratories, Inc.', 'bio-rad.com', 'US', 768, 'business', '1998-07-02 00:00:00', 0),
(748, 1133, 'SURFnet bv', 'surf.nl', 'NL', 65536, 'isp', '2002-08-21 16:06:37', 0),
(749, 11331, 'Thomas H. Lee Capital, LLC', 'thlcapital.com', 'US', 256, 'business', '2005-10-31 00:00:00', 0),
(750, 11332, 'Crestron Electronics Inc', 'crestron.com', 'US', 256, 'business', '2014-01-07 00:00:00', 0),
(751, 11333, 'CyberTrails', 'cybertrails.net', 'US', 65536, 'business', '1998-07-06 00:00:00', 0),
(752, 11334, 'MidAmerican Energy Holdings Company', 'midamerican.com', 'US', 2048, 'business', '1998-07-06 00:00:00', 0),
(753, 11336, 'Barclays Global Investors', 'barclaysglobal.com', 'US', 1024, 'business', '1998-07-08 00:00:00', 0),
(754, 11337, 'Marlabs Incorporated', 'marlabs.com', 'US', 1024, 'business', '2007-12-14 00:00:00', 0),
(755, 11338, 'SKY SERVIÇOS DE BANDA LARGA LTDA', 'skybandalarga.com.br', 'BR', 62208, 'isp', '2016-06-13 00:00:00', 0),
(756, 11339, 'United Sources of America Inc.', 'usastudios.tv', 'US', 256, 'business', '2010-06-02 00:00:00', 0),
(757, 11340, 'Red Universitaria Nacional', 'reuna.cl', 'CL', 103168, 'education', '1998-11-09 00:00:00', 0),
(758, 11342, 'Pathway Communications', 'pathwaycommunications.com', 'CA', 49920, 'isp', '1998-07-13 00:00:00', 0),
(759, 11345, 'Akima Management Services, Inc.', 'akima.com', 'US', 256, 'business', '2008-03-11 00:00:00', 0),
(760, 11347, 'ORC', 'orc.com', 'US', 512, 'business', '1998-07-13 00:00:00', 0),
(761, 11348, 'Missouri University of Science and Technology', 'mst.edu', 'US', 65536, 'education', '2007-01-10 00:00:00', 0),
(762, 11349, 'Windstream Communications LLC', 'windstream.net', 'US', 1280, 'isp', '1998-07-13 00:00:00', 0),
(763, 11350, 'NorthWestern Medical Center', 'northwesternmedicalcenter.org', 'US', 256, 'business', '2017-09-07 00:00:00', 0),
(764, 11351, 'Charter Communications Inc', 'charter.com', 'US', 4903680, 'isp', '1998-07-14 00:00:00', 0),
(765, 11352, 'Iomartcloud Inc.', 'iomartcloud.com', 'US', 7424, 'business', '2008-05-21 00:00:00', 0),
(766, 11353, 'Education Service Center Region XI', 'esc11.net', 'US', 18176, 'education', '2006-06-19 00:00:00', 0),
(767, 11354, 'Carolinas Healthcare System', 'carolinashealthcare.org', 'US', 1024, 'business', '2005-12-30 00:00:00', 0),
(768, 11355, 'Shell Information Technology International, Inc.', 'shell.com', 'US', 66560, 'isp', '1998-07-17 00:00:00', 0),
(769, 11357, 'InfoQuest Technologies, Inc.', 'infoquest.com', 'US', 12288, 'hosting', '1998-07-17 00:00:00', 0),
(770, 11359, 'Zayo Bandwidth', 'zayobandwidth.com', 'US', 2304, 'isp', '1998-07-17 00:00:00', 0),
(771, 1136, 'KPN B.V.', 'kpn.com', 'EU', 6938368, 'isp', '2004-12-28 13:20:55', 0),
(772, 11360, 'Electronics for Imaging, Inc.', 'efi.com', 'US', 1024, 'business', '1998-07-17 00:00:00', 0),
(773, 11361, 'Boscov\'s Department Store, LLC', 'boscovs.com', 'US', 256, 'business', '2005-10-31 00:00:00', 0),
(774, 11362, 'Vector Data Systems LLC', 'vectordatasystems.com', 'US', 1280, 'business', '2011-12-22 00:00:00', 0),
(775, 11363, 'Fujitsu America Inc.', 'fujitsu.com', 'US', 331776, 'business', '1998-07-22 00:00:00', 0),
(776, 11364, 'Varex Imaging Corporation', 'vareximaging.com', 'US', 512, 'business', '2018-07-31 00:00:00', 0),
(777, 11365, 'Credit.com, Inc.', 'credit.com', 'US', 1024, 'business', '2010-06-10 00:00:00', 0),
(778, 11367, 'WorldNet Telecommunications, Inc.', 'worldnetpr.com', 'PR', 19456, 'isp', '1998-07-27 00:00:00', 0),
(779, 11369, 'INTL FCStone Financial Inc', 'intlfcstone.com', 'US', 512, 'business', '2009-02-12 00:00:00', 0),
(780, 11370, 'Uneed Solutions Inc.', 'uneedsolutions.com', 'US', 8192, 'business', '1998-07-28 00:00:00', 0),
(781, 11372, '14 W Administrative Services LLC', '14west.us', 'US', 1280, 'business', '2012-09-17 00:00:00', 0),
(782, 11374, 'Panterra Networks, Inc.', 'panterranetworks.com', 'US', 1024, 'business', '2007-03-30 00:00:00', 0),
(783, 11375, 'Minneapolis College of Art and Design', 'mcad.edu', 'US', 32768, 'education', '2005-03-14 00:00:00', 0),
(784, 11376, 'Choice Logistics, Inc.', 'choicelogistics.com', 'US', 256, 'business', '2012-09-17 00:00:00', 0),
(785, 11377, 'SendGrid, Inc.', 'sendgrid.com', 'US', 131840, 'business', '2012-06-28 00:00:00', 0),
(786, 11378, 'Stoel Rives LLP', 'stoel.com', 'US', 256, 'business', '2010-08-11 00:00:00', 0),
(787, 11379, 'Wyndham Hotel Group, LLC', 'wyndham.com', 'US', 1792, 'business', '2006-07-21 00:00:00', 0),
(788, 11381, 'Point Broadband Fiber Holding, LLC', 'point-broadband.com', 'US', 4096, 'isp', '1998-07-29 00:00:00', 0),
(789, 11382, 'Wiley Rein LLP', 'wileyrein.com', 'US', 512, 'business', '2016-05-03 00:00:00', 0),
(790, 11383, 'Xand Corporation', 'xand.com', 'US', 19712, 'business', '2002-01-31 00:00:00', 0),
(791, 11385, 'Nowyr, inc.', 'nowyr.com', 'US', 1024, 'business', '2013-01-04 00:00:00', 0),
(792, 11386, 'HEALTH AND HOSPITAL CORPORATION OF MARION COUNTY', 'hhcorp.org', 'US', 768, 'business', '2011-04-12 00:00:00', 0),
(793, 11387, 'La Curacao', 'lacuracao.com', 'US', 256, 'business', '2005-05-06 00:00:00', 0),
(794, 11389, 'Heritage Capital Corporation', 'heritagecoin.com', 'US', 1024, 'business', '2005-11-01 00:00:00', 0),
(795, 11392, 'Nosis Laboratorio de Investigación y Desarrollo S.A.', 'nosis.com', 'AR', 1024, 'business', '1998-08-03 00:00:00', 0),
(796, 11393, 'ION247', 'ion247.com', 'US', 4096, 'business', '2013-05-28 00:00:00', 0),
(797, 11394, 'City of Richardson', 'cor.gov', 'US', 768, 'business', '2006-07-07 00:00:00', 0),
(798, 11395, 'Thiel College', 'thiel.edu', 'US', 256, 'education', '2013-01-03 00:00:00', 0),
(799, 11396, 'Williams Information Technology LLC', 'williams.com', 'US', 20992, 'business', '1998-08-03 00:00:00', 0),
(800, 11397, 'River Delta Wireless', 'riverdeltawireless.com', 'US', 6144, 'business', '2010-12-06 00:00:00', 0),
(801, 11398, 'CenturyLink Communications, LLC', 'centurylink.com', 'US', 169472, 'isp', '1998-08-04 00:00:00', 0),
(802, 11399, 'Williams College', 'williams.edu', 'US', 65792, 'education', '1998-08-05 00:00:00', 0),
(803, 1140, 'Stichting Internet Domeinregistratie Nederland', 'sidn.nl', 'NL', 3328, 'business', '2002-09-16 13:52:55', 0),
(804, 11402, 'Charlotte Colocation Center, LLc', 'charlottecolo.com', 'US', 19712, 'isp', '2006-09-11 00:00:00', 0),
(805, 11403, 'NYI', 'nyi.net', 'US', 53248, 'hosting', '1998-08-11 00:00:00', 0),
(806, 11404, 'Wave Broadband', 'wavebroadband.com', 'US', 714496, 'isp', '2007-03-28 00:00:00', 0),
(807, 11406, 'CIGNA', 'cigna.com', 'US', 17408, 'business', '2010-03-05 00:00:00', 0),
(808, 11408, 'Kintetsu World Express', 'kwe.com', 'US', 1536, 'business', '1998-08-12 00:00:00', 0),
(809, 11409, 'Equifax, Inc.', 'equifax.com', 'US', 4608, 'business', '1998-08-13 00:00:00', 0),
(810, 11410, 'Regional Network Communications, Inc', 'rnci.com', 'US', 512, 'business', '1998-08-14 00:00:00', 0),
(811, 11413, 'IHERB INC', 'iherb.com', 'US', 256, 'business', '2006-07-10 00:00:00', 0),
(812, 11414, 'Nvidia Corporation', 'nvidia.com', 'US', 15104, 'business', '1998-08-14 00:00:00', 0),
(813, 11417, 'Northern Illinois University', 'niu.edu', 'US', 65536, 'education', '1998-08-17 00:00:00', 0),
(814, 11419, 'TELEFÔNICA BRASIL S.A', 'telefonica.com.br', 'BR', 28160, 'isp', '1999-11-17 00:00:00', 0),
(815, 1142, 'SURFnet bv', 'surf.nl', 'NL', 1536, 'isp', '2002-08-21 16:06:40', 0),
(816, 11420, 'Tribune Publishing Company, LLC', 'tribpub.com', 'US', 4096, 'business', '1998-08-17 00:00:00', 0),
(817, 11425, 'CWIE, LLC', 'cwie.net', 'US', 4096, 'business', '2009-04-24 00:00:00', 0),
(818, 11426, 'Charter Communications Inc', 'charter.com', 'US', 4656128, 'isp', '2000-06-09 00:00:00', 0),
(819, 11427, 'Charter Communications Inc', 'charter.com', 'US', 5242624, 'isp', '2000-06-09 00:00:00', 0),
(820, 11428, 'Jim Beam Brands Co.', 'jimbeam.com', 'US', 1280, 'business', '2014-04-30 00:00:00', 0),
(821, 11429, 'West Corporation', 'west.com', 'US', 1792, 'business', '1998-08-19 00:00:00', 0),
(822, 11430, 'Austin Bestline', 'bestline.net', 'US', 8192, 'business', '1998-08-19 00:00:00', 0),
(823, 11432, 'Telium Telecomunicações Ltda', 'telium.com.br', 'BR', 43008, 'business', '1999-11-17 00:00:00', 0),
(824, 11433, 'Apeiron', 'apeironsys.com', 'US', 7424, 'business', '2007-05-14 00:00:00', 0),
(825, 11435, 'La Capitale, cie d\'assurance generale', 'lacapitale.com', 'CA', 1024, 'business', '2010-07-23 00:00:00', 0),
(826, 11436, 'West Marine Products Inc.', 'westmarine.com', 'US', 256, 'business', '2014-06-02 00:00:00', 0),
(827, 11437, 'ClearSky Technologies, Inc.', 'csky.com', 'US', 1536, 'business', '1998-08-24 00:00:00', 0),
(828, 11438, 'LeMans Corporation', 'lemanscorp.com', 'US', 256, 'business', '2013-05-13 00:00:00', 0),
(829, 11439, 'Caneris Inc.', 'caneris.com', 'CA', 2048, 'isp', '2010-06-25 00:00:00', 0),
(830, 11440, 'Netsville, Inc.', 'netsville.com', 'US', 4096, 'business', '2000-04-07 00:00:00', 0),
(831, 11441, 'Frederick Memorial Healthcare System', 'fmh.org', 'US', 256, 'business', '2019-03-20 00:00:00', 0),
(832, 11442, 'North Carolina State University', 'ncsu.edu', 'US', 197632, 'education', '2006-02-09 00:00:00', 0),
(833, 11444, 'Neuteck LLC', 'neuteck.com', 'US', 256, 'business', '2018-04-13 00:00:00', 0),
(834, 11446, 'Lakeland Community College', 'lakelandcc.edu', 'US', 2048, 'education', '2006-07-10 00:00:00', 0),
(835, 11449, 'Interactive Brokers LLC', 'interactivebrokers.com', 'US', 512, 'business', '1998-08-26 00:00:00', 0),
(836, 1145, 'SURFnet bv', 'surf.nl', 'NL', 4096, 'isp', '2002-08-21 16:06:43', 0),
(837, 11452, 'Mount Sinai School of Medicine', 'mssm.edu', 'US', 55552, 'education', '1998-08-27 00:00:00', 0),
(838, 11455, 'US Technology Resources, LLC', 'ust-global.com', 'US', 1280, 'business', '2007-05-24 00:00:00', 0),
(839, 11457, 'Digital Realty Trust, L.P.', 'digitalrealty.com', 'US', 256, 'business', '2017-12-12 00:00:00', 0),
(840, 11458, 'Advanced Network Management, Inc', 'anm.com', 'US', 256, 'business', '2012-06-11 00:00:00', 0),
(841, 1146, 'SURFnet bv', 'surf.nl', 'NL', 256, 'isp', '2002-08-21 16:06:44', 0),
(842, 11462, 'ARAMARK', 'aramark.com', 'US', 256, 'business', '2020-03-17 00:00:00', 0),
(843, 11465, 'Kaweah Delta Health Care District', 'kaweahdelta.org', 'US', 8192, 'business', '2014-03-04 00:00:00', 0),
(844, 11466, 'Andrews Federal Credit Union', 'andrewsfcu.org', 'US', 256, 'business', '2006-11-10 00:00:00', 0),
(845, 11468, 'Airfire', 'as11468.net', 'CA', 9216, 'business', '1998-09-02 00:00:00', 0),
(846, 1147, 'SURFnet bv', 'surf.nl', 'NL', 32768, 'isp', '2002-08-21 16:06:45', 0),
(847, 11470, 'Radiological Society of North America', 'rsna.org', 'US', 768, 'business', '1998-09-02 00:00:00', 0),
(848, 11471, 'Eastland Internet', 'txol.net', 'US', 4096, 'business', '1998-09-03 00:00:00', 0),
(849, 11472, 'Your Town Online', 'yourtownonline.com', 'US', 5120, 'business', '2008-12-18 00:00:00', 0),
(850, 11473, 'West Central Ohio Internet Link', 'wcoil.com', 'US', 8192, 'business', '1998-09-04 00:00:00', 0),
(851, 11475, '1Wire Communications, LLC', '1wirecom.com', 'US', 2048, 'business', '2012-09-20 00:00:00', 0),
(852, 11477, 'GO Concepts, Inc', 'go-concepts.com', 'US', 1024, 'business', '1998-09-09 00:00:00', 0),
(853, 11478, 'Beanfield Technologies Inc.', 'beanfield.com', 'CA', 19456, 'isp', '1998-09-09 00:00:00', 0),
(854, 11479, 'Oracle Corporation', 'oracle.com', 'US', 8448, 'business', '1998-09-09 00:00:00', 0),
(855, 11480, 'Micromedex Inc.', 'ibm.com', 'US', 512, 'business', '1998-09-09 00:00:00', 0),
(856, 11481, 'University of Texas Rio Grande Valley', 'utrgv.edu', 'US', 73728, 'education', '2015-05-11 00:00:00', 0),
(857, 11482, 'Canisius College', 'canisius.edu', 'US', 65792, 'education', '2006-04-07 00:00:00', 0),
(858, 11483, 'Conviva, Inc.', 'conviva.com', 'US', 1536, 'business', '2008-08-21 00:00:00', 0),
(859, 11486, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 230400, 'isp', '1998-09-09 00:00:00', 0),
(860, 11487, 'Grey Group', 'grey.com', 'US', 1536, 'business', '1998-09-09 00:00:00', 0),
(861, 11488, 'BBN Technologies Corp.', 'bbn.com', 'US', 148736, 'isp', '2007-05-22 00:00:00', 0),
(862, 11489, 'Bell Canada', 'bell.ca', 'CA', 308480, 'isp', '1998-09-10 00:00:00', 0),
(863, 11490, 'Silverstein Properties, Inc.', 'silversteinproperties.com', 'US', 512, 'business', '2006-04-07 00:00:00', 0),
(864, 11491, 'Trivalent Group Inc.', 'trivalentgroup.com', 'US', 20480, 'business', '1998-09-10 00:00:00', 0),
(865, 11492, 'CABLE ONE, INC.', 'cableone.biz', 'US', 1349632, 'isp', '1998-09-10 00:00:00', 0),
(866, 11493, 'Hillsborough County Sheriff\'s Office', 'tampa.fl.us', 'US', 1280, 'business', '2006-04-07 00:00:00', 0),
(867, 11494, 'Kellogg Community College', 'kellogg.edu', 'US', 256, 'education', '2012-09-21 00:00:00', 0),
(868, 11495, 'COMNEXIA Corporation', 'comnexia.com', 'US', 2304, 'business', '2007-03-06 00:00:00', 0),
(869, 11496, 'JPMorgan Chase & Co.', 'jpmorganchase.com', 'US', 1280, 'business', '1998-09-11 00:00:00', 0),
(870, 11498, 'D.I.B.I. S.A.', 'dibisa.com.ar', 'AR', 256, 'business', '1998-09-11 00:00:00', 0),
(871, 11499, 'Woods Hole Oceanographic Institution', 'whoi.edu', 'US', 68864, 'education', '1998-09-11 00:00:00', 0),
(872, 11500, 'Milwaukee School of Engineering', 'msoe.edu', 'US', 65536, 'education', '2017-08-04 00:00:00', 0),
(873, 11501, 'Vista Radiology, P.C.', 'vistaradiology.com', 'US', 256, 'business', '2007-03-06 00:00:00', 0),
(874, 11505, 'DART INDUSTRIES INC.', 'tupperware.com', 'US', 256, 'business', '2015-06-26 00:00:00', 0),
(875, 11507, 'Medicine Hat College', 'mhc.ab.ca', 'CA', 256, 'education', '2017-08-03 00:00:00', 0),
(876, 11509, 'Tierzero', 'tierzero.com', 'US', 123136, 'isp', '1998-09-15 00:00:00', 0),
(877, 11511, 'Crete Carrier Corporation', 'cretecarrier.com', 'US', 256, 'business', '2009-01-28 00:00:00', 0),
(878, 11512, 'Parsec Data Management Inc.', 'parsecdata.com', 'US', 2304, 'business', '2010-10-15 00:00:00', 0),
(879, 11514, 'Transdatos', 'transdatos.com.ar', 'AR', 1280, 'isp', '1998-09-15 00:00:00', 0),
(880, 11516, 'Eastern Suffolk BOCES', 'sricboces.org', 'US', 13824, 'business', '2007-05-14 00:00:00', 0),
(881, 11517, 'Blue Cross & Blue Shield of Minnesota', 'bluecrossmn.com', 'US', 14592, 'business', '2006-04-07 00:00:00', 0),
(882, 11519, 'Banco Mercantil del Norte S.A., Institucion de Banca Multiple, Grupo Financiero Banorte', 'gfnorte.com.mx', 'MX', 1536, 'business', '1998-09-16 00:00:00', 0),
(883, 11520, 'Allstate Insurance Company', 'allstate.com', 'US', 66304, 'business', '1998-09-16 00:00:00', 0),
(884, 11521, 'ModusLink Corporation', 'moduslink.com', 'US', 2560, 'business', '1998-09-16 00:00:00', 0),
(885, 11522, 'Greater Sudbury Telecommunications Inc.', 'greatersudbury.ca', 'CA', 16640, 'isp', '1998-09-17 00:00:00', 0),
(886, 11523, 'H. Lee Moffitt Cancer Center & Research Institute, Inc.', 'moffitt.org', 'US', 1024, 'business', '2007-05-22 00:00:00', 0),
(887, 11524, 'SEG Network Technologies', 'seg.net', 'US', 14848, 'business', '1998-09-17 00:00:00', 0),
(888, 11525, 'Hancock Rural Telephone Corp.', 'ninestarconnect.com', 'US', 10496, 'isp', '1998-09-17 00:00:00', 0),
(889, 11527, 'TeleCommunication Systems, Inc.', 'telecomsys.com', 'US', 2048, 'business', '2010-11-29 00:00:00', 0),
(890, 11528, 'Photronics Inc.', 'photronics.com', 'US', 3072, 'business', '1998-09-17 00:00:00', 0),
(891, 11529, 'National Grid', 'nationalgridus.com', 'US', 65792, 'business', '1998-09-21 00:00:00', 0),
(892, 11533, 'Verity, Inc.', 'verity.com', 'US', 512, 'business', '1998-09-23 00:00:00', 0),
(893, 11534, 'School District of Philadelphia', 'philasd.org', 'US', 65536, 'education', '1998-09-23 00:00:00', 0),
(894, 11536, 'Sunrise Communications LLC', 'src-mi.com', 'US', 2048, 'isp', '2009-06-19 00:00:00', 0),
(895, 11537, 'Internet2', 'internet2.edu', 'US', 9472, 'education', '1998-09-23 00:00:00', 0),
(896, 11539, 'Liaison Technologies, INC.', 'liaison.com', 'US', 1792, 'business', '2007-05-23 00:00:00', 0),
(897, 11540, 'Research Triangle Institute', 'rti.org', 'US', 65792, 'business', '2012-06-29 00:00:00', 0),
(898, 11542, 'EYEMG - interactive media group', 'eyemg.com', 'US', 768, 'business', '2007-05-24 00:00:00', 0),
(899, 11544, 'Royal Bank of Canada', 'rbc.com', 'CA', 768, 'business', '1998-09-29 00:00:00', 0),
(900, 11548, 'Heritage University', 'heritage.edu', 'US', 512, 'education', '2014-10-08 00:00:00', 0),
(901, 11550, 'Smithville Digital, LLC', 'smithville.com', 'US', 44288, 'isp', '1998-09-30 00:00:00', 0),
(902, 11552, 'Nassau Life Insurance Company', 'phxlife.com', 'US', 65536, 'business', '1998-09-30 00:00:00', 0),
(903, 11553, 'Mannatech INC.', 'mannatech.com', 'US', 512, 'business', '2006-09-29 00:00:00', 0),
(904, 11554, 'SolidNetwork Technologies, Inc.', 'solidnetwork.org', 'US', 4096, 'business', '2018-04-04 00:00:00', 0),
(905, 11555, 'Alpha Hosting, LLC', 'alphahosting.com', 'US', 4096, 'hosting', '2017-08-14 00:00:00', 0),
(906, 11556, 'Cable & Wireless Panama', 'cwpanama.net', 'PA', 786688, 'isp', '1998-10-02 00:00:00', 0),
(907, 11557, 'Sidera Networks LLC', 'sidera.net', 'US', 4096, 'business', '2007-07-12 00:00:00', 0),
(908, 11558, 'TUSCARORA INTERMEDIATE UNIT', 'tiu11.org', 'US', 1024, 'business', '2005-03-14 00:00:00', 0),
(909, 11559, 'RSA Security Inc.', 'rsasecurity.com', 'US', 2560, 'business', '2006-03-06 00:00:00', 0),
(910, 11560, 'Sandwich Isles Communications, Inc', 'sandwichisles.com', 'US', 4096, 'isp', '2007-10-26 00:00:00', 0),
(911, 11561, 'EDGAR Online, Inc.', 'edgar-online.com', 'US', 256, 'business', '1998-10-05 00:00:00', 0),
(912, 11562, 'Net Uno, C.A.', 'netuno.net', 'VE', 59136, 'isp', '1998-10-06 00:00:00', 0),
(913, 11563, 'NetEnterprise Inc.', 'netenterprise.net', 'US', 20224, 'business', '1998-10-06 00:00:00', 0),
(914, 11568, 'CGI Inc.', 'cgi.com', 'CA', 1280, 'business', '2016-06-17 00:00:00', 0),
(915, 11570, 'Eastern New Mexico University', 'enmu.edu', 'US', 2304, 'education', '2014-06-16 00:00:00', 0),
(916, 11571, 'LA NACION', 'lanacion.com.ar', 'AR', 256, 'business', '1998-10-08 00:00:00', 0),
(917, 11572, 'PhoenixNAP LLC', 'phoenixnap.com', 'US', 9472, 'isp', '2010-01-11 00:00:00', 0),
(918, 11574, 'Iridian Asset Management LLC', 'iridian.com', 'US', 256, 'business', '2011-07-19 00:00:00', 0),
(919, 11575, 'Jupiter Medical Center', 'jupitermed.com', 'US', 512, 'business', '2012-05-30 00:00:00', 0),
(920, 11577, 'Vermont Department of Information and Innovation', 'vermont.gov', 'US', 131072, 'business', '1998-10-09 00:00:00', 0),
(921, 11579, 'LANline Communications Inc', 'lanline.com', 'US', 16384, 'business', '1998-10-12 00:00:00', 0),
(922, 11580, 'Island Networks Ltd', 'islandnetjm.com', 'JM', 768, 'isp', '2005-09-21 00:00:00', 0),
(923, 11582, 'Smart City Networks, L.P.', 'smartcity.com', 'US', 1280, 'business', '2007-01-03 00:00:00', 0),
(924, 11584, 'New York City Health & Hospitals Corporation', 'nychhc.org', 'US', 4096, 'business', '2008-03-11 00:00:00', 0),
(925, 11586, 'Johnson Outdoors, Inc.', 'johnsonoutdoors.com', 'US', 256, 'business', '2007-09-17 00:00:00', 0),
(926, 11587, 'Northeast Texas Broadband, LLC', 'None', 'US', 4096, 'hosting', '1998-10-14 00:00:00', 0),
(927, 11588, 'Highwinds Network Group, Inc.', 'highwinds.com', 'US', 4864, 'isp', '1998-10-14 00:00:00', 0),
(928, 11589, 'Stowe Communications LLC', 'stowecable.com', 'US', 4096, 'business', '2011-07-27 00:00:00', 0),
(929, 11590, 'Cumberland Technologies International', 'ctiresidential.com', 'US', 25600, 'isp', '1998-10-14 00:00:00', 0),
(930, 11591, 'Capario, Inc.', 'capario.com', 'US', 1536, 'business', '2008-12-04 00:00:00', 0),
(931, 11593, 'Plains Equipment Group', 'plainseg.com', 'US', 256, 'business', '2014-02-11 00:00:00', 0),
(932, 11594, 'APUA', 'apua.ag', 'AG', 10240, 'isp', '2007-05-23 00:00:00', 0),
(933, 11595, 'Netsonic', 'netsonic.net', 'US', 8192, 'business', '1998-10-15 00:00:00', 0),
(934, 11596, 'Best Buy Co., Inc.', 'bestbuy.com', 'US', 131584, 'business', '1998-10-15 00:00:00', 0),
(935, 11597, 'Mercury Wireless, LLC', 'mercurywireless.com', 'US', 12288, 'isp', '2010-12-07 00:00:00', 0),
(936, 11598, 'Recol', 'recol.com', 'US', 8192, 'business', '1998-10-16 00:00:00', 0),
(937, 116, 'Telcordia Technologies', 'telcordia.com', 'US', 112896, 'business', '2000-05-04 00:00:00', 0),
(938, 11601, 'Reseau Picanoc.net Inc.', 'picanoc.net', 'CA', 5120, 'isp', '2007-05-23 00:00:00', 0),
(939, 11602, 'South Dakota School of Mines & Technology', 'sdsmt.edu', 'US', 60416, 'education', '1998-10-19 00:00:00', 0),
(940, 11604, 'Heller Information Services, Inc.', 'quilt.net', 'US', 2048, 'business', '1998-10-19 00:00:00', 0),
(941, 11605, 'Fluidsoft Incorporated', 'fluidsoft.net', 'US', 256, 'business', '2008-12-04 00:00:00', 0),
(942, 11606, 'Alteva Inc', 'wvtc.com', 'US', 24576, 'business', '1998-10-19 00:00:00', 0),
(943, 11607, 'South Dakota State University', 'sdstate.edu', 'US', 65536, 'education', '1998-10-19 00:00:00', 0),
(944, 11608, 'Accretive Networks', 'accretive-networks.net', 'US', 36352, 'business', '2001-06-21 00:00:00', 0),
(945, 11609, 'ELAVON', 'elavon.com', 'US', 7168, 'business', '1998-10-20 00:00:00', 0),
(946, 1161, 'SURFnet bv', 'surf.nl', 'NL', 70656, 'isp', '0000-00-00 00:00:00', 0),
(947, 11610, 'Internet Nebraska Corporation', 'inebraska.com', 'US', 1792, 'business', '1998-10-21 00:00:00', 0),
(948, 11612, 'Ready Telecom, Inc.', 'readytelecom.com', 'US', 7680, 'business', '1998-10-22 00:00:00', 0),
(949, 11618, 'Ignition Bermuda', 'ignition.com', 'BM', 2816, 'isp', '2010-12-07 00:00:00', 0),
(950, 11619, 'ANDERSON TRUCKING SERVICE, INC.', 'atsinc.com', 'US', 256, 'business', '2007-03-06 00:00:00', 0),
(951, 11620, 'Succeed.Net', 'succeed.net', 'US', 10240, 'business', '1998-10-26 00:00:00', 0),
(952, 11621, 'Reyes Holdings, L.L.C.', 'reyesholdings.com', 'US', 768, 'business', '2007-05-23 00:00:00', 0),
(953, 11622, 'Orland Fire Protection District', 'orlandfire.net', 'US', 256, 'business', '2017-07-18 00:00:00', 0),
(954, 11623, 'CT Communications Network', 'ctcommunications.com', 'US', 10240, 'isp', '1998-10-26 00:00:00', 0),
(955, 11624, 'COLLINS COMMUNICATIONS INC', 'collinscom.net', 'US', 5120, 'isp', '2012-11-27 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(956, 11626, 'ConneXon Telecom', '911enable.com', 'CA', 256, 'business', '2006-10-18 00:00:00', 0),
(957, 11628, 'Ontario Institute for Cancer Research', 'oicr.on.ca', 'CA', 2304, 'business', '2008-12-04 00:00:00', 0),
(958, 11629, 'Zenni Optical, LLC', 'zennioptical.com', 'US', 256, 'business', '2010-12-07 00:00:00', 0),
(959, 11632, 'American Society of Plastic Surgeons', 'plasticsurgery.org', 'US', 256, 'business', '2012-06-05 00:00:00', 0),
(960, 11633, '4Life Research USA, LLC', '4life.com', 'US', 512, 'business', '2007-05-23 00:00:00', 0),
(961, 11635, 'Envi Networks Ltd.', 'clearcable.ca', 'CA', 2048, 'isp', '2018-04-13 00:00:00', 0),
(962, 11636, 'MB SERVICES LTD.', 'mbmlex.com', 'CA', 256, 'business', '2007-06-25 00:00:00', 0),
(963, 11637, 'MetroDataPath, Inc.', 'metrodatapath.com', 'US', 1024, 'business', '2007-05-24 00:00:00', 0),
(964, 11639, 'ETC', 'trustetc.com', 'US', 256, 'business', '2017-08-03 00:00:00', 0),
(965, 11643, 'eBay, Inc', 'ebayinc.com', 'US', 28672, 'business', '1998-11-02 00:00:00', 0),
(966, 11644, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 512, 'business', '1999-11-18 00:00:00', 0),
(967, 11647, 'Sentex Communications Corporation', 'sentex.net', 'CA', 23296, 'isp', '1998-11-03 00:00:00', 0),
(968, 11648, 'Technicolor, Inc.', 'technicolor.com', 'US', 2304, 'business', '1998-11-03 00:00:00', 0),
(969, 11649, 'Gonzaga University', 'gonzaga.edu', 'US', 65536, 'education', '2006-08-22 00:00:00', 0),
(970, 11650, 'Pioneer Long Distance Inc.', 'pld.com', 'US', 40960, 'isp', '1998-11-04 00:00:00', 0),
(971, 11651, 'Centric Group, LLC', 'centricgroup.com', 'US', 512, 'business', '2012-06-11 00:00:00', 0),
(972, 11652, 'Kaiser Aluminum Fabricated Products, L.L.C.', 'kaiseraluminum.com', 'US', 256, 'business', '2014-01-21 00:00:00', 0),
(973, 11653, 'Puerto Rico Webmasters', 'prw.net', 'US', 7168, 'business', '1998-11-04 00:00:00', 0),
(974, 11656, 'Medical Mutual Services', 'medmutual.com', 'US', 2048, 'business', '2010-04-05 00:00:00', 0),
(975, 11657, 'Legg Mason & Co., LLC', 'leggmason.com', 'US', 4096, 'business', '1998-11-05 00:00:00', 0),
(976, 11659, 'University of Kansas Medical Center', 'kumc.edu', 'US', 65536, 'education', '1998-11-05 00:00:00', 0),
(977, 11661, 'Semicubic Systems LLC', 'semicubic.com', 'US', 512, 'business', '2020-02-04 00:00:00', 0),
(978, 11662, 'Diversified Media Group, LLC.', 'divmedia.net', 'US', 256, 'business', '2013-05-28 00:00:00', 0),
(979, 11663, 'State of Utah', 'utah.gov', 'US', 400896, 'isp', '2010-04-16 00:00:00', 0),
(980, 11664, 'Techtel LMDS Comunicaciones Interactivas S.A.', 'claro.com.ar', 'AR', 857600, 'isp', '1998-11-09 00:00:00', 0),
(981, 11666, 'Nexicom Inc.', 'nexicom.net', 'CA', 81152, 'isp', '1998-11-09 00:00:00', 0),
(982, 11667, 'Westel, Inc.', 'westel.net', 'US', 3328, 'business', '2010-12-08 00:00:00', 0),
(983, 11668, 'WEST COAST INTERNET INCORPORATED', 'thewestcoast.net', 'US', 12288, 'business', '1998-11-09 00:00:00', 0),
(984, 11672, 'GLOBALVISION', 'globalvision.net', 'US', 8192, 'business', '1998-11-09 00:00:00', 0),
(985, 11676, 'Conduent Business Services, LLC', 'conduent.com', 'US', 20224, 'business', '2013-12-13 00:00:00', 0),
(986, 11678, 'USDOE, NV Operations Office', 'doe.gov', 'US', 256, 'business', '1998-11-11 00:00:00', 0),
(987, 11679, 'Stihl Inc.', 'stihlusa.com', 'US', 512, 'business', '2012-06-29 00:00:00', 0),
(988, 11680, 'Hewlett-Packard Company', 'hp.com', 'US', 24576, 'business', '1998-11-12 00:00:00', 0),
(989, 11681, 'Integrity Networks', 'integrity-networks.net', 'US', 5632, 'business', '2005-05-09 00:00:00', 0),
(990, 11685, 'Huntington National Bank', 'huntington.com', 'US', 65536, 'business', '1998-11-16 00:00:00', 0),
(991, 11686, 'Education Networks of America', 'ena.com', 'US', 339456, 'education', '1998-11-16 00:00:00', 0),
(992, 11687, 'City of Hope Medical Center', 'coh.org', 'US', 16896, 'business', '1998-11-16 00:00:00', 0),
(993, 11688, 'Lightstream Communications, Inc.', 'lightstream.tech', 'US', 256, 'business', '2006-09-18 00:00:00', 0),
(994, 11690, 'Cognizant', 'cognizant.com', 'US', 2816, 'isp', '2012-09-21 00:00:00', 0),
(995, 11691, 'Evocative, Inc.', 'evocative.com', 'US', 8960, 'hosting', '1998-11-17 00:00:00', 0),
(996, 11692, 'Carewise Health, Inc.', 'carewisehealth.com', 'US', 256, 'business', '1998-11-17 00:00:00', 0),
(997, 11693, 'WideOpenWest Finance LLC', 'wowway.com', 'US', 22016, 'isp', '1998-11-17 00:00:00', 0),
(998, 11694, 'Universidad Simon Bolivar', 'usb.ve', 'VE', 65536, 'education', '1998-11-18 00:00:00', 0),
(999, 11695, 'TheStreet.Com', 'thestreet.com', 'US', 256, 'business', '1998-11-18 00:00:00', 0),
(1000, 11696, 'NBS', 'nbsvoice.com', 'US', 88832, 'isp', '1998-11-18 00:00:00', 0),
(1001, 11698, 'WESTERN IOWA TELEPHONE ASSOCIATION (A COOPERATIVE)', '7sigma.com', 'US', 4864, 'business', '2015-04-29 00:00:00', 0),
(1002, 11699, 'UniVoIP Inc.', 'univoip.com', 'US', 2048, 'business', '2014-01-21 00:00:00', 0),
(1003, 11700, 'CW-E', 'cw-e.ca', 'CA', 71168, 'isp', '1998-11-20 00:00:00', 0),
(1004, 11701, 'BOSTWICK LABORATORIES INC.', 'bostwicklaboratories.com', 'US', 256, 'business', '2006-07-12 00:00:00', 0),
(1005, 11702, 'ConneXon Telecom', '911enable.com', 'CA', 512, 'business', '2006-10-18 00:00:00', 0),
(1006, 11703, 'MaRS Discovery District', 'marsdd.com', 'CA', 512, 'business', '2006-07-12 00:00:00', 0),
(1007, 11706, 'Terra Networks Brasil S.A.', 'terra.com.br', 'BR', 66048, 'business', '1999-11-12 00:00:00', 0),
(1008, 11708, 'City of North Kansas City, MO', 'linkcity.org', 'US', 10240, 'business', '2006-08-22 00:00:00', 0),
(1009, 11709, 'VIRTUAL INTERACTIVE CENTER', 'virtu.nl', 'US', 256, 'business', '1998-11-23 00:00:00', 0),
(1010, 11710, 'ABBA TECHNOLOGIES', 'abbatech.com', 'US', 512, 'business', '2008-12-19 00:00:00', 0),
(1011, 11711, 'TULAROSA COMMUNICATIONS, INC.', 'tularosa.net', 'US', 78080, 'business', '1998-11-23 00:00:00', 0),
(1012, 11712, 'AT&T Services, Inc.', 'att.com', 'US', 32256, 'isp', '1998-11-23 00:00:00', 0),
(1013, 11713, 'Granite Block Global Data Center, Inc', 'congruity360.com', 'US', 1280, 'business', '2012-06-29 00:00:00', 0),
(1014, 11714, 'Network Nebraska', 'networknebraska.net', 'US', 294656, 'isp', '1998-11-23 00:00:00', 0),
(1015, 11715, '1538556 Ontario Inc.', 'theboatwarehouse.com', 'CA', 256, 'business', '2018-05-18 00:00:00', 0),
(1016, 11716, 'William O\'Neil & Company', 'williamoneil.com', 'US', 2048, 'business', '1998-11-24 00:00:00', 0),
(1017, 11719, 'Eaton Corporation', 'eaton.com', 'US', 198400, 'business', '1998-11-25 00:00:00', 0),
(1018, 11720, 'Independent Bank Corporation', 'ibcp.com', 'US', 512, 'business', '2013-03-28 00:00:00', 0),
(1019, 11722, 'Westelcom Internet, Inc.', 'westelcom.net', 'US', 13312, 'isp', '1998-12-01 00:00:00', 0),
(1020, 11724, 'Comptroller of the Currency', 'treas.gov', 'US', 1536, 'business', '2005-03-21 00:00:00', 0),
(1021, 11726, 'WB Games Inc.', 'wbgames.com', 'US', 512, 'business', '2017-07-17 00:00:00', 0),
(1022, 11727, 'Bruce Telecom', 'brucetelecom.com', 'CA', 17920, 'isp', '1998-12-01 00:00:00', 0),
(1023, 11728, 'LUCN LLC', 'berkeley.edu', 'US', 9216, 'education', '2006-10-23 00:00:00', 0),
(1024, 11729, 'Vista Higher Learning, Inc.', 'vistahigherlearning.com', 'US', 256, 'business', '2012-06-29 00:00:00', 0),
(1025, 11730, 'Progressive Finance', 'progfinance.com', 'US', 512, 'business', '2013-08-14 00:00:00', 0),
(1026, 11731, 'Weston Solutions, Inc.', 'westonsolutions.com', 'US', 512, 'business', '1998-12-02 00:00:00', 0),
(1027, 11732, 'INGRAM ENTERTAINMENT INC.', 'ingramentertainment.com', 'US', 512, 'business', '1998-12-02 00:00:00', 0),
(1028, 11733, 'E. & J. Gallo Winery Inc.', 'gallo.com', 'US', 2560, 'business', '2009-06-19 00:00:00', 0),
(1029, 11734, 'Connectria', 'connectria.com', 'US', 15872, 'business', '1998-12-03 00:00:00', 0),
(1030, 11736, 'University of South Dakota', 'usd.edu', 'US', 17152, 'education', '1998-12-03 00:00:00', 0),
(1031, 11737, 'Nu-Age Managed Services, LLC', 'nuageindustries.com', 'US', 768, 'business', '2010-12-09 00:00:00', 0),
(1032, 11738, 'BLIP Networks', 'gotblip.net', 'US', 3072, 'isp', '2020-02-04 00:00:00', 0),
(1033, 11740, 'Progressive Casualty Insurance Companies', 'progressive.com', 'US', 17152, 'business', '1998-12-03 00:00:00', 0),
(1034, 11741, 'BENTON REA POWERNET', 'bentonrea.org', 'US', 8192, 'business', '1998-12-03 00:00:00', 0),
(1035, 11742, 'SpotX, Inc.', 'spotx.tv', 'US', 1024, 'business', '2014-05-19 00:00:00', 0),
(1036, 11743, 'EBSCO Industries, Inc.', 'ebscoind.com', 'US', 768, 'business', '1998-12-04 00:00:00', 0),
(1037, 11744, 'Investec Bank Ltd', 'investec.co.za', 'ZA', 1280, 'business', '1998-12-04 00:00:00', 0),
(1038, 11745, 'University System of New Hampshire', 'usnh.edu', 'US', 73728, 'education', '1998-12-04 00:00:00', 0),
(1039, 11746, 'Waggener Edstrom', 'waggeneredstrom.com', 'US', 1024, 'business', '1998-12-07 00:00:00', 0),
(1040, 11747, 'MK Systems USA Inc.', 'mediakind.com', 'US', 2048, 'business', '2018-07-18 00:00:00', 0),
(1041, 11750, 'Interdotnet Argentina S.A.', 'inter.net', 'AR', 4352, 'business', '1998-12-07 00:00:00', 0),
(1042, 11751, 'INSTITUTO CYBER DE ENSINO E PESQUISA', 'icep.org.br', 'BR', 3328, 'business', '2000-02-15 00:00:00', 0),
(1043, 11753, 'Netrepid', 'netrepid.com', 'US', 5120, 'business', '1998-12-08 00:00:00', 0),
(1044, 11756, 'Children\'s Hospital Los Angeles', 'chla.org', 'US', 2048, 'business', '2014-10-31 00:00:00', 0),
(1045, 11757, 'Whirlpool Corporation', 'whirlpool.com', 'US', 212992, 'isp', '1998-12-08 00:00:00', 0),
(1046, 11758, 'IRIS Networks', 'irisnetworksusa.com', 'US', 3584, 'business', '2007-05-15 00:00:00', 0),
(1047, 11759, 'The Canine Companies Inc.', 'caninecompanies.com', 'US', 256, 'business', '2011-07-19 00:00:00', 0),
(1048, 11760, 'Connecticut Housing Finance Authority', 'chfa.org', 'US', 512, 'business', '2009-10-23 00:00:00', 0),
(1049, 11763, 'MitoTec', 'mitotec.com', 'US', 6400, 'business', '2007-05-25 00:00:00', 0),
(1050, 11765, 'Netsurion LLC', 'netsurion.com', 'US', 768, 'business', '2013-03-28 00:00:00', 0),
(1051, 11766, 'Meriplex Communications, Ltd.', 'meriplex.com', 'US', 12288, 'business', '1998-12-11 00:00:00', 0),
(1052, 11767, 'Quality Technology Services, LLC', 'qualitytech.com', 'US', 11520, 'business', '2007-12-14 00:00:00', 0),
(1053, 11768, 'Vontobel Asset Management INC', 'vusa.com', 'US', 256, 'business', '2007-04-02 00:00:00', 0),
(1054, 11769, 'Mobilenetics Corporation', 'mobilenetics.com', 'US', 4608, 'business', '1998-12-14 00:00:00', 0),
(1055, 11770, 'Net 56, Inc.', 'net56.com', 'US', 6144, 'business', '1998-12-14 00:00:00', 0),
(1056, 11773, 'The University Of Texas M.D. Anderson Cancer Center', 'mdanderson.org', 'US', 65792, 'education', '1998-12-15 00:00:00', 0),
(1057, 11776, 'Atlantic Broadband Finance, LLC', 'atlanticbb.com', 'US', 586752, 'isp', '2005-03-14 00:00:00', 0),
(1058, 11777, 'North Carolina Adminstrative Office of the Courts', 'nccourts.org', 'US', 1024, 'business', '2008-03-11 00:00:00', 0),
(1059, 11781, 'TradeGlobal, LLC', 'tradeglobal.com', 'US', 256, 'business', '2012-06-11 00:00:00', 0),
(1060, 11782, 'Perfecto Mobile Inc', 'perfecto.io', 'US', 768, 'business', '2013-05-20 00:00:00', 0),
(1061, 11783, 'Brooklyn Law School', 'brooklaw.edu', 'US', 2048, 'education', '2007-05-25 00:00:00', 0),
(1062, 11784, 'AV8 Internet, Inc', 'av8.com', 'US', 2048, 'business', '1998-12-17 00:00:00', 0),
(1063, 11785, 'Element 8 Internet', 'e8internet.com', 'US', 256, 'business', '2020-02-04 00:00:00', 0),
(1064, 11787, 'Supreme Court of Pennsylvania', 'pacourts.us', 'US', 1024, 'business', '1998-12-18 00:00:00', 0),
(1065, 11790, 'Random House, Inc.', 'randomhouse.com', 'US', 24576, 'business', '1998-12-18 00:00:00', 0),
(1066, 11791, 'IdenTrust', 'identrust.com', 'US', 1536, 'business', '1998-12-21 00:00:00', 0),
(1067, 11795, 'Sony Interactive Entertainment LLC.', 'playstation.com', 'US', 4096, 'business', '1998-12-22 00:00:00', 0),
(1068, 11796, 'Airstream Communications, LLC', 'airstreamcomm.net', 'US', 113152, 'isp', '1998-12-22 00:00:00', 0),
(1069, 11798, 'Ace Data Centers, Inc.', 'acedatacenter.com', 'US', 37888, 'business', '2006-11-01 00:00:00', 0),
(1070, 11799, 'Clarksys Inc.', 'clarksys.com', 'US', 16640, 'business', '2007-04-02 00:00:00', 0),
(1071, 118, 'DoD Network Information Center', 'mail.mil', 'US', 256, 'isp', '1987-06-22 00:00:00', 0),
(1072, 11802, 'Centro de Informatica e Automacao do Estado de SC', 'csc.sc.gov.br', 'BR', 12288, 'business', '1999-11-18 00:00:00', 0),
(1073, 11803, 'Omnicell Inc.', 'omnicell.com', 'US', 512, 'business', '2008-12-05 00:00:00', 0),
(1074, 11804, 'All Mobile Video Inc', 'allmobilevideo.com', 'US', 768, 'business', '2012-04-26 00:00:00', 0),
(1075, 11805, 'Ennwise', 'ennwise.com', 'US', 1024, 'business', '2020-02-28 00:00:00', 0),
(1076, 11806, 'Leepfrog Technologies, Inc.', 'leepfrog.com', 'US', 768, 'business', '1998-12-29 00:00:00', 0),
(1077, 11807, 'Divertissements GameLoft Inc', 'gameloft.com', 'CA', 3072, 'business', '2006-09-05 00:00:00', 0),
(1078, 11808, 'University of Idaho', 'uidaho.edu', 'US', 65536, 'education', '1998-12-29 00:00:00', 0),
(1079, 11809, 'Embry-Riddle University', 'erau.edu', 'US', 67840, 'education', '1998-12-29 00:00:00', 0),
(1080, 11810, 'AWeber Systems, Inc.', 'aweber.com', 'US', 768, 'business', '2010-12-22 00:00:00', 0),
(1081, 11811, 'Oppenheimer & Co. Inc.', 'oppenheimer.com', 'US', 512, 'business', '2007-01-17 00:00:00', 0),
(1082, 11813, 'Natixis North America LLC', 'natixis.com', 'US', 256, 'business', '1998-12-30 00:00:00', 0),
(1083, 11814, 'DISTRIBUTEL COMMUNICATIONS LTD.', 'distributel.ca', 'CA', 311552, 'isp', '1998-12-30 00:00:00', 0),
(1084, 11815, 'Cooperativa Telefonica de V.G.G. Ltda.', 'telvgg.coop', 'AR', 21504, 'isp', '1998-12-30 00:00:00', 0),
(1085, 11816, 'SetarNet', 'setarnet.aw', 'AW', 74496, 'isp', '1998-12-31 00:00:00', 0),
(1086, 11817, 'Stafford Associates Computer Specialists, Inc.', 'staffordassociates.com', 'US', 3072, 'business', '1998-12-31 00:00:00', 0),
(1087, 11819, 'Smith & Associates', 'nfsmith.com', 'US', 256, 'business', '1998-12-31 00:00:00', 0),
(1088, 11820, 'Wikimedia Foundation, Inc.', 'wikimedia.org', 'US', 256, 'business', '2013-09-30 00:00:00', 0),
(1089, 11821, 'SmartBurst LLC', 'smartburst.com', 'US', 1536, 'business', '2017-08-03 00:00:00', 0),
(1090, 11823, 'Lord, Abbett & Co.', 'lordabbett.com', 'US', 512, 'business', '1999-01-04 00:00:00', 0),
(1091, 11825, 'JDRF International', 'jdrf.org', 'US', 512, 'business', '2013-10-03 00:00:00', 0),
(1092, 11826, 'Regional Information Sharing Systems (RISS), Office of Information Technology (OIT)', 'riss.net', 'US', 1536, 'business', '1999-01-05 00:00:00', 0),
(1093, 11827, 'Washington State University', 'wsu.edu', 'US', 70400, 'education', '1999-01-05 00:00:00', 0),
(1094, 11829, 'Cadence Design Systems, Inc.', 'cadence.com', 'US', 2560, 'business', '1999-01-05 00:00:00', 0),
(1095, 11830, 'Instituto Costarricense de Electricidad y Telecom.', 'ice.go.cr', 'CR', 1512960, 'isp', '1999-01-06 00:00:00', 0),
(1096, 11831, 'eSecureData', 'esecuredata.com', 'CA', 15360, 'hosting', '2011-03-25 00:00:00', 0),
(1097, 11833, 'LEAP Agency LLC', 'leapagency.com', 'US', 4096, 'business', '1999-01-07 00:00:00', 0),
(1098, 11834, 'Drexel University', 'drexel.edu', 'US', 131840, 'education', '1999-01-07 00:00:00', 0),
(1099, 11835, 'NOVA FIBRA TELECOM S.A.', 'novafibratelecom.com.br', 'BR', 34048, 'isp', '1999-11-18 00:00:00', 0),
(1100, 11836, 'Intercom', 'intercominc.com', 'US', 8192, 'business', '1999-01-12 00:00:00', 0),
(1101, 11840, 'VeriSign Infrastructure & Operations', 'verisign.com', 'US', 3328, 'business', '1999-01-13 00:00:00', 0),
(1102, 11841, 'Ultimate Internet Access, Inc', 'uia.net', 'US', 54016, 'isp', '1999-01-14 00:00:00', 0),
(1103, 11842, 'Regal Entertainment Group', 'regmovies.com', 'US', 768, 'business', '1999-01-14 00:00:00', 0),
(1104, 11844, 'Empresa Catarinense De Tec em Telecomunicacoes Ltd', 'ole.net.br', 'BR', 18432, 'business', '2000-06-12 00:00:00', 0),
(1105, 11845, 'Vox Telecom Ltd', 'voxtelecom.co.za', 'ZA', 289280, 'isp', '1999-01-14 00:00:00', 0),
(1106, 11847, 'Mid-Maine Communications, Inc.', 'mid-maine.com', 'US', 38912, 'isp', '1999-01-15 00:00:00', 0),
(1107, 11849, 'Camplink', 'camplink.net', 'US', 1024, 'business', '2009-01-29 00:00:00', 0),
(1108, 11850, 'MagsNet LLC', 'mags.net', 'US', 4096, 'business', '1999-01-15 00:00:00', 0),
(1109, 11851, 'The Michener Institute for Applied Health Sciences', 'michener.ca', 'CA', 512, 'business', '2010-10-14 00:00:00', 0),
(1110, 11852, 'White House Custom Colour, Inc', 'whcc.com', 'US', 256, 'business', '2011-06-06 00:00:00', 0),
(1111, 11853, 'Internap Holding LLC', 'inap.com', 'US', 17920, 'isp', '1999-01-20 00:00:00', 0),
(1112, 11854, 'Internap Holding LLC', 'inap.com', 'US', 10496, 'isp', '1999-01-20 00:00:00', 0),
(1113, 11855, 'Internap Holding LLC', 'inap.com', 'US', 15104, 'isp', '1999-01-20 00:00:00', 0),
(1114, 11856, 'XConnect Global Networks Ltd.', 'xconnect.net', 'US', 1280, 'business', '2006-11-01 00:00:00', 0),
(1115, 11857, 'Aegon USA, Inc.', 'aegonusa.com', 'US', 132352, 'business', '1999-01-20 00:00:00', 0),
(1116, 11858, 'Cm2.com Inc.', 'erado.com', 'US', 8192, 'business', '1999-01-20 00:00:00', 0),
(1117, 11859, 'Bracco Diagnostics Inc.', 'bracco.com', 'US', 256, 'business', '2012-10-29 00:00:00', 0),
(1118, 11860, 'AEGIS Insurance Services, Inc.', 'aegislink.com', 'US', 256, 'business', '2011-01-19 00:00:00', 0),
(1119, 11862, 'Radial, Inc.', 'radial.com', 'US', 1536, 'business', '2012-07-02 00:00:00', 0),
(1120, 11863, 'Pacific Lutheran University', 'plu.edu', 'US', 65536, 'education', '1999-01-21 00:00:00', 0),
(1121, 11866, 'Ellucian Company LP', 'ellucian.com', 'US', 512, 'business', '1999-01-21 00:00:00', 0),
(1122, 11868, 'SITA', 'sita.aero', 'US', 1024, 'business', '2012-09-21 00:00:00', 0),
(1123, 11870, 'ALTICOR INC', 'alticor.com', 'US', 65536, 'business', '1999-01-25 00:00:00', 0),
(1124, 11871, 'Duke Energy Corporation', 'duke-energy.com', 'US', 256, 'business', '1999-01-25 00:00:00', 0),
(1125, 11872, 'Syracuse University', 'syr.edu', 'US', 131072, 'education', '1999-01-25 00:00:00', 0),
(1126, 11874, 'Columbus Regional Hospital', 'crh.org', 'US', 256, 'business', '2012-01-10 00:00:00', 0),
(1127, 11875, 'William Herrin', 'herrin.us', 'US', 512, 'business', '2008-12-05 00:00:00', 0),
(1128, 11877, 'GENMODO', 'genmodo.com', 'US', 256, 'business', '2020-05-28 00:00:00', 0),
(1129, 11878, 'tzulo, inc.', 'tzulo.com', 'US', 124672, 'isp', '2007-04-02 00:00:00', 0),
(1130, 11880, 'Tickets.com, Inc.', 'tickets.com', 'US', 1280, 'business', '2010-12-08 00:00:00', 0),
(1131, 11881, 'CNA National Warranty Corporation', 'cnanational.com', 'US', 256, 'business', '2012-11-28 00:00:00', 0),
(1132, 11882, 'COMPREHENSIVE HEALTH MANAGEMENT, INC.', 'wellcare.com', 'US', 1280, 'business', '2008-05-22 00:00:00', 0),
(1133, 11883, 'TEGNA Inc.', 'tegna.com', 'US', 256, 'business', '2008-06-23 00:00:00', 0),
(1134, 11884, 'SMARTHOME, INC.', 'smarthome.com', 'US', 256, 'business', '2005-10-17 00:00:00', 0),
(1135, 11888, 'Television Internacional, S.A. de C.V.', 'izzi.mx', 'MX', 493824, 'isp', '1999-01-28 00:00:00', 0),
(1136, 11889, 'iBasis, Inc.', 'ibasis.com', 'US', 2560, 'isp', '1999-01-28 00:00:00', 0),
(1137, 11892, 'NCS Pearson Inc.', 'ncspearson.com', 'US', 13568, 'business', '1999-01-29 00:00:00', 0),
(1138, 11893, 'Loligo Cache Systems, Inc.', 'loligo.com', 'US', 2048, 'business', '1999-01-29 00:00:00', 0),
(1139, 11894, 'Service Credit Union', 'servicecu.org', 'US', 512, 'business', '2017-08-03 00:00:00', 0),
(1140, 11895, 'Kofax, Inc.', 'kofax.com', 'US', 512, 'business', '2007-06-11 00:00:00', 0),
(1141, 11897, 'Tulsa Community College', 'tulsacc.edu', 'US', 1280, 'education', '2009-01-05 00:00:00', 0),
(1142, 11898, 'TRUNO Retail Technology Solutions', 'truno.com', 'US', 512, 'business', '2020-02-04 00:00:00', 0),
(1143, 11899, 'Measurement Incorporated', 'measurementinc.com', 'US', 256, 'business', '2007-08-27 00:00:00', 0),
(1144, 11900, 'Datacruz, Inc.', 'datacruz.com', 'US', 2048, 'business', '1999-02-01 00:00:00', 0),
(1145, 11901, 'County of Sacramento', 'saccounty.net', 'US', 1024, 'business', '2007-05-29 00:00:00', 0),
(1146, 11903, 'Lincolnshire Management, Inc.', 'lincolnshiremgmt.com', 'US', 256, 'business', '2006-08-15 00:00:00', 0),
(1147, 11904, 'AcenTek', 'acentek.net', 'US', 19456, 'isp', '1999-02-02 00:00:00', 0),
(1148, 11910, 'LakeNet LLC', 'lakenetmi.com', 'US', 3072, 'business', '2014-02-06 00:00:00', 0),
(1149, 11911, 'The Bank of New York Mellon Corporation', 'bnymellon.com', 'US', 102400, 'business', '1999-02-03 00:00:00', 0),
(1150, 11915, 'TPx Communications', 'tpx.com', 'US', 82688, 'isp', '2005-02-25 00:00:00', 0),
(1151, 11916, 'UNDP', 'undp.org', 'US', 65792, 'business', '1999-02-03 00:00:00', 0),
(1152, 11917, 'WhatsApp', 'whatsapp.com', 'US', 1024, 'business', '2018-11-01 00:00:00', 0),
(1153, 11919, 'Telesat Network Services Inc', 'telesat.com', 'US', 9216, 'business', '1999-02-04 00:00:00', 0),
(1154, 11921, 'SECRELNET INFORMATICA LTDA', 'secrel.net.br', 'BR', 28672, 'business', '1999-11-18 00:00:00', 0),
(1155, 11922, 'RealNetworks, Inc.', 'realnetworks.com', 'US', 6144, 'business', '1999-02-05 00:00:00', 0),
(1156, 11924, 'Montana Opticom, LLC', 'mt-opticom.com', 'US', 16640, 'isp', '2007-03-06 00:00:00', 0),
(1157, 11925, 'Delta Dental of Wisconsin, Inc', 'deltadentalwi.com', 'US', 256, 'business', '2007-05-30 00:00:00', 0),
(1158, 11926, 'Hart Software, Inc.', 'hartsoftware.com', 'US', 256, 'business', '2013-05-20 00:00:00', 0),
(1159, 11927, 'Advance Publications Inc.', 'advance.net', 'US', 4096, 'business', '1999-02-08 00:00:00', 0),
(1160, 11928, 'Hachette Book Group, Inc.', 'hachettebookgroup.com', 'US', 1536, 'business', '1999-02-08 00:00:00', 0),
(1161, 11929, 'MFA Oil Company', 'mfaoil.com', 'US', 512, 'business', '2018-07-31 00:00:00', 0),
(1162, 11931, 'NYCEDC', 'edc.nyc', 'US', 256, 'business', '2019-05-21 00:00:00', 0),
(1163, 11933, 'Supply Technologies, LLC', 'supplytechnologies.com', 'US', 512, 'business', '2007-08-03 00:00:00', 0),
(1164, 11935, 'TalkPoint Communications', 'talkpoint.com', 'US', 2048, 'business', '1999-02-09 00:00:00', 0),
(1165, 11936, 'Marathon Cheese Corporation', 'mcheese.com', 'US', 256, 'business', '2018-12-07 00:00:00', 0),
(1166, 11937, 'TRX Inc.', 'trx.com', 'US', 256, 'business', '1999-02-09 00:00:00', 0),
(1167, 11939, 'The MathWorks, Inc.', 'mathworks.com', 'US', 65536, 'business', '1999-02-09 00:00:00', 0),
(1168, 11940, 'Direct Supply, Inc.', 'directsupplycareers.com', 'US', 1024, 'business', '1999-02-09 00:00:00', 0),
(1169, 11941, 'Pillsbury Madison & Sutro, Inc.', 'pillsburylaw.com', 'US', 6400, 'business', '2005-05-09 00:00:00', 0),
(1170, 11942, 'IP Global, LLC.', 'ipglobal.net', 'US', 13312, 'business', '1999-02-10 00:00:00', 0),
(1171, 11944, 'Webtrends Corporation', 'webtrends.com', 'US', 256, 'business', '1999-02-10 00:00:00', 0),
(1172, 11945, 'Corporation of the Fine Arts Museums', 'famsf.org', 'US', 256, 'business', '2010-08-25 00:00:00', 0),
(1173, 11947, 'Cablenett Limited', 'cablenett.net', 'TT', 16384, 'isp', '1999-02-10 00:00:00', 0),
(1174, 11948, 'Development Group, Inc', 'development-group.net', 'US', 512, 'business', '2011-07-19 00:00:00', 0),
(1175, 11949, 'COZAD TELEPHONE COMPANY', 'cozadtel.net', 'US', 4096, 'business', '2009-11-11 00:00:00', 0),
(1176, 11951, 'Medical Computer Systems', 'medicalcomputersystems.com', 'US', 37376, 'business', '1999-02-12 00:00:00', 0),
(1177, 11954, 'Bayview Financial, LP', 'bayviewfinancial.com', 'US', 512, 'business', '2005-03-14 00:00:00', 0),
(1178, 11955, 'Charter Communications Inc', 'charter.com', 'US', 93952, 'isp', '2000-06-09 00:00:00', 0),
(1179, 11956, 'NOAA / PMEL', 'noaa.gov', 'US', 1024, 'isp', '1999-02-12 00:00:00', 0),
(1180, 11958, 'USAble Life', 'usablelife.com', 'US', 512, 'business', '2014-08-20 00:00:00', 0),
(1181, 11959, 'AEG', 'aegworldwide.com', 'US', 256, 'business', '2017-08-08 00:00:00', 0),
(1182, 11960, 'EMPRESA DE TELECOMUNICACIONES DE CUBA S.A. (IXP CUBA)', 'co.cu', 'CU', 256, 'business', '1999-02-12 00:00:00', 0),
(1183, 11961, 'Mid-Rivers Telephone Cooperative', 'midrivers.com', 'US', 24576, 'business', '1999-02-16 00:00:00', 0),
(1184, 11962, 'Empire Today LLC', 'empiretoday.com', 'US', 512, 'business', '2007-01-05 00:00:00', 0),
(1185, 11963, 'PennWell Corporation', 'pennwell.net', 'US', 8448, 'business', '1999-02-16 00:00:00', 0),
(1186, 11964, 'Air Wisconsin Airlines Corporation', 'airwis.com', 'US', 512, 'business', '2007-07-13 00:00:00', 0),
(1187, 11966, 'GLOBAL DATA SYSTEMS INC.', 'getgds.com', 'US', 5888, 'business', '1999-02-16 00:00:00', 0),
(1188, 11967, 'W &T Offshore, Inc.', 'wtoffshore.com', 'US', 256, 'business', '2009-02-09 00:00:00', 0),
(1189, 11969, 'MACSTEEL SERVICE CENTERS USA, INC.', 'macsteelusa.com', 'US', 4352, 'business', '2010-01-11 00:00:00', 0),
(1190, 1197, 'Network Ability Limited', 'netability.ie', 'IE', 3328, 'business', '2010-11-18 17:03:30', 0),
(1191, 11970, 'e-Tel, LLC', 'vci.net', 'US', 8960, 'business', '1999-02-17 00:00:00', 0),
(1192, 11971, 'Pfizer Inc.', 'pfizer.com', 'US', 65536, 'business', '1999-02-17 00:00:00', 0),
(1193, 11973, 'Secure Independence, Inc', 'nypwh.com', 'US', 2048, 'business', '2008-12-19 00:00:00', 0),
(1194, 11974, 'US Department of State', 'state.gov', 'US', 256, 'business', '2018-10-01 00:00:00', 0),
(1195, 11975, 'The College of William and Mary', 'wm.edu', 'US', 131072, 'education', '1999-02-18 00:00:00', 0),
(1196, 11976, 'Fidelity Communication International Inc.', 'fidelitycommunications.com', 'US', 125184, 'isp', '1999-02-19 00:00:00', 0),
(1197, 11978, 'Vegas.com, LLC', 'vegas.com', 'US', 1280, 'business', '2019-05-30 00:00:00', 0),
(1198, 11979, 'Bluegrass Network LLC', 'blue.net', 'US', 25856, 'isp', '1999-02-22 00:00:00', 0),
(1199, 11980, 'BDO USA, LLP', 'bdo.com', 'US', 1024, 'business', '1999-02-22 00:00:00', 0),
(1200, 11982, 'Sandhills Wireless, LLC', 'shwisp.net', 'US', 1024, 'business', '2013-08-27 00:00:00', 0),
(1201, 11985, 'Social Security Administration', 'ssa.gov', 'US', 18688, 'business', '1999-02-22 00:00:00', 0),
(1202, 11986, 'InfoStructure', 'originnetworks.us', 'US', 24576, 'business', '1999-02-23 00:00:00', 0),
(1203, 11988, 'CEVA INC.', 'ceva-dsp.com', 'US', 256, 'business', '2008-06-10 00:00:00', 0),
(1204, 11989, 'Jumpline Inc', 'jumpline.com', 'US', 7424, 'hosting', '2007-05-30 00:00:00', 0),
(1205, 1199, 'SURFnet bv', 'surf.nl', 'NL', 65536, 'isp', '2002-09-20 11:12:07', 0),
(1206, 11990, 'Unlimited Net, LLC', 'unlimitednet.us', 'US', 2560, 'business', '2012-09-21 00:00:00', 0),
(1207, 11992, 'AT&T Mobility Puerto Rico', 'att.com', 'PR', 118784, 'isp', '1999-02-23 00:00:00', 0),
(1208, 11993, 'BANCO DO BRASIL S.A.', 'bb.com.br', 'BR', 67584, 'business', '2007-02-13 00:00:00', 0),
(1209, 11994, 'Cruzio', 'cruzio.com', 'US', 15360, 'hosting', '2006-09-18 00:00:00', 0),
(1210, 11995, 'Oregon Health & Science University', 'ohsu.edu', 'US', 133120, 'education', '1999-02-23 00:00:00', 0),
(1211, 11996, 'Lobo Internet Services, Ltd', 'lobo.net', 'US', 9216, 'business', '1999-02-23 00:00:00', 0),
(1212, 11998, 'Province of New Brunswick', 'snb.ca', 'CA', 66048, 'education', '1999-02-24 00:00:00', 0),
(1213, 11999, 'REJIS Commission', 'rejis.org', 'US', 1024, 'business', '2007-11-12 00:00:00', 0),
(1214, 12, 'New York University', 'nyu.edu', 'US', 99072, 'education', '1984-07-05 00:00:00', 0),
(1215, 1200, 'Amsterdam Internet Exchange B.V.', 'ams-ix.net', 'NL', 5120, 'business', '2002-03-21 10:27:21', 0),
(1216, 12000, 'Fidelity Investments', 'fidelity.com', 'US', 768, 'business', '1999-02-24 00:00:00', 0),
(1217, 12001, 'Point North Networks, Inc.', 'pointnorth.net', 'US', 3072, 'business', '2012-08-24 00:00:00', 0),
(1218, 12002, 'Great Point Partners, LLC', 'gppfunds.com', 'US', 256, 'business', '2006-03-13 00:00:00', 0),
(1219, 12004, 'Young Living Essential Oils', 'youngliving.com', 'US', 256, 'isp', '2005-03-14 00:00:00', 0),
(1220, 12005, 'University of South Carolina', 'sc.edu', 'US', 67584, 'education', '1999-03-01 00:00:00', 0),
(1221, 12007, 'Raytheon Company', 'ray.com', 'US', 36608, 'business', '1999-03-03 00:00:00', 0),
(1222, 12008, 'NeuStar, Inc.', 'home.neustar', 'US', 7936, 'isp', '1999-03-03 00:00:00', 0),
(1223, 12009, 'Eastern Oregon Net, Inc.', 'eoni.com', 'US', 12288, 'isp', '1999-03-03 00:00:00', 0),
(1224, 1201, 'Old Dominion University', 'odu.edu', 'US', 65536, 'education', '1990-12-18 00:00:00', 0),
(1225, 12010, 'International Financial Data Services (Canada) Ltd.', 'ifdsgroup.com', 'CA', 512, 'business', '2006-12-05 00:00:00', 0),
(1226, 12011, 'Thompson School District', 'thompsonschools.org', 'US', 256, 'education', '2018-12-06 00:00:00', 0),
(1227, 12012, 'Novani, LLC', 'novani.com', 'US', 768, 'business', '2011-11-09 00:00:00', 0),
(1228, 12013, 'Florida Atlantic University', 'fau.edu', 'US', 65536, 'education', '1999-03-03 00:00:00', 0),
(1229, 12016, 'Retirement Housing Foundation', 'rhf.org', 'US', 512, 'business', '2013-06-04 00:00:00', 0),
(1230, 12017, 'PITTSBURGH LOGISTICS SYSTEMS, INC.', 'pghlogistics.com', 'US', 256, 'business', '2007-05-30 00:00:00', 0),
(1231, 12018, 'OOCL (USA), Inc.', 'oocl.com', 'US', 2816, 'business', '1999-03-03 00:00:00', 0),
(1232, 12019, 'Network Communications', 'net-com.com', 'US', 18688, 'isp', '2007-01-03 00:00:00', 0),
(1233, 12020, 'Methodist Hospital of Southern California', 'methodisthospital.org', 'US', 256, 'business', '2010-10-11 00:00:00', 0),
(1234, 12021, 'Rogers Communications Canada Inc.', 'rogers.com', 'CA', 24576, 'isp', '1999-03-04 00:00:00', 0),
(1235, 12022, 'Springleaf Finance Inc.', 'springleaf.com', 'US', 3072, 'business', '2014-03-19 00:00:00', 0),
(1236, 12024, 'Advanced Corporate Network', 'acnusa.net', 'US', 8192, 'business', '1999-03-05 00:00:00', 0),
(1237, 12025, 'Iron Mountain Data Center', 'ironmountain.com', 'US', 118528, 'isp', '2007-05-30 00:00:00', 0),
(1238, 12028, 'MM Internet, Inc.', 'mminternet.com', 'US', 12288, 'business', '1999-03-05 00:00:00', 0),
(1239, 12031, 'Lord Corporation', 'lord.com', 'US', 256, 'business', '1999-03-05 00:00:00', 0),
(1240, 12033, 'Adams TelSystems, Inc.', 'adamstel.com', 'US', 32768, 'isp', '1999-03-05 00:00:00', 0),
(1241, 12036, 'ISP Associates, Inc. DBA Dixie-Net', 'dixie-net.com', 'US', 20736, 'business', '1999-03-05 00:00:00', 0),
(1242, 12037, 'Federal Deposit Insurance Corporation', 'fdic.gov', 'US', 1792, 'business', '1999-03-08 00:00:00', 0),
(1243, 1204, 'State University of New York, Central', 'suny.edu', 'US', 16896, 'education', '1990-12-20 00:00:00', 0),
(1244, 12041, 'Afilias, Inc.', 'afilias.info', 'US', 142592, 'business', '2006-10-19 00:00:00', 0),
(1245, 12042, 'Consolidated Communications, Inc.', 'consolidated.com', 'US', 137984, 'isp', '1999-03-09 00:00:00', 0),
(1246, 12043, 'Boston Partners Global Investors, Inc.', 'boston-partners.com', 'US', 256, 'business', '2010-02-18 00:00:00', 0),
(1247, 12044, 'Willamette Valley Internet, L.L.C.', 'wvi.com', 'US', 14592, 'business', '1999-03-09 00:00:00', 0),
(1248, 12046, 'Malta Internet Foundation', 'compucreations.com', 'EU', 13568, 'isp', '2002-09-18 08:34:16', 0),
(1249, 12047, 'Gundersen Lutheran Medical Center, Inc.', 'gundersenhealth.org', 'US', 1280, 'business', '2007-01-03 00:00:00', 0),
(1250, 1205, 'University Linz', 'uni-linz.ac.at', 'AT', 67584, 'education', '2002-09-03 14:20:59', 0),
(1251, 12050, 'DIRECTV, LLC', 'directv.com', 'US', 22016, 'business', '2000-08-20 00:00:00', 0),
(1252, 12051, 'City of Escondido', 'escondido.org', 'US', 512, 'business', '1999-03-09 00:00:00', 0),
(1253, 12052, 'VF Services, Inc. Information Technology Services', 'vfc.com', 'US', 11264, 'business', '1999-03-10 00:00:00', 0),
(1254, 12053, 'TruMark Financial Credit Union', 'trumarkonline.org', 'US', 512, 'business', '2017-08-08 00:00:00', 0),
(1255, 12054, 'Alameda County', 'alamedactc.org', 'US', 17152, 'business', '2007-01-17 00:00:00', 0),
(1256, 12055, 'Clearbearing Inc.', 'clearbearing.com', 'US', 512, 'business', '2007-03-08 00:00:00', 0),
(1257, 12056, 'Yucca Telecom', 'yucca.net', 'US', 6144, 'business', '2011-02-24 00:00:00', 0),
(1258, 12057, 'LiveVox, INC.', 'livevox.com', 'US', 1024, 'business', '2011-02-04 00:00:00', 0),
(1259, 12058, 'EXPEDIA, INC', 'expediagroup.com', 'US', 256, 'business', '2019-11-18 00:00:00', 0),
(1260, 12059, 'Internet Light and Power Inc.', 'ilap.com', 'CA', 8448, 'isp', '1999-03-12 00:00:00', 0),
(1261, 1206, 'Pittsburgh Supercomputing Center', 'psc.edu', 'US', 66048, 'education', '1991-01-11 00:00:00', 0),
(1262, 12060, 'NAP OF CENTRAL FLORIDA, INC', 'sowardsinc.com', 'US', 256, 'business', '2014-12-03 00:00:00', 0),
(1263, 12061, '24 Hour Fitness USA, Inc.', '24hourfitness.com', 'US', 512, 'business', '1999-03-15 00:00:00', 0),
(1264, 12062, 'Decision One', 'decisionone.com', 'US', 512, 'business', '1999-03-15 00:00:00', 0),
(1265, 12065, 'Revo Communications', 'revocommunications.com', 'US', 768, 'business', '2012-09-21 00:00:00', 0),
(1266, 12066, 'ALTICE DOMINICANA S.A.', 'altice.com.do', 'DO', 319488, 'isp', '1999-03-15 00:00:00', 0),
(1267, 12068, 'West Corporation', 'west.com', 'US', 1024, 'business', '2010-09-13 00:00:00', 0),
(1268, 12069, 'Rev.Net Technologies', 'rev.net', 'US', 4096, 'business', '1999-03-15 00:00:00', 0),
(1269, 1207, 'Pittsburgh Supercomputing Center', 'psc.edu', 'US', 33024, 'education', '1991-01-11 00:00:00', 0),
(1270, 12071, 'Blue Cod Technologies, Inc.', 'bluecod.com', 'US', 256, 'business', '2015-05-14 00:00:00', 0),
(1271, 12072, 'Aquiline Holdings, LLC', 'aquiline-llc.com', 'US', 256, 'business', '2007-05-31 00:00:00', 0),
(1272, 12073, 'Contemporary Computer Services Inc.', 'ccsinet.com', 'US', 4096, 'business', '1999-03-15 00:00:00', 0),
(1273, 12074, 'County of Saginaw', 'saginawcounty.com', 'US', 256, 'business', '2017-11-08 00:00:00', 0),
(1274, 12075, 'Jacobs Engineering Group', 'jacobs.com', 'US', 69120, 'business', '1999-03-16 00:00:00', 0),
(1275, 12076, 'Microsoft Corporation', 'microsoft.com', 'US', 18688, 'business', '1999-03-16 00:00:00', 0),
(1276, 12077, 'Celerity IT, LLC', 'celerity.com', 'US', 256, 'business', '2014-08-28 00:00:00', 0),
(1277, 12079, 'Cellco Partnership DBA Verizon Wireless', 'verizonwireless.com', 'US', 163840, 'isp', '1999-03-17 00:00:00', 0),
(1278, 1208, 'DoD Network Information Center', 'mail.mil', 'US', 8192, 'isp', '1991-01-10 00:00:00', 0),
(1279, 12081, 'Greenheck Fan', 'greenheck.com', 'US', 256, 'business', '1999-03-17 00:00:00', 0),
(1280, 12082, 'NWN Corporation', 'nwnit.com', 'US', 1024, 'business', '1999-03-18 00:00:00', 0),
(1281, 12083, 'WideOpenWest Finance LLC', 'wowway.com', 'US', 1163264, 'isp', '1999-03-19 00:00:00', 0),
(1282, 12085, 'Equinix, Inc.', 'equinix.com', 'US', 7168, 'isp', '2012-03-28 00:00:00', 0),
(1283, 12086, 'DT Micro, inc.', 'dtmicro.com', 'US', 55552, 'business', '2011-06-09 00:00:00', 0),
(1284, 12087, 'Salsgiver, Inc.', 'salsgiver.com', 'US', 4352, 'business', '1999-03-19 00:00:00', 0),
(1285, 12088, 'North American Bancard, LLC', 'northamericanbancard.net', 'US', 256, 'business', '2009-10-23 00:00:00', 0),
(1286, 12089, 'Conterra', 'conterra.com', 'US', 2816, 'isp', '2007-04-02 00:00:00', 0),
(1287, 12090, 'AAA National', 'aaa.com', 'US', 11520, 'business', '1999-03-22 00:00:00', 0),
(1288, 12091, 'MTN SA', 'mtn.com', 'ZA', 37632, 'isp', '2010-08-12 00:00:00', 0),
(1289, 12092, 'Sonifi Solutions, Inc.', 'sonifi.com', 'US', 1024, 'business', '1999-03-22 00:00:00', 0),
(1290, 12093, 'University of Waterloo', 'uwaterloo.ca', 'CA', 65792, 'education', '1999-03-22 00:00:00', 0),
(1291, 12094, 'Sister Lakes Cable', 'sisterlakescable.com', 'US', 8448, 'business', '2020-02-04 00:00:00', 0),
(1292, 12095, 'Arizona Science Center', 'azscience.org', 'US', 256, 'business', '2012-07-02 00:00:00', 0),
(1293, 12096, 'AMP Telephones', 'ampnet.net', 'US', 256, 'business', '1999-03-22 00:00:00', 0),
(1294, 12097, 'Massillon Cable Communications', 'sssnet.com', 'US', 58624, 'isp', '1999-03-22 00:00:00', 0),
(1295, 12098, 'Union Bank of California', 'unionbank.com', 'US', 256, 'business', '1999-03-22 00:00:00', 0),
(1296, 121, 'DoD Network Information Center', 'mail.mil', 'US', 9472, 'isp', '1987-08-13 00:00:00', 0),
(1297, 12100, 'Lexicon International Inc', 'lexicon-inc.com', 'US', 768, 'business', '2017-07-11 00:00:00', 0),
(1298, 12101, 'PROGRESS RAIL SERVICES Corporation', 'progressrail.com', 'US', 512, 'business', '2017-10-20 00:00:00', 0),
(1299, 12102, 'City of Portland', 'cityofportlandtn.gov', 'US', 1024, 'business', '2007-05-16 00:00:00', 0),
(1300, 12104, 'State Farm Mutual  Automobile Insurance Company', 'statefarm.com', 'US', 1280, 'business', '2012-09-21 00:00:00', 0),
(1301, 12105, 'DRS Technical Services Inc', 'drs.com', 'US', 2816, 'business', '2007-05-16 00:00:00', 0),
(1302, 12107, 'Dealer Dot Com Inc.', 'dealer.com', 'US', 256, 'business', '2011-02-16 00:00:00', 0),
(1303, 12108, 'PROFIT DEVELOPERS INC', 'profitdevelopers.com', 'US', 1024, 'business', '2007-06-01 00:00:00', 0),
(1304, 12109, 'Technology Investors, Inc.', 'tlo.com', 'US', 768, 'business', '2010-01-12 00:00:00', 0),
(1305, 12110, 'Internex Inc.', 'gitflorida.com', 'US', 2048, 'business', '2010-10-11 00:00:00', 0),
(1306, 12111, 'Visionary Communications, Inc.', 'visioncommunications.com', 'US', 36864, 'isp', '1999-03-26 00:00:00', 0),
(1307, 12112, 'Consolidated Communications, Inc.', 'consolidated.com', 'US', 35840, 'isp', '1999-03-26 00:00:00', 0),
(1308, 12113, 'Dawn Food Products, Inc.', 'dawnfoods.com', 'US', 512, 'business', '2010-07-14 00:00:00', 0),
(1309, 12115, 'Financial Network, Inc.', 'financialnetworkinc.com', 'US', 1280, 'business', '1999-03-26 00:00:00', 0),
(1310, 12116, 'Federal Home Loan Bank of Dallas', 'fhlb.com', 'US', 512, 'business', '1999-03-29 00:00:00', 0),
(1311, 12118, 'West Virginia University', 'wvu.edu', 'US', 90624, 'education', '1999-03-29 00:00:00', 0),
(1312, 12119, 'ITV-3', 'itv-3.com', 'US', 34816, 'isp', '1999-03-29 00:00:00', 0),
(1313, 12120, 'Amphenol Corp', 'amphenol.com', 'US', 512, 'business', '2005-05-10 00:00:00', 0),
(1314, 12121, 'Internet Access Service, Inc.', 'iaservice.net', 'US', 768, 'business', '1999-03-29 00:00:00', 0),
(1315, 12122, 'St. Joseph Health System', 'stjhs.org', 'US', 2304, 'business', '2009-11-23 00:00:00', 0),
(1316, 12125, 'Zebrafish Labs Inc.', 'imgix.com', 'US', 512, 'business', '2014-05-01 00:00:00', 0),
(1317, 12127, 'Telefonica Moviles El Salvador S.A. de C.V.', 'movistar.com.sv', 'SV', 3840, 'isp', '1999-03-30 00:00:00', 0),
(1318, 12128, 'Refinitiv US LLC', 'refinitiv.com', 'US', 512, 'business', '2014-05-02 00:00:00', 0),
(1319, 12129, '123.Net, Inc.', '123.net', 'US', 174848, 'business', '1999-03-30 00:00:00', 0),
(1320, 1213, 'HEAnet', 'heanet.ie', 'IE', 1777920, 'isp', '2002-01-16 14:31:21', 0),
(1321, 12130, 'Bandwidth Inc.', 'bandwidth.com', 'US', 6912, 'business', '2008-03-12 00:00:00', 0),
(1322, 12131, 'Vertical Computers', 'verticalcomputers.com', 'US', 256, 'business', '2018-05-11 00:00:00', 0),
(1323, 12132, 'Quebec Internet Inc', 'quebecinternet.com', 'CA', 12544, 'isp', '2012-07-03 00:00:00', 0),
(1324, 12133, 'LISCO', 'lisco.com', 'US', 24832, 'business', '1999-03-31 00:00:00', 0),
(1325, 12134, 'Manufacturers and Traders Trust Company', 'mtb.com', 'US', 1024, 'business', '1999-03-31 00:00:00', 0),
(1326, 12135, 'Prointernet do Brasil Ltda', 'pib.com.br', 'BR', 4096, 'business', '1999-11-18 00:00:00', 0),
(1327, 12136, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 512, 'business', '1999-11-18 00:00:00', 0),
(1328, 12137, 'LightHouse Business Information Solutions, LLC', 'lhbis.com', 'US', 256, 'business', '2014-10-09 00:00:00', 0),
(1329, 12138, 'Tax AirFreight, Inc.', 'taxair.com', 'US', 256, 'business', '2014-02-19 00:00:00', 0),
(1330, 12139, 'AMNET US LLC', 'millicom.com', 'US', 4096, 'isp', '1999-04-02 00:00:00', 0),
(1331, 12140, 'Lanis Ltda', 'lanis.com', 'BR', 1024, 'business', '1999-11-17 00:00:00', 0),
(1332, 12142, 'SULLCROM', 'sullcrom.com', 'US', 512, 'business', '1999-04-05 00:00:00', 0),
(1333, 12144, 'Cloud Grid Computing', 'cloud-grid.net', 'US', 512, 'business', '2012-07-03 00:00:00', 0),
(1334, 12145, 'Colorado State University', 'colostate.edu', 'US', 81920, 'education', '1999-04-06 00:00:00', 0),
(1335, 12147, 'Discover Financial Services', 'discover.com', 'US', 2560, 'business', '2005-06-10 00:00:00', 0),
(1336, 12148, 'Clemson University', 'clemson.edu', 'US', 98560, 'education', '1999-04-06 00:00:00', 0),
(1337, 1215, 'Oracle Corporation', 'oracle.com', 'US', 16384, 'business', '1991-01-30 00:00:00', 0),
(1338, 12150, 'COTELCAM', 'cotelcam.net.ar', 'AR', 9216, 'isp', '1999-04-06 00:00:00', 0),
(1339, 12151, 'Learning Tree International, Inc.', 'learningtree.com', 'US', 512, 'business', '2006-11-01 00:00:00', 0),
(1340, 12152, 'Ascensus, LLC.', 'ascensus.com', 'US', 2304, 'business', '1999-04-06 00:00:00', 0),
(1341, 12153, 'HBI Branded Apparel Enterprises, LLC', 'myapparelnet.com', 'US', 1536, 'business', '1999-04-06 00:00:00', 0),
(1342, 12154, 'InfoUSA', 'infousa.com', 'US', 11520, 'business', '2000-06-22 00:00:00', 0),
(1343, 12155, 'Henderson Municipal Power & Light', 'hmpl.net', 'US', 2048, 'business', '2007-06-04 00:00:00', 0),
(1344, 12156, 'City of Aurora Colorado', 'auroragov.org', 'US', 768, 'business', '2018-01-24 00:00:00', 0),
(1345, 12157, 'Element Capital Management LLC', 'elementcapital.com', 'US', 512, 'business', '2007-06-04 00:00:00', 0),
(1346, 12158, 'ILLUMINA, INC.', 'illumina.com', 'US', 512, 'business', '2012-07-03 00:00:00', 0),
(1347, 12159, 'Securities America Inc.', 'securitiesamerica.com', 'US', 256, 'business', '1999-04-07 00:00:00', 0),
(1348, 1216, 'Oracle Corporation', 'oracle.com', 'US', 256, 'business', '1991-01-30 00:00:00', 0),
(1349, 12161, 'dao Consulting, LLC', 'daoconsulting.com', 'US', 2560, 'business', '2014-03-04 00:00:00', 0),
(1350, 12162, 'DATA DISTRIBUTORS', 'datadist.com', 'US', 256, 'business', '2005-08-29 00:00:00', 0),
(1351, 12163, 'Amherst Holdings LLC', 'amherst.com', 'US', 512, 'business', '2013-09-18 00:00:00', 0),
(1352, 12165, 'Xactware Information Services Inc.', 'xactware.com', 'US', 1536, 'business', '1999-04-09 00:00:00', 0),
(1353, 12166, 'Other World Computing - OWC', 'owc.net', 'US', 1792, 'business', '1999-04-09 00:00:00', 0),
(1354, 12167, 'LightWave Networks', 'lightwavenetworks.com', 'US', 512, 'business', '2001-05-16 00:00:00', 0),
(1355, 12168, 'The Dana On Mission Bay', 'bartellhotels.com', 'US', 512, 'business', '2018-11-12 00:00:00', 0),
(1356, 12169, 'IBM Business Recovery Service', 'ibm.com', 'US', 9472, 'business', '1999-04-09 00:00:00', 0),
(1357, 1217, 'Oracle Corporation', 'oracle.com', 'US', 1280, 'business', '1991-01-30 00:00:00', 0),
(1358, 12171, 'Fast Enterprises, LLC', 'fastenterprises.com', 'US', 3328, 'business', '2010-08-25 00:00:00', 0),
(1359, 12172, 'FISERV Inc.', 'fiserv.com', 'US', 768, 'business', '2018-06-25 00:00:00', 0),
(1360, 12173, 'The University of Alabama', 'ua.edu', 'US', 65536, 'education', '1999-04-12 00:00:00', 0),
(1361, 12175, 'Yelm Telephone Company', 'fairpoint.com', 'US', 18432, 'isp', '1999-04-12 00:00:00', 0),
(1362, 12176, 'ICAP Services North America LLC', 'icap.com', 'US', 768, 'business', '1999-04-12 00:00:00', 0),
(1363, 12177, 'ETS TELEPHONE COMPANY, INC.', 'entouchsystems.net', 'US', 32256, 'isp', '2005-06-10 00:00:00', 0),
(1364, 12178, 'Internap Holding LLC', 'inap.com', 'US', 24576, 'isp', '1999-04-13 00:00:00', 0),
(1365, 12179, 'Internap Holding LLC', 'inap.com', 'US', 44544, 'isp', '1999-04-13 00:00:00', 0),
(1366, 1218, 'Oracle Corporation', 'oracle.com', 'US', 13568, 'business', '1991-01-30 00:00:00', 0),
(1367, 12180, 'Internap Holding LLC', 'inap.com', 'US', 78080, 'isp', '1999-04-13 00:00:00', 0),
(1368, 12181, 'Internap Holding LLC', 'inap.com', 'US', 35840, 'isp', '1999-04-13 00:00:00', 0),
(1369, 12182, 'Internap Holding LLC', 'inap.com', 'US', 70656, 'isp', '1999-04-13 00:00:00', 0),
(1370, 12183, 'Talkie Communications, Inc', 'talkiefiber.com', 'US', 1536, 'business', '2017-09-21 00:00:00', 0),
(1371, 12184, 'Forrester Research', 'forrester.com', 'US', 1280, 'business', '1999-04-13 00:00:00', 0),
(1372, 12185, 'Thompson, Siegel & Walmsley LLC', 'tswinvest.com', 'US', 768, 'business', '2009-02-03 00:00:00', 0),
(1373, 12186, 'GVVME', 'gvv.me', 'US', 256, 'business', '2018-04-03 00:00:00', 0),
(1374, 12187, 'Metropolitan Tranportation Authority', 'mtahq.org', 'US', 20480, 'business', '1999-04-13 00:00:00', 0),
(1375, 12188, 'Q9 Networks Inc.', 'q9.com', 'CA', 91648, 'business', '2001-12-20 00:00:00', 0),
(1376, 12189, 'PhoenixNAP LLC', 'phoenixnap.com', 'US', 11520, 'isp', '2013-03-07 00:00:00', 0),
(1377, 1219, 'Oracle Corporation', 'oracle.com', 'US', 256, 'business', '1991-01-30 00:00:00', 0),
(1378, 12190, 'OOCL (USA), Inc.', 'oocl.com', 'US', 3072, 'business', '1999-04-19 00:00:00', 0),
(1379, 12191, 'City of Lebanon - Lebanon Utilities', 'lebanon-utilities.com', 'US', 4096, 'business', '1999-04-19 00:00:00', 0),
(1380, 12193, 'IMAGINE COMMUNICATIONS', 'imaginecommunications.com', 'US', 512, 'business', '2018-04-19 00:00:00', 0),
(1381, 12196, 'Etsy Inc.', 'etsy.com', 'US', 512, 'business', '2008-03-31 00:00:00', 0),
(1382, 122, 'UPMC', 'upmc.edu', 'US', 270848, 'education', '1987-08-21 00:00:00', 0),
(1383, 12200, 'Rackspace Hosting', 'rackspace.com', 'US', 512, 'hosting', '2007-05-16 00:00:00', 0),
(1384, 12202, 'PINEHURST SURGICAL CLINIC, P.A', 'pinehurstsurgical.com', 'US', 256, 'business', '2010-12-08 00:00:00', 0),
(1385, 12203, 'Sterling National Bank', 'snb.com', 'US', 1024, 'business', '1999-04-23 00:00:00', 0),
(1386, 12204, 'SCN Research, Inc.', 'scnresearch.com', 'US', 1024, 'business', '1999-04-23 00:00:00', 0),
(1387, 12205, 'Sachem Central School District', 'sachem.edu', 'US', 512, 'education', '2005-03-14 00:00:00', 0),
(1388, 12206, 'DNP Networks', 'dnpnetworks.net', 'PR', 512, 'business', '2010-03-04 00:00:00', 0),
(1389, 12208, 'TruVista Communications', 'truvista.net', 'US', 41984, 'isp', '2008-12-08 00:00:00', 0),
(1390, 12209, 'Girosol, Corp.', 'girosol.com', 'US', 512, 'business', '2008-12-08 00:00:00', 0),
(1391, 1221, 'Telstra Corporation Ltd', 'telstra.com.au', 'AU', 13632256, 'isp', '0000-00-00 00:00:00', 0),
(1392, 12210, 'Community West Bank', 'communitywestbank.com', 'US', 256, 'business', '2005-03-15 00:00:00', 0),
(1393, 12211, 'Operations & Compliance Network LLC', 'nimi.com', 'US', 1280, 'business', '2005-03-16 00:00:00', 0),
(1394, 12212, 'Ravand Cybertech Inc.', 'ravand.com', 'CA', 9216, 'hosting', '2010-08-27 00:00:00', 0),
(1395, 12213, 'Cyxtera Technologies Inc', 'cyxtera.com', 'US', 22016, 'business', '2017-10-20 00:00:00', 0),
(1396, 12214, 'RapidDSL & Wireless', 'rapiddsl.net', 'US', 4096, 'business', '2005-03-16 00:00:00', 0),
(1397, 12216, 'KRAVET INC.', 'kravet.com', 'US', 256, 'business', '2005-03-16 00:00:00', 0),
(1398, 12217, 'UNITED PARCEL SERVICE', 'ups.com', 'US', 72448, 'business', '1999-04-26 00:00:00', 0),
(1399, 12218, 'American Institutes for Research', 'air.org', 'US', 512, 'business', '2007-06-04 00:00:00', 0),
(1400, 12219, 'Miller\'s Supplies at Work', 'millersoffice.com', 'US', 256, 'business', '2007-03-08 00:00:00', 0),
(1401, 1222, 'EL PASO COMMUNITY COLLEGE', 'epcc.edu', 'US', 768, 'education', '1991-02-22 00:00:00', 0),
(1402, 12220, 'I-Evolve Technology Services', 'i-evolve.com', 'US', 2048, 'business', '2008-05-21 00:00:00', 0),
(1403, 12222, 'Akamai Technologies, Inc.', 'akamai.com', 'US', 12800, 'isp', '1999-04-26 00:00:00', 0),
(1404, 12223, 'MNJ Technology Services LLC', 'mnjtech.com', 'US', 5888, 'business', '2007-11-12 00:00:00', 0),
(1405, 12225, 'Consumerinfo.com, Inc.', 'consumerinfo.com', 'US', 1280, 'business', '2005-06-15 00:00:00', 0),
(1406, 12226, 'CIBC World Markets', 'cibc.com', 'US', 65536, 'business', '2020-03-05 00:00:00', 0),
(1407, 12227, 'WBNS TV, Inc.', '10tv.com', 'US', 256, 'business', '2007-05-03 00:00:00', 0),
(1408, 12228, '21ST CENTURY ONCOLOGY, INC.', '21co.com', 'US', 3072, 'business', '2010-06-02 00:00:00', 0),
(1409, 12229, 'SAS Institute, Inc.', 'sas.com', 'US', 68096, 'business', '1999-04-27 00:00:00', 0),
(1410, 12230, 'EDGEWATER NETWORKS, INC', 'edgewaternetworks.com', 'US', 256, 'business', '2017-11-09 00:00:00', 0),
(1411, 12231, 'Conway Corporation', 'conwaycorp.com', 'US', 29696, 'isp', '1999-04-27 00:00:00', 0),
(1412, 12232, 'RoadRunner', 'roadrunnerwireless.net', 'None', 1024, 'business', '2011-07-06 00:00:00', 0),
(1413, 12234, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 20992, 'isp', '1999-04-28 00:00:00', 0),
(1414, 12235, 'SmartEdgeNet LLC', 'smart.it', 'US', 768, 'isp', '2012-09-24 00:00:00', 0),
(1415, 12236, 'Hanover Insurance Group, Inc.', 'hanover.com', 'US', 1024, 'business', '2010-12-08 00:00:00', 0),
(1416, 12237, 'Apptio Inc', 'apptio.com', 'US', 256, 'business', '2011-10-05 00:00:00', 0),
(1417, 12238, 'AECOM', 'aecom.com', 'US', 512, 'business', '1999-04-28 00:00:00', 0),
(1418, 12239, 'Bloomington Public School District No. 87', 'district87.org', 'US', 1536, 'education', '2012-06-11 00:00:00', 0),
(1419, 1224, 'National Center for Supercomputing Applications', 'ncsa.edu', 'US', 65792, 'education', '1991-02-25 00:00:00', 0),
(1420, 12241, 'Nebraska Central Telephone Company', 'nctc.net', 'US', 7936, 'business', '2005-06-10 00:00:00', 0),
(1421, 12242, 'Nodal Exchange, LLC', 'nodalexchange.com', 'US', 768, 'business', '2017-11-09 00:00:00', 0),
(1422, 12243, 'Waddell Solutions Group LLC', 'waddellsolutions.com', 'US', 1536, 'business', '2014-02-24 00:00:00', 0),
(1423, 12244, 'Supreme Security Systems, Inc.', 'supremealarm.com', 'US', 768, 'business', '2007-05-16 00:00:00', 0),
(1424, 12245, 'Peninsula Regional Medical Center', 'peninsula.org', 'US', 768, 'business', '2005-08-09 00:00:00', 0),
(1425, 12246, 'HPM Networks', 'hpmnetworks.com', 'US', 512, 'business', '2011-06-20 00:00:00', 0),
(1426, 12247, 'Tri-Rivers Educational Computer Association', 'treca.org', 'US', 8192, 'education', '2007-04-03 00:00:00', 0),
(1427, 1225, 'NTT America, Inc.', 'ntt.com', 'US', 1024, 'isp', '2000-04-12 00:00:00', 0),
(1428, 12250, 'EDWARD HEALTH SERVICE CORP', 'edward.org', 'US', 768, 'business', '2007-09-25 00:00:00', 0),
(1429, 12252, 'America Movil Peru S.A.C.', 'telmex.com.pe', 'PE', 658944, 'isp', '2000-11-17 00:00:00', 0),
(1430, 12253, 'Leon County Board of County Commisioners', 'leoncountyfl.gov', 'US', 2048, 'business', '2006-08-22 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(1431, 12254, 'Instructure, Inc', 'instructure.com', 'US', 256, 'business', '2012-06-11 00:00:00', 0),
(1432, 12256, 'CityLinq Net Services', 'citylinq.com', 'US', 256, 'business', '1999-05-03 00:00:00', 0),
(1433, 12257, 'EMC Corporation', 'emc.com', 'US', 38656, 'business', '1999-05-03 00:00:00', 0),
(1434, 12258, 'Dimension Data (Pty) Ltd - Optinet', 'optinet.net', 'ZA', 54016, 'isp', '1999-05-03 00:00:00', 0),
(1435, 12259, 'EBOCOM LLC', 'ebocom.net', 'US', 512, 'business', '2005-06-17 00:00:00', 0),
(1436, 1226, 'California Technology Agency', 'ca.gov', 'US', 1104128, 'isp', '1991-02-28 00:00:00', 0),
(1437, 12260, 'Colostore.com', 'colostore.com', 'US', 29952, 'hosting', '1999-05-04 00:00:00', 0),
(1438, 12261, 'DTC Communications, Inc.', 'dtccom.com', 'US', 13824, 'business', '1999-05-04 00:00:00', 0),
(1439, 12263, 'Saint Bernard Hospital', 'stbernardhospital.com', 'US', 256, 'business', '2012-06-05 00:00:00', 0),
(1440, 12265, 'R2G Services LLC', 'r2g.com', 'US', 256, 'business', '1999-05-05 00:00:00', 0),
(1441, 12266, 'StoreRunner, Inc.', 'srnhosting.com', 'US', 4096, 'hosting', '1999-05-06 00:00:00', 0),
(1442, 12268, 'Elizabethtown College', 'etownian.com', 'US', 4096, 'education', '2008-12-29 00:00:00', 0),
(1443, 12269, 'Groupon, Inc.', 'groupon.com', 'US', 3584, 'business', '2012-01-10 00:00:00', 0),
(1444, 12271, 'Charter Communications Inc', 'charter.com', 'US', 3252224, 'isp', '2000-06-09 00:00:00', 0),
(1445, 12272, 'Medata Inc.', 'medata.com', 'US', 1024, 'business', '2011-03-04 00:00:00', 0),
(1446, 12273, 'Transunion Interactive, Inc.', 'transunion.com', 'US', 2048, 'business', '1999-05-07 00:00:00', 0),
(1447, 12274, 'Fujitsu America Inc.', 'fujitsu.com', 'US', 8704, 'business', '1999-05-11 00:00:00', 0),
(1448, 12275, 'Networkfleet, Inc.', 'networkfleet.com', 'US', 1024, 'business', '2008-05-21 00:00:00', 0),
(1449, 12276, 'San Francisco Metropolitan Internet Exchange (SFMIX)', 'sfmix.org', 'US', 256, 'business', '2007-06-04 00:00:00', 0),
(1450, 12278, 'North Carolina 811, INC', 'nc811.org', 'US', 256, 'business', '2006-09-27 00:00:00', 0),
(1451, 12279, 'VertitechIT, Inc.', 'vertitechit.com', 'US', 256, 'business', '2002-01-23 00:00:00', 0),
(1452, 12281, 'ALORICA INC', 'alorica.com', 'US', 768, 'business', '2020-07-22 00:00:00', 0),
(1453, 12282, 'Selectronics Corp.', 'wcvt.com', 'US', 33792, 'isp', '1999-05-11 00:00:00', 0),
(1454, 12283, 'First Technology Services', 'firstts.com', 'US', 256, 'business', '2012-01-10 00:00:00', 0),
(1455, 12285, 'One Eleven Internet Services', 'one-eleven.net', 'US', 7680, 'business', '1999-05-11 00:00:00', 0),
(1456, 12286, 'Princeton Healthcare System', 'princetonhcs.org', 'US', 256, 'business', '2009-10-26 00:00:00', 0),
(1457, 12287, 'Afilias, Inc.', 'afilias.info', 'US', 512, 'business', '2006-10-19 00:00:00', 0),
(1458, 12288, 'Verlag fuer Neue Medien Data Communications GmbH', 'vfnm.de', 'DE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1459, 12289, '\"Svyazekspert\" LLC.', 'tcex.ru', 'RU', 1024, 'business', '2011-10-05 07:19:47', 0),
(1460, 12290, 'Exonetric Consulting Ltd', 'exonetric.com', 'GB', 2048, 'business', '2002-06-11 14:38:35', 0),
(1461, 12291, 'Deutsche Post AG', 'deutschepost.de', 'DE', 393728, 'business', '0000-00-00 00:00:00', 0),
(1462, 12292, 'Transkom GmbH', 'transkom.net', 'DE', 8448, 'business', '0000-00-00 00:00:00', 0),
(1463, 12294, 'PrJSC VF UKRAINE', 'umc.com.ua', 'UA', 73728, 'business', '2002-09-18 16:37:57', 0),
(1464, 12296, 'ADA-NET Internet ve Iletisim Hizmetleri Tic. A.S.', 'ada.net.tr', 'TR', 24576, 'business', '0000-00-00 00:00:00', 0),
(1465, 12297, 'VEON Armenia CJSC', 'beeline.am', 'AM', 188416, 'isp', '2001-11-30 08:28:51', 0),
(1466, 12298, 'QIAGEN GmbH', 'qiagen.com', 'DE', 512, 'business', '2011-05-02 09:16:21', 0),
(1467, 12301, 'Invitech ICT Services Kft.', 'invitech.hu', 'HU', 389632, 'isp', '2002-09-11 14:07:50', 0),
(1468, 12302, 'Vodafone Romania S.A.', 'vodafone.ro', 'RO', 269824, 'isp', '2002-09-05 13:16:54', 0),
(1469, 12303, 'Council of Hungarian Internet Providers', 'iszt.hu', 'HU', 2816, 'business', '2005-06-14 09:03:41', 0),
(1470, 12305, 'G9Telecom S.A.', 'g9telecom.pt', 'PT', 24576, 'isp', '2002-07-05 17:59:22', 0),
(1471, 12306, 'Plus.line AG', 'plusline.net', 'DE', 43264, 'isp', '2002-08-21 15:41:57', 0),
(1472, 12307, 'Sandro Bolliger trading as Bolliger Network Solutions', 'ravana.me', 'CH', 512, 'business', '2015-09-30 09:37:59', 0),
(1473, 12309, 'Nouvelle S.r.l', 'nouvelle.it', 'IT', 8192, 'business', '2002-09-19 20:01:10', 0),
(1474, 12310, 'iNES GROUP SRL', 'ines.ro', 'RO', 62976, 'isp', '2002-06-06 07:33:11', 0),
(1475, 12311, 'International Atomic Energy Agency', 'iaea.org', 'AT', 65536, 'business', '0000-00-00 00:00:00', 0),
(1476, 12312, 'ecotel communication ag', 'ecotel.de', 'DE', 1056000, 'isp', '2002-09-18 14:13:02', 0),
(1477, 12314, 'RopNet', 'ropnet.ru', 'RU', 8192, 'business', '2002-03-05 16:26:30', 0),
(1478, 12315, 'Quality Service Provider BV', 'qsp.nl', 'NL', 10240, 'isp', '2001-11-08 10:42:11', 0),
(1479, 12316, 'Finanz Informatik Technologie Service GmbH & Co. KG', 'f-i-ts.net', 'DE', 10240, 'business', '0000-00-00 00:00:00', 0),
(1480, 12318, 'EXANE SA', 'exane.com', 'FR', 256, 'business', '2002-08-09 06:16:52', 0),
(1481, 12319, 'IZFE SA', 'gipuzkoa.net', 'ES', 8192, 'business', '2004-02-16 11:59:32', 0),
(1482, 12321, 'XTRA TELECOM S.A.', 'ibercomtelecom.es', 'ES', 32768, 'business', '2002-03-19 08:53:28', 0),
(1483, 12322, 'Free SAS', 'free.fr', 'FR', 11116544, 'isp', '2002-07-20 01:42:03', 0),
(1484, 12324, 'Maria Curie-Sklodowska University', 'umcs.pl', 'PL', 65536, 'education', '2002-05-06 15:18:09', 0),
(1485, 12325, 'IPv4 Management SRL', 'ip.ro', 'RO', 4864, 'isp', '2009-07-29 12:48:56', 0),
(1486, 12328, '\"Alan Systems\" Sp. z o. o.', 'alan-systems.com', 'PL', 512, 'business', '2011-06-15 07:34:04', 0),
(1487, 12329, 'Telekommunikation Mittleres Ruhrgebiet GmbH', 'tmr.net', 'DE', 17664, 'isp', '2002-08-11 22:00:52', 0),
(1488, 12330, 'MPY Telecom Oyj', 'mpy.fi', 'FI', 3072, 'isp', '0000-00-00 00:00:00', 0),
(1489, 12331, 'Audi AG', 'audi.com', 'DE', 65536, 'business', '2002-01-02 13:01:21', 0),
(1490, 12332, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 303104, 'isp', '2002-08-29 06:01:05', 0),
(1491, 12333, 'DFI Service SA', 'dfi.ch', 'CH', 10752, 'isp', '2002-09-20 08:18:10', 0),
(1492, 12334, 'R Cable y Telecable Telecomunicaciones, S.A.U.', 'telecable.es', 'ES', 451584, 'isp', '2002-06-18 08:24:00', 0),
(1493, 12335, 'Tario Communications LLC', 'tario.ru', 'RU', 8192, 'business', '0000-00-00 00:00:00', 0),
(1494, 12337, 'noris network AG', 'noris.net', 'DE', 95488, 'isp', '2002-09-03 13:23:54', 0),
(1495, 12338, 'Euskaltel S.A.', 'euskaltel.com', 'ES', 571392, 'isp', '2002-07-17 13:28:49', 0),
(1496, 1234, 'Fortum', 'fortum.com', 'EU', 133120, 'business', '2002-07-01 06:59:10', 0),
(1497, 12341, 'Ural State Polzunov College', 'ural.ru', 'RU', 256, 'isp', '2009-07-29 12:54:33', 0),
(1498, 12342, 'Brack.ch AG', 'brack.ch', 'CH', 256, 'business', '2009-08-19 13:46:20', 0),
(1499, 12344, 'CZECH IT CLUSTER, druzstvo', 'czech-itc.cz', 'CZ', 1024, 'business', '2015-09-30 09:15:41', 0),
(1500, 12345, 'General Software s.r.l.', 'gensoft.it', 'IT', 8192, 'business', '2019-01-02 09:55:51', 0),
(1501, 12346, 'Maria Curie-Sklodowska University', 'umcs.pl', 'PL', 16640, 'education', '2002-05-06 15:18:09', 0),
(1502, 12347, 'Virtualtec Solutions AG', 'virtualtec.ch', 'CH', 2048, 'business', '2002-09-04 12:25:29', 0),
(1503, 12348, 'ODN OnlineDienst Nordbayern GmbH & Co. KG', 'odn.de', 'DE', 17152, 'business', '0000-00-00 00:00:00', 0),
(1504, 12349, 'Bayer', 'bayer.com', 'DE', 2048, 'business', '0000-00-00 00:00:00', 0),
(1505, 12350, 'VTX Services SA', 'vtx.ch', 'CH', 406272, 'isp', '2002-09-11 06:46:08', 0),
(1506, 12353, 'Vodafone Portugal - Communicacoes Pessoais S.A.', 'vodafone.com', 'PT', 1207296, 'isp', '2002-05-23 19:36:29', 0),
(1507, 12355, 'HeLi NET Telekommunication GmbH & Co.', 'helinet.de', 'DE', 66560, 'isp', '2002-01-04 13:33:44', 0),
(1508, 12356, 'UNIVERSITATEA ROMANO-AMERICANA', 'rau.ro', 'RO', 512, 'education', '2009-01-14 11:53:46', 0),
(1509, 12357, 'VODAFONE ESPANA S.A.U.', 'vodafone.es', 'ES', 1320960, 'isp', '2002-08-22 11:56:08', 0),
(1510, 1236, 'General Dynamics C4 Systems, Inc.', 'gdc4s.com', 'US', 6912, 'business', '1991-03-13 00:00:00', 0),
(1511, 12360, 'KEVAG Telekom GmbH', 'kevag-telekom.de', 'DE', 40192, 'isp', '2002-08-21 08:30:55', 0),
(1512, 12361, 'VODAFONE-PANAFON HELLENIC TELECOMMUNICATIONS COMPANY SA', 'vodafone.com', 'GR', 91904, 'isp', '2011-12-09 13:26:59', 0),
(1513, 12362, 'NETPLUSCOM Legacy', 'netplus.fr', 'FR', 8192, 'business', '2002-06-12 14:21:45', 0),
(1514, 12363, 'REGISTER S.P.A.', 'dada.eu', 'IT', 768, 'hosting', '2002-02-20 10:19:27', 0),
(1515, 12364, 'University of Macedonia, Economic and Social Sciences', 'uom.gr', 'GR', 5120, 'education', '0000-00-00 00:00:00', 0),
(1516, 12365, 'JC LLC Sarkor-Telecom', 'sarkor.uz', 'UZ', 32256, 'isp', '2002-10-21 08:16:58', 0),
(1517, 1237, 'KISTI', 'kisti.re.kr', 'KR', 328192, 'isp', '0000-00-00 00:00:00', 0),
(1518, 12371, 'Avency GmbH', 'avency.de', 'DE', 24576, 'business', '2001-12-13 14:52:38', 0),
(1519, 12372, 'Cubic Telecom Limited', 'cubictelecom.com', 'IE', 1024, 'business', '2015-09-30 08:02:59', 0),
(1520, 12374, 'LF.net Netzwerksysteme GmbH', 'lf.net', 'DE', 34048, 'business', '2002-09-05 15:04:27', 0),
(1521, 12379, 'ip4 GmbH', 'ip4-gmbh.de', 'DE', 9216, 'business', '0000-00-00 00:00:00', 0),
(1522, 12380, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 18432, 'isp', '0000-00-00 00:00:00', 0),
(1523, 12381, 'Resilans AB', 'resilans.se', 'SE', 2304, 'business', '2002-06-28 06:51:17', 0),
(1524, 12384, 'Swedish University of Agricultural Sciences', 'slu.se', 'SE', 9216, 'education', '2002-05-24 09:57:36', 0),
(1525, 12386, 'Orange Espagne SA', 'orange.com', 'ES', 30208, 'isp', '0000-00-00 00:00:00', 0),
(1526, 12387, 'TON Total optical Networks AG', 'ton-net.com', 'CH', 8192, 'business', '0000-00-00 00:00:00', 0),
(1527, 12388, 'Casey CableVision Ltd.', 'cablesurf.com', 'IE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1528, 12389, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 9319424, 'isp', '2005-07-01 14:26:50', 0),
(1529, 1239, 'Sprint', 'sprint.net', 'US', 17175296, 'business', '1991-03-25 00:00:00', 0),
(1530, 12390, 'KCOM GROUP LIMITED', 'kcom.com', 'GB', 262144, 'isp', '2002-09-12 06:35:59', 0),
(1531, 12392, 'Brutele SC', 'brutele.be', 'BE', 422912, 'isp', '2002-04-02 10:10:21', 0),
(1532, 12395, 'ADISTA SAS', 'adista.fr', 'FR', 256, 'hosting', '2002-07-16 15:22:16', 0),
(1533, 12396, 'PJSC MegaFon', 'megafon.ru', 'RU', 4864, 'isp', '2002-03-07 07:11:27', 0),
(1534, 12397, 'Optocom Ltd', 'None', 'UA', 1024, 'hosting', '2011-10-20 10:47:39', 0),
(1535, 12399, 'ScanPlus GmbH', 'scanplus.de', 'DE', 42496, 'isp', '2002-05-08 15:55:13', 0),
(1536, 12400, 'Partner Communications Ltd.', 'orange.co.il', 'IL', 717568, 'isp', '0000-00-00 00:00:00', 0),
(1537, 12401, 'internic Datenkommunikations GmbH', 'internic.at', 'AT', 8448, 'business', '0000-00-00 00:00:00', 0),
(1538, 12402, 'University of Piraeus', 'unipi.gr', 'GR', 4608, 'education', '0000-00-00 00:00:00', 0),
(1539, 12404, 'Saarbrucker Zeitung Verlag und Druckerei GmbH', 'sz-sb.de', 'DE', 8192, 'business', '2002-06-26 13:50:14', 0),
(1540, 12405, 'OJSC Russian Railways', 'rzd.ru', 'RU', 256, 'business', '2015-09-30 06:35:00', 0),
(1541, 12406, 'Business Network Ltd', 'bn.by', 'BY', 20480, 'hosting', '2002-01-09 15:10:53', 0),
(1542, 12408, 'LLC Bi-Kent', 'None', 'RU', 256, 'hosting', '2003-12-09 12:25:34', 0),
(1543, 12409, 'H.R.Net SARL', 'hrnet.fr', 'FR', 8192, 'isp', '2002-09-06 06:30:30', 0),
(1544, 1241, 'Forthnet', 'forthnet.gr', 'GR', 610304, 'isp', '2002-05-29 11:40:34', 0),
(1545, 12413, 'Handshake e.V.', 'handshake.de', 'DE', 256, 'business', '0000-00-00 00:00:00', 0),
(1546, 12414, 'Solcon Internetdiensten B.V.', 'solcon.nl', 'NL', 154112, 'isp', '0000-00-00 00:00:00', 0),
(1547, 12415, 'Weblink Telecom Ltd', 'weblink.ie', 'NL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1548, 12418, 'Quantum CJSC', 'ptl.ru', 'RU', 69120, 'isp', '2002-02-16 11:23:19', 0),
(1549, 12422, 'Evonik Industries AG', 'evonik.de', 'DE', 73728, 'business', '2002-04-11 08:27:51', 0),
(1550, 12423, 'Nicolaus Copernicus University in Torun', 'torun.pl', 'PL', 32768, 'education', '0000-00-00 00:00:00', 0),
(1551, 12426, 'Slovanet a.s.', 'slovanet.net', 'SK', 6144, 'isp', '2002-01-30 17:17:07', 0),
(1552, 12427, 'Indeks PK Ltd.', 'customscard.ru', 'RU', 256, 'business', '2015-09-29 15:07:02', 0),
(1553, 12428, 'UniCredit Business Integrated Solutions S.C.p.A.', 'unicredit.eu', 'IT', 4608, 'business', '0000-00-00 00:00:00', 0),
(1554, 12430, 'VODAFONE ESPANA S.A.U.', 'vodafone.es', 'ES', 3791872, 'isp', '0000-00-00 00:00:00', 0),
(1555, 12431, 'SYBCOM GmbH', 'sybcom.de', 'DE', 9472, 'business', '0000-00-00 00:00:00', 0),
(1556, 12436, 'Bergon Internet Ltd.', 'bergon.net', 'BG', 10240, 'isp', '2009-09-17 15:00:19', 0),
(1557, 12437, 'DTS Systeme Muenster GmbH', 'icsmedia.de', 'DE', 8192, 'business', '2002-05-06 14:30:23', 0),
(1558, 12438, 'Enterpreneur Oshitjer Igor Anatolievich', 'sunline.com.ua', 'UA', 2048, 'isp', '2010-09-09 14:39:08', 0),
(1559, 12439, 'Impromex S.R.L.', 'impromex.ro', 'RO', 768, 'business', '0000-00-00 00:00:00', 0),
(1560, 12440, 'Hughes Network Systems GmbH', 'hughes.com', 'DE', 41984, 'isp', '2002-07-16 15:25:04', 0),
(1561, 12441, 'Cyren Inc', 'eleven.de', 'DE', 1024, 'business', '2002-07-14 09:58:15', 0),
(1562, 12442, 'PRO TV S.A.', 'protv.ro', 'RO', 2560, 'business', '0000-00-00 00:00:00', 0),
(1563, 12443, 'Riga Domes Technology Center', 'riga.lv', 'LV', 1024, 'isp', '0000-00-00 00:00:00', 0),
(1564, 12444, 'TELNET TELEKOM HIZMETLERI ANONIM SIRKETI', 'telnet.it', 'TR', 1536, 'business', '2002-10-23 16:00:18', 0),
(1565, 12445, 'A2A Smart City S.P.A', 'selenebs.it', 'IT', 26624, 'isp', '2001-12-19 18:20:46', 0),
(1566, 12446, 'MX1 C.E.E SA', 'ess.ro', 'RO', 768, 'business', '0000-00-00 00:00:00', 0),
(1567, 12447, 'Ernst Klingler Kabelfernsehen Gmbh', 'kabeline.at', 'AT', 3072, 'isp', '2010-01-05 12:14:38', 0),
(1568, 12450, '\"Agentia Transcor\" SRL', 'transcor.md', 'RO', 1024, 'business', '2008-08-13 07:31:57', 0),
(1569, 12453, 'Bernhard Kraft', 'kraftcom.at', 'AT', 7168, 'isp', '2011-03-31 07:27:07', 0),
(1570, 12455, 'Kenyan Post & Telecommunications Company / Telkom Kenya Ltd', 'telkom.co.ke', 'KE', 303104, 'isp', '2006-10-17 00:00:00', 0),
(1571, 12456, 'KL Group LLC', 'klgroup.com', 'RU', 256, 'business', '2010-07-21 11:11:55', 0),
(1572, 12459, 'UNITED INTERNET LTD.', 'united.rs', 'RS', 768, 'business', '2015-09-29 09:53:27', 0),
(1573, 1246, 'Zito Media', 'zitomedia.com', 'US', 48896, 'isp', '2009-07-23 00:00:00', 0),
(1574, 12460, 'Mandala Internet EDV Service GmbH', 'mandala.de', 'DE', 7936, 'isp', '0000-00-00 00:00:00', 0),
(1575, 12463, 'S.A. des Bains de Mer et du Cercle des Etrangers a Monaco', 'sbm.mc', 'FR', 256, 'business', '0000-00-00 00:00:00', 0),
(1576, 12464, 'Politechnika Warszawska', 'pw.edu.pl', 'PL', 13312, 'education', '0000-00-00 00:00:00', 0),
(1577, 12465, 'Banca IMI S.p.A.', 'bancaimi.com', 'IT', 4096, 'business', '2010-05-12 11:54:11', 0),
(1578, 12466, 'Bicos Computer GmbH', 'bicos.de', 'DE', 5376, 'business', '2002-08-12 15:26:14', 0),
(1579, 12468, 'Abaco Informatica S.r.l.', 'abanet.it', 'IT', 8192, 'business', '0000-00-00 00:00:00', 0),
(1580, 12470, 'Globe Development GmbH', 'globe.de', 'DE', 8448, 'business', '2002-07-02 10:00:57', 0),
(1581, 12472, 'Waycom International (SASU)', 'waycom.net', 'LU', 1280, 'isp', '2002-06-14 21:36:08', 0),
(1582, 12479, 'Orange Espagne SA', 'orange.es', 'ES', 6765312, 'isp', '2002-09-02 14:00:50', 0),
(1583, 1248, 'HERE Global BV', 'here.com', 'NL', 40960, 'isp', '0000-00-00 00:00:00', 0),
(1584, 12480, 'ILK Internet.Gmbh', 'ilk.net', 'DE', 12032, 'business', '2002-09-19 15:20:00', 0),
(1585, 12481, 'Trivenet S.R.L.', 'trivenet.it', 'IT', 12288, 'isp', '0000-00-00 00:00:00', 0),
(1586, 12483, 'Den Danske Bank A/S', 'danskebank.dk', 'DK', 9728, 'business', '0000-00-00 00:00:00', 0),
(1587, 12484, 'Boris Ltd.', 'borisk.biz', 'RU', 4096, 'business', '2011-03-23 08:44:21', 0),
(1588, 12486, 'TeleYemen', 'teleyemen.com.ye', 'YE', 8192, 'isp', '0000-00-00 00:00:00', 0),
(1589, 12488, 'Krystal Hosting Ltd', 'krystal.co.uk', 'GB', 8704, 'hosting', '2007-04-10 08:34:13', 0),
(1590, 1249, 'Five Colleges Network', 'umass.edu', 'US', 82432, 'education', '1991-04-18 00:00:00', 0),
(1591, 12491, 'Gilat Satcom', 'gilatsatcom.com', 'IL', 88832, 'isp', '2001-12-31 13:09:01', 0),
(1592, 12494, 'OOO \"Post ltd\"', 'kmv.ru', 'RU', 33792, 'isp', '2002-11-04 11:13:17', 0),
(1593, 12496, 'Infinity Developments Limited', 'idnet.net', 'GB', 20480, 'isp', '2002-08-23 10:18:41', 0),
(1594, 12498, 'FinecoBank SpA', 'finecobank.com', 'IT', 512, 'business', '2002-06-03 09:31:21', 0),
(1595, 125, 'Honeywell International, Inc.', 'honeywell.com', 'US', 19200, 'business', '1987-08-28 00:00:00', 0),
(1596, 12500, 'JSC \"Ruscentrosvyaz\"', 'rclink.ru', 'RU', 1536, 'business', '0000-00-00 00:00:00', 0),
(1597, 12501, 'UMDAC, Umea University', 'umu.se', 'SE', 122880, 'education', '2002-09-02 08:27:19', 0),
(1598, 12502, 'Dr.-Ing. Nepustil & Co. GmbH Internet Service Center Ingenieurgesellschaft fuer Systemsoftware und Kommunikationstechnik', 'nepustil.net', 'DE', 9728, 'isp', '0000-00-00 00:00:00', 0),
(1599, 12505, 'Banco BPM S.P.A', 'bancobpmspa.it', 'IT', 2048, 'business', '0000-00-00 00:00:00', 0),
(1600, 12507, 'Swift Trace ltd.', 'strace.net', 'RU', 4096, 'business', '2003-01-17 05:53:22', 0),
(1601, 12508, 'Rainside s.r.o.', 'rainside.sk', 'SK', 8704, 'isp', '2002-05-15 08:43:35', 0),
(1602, 12509, 'LATVIJAS BANKA', 'bank.lv', 'LV', 512, 'business', '0000-00-00 00:00:00', 0),
(1603, 1251, 'FUNDAÇÃO DE AMPARO À PESQUISA DO ESTADO SÃO PAULO', 'ansp.br', 'BR', 167424, 'business', '1999-11-12 00:00:00', 0),
(1604, 12510, 'SAP SE', 'sap.com', 'DE', 54784, 'business', '2002-02-26 11:10:00', 0),
(1605, 12511, 'Die Schweizerische Post AG', 'post.ch', 'CH', 165888, 'business', '0000-00-00 00:00:00', 0),
(1606, 12512, 'CBXNET combox internet GmbH', 'cbxnet.de', 'DE', 16384, 'business', '2002-08-16 13:52:58', 0),
(1607, 12513, 'KCOM GROUP LIMITED', 'kcom.com', 'GB', 216064, 'isp', '2002-09-25 13:16:10', 0),
(1608, 12515, 'RSAdvSys', 'rsadvnet.it', 'IT', 8192, 'business', '0000-00-00 00:00:00', 0),
(1609, 12516, 'WEBORAMA SA', 'weborama.com', 'FR', 512, 'business', '0000-00-00 00:00:00', 0),
(1610, 12517, 'LAN-WAN I.T LTD', 'lan-wan.net', 'IL', 1024, 'business', '2015-09-28 12:19:01', 0),
(1611, 12519, 'FastNet International Ltd', 'fastnet.co.uk', 'GB', 28672, 'isp', '2002-06-12 14:03:11', 0),
(1612, 1252, 'University of Nebraska Medical Center', 'unmc.edu', 'US', 139008, 'education', '1991-04-12 00:00:00', 0),
(1613, 12521, 'Nova Internet S.L.', 'nova.es', 'ES', 11264, 'business', '0000-00-00 00:00:00', 0),
(1614, 12523, 'Visable S.A.', 'europages.fr', 'FR', 256, 'business', '0000-00-00 00:00:00', 0),
(1615, 12525, 'INTERNET Ltd.', 'internet.lv', 'LV', 1024, 'business', '0000-00-00 00:00:00', 0),
(1616, 12527, 'Millennium BCP-Prestacao de Servicos ACE', 'millenniumbcp.pt', 'PT', 256, 'business', '0000-00-00 00:00:00', 0),
(1617, 12529, 'Sale For Distribution & Communication Co. Ltd', 'sale-co.com', 'SA', 512, 'business', '2009-07-29 14:39:38', 0),
(1618, 12530, 'Kyivstar PJSC', 'kyivstar.ua', 'UA', 212992, 'isp', '2002-09-24 06:07:19', 0),
(1619, 12531, 'WLW', 'wlw.de', 'DE', 1536, 'business', '0000-00-00 00:00:00', 0),
(1620, 12533, 'RMnet S.R.L.', 'rmnet.it', 'IT', 8448, 'business', '2002-08-21 12:31:16', 0),
(1621, 12536, 'IX Reach Ltd', 'ixreach.com', 'GB', 8448, 'business', '2002-09-02 10:56:44', 0),
(1622, 12539, 'Penki Kontinentai, Ltd.', 'penki.lt', 'LT', 4096, 'isp', '2002-04-13 11:07:12', 0),
(1623, 1254, 'National Aeronautics and Space Administration', 'nasa.gov', 'US', 131584, 'business', '1991-04-24 00:00:00', 0),
(1624, 12540, 'IdecNet S.A.', 'idecnet.com', 'ES', 8192, 'isp', '2002-08-27 11:47:08', 0),
(1625, 12541, 'EVOLUTIO CLOUD ENABLER S.A. UNIPERSONAL', 'evolutio.com', 'ES', 166912, 'isp', '2002-09-06 13:25:00', 0),
(1626, 12543, 'PJSC Vimpelcom', 'beeline.ru', 'RU', 17408, 'isp', '0000-00-00 00:00:00', 0),
(1627, 12545, 'Transcom Ltd', 'xcm.org', 'UA', 4096, 'isp', '2002-01-18 11:35:18', 0),
(1628, 12546, 'Kleemann GmbH', 'kleemann-gmbh.com', 'DE', 1024, 'business', '2015-09-28 10:06:10', 0),
(1629, 12548, 'Viaduk-Telecom, Inc.', 'viaduk.net', 'UA', 1024, 'business', '2002-02-15 14:57:47', 0),
(1630, 12551, 'ENEL S.p.A', 'enel.com', 'IT', 131072, 'business', '0000-00-00 00:00:00', 0),
(1631, 12552, 'IP-Only Networks AB', 'ip-only.net', 'SE', 420352, 'hosting', '2002-01-29 10:36:15', 0),
(1632, 12553, 'Andreas Grawehr', 'as12553.net', 'CH', 256, 'business', '2010-01-05 16:36:05', 0),
(1633, 12555, 'Data-center IMAQLIQ Ltd.', 'iqdata.center', 'RU', 7168, 'business', '2008-05-02 06:52:30', 0),
(1634, 12556, 'Internet Solutions (Kenya)', 'is.co.ke', 'KE', 16640, 'isp', '2009-01-15 00:00:00', 0),
(1635, 12557, 'SimpleThings GmbH', 'simplethings.de', 'DE', 1024, 'business', '2015-09-25 16:26:01', 0),
(1636, 12559, 'BCC SISTEMI INFORMATICI S.P.A.', 'bcc.it', 'IT', 4096, 'business', '0000-00-00 00:00:00', 0),
(1637, 1256, 'Massachusetts Education Computer Network', 'umassp.edu', 'US', 66048, 'education', '1991-04-26 00:00:00', 0),
(1638, 12561, 'IX Networks B.V.', 'ixnetworks.nl', 'NL', 2048, 'business', '2011-04-19 06:16:36', 0),
(1639, 12564, 'Council of Ministers', 'government.bg', 'BG', 9216, 'isp', '0000-00-00 00:00:00', 0),
(1640, 12565, 'Groupe LDLC', 'groupe-ldlc.com', 'FR', 1024, 'business', '2008-12-29 06:59:24', 0),
(1641, 12566, 'SFR SA', 'sfr.fr', 'FR', 18944, 'isp', '2002-06-11 11:10:51', 0),
(1642, 12567, 'GAIJIN NETWORK LTD', 'gaijin.net', 'RU', 256, 'business', '2015-09-25 16:23:18', 0),
(1643, 12569, 'Instrumentacion y Componentes, SA', 'inycom.es', 'ES', 8192, 'business', '0000-00-00 00:00:00', 0),
(1644, 1257, 'TELE2', 'tele2.se', 'SE', 4846080, 'isp', '2002-09-19 15:18:13', 0),
(1645, 12570, 'itself s.r.o.', 'itself.cz', 'CZ', 57856, 'isp', '2002-05-27 13:11:15', 0),
(1646, 12571, 'INCAS GmbH', 'incas.de', 'DE', 9216, 'business', '0000-00-00 00:00:00', 0),
(1647, 12574, 'Hosting.de GmbH', 'hosting.de', 'DE', 9216, 'hosting', '2002-07-22 09:54:22', 0),
(1648, 12576, 'EE Limited', 'ee.co.uk', 'GB', 6842112, 'isp', '2002-09-05 10:57:10', 0),
(1649, 12577, 'mmc kommunikationstechnologie gmbh', 'mmc.at', 'AT', 14592, 'isp', '0000-00-00 00:00:00', 0),
(1650, 12578, 'SIA Tet', 'tet.lv', 'LV', 499712, 'isp', '0000-00-00 00:00:00', 0),
(1651, 12579, 'Xenologics Networks & Communications GmbH', 'xnc.com', 'DE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1652, 1258, 'XKL, LLC', 'xkl.com', 'US', 256, 'business', '1991-05-03 00:00:00', 0),
(1653, 12580, 'Euvic Solutions S.A.', 'omnitec.pl', 'PL', 3584, 'business', '0000-00-00 00:00:00', 0),
(1654, 12581, 'tops.net GmbH & Co. KG', 'tops.net', 'DE', 12288, 'isp', '2002-03-26 10:13:21', 0),
(1655, 12582, 'Telia Finland Oyj', 'telia.fi', 'FI', 9216, 'isp', '2001-11-05 14:59:33', 0),
(1656, 12583, 'Stanley UK Services Ltd', 'stanleyworks.com', 'GB', 256, 'business', '2010-05-03 14:52:54', 0),
(1657, 12586, 'GHOSTnet GmbH', 'ghostnet.de', 'DE', 278528, 'hosting', '2002-06-04 08:46:38', 0),
(1658, 12587, 'Aizkraukles Banka AS', 'ab.lv', 'LT', 256, 'business', '0000-00-00 00:00:00', 0),
(1659, 12589, 'Magyar Posta Zrt', 'posta.hu', 'HU', 256, 'business', '0000-00-00 00:00:00', 0),
(1660, 12590, 'THE DOT SPOT NET SARL', 'None', 'LB', 1024, 'hosting', '2015-09-24 13:25:30', 0),
(1661, 12591, 'Smartcom Bulgaria AD', 'smartcom.bg', 'BG', 512, 'business', '0000-00-00 00:00:00', 0),
(1662, 12592, 'Trans Tel Services SRL', 'tts.ro', 'RO', 512, 'business', '2002-10-03 10:42:54', 0),
(1663, 12593, 'Ukrcom Ltd', 'ukrcom.net', 'UA', 12288, 'isp', '2002-07-10 10:41:40', 0),
(1664, 12594, 'Comnica Kft.', 'uhusystems.com', 'HU', 12544, 'business', '2002-01-30 17:13:40', 0),
(1665, 12597, 'Gotalandsnatet AB', 'gotanet.se', 'SE', 16896, 'isp', '2002-08-07 11:45:25', 0),
(1666, 12598, 'Verlagsgruppe Milchstrasse GmbH', 'hubert-burda-media.de', 'DE', 512, 'business', '2002-06-25 10:47:12', 0),
(1667, 12599, 'ATLAS ON-LINE', 'atlas.net.tr', 'TR', 2816, 'business', '2001-10-11 08:24:32', 0),
(1668, 12601, 'Cegedim.Cloud SASU', 'cegedim.fr', 'FR', 7680, 'business', '0000-00-00 00:00:00', 0),
(1669, 12605, 'LIWEST Kabelmedien GmbH', 'liwest.at', 'AT', 156672, 'isp', '2002-08-05 10:04:55', 0),
(1670, 12607, 'Digital Bros. S.p.A.', 'digitalbros.com', 'IT', 2048, 'business', '2002-03-22 16:08:50', 0),
(1671, 12608, 'NTX Technologies s.r.o.', 'ntx.ru', 'RU', 256, 'hosting', '2011-03-31 10:01:27', 0),
(1672, 1261, 'National Instruments Corporation', 'ni.com', 'US', 32768, 'business', '1991-06-17 00:00:00', 0),
(1673, 12610, 'Rockenstein AG', 'rockenstein.de', 'DE', 2048, 'isp', '2002-07-04 23:09:04', 0),
(1674, 12611, 'R-KOM Regensburger Telekommunikationsverwaltungsgesellschaft mbH trading as R-KOM Telekommunikationsgesellschaft mbH & Co. KG', 'r-kom.de', 'DE', 58880, 'isp', '2002-09-25 09:01:22', 0),
(1675, 12613, 'Firebrick Limited', 'firebrick.net', 'GB', 256, 'business', '2003-11-21 13:34:14', 0),
(1676, 12615, 'Global Communication Net Plc', 'gcn.bg', 'BG', 100096, 'isp', '2004-04-21 09:50:37', 0),
(1677, 12616, 'Filanco LLC', 'filanco.ru', 'RU', 3328, 'hosting', '2006-04-03 10:31:37', 0),
(1678, 12617, 'Sentia Denmark A/S', 'sentia.dk', 'DK', 9216, 'isp', '2009-07-29 15:00:33', 0),
(1679, 12618, 'University of Technology and Life Sciences Bydgoszcz', 'man.bydgoszcz.pl', 'PL', 39424, 'education', '2001-11-08 18:31:15', 0),
(1680, 12619, 'Yediot Information Technologies ltd', 'yit.co.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1681, 12620, 'Ticinocom SA', 'ticino.com', 'CH', 50688, 'isp', '0000-00-00 00:00:00', 0),
(1682, 12625, 'Deutsche Boerse AG', 'deutsche-boerse.com', 'DE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1683, 12626, 'SFR SA', 'sfr.fr', 'FR', 123648, 'isp', '2002-07-03 16:01:51', 0),
(1684, 12628, 'JACO ENGELBRECHT', 'networkgods.net', 'GB', 512, 'business', '2001-12-19 17:05:05', 0),
(1685, 12629, 'Option Service SAS', 'option-service.fr', 'FR', 5376, 'isp', '0000-00-00 00:00:00', 0),
(1686, 12630, 'Otaverkko Oy', 'otaverkko.fi', 'FI', 9216, 'business', '0000-00-00 00:00:00', 0),
(1687, 12632, 'RCS & RDS SA', 'rcs-rds.ro', 'RO', 2560, 'isp', '2002-05-20 10:45:13', 0),
(1688, 12635, 'Hutchison Drei Austria GmbH', 'drei.at', 'AT', 8192, 'isp', '0000-00-00 00:00:00', 0),
(1689, 12637, 'SEEWEB s.r.l.', 'seeweb.it', 'IT', 97536, 'hosting', '2002-09-18 17:28:36', 0),
(1690, 12638, 'Telefonica Germany GmbH & Co.OHG', 'telefonica.de', 'DE', 574464, 'isp', '0000-00-00 00:00:00', 0),
(1691, 12639, 'MARKASON LTD', 'modnakasta.ua', 'UA', 768, 'business', '2011-09-21 09:36:53', 0),
(1692, 12643, 'Fraunhofer-Gesellschaft zur Foerderung der angewandten Forschung e.V.', 'fraunhofer.de', 'DE', 70144, 'business', '2002-03-13 13:27:47', 0),
(1693, 12645, 'Cap\'Mediatel SARL', 'capmedia.fr', 'FR', 1536, 'business', '0000-00-00 00:00:00', 0),
(1694, 12649, 'Banque Pictet & Cie SA', 'group.pictet', 'CH', 1024, 'business', '0000-00-00 00:00:00', 0),
(1695, 1265, 'Saint Mary\'s College', 'saintmarys.edu', 'US', 65536, 'education', '1991-06-27 00:00:00', 0),
(1696, 12650, 'Il Sole 24 Ore SpA', 'ilsole24ore.com', 'IT', 2048, 'business', '0000-00-00 00:00:00', 0),
(1697, 12651, 'IP worldcom SA', 'worldcom.ch', 'CH', 32768, 'isp', '2002-04-09 14:03:50', 0),
(1698, 12653, 'KB Impuls Hellas S.A.', 'kbihellas.com', 'GR', 14336, 'business', '0000-00-00 00:00:00', 0),
(1699, 12654, 'Reseaux IP Europeens Network Coordination Centre (RIPE NCC)', 'ripe.net', 'EU', 7168, 'business', '0000-00-00 00:00:00', 0),
(1700, 12655, 'Telefonbuch Verlag Hans Mueller GmbH & Co. KG', 'muellerverlag.de', 'DE', 1280, 'business', '0000-00-00 00:00:00', 0),
(1701, 12657, 'BayCIX GmbH', 'baycix.de', 'DE', 24576, 'business', '2002-07-23 10:35:22', 0),
(1702, 12658, 'Dexterity Networks Limited', 'dx.net', 'GB', 8704, 'isp', '2009-01-12 08:27:16', 0),
(1703, 12659, 'European Backbone Networks Inc.', 'bbnetworks.net', 'FI', 8192, 'business', '0000-00-00 00:00:00', 0),
(1704, 12660, 'Sharif University Of Technology', 'sharif.ir', 'IR', 25088, 'education', '2002-08-16 19:31:26', 0),
(1705, 12662, 'FOP Petrushenko Sergiy Petrovich', 'nemicom.ua', 'UA', 1024, 'isp', '2011-03-31 10:18:05', 0),
(1706, 12663, 'Vodafone Italia S.p.A.', 'vodafone.it', 'IT', 577536, 'isp', '0000-00-00 00:00:00', 0),
(1707, 12664, 'BNP PARIBAS S.A.', 'bnpparibas.com', 'DE', 256, 'business', '2002-04-05 10:23:57', 0),
(1708, 12665, 'MSH Medien System Haus GmbH & Co. KG', 'msh.de', 'DE', 8704, 'business', '2002-07-24 13:17:12', 0),
(1709, 12666, 'InterXion Headquarters B.V.', 'interxion.com', 'EU', 256, 'business', '2002-08-16 11:46:40', 0),
(1710, 12668, 'LLC KomTehCentr', 'itmh.ru', 'RU', 152576, 'isp', '0000-00-00 00:00:00', 0),
(1711, 1267, 'WIND TRE S.P.A.', 'wind.it', 'IT', 6102784, 'isp', '2002-09-19 13:11:07', 0),
(1712, 12670, 'COMPLETEL SAS', 'completel.fr', 'FR', 668416, 'isp', '2002-09-13 08:27:12', 0),
(1713, 12672, 'Ringier Print SRL', 'ringier.ro', 'RO', 1280, 'business', '0000-00-00 00:00:00', 0),
(1714, 12675, 'Alexandru Ioan Cuza University', 'uaic.ro', 'RO', 5120, 'education', '0000-00-00 00:00:00', 0),
(1715, 12676, 'HKN GmbH', 'hkn.de', 'DE', 62208, 'business', '2002-08-30 18:02:47', 0),
(1716, 12678, 'Greysom Limited', 'monopost.com', 'GB', 5120, 'business', '2011-06-15 08:58:32', 0),
(1717, 12679, 'Iceberg Telecom Ltd.', 'mol.ru', 'RU', 15872, 'business', '0000-00-00 00:00:00', 0),
(1718, 12680, 'Gruner+Jahr GmbH', 'guj.de', 'DE', 24576, 'business', '2002-08-27 08:20:54', 0),
(1719, 12683, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 198656, 'isp', '0000-00-00 00:00:00', 0),
(1720, 12684, 'SES ASTRA S.A.', 'onastra.fr', 'LU', 253696, 'isp', '2002-07-11 12:37:13', 0),
(1721, 12685, 'Sibitex Ltd', 'com.ru', 'RU', 8192, 'isp', '2002-04-24 05:32:36', 0),
(1722, 12686, 'Open Joint Stock Commercial Bank Rosbank (OJSC)', 'fronttel.ru', 'RU', 512, 'business', '0000-00-00 00:00:00', 0),
(1723, 12687, 'Association of users of Ukrainian Research & Academic Network URAN', 'uran.ua', 'UA', 7168, 'education', '0000-00-00 00:00:00', 0),
(1724, 12688, 'Joint Stock Company TransTeleCom', 'transtelecom-nn.ru', 'RU', 35840, 'isp', '2011-03-23 09:54:11', 0),
(1725, 12690, 'International Communications Company LLC', 'csi.ru', 'RU', 7424, 'business', '2002-08-30 13:00:00', 0),
(1726, 12693, 'e.discom Telekommunikation GmbH', 'ediscom.de', 'DE', 56320, 'isp', '2002-08-29 09:15:22', 0),
(1727, 12695, 'LLC Digital Network', 'di-net.ru', 'RU', 180992, 'isp', '2002-08-06 10:41:40', 0),
(1728, 12696, 'GIE AXA Technology Services France', 'axa.com', 'FR', 23808, 'business', '0000-00-00 00:00:00', 0),
(1729, 12697, 'Tose Masiryabi Shabake Aria PJSC', 'nrd.ir', 'IR', 256, 'business', '2015-09-24 09:01:01', 0),
(1730, 127, 'Jet Propulsion Laboratory', 'caltech.edu', 'US', 275200, 'education', '1987-09-16 00:00:00', 0),
(1731, 1270, 'UUNET Germany', 'None', 'EU', 1024, 'isp', '2002-09-20 11:12:08', 0),
(1732, 12700, 'Komertsiyno Virobnitcha Firma \"VEKTOR\"', 'sc.net.ua', 'UA', 3072, 'isp', '2008-03-13 09:45:00', 0),
(1733, 12701, 'Barclays Bank plc', 'barclays.co.uk', 'GB', 67584, 'business', '0000-00-00 00:00:00', 0),
(1734, 12703, 'Pulsant (Scotland) Ltd', 'lumison.net', 'GB', 81152, 'hosting', '2002-09-19 15:10:07', 0),
(1735, 12706, 'Public JSC First Ukrainian International Bank', 'fuib.com', 'UA', 256, 'business', '0000-00-00 00:00:00', 0),
(1736, 12708, 'TalkTalk Communications Limited', 'talktalkplc.com', 'GB', 279552, 'isp', '2002-02-26 12:51:51', 0),
(1737, 12709, 'Melita Limited', 'melita.com', 'MT', 288000, 'isp', '2002-09-10 11:50:59', 0),
(1738, 12713, 'OTEGlobe - OTE Global Solutions SA', 'oteglobe.gr', 'GR', 4096, 'isp', '2002-06-26 19:07:53', 0),
(1739, 12714, 'Net By Net Holding LLC', 'netbynet.ru', 'RU', 1206016, 'isp', '2002-07-18 12:38:14', 0),
(1740, 12715, 'Orange Espagne SA', 'orange.es', 'ES', 6768640, 'isp', '2002-08-26 12:56:45', 0),
(1741, 12716, 'A1 Bulgaria EAD', 'a1.bg', 'BG', 512, 'isp', '2002-08-19 13:06:34', 0),
(1742, 12722, 'RECONN LLC', 'reconn.ru', 'RU', 63232, 'isp', '2011-02-14 11:14:43', 0),
(1743, 12724, 'Prokhorov General Physics Institute, Russian Academy of Sciences, RAS (GPI)', 'gpi.ru', 'RU', 12288, 'education', '2002-09-13 14:58:06', 0),
(1744, 12726, 'Lufthansa Airplus Servicekarten GmbH', 'airplus.com', 'DE', 512, 'business', '2002-05-21 15:26:55', 0),
(1745, 12727, 'VIALIS SAEM', 'vialis.net', 'FR', 13312, 'isp', '2002-08-14 12:47:17', 0),
(1746, 12729, 'HSBC BANK ANONIM SIRKETI', 'hsbc.com.tr', 'TR', 8192, 'business', '2002-06-18 14:47:15', 0),
(1747, 1273, 'Vodafone Group PLC', 'vodafone.com', 'EU', 1338880, 'isp', '2002-09-23 11:29:14', 0),
(1748, 12730, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 49152, 'isp', '2002-09-25 10:52:01', 0),
(1749, 12731, 'IPHH Internet Port Hamburg GmbH', 'iphh.net', 'DE', 19456, 'business', '2002-09-20 09:02:34', 0),
(1750, 12732, 'GutCon GmbH', 'gutcon.eu', 'DE', 1792, 'business', '2002-07-24 00:39:28', 0),
(1751, 12734, 'Fiat Information Technology, Excellence and Methods S.p.A.', 'fiat.com', 'IT', 4096, 'business', '0000-00-00 00:00:00', 0),
(1752, 12735, 'TurkNet Iletisim Hizmetleri A.S.', 'turk.net', 'TR', 144384, 'isp', '2002-05-30 13:30:48', 0),
(1753, 12736, 'Israel Airports Authority', 'iaa.gov.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1754, 12737, 'KrasPromStroy, LLC', 'rightside.ru', 'RU', 9984, 'isp', '2015-09-23 14:04:20', 0),
(1755, 12739, 'CJSC Netline', 'netline.ru', 'RU', 10240, 'isp', '0000-00-00 00:00:00', 0),
(1756, 12740, 'Nasdaq Technology AB', 'nasdaq.com', 'GB', 256, 'business', '0000-00-00 00:00:00', 0),
(1757, 12741, 'Netia SA', 'netia.pl', 'PL', 1651968, 'isp', '2002-09-05 10:09:06', 0),
(1758, 12743, 'Orange Polska Spolka Akcyjna', 'orange.com', 'PL', 4352, 'isp', '0000-00-00 00:00:00', 0),
(1759, 12748, 'IAV GmbH Ingenieurgesellschaft Auto und Verkehr', 'iav.de', 'DE', 1536, 'business', '2009-12-17 15:40:43', 0),
(1760, 12750, 'Softec AG', 'softec.ch', 'CH', 8192, 'business', '0000-00-00 00:00:00', 0),
(1761, 12753, 'Teva Pharmaceutical Industries Limited', 'teva.co.il', 'IL', 768, 'business', '2002-05-31 04:46:14', 0),
(1762, 12754, 'Coolnet New Communication Provider', 'coolnet.ps', 'PS', 32768, 'isp', '2009-11-11 13:37:06', 0),
(1763, 12756, 'INFOCOM Plc.', 'infocom.bg', 'BG', 256, 'business', '2006-09-07 08:57:29', 0),
(1764, 12757, 'IPTRON.NET OU', 'iptron.net', 'EE', 2816, 'business', '0000-00-00 00:00:00', 0),
(1765, 12759, 'SOCO SoftCom Datensysteme', 'soco.net', 'DE', 25600, 'isp', '2002-09-18 20:55:06', 0),
(1766, 12761, 'COLT Technology Services Group Limited', 'colt.net', 'IT', 1024, 'isp', '2002-01-22 14:10:32', 0),
(1767, 12762, 'Vorarlberger Informatik- und Telekommunikationsdienstleistungsgesellschaft mbH', 'vorarlberg.at', 'AT', 13312, 'business', '0000-00-00 00:00:00', 0),
(1768, 12763, 'Honda Europe NV', 'hondaeurope.be', 'BE', 512, 'business', '0000-00-00 00:00:00', 0),
(1769, 12764, 'AKNET Ltd.', 'aknet.kg', 'KG', 11264, 'isp', '0000-00-00 00:00:00', 0),
(1770, 12765, 'Total S.A.', 'total.com', 'FR', 65792, 'business', '0000-00-00 00:00:00', 0),
(1771, 12766, 'MAGNA STEYR Fahrzeugtechnik AG und Co KG', 'magnasteyr.com', 'AT', 5120, 'business', '0000-00-00 00:00:00', 0),
(1772, 12767, 'T-Mobile Czech Republic a.s.', 't-mobile.cz', 'CZ', 67584, 'isp', '2002-09-24 12:26:58', 0),
(1773, 12768, 'JSC ER-Telecom Holding', 'ertelecom.ru', 'RU', 152064, 'isp', '0000-00-00 00:00:00', 0),
(1774, 1277, 'vXchnge Operating, LLC', 'vxchnge.com', 'US', 768, 'business', '2009-07-24 00:00:00', 0),
(1775, 12770, 'Pacific National University, Public Institution', 'khb.ru', 'RU', 1280, 'education', '0000-00-00 00:00:00', 0),
(1776, 12771, 'MEDIAMETRIE S.A.', 'mediametrie.com', 'FR', 512, 'business', '0000-00-00 00:00:00', 0),
(1777, 12772, 'JSC ER-Telecom Holding', 'ertelecom.ru', 'RU', 122880, 'isp', '2005-07-07 09:53:40', 0),
(1778, 12773, 'Meshnet ltd.', 'meshnet.su', 'UA', 2048, 'business', '2002-09-30 08:13:28', 0),
(1779, 12774, 'Wydawnictwo Naukowe PWN SA', 'pwn.pl', 'PL', 512, 'business', '2008-04-08 11:10:53', 0),
(1780, 12775, 'JPC Infonet Ltd', 'jpci.net', 'GB', 11264, 'business', '0000-00-00 00:00:00', 0),
(1781, 12776, 'Bank Vontobel AG', 'vontobel.com', 'CH', 512, 'business', '2002-02-19 09:05:31', 0),
(1782, 12777, 'Eser Telekom', 'esertelekom.com', 'TR', 2304, 'business', '0000-00-00 00:00:00', 0),
(1783, 12778, 'SGN d.o.o.', 'sgn.net', 'SI', 16384, 'isp', '2002-07-02 10:56:49', 0),
(1784, 12779, 'IT.Gate S.p.A.', 'itgate.it', 'IT', 52736, 'business', '2002-09-17 13:41:17', 0),
(1785, 12782, 'Uppsala Lans Landsting', 'regionuppsala.se', 'SE', 11264, 'business', '0000-00-00 00:00:00', 0),
(1786, 12783, 'ENET Shpk', 'enet.al', 'AL', 2048, 'isp', '2009-09-17 15:10:25', 0),
(1787, 12785, 'ZVD Zavod za varstvo pri delu d.d.', 'zvd.si', 'SI', 256, 'business', '2011-09-28 07:40:55', 0),
(1788, 12786, 'Hattrick Limited', 'hattrick.org', 'CH', 512, 'business', '2006-11-07 09:57:08', 0),
(1789, 12788, 'NBI INTERNET LLC', 'nbi.kyiv.ua', 'UA', 8192, 'isp', '2002-07-12 10:21:43', 0),
(1790, 12789, 'DMG Media Limited', 'dmgmedia.co.uk', 'GB', 3840, 'business', '0000-00-00 00:00:00', 0),
(1791, 12790, 'MSN Telecom LLC', 'mcntelecom.com', 'RU', 512, 'business', '0000-00-00 00:00:00', 0),
(1792, 12792, 'Netassist Limited', 'netassist.ua', 'UA', 1792, 'isp', '2002-09-25 12:29:08', 0),
(1793, 12793, 'A1 Telekom Austria AG', 'a1.net', 'AT', 73984, 'isp', '2002-08-22 09:38:07', 0),
(1794, 12794, 'AKBANK TAS', 'akbank.com', 'TR', 4096, 'business', '0000-00-00 00:00:00', 0),
(1795, 12795, 'Central Cooperative Bank PLC', 'ccbank.bg', 'BG', 512, 'business', '2004-02-04 15:12:37', 0),
(1796, 12796, 'Telecommunication Company Varna EAD', 'tcv.bg', 'BG', 11776, 'business', '2008-08-26 13:50:41', 0),
(1797, 12797, 'BT Italia S.p.A.', 'bt.com', 'IT', 98816, 'isp', '2002-09-13 13:09:01', 0),
(1798, 12798, 'Betvictor Limited', 'betvictor.com', 'GI', 7424, 'isp', '0000-00-00 00:00:00', 0),
(1799, 1280, 'Internet Systems Consortium, Inc.', 'isc.org', 'US', 31488, 'business', '1991-07-31 00:00:00', 0),
(1800, 12801, 'Texas Instruments Deutschland GmbH', 'ti.com', 'DE', 768, 'business', '0000-00-00 00:00:00', 0),
(1801, 12802, 'Migdal Insurance Company Ltd.', 'migdal-group.co.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1802, 12803, 'TELECOM GROUP LLC', 'telecom-group.net', 'UA', 512, 'business', '2009-12-04 15:49:52', 0),
(1803, 12804, 'Adisam Telecom S.A.', 'adisam.ro', 'RO', 1280, 'business', '0000-00-00 00:00:00', 0),
(1804, 12807, 'Orange Business Services SA', 'orange-business.com', 'FR', 3584, 'isp', '0000-00-00 00:00:00', 0),
(1805, 12808, 'dtms GmbH', 'dtms.de', 'DE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1806, 12810, 'A1 Hrvatska d.o.o.', 'a1.hr', 'HR', 132864, 'isp', '2002-03-13 13:23:11', 0),
(1807, 12811, 'GIE Auchan International Technology', 'auchan.com', 'FR', 1024, 'business', '0000-00-00 00:00:00', 0),
(1808, 12812, 'AMERICAN UNIVERSITY of BEIRUT', 'aub.edu.lb', 'LB', 2048, 'education', '0000-00-00 00:00:00', 0),
(1809, 12813, 'WorNet AG', 'wor.net', 'DE', 8192, 'business', '2002-04-16 06:28:10', 0),
(1810, 12815, 'Musala Soft Ltd', 'musala.com', 'BG', 256, 'business', '2004-11-02 13:17:16', 0),
(1811, 12816, 'Leibniz-Rechenzentrum', 'lrz.de', 'DE', 395008, 'isp', '2002-10-21 12:08:09', 0),
(1812, 12817, 'GeFoekoM e.V.', 'gefoekom.net', 'DE', 512, 'business', '2002-04-19 13:02:35', 0),
(1813, 12822, 'LYNET Kommunikation AG', 'lynet.de', 'DE', 6144, 'business', '2001-11-15 16:27:36', 0),
(1814, 12823, 'UMKA d.o.o', 'kappastar.com', 'RS', 256, 'business', '2012-01-12 08:15:11', 0),
(1815, 12824, 'home.pl S.A.', 'home.pl', 'PL', 204800, 'hosting', '2002-02-22 12:33:57', 0),
(1816, 12826, 'Conseils et Systemes Informatiques', 'conse.it', 'FR', 6656, 'business', '2002-02-27 16:00:26', 0),
(1817, 12827, 'Wirtualna Polska Media S.A.', 'wp.pl', 'PL', 3072, 'business', '0000-00-00 00:00:00', 0),
(1818, 12828, 'Institution of the Russian Science Academy Institute of Computational Modeling of Siberian RAN Department', 'krasn.ru', 'RU', 1024, 'education', '0000-00-00 00:00:00', 0),
(1819, 12829, 'Angelsoft ET', 'filibe.net', 'BG', 26624, 'isp', '2001-12-27 11:27:39', 0),
(1820, 12830, 'InfraNet AG', 'infra.net', 'DE', 10240, 'business', '2002-07-19 13:15:29', 0),
(1821, 12831, 'Technical University of Gdansk, Academic Computer Center TASK', 'gda.pl', 'PL', 18944, 'education', '0000-00-00 00:00:00', 0),
(1822, 12833, 'Fundacao para a Ciencia e a Tecnologia, I.P.', 'gigapix.pt', 'PT', 512, 'business', '0000-00-00 00:00:00', 0),
(1823, 12834, 'Danfoss A/S', 'danfoss.com', 'DK', 256, 'business', '0000-00-00 00:00:00', 0),
(1824, 12835, 'Trentino Digitale SPA', 'trentinodigitale.it', 'IT', 11520, 'isp', '0000-00-00 00:00:00', 0),
(1825, 12836, 'POISK-TELECOM LLC', 'poisk-telecom.ru', 'RU', 3072, 'business', '2009-01-15 09:12:00', 0),
(1826, 12840, 'ATP', 'atp.com', 'TR', 8192, 'business', '0000-00-00 00:00:00', 0),
(1827, 12841, 'Veltrade LLC', 'veltrade.ru', 'RU', 256, 'business', '2015-09-23 12:17:38', 0),
(1828, 12842, 'Internet Oltenia SRL', 'oltenia.ro', 'RO', 4096, 'isp', '0000-00-00 00:00:00', 0),
(1829, 12843, 'TelemaxX Telekommunikation GmbH', 'telemaxx.de', 'DE', 126208, 'isp', '2002-09-09 13:21:01', 0),
(1830, 12846, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 24576, 'isp', '0000-00-00 00:00:00', 0),
(1831, 12847, 'Latvijas Mobilais Telefons SIA', 'lmt.lv', 'LV', 8192, 'isp', '2002-08-16 12:28:36', 0),
(1832, 12849, 'Hot-Net internet services Ltd.', 'hotnet.net.il', 'IL', 417792, 'isp', '2009-05-12 08:21:43', 0),
(1833, 12850, 'IRIDEOS S.P.A.', 'irideos.it', 'IT', 37888, 'isp', '0000-00-00 00:00:00', 0),
(1834, 12853, 'InfraServ Gendorf', 'gendorf.de', 'DE', 11264, 'business', '2002-02-25 13:51:19', 0),
(1835, 12859, 'BIT BV', 'bit.nl', 'NL', 66048, 'hosting', '2002-09-19 06:04:26', 0),
(1836, 1286, 'Altay Corporation', 'altayusa.com', 'US', 3840, 'business', '2009-07-24 00:00:00', 0),
(1837, 12861, 'Vestel Elektronik Sanayi ve Ticaret A.S.', 'vestelyatirimciiliskileri.com', 'TR', 1536, 'business', '0000-00-00 00:00:00', 0),
(1838, 1287, 'Professional Education Institute', 'thepei.com', 'US', 256, 'education', '2009-07-24 00:00:00', 0),
(1839, 12871, 'KPN B.V.', 'kpn.com', 'NL', 133120, 'isp', '2002-05-28 15:40:00', 0),
(1840, 12872, 'ISP Fregat Ltd.', 'fregat.net', 'UA', 17408, 'isp', '2002-08-29 07:41:53', 0),
(1841, 12874, 'Fastweb SpA', 'fastweb.it', 'IT', 3659264, 'isp', '2002-09-13 16:27:20', 0),
(1842, 12876, 'ONLINE S.A.S.', 'online.net', 'FR', 458752, 'hosting', '2002-05-27 13:11:32', 0),
(1843, 12878, 'COLT Technology Services Group Limited', 'colt.net', 'AT', 2048, 'isp', '2002-08-05 08:47:20', 0),
(1844, 12880, 'Information Technology Company (ITC)', 'ito.gov.ir', 'IR', 1916416, 'isp', '0000-00-00 00:00:00', 0),
(1845, 12883, 'PRIVATE JOINT-STOCK COMPANY FARLEP-INVEST', 'farlep.net', 'UA', 38400, 'isp', '2002-08-14 07:56:52', 0),
(1846, 12884, 'DRW Investments (UK) Limited', 'drw.com', 'GB', 256, 'business', '2009-01-15 11:17:03', 0),
(1847, 12886, 'LEW TelNet GmbH', 'lewtelnet.de', 'DE', 35840, 'isp', '2002-09-10 11:50:17', 0),
(1848, 12888, 'Amadeus Data Processing GmbH', 'amadeus.com', 'DE', 21760, 'business', '0000-00-00 00:00:00', 0),
(1849, 1289, 'Colgate University', 'colgate.edu', 'US', 65536, 'education', '2009-07-24 00:00:00', 0),
(1850, 12891, 'Genel Kurmay Baskanligi', 'ttnet.net.tr', 'TR', 1792, 'business', '0000-00-00 00:00:00', 0),
(1851, 12895, 's IT Solutions AT Spardat GmbH', 's-itsolutions.at', 'AT', 8192, 'business', '0000-00-00 00:00:00', 0),
(1852, 12897, 'ENTEGA Medianet GmbH', 'entega-medianet.de', 'DE', 135680, 'isp', '2002-09-20 13:12:19', 0),
(1853, 12898, 'PSV Digital GmbH', 'psv-digital.de', 'DE', 4096, 'business', '0000-00-00 00:00:00', 0),
(1854, 1290, 'Telstra Europe Ltd', 'telstra.net', 'EU', 307456, 'isp', '2002-06-26 15:10:28', 0),
(1855, 12902, 'Luna.nl B.V.', 'luna.nl', 'NL', 10240, 'business', '2002-09-23 20:39:10', 0),
(1856, 12903, 'Garanti Bilisim Teknolojisi ve Ticaret T.A.S.', 'garantiteknoloji.com.tr', 'TR', 5632, 'business', '0000-00-00 00:00:00', 0),
(1857, 12905, 'ACS spol. s r. o.', 'acs.sk', 'SK', 9472, 'isp', '0000-00-00 00:00:00', 0),
(1858, 12906, 'Deltatre S.p.A.', 'deltatre.com', 'IT', 2048, 'business', '2009-07-30 08:23:27', 0),
(1859, 12907, 'ip&more GmbH', 'ipandmore.de', 'DE', 16384, 'business', '2002-09-24 17:40:46', 0),
(1860, 12908, 'Sabanci University', 'sabanciuniv.edu', 'TR', 8704, 'education', '2002-08-05 11:21:40', 0),
(1861, 12912, 'T-Mobile Polska S.A.', 't-mobile.pl', 'PL', 679936, 'isp', '2002-07-16 05:13:27', 0),
(1862, 12915, 'EPAG Domainservices GmbH', 'epag.de', 'DE', 8192, 'business', '2002-07-19 10:37:33', 0),
(1863, 12917, 'GlobalLogic s.r.o.', 'globallogic.com', 'SK', 256, 'business', '2015-09-23 11:58:17', 0),
(1864, 12922, 'CEDACRI S.P.A.', 'cedacri.it', 'IT', 256, 'business', '2002-06-05 18:16:25', 0),
(1865, 12923, 'Wizard Computersysteme GmbH', 'wizard.de', 'DE', 12288, 'isp', '2002-10-17 12:43:03', 0),
(1866, 12924, 'Nethits Telecom Solutions S.L.', 'nethitshospitality.com', 'ES', 5120, 'business', '0000-00-00 00:00:00', 0),
(1867, 12925, 'SINP MSU', 'msu.ru', 'RU', 8192, 'education', '0000-00-00 00:00:00', 0),
(1868, 12926, 'AR TELECOM - Acessos e Redes de Telecomunicacoes, S.A.', 'artelecom.pt', 'PT', 75008, 'isp', '0000-00-00 00:00:00', 0),
(1869, 12928, 'BANQUE CANTONALE VAUDOISE ENTERPRISE DROIT PUBLIC', 'bcv.ch', 'CH', 65536, 'business', '2002-08-07 12:26:09', 0),
(1870, 12929, 'Telia Norge AS', 'telia.net', 'NO', 286720, 'isp', '2002-07-01 12:04:35', 0),
(1871, 1293, 'Hewlett-Packard Company', 'hp.com', 'US', 25856, 'business', '1991-05-24 00:00:00', 0),
(1872, 12930, 'card complete Service Bank AG', 'cardcomplete.com', 'AT', 3072, 'business', '2011-10-06 10:01:33', 0),
(1873, 12931, 'IDKOM Networks GmbH', 'idkom.de', 'DE', 12288, 'isp', '2001-12-10 10:38:13', 0),
(1874, 12933, 'Private joint-stock company (PrJSC) DORIS', 'doris.ua', 'UA', 256, 'isp', '2002-02-23 00:17:09', 0),
(1875, 12935, 'QD Sverige AB', 'qd.se', 'SE', 9728, 'business', '2002-08-09 10:45:13', 0),
(1876, 12938, 'Shemyakin-Ovchinnikov Institute of Bioorganic Chemistry Russian Academy of Sciences', 'ibch.ru', 'RU', 512, 'education', '2015-09-23 07:30:43', 0),
(1877, 12939, 'Hanse Holding AB', 'hanse.com', 'SE', 512, 'business', '2003-01-31 15:54:31', 0),
(1878, 1294, 'NTT DATA Services Holdings Corporation', 'nttdata.com', 'US', 82944, 'business', '1991-05-24 00:00:00', 0),
(1879, 12941, 'intersaar GmbH', 'intersaar.de', 'DE', 11776, 'isp', '2001-10-20 21:31:20', 0),
(1880, 12942, 'Network Research Belgium', 'nrb.be', 'BE', 16384, 'business', '0000-00-00 00:00:00', 0),
(1881, 12945, 'Gamepoint B.V.', 'gamepoint.net', 'NL', 512, 'business', '2002-07-16 21:22:51', 0),
(1882, 12946, 'R Cable y Telecable Telecomunicaciones, S.A.U.', 'telecable.es', 'ES', 246784, 'isp', '2003-03-20 14:09:32', 0),
(1883, 12952, 'Knowledge Path for Information Technology and General Trading Ltd', 'know-path.com', 'IQ', 1280, 'isp', '2015-09-22 12:31:26', 0),
(1884, 12954, 'SIA S.p.A.', 'sia.eu', 'IT', 2304, 'business', '0000-00-00 00:00:00', 0),
(1885, 12956, 'Telefonica International Wholesale Services II, S.L.U.', 'telefonica.com', 'ES', 180480, 'isp', '2002-09-24 17:21:02', 0),
(1886, 12958, 'T2 Mobile LLC', 'tele2.ru', 'RU', 228096, 'isp', '2002-08-06 13:40:42', 0),
(1887, 12962, 'First Investment Bank AD', 'fibank.bg', 'BG', 512, 'business', '0000-00-00 00:00:00', 0),
(1888, 12963, 'Scientific -Industrial Firm \"Volz\" Ltd', 'volz.ua', 'UA', 19456, 'isp', '2002-03-14 12:09:39', 0),
(1889, 12964, 'Dr. Buelow & Masiak GmbH', 'buelow-masiak.de', 'DE', 6144, 'business', '2002-06-05 08:07:17', 0),
(1890, 12965, 'AS \"SEB banka\"', 'seb.lv', 'LV', 512, 'business', '0000-00-00 00:00:00', 0),
(1891, 12966, 'Polskie Linie Lotnicze LOT S.A.', 'lot.com', 'PL', 2048, 'business', '0000-00-00 00:00:00', 0),
(1892, 12967, 'AT&T Global Network Services Nederland B.V.', 'att.com', 'GB', 256, 'isp', '2001-11-21 10:05:24', 0),
(1893, 12969, 'Fjarskipti ehf', 'vodafone.is', 'IS', 330240, 'isp', '2002-09-13 16:21:04', 0),
(1894, 12971, 'Internet Viennaweb Service GmbH', 'viennaweb.at', 'AT', 8448, 'business', '2002-04-09 16:30:21', 0),
(1895, 12975, 'Palestine Telecommunications Company (PALTEL)', 'paltel.net', 'PS', 267520, 'isp', '2002-08-19 13:53:51', 0),
(1896, 12976, 'CITIC Telecom CPC Rus LLC', 'citictel-cpc.com', 'RU', 16384, 'isp', '2002-09-24 14:12:08', 0),
(1897, 12978, 'DEMIROREN TV DIGITAL PLATFORM ISLETMECILIGI A.S.', 'dsmart.com.tr', 'TR', 410112, 'isp', '2001-11-22 07:37:34', 0),
(1898, 12979, 'JSC Transinfoset', 'tsi.ru', 'RU', 8192, 'business', '2002-08-08 14:10:57', 0),
(1899, 12980, 'AT&T Global Network Services Nederland B.V.', 'att.com', 'EU', 32768, 'isp', '2002-06-28 12:09:42', 0),
(1900, 12982, 'Bulinfo Ltd', 'bulinfo.net', 'BG', 512, 'business', '0000-00-00 00:00:00', 0),
(1901, 12984, 'PilsFree, z. s.', 'pilsfree.net', 'CZ', 1024, 'business', '2015-09-22 09:39:46', 0),
(1902, 12985, 'TVK WSM - Wielunska Spoldzielnia Mieszkaniowa w Wieluniu', 'wsm.wielun.pl', 'PL', 2304, 'isp', '2011-03-31 10:54:35', 0),
(1903, 12986, 'Ukrspetskom LLC.', 'e.ua', 'UA', 512, 'business', '2002-01-29 16:11:28', 0),
(1904, 12988, 'The Phoenix Insurance Company Ltd', 'phoenix.co.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1905, 12989, 'StackPath LLC', 'stackpath.com', 'NL', 132096, 'isp', '2003-05-12 13:21:02', 0),
(1906, 1299, 'Telia Company AB', 'teliacompany.com', 'EU', 269056, 'isp', '2002-09-19 08:19:14', 0),
(1907, 12990, 'Ringier Axel Springer Polska Sp. z o.o.', 'ringieraxelspringer.pl', 'PL', 9216, 'business', '2002-02-04 13:10:16', 0),
(1908, 12991, 'Amt der OOe Landesregierung', 'ooe.gv.at', 'AT', 10240, 'business', '2002-06-10 14:26:40', 0),
(1909, 12992, 'Proszynski Media sp. z o.o.', 'proszynskimedia.pl', 'PL', 256, 'business', '0000-00-00 00:00:00', 0),
(1910, 12993, 'SIA Digitalas Ekonomikas Attistibas Centrs', 'deac.eu', 'LV', 29952, 'hosting', '2002-07-05 07:33:54', 0),
(1911, 12996, 'Domeneshop AS', 'domeneshop.no', 'NO', 5888, 'business', '2002-09-09 21:41:27', 0),
(1912, 12997, 'OJSC Kyrgyztelecom', 'kt.kg', 'KG', 82944, 'isp', '2002-07-19 06:31:18', 0),
(1913, 12998, 'BGNet LLC', 'bg.net.ua', 'UA', 3584, 'isp', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(1914, 12999, 'State Educational institution for High professional education \'Far Eastern State University\'', 'dvgu.ru', 'RU', 256, 'education', '0000-00-00 00:00:00', 0),
(1915, 13, 'Headquarters, USAISC', 'mail.mil', 'US', 132352, 'isp', '1984-07-16 00:00:00', 0),
(1916, 13000, 'Leon Sp. z o.o.', 'leon.pl', 'PL', 51968, 'business', '2005-12-08 09:54:41', 0),
(1917, 13001, 'A B 2 R SARL', 'systemanetwork.com', 'FR', 2304, 'business', '2006-09-14 08:39:51', 0),
(1918, 13002, 'ISIX Communications LLP', 'i6c.co.uk', 'GB', 8192, 'business', '2001-12-05 12:41:58', 0),
(1919, 13003, 'Webmatic Kommunikations GmbH', 'webmatic.de', 'DE', 17408, 'business', '2002-01-14 07:31:37', 0),
(1920, 13004, 'Serbian Open Exchange DOO', 'sox.rs', 'RS', 768, 'business', '2010-02-26 17:02:35', 0),
(1921, 13005, 'Atlas Business Group of Companies Ltd', 'atlasbusiness.com', 'GB', 12288, 'business', '2002-09-18 12:25:16', 0),
(1922, 13006, 'DID Logic Limited', 'didlogic.com', 'NL', 1024, 'business', '2015-09-21 13:32:10', 0),
(1923, 13008, 'bwin.party services (Austria) GmbH', 'bwin.com', 'AT', 2560, 'business', '2002-05-15 16:09:17', 0),
(1924, 13009, 'VData Ltd', 'vdata.vn', 'GB', 45056, 'isp', '0000-00-00 00:00:00', 0),
(1925, 1301, 'Electricite de France Service National', 'edf.fr', 'FR', 25344, 'business', '2002-09-19 15:18:14', 0),
(1926, 13010, 'MTS Internet GmbH', 'mts.de', 'DE', 8192, 'business', '0000-00-00 00:00:00', 0),
(1927, 13011, 'RA Monitorul Oficial', 'ramo.ro', 'RO', 256, 'business', '2008-12-08 10:43:18', 0),
(1928, 13012, 'Genias Internet', 'genias.net', 'DE', 9216, 'isp', '2002-07-18 11:30:46', 0),
(1929, 13016, 'Teleline Ltd.', 'teleline.ru', 'RU', 1024, 'business', '2008-06-02 13:01:21', 0),
(1930, 13018, 'Banca Monte Dei Paschi Di Siena S.P.A.', 'mps.it', 'IT', 2048, 'business', '2001-11-27 14:03:40', 0),
(1931, 13021, 'Arexim S.A.', 'arexim.ro', 'RO', 256, 'business', '0000-00-00 00:00:00', 0),
(1932, 13022, 'Streams Telecommunicationsservices GmbH', 'streams.at', 'AT', 6400, 'business', '0000-00-00 00:00:00', 0),
(1933, 13023, 'Weber Ltd', 'webber.net.ua', 'UA', 1024, 'business', '0000-00-00 00:00:00', 0),
(1934, 13026, 'Manuel Kahr', 'k-wlan.at', 'AT', 1536, 'isp', '2011-02-04 10:09:16', 0),
(1935, 13027, 'Ukrainian National News Agency UKRINFORM', 'ukrinform.com', 'UA', 256, 'business', '0000-00-00 00:00:00', 0),
(1936, 13029, 'Ministry of Digital Development, Information Policy and Mass Communications of the Chuvash Republic', 'cap.ru', 'RU', 512, 'business', '2008-12-19 08:55:06', 0),
(1937, 1303, 'Renater', 'renater.fr', 'FR', 66560, 'isp', '0000-00-00 00:00:00', 0),
(1938, 13030, 'Init7 (Switzerland) Ltd.', 'init7.net', 'CH', 95744, 'isp', '2002-09-17 17:36:34', 0),
(1939, 13032, 'Kyiv National Taras Shevchenko University', 'univ.kiev.ua', 'UA', 1792, 'education', '2002-09-18 18:34:14', 0),
(1940, 13034, 'SOLOCAL', 'pagesjaunes.fr', 'FR', 768, 'business', '0000-00-00 00:00:00', 0),
(1941, 13035, 'IP Telecom ltd.', 'iptelecom.it', 'IT', 2304, 'business', '2010-01-25 12:58:01', 0),
(1942, 13036, 'T-Mobile Czech Republic a.s.', 't-mobile.cz', 'CZ', 352256, 'isp', '0000-00-00 00:00:00', 0),
(1943, 13037, 'Zen Internet Ltd', 'zen.co.uk', 'GB', 670720, 'isp', '2002-09-20 15:36:24', 0),
(1944, 13038, 'HELLENIC EXCHANGES S.A. HOLDING, CLEARING, SETTLEMENT & REGISTRATION', 'helex.gr', 'GR', 3072, 'business', '0000-00-00 00:00:00', 0),
(1945, 13039, 'Global Village GmbH', 'global-village.de', 'DE', 13568, 'business', '2002-08-20 12:28:40', 0),
(1946, 13040, 'FIZ Karlsruhe - Leibniz-Institut fuer Informationsinfrastruktur GmbH', 'fiz-karlsruhe.de', 'DE', 65536, 'business', '2001-09-26 09:35:23', 0),
(1947, 13041, 'Consorci de Serveis Universitaris de Catalunya', 'csuc.cat', 'ES', 311808, 'education', '2002-04-24 15:18:07', 0),
(1948, 13042, 'Oesterreichische Nationalbank', 'oenb.at', 'AT', 8192, 'business', '0000-00-00 00:00:00', 0),
(1949, 13043, 'Bayer Business Services GmbH', 'bayer.de', 'DE', 178432, 'business', '2002-08-19 14:11:34', 0),
(1950, 13044, 'Aoun.net s.a.r.l', 'aoun.net', 'LB', 6656, 'isp', '2015-09-21 10:34:26', 0),
(1951, 13045, 'htp GmbH', 'htp.net', 'DE', 174592, 'isp', '2002-07-31 08:42:09', 0),
(1952, 13046, 'ISKON INTERNET d.d. za informatiku i telekomunikacije', 'iskon.hr', 'HR', 139264, 'isp', '2002-08-30 09:22:28', 0),
(1953, 13053, 'JSC Priocom', 'priocom.com', 'UA', 8192, 'business', '2002-04-22 06:47:34', 0),
(1954, 13054, 'FreiNet GmbH', 'freinet.de', 'DE', 11264, 'isp', '2002-06-30 13:11:28', 0),
(1955, 13055, 'JSC Comstar-Regions', 'comstar-r.ru', 'RU', 21504, 'isp', '2009-09-18 08:21:23', 0),
(1956, 13056, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 67072, 'isp', '0000-00-00 00:00:00', 0),
(1957, 13057, 'A.P. Moller - Maersk A/S', 'maersk.com', 'DK', 256, 'business', '0000-00-00 00:00:00', 0),
(1958, 13059, 'Extreme Solutions SRL', 'extreme.ro', 'RO', 512, 'business', '0000-00-00 00:00:00', 0),
(1959, 13060, 'Basic Net SpA', 'basicnet.com', 'IT', 256, 'business', '2002-07-11 09:30:07', 0),
(1960, 13063, 'SKF Sverige AB', 'skf.com', 'SE', 65536, 'business', '0000-00-00 00:00:00', 0),
(1961, 13065, 'Uniwersytet Zielonogorski', 'uz.zgora.pl', 'PL', 7168, 'business', '2002-04-18 13:24:11', 0),
(1962, 13068, 'Wiener Borse AG', 'wienerborse.at', 'AT', 256, 'business', '0000-00-00 00:00:00', 0),
(1963, 13069, 'DataGuard', 'globalconnect.no', 'NO', 1280, 'isp', '2001-10-03 16:35:28', 0),
(1964, 1307, 'Renater', 'renater.fr', 'FR', 131072, 'isp', '2002-08-21 16:42:11', 0),
(1965, 13070, 'SIA Electronic Solutions', 'silale.lv', 'LV', 5120, 'isp', '2004-04-14 12:24:12', 0),
(1966, 13073, 'IFAT - Media Information Center LTD', 'ifat.com', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1967, 13074, 'Teletel Communication Channels Ltd', 'walla.net.il', 'IL', 2048, 'business', '0000-00-00 00:00:00', 0),
(1968, 13075, 'CJSC Megalabs', 'megalabs.ru', 'RU', 1024, 'business', '2002-01-20 15:19:33', 0),
(1969, 13077, 'North-Caucasus Federal University', 'ncfu.ru', 'RU', 2560, 'education', '0000-00-00 00:00:00', 0),
(1970, 13078, 'Computer Technologies Institute,ltd', 'ctinet.ru', 'RU', 4096, 'business', '0000-00-00 00:00:00', 0),
(1971, 13079, 'Zond Holding JSC', 'zond.ru', 'RU', 8192, 'business', '0000-00-00 00:00:00', 0),
(1972, 13082, 'Kar-Tel LLC', 'beeline.kz', 'KZ', 8192, 'isp', '0000-00-00 00:00:00', 0),
(1973, 13085, 'Banca Comerciala Carpatica SA', 'carpatica.ro', 'RO', 512, 'business', '2008-04-08 11:46:23', 0),
(1974, 13091, 'JP Posta Srbije Beograd', 'posta.rs', 'RS', 48640, 'isp', '2002-08-21 08:12:36', 0),
(1975, 13092, 'Akademska mreza Republike Srbije - AMRES', 'amres.ac.rs', 'RS', 74752, 'education', '0000-00-00 00:00:00', 0),
(1976, 13093, 'Haaretz Daily Newspaper Ltd.', 'haaretz.co.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(1977, 13094, 'LLC Milecom', 'milecom.ru', 'RU', 512, 'business', '2011-03-23 13:52:11', 0),
(1978, 13095, 'PJSC Vimpelcom', 'ctk.ru', 'RU', 8192, 'business', '2002-08-12 11:13:39', 0),
(1979, 13097, 'Telemar s.p.a.', 'telemar.it', 'IT', 20224, 'isp', '0000-00-00 00:00:00', 0),
(1980, 13099, 'AzEuroTel J.V.', 'azeurotel.com', 'AZ', 8448, 'business', '0000-00-00 00:00:00', 0),
(1981, 131, 'University of California, Santa Barbara', 'ucsb.edu', 'US', 132096, 'education', '1987-09-30 00:00:00', 0),
(1982, 13101, 'ennit server GmbH', 'tng.de', 'DE', 118784, 'isp', '2002-09-20 22:37:35', 0),
(1983, 13102, 'Istanbul Bilgi Universitesi', 'bilgi.edu.tr', 'TR', 512, 'education', '0000-00-00 00:00:00', 0),
(1984, 13105, 'LUKOIL Technology Services GmbH', 'lukoil.com', 'RU', 24576, 'business', '2001-12-04 11:27:03', 0),
(1985, 13106, 'Don Apex Ltd', 'donapex.net', 'UA', 9216, 'business', '2001-12-10 09:31:39', 0),
(1986, 13107, 'PIK Ltd', 'icm.dn.ua', 'UA', 1024, 'business', '0000-00-00 00:00:00', 0),
(1987, 131078, 'KDDI R&D Laboratories, INC.', 'kddilabs.jp', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(1988, 131079, 'INTERNET MULTIFEED CO.', 'mfeed.ad.jp', 'JP', 256, 'isp', '0000-00-00 00:00:00', 0),
(1989, 131088, 'Western Australian Internet Association', 'internet.asn.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(1990, 131089, 'CAT TELECOM Public Company Ltd,CAT', 'cat.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(1991, 131090, 'CAT TELECOM Public Company Ltd,CAT', 'cat.net.th', 'TH', 205824, 'isp', '0000-00-00 00:00:00', 0),
(1992, 131091, 'GSS Global', 'goldsunshine.net', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(1993, 131098, 'Korea Internet Security Agency', 'None', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(1994, 131099, 'Korea Internet Security Agency', 'None', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(1995, 1311, 'BARRA', 'barra.com', 'US', 1536, 'business', '1991-07-19 00:00:00', 0),
(1996, 13110, 'INEA S.A.', 'inea.pl', 'PL', 167680, 'isp', '2002-05-25 22:17:41', 0),
(1997, 131100, 'Korea Internet Security Agency', 'None', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(1998, 131107, 'ASN for APNICTRAINING LAB DC', 'apnictraining.net', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(1999, 131111, 'PT Mora Telematika Indonesia', 'moratelindo.co.id', 'ID', 54272, 'isp', '0000-00-00 00:00:00', 0),
(2000, 131112, 'Sekolah Tinggi Multi Media MMTC Yogyakarta', 'mmtc.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(2001, 131117, 'MPLS Network Provider', 'cbn.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(2002, 131118, 'Network Access Provider', 'cbn.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(2003, 131119, 'Internet Service Provider', 'ispfo.co.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(2004, 131122, 'Vietnam Internet network information center (VNNIC)', 'vnnic.vn', 'VN', 256, 'isp', '0000-00-00 00:00:00', 0),
(2005, 131123, 'Vietnam Internet network information center (VNNIC)', 'vnnic.vn', 'VN', 256, 'isp', '0000-00-00 00:00:00', 0),
(2006, 131124, 'Vietnam Bank For Social Policies', 'vbsp.org.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2007, 131125, 'TVSI-VN', 'tvsi.com.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2008, 131126, 'Vietnam Airlines Corp', 'vietnamair.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2009, 131127, 'Global Telecom Corp', 'gtelmiennam.vn', 'VN', 5376, 'business', '0000-00-00 00:00:00', 0),
(2010, 131128, 'Onepay Online Service and Commercial Joint Stock Company', 'onepay.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2011, 131129, 'Hochiminh Stock Exchange', 'hsx.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2012, 13113, 'ISI Line srl', 'isiline.it', 'IT', 34816, 'isp', '0000-00-00 00:00:00', 0),
(2013, 131130, 'MB securities joint stock company', 'mbs.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2014, 131134, 'Bosch (China) Investment Ltd.', 'bosch.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2015, 131142, 'Asia Pacific On-Line Service Inc.', 'apol.com.tw', 'TW', 13568, 'isp', '0000-00-00 00:00:00', 0),
(2016, 131143, 'Chinatrust Commercial Bank', 'chinatrust.com.tw', 'TW', 3072, 'business', '0000-00-00 00:00:00', 0),
(2017, 131144, 'ASUSTek COMPUTER INC.', 'asus.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2018, 131148, 'Bank Of Taiwan', 'bot.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2019, 131149, 'Yuan-Jhen Info., Co., Ltd', 'twnoc.net', 'TW', 8192, 'hosting', '0000-00-00 00:00:00', 0),
(2020, 13115, 'Home of the Brave Internet Technology Based Solutions GmbH', 'brave.de', 'DE', 9216, 'business', '2002-08-10 12:30:30', 0),
(2021, 131150, 'Education Bureau, Kaohsiung City Government, Taiwan', 'moe.edu.tw', 'TW', 5632, 'education', '0000-00-00 00:00:00', 0),
(2022, 131155, 'NTT Communications Corporation', 'ntt.com', 'JP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2023, 131158, 'Nara Institute of Science and Technology, National University Corporation', 'naist.jp', 'JP', 512, 'education', '0000-00-00 00:00:00', 0),
(2024, 131159, 'Yamagata University', 'yamagata-u.ac.jp', 'JP', 65536, 'education', '0000-00-00 00:00:00', 0),
(2025, 13116, 'Tele2 Sverige AB', 'tele2.se', 'SE', 256, 'isp', '0000-00-00 00:00:00', 0),
(2026, 131160, 'Wire and Wireless Co.,Ltd.', 'wi2.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2027, 131162, 'Internet Service Provider in Thailand', 'trueinternet.co.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(2028, 131164, '61 Ming Chuan Road Section 1', 'None', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2029, 131168, 'Windcave Limited', 'windcave.com', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2030, 131169, '# 26, Bannerghatta Road, J. P. Nagar, Phase III', 'onmobile.com', 'IN', 2560, 'business', '0000-00-00 00:00:00', 0),
(2031, 13117, 'Nexusguard, Inc', 'nexusguard.com', 'NL', 512, 'business', '2015-09-21 09:43:25', 0),
(2032, 131170, 'Electronics For Imaging India Private Limited', 'efi.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2033, 131171, 'S-Tech LTD.', 'streaming-tech.com', 'PH', 768, 'business', '0000-00-00 00:00:00', 0),
(2034, 131174, 'Vivid Solutions, ISP, Auckland', 'vocusgroup.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2035, 131178, 'OpenNet ISP Cambodia', 'opennet.com.kh', 'KH', 60416, 'isp', '0000-00-00 00:00:00', 0),
(2036, 131179, 'Telebangla Communications Limited', 'telebangla.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2037, 13118, 'PJSC Rostelecom', 'rostelecom.ru', 'RU', 111104, 'isp', '2002-02-06 09:36:57', 0),
(2038, 131181, 'Financial Technologies Communication Limited', 'ftindia.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2039, 131182, 'Crosspoint Telecommunications Pty Ltd', 'crosspoint-telecom.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2040, 131183, 'Empowering Net (epnet)', 'epnetbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2041, 131184, 'Fountain Set (Holdings) Ltd', 'fshl.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2042, 131188, 'Global Gateway, Tsuen Wan, New Territories, Hong Kong', 'readyspace.com.hk', 'HK', 2304, 'hosting', '0000-00-00 00:00:00', 0),
(2043, 131189, 'Livecom Limited', 'livecom.hk', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(2044, 13119, 'Zachodniopomorski Uniwersytet Technologiczny w Szczecinie, Akademickie Centrum Informatyki', 'man.szczecin.pl', 'PL', 16640, 'education', '2002-07-08 08:40:56', 0),
(2045, 131194, 'PGi SG', 'pgi.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2046, 131195, 'SIM Headquarters', 'sim.edu.sg', 'SG', 768, 'education', '0000-00-00 00:00:00', 0),
(2047, 131196, 'Enable Networks', 'snap.net.nz', 'NZ', 256, 'isp', '0000-00-00 00:00:00', 0),
(2048, 131197, 'FORTRESS ESPORTS PTY. LTD.', 'fortressmelbourne.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2049, 131198, 'Mediatribe Limited', 'mediatribe.co.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2050, 131199, 'Nexeon Technologies, Inc.', 'nexeon.com', 'US', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2051, 1312, 'Virginia Polytechnic Institute and State Univ.', 'vt.edu', 'US', 147712, 'education', '1991-07-19 00:00:00', 0),
(2052, 13120, 'BEC Bankernes EDB Central', 'bec.dk', 'DK', 3072, 'business', '0000-00-00 00:00:00', 0),
(2053, 131202, 'Gravity Internet Ltd', 'getgravity.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2054, 131203, 'MekongNet1 IXP. For Domestic Internet exchange (DIX)Cambodia', 'mekongnet.com.kh', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(2055, 131207, 'SINET, Cambodia\'s specialist Internet and Telecom Service Provider.', 'sinet.com.kh', 'KH', 18176, 'isp', '0000-00-00 00:00:00', 0),
(2056, 13121, 'Navigator Online TOV', 'naverex.net', 'UA', 8192, 'business', '2002-06-20 09:20:34', 0),
(2057, 131210, 'Yashash Cable Network Pvt Ltd', 'yashtel.in', 'IN', 4864, 'isp', '0000-00-00 00:00:00', 0),
(2058, 131214, 'Interact Hosting Pty Ltd', 'interacthosting.com.au', 'AU', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2059, 131215, '116 MADHAV DARSHAN', 'sancharonline.net', 'IN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(2060, 131216, 'Saharea Hossain t/a Authentic Network', 'ansbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(2061, 131217, '8 Kallang Sector', 'infineon.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2062, 131218, 'Innodata Lanka Pvt Ltd', 'innodata-isogen.com', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(2063, 131219, 'Indosat Singapore Pte. Ltd.', 'indosatooredoosingapore.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2064, 13122, 'Manx Telecom Trading Ltd', 'manxtelecom.com', 'GB', 48128, 'isp', '2002-05-10 14:02:42', 0),
(2065, 131220, 'Optimum Media Direction Pty Ltd', 'omnicommediagroup.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2066, 131221, 'Petchaburi Rajabhat University', 'uni.net.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2067, 131224, 'SGC-Cloud Alliance Limited', 'sgc.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2068, 131225, 'Level 21', 'csenergy.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2069, 131226, 'Indian Institute Of Technology Roorkee', 'iitr.ac.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(2070, 131227, 'Tussock Networks Limited', 'tussock.net.nz', 'NZ', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2071, 131230, 'Mitre 10 Australia Pty. Ltd', 'mitre10.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2072, 131232, 'ADP Private Limited', 'adp.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2073, 131234, 'AEDAS-HK', 'aedas.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2074, 131235, 'SYNTELNET-IN', 'syntelinc.com', 'IN', 3072, 'business', '0000-00-00 00:00:00', 0),
(2075, 131236, 'Genworx Pte Ltd', 'genworx.sg', 'SG', 2048, 'business', '0000-00-00 00:00:00', 0),
(2076, 131237, 'PT. FWD Life Indonesia', 'fwd.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2077, 131239, 'Auckland Council', 'aucklandcouncil.govt.nz', 'NZ', 2816, 'business', '0000-00-00 00:00:00', 0),
(2078, 13124, 'A1 Bulgaria EAD', 'a1.bg', 'BG', 408576, 'isp', '0000-00-00 00:00:00', 0),
(2079, 131240, 'Ultranet Zone LLC', 'ultranet.mn', 'MN', 256, 'business', '0000-00-00 00:00:00', 0),
(2080, 131244, 'ICA ORTHO SERVICES PTE. LTD.', 'aligntech.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2081, 131245, 'University of the Philippines', 'up.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(2082, 131246, 'LOEI university network ,LOEI, Thailand', 'lru.ac.th', 'TH', 256, 'education', '0000-00-00 00:00:00', 0),
(2083, 131247, 'Infobd24 Systems', 'infobd24.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2084, 131253, 'De La Salle-Lipa', 'dlsl.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(2085, 131254, 'Northpower Ltd', 'northpower.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2086, 131255, 'Caliber Point Business Solutions Ltd', 'caliberpoint.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2087, 131256, 'MGRM DIGITAL CLOUD SERVICES PRIVATE LIMITED', 'mgrm.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2088, 131257, 'Suratthani ratjabhat university, Thailand', 'sru.ac.th', 'TH', 256, 'education', '0000-00-00 00:00:00', 0),
(2089, 131258, 'DLS-CSB-SDA', 'benilde.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(2090, 131259, 'QOXY PTE LTD', 'qoxy.com', 'SG', 5120, 'business', '0000-00-00 00:00:00', 0),
(2091, 13126, 'Satellite Mediaport Services Ltd.', 'sms-teleport.com', 'GB', 24320, 'business', '2002-09-25 12:52:35', 0),
(2092, 131262, 'Kelnet Communication Services (P) Ltd.', 'kelnetonline.net', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2093, 131264, 'Functional Solutions PTY LTD', 'functionalsolutions.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2094, 131265, 'TCS eServe Limited', 'tcs.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2095, 131267, 'PO box T511 Phonexay road - Xaysettha district', 'unitel.com.la', 'LA', 9216, 'isp', '0000-00-00 00:00:00', 0),
(2096, 131268, 'Sunshine Coast Regional Council', 'sunshinecoast.qld.gov.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(2097, 131269, 'ACTFIBERNET Pvt Ltd', 'actcorp.in', 'IN', 114688, 'isp', '0000-00-00 00:00:00', 0),
(2098, 13127, 'Tele2 Nederland B.V.', 'tele2.nl', 'NL', 1314048, 'isp', '2002-08-26 13:37:26', 0),
(2099, 131270, 'Planet Technology Group Ltd', 'buroserv.com.au', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(2100, 131271, 'ABS (HK) Limited', 'absatellite.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2101, 131272, 'The Open Polytechnic of New Zealand', 'openpolytechnic.ac.nz', 'NZ', 4096, 'education', '0000-00-00 00:00:00', 0),
(2102, 131273, 'HiMORE Digital', 'himore.tw', 'TW', 768, 'business', '0000-00-00 00:00:00', 0),
(2103, 131274, 'Cypresstel Global Network', 'cypresstel.com', 'HK', 2304, 'business', '0000-00-00 00:00:00', 0),
(2104, 131275, 'Logon Broadband Pvt. Limited', 'logon.com.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(2105, 131276, 'BT INFOCOMMUNICATIONS SPECIALIST INC.', 'None', 'PH', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2106, 131278, 'Abir Telecommunications Ltd', 'abirtelecomiig.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2107, 131279, 'Ryugyong-dong', 'net.kp', 'KP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2108, 13128, 'IT-Dienstleistungszentrum Berlin', 'itdz-berlin.de', 'DE', 65536, 'business', '2001-09-26 16:59:34', 0),
(2109, 131280, 'Hutchison International Limited', 'hwl.com.hk', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(2110, 131281, 'University of the Philippines, Visayas Cebu Campus', 'upd.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(2111, 131282, 'ELEMENT FLEET SERVICES AUSTRALIA PTY LTD', 'elementfleet.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2112, 131283, 'HDFC Bank House', 'hdfcbank.com', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(2113, 131284, 'Etisalat Afghan', 'etisalat.af', 'AF', 16384, 'isp', '0000-00-00 00:00:00', 0),
(2114, 131285, 'CHINATELECOM Hubei province Shengji 5G network', 'chinatelecom.cn', 'CN', 131072, 'isp', '0000-00-00 00:00:00', 0),
(2115, 131286, 'Bilmark Pty Ltd', 'bilmark.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2116, 131287, 'Yonder.Co.Nz Limited', 'yonder.co.nz', 'NZ', 512, 'isp', '0000-00-00 00:00:00', 0),
(2117, 131290, 'RACWA Holdings Pty Ltd', 'rac.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2118, 131291, 'LANWorx Limited', 'lanworx.co.nz', 'NZ', 1280, 'isp', '0000-00-00 00:00:00', 0),
(2119, 131292, 'Hub Computing Services Pty Ltd', 'hubcomputing.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2120, 131293, 'TOT Public Company Limited', 'tot.co.th', 'TH', 93184, 'isp', '0000-00-00 00:00:00', 0),
(2121, 131294, 'ANMM-AU', 'anmm.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2122, 131295, 'Employers Mutual Management Pty Ltd', 'aswigsolutions.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2123, 131296, 'REXNETWORKS LIMITED', 'rexnetworks.co.nz', 'NZ', 2048, 'business', '0000-00-00 00:00:00', 0),
(2124, 131299, 'tornado net private limited', 'mnc.com.my', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2125, 1313, 'Adobe Systems Inc.', 'adobe.com', 'US', 4352, 'business', '1991-07-24 00:00:00', 0),
(2126, 13130, 'Autostadt GmbH', 'autostadt.de', 'DE', 256, 'business', '0000-00-00 00:00:00', 0),
(2127, 131302, 'Edelweiss Capital Limited', 'edelcap.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2128, 131303, 'FCCDCI-NET-PH', 'fccdci.com', 'PH', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2129, 131306, 'CITI Cableworld Inc.', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2130, 131310, 'CX2 Computer Exchange', 'pltpro.com', 'MY', 6400, 'business', '0000-00-00 00:00:00', 0),
(2131, 131312, 'TAYLOR CONSTRUCTION GROUP PTY LTD', 'taylorau.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2132, 131314, 'China Broadband Communications (Hong Kong) Company Limited', 'cbccom.net', 'HK', 4608, 'business', '0000-00-00 00:00:00', 0),
(2133, 131315, 'RACP-AU', 'racp.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(2134, 131316, 'Slnet Hosting', 'slnet.com.au', 'AU', 512, 'hosting', '0000-00-00 00:00:00', 0),
(2135, 131317, 'TTSL-ISP DIVISION', 'tatatel.co.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(2136, 131318, 'Wialus Solutions Limited', 'wialus.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2137, 13132, 'cyberways Informationsdienste GmbH', 'cyberways.net', 'DE', 8704, 'isp', '2002-09-03 09:44:12', 0),
(2138, 131322, 'Yatanarpon Teleport Company Limited', 'teleport.net.mm', 'MM', 13056, 'isp', '0000-00-00 00:00:00', 0),
(2139, 131323, 'Honda New Zealand Ltd', 'honda.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2140, 131324, '92Cloud Technology Co., Limited', '92cloud.com', 'HK', 6144, 'business', '0000-00-00 00:00:00', 0),
(2141, 131325, 'CHINATELECOM JIANGSU province NANTONG MAN network', 'chinatelecom.cn', 'CN', 23808, 'isp', '0000-00-00 00:00:00', 0),
(2142, 131331, 'BDKTel Co., Ltd.', 'bdktel.com', 'KH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2143, 131332, '113-B, Jalan Aminuddin Baki,', 'myevolution.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(2144, 131337, 'Block B, Manulife Financial Center', 'manulife.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2145, 13134, 'Instituto de Informatica, IP - Ministerio da Solidariedade e Seguranca Social', 'seg-social.pt', 'PT', 256, 'business', '0000-00-00 00:00:00', 0),
(2146, 131340, 'Md. Mozammel Hoque t/a Taqwa IT', 'taqwait.com', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(2147, 131341, 'Department of Information Technology, Government of Nepal', 'doit.gov.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2148, 131342, 'Vietnam Technological and Commercial Joint-stock Bank - Techcombank', 'techcombank.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2149, 131343, 'Vietnam Internationl commercial joint stock bank', 'vib.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2150, 131344, 'TH Food Chain Joint Stock Company', 'thmilk.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2151, 131345, 'KienLong commercial joint stock bank', 'kienlongbank.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2152, 131347, 'Shinhan Viet Nam Bank Limited', 'shinhan.com', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2153, 131348, 'Joint stock Commercial Bank for Foreign Trade of Viet Nam', 'vietcombank.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2154, 131349, 'Digital telecomminication service joint stock', 'dgn.vn', 'VN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2155, 13135, 'Wieske\'s Crew GmbH', 'crew-gmbh.de', 'DE', 7936, 'business', '2002-08-07 14:57:33', 0),
(2156, 131351, 'Orient commercial joint stock bank', 'ocb.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2157, 131352, 'Vietnam Cybersecurity Emergency Response Teams/Coordination Center', 'vncert.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2158, 131353, 'NhanHoa Software company', 'nhanhoa.com', 'VN', 6144, 'hosting', '0000-00-00 00:00:00', 0),
(2159, 131354, 'Prudential Vietnam Assurance Private limited', 'prudential.com.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2160, 131355, 'IGI-VN', 'vmdgroup.com.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2161, 131357, 'Duy Tan University', 'duytan.edu.vn', 'VN', 1024, 'education', '0000-00-00 00:00:00', 0),
(2162, 131358, 'Telehouse international corporation of vietnam', 'telehouse.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2163, 13136, 'Interstroom Informatietechnologie BV', 'interstroom.nl', 'NL', 4096, 'business', '2002-05-17 15:52:22', 0),
(2164, 131360, 'VietNam national financial switching joint stock company', 'banknetvn.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2165, 131361, 'GSS Investment Corporation', 'xgo.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2166, 131362, 'HaNoi Stock Exchange', 'hnx.vn', 'VN', 768, 'business', '0000-00-00 00:00:00', 0),
(2167, 131363, 'Department of Information Technology - General Department of Taxation', 'gdt.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2168, 131364, 'Military commercial join stock bank', 'mbbank.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2169, 131365, 'Department Of Information Technology and Data of Natural Resources and Environment', 'monre.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2170, 131366, 'Lanit Technology and Communication Joint Stock Company', 'lanit.com.vn', 'VN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2171, 131367, 'Viet Online trading service corporation', 'vonline.vn', 'VN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2172, 131368, 'Petro Viet Nam Oil Corporation', 'pvoil.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2173, 131369, 'Ministry of Agriculture and Rural Development', 'mard.gov.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2174, 13137, 'AGENCIA EFE SA', 'efe.com', 'ES', 256, 'business', '0000-00-00 00:00:00', 0),
(2175, 131371, 'BaoMinh securities company', 'bmsc.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2176, 131372, 'VIVAS-VN', 'vivas.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2177, 131373, 'Information Center - Ministry of Science and Technology', 'most.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2178, 131374, 'Hong Quang Trading Investment  Company Limited', 'hqg.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2179, 131375, 'Trung tam Thong tin Bo TT & TT', 'mic.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2180, 131376, 'KB Securities Vietnam Joint Stock Company', 'kbsec.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2181, 131377, 'DIGIPOWER CO., LTD', 'digipower.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2182, 131378, 'Cloud Viet Technology Company Limited', 'vnnic.vn', 'VN', 512, 'isp', '0000-00-00 00:00:00', 0),
(2183, 131379, 'Ocean Commercial Joint Stock Bank', 'oceanbank.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2184, 13138, 'Turk Ekonomi Bankasi Anonim Sirketi', 'teb.com.tr', 'TR', 8192, 'business', '0000-00-00 00:00:00', 0),
(2185, 131380, 'Niteco VN', 'niteco.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2186, 131381, 'Customs IT and Statistics Department - General Department of Vietnam Customs', 'customs.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2187, 131383, 'PVI Holdings', 'pvi.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2188, 131385, 'VTV-VN', 'vtv.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2189, 131386, 'Long Van System Solution JSC', 'lvsolution.vn', 'VN', 4096, 'hosting', '0000-00-00 00:00:00', 0),
(2190, 131387, 'Sun Life Vietnam Insurance Company Limited', 'sunlife.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(2191, 131388, 'Vietnam HTS., JSC', 'hts.vn', 'VN', 4096, 'business', '0000-00-00 00:00:00', 0),
(2192, 131389, 'SeABank', 'seabank.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2193, 131390, 'Vietnam E-commerce Development Centre', 'ecomviet.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2194, 131391, 'Vietnam-Asia Commercial Joint Stock Bank', 'vietabank.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2195, 131392, 'GMO-Z.com Runsystem Joint Stock Company', 'gmo-z.com', 'VN', 19456, 'hosting', '0000-00-00 00:00:00', 0),
(2196, 131394, 'Cloudovs Vietnam Technology Joint Stock Company', 'vnnic.vn', 'VN', 256, 'isp', '0000-00-00 00:00:00', 0),
(2197, 131396, 'Rmit International University Vietnam', 'rmit.edu.vn', 'VN', 1536, 'education', '0000-00-00 00:00:00', 0),
(2198, 131397, 'Hanoi Medical University', 'hmu.edu.vn', 'VN', 1024, 'education', '0000-00-00 00:00:00', 0),
(2199, 131398, 'Lotte Data Communication Company Limited', 'ldcc.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2200, 131401, 'Department of Information and Communication of Vinh Phuc', 'vinhphuc.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2201, 131402, 'FPT Software Company limited', 'fsoft.com.vn', 'VN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2202, 131403, 'ICSOFT Joint Stock Company', 'icsoft.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2203, 131404, 'Masters Technology Corporation', 'vietnamhost.vn', 'VN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2204, 131405, 'Saigon Newport', 'saigonnewport.com.vn', 'VN', 768, 'business', '0000-00-00 00:00:00', 0),
(2205, 131407, 'Sai Gon CTT', 'saigonctt.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2206, 131408, 'TPBANK-VN', 'tpb.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2207, 131410, 'Vietnam Television Cable Corporation One Member Company Limited', 'vtvcab.vn', 'VN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2208, 131412, 'State Audit Office of Vietnam', 'sav.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2209, 131413, 'VinCommerce General Commercial Services Joint Stock Company', 'vingroup.net', 'VN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2210, 131414, 'Long Van Soft Solution JSC', 'longvan.net', 'VN', 3072, 'hosting', '0000-00-00 00:00:00', 0),
(2211, 131415, 'Vietnam Internet network information center (VNNIC)', 'vnnic.vn', 'VN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2212, 131417, 'Vietnam National Coaland Mineral Industries Holding Corporation Limited', 'vinacomin.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2213, 131418, 'Vietnam Esports Development Joint Stock Company', 'ved.com.vn', 'VN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2214, 131419, 'Smartlink Card., JSC', 'smartlink.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2215, 131421, 'Intercom Telecom., JSC', 'intercom.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2216, 131423, 'Branch of Long Van System Solution JSC - Hanoi', 'longvan.net', 'VN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2217, 131425, 'The gioi di dong jsc', 'thegioididong.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2218, 131426, 'MISA-VN', 'misa.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2219, 131427, 'AOHOAVIET-VN', 'aohoaviet.com', 'VN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2220, 131428, 'Rainbow E-Commerce Company Limited', 'rainbow-mail.com', 'VN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(2221, 131429, 'MOBIFONE Corporation', 'mobifone.vn', 'VN', 32256, 'isp', '0000-00-00 00:00:00', 0),
(2222, 131430, 'Bao Viet bank', 'baovietbank.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2223, 131433, 'Corporation Technology Development Eposi', 'eposi.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(2224, 131434, 'Scom Technology Join stock company', 'scom.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2225, 131435, 'Vietnam Esports and Entertainment Joint Stock Company', 'ved.com.vn', 'VN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2226, 131437, 'DT Communications company limited', 'wihat.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2227, 131438, 'VIETNAM POST', 'vnpost.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2228, 131439, 'VietNam credit information joint stock company', 'pcb.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2229, 131440, 'Nguyen Bao Digital Company Limited', 'vng.com.vn', 'VN', 256, 'isp', '0000-00-00 00:00:00', 0),
(2230, 131442, 'Digital Network Associates Pvt Ltd', 'dna.com', 'IN', 4864, 'isp', '0000-00-00 00:00:00', 0),
(2231, 131444, 'Huawei IT Data Center in AP', 'huawei.com', 'HK', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(2232, 131445, 'Advance Wireless Network', 'ais.co.th', 'TH', 147968, 'isp', '0000-00-00 00:00:00', 0),
(2233, 131446, 'Minerals and Metals Group Ltd', 'mmg.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2234, 131447, 'POPIDC powered by CSLoxinfo', 'pop-idc.com', 'TH', 4608, 'hosting', '0000-00-00 00:00:00', 0),
(2235, 131448, 'Broadband Networks', 'bnisolutions.com', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(2236, 131454, 'C-PRO CO., LTD.', 'cpronet.net', 'KH', 2816, 'business', '0000-00-00 00:00:00', 0),
(2237, 131455, '22 Stirling St', 'onsitecomputers.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(2238, 131458, 'WILLIAMS LEA INDIA PRIVATE LIMITED', 'williamslea.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(2239, 131459, '88c, Race Course Road, Coimbatore 641018', 'bluwifi.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2240, 131460, '9 UM Tower', 'asiasoft.co.th', 'TH', 3840, 'business', '0000-00-00 00:00:00', 0),
(2241, 131462, 'Landgate Western Australian Land Information System Office', 'walis.wa.gov.au', 'AU', 4352, 'business', '0000-00-00 00:00:00', 0),
(2242, 131463, 'STN COMMUNICATION & ADVERTISING PVT LTD', 'irinn.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2243, 131464, 'Digi Jadoo Broadband Ltd', 'digijadoo.com', 'BD', 3072, 'business', '0000-00-00 00:00:00', 0),
(2244, 131465, 'TANG INTERNET LIMITED', 'nonolive.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2245, 131467, 'Unified National Networks', 'unn.com.bn', 'BN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2246, 13147, 'Net Info JSCo', 'netinfo.bg', 'BG', 256, 'business', '0000-00-00 00:00:00', 0),
(2247, 131471, 'Login.Me (Pvt) Ltd', 'lmpl.net', 'PK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2248, 131473, 'SRM Nagar', 'srmist.edu.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(2249, 131474, 'Gumtree.com Australia Pty Ltd', 'gumtree.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2250, 131475, 'Singapore Institute of Technology', 'singaporetech.edu.sg', 'SG', 512, 'education', '0000-00-00 00:00:00', 0),
(2251, 131476, 'FUSIONBB-AU', 'fusionbroadband.com.au', 'AU', 3328, 'isp', '0000-00-00 00:00:00', 0),
(2252, 131477, 'Shanghai Huajuan Information Technology Co., Ltd.', 'betaidc.com', 'CN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(2253, 131478, 'CLARENCE PROFESSIONAL OFFICES PTY. LIMITED', 'clarenceprofessionalgroup.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2254, 131480, 'Innovations Direct Pty Ltd', 'directgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2255, 131482, 'Hangzhou Aron Teconology Co.,Ltd.', 'cnnic.cn', 'CN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2256, 131486, 'Beijing Jingdong 360 Degree E-commerce Co., Ltd.', 'jd.com', 'CN', 100352, 'business', '0000-00-00 00:00:00', 0),
(2257, 131497, 'Volkswagen (China) Investment Co., LTD', 'vw.com.cn', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2258, 1315, 'Imperial PFS', 'ipfs.com', 'US', 256, 'business', '2014-02-05 00:00:00', 0),
(2259, 13150, 'CATO NETWORKS LTD', 'catonetworks.com', 'DE', 22016, 'isp', '2015-09-18 14:46:28', 0),
(2260, 131503, 'China National Aero-Technology Import & Export Corporation', 'catic.cn', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2261, 131506, 'HEILONGJIANG RADIO & TV NETWORK CO.,LTD', 'ljwl.cn', 'CN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2262, 131519, 'Hisense', 'hisense.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2263, 131524, 'Shanghai pujv Communication Technology co., Ltd.', 'pjnet.com.cn', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(2264, 131525, 'Nanjing Tuniu Technology Co. Ltd.', 'tuniu.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(2265, 13153, 'SINGULARLOGIC INTEGRATOR SA', 'singularlogic.eu', 'GR', 512, 'business', '0000-00-00 00:00:00', 0),
(2266, 131530, 'Shanghai Stacks Network Co., Ltd', 'stacksnet.com', 'CN', 1536, 'business', '0000-00-00 00:00:00', 0),
(2267, 131536, 'Shanghai Great Wall Broadband Network Service Co., Ltd.', 'gwbnsh.net.cn', 'CN', 16384, 'isp', '0000-00-00 00:00:00', 0),
(2268, 13154, 'RZZ Rechenzentrum AG', 'rzz.ch', 'CH', 256, 'business', '2010-03-01 10:17:11', 0),
(2269, 131541, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 256, 'business', '2006-11-29 00:00:00', 0),
(2270, 13155, 'MTS PJSC', 'mts.ru', 'RU', 4352, 'isp', '0000-00-00 00:00:00', 0),
(2271, 131558, 'Wal-mart (China) Investment Co., Ltd.', 'wal-mart.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(2272, 13156, 'NOWO COMMUNICATIONS, S.A.', 'nowo.pt', 'PT', 218112, 'isp', '0000-00-00 00:00:00', 0),
(2273, 131562, 'HUNAN CATV Network Group CO.,LTD.', 'cnnic.cn', 'CN', 32768, 'isp', '0000-00-00 00:00:00', 0),
(2274, 13157, 'GOPAS Solutions GmbH', 'gopas.de', 'DE', 9728, 'business', '2001-11-05 18:01:59', 0),
(2275, 131577, 'Hubei zhaosheng kailai technology co., LTD', 'cnnic.cn', 'CN', 512, 'isp', '0000-00-00 00:00:00', 0),
(2276, 131578, 'Beijing Foreign Studies University', 'bfsu.edu.cn', 'CN', 1024, 'education', '0000-00-00 00:00:00', 0),
(2277, 131581, 'INPEX Australia', 'inpex.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2278, 131582, 'QUAPE PTE LTD', 'quape.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2279, 131583, 'WIZwireless Limited', 'wizbiz.net.nz', 'NZ', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2280, 131584, 'Taiwan Intelligent Fiber Optic Network Co.,Ltd.', 'taifo.com.tw', 'TW', 28672, 'isp', '0000-00-00 00:00:00', 0),
(2281, 131586, 'New Century InfoComm Tech Co., Ltd.', 'seed.net.tw', 'TW', 34304, 'isp', '0000-00-00 00:00:00', 0),
(2282, 131587, 'Mega International Commercial Bank', 'megabank.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2283, 131588, 'Financial Information Service Co., Ltd.', 'fisc.com.tw', 'TW', 768, 'business', '0000-00-00 00:00:00', 0),
(2284, 131589, 'Foxconn Technology Group', 'foxconn.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2285, 131590, 'Taiwan Cooperative Bank', 'tcb-bank.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2286, 131591, 'Ambit Microsystem Corporation', 'ambit.com.tw', 'TW', 281856, 'isp', '0000-00-00 00:00:00', 0),
(2287, 131593, 'PEGATRON', 'pegatroncorp.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2288, 131595, 'Kingston Technology Fareast Corp.', 'kingston.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2289, 131596, 'TBC', 'lsc.net.tw', 'TW', 351232, 'isp', '0000-00-00 00:00:00', 0),
(2290, 131597, 'New Changhua Digital Cable TV CO,.Ltd', 'ncdtv.com.tw', 'TW', 37888, 'isp', '0000-00-00 00:00:00', 0),
(2291, 131599, 'Wistron Corporation', 'wistron.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2292, 13160, 'EMMELIBRI S.R.L.', 'emmelibri.it', 'IT', 512, 'business', '0000-00-00 00:00:00', 0),
(2293, 131600, 'Chief Telecom Inc.', 'chief.com.tw', 'TW', 2816, 'isp', '0000-00-00 00:00:00', 0),
(2294, 131601, 'Dynamic Computing Technology', 'dct-cloud.com', 'TW', 2304, 'business', '0000-00-00 00:00:00', 0),
(2295, 131603, 'Worldstar Network', 'worldstar.net.tw', 'TW', 2304, 'business', '0000-00-00 00:00:00', 0),
(2296, 131605, 'Inventec Besta CO.,LTD', 'besta.com.tw', 'TW', 2048, 'business', '0000-00-00 00:00:00', 0),
(2297, 131606, 'Chief Telecom Inc.', 'chief.com.tw', 'TW', 512, 'isp', '0000-00-00 00:00:00', 0),
(2298, 131607, 'Digidom CableTV Co., LTD.', 'dctv.net.tw', 'TW', 27904, 'isp', '0000-00-00 00:00:00', 0),
(2299, 131609, 'Taiwan Envirotech Development Corp.', 'tldc.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2300, 13161, 'LTD Technocom', 'technocomusa.com', 'RU', 1024, 'business', '2002-06-27 07:16:17', 0),
(2301, 131610, 'Anson Network Limited (Taiwan)', 'ansonnet.com', 'TW', 768, 'business', '0000-00-00 00:00:00', 0),
(2302, 131611, 'San Da Cable TV Co., Ltd.', 'sdtv.net.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2303, 131618, 'Carl International Information ltd.', 'cii.com.tw', 'TW', 7424, 'business', '0000-00-00 00:00:00', 0),
(2304, 131619, 'Jigentec CO. LTD.', 'jigentec.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2305, 131620, 'SERVCOMPUTING INC', 'servcomputing.com', 'TW', 768, 'business', '0000-00-00 00:00:00', 0),
(2306, 131621, 'Taiwan Network Information Center', 'twnic.net.tw', 'TW', 768, 'isp', '0000-00-00 00:00:00', 0),
(2307, 131623, 'SHOPEE (TAIWAN) CO. LTD.', 'seagroup.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2308, 131626, 'NSS INT\'L CO., LTD.', 'nss.com.tw', 'TW', 1280, 'business', '0000-00-00 00:00:00', 0),
(2309, 131627, 'Peicity Digital Cable Television., LTD', 'taipeinet.com.tw', 'TW', 109568, 'isp', '0000-00-00 00:00:00', 0),
(2310, 131628, 'Tai-Fu Cloud Co., Ltd.', 'taiwanmobile.com', 'TW', 9728, 'isp', '0000-00-00 00:00:00', 0),
(2311, 131630, 'Garena (TAIWAN) CO. LTD.', 'garena.sg', 'TW', 768, 'isp', '0000-00-00 00:00:00', 0),
(2312, 131631, 'Sunchi Networks', 'scnet.io', 'TW', 768, 'business', '0000-00-00 00:00:00', 0),
(2313, 131632, 'LETSWIN TELECOM CO., LTD.', 'livemail.tw', 'TW', 1280, 'business', '0000-00-00 00:00:00', 0),
(2314, 131633, 'Sakura Internet Ltd.', 'mcsh.co', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2315, 131634, 'MOBA Private Limited Taiwan Branch', 'seagroup.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2316, 131635, 'Airpay TW', 'seagroup.com', 'TW', 1280, 'business', '0000-00-00 00:00:00', 0),
(2317, 131636, 'WANIN INTERNATIONAL CO., LTD.', 'wanin.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2318, 131637, 'FastCould', 'fastcloud.com.tw', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2319, 131639, 'Taiwan Intelligent Home Corp.', 'tih.tw', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(2320, 131642, 'Pittqiao Network Information Co.,Ltd.', 'pni.com.tw', 'TW', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2321, 131644, 'Zhendong Information', 'twnic.net.tw', 'TW', 512, 'isp', '0000-00-00 00:00:00', 0),
(2322, 131645, 'KlickKlack Co., Ltd', 'kkco.com.tw', 'TW', 4352, 'business', '0000-00-00 00:00:00', 0),
(2323, 13165, 'Siberian Internet Company LLC', 'sibintek.net', 'RU', 4352, 'business', '2002-09-11 15:55:16', 0),
(2324, 131651, 'loongaming', 'twnic.net.tw', 'TW', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2325, 131653, 'Chen Sheng Network Technology', 'csnt.com.tw', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2326, 131655, 'NAN YA PLASTICS CORPORATION', 'fpg.com.tw', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2327, 131657, 'HUANG HR CO., LTD.', '4202.tw', 'TW', 1536, 'business', '0000-00-00 00:00:00', 0),
(2328, 131659, 'NETEASE', 'netease.fr', 'TW', 2048, 'business', '0000-00-00 00:00:00', 0),
(2329, 131660, 'Data Communication Business Group,', 'hinet.net', 'TW', 256, 'isp', '0000-00-00 00:00:00', 0),
(2330, 131662, 'Denpa Ltd.', 'denpa.io', 'TW', 1536, 'business', '0000-00-00 00:00:00', 0),
(2331, 131663, 'GIGABYTE', 'gigabyte.com', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(2332, 131667, 'GRONEXT CO., LTD.', 'gronext.com', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2333, 131668, 'Taiwan Digital Streaming Co.', 'twds.tw', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2334, 131669, 'DOPPLER CYBER THREAT SOLUTIONS INC.', 'threatsonar.org', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(2335, 13167, 'Merck KGaA', 'merckgroup.com', 'DE', 67584, 'isp', '0000-00-00 00:00:00', 0),
(2336, 131670, 'DOPPLER CYBER THREAT SOLUTIONS INC.', 'threatvision.org', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(2337, 131671, 'FANTASY TECHNOLOGY CO., LTD.', 'fantasy.game.tw', 'TW', 512, 'business', '0000-00-00 00:00:00', 0),
(2338, 131675, 'Beyond Orbit Co., Ltd.', 'beyond-orbit.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2339, 131677, 'OpenFor Telecommunications Co., Ltd.', 'openrich.com.tw', 'TW', 1536, 'business', '0000-00-00 00:00:00', 0),
(2340, 131678, 'DQWLIT', 'twnic.net.tw', 'TW', 768, 'isp', '0000-00-00 00:00:00', 0),
(2341, 131680, 'Compal Electronics', 'compal.com', 'TW', 1024, 'business', '0000-00-00 00:00:00', 0),
(2342, 131684, 'Universal Connections Technologies (M) Sdn. Bhd.', 'universal.com.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(2343, 131686, 'MD. Khurshid Alom t/a Computer Complex Network', 'ccnetbd.com', 'BD', 1792, 'business', '0000-00-00 00:00:00', 0),
(2344, 13169, 'ABN AMRO Bank N.V.', 'abnamro.com', 'NL', 2048, 'business', '0000-00-00 00:00:00', 0),
(2345, 131693, 'Kementerian Agama (KEMENAG)', 'kemenag.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2346, 131697, 'PT Samudera Indonesia Tbk.', 'samudera.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2347, 13170, 'Kaisanet Oy', 'kaisanet.fi', 'FI', 62464, 'isp', '2002-04-18 18:21:52', 0),
(2348, 131703, 'Universitas Negeri Jakarta', 'unj.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(2349, 131706, 'PT SELARAS CITRA TERABIT', 'terabit.net.id', 'ID', 3840, 'isp', '0000-00-00 00:00:00', 0),
(2350, 131709, 'PENGGUNA DIKS PTH UNSOED', 'sgknet.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2351, 13171, 'Belarusian State University', 'bsu.by', 'BY', 256, 'education', '2002-09-04 08:05:07', 0),
(2352, 131710, 'PT Aero Systems Indonesia', 'asyst.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2353, 131711, 'PT Global Teknologi Teraindo', 'globalmta.biz.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(2354, 131713, 'PT Sano Komunikasi', 'wibisono.or.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2355, 131715, 'PT. Bank Tabungan Negara (Persero) Tbk', 'btn.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2356, 131716, 'PT. Bens Data Solusi', 'tjilaloeng.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2357, 131717, 'PT Citra Jelajah Informatika', 'cifo.co.id', 'ID', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2358, 131718, 'Network Access Provider and Internet Service Provider', 'idola.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(2359, 131719, 'Dinas Perhubungan Kominfo Provinsi Sumatera Selatan', 'sumselprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2360, 13172, 'Electroenergien Sistemen Operator EAD', 'eso.bg', 'BG', 1024, 'business', '2005-02-04 13:49:16', 0),
(2361, 131720, 'BADAN PENGELOLAAN KEUANGAN DAN ASET DAERAH KOTA MAKASSAR', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2362, 131721, 'PT.KALBE FARMA Tbk', 'kalbe.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2363, 131722, 'Kementrian Pekerjaan Umum', 'pu.go.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2364, 131723, 'Kementerian Keuangan Ditjen Bea Cukai', 'customs.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2365, 131724, 'DINHUBKOMINFO PEMPROV. JAWA TENGAH', 'jatengprov.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2366, 131726, 'Dishubkominfo Kota Tegal', 'tegalkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(2367, 131728, 'PT Aneka Signal', 'anekasignal.net.id', 'ID', 1792, 'business', '0000-00-00 00:00:00', 0),
(2368, 13173, 'Foreshore Limited', 'foreshore.net', 'GB', 8192, 'business', '2002-07-15 15:37:16', 0),
(2369, 131732, 'PT. COGINDO DAYABERSAMA', 'cogindo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2370, 131734, 'Universitas Islam Negeri Syarif Hidayatullah Jakarta', 'uinjkt.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(2371, 131735, 'PT Telemedia Network Cakrawala', 'tnc.co.id', 'ID', 1792, 'business', '0000-00-00 00:00:00', 0),
(2372, 131737, 'PT Jakarta International Container Terminal', 'jict.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2373, 131738, 'Golden IT', 'golden-it.co.id', 'ID', 768, 'isp', '0000-00-00 00:00:00', 0),
(2374, 131739, 'Kementerian Pendayagunaan Aparatur Negara dan Reformasi Birokrasi', 'menpan.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2375, 13174, 'MTS PJSC', 'mts.ru', 'RU', 14592, 'isp', '2002-08-26 08:47:05', 0),
(2376, 131740, 'PT Smart Media Pratama', 'smartmedia.net.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(2377, 131741, 'Lembaga Kebijakan Pengadaan Barang/Jasa Pemerintah', 'lkpp.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2378, 131743, 'PT GNET BIARO AKSES', 'golden.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2379, 131745, 'PT. Cybertechtonic Pratama', 'cbtp.co.id', 'ID', 3584, 'hosting', '0000-00-00 00:00:00', 0),
(2380, 131746, 'PT. Medianusa Permana', 'permana.net.id', 'ID', 2304, 'business', '0000-00-00 00:00:00', 0),
(2381, 131749, 'PT. Arthatama Adhiprima Persada', 'indocyber.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2382, 131753, 'CV. VERD', 'verd.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2383, 131754, 'Universitas Mulawarman', 'unmul.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(2384, 131755, 'PT Axarva Media Teknologi', 'axarva.co.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(2385, 131757, 'Koperasi PRIMKOKAS', 'primkokas.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2386, 131758, 'PT. Bali Ning', 'ning.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2387, 131759, 'PT. Web Data Solusindo', 'wds.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2388, 131760, 'Premier oil Indonesia', 'premier-oil.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2389, 131761, 'PT Pelabuhan Indonesia II', 'indonesiaport.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2390, 131762, 'PT. VOLTRAS International', 'voltras.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2391, 131763, 'Universitas Tadulako', 'kaili-network.net', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(2392, 131765, 'Kementerian Dalam Negeri Republik Indonesia', 'depdagri.go.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2393, 131767, 'PT. SOLO JALA BUANA', 'solonet.net.id', 'ID', 1536, 'business', '0000-00-00 00:00:00', 0),
(2394, 131769, 'PT Mayatama Solusindo', 'mayatama.net', 'ID', 3584, 'isp', '0000-00-00 00:00:00', 0),
(2395, 131772, 'PT Mitra Persada Lentera Sejahtera', 'mpls.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2396, 131773, 'PT WISUANDHA NETWORK GLOBALINDO', 'apjii.or.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2397, 131775, 'PT. Jupiter Jala Arta', 'jalanet.co.id', 'ID', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2398, 131776, 'Lembaga Penerbangan dan Antariksa Nasional (LAPAN)', 'lapan.go.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2399, 131778, 'PT Dian Nuswantoro Teknologi', 'dinustech.com', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(2400, 131779, 'Bidang Data dan Sarana Informasi (BDSI) Sekjen DPR RI', 'dpr.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2401, 13178, 'LLC Real-net', 'real-net.pro', 'FR', 18944, 'isp', '2008-03-25 08:03:47', 0),
(2402, 131780, 'PT Orion Cyber Internet', 'orion.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(2403, 131781, 'Universitas Islam Negeri Maulana Malik Ibrahin (UIN Maliki)', 'uin-malang.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(2404, 131782, 'Kementerian Badan Usaha Milik Negara', 'bumn.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2405, 131783, 'PT. Indomarco Prismatama', 'indomaret.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2406, 131784, 'Sumber Daya Dan Perangkat Pos Dan Informatika SIMS', 'postel.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2407, 131785, 'Mahkamah Agung RI', 'mahkamahagung.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2408, 131787, 'Keltron House', 'keltron.org', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2409, 131790, 'SANOFI-SG', 'sanofi.com', 'SG', 66048, 'business', '0000-00-00 00:00:00', 0),
(2410, 13180, 'CEDACRI S.P.A.', 'cedacri.it', 'IT', 1536, 'business', '2002-09-23 15:44:56', 0),
(2411, 13181, 'ISPE Design and Consulting SA', 'ispe.ro', 'RO', 256, 'business', '0000-00-00 00:00:00', 0),
(2412, 13182, 'Made Network Srl', 'madenetwork.it', 'IT', 8192, 'business', '0000-00-00 00:00:00', 0),
(2413, 13183, 'Intesa Sanpaolo S.p.A.', 'intesasanpaolo.com', 'IT', 4096, 'business', '0000-00-00 00:00:00', 0),
(2414, 13185, 'FSBE Institution of HE \"I.S. TURGENEV Orlovsky STATE UNIVERSITY\"', 'univ-orel.ru', 'RU', 512, 'education', '0000-00-00 00:00:00', 0),
(2415, 13187, 'Lanxess Deutschland GmbH', 'lanxess.de', 'DE', 256, 'business', '2001-12-30 01:19:42', 0),
(2416, 13188, 'CONTENT DELIVERY NETWORK LTD', 'triolan.com.ua', 'UA', 410624, 'isp', '2002-07-26 15:13:05', 0),
(2417, 13189, 'Liden Data Internetwork AB', 'lidero.net', 'SE', 79872, 'isp', '2002-09-16 08:07:34', 0),
(2418, 131891, 'Cebu Air Inc.', 'cebupacificair.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(2419, 131893, 'RICOH Company, Ltd.', 'ricoh.com', 'JP', 6656, 'isp', '0000-00-00 00:00:00', 0),
(2420, 131894, 'UNIADEX, LTD.', 'uniadex.co.jp', 'JP', 256, 'isp', '0000-00-00 00:00:00', 0),
(2421, 131895, 'Okinawa Institute of science and technology', 'oist.jp', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2422, 131896, 'SSI Lab Inc.', 'ssilab.net', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2423, 131897, 'National University Corporation ,Ehime University', 'ehime-u.ac.jp', 'JP', 65536, 'education', '0000-00-00 00:00:00', 0),
(2424, 131899, 'DIG Inc.', 'diginc.jp', 'JP', 20992, 'business', '0000-00-00 00:00:00', 0),
(2425, 13190, 'Cryptoshell AG', 'cryptoshell.li', 'LI', 1024, 'business', '2015-09-18 08:13:58', 0),
(2426, 131901, 'FIDESSA KK', 'fidessa.com', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2427, 131903, 'Nomura Research Institute,Ltd.', 'nri.com', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2428, 131904, 'Cyber Feel Inc.', 'cyberfeel.net', 'JP', 1280, 'business', '0000-00-00 00:00:00', 0),
(2429, 131905, 'Japan Registry Services Co., Ltd.', 'jprs.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2430, 131906, 'Gap Japan K.K.', 'gap.co.jp', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2431, 131907, 'Iwami Cablevision Co.,Ltd.', 'iwamicatv.jp', 'JP', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2432, 131909, 'C&C OKINAWA', 'okinawacloud.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(2433, 131910, 'SORACOM. INC.', 'soracom.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2434, 131911, 'HONJYO CABLE VISION CO., LTD.', 'catnet.jp', 'JP', 9216, 'isp', '0000-00-00 00:00:00', 0),
(2435, 131912, 'Cybozu,Inc.', 'cybozu.co.jp', 'JP', 1280, 'business', '0000-00-00 00:00:00', 0),
(2436, 131913, 'Niigata ken', 'niigata.lg.jp', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2437, 131914, 'data dock Inc.', 'datadock.co.jp', 'JP', 4608, 'business', '0000-00-00 00:00:00', 0),
(2438, 131915, 'Hamamatsu Cable Television .Inc', 'hctnet.ne.jp', 'JP', 20480, 'isp', '0000-00-00 00:00:00', 0),
(2439, 131916, 'Tokyo Bay Network Co.,Ltd.', 'baynet.ne.jp', 'JP', 22528, 'isp', '0000-00-00 00:00:00', 0),
(2440, 131917, 'Toshiba I.S. corp', 'toshiba.co.jp', 'JP', 768, 'business', '0000-00-00 00:00:00', 0),
(2441, 131918, 'SHONAN CABLE NETWORK', 'scn-net.ne.jp', 'JP', 38912, 'business', '0000-00-00 00:00:00', 0),
(2442, 131919, 'Meiji University', 'meiji.ac.jp', 'JP', 65536, 'education', '0000-00-00 00:00:00', 0),
(2443, 13192, 'dFactory Sarl.', 'cbsi.com', 'RU', 1280, 'business', '0000-00-00 00:00:00', 0),
(2444, 131920, 'WirelessGate, Inc.', 'wirelessgate.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2445, 131921, 'GMO CLOUD K.K.', 'gmocloud.com', 'JP', 80128, 'hosting', '0000-00-00 00:00:00', 0),
(2446, 131923, 'Mihara Cable Television Ltd.', 'mcat.co.jp', 'JP', 10240, 'isp', '0000-00-00 00:00:00', 0),
(2447, 131924, 'Kansai Airports', 'None', 'JP', 256, 'hosting', '0000-00-00 00:00:00', 0),
(2448, 131925, 'FAMILY NET JAPAN INCORPORATED', 'fnj.co.jp', 'JP', 15360, 'isp', '0000-00-00 00:00:00', 0),
(2449, 131926, 'Cable Television Saiki Co. , Ltd.', 'saiki.tv', 'JP', 10240, 'isp', '0000-00-00 00:00:00', 0),
(2450, 131927, 'TV Matsumoto Cablevision', 'tvm.co.jp', 'JP', 26624, 'isp', '0000-00-00 00:00:00', 0),
(2451, 131928, 'Tottori Teletopia Co., Ltd.', 'None', 'JP', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2452, 131929, 'Yamanashi CATV Co,. ltd', 'fruits.jp', 'JP', 2048, 'business', '0000-00-00 00:00:00', 0),
(2453, 13193, 'Nerim SAS', 'nerim.fr', 'FR', 118272, 'isp', '2002-09-13 10:04:26', 0),
(2454, 131930, 'Tokyo Broadcasting System Television, Inc.', 'tbs.co.jp', 'JP', 65536, 'business', '0000-00-00 00:00:00', 0),
(2455, 131931, 'Aomori Cable TV Co., Ltd.', 'actv.ne.jp', 'JP', 10240, 'isp', '0000-00-00 00:00:00', 0),
(2456, 131932, 'JR East Information Systems Company', 'jreast.co.jp', 'JP', 327680, 'business', '0000-00-00 00:00:00', 0),
(2457, 131933, 'TAMA Television Co., Ltd', 'ttv.co.jp', 'JP', 8192, 'isp', '0000-00-00 00:00:00', 0),
(2458, 131934, 'ICC Corporation', 'icc-media.co.jp', 'JP', 26624, 'isp', '0000-00-00 00:00:00', 0),
(2459, 131936, 'UNIVERSAL MUSIC LLC', 'universal-music.co.jp', 'JP', 2304, 'business', '0000-00-00 00:00:00', 0),
(2460, 131937, 'Joetsu Cable Vision', 'jcv.co.jp', 'JP', 22528, 'isp', '0000-00-00 00:00:00', 0),
(2461, 131938, 'NISSAN MOTOR CO.,LTD.', 'nissan.co.jp', 'JP', 49152, 'business', '0000-00-00 00:00:00', 0),
(2462, 131939, 'IPS INC', 'ipsism.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2463, 13194, 'UAB Bite Lietuva', 'bi.lt', 'LT', 94464, 'isp', '2002-06-26 09:09:55', 0),
(2464, 131940, 'Nissho Electronics Corp.', 'nissho-ele.co.jp', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(2465, 131941, 'Entsu Co.,Ltd.', 'None', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2466, 131942, 'Gurunavi, Inc.', 'gnavi.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2467, 131943, 'Goto tv', 'goto-tv.com', 'JP', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2468, 131944, 'KADOKAWA DWANGO CORPORATION', 'kadokawa.co.jp', 'JP', 768, 'business', '0000-00-00 00:00:00', 0),
(2469, 131945, 'Sanntuu Corporation', 'sanntsu.com', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2470, 131946, 'MUSASHINO UNIVERSITY E.F.', 'musashino-u.ac.jp', 'JP', 512, 'education', '0000-00-00 00:00:00', 0),
(2471, 131949, 'General Incorporated Foundation Aso Telework Center', 'aso.ne.jp', 'JP', 6144, 'business', '0000-00-00 00:00:00', 0),
(2472, 13195, 'Ingenieria y Economia del Transporte, S.A', 'ineco.com', 'ES', 512, 'business', '2001-11-16 17:26:11', 0),
(2473, 131950, 'EnjoyVC Japan Corporation', 'enjoyvc.com', 'JP', 1536, 'business', '0000-00-00 00:00:00', 0),
(2474, 131951, 'Suzuyo Shinwart Corporation', 'None', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2475, 131952, 'Asahikawa Cable Television Co., Ltd.', 'hokkai.net', 'JP', 13824, 'isp', '0000-00-00 00:00:00', 0),
(2476, 131954, 'Kawaguchiko cable television Inc', 'lcnet.jp', 'JP', 5120, 'isp', '0000-00-00 00:00:00', 0),
(2477, 131957, 'MicroAd, Inc.', 'microad.co.jp', 'JP', 1536, 'business', '0000-00-00 00:00:00', 0),
(2478, 131958, 'Tama Cable Network Co.,Ltd.', 'tcnnet.co.jp', 'JP', 17920, 'isp', '0000-00-00 00:00:00', 0),
(2479, 131959, 'YOU Communications Corporation', 'netyou.jp', 'JP', 37376, 'isp', '0000-00-00 00:00:00', 0),
(2480, 131960, 'MBO holdings Inc.', 'ixnet.jp', 'JP', 8192, 'isp', '0000-00-00 00:00:00', 0),
(2481, 131961, 'Dokkyo University', 'dokkyo.ac.jp', 'JP', 1024, 'education', '0000-00-00 00:00:00', 0),
(2482, 131963, 'MC Digital Realty, Inc.', 'mc-digitalrealty.com', 'JP', 4096, 'business', '0000-00-00 00:00:00', 0),
(2483, 131964, 'FAMILYNET JAPAN CORPORATION', 'None', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(2484, 131965, 'Xserver Inc.', 'xserver.co.jp', 'JP', 2048, 'business', '0000-00-00 00:00:00', 0),
(2485, 131969, 'Suzuyo Shinwart Corporation', 'None', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2486, 13199, 'Jaroslav Doubrava', 'doubrava.net', 'CZ', 1024, 'business', '2015-09-16 13:24:56', 0),
(2487, 131993, 'QUINNOX-IN', 'quinnox.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2488, 131994, 'Deutsche Bank AG', 'db.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2489, 131995, 'XLPM', 'xlpm.nc', 'NC', 1024, 'business', '0000-00-00 00:00:00', 0),
(2490, 131996, 'NEVIGATE GLOBAL NETWORK SDN. BHD.', 'nevigate.net', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(2491, 131998, 'Ticketmaster Australasia', 'ticketmaster.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2492, 131999, 'Lateral Plains Pty Ltd', 'lateralplains.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2493, 132, 'Air Force Systems Networking', 'af.mil', 'US', 329216, 'isp', '1987-10-15 00:00:00', 0),
(2494, 13200, 'Banco BPI SA', 'bancobpi.pt', 'PT', 512, 'business', '0000-00-00 00:00:00', 0),
(2495, 132000, 'Hansen Corporation Pty Ltd', 'hansencx.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2496, 132001, 'Vital Data Ltd', 'vital.co.nz', 'NZ', 256, 'isp', '0000-00-00 00:00:00', 0),
(2497, 132003, 'Network Research Lab', 'vuw.ac.nz', 'NZ', 1024, 'education', '0000-00-00 00:00:00', 0),
(2498, 132004, 'Touch Net India Pvt. Ltd.', 'touchnetindia.net', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(2499, 132005, '209, Laxmi Plaza', 'oriensoft.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(2500, 132006, 'Domicilium (IOM) Ltd', 'domicilium.com', 'GB', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2501, 132007, 'DataWave Internet Pty Ltd', 'datawave.net.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2502, 132013, 'True Internet assigned for ICS', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2503, 132015, 'ITonCloud', 'itoncloud.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2504, 132016, 'IRESS Market Technology Ltd', 'iress.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2505, 132017, 'Kartina World Llp', 'kartina.tv', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2506, 132018, 'Event Zero', 'paxnet.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2507, 13202, 'Production Company POLISAN Ltd.', 'sim.net.ua', 'UA', 512, 'business', '2002-01-09 11:44:53', 0),
(2508, 132020, 'NineWire Pty Ltd', 'ninewire.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2509, 132021, 'Kalibo Cable Television Network Inc', 'kalibo-cable.tv', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2510, 132022, 'IP World Technologies Sdn. Bhd.', 'ipwtech.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(2511, 132023, 'Greenfields Internet Limited', 'greenfields.net.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(2512, 132025, 'TOMNET ISP Co.,LTD', 'tomnet.com.kh', 'KH', 768, 'isp', '0000-00-00 00:00:00', 0),
(2513, 132027, 'Hastings District Council', 'hdc.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2514, 132028, 'Aspire Systems India Private Ltd', 'aspiresys.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2515, 132029, 'Telstra Pty Ltd.', 'telstra.net', 'AU', 74496, 'isp', '0000-00-00 00:00:00', 0),
(2516, 132030, 'VEOLIA ENVIRONMENTAL SERVICES (AUSTRALIA) PTY LTD', 'veoliaes.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2517, 132031, 'Taylor Communications Ltd', 'taylorbroadband.co.nz', 'NZ', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2518, 132032, 'Total Access Communication PLC.', 'dtac.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2519, 132033, 'ECSNET-MY', 'ecsm.com.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(2520, 132035, 'Computer Center', 'uum.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(2521, 132037, 'HO\'NGSA\' TELECOM COMPANY LIMITED', 'myhongsa.net', 'MM', 768, 'business', '0000-00-00 00:00:00', 0),
(2522, 132038, 'PGi', 'pgi.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2523, 13204, 'TERA YATIRIM MENKUL DEGERLER A.S.', 'terayatirim.com', 'TR', 1024, 'business', '2015-09-16 12:00:33', 0),
(2524, 132040, 'Vital Data Ltd', 'vital.co.nz', 'NZ', 7168, 'isp', '0000-00-00 00:00:00', 0),
(2525, 132043, 'MHSDC2011', 'maharashtra.gov.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2526, 132044, 'HEALTHE CARE AUSTRALIA PTY LTD', 'healthecare.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2527, 132045, 'Bharti Airtel Lanka Pvt. Limited', 'airtel.com', 'LK', 15360, 'isp', '0000-00-00 00:00:00', 0),
(2528, 132046, '3705 West of ayala, 252 Sen Gil Puyat Avenue', 'thesunbridge.com', 'PH', 6656, 'business', '0000-00-00 00:00:00', 0),
(2529, 13205, 'British Telecommunications PLC', 'btplc.com', 'GB', 17408, 'isp', '0000-00-00 00:00:00', 0),
(2530, 132052, 'NIL-36C, Malviya Nagar', 'cyberspace.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2531, 132053, 'Qualcomm Inc', 'qualcomm.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2532, 132054, 'Rising Star Cable TV Services', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2533, 132055, 'Ernst & Young Global Services Ltd.', 'ey.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2534, 132056, 'SCICUBE', 'scicube.com', 'HK', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(2535, 132057, 'REDI Technologies Hong Kong Limited', 'redi.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2536, 132059, '762 Quirino Highway, San Bartolome', 'None', 'PH', 768, 'hosting', '0000-00-00 00:00:00', 0),
(2537, 132061, 'Realmove Company Limited', 'truecorp.co.th', 'TH', 51456, 'isp', '0000-00-00 00:00:00', 0),
(2538, 132063, 'KITTI BOONMEE', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2539, 132064, 'Intervolve Pty Ltd', 'intervolve.com.au', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(2540, 132066, 'New Plymouth District Council', 'npdc.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2541, 132071, 'Intervolve Pty Ltd', 'intervolve.com.au', 'AU', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2542, 132075, 'Tech Mahindra Business Services Limited', '3globalservices.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2543, 132077, 'Fortescue Metals Group Ltd', 'fmgl.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2544, 13208, 'Newtel Limited', 'newtel.je', 'GB', 7936, 'isp', '2002-07-26 10:44:43', 0),
(2545, 132080, 'M.A.T Co., Ltd.', 'None', 'KH', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2546, 132082, 'Global Infosys Limited', 'globalinfosys.et', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2547, 132083, 'FOUNDATION CLOUD SERVICES LIMITED', 'foundationpartners.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(2548, 132084, '5201 Great America Pkwy # 120', 'dimensiondata.com', 'AU', 10752, 'business', '0000-00-00 00:00:00', 0),
(2549, 132088, 'Wind Cloud Network Technology Co Ltd', 'as132088.net', 'MO', 512, 'business', '0000-00-00 00:00:00', 0),
(2550, 132089, 'XAVIENT SOFTWARE SOLUTION(INDIA) PRIVATE LIMITED', 'xavient.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2551, 13209, 'Atom Hosting SRL', 'atom-hosting.com', 'RO', 768, 'hosting', '2010-09-15 14:03:24', 0),
(2552, 132090, 'Mify Solutions Pvt. Ltd.', 'move2inbox.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2553, 132092, 'Mir Mosharrof Hossain t/a IT Base', 'itbasebd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2554, 132093, 'The Royal Womens Hospital', 'thewomens.org.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2555, 132094, 'Kritikos Solutions Pty Ltd', 'ksol.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2556, 132095, 'HEWLETT PACKARD-SHINSUNA COLO', 'hp.com', 'JP', 4096, 'business', '0000-00-00 00:00:00', 0),
(2557, 132097, 'BUPA Australia Health Pty Ltd', 'bupa.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2558, 132098, 'SATURN HOLDINGS LIMITED', 'unwire.us', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(2559, 132099, 'E.B Solutions Ltd.', 'ebsbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2560, 1321, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 2816, 'isp', '1994-11-23 00:00:00', 0),
(2561, 13210, 'ACADEMIA DE STUDII ECONOMICE', 'ase.ro', 'RO', 1536, 'education', '0000-00-00 00:00:00', 0),
(2562, 132100, 'Myanmar Speed Net Co.,Ltd', 'mmspeednet.com', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2563, 132102, 'ALHGROUP-AU', 'alhgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2564, 132107, 'Cloudpower Solutions', '2s1n.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(2565, 132108, 'ISSL', 'issl.co.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(2566, 132111, 'Bigband Sdn Bhd', 'bigband.net.my', 'MY', 8960, 'hosting', '0000-00-00 00:00:00', 0),
(2567, 132113, 'Connected Australia PTY LTD', 'connectedoz.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2568, 132116, 'Ani Network Pvt Ltd', 'aninetwork.in', 'IN', 39424, 'isp', '0000-00-00 00:00:00', 0),
(2569, 132117, 'Ministry of Interior', 'moi.go.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(2570, 132119, 'BNP Paribas', 'bnpparibas.com', 'JP', 4096, 'business', '0000-00-00 00:00:00', 0),
(2571, 132121, 'HP-ENTERPRISE CLOUD SERVICES', 'hp.com', 'IN', 4096, 'business', '0000-00-00 00:00:00', 0),
(2572, 132123, 'Portonics Limited', 'portonics.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(2573, 132124, 'Information and Communication Technology Agency of Sri Lanka', 'icta.lk', 'LK', 2048, 'business', '0000-00-00 00:00:00', 0),
(2574, 132125, 'Braintrust Ltd', 'braintrust.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2575, 132129, 'Sysland Speed Online Network', 'syslandonline.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2576, 13213, 'UK-2 Limited', 'uk2group.com', 'GB', 105728, 'hosting', '2002-06-25 16:55:14', 0),
(2577, 132130, 'TRIKO SECURITY LIMITED', 'triko.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2578, 132132, 'MyRepublic Ltd.', 'myrepublic.net', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2579, 132133, 'SB.Furniture House Co.,Ltd', 'sb-furniture.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(2580, 132134, 'SpotXchange, Inc', 'spotxchange.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2581, 132135, 'Hero MotoCorp Ltd', 'heromotocorp.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2582, 132136, 'Bremmar Communications Pty Ltd', 'bremmar.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2583, 132137, 'Shree Omkar Infocom Pvt Ltd', 'soipl.co.in', 'IN', 10496, 'isp', '0000-00-00 00:00:00', 0),
(2584, 132138, 'THE GREX GROUP PTY LTD', 'thegrexgroup.com', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2585, 132139, 'VECLOUD LIMITED', 'vecloud.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2586, 13214, 'Hans Fredrik Lennart Neij', 'dcpnetworks.net', 'SE', 2816, 'business', '2008-02-18 08:30:31', 0),
(2587, 132141, 'Penthouse', 'chikka.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(2588, 132142, 'ZONE Telecom Pte Ltd', 'zonetel.com.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(2589, 132143, 'Harbour City Security Limited', 'alarm.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(2590, 132144, 'GPX', 'gpxglobal.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2591, 132145, 'DC Two Pty Ltd', 'dctwo.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(2592, 132146, 'Rich Top EC Limited', 'richtopec.com', 'HK', 9728, 'business', '0000-00-00 00:00:00', 0),
(2593, 132147, 'CT-SHANXI-MAN', 'shanxitele.com', 'CN', 12544, 'business', '0000-00-00 00:00:00', 0),
(2594, 132148, 'HORIZON TELECOM INTERNATIONAL COMPANY LIMITED', 'telecom-horizon.com', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2595, 13215, 'CJSC TK Convey Plus', 'cplus.ru', 'RU', 2560, 'business', '2001-09-24 06:02:38', 0),
(2596, 132150, 'ValueLabs Technologies', 'valuelabs.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2597, 132151, 'NAVIGANT BPM (INDIA) PRIVATE LIMITED', 'navigantbpm.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2598, 132152, 'Persistent System Ltd', 'persistent.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2599, 132153, 'CT-SHANXI-MAN-2', 'shanxitele.com', 'CN', 6144, 'business', '0000-00-00 00:00:00', 0),
(2600, 132158, 'Australian Synchrotron', 'synchrotron.org.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(2601, 13216, 'C5 IT Services (Guernsey) Limited', 'itex-ci.net', 'GB', 9216, 'business', '2002-02-08 09:35:48', 0),
(2602, 132160, 'SPEEDCAST AUSTRALIA PTY LIMITED', 'speedcast.com', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(2603, 132161, 'LAYERX CLOUD LIMITED', 'vgrid.nz', 'NZ', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2604, 132162, 'SANTOS WA ENERGY LIMITED', 'energylimited.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2605, 132164, 'Kaskus Networks', 'kaskusnetworks.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2606, 132165, 'Connect Communications', 'connect.net.pk', 'PK', 262144, 'isp', '0000-00-00 00:00:00', 0),
(2607, 132166, 'Rida Communication Private Limited', 'ridaonline.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2608, 132167, 'OOREDOO MYANMAR', 'ooredoo.com.mm', 'MM', 8704, 'isp', '0000-00-00 00:00:00', 0),
(2609, 132168, 'ESUN TECHNOLOGY INTERNATIONAL CO., LIMITED', 'esun21.com', 'HK', 3328, 'business', '0000-00-00 00:00:00', 0),
(2610, 132169, 'Kbz Online', 'kbzonlineisp.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(2611, 132170, 'Exitra Sdn. Bhd.', 'exitra.com.my', 'MY', 768, 'business', '0000-00-00 00:00:00', 0),
(2612, 132172, 'Fiscal Policy Office', 'fpo.go.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(2613, 132173, 'Streamlink Communications', 'None', 'AF', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2614, 132193, 'Social Security System', 'sss.gov.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(2615, 132196, 'DANAWA RESOURCES SDN BHD', 'danawa.com.my', 'MY', 4864, 'isp', '0000-00-00 00:00:00', 0),
(2616, 132197, 'SKALI', 'skali.net', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(2617, 132198, 'iCore Technology Sdn Bhd', 'icore.com.my', 'MY', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2618, 132199, 'Globe Telecom Inc.', 'globe.com.ph', 'PH', 279808, 'isp', '0000-00-00 00:00:00', 0),
(2619, 132201, 'Land and Houses Bank Public Company Limited', 'lhbank.co.th', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(2620, 132203, 'Tencent Building, Kejizhongyi Avenue', 'tencent.com', 'CN', 552960, 'hosting', '0000-00-00 00:00:00', 0),
(2621, 132205, 'YARRA CITY COUNCIL', 'yarracity.vic.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2622, 132206, 'ePLDT Inc.', 'epldt.com', 'PH', 4608, 'isp', '0000-00-00 00:00:00', 0),
(2623, 132208, 'NGBPS LTD.', 'ngbps.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2624, 132209, 'IP-Converge Data Center, Inc.', 'ip-converge.com', 'PH', 2048, 'business', '0000-00-00 00:00:00', 0),
(2625, 132210, 'ReignICT', 'reignict.com', 'BD', 2304, 'isp', '0000-00-00 00:00:00', 0),
(2626, 132212, 'ACRE COMPUTER SERVICES LIMITED', 'acrepc.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(2627, 132215, 'Power Grid Corporation of India Limited', 'powergridindia.com', 'IN', 16128, 'isp', '0000-00-00 00:00:00', 0),
(2628, 132216, 'Comilla University', 'None', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(2629, 132217, 'Virgin Australia Airlines Pty Ltd', 'virginaustralia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2630, 132218, 'Maldives Customs Service', 'customs.gov.mv', 'MV', 256, 'business', '0000-00-00 00:00:00', 0),
(2631, 132219, 'Ministry of Maori Development (Te Puni Kokiri)', 'tpk.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2632, 132220, 'JPR Digital Pvt. Ltd.', 'jprdigital.in', 'IN', 21760, 'isp', '0000-00-00 00:00:00', 0),
(2633, 132222, 'Sanzar F Kakar T/A Afghanistan Holding Group', 'ahg.af', 'AF', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2634, 132228, 'Vanuatu Government', 'gov.vu', 'VU', 512, 'isp', '0000-00-00 00:00:00', 0),
(2635, 132229, '8F Tower 2 The Rockwell Business Center', 'trendmicro.com.ph', 'PH', 768, 'business', '0000-00-00 00:00:00', 0),
(2636, 13223, 'CONSEIL DE L EUROPE', 'conse.it', 'FR', 1024, 'business', '0000-00-00 00:00:00', 0),
(2637, 132230, 'Australian Hearing Services T/A Australian Hearing', 'hearing.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2638, 132232, 'Data Centre Services', 'dcs.bt', 'BT', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2639, 132233, 'NCR Network Technology International Limited', 'ncr-network.com', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(2640, 132236, 'NEC ASIA PACIFIC PTE LTD', 'nec.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2641, 132238, 'CAMHR INFORMATION(CAMBODIA) Co.,LTD', 'None', 'KH', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2642, 132239, 'Envestnet Asset Management India Pvt. Ltd', 'envestnet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2643, 13224, 'NairobiNet Online', 'nbnet.co.ke', 'KE', 8192, 'isp', '2010-02-11 00:00:00', 0),
(2644, 132240, 'Plan-b Ltd', 'planb.co.nz', 'NZ', 1536, 'business', '0000-00-00 00:00:00', 0),
(2645, 132241, 'SKSA TECHNOLOGY SDN BHD', 'internet-webhosting.com', 'MY', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2646, 132242, 'Hogarth Worldwide Pte', 'hogarthww.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2647, 132245, 'Data Express Pty Ltd', 'dataexpress.net.au', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(2648, 132246, 'ST. LUKE\'S MEDICAL CENTER, INC.', 'stluke.com.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(2649, 132248, 'Reserve Bank of Fiji', 'rbf.gov.fj', 'FJ', 256, 'business', '0000-00-00 00:00:00', 0),
(2650, 13225, 'Renaissance Capital Financial Consultant OOO', 'rencap.com', 'RU', 512, 'business', '0000-00-00 00:00:00', 0),
(2651, 132250, 'Princess of Naradhiwas University', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(2652, 132252, 'HKMPCL-HK', 'hkmpcl.com.hk', 'HK', 4352, 'business', '0000-00-00 00:00:00', 0),
(2653, 132253, '79 Robinson Road', 'cpf.gov.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2654, 132254, 'PRIMA DC LIMITED', 'primadc.com', 'VU', 512, 'business', '0000-00-00 00:00:00', 0),
(2655, 132255, 'PrimoWireless Ltd', 'primowireless.co.nz', 'NZ', 6656, 'isp', '0000-00-00 00:00:00', 0),
(2656, 132256, 'CGI Technologies and Solutions Australia Pty Ltd', 'cgi.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2657, 132257, 'Area9 IT Solutions', 'area9.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2658, 13226, 'CYBERNET SA', 'cybernet.be', 'BE', 8192, 'isp', '0000-00-00 00:00:00', 0),
(2659, 132260, 'SATSOL LIMITED', 'satsol.net', 'SB', 256, 'isp', '0000-00-00 00:00:00', 0),
(2660, 132263, 'Sportingbet Australia Pty Ltd', 'sportingbet.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2661, 132264, 'Callaghan Innovation', 'callaghaninnovation.govt.nz', 'NZ', 9984, 'business', '0000-00-00 00:00:00', 0),
(2662, 132265, 'Singapore Airlines Limited', 'singaporeair.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2663, 132267, 'NovoCom Limited', 'novocom-bd.com', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(2664, 132268, 'Velocity Net Limited', 'velocitynet.co.nz', 'NZ', 2560, 'isp', '0000-00-00 00:00:00', 0),
(2665, 132269, 'CommSphere', 'commsphere.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2666, 13227, 'Kraft-S LLC', 'kraft-s.ru', 'RU', 16384, 'business', '2002-06-06 07:28:30', 0),
(2667, 132270, 'Nabil Bank Limited', 'nabilbank.com', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(2668, 132272, 'TRIJIT TECHNOLOGIES PVT LTD', 'trijit.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2669, 132277, 'XTRA-COMMUNICATION-SG', 'xtracommunication.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(2670, 132278, 'Chemoil Information Services Private Limited', 'chemoil.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2671, 132279, 'Automatic Data Processing Limited', 'adp.com', 'AU', 3328, 'business', '0000-00-00 00:00:00', 0),
(2672, 132280, 'Symphony Communication (Thailand) PCL.', 'symphony.net.th', 'TH', 64256, 'isp', '0000-00-00 00:00:00', 0),
(2673, 132281, 'China Unicom (Singapore) Operations Pte Ltd', 'chinaunicom.cn', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2674, 132282, 'Guavus Network Systems Private Limited', 'guavus.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2675, 132284, 'Radio New Zealand', 'radionz.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2676, 132295, 'Jahid Communication', 'jahidcommunication.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(2677, 132296, 'Seven Star Digital Network Private Limited', '7stardigitalnetwork.com', 'IN', 12032, 'isp', '0000-00-00 00:00:00', 0),
(2678, 132298, 'Antaranga Dot Com Ltd', 'antbd.net', 'BD', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2679, 132299, 'Applied Satellite Technology Australia Pty Ltd', 'asta.net.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2680, 1323, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 256, 'isp', '1994-11-23 00:00:00', 0),
(2681, 132303, 'Tata Sky Ltd', 'tatasky.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2682, 132304, 'CLOUDEST (HK) LIMITED', 'None', 'HK', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(2683, 132305, 'First Communication Limited', 'firstcom-bd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2684, 132306, 'MOS 5 TEL LIMITED', 'mos5tel.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2685, 132308, 'CONDUENT BUSINESS SERVICES INDIA LLP', 'conduent.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2686, 132309, '6Y\'S Pty Ltd', '6ys.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(2687, 13231, 'Baharan PLC', 'baharan.ir', 'IR', 1024, 'business', '2012-05-31 05:58:55', 0),
(2688, 132310, 'ED & F Man Capital Markets Hong Kong Limited', 'edfmancapital.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2689, 132313, 'Uber Technologies Limited', 'uber.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2690, 132315, 'Intillismart Pty Ltd', 'intillismart.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2691, 13232, 'Portigon AG', 'portigon-ag.de', 'DE', 768, 'business', '2002-07-23 09:42:14', 0),
(2692, 132321, 'Northern Territory Government', 'nt.gov.au', 'AU', 131072, 'business', '0000-00-00 00:00:00', 0),
(2693, 132322, 'Good Domain Registry Private Limited', 'gooddomainregistry.com', 'IN', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(2694, 132323, 'PERFECT INTERNET PVT.LTD', 'perfectinternet.in', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2695, 132326, 'F1CSB-NET-MY', 'f1.net.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(2696, 132327, 'Allianz Global Investors GMBH', 'allianzinvestors.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2697, 132329, 'Firstsource Solutions Ltd', 'firstsource.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2698, 13233, '21TORR GmbH', '21torr.com', 'DE', 8192, 'business', '2002-05-28 06:45:52', 0),
(2699, 132330, 'Hillsong International Ltd', 'hillsong.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2700, 132334, '51 Changi Business Park Central 2', 'ilm.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2701, 132335, 'LeapSwitch Networks Pvt Ltd', 'leapswitch.com', 'IN', 26368, 'hosting', '0000-00-00 00:00:00', 0),
(2702, 132337, 'ALPHA NETWORKS SOLUTION PTE. LTD.', 'alphanetworks.com.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2703, 132338, 'HP Global Soft Pvt Ltd', 'hp.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2704, 132339, 'CEL TELECOM LTD', 'celtelecom-bd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2705, 132340, 'Venus Telecom Limited', 'venustelco.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2706, 132341, 'Digicon Telecommunication Ltd', 'digicontel.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2707, 132342, 'Fidessa ltd', 'fidessa.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2708, 132343, 'SUN TV NETWORK LIMITED', 'sunnetwork.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2709, 132344, 'SEANET', 'seanetmsc.com', 'MM', 2048, 'business', '0000-00-00 00:00:00', 0),
(2710, 132345, 'The Friends School', 'friends.tas.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(2711, 132346, 'SPICITY', 'spi.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2712, 132347, 'MikiPro Ltd', 'mikipro.co.nz', 'NZ', 3328, 'isp', '0000-00-00 00:00:00', 0),
(2713, 132349, 'Mylan Laboratories Ltd', 'mylan.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2714, 13235, 'Nik Rayan Parsian Computer Services Cooperative Company', 'None', 'IR', 1024, 'hosting', '2015-09-16 09:13:44', 0),
(2715, 132351, 'National Payment Corporation Of India', 'npci.org.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2716, 132354, 'CELCOM TIMUR (SABAH) SDN BHD', 'ctsabah.com.my', 'MY', 1280, 'isp', '0000-00-00 00:00:00', 0),
(2717, 132355, 'TAL Services Limited', 'tal.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2718, 132356, 'Changi Airport Group (Singapore) Pte Ltd', 'changiairportgroup.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2719, 132359, 'RapidCloud (M) Sdn Bhd', 'rapidcloud.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(2720, 13236, 'DATACOM LTD', 'datacom.bg', 'BG', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2721, 132360, 'Service Stream Limited', 'servicestream.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2722, 132361, 'Citrix Systems Asia Pacific Pty Ltd', 'citrix.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2723, 132364, 'Level 16, Nexxus Buildings', 'executivecentre.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(2724, 132365, 'Bangladesh Agricultural University (BAU)', 'bau.edu.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(2725, 132368, 'AUDATEX AUSTRALIA PTY LTD', 'audatex.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2726, 132369, 'XIANGAO INTERNATIONAL TELECOMMUNICATION LIMITED', 'xiangao.com.hk', 'HK', 3072, 'business', '0000-00-00 00:00:00', 0),
(2727, 13237, 'euNetworks GmbH', 'eunetworks.de', 'DE', 575488, 'isp', '2002-09-19 14:55:08', 0),
(2728, 132370, 'Civica Pty Limited', 'civica.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2729, 132371, 'Solartis Technology Services Private Limited', 'solartis.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2730, 132372, 'GB Network Solutions Sdn. Bhd.', 'gbnetwork.my', 'MY', 3584, 'hosting', '0000-00-00 00:00:00', 0),
(2731, 132374, 'Layerstack Limited', 'layerstack.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(2732, 132376, 'BasketAsia, Sdn. Bhd.', 'persiasys.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(2733, 132377, 'Ellucian Company LP', 'ellucian.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2734, 132378, '44KM Stone, Delhi-Rohtak Road', 'merinoindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2735, 13238, 'YANDEX LLC', 'yandex.net', 'RU', 198912, 'isp', '2002-09-05 12:35:22', 0),
(2736, 132380, 'General Motors Thailand, Rayong', 'gm.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(2737, 132381, 'Future Net Solution', 'futurenet-bd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2738, 132382, 'Greenbay Communications Pty Ltd', 'greenbay.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2739, 132384, 'Deloitte Consulting India Pvt. Ltd', 'deloitte.com', 'IN', 2816, 'business', '0000-00-00 00:00:00', 0),
(2740, 132386, 'Usman Internet Service Provider Private Limited', 'None', 'PK', 512, 'hosting', '0000-00-00 00:00:00', 0),
(2741, 132387, 'Essar House,', 'essar.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2742, 132388, 'Intuit India Product Development Center Private Limited', 'intuit.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2743, 132389, 'China Mobile International Limited', 'chinamobile.com', 'AU', 256, 'isp', '0000-00-00 00:00:00', 0),
(2744, 132394, 'OpusV Technology Group', 'mikeit.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(2745, 132395, 'Unified National Networks', 'unn.com.bn', 'BN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2746, 132396, 'Federal Express Corporation Hong Kong Branch', 'fedex.com', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2747, 132397, 'PowerNET IT Consultants Pty Ltd', 'power-net.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2748, 132398, 'Science and Engineering Institutes', 'nscc.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2749, 132399, '26, rue de joinville', 'sita.aero', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(2750, 13240, 'TRENDLINE INFORMATION and COMMUNICATION SERVICES LTD', 'kavmanche.co.il', 'IL', 1024, 'business', '0000-00-00 00:00:00', 0),
(2751, 132400, 'COMMUNITY CABLE VISION CORPORATION', 'None', 'PH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2752, 132401, 'COMCAST INDIA ENGINEERING CENTER I LLP', 'None', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2753, 132402, '516 Clyde Ave US', 'bluejeans.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2754, 132404, 'Neda Telecommunications', 'neda.af', 'AF', 1280, 'isp', '0000-00-00 00:00:00', 0),
(2755, 132405, 'Summit Internet (Australia)', 'summitinternet.com.au', 'AU', 6400, 'isp', '0000-00-00 00:00:00', 0),
(2756, 132406, '8 Shenton Way', 'linkedin.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2757, 132407, 'Verisk Nepal Pvt. Ltd.', 'veriskdom.com', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(2758, 132409, 'Museum of New Zealand Te Papa Tongarewa', 'tepapa.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2759, 132413, 'First Data Resources Australia Limited', 'firstdata.com.au', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2760, 132414, 'First Data Resources Australia Limited', 'firstdata.com.au', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2761, 132415, 'JUSTDIAL', 'justdial.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2762, 132416, 'Discovery Technology Pty Ltd', 'discovery.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2763, 132417, 'IM-CVG-IN', 'netcracker.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2764, 132418, '1 Rue Royale FR', 'outscale.com', 'JP', 9216, 'isp', '0000-00-00 00:00:00', 0),
(2765, 132419, '1000 Alfred Nobel Drive US', 'bio-rad.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2766, 13242, 'Latvijas Lauksaimniecibas Universitate', 'llu.lv', 'LV', 4096, 'education', '2015-09-15 15:36:19', 0),
(2767, 132422, 'Hong Kong Telecom Global Data Centre', '31.com.hk', 'HK', 48128, 'hosting', '0000-00-00 00:00:00', 0),
(2768, 132423, 'Powai', 'iitb.ac.in', 'IN', 1024, 'education', '0000-00-00 00:00:00', 0),
(2769, 132424, 'Brambles Limited', 'chep.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2770, 132425, 'APC Hosting Pte Ltd', 'apc.sg', 'SG', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2771, 132426, 'Net2One Sdn Bhd', 'altel.my', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(2772, 132428, 'Quest Diagnostics HTAS India Pvt. Ltd.', 'questdiagnostics.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2773, 132429, 'Digicel Vanuatu LTD', 'digicelgroup.com', 'VU', 1280, 'isp', '0000-00-00 00:00:00', 0),
(2774, 13243, 'EVRY NORGE AS', 'evry.com', 'NO', 55808, 'isp', '2002-06-19 12:18:07', 0),
(2775, 132430, 'Adelaide Venue Management Corporation', 'avmc.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2776, 132433, 'KORE WIRELESS PTY LTD', 'korewireless.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2777, 132434, 'M-04-3A, Block M,', 'peering1.com', 'MY', 3072, 'business', '0000-00-00 00:00:00', 0),
(2778, 132435, 'SYMPHONET-MY', 'symphonet.com.my', 'MY', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2779, 132436, 'Wahidur Rahman Sharif T/A Tahoe Communication Limited', 'digicontechnologies.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2780, 132437, '10 Anson Road', 'saasplaza.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2781, 132438, 'Evan Ahmed Bhuiyan t/a APON IT', 'aponit.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2782, 13244, 'Rietumu banka AS', 'rietumu.lv', 'LV', 512, 'business', '2001-10-03 09:38:17', 0),
(2783, 132440, 'PMC-NET-IN', 'pmcbank.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2784, 132441, 'SHRI SAIBABA SANSTHAN TRUST, SHIRDI', 'sai.org.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2785, 132443, 'Southtech Limited', 'southtechlimited.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2786, 132445, 'Khetan Cable Network Pvt. Limited', 'khetanisp.com', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(2787, 132447, '234, Galle Road, Colombo 4', 'hutchison.lk', 'LK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2788, 132448, 'SolutionOne Pty Ltd', 'solution-one.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2789, 132449, 'Wireless Nation', 'wirelessnation.co.nz', 'NZ', 1792, 'business', '0000-00-00 00:00:00', 0),
(2790, 13245, 'Foltron LP', 'ddosnomore.me', 'NL', 1024, 'business', '2015-11-16 08:39:36', 0),
(2791, 132450, 'New Era IT Ltd', 'newerait.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(2792, 132451, '2142-1;KUKIOKA;MAEDA;', 'hpe.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(2793, 132453, 'TRIPLE PLAY BROADBAND PRIVATE LIMITED', 'tripleplay.in', 'IN', 17408, 'isp', '0000-00-00 00:00:00', 0),
(2794, 132454, 'Philippine Telegraph and Telephone Corporation,', 'ptt.net.ph', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2795, 13246, 'InterNetWire Communications GmbH', 'internetwire.de', 'DE', 3328, 'business', '2002-09-09 08:45:53', 0),
(2796, 132462, 'Bemobile Solomon Islands Ltd', 'bmobile.com.pg', 'SB', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2797, 132464, 'Barbaza Multi-Purpose Cooperative', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2798, 132468, 'SATSOL LIMITED', 'satsol.net', 'SB', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2799, 132469, 'Department of Primary Industries and Regional Development', 'dpird.wa.gov.au', 'AU', 4352, 'business', '0000-00-00 00:00:00', 0),
(2800, 13247, 'Erdenreich Datentechnik GmbH', 'erdenreich.net', 'DE', 11008, 'isp', '2009-01-12 12:47:07', 0),
(2801, 132470, 'NEXTRA', 'nextraworld.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2802, 132471, 'MTNAFGHANISTAN', 'mtn.com.af', 'AF', 5120, 'isp', '0000-00-00 00:00:00', 0),
(2803, 132472, '70 Bendemeer Road', 'auctorizium.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2804, 132473, 'RFGPL', 'rams.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2805, 132476, 'Compass Education Pty Ltd', 'compass.education', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(2806, 132480, 'Netze Technology Private Limited', 'netze.pk', 'PK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2807, 132481, 'Marsh & McLennan Companies, Inc.', 'marsh.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2808, 132482, 'Rajamangala University of Technology Rattanakosin', 'rmutr.ac.th', 'TH', 2048, 'education', '0000-00-00 00:00:00', 0),
(2809, 132484, 'LINK ADMINISTRATION HOLDINGS LIMITED', 'linkgroup.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(2810, 132485, 'Axis Securities Limited', 'axissecurities.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2811, 132486, 'OCEAN LINK LTD', 'oceanlinknet.com', 'KI', 512, 'isp', '0000-00-00 00:00:00', 0),
(2812, 13249, 'IT Systems LLC', 'itsystems.ua', 'UA', 9728, 'business', '2002-03-27 12:35:04', 0),
(2813, 132491, 'AFT Communications Pty Ltd', 'aftc.co', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(2814, 132493, 'Lampang-Meatha Rd., Thambon Chomphu Ampher Maung Lampang 52100', 'rit.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(2815, 132494, 'Universiti Tun Hussein Onn Malaysia', 'uthm.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(2816, 132497, 'DIGITAL NETWORK ASSOCIATES PRIVATE LIMITED', 'dnainfotel.com', 'IN', 8448, 'isp', '0000-00-00 00:00:00', 0),
(2817, 132498, 'ASPEDIA AUSTRALIA PTY LTD', 'aspedia.net', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2818, 132499, 'HKCOLO.NET LIMITED', 'hkcolo.net', 'HK', 2304, 'business', '0000-00-00 00:00:00', 0),
(2819, 1325, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 768, 'isp', '1994-11-23 00:00:00', 0),
(2820, 13250, 'Backbone Solutions AG', 'backbone.ch', 'CH', 8192, 'business', '2002-07-02 06:18:25', 0),
(2821, 132502, 'Payment Gateway of Bangladesh', 'dnsgroup.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2822, 132504, 'QUALITIA Co.,Ltd', 'transware.co.jp', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(2823, 132505, 'Concentrix Daksh Services Philippines Corporation', 'concentrix.com', 'PH', 1280, 'business', '0000-00-00 00:00:00', 0),
(2824, 132506, 'EXCHANGE ADVERTISING COMPANY', 'exadv.com.hk', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(2825, 132507, 'Helios IT Infra Solutions P Ltd', 'heliositinfra.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(2826, 132508, 'A GLOBAL CUSTOMER SERVICE ORGANIZATION,', 'pldt.com.ph', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2827, 132509, 'DIGIWEB ADVANCED HOSTING LIMITED', 'umbrellar.com', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2828, 13251, 'QiTEC GmbH', 'qitec.de', 'DE', 1792, 'business', '2002-03-14 07:35:53', 0),
(2829, 132510, 'IDC ShanXi China Mobile communications corporation', 'chinamobile.com', 'CN', 42240, 'isp', '0000-00-00 00:00:00', 0),
(2830, 132512, 'World Hub Communications (M) Sdn Bhd', 'worldhubcom.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(2831, 132513, 'Sky Telecom State Company', 'None', 'LA', 1792, 'hosting', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(2832, 132514, 'Ubon Ratchathani University,', 'ubu.ac.th', 'TH', 1024, 'education', '0000-00-00 00:00:00', 0),
(2833, 132515, 'Maximo Infotech', 'sparkbroadband.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2834, 132516, 'Pacenet Meghbela Broadband Pvt. Ltd.', 'pmplbroadband.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2835, 132518, 'Sheen Telecom Consultants Private Limited', 'sheen.tel', 'IN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(2836, 132519, 'Sikka Cable', 'sikkacable.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2837, 132520, 'MahaOnline Limited', 'mahaonline.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2838, 132523, 'Speed Touch Net Service', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(2839, 132524, 'Tata Institute of Fundamental Research', 'tifr.res.in', 'IN', 36352, 'isp', '0000-00-00 00:00:00', 0),
(2840, 132525, 'HeiLongJiang Mobile Communication Company Limited', 'chinamobile.com', 'CN', 368896, 'isp', '0000-00-00 00:00:00', 0),
(2841, 132526, 'ZONE TELECOM PTE LTD', 'zonetel.com.sg', 'SG', 4864, 'business', '0000-00-00 00:00:00', 0),
(2842, 132527, 'Department of Posts', 'indiapost.gov.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2843, 132528, 'Digicel Australia Pty Ltd', 'digicelgroup.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2844, 132529, 'W3 Networks Pty Ltd', 'w3networks.com.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2845, 13253, 'Intesa Sanpaolo S.p.A.', 'intesasanpaolo.com', 'IT', 1536, 'business', '0000-00-00 00:00:00', 0),
(2846, 132530, 'Bestec Telecom Ltd.', 'bestecgroup.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(2847, 132531, 'M EAST SDN. BHD.', 'marlboroughcollege.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(2848, 132532, 'The trustee for The CommSys Australia Unit Trust', 'commsys.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2849, 132533, 'Vibe Group Pty Ltd', 'vibegroup.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2850, 132534, 'Healthlink Limited', 'healthlink.net', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2851, 132535, 'ANTARIKSH BROADBAND AND WIRELESS SOLUTION PRIVATE LIMITED', 'antariksh.co.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2852, 132539, 'Viteos Capital Market Services Limited', 'viteos.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2853, 13254, 'ARNOLDO MONDADORI EDITORE SPA', 'mondadori.it', 'IT', 12800, 'business', '0000-00-00 00:00:00', 0),
(2854, 132540, 'AIRNAT IT SOLUTIONS PVT LTD', 'airnat.com', 'IN', 3072, 'business', '0000-00-00 00:00:00', 0),
(2855, 132542, 'Chinetworks India Pvt. Ltd.', 'chinetworks.com', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2856, 132543, 'Nextgen Networks Limited', 'nextgennetworksbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2857, 132544, 'Cloudoip Pty Ltd', 'cloudoip.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2858, 132545, 'Sapanan General Food', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2859, 132547, 'Sajag Prahari Foundation', 'sajagprahari.org', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2860, 132549, 'eBroker Systems Ltd', 'ebrokernet.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2861, 132552, 'Tianjin Municipal Education and Research Network', 'cernet.edu.cn', 'CN', 17408, 'education', '0000-00-00 00:00:00', 0),
(2862, 132553, 'China University of Petroleum (East China)', 'upc.edu.cn', 'CN', 34816, 'education', '0000-00-00 00:00:00', 0),
(2863, 132554, 'Ateneo de Manila University', 'ateneo.edu', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(2864, 132556, 'Blue Lotus Support Services Pvt Ltd', 'bluelotusservices.com', 'IN', 15104, 'isp', '0000-00-00 00:00:00', 0),
(2865, 132557, 'GE Capital Business Process Management Services Limited', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2866, 132559, 'Gatik Business Solutions', 'gatikbs.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2867, 132562, 'ZeroWorries Private Limited', 'zeroworries.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2868, 132563, 'MegaHostZone', 'megahostzone.com', 'IN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(2869, 132564, 'Minosha India Limited', 'minoshaidc.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(2870, 132566, 'Skynet Broadband Plus Solution', 'skynetbroadband.com.au', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2871, 132567, 'VMware India Software Pvt Ltd', 'vmware.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2872, 132568, 'Infinet Communictions', 'infinetworld.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2873, 13257, 'PJSC Vimpelcom', 'beeline.ru', 'RU', 14336, 'isp', '2002-06-06 07:04:49', 0),
(2874, 132571, 'Euronet Services India Pvt Ltd', 'euronetworldwide.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(2875, 132572, 'Fasthook Networks Pvt Ltd', 'fhnpl.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2876, 132573, 'SAI NGN Network Services', 'vasaicable.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2877, 132575, 'Sigma Engineers Ltd', 'sigma-bd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(2878, 132576, 'WorleyParsons Limited', 'worleyparsons.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(2879, 132578, 'RETURNED & SERVICES LEAGUE OF AUSTRALIA (QUEENSLAND BRANCH)', 'rslqld.org', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2880, 132579, 'Tonga Cable Limited', 'tongacable.to', 'TO', 768, 'isp', '0000-00-00 00:00:00', 0),
(2881, 132581, 'VICTORIAN RAIL TRACK', 'victrack.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(2882, 132582, 'Gazal Apparel Pty Ltd', 'gazal.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2883, 132583, 'Core Desktop Pty Ltd', 'coredesktop.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2884, 132585, 'SkyExchange Internet Access', 'pccw.com', 'HK', 19456, 'isp', '0000-00-00 00:00:00', 0),
(2885, 132587, 'INFORMATICA BUSINESS SOLUTION PVT LTD', 'informatica.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2886, 132588, 'Yrless Ltd', 'yrless.co.nz', 'NZ', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2887, 13259, 'Delta Telesystems Ltd.', 'deltatelesystems.ru', 'RU', 2560, 'business', '2008-06-10 07:46:20', 0),
(2888, 132590, 'AKCTV Pte. Ltd.', 'ievosolutions.com', 'KH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2889, 132591, 'Tencent AS num for global network', 'tencent.com', 'HK', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(2890, 132593, 'Helloworld Travel Services (NZ) LTD', 'helloworld.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2891, 132594, 'RAA INSURANCE LIMITED', 'raa.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2892, 132595, 'Solutions Experts and Enablers Inc.', 'None', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(2893, 132596, 'New Zealand Cloud Service (NZCS)', 'hpe.com', 'NZ', 2048, 'business', '0000-00-00 00:00:00', 0),
(2894, 132597, 'Hong Kong Serverworks Limited', 'hkserverworks.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(2895, 132599, 'Ministry of Posts and Telecommunication', 'mptc.gov.kh', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2896, 1326, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 2048, 'isp', '1994-11-23 00:00:00', 0),
(2897, 13260, 'SKUBA, UAB', 'skuba.lt', 'LT', 256, 'business', '2015-09-24 07:42:00', 0),
(2898, 132602, 'Bangladesh Submarine Cable Company Limited (BSCCL)', 'bsccl.com', 'BD', 2304, 'business', '0000-00-00 00:00:00', 0),
(2899, 132603, 'THOMAS DURYEA LOGICALIS HOLDINGS PTY LTD.', 'logicalis.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2900, 132604, 'Midland Bank', 'midlandbankbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2901, 132605, 'KTB General Services Co.,Ltd', 'ktbgs.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(2902, 132611, 'Tech-e Pty Ltd', 'tech-e.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2903, 132613, 'SunTec Business Solutions Pvt. Ltd.', 'suntecgroup.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2904, 132615, 'Pipol Broadband and Telecommunications Corporation', 'pipolbroadband.com', 'PH', 2304, 'isp', '0000-00-00 00:00:00', 0),
(2905, 132616, 'Ipswich City Council', 'ipswich.qld.gov.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2906, 132618, 'Real Future Company Limited', 'truecorp.co.th', 'TH', 20992, 'isp', '0000-00-00 00:00:00', 0),
(2907, 132619, 'POLICE DEPARTMENT (VIC) trading as VICTORIA POLICE', 'police.vic.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(2908, 132620, 'STW Communications Group Ltd', 'stwgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2909, 132621, 'Commonwealth Bank of Australia', 'commbank.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2910, 132622, 'Combined Soft BD', 'combinedbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2911, 132626, 'INFINET VOICE & DATA PTY LTD', 'infinet.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2912, 132627, 'ConnektNet Pty. Ltd.', 'connektnet.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(2913, 132634, 'Direktorat E-Goverment Kementerian KOMINFO', 'kominfo.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2914, 132637, 'PT BINA INFORMATIKA SOLUSI', 'bitsnet.co.id', 'ID', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2915, 132638, 'IAIN Walisongo Semarang', 'walisongo.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(2916, 132639, 'PT Integrasi Logistik Cipta Solusi', 'ilcs.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2917, 132641, 'PT Netciti Persada', 'netciti.co.id', 'ID', 4352, 'isp', '0000-00-00 00:00:00', 0),
(2918, 132642, 'Universitas Ahmad Dahlan', 'uad.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(2919, 132643, 'Komisi Pemilihan Umum', 'kpu.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2920, 132644, 'PT. Cyberindo Mega Persada', 'cbncloud.co.id', 'ID', 3328, 'hosting', '0000-00-00 00:00:00', 0),
(2921, 132645, 'Politeknik Perkapalan Negeri Surabaya', 'ppns.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(2922, 132647, 'Pengelola Nama Domain Internet Indonesia', 'pandi.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(2923, 132649, 'PT Adau Putra Network', 'adau-network.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(2924, 132652, 'PT. Cahaya Buana Raksa', 'cbr.net.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(2925, 132653, 'PT Transdata Sejahtera', 'b-link.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2926, 132655, 'Sekretariat Jenderal Dewan Perwakilan Daerah Republik Indonesia', 'dpd.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2927, 132658, 'Dinas Komunikasi dan Informatika Provinsi Sumatera Utara', 'sumutprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2928, 13266, 'Havenbedrijf Rotterdam n.v.', 'portofrotterdam.com', 'NL', 1792, 'business', '0000-00-00 00:00:00', 0),
(2929, 132660, 'Universitas Negeri Gorontalo', 'ung.ac.id', 'ID', 768, 'education', '0000-00-00 00:00:00', 0),
(2930, 132661, 'Indonesia Network Information Center', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2931, 132662, 'PT. Lotte Data Communication Indonesia (LDCI)', 'lotte.net', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2932, 132663, 'PT Indonesia Media Komunikasi Masyarakat', 'indomedia.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2933, 132664, 'PT. Merah Cipta Media', 'merahciptamedia.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2934, 132666, 'Dinas Komunikasi dan Informatika Kota Bandar Lampung', 'bandarlampungkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(2935, 132667, 'Universitas Jambi', 'unja.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(2936, 132668, 'PT Bali Towerindo Sentra', 'balitower.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2937, 132669, 'PT Globalnet Multi Data', 'global.net.ar', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(2938, 13267, 'Zuercher Kantonalbank', 'zkb.ch', 'CH', 8192, 'business', '0000-00-00 00:00:00', 0),
(2939, 132670, 'PT Aseli Dagadu Djokdja', 'dagadu.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(2940, 132676, 'Universitas Sriwijaya', 'unsri.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(2941, 132677, 'PT Garuda Media Informatika', 'garudainformatika.com', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2942, 132678, 'Universitas Jember', 'unej.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(2943, 132680, 'Net Virtue Pty Ltd', 'netvirtue.com.au', 'AU', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(2944, 132681, 'AIN Globalcomm Limited., Company.', 'ais.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(2945, 132682, 'Australian Rugby Union Limited', 'rugby.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2946, 132685, 'TouchPal HK Co., Limited', 'cootek.cn', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(2947, 132686, 'Amara Communications', 'amaracommunications.com', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2948, 132688, 'University of Malaya', 'um.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(2949, 132690, 'Network For Electronic Transfers (Singapore) Pte Ltd', 'nets.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2950, 132691, 'Anglicare Tasmania Inc', 'anglicare-tas.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2951, 132692, 'GlobiCom Limited', 'globicom.co.nz', 'NZ', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(2952, 132693, 'Eastern Health', 'easternhealth.org.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2953, 132694, 'Universiti Sains Islam Malaysia', 'usim.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(2954, 132695, 'Optimation New Zealand Limited', 'optimation.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2955, 132696, 'SGIX Services', 'sgix.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2956, 132697, 'TBD Holdings Ltd', 'hd.net.nz', 'NZ', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(2957, 132699, 'Siemens Pte Ltd.', 'siemens.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(2958, 132701, 'Uttaradit Rajabhat University', 'rit.ac.th', 'TH', 256, 'education', '0000-00-00 00:00:00', 0),
(2959, 132702, 'TUV Rheinland Hong Kong Ltd.', 'tuv.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(2960, 132703, 'Hancock Prospecting Pty Ltd', 'hancockprospecting.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2961, 132706, 'Bluestone Mortgages Pty Limited', 'bluestone.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2962, 132707, 'Asix', 'asix-afg.com', 'AF', 1024, 'isp', '0000-00-00 00:00:00', 0),
(2963, 132708, 'VNG Singapore PTE. LTD.', 'vng.com.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(2964, 132710, 'Cover-More Insurance Services Pty Ltd', 'covermore.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2965, 132711, 'Dell SonicWALL', 'sonicwall.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(2966, 132712, 'Daifuku Oceania', 'daifukuoc.com', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(2967, 132713, 'Virgin Australia Airlines Pty Ltd', 'virginaustralia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2968, 132716, '1 Solaire Boulevard,', 'solairemanila.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(2969, 132717, 'NxtGen Datacenter & Cloud Technologies Pvt. Ltd.', 'nxtgen.co.in', 'IN', 10240, 'business', '0000-00-00 00:00:00', 0),
(2970, 132718, 'Samarad Pty Ltd t/as', 'mantragroup.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2971, 13272, 'Elisa Teleteenused AS', 'elisa.ee', 'EE', 115712, 'isp', '2002-06-20 15:41:04', 0),
(2972, 132720, 'Experian Marketing Services (Malaysia) Sdn. Bhd.', 'experian.com', 'MY', 768, 'business', '0000-00-00 00:00:00', 0),
(2973, 132721, 'Ping Global Amsterdam POP ASN', 'ping.com.hk', 'NL', 12288, 'hosting', '0000-00-00 00:00:00', 0),
(2974, 132722, 'Intellium Technology Limited', 'intellium.co.nz', 'NZ', 768, 'isp', '0000-00-00 00:00:00', 0),
(2975, 132723, 'Tararua District Council', 'tararuadc.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(2976, 132724, 'NARKOV Pty Ltd', 'narkov.com', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(2977, 132726, '5-3 Miyuki-cho', 'tt5.com', 'JP', 8704, 'business', '0000-00-00 00:00:00', 0),
(2978, 132727, 'Strata Networks Ltd', 'stratanetworks.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2979, 132728, 'Alfred Health', 'alfred.org.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(2980, 13273, 'Smile S.A.', 'smile.fr', 'FR', 18432, 'business', '2002-09-06 12:01:44', 0),
(2981, 132730, 'Maximum Business Information Technology', 'maxbit.com.kh', 'KH', 4096, 'isp', '0000-00-00 00:00:00', 0),
(2982, 132733, 'Engage Pty Ltd', 'letsengage.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(2983, 132734, 'Schneider Electric (SINGAPORE) Pty Ltd', 'schneider-electric.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(2984, 132735, 'Rayan Traders', 'rayantraders.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(2985, 132739, 'Scaffnet Pte Ltd', 'scaffnet.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(2986, 13274, 'mBank SA', 'mbank.pl', 'PL', 256, 'business', '0000-00-00 00:00:00', 0),
(2987, 132740, 'Netlink Group PTY LTD', 'netlinkgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(2988, 132741, 'National Communications Services (SMC-Private) Limited', 'dunyatv.tv', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(2989, 132742, 'Guochao Group limited', 'None', 'HK', 37888, 'hosting', '0000-00-00 00:00:00', 0),
(2990, 132744, 'The Virus Centre Ltd', 'tvc.co.nz', 'NZ', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2991, 132745, 'Computer Corner Ltd', 'computercorner.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(2992, 132751, 'Omkar Infotech', 'omkarinfotech.co.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(2993, 132752, 'skynet system', 'skynets.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(2994, 132753, 'Inventum Technologies Private Limited', 'inventum.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2995, 132754, 'Realtel Network Services Pvt Ltd', 'realtel.in', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(2996, 132757, 'Sristi Sanchar Webnet Ltd.', 'sswl.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(2997, 132760, 'Progression Infonet Pvt Ltd', 'progression.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(2998, 132761, 'Smartlink Solutions', 'smartlinkindia.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(2999, 132763, 'HPCL-Mittal Energy Ltd.', 'hmel.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3000, 132764, 'Pinkey Internet', 'pinkeyinternet.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3001, 132768, 'Five network Broadband Solution Pvt Ltd', 'fivenetwork.com', 'IN', 23296, 'isp', '0000-00-00 00:00:00', 0),
(3002, 132770, 'Gazon Communications India Limited', 'gazonindia.com', 'IN', 28928, 'isp', '0000-00-00 00:00:00', 0),
(3003, 132771, 'Fibre Air Services Private Limited', 'fibreair.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3004, 132772, 'Sistemos Information Technology Private Limited', 'sistemos.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3005, 132774, 'Niss Internet services private limited', 'nissbroadband.com', 'IN', 3072, 'business', '0000-00-00 00:00:00', 0),
(3006, 132778, 'Panchsheel Broadband Services Private Limited', 'panchsheelbroadband.com', 'IN', 4608, 'isp', '0000-00-00 00:00:00', 0),
(3007, 132779, 'RackBank Datacenters Private Ltd', 'rackbank.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3008, 13278, 'TEI(TUSAS MOTOR SANAYI A.S.)', 'tei.com.tr', 'TR', 256, 'business', '2002-11-06 16:26:11', 0),
(3009, 132780, 'Indian Institute of Technology Delhi', 'iitd.ac.in', 'IN', 1024, 'education', '0000-00-00 00:00:00', 0),
(3010, 132781, 'Unicel Technologies Pvt Ltd', 'uniceltech.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3011, 132783, 'AMARNATH INTERNET SOLUTION PVT LTD', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3012, 132785, 'Shiv Nadar University', 'snu.edu.in', 'IN', 2048, 'education', '0000-00-00 00:00:00', 0),
(3013, 132787, 'Helios IT Infrasolutions Pvt Ltd', 'netxpress.in', 'IN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(3014, 132788, 'MOBILINK IT AS', 'link.net', 'PK', 256, 'isp', '0000-00-00 00:00:00', 0),
(3015, 132789, 'Pivotel Group Pty Limited', 'pivotel.com.au', 'AU', 6400, 'business', '0000-00-00 00:00:00', 0),
(3016, 132791, 'Faley Pty Ltd', 'itcentre.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3017, 132792, 'University of the Philippines Visayas, Miagao', 'dost.gov.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(3018, 132795, 'University of the Philippines Visayas, Iloilo Campus', 'dost.gov.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(3019, 132796, 'University of the Philippines Baguio Campus', 'upb.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(3020, 132797, 'Vanuatu Internet Exchange (VIX)', 'gov.vu', 'VU', 256, 'isp', '0000-00-00 00:00:00', 0),
(3021, 132798, 'Cloud IT Pty Ltd', 'cloudit.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3022, 132799, 'DISH MEDIA NETWORK PUBLIC LIMITED', 'dishhome.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(3023, 13280, 'Three Ireland (Hutchison) limited', 'three.ie', 'IE', 163840, 'isp', '2002-08-19 09:04:36', 0),
(3024, 132801, 'National Bank Limited , Head Office', 'amberit.com.bd', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(3025, 132804, 'Singapore Telecommunications Limited', 'singtel.com', 'SG', 256, 'isp', '0000-00-00 00:00:00', 0),
(3026, 132805, 'Singapore Telecommunications Limited', 'singtel.com', 'SG', 256, 'isp', '0000-00-00 00:00:00', 0),
(3027, 132806, 'Khulna University of Engineering & Technology', 'kuet.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(3028, 132808, 'IP Telco', 'iptelco.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3029, 13281, 'TOV Hotel Management', 'ickyiv.com', 'UA', 256, 'business', '2009-10-08 07:03:11', 0),
(3030, 132812, 'Central Coast Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3031, 132813, 'HK AISI CLOUD COMPUTING LIMITED', 'aisicloud.net', 'HK', 14336, 'hosting', '0000-00-00 00:00:00', 0),
(3032, 132815, 'Evolution Wireless Ltd', 'ew.net.nz', 'NZ', 3584, 'isp', '0000-00-00 00:00:00', 0),
(3033, 132816, 'SimplerCloud Pte Ltd', 'simplercloud.com', 'SG', 2048, 'business', '0000-00-00 00:00:00', 0),
(3034, 132818, 'Netsolutions Limited', 'netsolutions.com.hk', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3035, 132819, 'Aldford Network Solutions Limited', 'aldfordhosting.com', 'PH', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(3036, 13282, 'Finanz Informatik GmbH & Co. KG', 'f-i.de', 'DE', 256, 'business', '0000-00-00 00:00:00', 0),
(3037, 132821, 'Trinity Securities Co., Ltd.', 'trinitythai.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3038, 132822, 'Fidelity Life Assurance Company Limited', 'fidelitylife.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3039, 132823, 'IMS Health India Pvt Ltd', 'imshealth.com', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(3040, 132825, 'Defense Australia Network', 'cnc-int.com', 'AU', 5120, 'hosting', '0000-00-00 00:00:00', 0),
(3041, 132826, 'Oakleigh Capital Ltd', 'oakleighcapital.com', 'PH', 1536, 'business', '0000-00-00 00:00:00', 0),
(3042, 132827, 'GATEWAY INC', 'gateway.com', 'JP', 31744, 'hosting', '0000-00-00 00:00:00', 0),
(3043, 132829, 'Nevigate Communications (S) Pte Ltd', 'nevigate.net', 'SG', 2560, 'business', '0000-00-00 00:00:00', 0),
(3044, 13283, 'Bank Julius Baer & Co. AG', 'juliusbaer.com', 'CH', 65536, 'business', '0000-00-00 00:00:00', 0),
(3045, 132831, 'EziNET Limited', 'ezinet.to', 'TO', 1280, 'business', '0000-00-00 00:00:00', 0),
(3046, 132834, 'Practical Applications Pty Ltd', 'pracapps.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3047, 132835, 'FlexiGroup Pty Ltd', 'flexigroup.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3048, 132836, 'Internomic Pty Ltd', 'internomic.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3049, 132837, 'VTelecoms Global Limited', 'orient-telecoms.com', 'HK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3050, 132839, 'POWER LINE DATACENTER', 'powerline.hk', 'HK', 1069568, 'hosting', '0000-00-00 00:00:00', 0),
(3051, 13284, 'Playnet S.R.L.', 'playnet.it', 'IT', 14336, 'business', '2002-05-03 08:14:02', 0),
(3052, 132840, 'Neos Systems Limited', 'neos.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3053, 132843, 'Marketing Convergence Inc.', 'sm-mci.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(3054, 132844, 'Ateneo de Manila University', 'ateneo.edu', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(3055, 132847, 'Network Solutions Group Pty Ltd', 'networksolutiongroup.com', 'AU', 1792, 'business', '0000-00-00 00:00:00', 0),
(3056, 132848, 'CNTCorp', 'cntcorp.com.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3057, 13285, 'TalkTalk Communications Limited', 'talktalkplc.com', 'GB', 3513600, 'isp', '2002-09-19 16:38:10', 0),
(3058, 132850, 'TS Global Network Sdn. Bhd.', 'tsgn.com.my', 'MY', 2304, 'business', '0000-00-00 00:00:00', 0),
(3059, 132851, 'MAI-TECH PTY LTD', 'imaginenowit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3060, 132852, 'Vault Systems Pty. Ltd.', 'vaultsystems.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3061, 132855, 'Integricity Technology Sdn Bhd', 'fatservers.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(3062, 132856, 'Kathmandu University', 'ku.edu.np', 'NP', 256, 'education', '0000-00-00 00:00:00', 0),
(3063, 132857, 'FULL FLAVOUR LIMITED', 'ff.net.nz', 'NZ', 2304, 'isp', '0000-00-00 00:00:00', 0),
(3064, 132858, 'Eye Media Australia Pty Ltd', 'eyemedia.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3065, 132861, 'Orceda Limited', 'orceda.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3066, 132862, 'ST. LUKE\'S MEDICAL CENTER (GLOBAL CITY), INC.', 'stlukes.com.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(3067, 132863, 'Megaport Pty Ltd', 'megaport.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3068, 132865, 'Genius Networks', 'g3ns.net', 'HK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3069, 132866, 'Rajamangala University of Technology Suvarnabhumi under UniNet Network', 'inet.co.th', 'TH', 2048, 'education', '0000-00-00 00:00:00', 0),
(3070, 132867, 'Fidelity Business Services India Private Limited', 'fmr.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3071, 132868, 'State Library of NSW', 'nsw.gov.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3072, 132869, 'Mohammad Mahabub Alam t/a M.A Network Service', 'manetbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3073, 13287, 'FALBOX S.L.', 'nixval.com', 'ES', 18944, 'hosting', '0000-00-00 00:00:00', 0),
(3074, 132870, 'Xtreme Networks Limited', 'xtreme.net.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3075, 132871, 'Click Software India Pvt. Ltd', 'clicksoftware.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3076, 132872, 'Data Check Limited', 'datacheck.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(3077, 132873, 'Conexim Global AnyCast Network', 'conexim.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3078, 132874, 'Universiti Malaysia Sabah', 'ums.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(3079, 132876, 'Symphony Communication (Thailand) PCL.', 'symphony.net.th', 'TH', 768, 'isp', '0000-00-00 00:00:00', 0),
(3080, 132878, 'HT Media Ltd.', 'shine.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3081, 132879, 'Rajabhat Mahasarakham University', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(3082, 132881, 'OmniNet Ltd', 'omninet.co.nz', 'NZ', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3083, 132882, 'Ohana Communications Sdn Bhd', 'ohana.com.my', 'MY', 6144, 'isp', '0000-00-00 00:00:00', 0),
(3084, 132883, 'TOPWAY GLOBAL LIMITED', 'topidc.hk', 'HK', 10496, 'hosting', '0000-00-00 00:00:00', 0),
(3085, 132884, 'Summit Communications Limited', 'summitcommunications.net', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(3086, 132885, 'CET DEVELOPMENT SDN BHD', 'mod.gov.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(3087, 132887, 'Counties Power LTD', 'countiespower.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3088, 13289, 'iWelt AG', 'iwelt.de', 'DE', 8704, 'business', '2002-06-25 14:47:01', 0),
(3089, 132890, 'IP Core Sdn Bhd', 'ipcore.com.my', 'MY', 3328, 'isp', '0000-00-00 00:00:00', 0),
(3090, 132891, 'SARFRAZ TEXTILE MILLS (PRIVATE) LIMITED', 'None', 'PK', 256, 'isp', '0000-00-00 00:00:00', 0),
(3091, 132892, 'Cloudflare, Inc.', 'cloudflare.com', 'US', 7936, 'business', '0000-00-00 00:00:00', 0),
(3092, 132893, 'KODIAK NETWORKS INDIA PRIVATE LIMITED', 'kodiaknetworks.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3093, 132894, 'Tech Project Pty Ltd', 'techproject.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3094, 132895, 'Prodigy Communications Pty Ltd', 'prodigy.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3095, 132896, 'MARKET CREATIONS', 'marketcreations.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3096, 132898, 'CHORUS NEW ZEALAND LIMITED', 'chorus.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3097, 132899, 'Network Solutions Ltd', 'networksolutions.com', 'HK', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3098, 132901, 'Global Forway Sdn Bhd', 'globalforway.com', 'MY', 1536, 'business', '0000-00-00 00:00:00', 0),
(3099, 132902, 'InfoTrack Pty Ltd', 'infotrack.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3100, 132905, 'AS number of Ateneo de Davao University', 'addu.edu.ph', 'PH', 1024, 'education', '0000-00-00 00:00:00', 0),
(3101, 132906, 'Lake Macquarie City Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3102, 132908, 'Hyperconnect Pty Ltd', 'hyperconnect.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3103, 132909, 'ACT Government InTACT Group', 'act.gov.au', 'AU', 65536, 'business', '0000-00-00 00:00:00', 0),
(3104, 132911, 'ECS BIZTECH PVT LTD', 'ecsbiztech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3105, 132912, 'Fairfax NZ', 'fairfaxmedia.com.au', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3106, 132914, 'Adelaide Brighton Limited', 'adbri.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3107, 132917, 'Yellow Pages Group', 'yellow.co.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(3108, 132919, 'WebSlice Limited', 'webslice.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3109, 13292, 'Willibald Hambammer trading as BK-DAT Electronics e.U.', 'bkdat.net', 'AT', 8192, 'isp', '0000-00-00 00:00:00', 0),
(3110, 132923, 'Vihaan Telecommunication Pvt. Ltd.', 'vihaantelecom.com', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(3111, 132924, 'Ero Wide Comm Private Limited', 'widecom.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3112, 132925, 'Ideastack solutions private limited', 'None', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3113, 132927, 'Oistel Telecom Private Limited', 'oistel.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3114, 13293, 'Institute of Bioorganic Chemistry Polish Academy of Science, Poznan Supercomputing and Networking Center', 'poznan.pl', 'PL', 1024, 'education', '0000-00-00 00:00:00', 0),
(3115, 132931, 'FICUS TELECOM PRIVATE LIMITED', 'ficustelecom.com', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3116, 132932, 'IT Things', 'None', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3117, 132933, 'CharotarTelelink Pvt Ltd', 'vertax.co.in', 'IN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(3118, 132934, 'Skymax broadband services Pvt. Ltd', 'skymaxbroadband.com', 'IN', 5632, 'isp', '0000-00-00 00:00:00', 0),
(3119, 132935, 'Arjun Broadband Private Limited', 'ccplgroup.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(3120, 132937, 'Diadem Technologies Pvt. Ltd.', 'diadem-tech.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3121, 132938, 'Shri Vinayagaa Internet Pvt. Ltd.', 'None', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(3122, 132941, 'IriisNet communication Pvt Ltd', 'iriisnet.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3123, 132943, 'Renaissance Technologies P. Ltd.', 'renaissanceind.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3124, 132944, 'eClerx Services Limited', 'eclerx.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(3125, 132946, 'Ujjivan Small Finance Bank Ltd', 'ujjivansfb.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3126, 132948, 'Kpit Cummins Infosystem Limited', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3127, 132950, 'Damco Solutions Pvt. Ltd.', 'damcogroup.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3128, 132952, 'ENOW', 'enow.in', 'IN', 4096, 'business', '0000-00-00 00:00:00', 0),
(3129, 132954, 'NXTR DATA LIMITED', 'nxtradata.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3130, 132955, 'Pmg Networks Pvt Ltd', 'quicknetwireless.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3131, 132956, 'V NET NETWORKS PVT LTD', 'vnetnetworks.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3132, 132957, 'Pintwire Infomatics Private Limited', 'pintwire.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3133, 132958, 'Gramin Broadband Network Pvt . Ltd.', 'gbnpl.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3134, 13296, 'Innovative Solutions Ltd', 'innor.ru', 'RU', 2304, 'business', '2008-05-19 09:03:12', 0),
(3135, 132960, 'Mukand Infotel Pvt Ltd.', 'mukandgroup.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3136, 132961, 'RGV Akshay communication Pvt. Ltd.', 'netfi.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3137, 132962, 'QuEST Global Engineering Private Limited', 'quest-global.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3138, 132964, 'Fibernet Solutions (OPC) Pvt. Ltd.', 'fibernetindia.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3139, 132965, 'Techbook international Pvt. Ltd.', 'techbooks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3140, 132968, 'KPMG', 'kpmg.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3141, 132970, 'CSS Corp PVT Ltd', 'csscorp.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3142, 132971, 'Sikka Star Satellite', 'sikkanet.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3143, 132972, 'Nandbalaji Connecting Zone Pvt. Ltd', 'nandbalaji.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3144, 132974, 'Suraj Network', 'None', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3145, 132976, 'Kings Broadband Pvt Ltd', 'kingsbroadband.net', 'IN', 6144, 'isp', '0000-00-00 00:00:00', 0),
(3146, 132977, 'Kaizen Systems', 'borgfx.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3147, 132978, 'Airline Internet Solutions India Private Limited', 'aisipl.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3148, 13298, 'SOS-Kinderdorf International', 'sos-kd.org', 'AT', 256, 'business', '2002-10-31 14:26:47', 0),
(3149, 132983, 'Real Time Data Services Pvt Ltd', 'myrealdata.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3150, 132984, 'Uka Tarsadia Unviersity', 'utu.ac.in', 'IN', 1024, 'education', '0000-00-00 00:00:00', 0),
(3151, 132986, 'Digital Dreams Consulting Pvt Ltd', 'ddcpl.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3152, 132988, 'Venessa Internet Pvt Ltd', 'venessainternet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3153, 132990, 'Applied Mobile Labs Private Limited', 'amlpl.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3154, 132991, 'Synechron Technologies Pvt. Ltd.', 'synechron.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3155, 132994, 'DENA BANK', 'denabank.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3156, 132995, 'South Asian University', 'southasianuniversity.org', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(3157, 132996, 'Threesa Infoway Pvt.Ltd.', 'threesabroadband.com', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(3158, 132999, 'Richa Telecom', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3159, 133000, 'ARJUN TELECOM PVT. LTD.', 'arjuntelecom.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3160, 133001, 'Airnet Cable And Datacom Pvt Ltd', 'airnetnetworks.com', 'IN', 16128, 'isp', '0000-00-00 00:00:00', 0),
(3161, 133002, 'Indian Institute of Tropical Meteorology', 'irinn.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(3162, 133003, 'Edge Telecommunications Pvt. Ltd.', 'irinn.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3163, 133005, 'NEW INDIA ASSURANCE CO LTD', 'newindia.co.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3164, 133006, 'Pega Systems Worldwide India Pvt Ltd', 'pega.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3165, 133007, 'UCN CABLE NETWORK PVT. LTD', 'ucnindia.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3166, 133010, 'eClerx Services Limited', 'eclerx.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3167, 133012, 'Cocoa Oriental Network Limited', 'cocoaoriental.com', 'HK', 3072, 'business', '0000-00-00 00:00:00', 0),
(3168, 133013, 'AbbVie, Inc.', 'abbvie.com', 'SG', 2048, 'business', '0000-00-00 00:00:00', 0),
(3169, 133014, 'Universiti Teknologi Malaysia', 'utm.my', 'MY', 49152, 'education', '0000-00-00 00:00:00', 0),
(3170, 133015, 'City of Stirling', 'stirling.wa.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3171, 133017, 'NASDAQ PTY LTD', 'nasdaq.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3172, 133019, 'Edmund Rice Education Australia', 'terrace.qld.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(3173, 13302, 'Linkey Ltd', 'linkey.ru', 'RU', 1024, 'business', '2002-10-22 10:27:16', 0),
(3174, 133023, 'Virtualplatform', 'virtualplatform.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3175, 133024, 'Room 704, ChinaChen Leighton Plaza', 'easyinternethk.com', 'HK', 14336, 'hosting', '0000-00-00 00:00:00', 0),
(3176, 133025, 'InMobi Pte. Ltd.', 'inmobi.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3177, 133028, 'EVRY INDIA PRIVATE LIMITED', 'evry.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(3178, 13303, 'University of Nis', 'ni.ac.rs', 'RS', 65536, 'education', '2002-10-23 10:51:31', 0),
(3179, 133030, 'Rocket Networks Pty Ltd', 'rocketnet.net', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3180, 133034, 'Virtual American Companies (BD) Limited', 'vacbl.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(3181, 133036, 'Amadeus is an international computer reservations system. A subsidary is in Bangalore and the ASN is for this site', 'amadeus.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3182, 133037, 'Kerala State IT Mission', 'keralaitmission.org', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3183, 133038, 'Exanet Limited', 'exa.net', 'HK', 4096, 'business', '0000-00-00 00:00:00', 0),
(3184, 133040, 'PPS MUTUAL INSURANCE PTY LTD', 'ppsmutual.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3185, 133041, 'Tianxin Group Co., Limited', 'None', 'HK', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(3186, 133042, 'Office of the basic education commission', 'obec.go.th', 'TH', 2816, 'education', '0000-00-00 00:00:00', 0),
(3187, 133043, 'Enhanced Solutions Ltd', 'enhancedsolutions.co.nz', 'NZ', 2304, 'isp', '0000-00-00 00:00:00', 0),
(3188, 133044, 'Sol1 Pty Ltd', 'sol1.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3189, 133045, 'NSW Electricity Networks Operations Pty Limited', 'transgrid.com.au', 'AU', 4864, 'business', '0000-00-00 00:00:00', 0),
(3190, 133046, 'Cloudoip Pty Ltd', 'cloudoip.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3191, 133047, 'ANCORE PTY LTD', 'altitudeit.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3192, 133048, 'Caption It Pty Ltd', 'captioning.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3193, 133050, 'CNCNA Pty Ltd', 'peakhour.io', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3194, 133051, 'COMMERCIAL BANK OF CEYLON PLC', 'combank.net', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(3195, 133052, 'FX Corporate LLC', 'fxcorporate.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(3196, 133053, 'Education Services Australia Limited', 'esa.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(3197, 133054, 'Reasonable Software House Limited', 'reasonables.com', 'HK', 6144, 'business', '0000-00-00 00:00:00', 0),
(3198, 133055, 'Ameriprise India Pvt Ltd', 'ameriprise.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3199, 133057, 'The Trustee for THE BOWEN FAMILY TRUST t/a BES IT Systems', 'bes.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3200, 133058, 'MyRepublic Ltd.', 'myrepublic.net', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3201, 13306, 'Unics EOOD', 'unicsbg.net', 'BG', 11520, 'isp', '2002-10-28 15:29:18', 0),
(3202, 133061, 'ActewAGL Distribution', 'actewagl.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3203, 133062, 'Reckon Limited', 'reckon.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3204, 133063, 'KGI Securities (Thailand) PLC.', 'kgi.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3205, 133065, 'Well-Act Partnership Limited', 'None', 'TH', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3206, 133066, 'Ariana Network Services Co', 'ans.af', 'AF', 256, 'business', '0000-00-00 00:00:00', 0),
(3207, 133068, 'China Online Innovations Inc', '51talk.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(3208, 13307, 'SKIF ISP Ltd.', 'skif.com.ua', 'UA', 8448, 'isp', '2002-10-29 14:02:04', 0),
(3209, 133070, 'CAMBODIAN SINGMENG TELEMEDIA CO., LTD', 'smtelemedia.com', 'KH', 4608, 'isp', '0000-00-00 00:00:00', 0),
(3210, 133073, 'TELEGLOBAL COMMUNICATION SERVICES LIMITED', 'tele-global.net', 'HK', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3211, 133075, 'Telesmart Limited', 'telesmart.co.nz', 'NZ', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3212, 133076, 'Unique Atlantic Telecommunication', 'uatelecom.af', 'AF', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3213, 133077, 'SCHNEIDER', 'schneider-electric.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3214, 133080, 'Comcity Technology Pty Ltd', 'comcity.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3215, 133081, 'State Revenue Office Victoria', 'sro.vic.gov.au', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(3216, 133082, 'AIRMESH COMMUNICATIONS LIMITED', 'airmesh.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3217, 133083, 'Bangladesh Extension Education Services', 'amberit.com.bd', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(3218, 133084, 'Jisc Collections and Janet Limited', 'ja.net', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(3219, 133085, 'Toshiba (Australia) Pty. Ltd', 'toshiba.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3220, 133087, 'DST Worlwide Services India Pvt. Ltd.', 'ispacesoftware.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3221, 133088, 'Viteos Capital Market Services Limited', 'viteos.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3222, 133089, 'Qualcomm Inc', 'qualcomm.com', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(3223, 133090, 'Fusion Networks', 'fusionnetworks.co.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(3224, 133091, 'NORTHERN MELBOURNE INSTITUTE OF TAFE', 'melbournepolytechnic.edu.au', 'AU', 1024, 'education', '0000-00-00 00:00:00', 0),
(3225, 133092, 'F-1 Soft International Pvt Ltd', 'f1soft.com', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(3226, 133093, 'Comwire IT Pty Ltd', 'comwireit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3227, 133094, 'Harry Perkins Institute of Medical Research Inc', 'perkins.org.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3228, 133096, 'MOTHERSHIP', 'mothership.co.nz', 'NZ', 2048, 'business', '0000-00-00 00:00:00', 0),
(3229, 1331, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 1280, 'isp', '1994-11-23 00:00:00', 0),
(3230, 133101, 'Dashnet Limited', 'pwls.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3231, 133102, 'Sydney Anglican Home Mission Society Council', 'anglicare.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3232, 133104, 'Instra Corporation Pty Ltd', 'instra.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3233, 133105, 'Roman Catholic Trust Corp. Diocese of Rockhampton', 'rok.catholic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(3234, 133107, 'FNETLINK CO .,LIMITED', 'onenet.hk', 'HK', 3328, 'business', '0000-00-00 00:00:00', 0),
(3235, 133108, 'Wanganui District Council', 'wanganui.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3236, 133111, 'CERNET New Technology Co., Ltd', 'cernet.com', 'CN', 25856, 'isp', '0000-00-00 00:00:00', 0),
(3237, 133113, 'Asia Wealth Securities Company Limited', 'asianet.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3238, 133114, 'ControlVM Sdn. Bhd.', 'controlvm.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(3239, 133115, 'HK Kwaifong Group Limited', 'None', 'HK', 49664, 'hosting', '0000-00-00 00:00:00', 0),
(3240, 133118, 'China Unicom IP network', 'chinaunicom.cn', 'CN', 67584, 'isp', '0000-00-00 00:00:00', 0),
(3241, 133119, 'China Unicom IP network', 'chinaunicom.cn', 'CN', 239872, 'isp', '0000-00-00 00:00:00', 0),
(3242, 13312, 'Lower Umpqua Hospital District', 'lowerumpquahospital.org', 'US', 256, 'business', '2020-03-02 00:00:00', 0),
(3243, 133120, 'Hosted Network Pty. Ltd.', 'hostednetwork.com.au', 'AU', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(3244, 133121, 'Norton Rose Australia Services Pty Ltd', 'nortonrosefulbright.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3245, 133122, 'Heritage Bank Ltd.', 'heritage.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3246, 133124, 'Spark Ventures', 'spark.co.nz', 'NZ', 11008, 'isp', '0000-00-00 00:00:00', 0),
(3247, 133125, 'PG Lion ReSources Aust Pty Ltd', 'apac-resources.com', 'AU', 2560, 'business', '0000-00-00 00:00:00', 0),
(3248, 133126, 'ERANET INTERNATIONAL LIMITED', 'todaynic.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(3249, 133127, 'Federal Express Corporation Hong Kong Branch', 'fedex.com', 'HK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3250, 133129, 'Capital B Pty Ltd', 'capitalb.net', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3251, 13313, 'Barnes & Noble Inc.', 'barnesandnobleinc.com', 'US', 512, 'business', '2006-12-05 00:00:00', 0),
(3252, 133130, 'Tello Services Pty Ltd', 'tello.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(3253, 133132, 'H. W. RICHARDSON GROUP LIMITED', 'hwr.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3254, 133133, 'Roy Hill', 'royhill.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3255, 133134, 'AION TECHNOLOGIES PTE LTD', 'aiontech.com.sg', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(3256, 133136, 'MyRepublic Ltd.', 'myrepublic.net', 'SG', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3257, 133137, 'Bemobile LTD', 'bmobile.com.pg', 'PG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3258, 133138, 'RANDOM HOUSE AUSTRALIA PTY LTD', 'randomhouse.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3259, 13314, 'Toyota Motor Engineering and Manufacturing North America, Inc.', 'toyota.com', 'US', 256, 'business', '2006-10-19 00:00:00', 0),
(3260, 133142, 'Trivago Hong Kong Limited', 'trivago.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(3261, 133143, 'Medihost Solutions Pty Ltd', 'medihostsolutions.com.au', 'AU', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3262, 133144, '8x8, Inc.', '8x8.com', 'US', 768, 'business', '0000-00-00 00:00:00', 0),
(3263, 133145, 'Trimble Planning Solutions Pty Ltd', 'trimble.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3264, 133146, 'PAPUAN OIL SEARCH LTD', 'oilsearch.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3265, 133149, 'Konnect Nepal Networks Pvt Ltd', 'konnectnepal.com', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(3266, 13315, 'Harvard Business School', 'hbs.edu', 'US', 12544, 'education', '1999-04-14 00:00:00', 0),
(3267, 133151, 'Garena Online Pte Ltd', 'garena.sg', 'SG', 256, 'isp', '0000-00-00 00:00:00', 0),
(3268, 133155, 'Satellite Connection', 'satconbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(3269, 133156, 'SS&C Solutions Pty Limited', 'sscinc.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3270, 133158, 'WELL-POWER Tech Corp', 'well-power.com.tw', 'TW', 2304, 'business', '0000-00-00 00:00:00', 0),
(3271, 133159, 'Mammoth Media Pty Ltd', 'mammoth.com.au', 'AU', 12544, 'hosting', '0000-00-00 00:00:00', 0),
(3272, 13316, 'SES Sistemas Electrónicos S.A.', 'ses.com.ar', 'AR', 6144, 'business', '1999-04-14 00:00:00', 0),
(3273, 133161, 'MBIT Technologies Pty Ltd', 'mbit.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3274, 133163, 'PP Ontime Company Limited', 'pp-ontime.co.th', 'TH', 1536, 'business', '0000-00-00 00:00:00', 0),
(3275, 133164, 'Viewqwest Digital Sdn. Bhd.', 'viewqwest.com', 'MY', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3276, 133166, 'PT Pertamina (Persero)', 'pertamina.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(3277, 133167, 'TMB Bank, Phahonyothin branch. ,', 'trueinternet.co.th', 'TH', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3278, 133168, 'Shahjalal University of Science and Technology', 'sust.edu', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(3279, 133169, 'University Malaysia Perlis', 'unimap.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(3280, 133171, 'Inhanced Cloud Pty Ltd', 'inhancedcloud.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3281, 133173, 'DGIT Systems', 'inomial.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3282, 133174, 'Neda Telecommunications', 'neda.af', 'AF', 512, 'isp', '0000-00-00 00:00:00', 0),
(3283, 133175, 'OZtell', 'oztell.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3284, 133177, 'Wicom Networks LLC', 'wicom.mn', 'MN', 1024, 'isp', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(3285, 133178, 'Australian Customs and Border Protection Service', 'customs.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3286, 133179, 'Syntegrate', 'syntegrate.asia', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(3287, 133186, 'COMPUTER & NETWORK SOLUTIONS LIMITED', 'cns.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3288, 133187, 'Ashnet Limited', 'ashnet.co.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3289, 133188, 'MWH Sydney POP', 'stantec.com', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(3290, 133189, 'SENTRIAN PTY LTD', 'sentrian.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3291, 13319, 'Storm Internet Services', 'storm.ca', 'CA', 16128, 'isp', '1999-04-15 00:00:00', 0),
(3292, 133191, 'Special Security Force (SSF), Bangladesh', 'ssf.gov.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3293, 133192, 'Ultimate Mobile limited', 'ultimatebroadband.co.nz', 'NZ', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3294, 133193, 'Provincial Electricity Authority (PEA)', 'pea.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(3295, 133194, 'Connections Hub Technology (Shanghai) Ltd. Company', 'connectionshub.co', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(3296, 133195, 'PERFETTI VAN MELLE ASIA PACIFIC PTE LTD - ROHQ', 'pvmgrp.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(3297, 133196, 'Localcom Pty Ltd', 'localcom.com.au', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(3298, 133198, 'iOne Resources, Inc.', 'ioneresources.net', 'PH', 768, 'business', '0000-00-00 00:00:00', 0),
(3299, 133199, 'SonderCloud Limited', 'sondercloud.com', 'HK', 39168, 'hosting', '0000-00-00 00:00:00', 0),
(3300, 133200, 'NeocomISP Limited', 'neocomisp.com', 'KH', 256, 'isp', '0000-00-00 00:00:00', 0),
(3301, 133201, 'ABCDE GROUP COMPANY LIMITED', 'qq.com', 'HK', 391680, 'hosting', '0000-00-00 00:00:00', 0),
(3302, 133202, 'AFSAT', 'afsat.af', 'AF', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3303, 133203, 'SBI BITS Co., Ltd.', 'sbibits.com', 'JP', 2048, 'business', '0000-00-00 00:00:00', 0),
(3304, 133204, 'BSL', 'bsl.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(3305, 133206, 'DGTEK PTY LTD', 'dgtek.net', 'AU', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3306, 13321, 'Technet International', 'technetinternational.com', 'US', 8192, 'business', '1999-04-16 00:00:00', 0),
(3307, 133210, 'EN Technologies Pte Ltd', 'en.net.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3308, 133212, 'Gold Fields Australia Pty Ltd', 'goldfields.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3309, 133214, 'PT Hutchison 3 Indonesia', 'tri.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3310, 133216, 'Yamaha Motor Australia', 'yamaha-motor.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3311, 133217, 'BACHBLUE PTY LTD T/A AFOYI', 'afoyi.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3312, 133218, 'Network Edge NZ Limited', 'network-edge.net', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3313, 133219, 'NewMedia Express Pte Ltd', 'newmediaexpress.com', 'CN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(3314, 13322, 'Fidelity Investments', 'fidelity.com', 'US', 13056, 'business', '1999-04-16 00:00:00', 0),
(3315, 133225, 'Indiabulls Ventures Ltd.', 'indiabullsventures.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3316, 133226, 'VISION SMARTLINK NETWORKING PRIVATE LIMITED', 'visionsmartlink.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3317, 133227, 'Anish Infoline Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3318, 133228, 'TwentyFourSevenCustomer', '247-inc.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3319, 133230, 'Aristocrat Technologies India Pvt Ltd', 'ali.com.au', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3320, 133231, 'Goods And Services Tax Network', 'gstn.org.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3321, 133232, 'SAMPARK ESTATES PVT. LTD.', 'samparkestates.com', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(3322, 133233, 'S.N. Bose National Centre for basic sceinces', 'bose.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3323, 133234, 'PLUSNET COMMUNICATION PVT. LTD.', 'plusnet.co.in', 'IN', 4096, 'business', '0000-00-00 00:00:00', 0),
(3324, 133235, 'GORAKHPUR NET SERVICES PVT. LTD.', 'gnspl.org', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3325, 133236, 'A3logics india Private Limited', 'a3logics.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3326, 133237, 'Apex Netcom India Pvt. Ltd.', 'apexnetcom.in', 'IN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(3327, 133238, 'AllTimeIT Solutions Pvt Ltd', 'alltimeit.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3328, 13324, 'Executive Personal Computers Inc.', 'epcusa.com', 'US', 512, 'business', '1999-04-16 00:00:00', 0),
(3329, 133240, 'WAVETREE NETWORKS PVT LTD', 'wave-tree.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3330, 133242, 'Infibeam Avenues Limited', 'ia.ooo', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3331, 133244, 'Craze It Solutions Pvt. Ltd.', 'crazetechnology.com', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(3332, 133246, 'softnet network', 'softnetnetwork.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3333, 133248, 'THE SKY INTERNET', 'theskyinternet.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3334, 133249, 'SEVEN INFOTECH', 'seveninfotech.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3335, 13325, 'State of Michigan, DMB-CNOC', 'state.mi.us', 'US', 524544, 'business', '1999-04-16 00:00:00', 0),
(3336, 133250, 'Pimoony Broadband Servivices Pvt Ltd', 'pimoony.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3337, 133255, 'Elxer Communications Private Limited', 'elxer.com', 'IN', 6656, 'isp', '0000-00-00 00:00:00', 0),
(3338, 133256, 'TANGEDCO', 'tnebnet.org', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3339, 133257, 'Spider Broadband And Cable Pvt. Ltd.', 'spiderbroadbandpcmc.net', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(3340, 133258, 'MCX STOCK EXCHANGE LIMITED', 'mcx-sx.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3341, 133259, 'Solutions Enterprise Pvt Ltd', 'sepl.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3342, 13326, 'Tufts University', 'tufts.edu', 'US', 65536, 'education', '1999-04-16 00:00:00', 0),
(3343, 133260, 'Gujarat Informatics Limited', 'gujarat.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3344, 133261, 'Vidarbh Wi-fi And Network Services Pvt. Ltd.', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3345, 133262, 'Tracmail I Pvt Ltd', 'tracmail.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3346, 133266, 'NET TECH SERVICES INDIA PVT. LTD.', 'ntsipl.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3347, 133269, 'Fiberpipe communications pvt. ltd', 'fiberpipe.in', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(3348, 13327, 'Eastern Kentucky University', 'eku.edu', 'US', 65536, 'education', '1999-04-16 00:00:00', 0),
(3349, 133270, 'Hps Digital Broadband Pvt Ltd', 'iaxntelecom.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3350, 133272, 'Sphier Infotech Private Limited', 'sphier.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3351, 133273, 'Tata Institute of Social Sciences', 'tiss.edu', 'IN', 1024, 'education', '0000-00-00 00:00:00', 0),
(3352, 133274, 'MPOnline Ltd', 'mponline.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3353, 133275, 'Gigantic Infotel Pvt Ltd', 'gtel.in', 'IN', 29184, 'isp', '0000-00-00 00:00:00', 0),
(3354, 133276, 'Birlasoft IndiaLtd.', 'birlasoft.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3355, 133277, 'Bajpai Telecom Private Limited', 'bajpaitelecom.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3356, 133278, 'Dehradun Enet Solutions Private Ltd', 'enet.net.in', 'IN', 8960, 'isp', '0000-00-00 00:00:00', 0),
(3357, 133279, 'SPEED4NET', 'irinn.in', 'IN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(3358, 133280, 'Jsw Steel Ltd', 'jsw.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3359, 133281, 'Kavach Networks Pvt Ltd', 'kavach.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3360, 133282, 'Solverminds and solutions Technologies', 'solverminds.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3361, 133283, 'Speedair webtech pvt. ltd', 'speedair.org', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3362, 133284, 'Airprime Internet Services Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3363, 133285, 'CNS Infotel Services Pvt. Ltd.', 'cns24x7.net', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3364, 133287, 'Andhra Pradesh State FiberNet Limited', 'apsfl.co.in', 'IN', 10240, 'isp', '0000-00-00 00:00:00', 0),
(3365, 133288, 'Balasai Net Pvt. Ltd.', 'balasai.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3366, 133289, 'Deshkal Network Pvt Ltd', 'deshkal.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3367, 13329, 'Kansas Fiber Network, LLC', 'ksfiber.net', 'US', 3072, 'business', '2010-11-02 00:00:00', 0),
(3368, 133290, 'Bob Communications Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3369, 133291, 'Srm Technologies Pvt. Ltd.', 'srmtech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3370, 133295, 'Web Werks India Pvt Ltd', 'webwerks.in', 'IN', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(3371, 133296, 'Web Werks India Pvt. Ltd.', 'webwerks.in', 'IN', 58880, 'hosting', '0000-00-00 00:00:00', 0),
(3372, 133297, 'Aeroway Networks Private Limited', 'aeroway.net', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3373, 133299, 'Yalamanchili Software Exports Ltd', 'yalamanchili.co.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3374, 13330, 'First American Real Estate Solutions', 'firstam.com', 'US', 12032, 'business', '2005-05-10 00:00:00', 0),
(3375, 133300, 'Soibam Technology Private Limited', 'skay.co.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3376, 133301, 'DWAN SUPPORTS P LTD', 'dwansupportspltd.co.in', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(3377, 133303, 'Janalakshmi Financial Services Pvt Ltd', 'janalakshmi.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3378, 133304, 'Hitech Broadband', 'hitechbroadband.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3379, 133305, 'Altimetrik India Private Limited', 'altimetrik.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3380, 133306, 'VMware India Software Pvt Ltd', 'vmware.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3381, 133308, 'Indira Gandhi Centre For Atomic Research', 'igcar.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3382, 133309, 'Access Smart Solutions India Pvt Ltd', 'access-smart.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3383, 13331, 'MetaPeer', 'metapeer.com', 'US', 8960, 'business', '1999-05-12 00:00:00', 0),
(3384, 133311, 'Maxtech Broadband Pvt Ltd', 'maxtechgroup.in', 'IN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(3385, 133312, 'LALCO PRIVATE LIMITED', 'lalco.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3386, 133313, 'Saha Institute of Nuclear Physics', 'saha.ac.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(3387, 133314, 'Bubble Server LLP.', 'bubblevps.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3388, 133315, 'Icontechnext', 'icontechnext.com', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3389, 133317, 'srinagar Net tech P ltd', 'snt.co.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3390, 13332, 'Hype Enterprises', 'hypeenterprises.com', 'US', 109312, 'isp', '2005-06-17 00:00:00', 0),
(3391, 133320, 'Alpha Infolab Private limited', 'alphainfolab.com', 'IN', 20480, 'hosting', '0000-00-00 00:00:00', 0),
(3392, 133321, 'Datacom QLD Internet ASN', 'datacom.com.au', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(3393, 133324, 'Ezi-Web', 'webtraf.com.au', 'AU', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3394, 133326, 'Sabervox', 'sabervox.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3395, 133327, 'Flextronics International Ltd.', 'flextronics.com', 'SG', 4096, 'business', '0000-00-00 00:00:00', 0),
(3396, 13333, 'Consolidated Communications, Inc.', 'consolidated.com', 'US', 138752, 'isp', '1999-05-13 00:00:00', 0),
(3397, 133331, 'Infobase Limited', 'infobd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3398, 133332, '5G NETWORK OPERATIONS PTY LTD', '5gn.com.au', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(3399, 133333, 'Frontier Networks Pty Ltd', 'frontiernetworks.com.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3400, 133334, 'DCTV Cable Network Broadband Services Inc', 'dctv.com.ph', 'PH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3401, 133335, 'Politeknik Negeri Padang', 'polinpdg.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3402, 133337, 'PT Menara Sinar Semesta', 'mss.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3403, 13334, 'MSG-ASN', 'm-s-g.com', 'None', 256, 'business', '2014-04-10 00:00:00', 0),
(3404, 133343, 'BADAN PERENCANAAN PEMBANGUNAN NASIONAL', 'bappenas.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3405, 133344, 'PT MetraPlasa', 'metraplasa.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3406, 133345, 'KEMENKO POLHUKAM RI', 'polkam.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3407, 133346, 'PT Global Digital Niaga', 'gdn-commerce.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3408, 133347, 'PT Indo Premier Securities', 'ipc.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3409, 133349, 'PT Jasa Utama Capital', 'juc.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3410, 13335, 'Cloudflare, Inc.', 'cloudflare.com', 'US', 1570816, 'business', '2010-07-14 00:00:00', 0),
(3411, 133352, 'PT. Berdikari Prima Mandiri', 'bpmandiri.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3412, 133354, 'PT Anugerah Karunia Perkasa Abadi', 'akpa.co.id', 'ID', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3413, 133355, 'Politeknik Negeri Bandung', 'polban.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3414, 133357, 'TELKOM UNIVERSITY', 'telkomuniversity.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3415, 133359, 'PT. Erudeye Indonesia', 'erudeye.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3416, 13336, 'Evergy Services, Inc.', 'evergy.com', 'US', 2304, 'business', '1999-05-15 00:00:00', 0),
(3417, 133360, 'PT Awinet Global Mandiri', 'awi.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3418, 133361, 'Universitas Katolik Parahyangan', 'unpar.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(3419, 133364, 'Politeknik Negeri Jakarta', 'pnj.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(3420, 13337, 'e-vergent.com LLC', 'e-vergent.com', 'US', 17152, 'isp', '1999-05-15 00:00:00', 0),
(3421, 133370, 'TODD ENERGY LIMITED', 'toddcorporation.com', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3422, 133371, 'ForwardIT', 'forwardit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3423, 133372, 'Interaptus Limited', 'interaptusltd.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3424, 133374, 'Md. Taskin Mahmood trading as BUCT Communication', 'buctbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3425, 133376, 'LAZADA Co.,Ltd.', 'lazada.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3426, 133377, 'IBM Business Services, Inc', 'ibm.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(3427, 133378, 'WiCAM Corporation Ltd.', 'wicam.com.kh', 'KH', 2816, 'isp', '0000-00-00 00:00:00', 0),
(3428, 133380, 'Layerstack Limited', 'layerstack.com', 'HK', 14848, 'business', '0000-00-00 00:00:00', 0),
(3429, 133382, 'THE BUSINESS DOCTOR NSW PTY LTD', 'bdnsw.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3430, 133383, 'Vanuatu Government,', 'gov.vu', 'VU', 256, 'isp', '0000-00-00 00:00:00', 0),
(3431, 133384, '5BB Broadband', 'redlink.net.mm', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3432, 133385, 'Telenor Myanmar', 'telenor.com.mm', 'MM', 10496, 'isp', '0000-00-00 00:00:00', 0),
(3433, 133386, 'Reliance Capital Limited', 'relianceada.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(3434, 133387, 'GOVERNMENT TECHNOLOGY AGENCY', 'tech.gov.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3435, 133388, 'IMS Health India Pvt Ltd', 'imshealth.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3436, 133389, 'ACURUS NETWORKS PTY LTD', 'acurus.com.au', 'AU', 5120, 'business', '0000-00-00 00:00:00', 0),
(3437, 13339, 'Amaya Gaming Group Inc', 'amayagaming.com', 'CA', 256, 'business', '2014-03-04 00:00:00', 0),
(3438, 133390, 'Cosmo System Pte Ltd', 'cosmo.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3439, 133391, 'SYSNETPRO SOLUTION PTE LTD', 'sysnetpro.asia', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3440, 133393, 'Naki Host Limited', 'nakihost.co.nz', 'NZ', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(3441, 133394, 'C2A.COM.AU', 'c2a.com.au', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(3442, 133396, 'TEAMnetwork Systems Ltd', 'teamnetwork.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3443, 133397, 'MESSAGE4U PTY LTD', 'messagemedia.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3444, 133398, 'Tele Asia Limited', 'tele-asia.net', 'HK', 8704, 'isp', '0000-00-00 00:00:00', 0),
(3445, 133399, 'HI-TECH SOLUTIONS LIMITED', 'hitechsolutions.co.nz', 'NZ', 2304, 'isp', '0000-00-00 00:00:00', 0),
(3446, 133400, 'Gumboot Internet Limited', 'hurst.net.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3447, 133401, 'Devoli-FREEDOMAU', 'devoli.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3448, 133403, 'Origin Net', 'originnet.com.au', 'AU', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3449, 133404, 'Online Republic Limited', 'onlinerepublic.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3450, 133408, 'UNIVERSITI TENAGA NASIONAL SDN BHD', 'uniten.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(3451, 133409, 'Unibet Services Limited', 'unibet.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3452, 13341, 'Tranquility Internet Services Inc.', 'tranquility.net', 'US', 6144, 'business', '1999-05-17 00:00:00', 0),
(3453, 133410, 'Business Zone Limited', 'businesszone.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3454, 133411, 'Mediamind Technologies LTD', 'mediamind.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3455, 133412, 'The Ogilvy Group, Inc.', 'ogilvy.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3456, 133413, 'LicenSys', 'licensys.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3457, 133414, 'Foxtel Management Pty Ltd', 'foxtel.com.au', 'AU', 532736, 'isp', '0000-00-00 00:00:00', 0),
(3458, 133415, 'Tango Technology', 'tangotechnology.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3459, 133416, 'PayGo SEA Cambodia Co., Ltd.', 'isp.my', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(3460, 133417, 'Dicker Data Ltd', 'dickerdata.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3461, 133419, 'Source Technology Pty Ltd', 'sourcetechnology.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(3462, 13342, 'Trenton TV Cable Company', 'trentoncable.com', 'US', 6912, 'business', '2007-06-04 00:00:00', 0),
(3463, 133420, 'Network for Learning', 'spark.co.nz', 'NZ', 9728, 'isp', '0000-00-00 00:00:00', 0),
(3464, 133421, 'INNET SOLUTIONS SDN BHD', 'innet.com.my', 'MY', 6144, 'isp', '0000-00-00 00:00:00', 0),
(3465, 133422, 'Aviva Asia Pte Ltd', 'aviva.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3466, 133424, 'Donghwa Telecom Co., Limited', 'donghwatele.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3467, 133427, 'OPTOMA PROJECTORS INDIA PRIVATE LIMITED', 'way2movies.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3468, 133429, 'Phoenix', 'wisperconnect.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3469, 13343, 'Charter Communications Inc', 'charter.com', 'US', 17408, 'isp', '2000-06-09 00:00:00', 0),
(3470, 133430, 'Islami Bank Bangladesh Limited', 'islamibankbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3471, 133431, 'Acurix Networks Pty Ltd', 'acurixnetworks.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3472, 133433, 'Loop Contact Solutions, Inc.', 'loopcontactsolutions.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(3473, 133435, 'REMMAH PROPERTIES PTY LTD', 'controlability.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3474, 133437, 'MXCloud Sdn. Bhd', 'mxcloud.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(3475, 133438, 'St John Ambulance Western Australia Ltd.', 'stjohnambulance.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3476, 133439, 'The Daily Star', 'thedailystar.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3477, 13344, 'NetEx Inc.', 'cw-realty.com', 'US', 768, 'business', '2012-03-29 00:00:00', 0),
(3478, 133440, 'ST-net', 'stnetinc.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(3479, 133441, 'CloudITIDC Global', 'clouditidc.com', 'KR', 5120, 'hosting', '0000-00-00 00:00:00', 0),
(3480, 133443, 'Comilla Online', 'comillaonline.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(3481, 133444, 'Net2One Sdn Bhd', 'net2one.my', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(3482, 133448, 'Korea', '7bull.net', 'HK', 5632, 'hosting', '0000-00-00 00:00:00', 0),
(3483, 133449, 'VASTNET LLP', 'vastspace.net', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3484, 13345, 'Massive Networks', 'massivenetworks.com', 'US', 1280, 'business', '1999-05-18 00:00:00', 0),
(3485, 133450, 'University Of Chittagong', 'cu.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(3486, 133451, 'PC Soft Limited', 'wd.net.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3487, 133453, 'Mogul Service and Support LLC', 'itzone.mn', 'MN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3488, 133455, 'SKYCITY Entertainment Group Limited', 'skycity.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3489, 133456, 'ALAGAS NETWORK PTE. LTD.', 'alagas.net', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3490, 133457, 'Giganor ISP', 'giganor.com', 'AF', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3491, 13346, 'Centurion Medical Products Corporation', 'centurionmp.com', 'US', 512, 'business', '2010-10-14 00:00:00', 0),
(3492, 133461, 'Eqhost Sdn Bhd', 'eqhost.com', 'MY', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3493, 133462, 'Texas Instruments, Inc.', 'ti.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3494, 133465, 'Duke Kunshan University', 'duke.edu', 'CN', 1280, 'education', '0000-00-00 00:00:00', 0),
(3495, 133466, 'Robert Bosch GmbH', 'bosch.de', 'SG', 4096, 'business', '0000-00-00 00:00:00', 0),
(3496, 133468, 'Abul Kashem trading as Active Network', 'activenetworkbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(3497, 133469, 'Multinet (Udaipur) Private Limited', 'multinetudaipur.com', 'IN', 5632, 'isp', '0000-00-00 00:00:00', 0),
(3498, 133470, 'Integrated Health Information Systems Pte Ltd', 'ihis.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3499, 133471, 'Integrated Health Information Systems Pte Ltd', 'ihis.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3500, 133475, 'New York University ASN', 'nyu.edu', 'CN', 768, 'education', '0000-00-00 00:00:00', 0),
(3501, 133476, 'First Innovation K.K.', 'firstinnovation.co.jp', 'JP', 2048, 'business', '0000-00-00 00:00:00', 0),
(3502, 133477, 'Bangladesh Police', 'police.gov.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3503, 133479, 'CDK GLOBAL, LLC Singapore', 'cdk.com', 'US', 768, 'business', '0000-00-00 00:00:00', 0),
(3504, 13348, 'CIGNA', 'cigna.com', 'US', 17664, 'business', '2010-03-05 00:00:00', 0),
(3505, 133480, 'Intergrid Group Pty Ltd', 'intergrid.com.au', 'AU', 10496, 'isp', '0000-00-00 00:00:00', 0),
(3506, 133481, 'AIS Fibre', 'ais.co.th', 'TH', 227584, 'isp', '0000-00-00 00:00:00', 0),
(3507, 133483, 'SWITCH TV PTY LTD T/A SWITCH MEDIA', 'switch.tv', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3508, 133485, 'Gameloft Limited', 'gameloft.com', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(3509, 133486, 'CSC Australia Pty Ltd', 'csc.com.au', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3510, 133488, 'service limited', 'servicehk.net', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3511, 13349, 'TEACHERS CREDIT UNION', 'tcunet.com', 'US', 512, 'business', '2010-12-08 00:00:00', 0),
(3512, 133491, 'Synchronoss Technologies India Private Limited', 'synchronoss.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3513, 133492, 'AIYUN', 'aiyun.com.cn', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(3514, 133493, 'Chaptech Pty Ltd', 'matilda.net.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3515, 133494, 'AIR NETWORKS WISP ASN', 'airnetworks.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3516, 133495, 'Vision telecom Private limited', 'visiontelecom.com.pk', 'PK', 3328, 'isp', '0000-00-00 00:00:00', 0),
(3517, 133496, 'CDN PLUS CO., LTD.', 'cdnp.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(3518, 133498, 'De La Salle University', 'dlsu.edu.ph', 'PH', 768, 'education', '0000-00-00 00:00:00', 0),
(3519, 13350, 'Digital Realty Trust, L.P.', 'digitalrealty.com', 'US', 256, 'business', '2017-12-12 00:00:00', 0),
(3520, 133500, 'Lao Gateway Co., Ltd', 'laogw.la', 'LA', 1024, 'business', '0000-00-00 00:00:00', 0),
(3521, 133501, 'QCS Group', 'qcsgroup.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3522, 133505, 'McKinsey & Company', 'mckinsey.com', 'IN', 2304, 'business', '0000-00-00 00:00:00', 0),
(3523, 133506, 'McKinsey & Company', 'mckinsey.com', 'IN', 3328, 'business', '0000-00-00 00:00:00', 0),
(3524, 133509, 'PowerNET IT Consultants Pty Ltd', 'power-net.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3525, 13351, 'Barbourville Utility Commission', 'barbourville.com', 'US', 4096, 'business', '1999-05-19 00:00:00', 0),
(3526, 13352, 'Mark G. Thomas Consulting', 'misty.com', 'US', 1536, 'business', '2006-10-19 00:00:00', 0),
(3527, 133520, 'DSP BlackRock Investment Managers Pvt. Ltd', 'dspblackrock.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3528, 133523, 'SMARTSPEAK SOLUTIONS PTY LTD', 'smartspeak.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3529, 133524, 'Global Technology Co., Ltd.', 'globalnet.com.mm', 'MM', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3530, 133525, 'Nimbus2 Pty Ltd', 'servermule.com.au', 'AU', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(3531, 133527, 'HuaBo Technology International Limited', 'huabo.tech', 'HK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3532, 133528, 'Mohammad Humayan Ur', 'nslbd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3533, 133529, 'Land and Houses Bank Public Company Limited', 'lhbank.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3534, 13353, 'Telmex do Brasil Ltda.', 'embratel.com.br', 'BR', 147456, 'business', '1999-11-16 00:00:00', 0),
(3535, 133530, 'ATLASSIAN PTY LTD', 'atlassian.com', 'AU', 3328, 'business', '0000-00-00 00:00:00', 0),
(3536, 133532, 'ASN for .nz InternetNZ Registry Content', 'internetnz.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3537, 133533, 'TRISTAR ISP', 'tristar.af', 'AF', 512, 'business', '0000-00-00 00:00:00', 0),
(3538, 133534, 'Ladbrokes Digital Australia Pty Ltd', 'ladbrokes.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(3539, 133535, 'PRIMABANANEN PTE. LTD.', 'primabananen.net', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3540, 133536, 'BB00 Networks', 'bb00.net', 'AU', 2560, 'business', '0000-00-00 00:00:00', 0),
(3541, 133537, 'Downer New Zealand Limited', 'downer.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3542, 133538, 'HYPERNODE PTY. LTD.', 'hypernode.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(3543, 13354, 'zColo', 'corexchange.com', 'US', 65536, 'hosting', '2007-03-08 00:00:00', 0),
(3544, 133540, 'EarthFactor Pvt Ltd', 'earthfactor.net', 'PK', 768, 'business', '0000-00-00 00:00:00', 0),
(3545, 133541, 'SIPPE-SG', 'sabic-ip.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3546, 133542, 'OSS Infotech Pty Ltd', 'omtelecom.net.au', 'AU', 4096, 'business', '0000-00-00 00:00:00', 0),
(3547, 133543, 'DTAC TriNet Co.,Ltd.', 'dtacnetwork.co.th', 'TH', 2304, 'business', '0000-00-00 00:00:00', 0),
(3548, 133544, 'The trustee for MLK Group Trust', 'mlkgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3549, 133546, 'Bell Potter Securities Ltd', 'bellpotter.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3550, 133547, 'Bit Net Technology', 'bitnetbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3551, 133548, 'RDG Electrical & Communications Solutions Pty Ltd', 'rdg.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3552, 13355, 'ANSWER FINANCIAL INC', 'answerfinancial.com', 'US', 256, 'business', '2018-07-18 00:00:00', 0),
(3553, 133552, 'B.M.S College Of Engineering', 'bmsce.ac.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(3554, 133553, 'AMAZE360 PTY LTD', 'amaze360.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3555, 133556, 'DCSI Business Broadband', 'streamlinenetworksolutions.com.au', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(3556, 133557, 'Loop Networks Pvt. Ltd.', 'loopnet.com.np', 'NP', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3557, 13356, 'Panora Telco', 'panoratelco.com', 'US', 5632, 'isp', '2017-07-18 00:00:00', 0),
(3558, 13357, 'Irati Telecomunicações Ltda.', 'irati.net.br', 'BR', 2048, 'business', '1999-11-18 00:00:00', 0),
(3559, 133578, 'DOERS NETWORKS LIMITED', 'doersnetworks.com', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3560, 133579, 'MYREPUBLIC LIMITED', 'myrepublic.co.nz', 'NZ', 14848, 'isp', '0000-00-00 00:00:00', 0),
(3561, 13358, 'DIGITAL RAZOR, INC', 'digitalrazor.com', 'US', 256, 'business', '1999-05-19 00:00:00', 0),
(3562, 133580, 'Vodafone Mobile Services Ltd', 'vodafone.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3563, 133581, 'Thailand Post Co,.Ltd.', 'thailandpost.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(3564, 133583, 'Digicel Carrier Services (Pacific) Limited', 'digicelgroup.com', 'HK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3565, 133584, 'Hills Limited', 'hills.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3566, 133586, 'Tiitacs IT and IT Solutions', 'tiitacs.com', 'AF', 512, 'business', '0000-00-00 00:00:00', 0),
(3567, 133587, 'Bain and Company', 'bain.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3568, 133588, 'Sabay Digital Group', 'gaertner.cc', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(3569, 133589, 'DECO MEDIA AND COMMUNICATIONS PVT LTD', 'decobroadband.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3570, 13359, 'North Texas GigaPOP', 'tx-learn.net', 'US', 512, 'business', '2007-04-03 00:00:00', 0),
(3571, 133590, 'Wow Solutions and Systems Pvt Ltd', 'wowsolutions.in', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(3572, 133591, 'Interglobe Enterprises. Ltd', 'interglobe.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3573, 133593, 'VIZAG BROADCASTING COMPANY PVT. LTD', 'vbctv.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3574, 133597, 'Max tech media and communications pvt ltd', 'irinn.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3575, 133599, 'Fairfax NZ SDC', 'fairfaxmedia.com.au', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3576, 13360, 'Triton Digital', 'tritondigital.com', 'CA', 3328, 'business', '2007-06-05 00:00:00', 0),
(3577, 133600, 'ESSEC', 'essec.edu', 'SG', 256, 'education', '0000-00-00 00:00:00', 0),
(3578, 133602, 'Neos Asia Pacific Pte Ltd', 'neosit.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(3579, 133603, 'Evision Pty Ltd', 'evision.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3580, 133604, 'MidCentral District Health Board', 'midcentraldhb.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3581, 133605, 'Bright Technologies Limited', 'btl.net.bd', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(3582, 133606, 'Viettel Timor Leste', 'telemor.tl', 'TL', 6144, 'isp', '0000-00-00 00:00:00', 0),
(3583, 133607, 'Web Connect NZ', 'webconnect.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3584, 133609, 'Infinity Supercorridor Sdn Bhd', 'valiramgroup.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(3585, 13361, 'American Computer Group, Inc.', 'whitehat.com', 'US', 768, 'business', '1999-05-20 00:00:00', 0),
(3586, 133610, 'ASN of BRAC', 'brac.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(3587, 133612, 'Vodafone Australia Pty Ltd', 'vodafone.com.au', 'AU', 1376256, 'isp', '0000-00-00 00:00:00', 0),
(3588, 133613, 'MTel telecommunication company ltd.', 'mtel.mo', 'MO', 14336, 'isp', '0000-00-00 00:00:00', 0),
(3589, 133615, 'Tecala ICT Pty Limited', 'tecala.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3590, 133616, 'Beachhead Group Pty. Ltd.', 'beachheadgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3591, 133617, 'ICT Enterprise', 'None', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(3592, 133618, 'Trellian Pty. Limited', 'trellian.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3593, 13362, 'PCWorld.com', 'pcworld.com', 'US', 256, 'business', '1999-05-20 00:00:00', 0),
(3594, 133622, 'Bottomline Technologies Pte. Ltd.', 'bottomline.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3595, 133623, 'Planet Cable Inc.', 'planetcabletv.com', 'PH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3596, 133624, 'EVOLUTION SYSTEMS PTY LIMITED', 'evolutionsystems.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3597, 133627, 'A.P.Eagers Ltd', 'apeagers.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3598, 13363, 'ASG Technologies Group, Inc.', 'asg.com', 'US', 1024, 'business', '1999-05-20 00:00:00', 0),
(3599, 133633, 'MultiTech Online', 'multitech.net.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3600, 133636, 'Fisheye Limited', 'fisheye.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3601, 133638, 'TrackNet services Pvt Ltd', 'onlinetrack.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3602, 13364, 'Jive Software Inc.', 'jivesoftware.com', 'US', 12288, 'business', '2009-10-26 00:00:00', 0),
(3603, 133643, 'Ewebguru', 'ewebguru.com', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(3604, 133644, 'RESEARCH CENTER IMARAT', 'rcilab.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3605, 133645, 'Yms Networks Pvt. Ltd', 'yms.net.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3606, 133647, 'ELXIRE DATA SERVICES PVT. LTD.', 'elxire.com', 'IN', 22528, 'isp', '0000-00-00 00:00:00', 0),
(3607, 133648, 'MNR Broadband Services Pvt. Ltd.', 'espl.in', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3608, 13365, 'THL Credit Advisors, LLC', 'thlcredit.com', 'US', 256, 'business', '2010-12-09 00:00:00', 0),
(3609, 133650, 'Mando Softtech India Pvt. Ltd.', 'halla.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3610, 133651, 'oasis cable pvt. ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3611, 133652, 'Zapbytes Technologies Pvt. Ltd.', 'zapbytes.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3612, 133653, 'Cyber Infrastructure (P) Limited', 'cisin.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3613, 133657, 'Indusind bank ltd', 'indusind.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3614, 133658, 'Ishani Broadband Pvt.ltd', 'spidinet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3615, 133659, 'NTPC Limited', 'ntpc.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3616, 133660, 'E-Infrastructure and Entertainment India Pvt. Ltd', 'edigital.co.in', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(3617, 133661, 'Netplus Broadband Services Private Limited', 'netplus.co.in', 'IN', 23296, 'isp', '0000-00-00 00:00:00', 0),
(3618, 133662, 'SHREENET', 'shreenet.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3619, 133663, 'SLK Global BPO Services Pvt Ltd.', 'slkglobalbpo.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3620, 133668, 'Eikon Technologies', 'eikontech.net', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3621, 133669, 'Arvind Limited', 'arvind.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3622, 13367, 'Comcast Cable Communications, LLC', 'comcast.com', 'US', 145152, 'isp', '2001-12-20 00:00:00', 0),
(3623, 133671, 'NETLINK SOFTWARE PVT.LTD', 'netlink.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3624, 133673, 'KWIKZO.Com Technology Private Limited', 'kwikzo.co.in', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(3625, 133674, 'Adarsh Infosolutions', 'adarshinfosolutions.net', 'IN', 2304, 'business', '0000-00-00 00:00:00', 0),
(3626, 133676, 'Precious netcom pvt ltd', 'preciousnetcom.in', 'IN', 16384, 'isp', '0000-00-00 00:00:00', 0),
(3627, 133678, 'Vizag Broadband Communications Pvt Ltd', 'vbcommunications.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3628, 133679, 'Raze Networks Private Limited', 'razenetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3629, 13368, 'Vyve Broadband', 'vyvebb.com', 'US', 21504, 'isp', '1999-05-24 00:00:00', 0),
(3630, 133680, 'Softech Infosol Pvt. Ltd.', 'softechinfosol.com', 'IN', 2816, 'business', '0000-00-00 00:00:00', 0),
(3631, 133684, 'Sun Broadband And Data Services Pvt Ltd', 'sunbroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3632, 133685, 'SDN TELECOM PVT LTD', 'signumtv.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3633, 133686, 'UNICEF', 'unicef.org', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3634, 133690, 'Rohela Broadband Network Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3635, 133692, 'Fastnet Communication Pvt. Ltd.', 'fastnet.me', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3636, 133693, 'Sri Krishna Internet Services Private Limited', 'skisp.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3637, 133694, 'EMAX GLOBAL MEDIA PVT. LTD.', 'emaxglobal.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3638, 133695, 'Wefe Technology Pvt Ltd', 'wefe.in', 'IN', 4608, 'isp', '0000-00-00 00:00:00', 0),
(3639, 133696, 'Fastway Transmission Private Limited', 'fastway.in', 'IN', 5376, 'isp', '0000-00-00 00:00:00', 0),
(3640, 133697, 'Nikhil Network Solution', 'nikhilnetworksolution.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3641, 133698, 'Aditya Birla Nuvo Ltd', 'adityabirlanuvo.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3642, 133699, 'Ziptel IT Solutions Pvt Ltd', 'ziptel.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3643, 13370, 'LocalTel Communications', 'localtel.com', 'US', 40192, 'isp', '1999-05-24 00:00:00', 0),
(3644, 133700, 'Gleam worldwide services pvt ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3645, 133702, 'Beamon Technologies Private Limited', 'beamontech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3646, 133703, 'Dalmia Bharat Limited', 'dalmiabharat.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3647, 133706, 'Gigantic Internet Services Pvt. Ltd.', 'gispl.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3648, 133707, 'La Pointe Telecom Solutions Pvt Ltd', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(3649, 133708, 'BSE LTD', 'bseindia.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3650, 13371, 'Duke University', 'duke.edu', 'US', 147712, 'education', '2006-10-03 00:00:00', 0),
(3651, 133711, 'Home Broadband Services LLP', 'homebroadband.tv', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3652, 133712, 'Spectra Technologies India Private Limited', 'spectraindia.com', 'IN', 2560, 'business', '0000-00-00 00:00:00', 0),
(3653, 133713, 'SWIFTNET BROADBAND PRIVATE LIMITED', 'swiftnetbroadband.net', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3654, 133715, 'YPT Entertainment House Pvt Ltd', 'irinn.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3655, 133716, 'SS NetCom Pvt. Ltd.', 'ssnetcom.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3656, 13372, 'Federated Investors', 'federatedinv.com', 'US', 256, 'business', '1999-05-24 00:00:00', 0),
(3657, 133720, 'SOFT CALL CUST-O-CARE PRIVATE LIMITED', 'softcall.net.in', 'IN', 20224, 'isp', '0000-00-00 00:00:00', 0),
(3658, 133722, 'mCarbon Tech Innovation Private Limited', 'mcarbon.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3659, 133723, 'Institute for Plasma Research', 'ipr.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3660, 133724, 'Swastik Internet and Cables pvt. ltd.', 'swastikinternet.com', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3661, 133725, 'AIRPORTS AUTHORITY OF INDIA', 'aai.aero', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3662, 133726, 'BLUEWEB NETWORK SOLUTIONS PVT.LTD.', 'blueweb.co.in', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3663, 133728, 'Chubb Asia Pacific Pte Ltd', 'cscglobal.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3664, 133729, 'Equinox Limited', 'equinox.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3665, 133730, 'Advatel Wireless Pty Ltd', 'advatel.net.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3666, 133731, 'Xinyuan Interconnect (HK) Limited', 'xyisp.hk', 'HK', 3328, 'hosting', '0000-00-00 00:00:00', 0),
(3667, 133734, 'McKinsey & Company', 'mckinsey.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3668, 133735, 'McKinsey & Company', 'mckinsey.com', 'SG', 1536, 'business', '0000-00-00 00:00:00', 0),
(3669, 133736, 'Field Solutions', 'fieldsolutions-group.com', 'AU', 10496, 'isp', '0000-00-00 00:00:00', 0),
(3670, 133737, 'BARWON HEALTH trading as SOUTH WEST ALLIANCE OF RURAL HEALTH (SWARH)', 'swarh.vic.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3671, 133738, 'Bangladesh Open University', 'bou.edu.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(3672, 133739, 'CoreDV Pty Ltd ts', 'coredv.com.au', 'AU', 5120, 'business', '0000-00-00 00:00:00', 0),
(3673, 13374, 'D\'Youville College', 'dyc.edu', 'US', 256, 'education', '2012-04-30 00:00:00', 0),
(3674, 133742, 'State Trading Organization Plc', 'sto.mv', 'MV', 256, 'business', '0000-00-00 00:00:00', 0),
(3675, 133744, 'Better Cloud Limited', 'None', 'HK', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3676, 133745, 'InternetNZ', 'internetnz.net.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3677, 133747, 'TRIUMPH DYNASTY Limited', 'None', 'HK', 10496, 'hosting', '0000-00-00 00:00:00', 0),
(3678, 133748, 'CORETEL NETWORKS (INTERNATIONAL) PTE LTD', 'coretelnet.com', 'SG', 6400, 'business', '0000-00-00 00:00:00', 0),
(3679, 13375, 'Payless ShoeSource, Inc.', 'payless.com', 'US', 512, 'business', '1999-05-25 00:00:00', 0),
(3680, 133750, 'Deere & Company', 'deere.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3681, 133751, 'Pacific Net Venture Co., Ltd.', 'servenet.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3682, 133752, 'Leaseweb Asia Pacific pte. ltd.', 'leaseweb.com', 'HK', 15104, 'hosting', '0000-00-00 00:00:00', 0),
(3683, 133755, 'AIA Bhd.', 'aia.com.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(3684, 133756, 'Satlan Corporation Limited', 'satlan.com', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3685, 133758, 'OZtell', 'oztell.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3686, 13376, 'Toppan Merrill LLC', 'toppanmerrill.com', 'US', 65536, 'business', '1999-05-25 00:00:00', 0),
(3687, 133760, 'Electronics Extreme Co., Ltd', 'extreme.co.th', 'TH', 1536, 'business', '0000-00-00 00:00:00', 0),
(3688, 133761, 'Mr. Naphat', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(3689, 133762, 'NETWORK JOINT (HK) LIMITED', 'qq.com', 'HK', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3690, 133767, 'SAP', 'sap.com', 'AU', 5376, 'business', '0000-00-00 00:00:00', 0),
(3691, 133768, 'Schneider Electric India Pvt Ltd', 'schneider-electric.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3692, 13377, 'Rogue Broadband', 'roguebroadband.com', 'US', 1024, 'business', '2009-06-19 00:00:00', 0),
(3693, 133771, 'Rapid Shield Company Limited', 'rapid-shield.com', 'HK', 30720, 'business', '0000-00-00 00:00:00', 0),
(3694, 133772, 'New Eagle Ltd', 'None', 'HK', 12288, 'hosting', '0000-00-00 00:00:00', 0),
(3695, 133774, 'Fuzhou', 'chinatelecom.cn', 'CN', 177408, 'isp', '0000-00-00 00:00:00', 0),
(3696, 133775, 'Xiamen', 'chinatelecom.cn', 'CN', 77824, 'isp', '0000-00-00 00:00:00', 0),
(3697, 133776, 'Quanzhou', 'chinatelecom.cn', 'CN', 21248, 'isp', '0000-00-00 00:00:00', 0),
(3698, 133778, 'GY Consultancy Group Inc.', 'gycgi.com', 'PH', 2048, 'business', '0000-00-00 00:00:00', 0),
(3699, 133779, 'Huayun Data International Limited', 'huayun.com', 'HK', 9216, 'hosting', '0000-00-00 00:00:00', 0),
(3700, 13378, 'BACKGROUND INVESTIGATION BUREAU INC', 'bib.com', 'US', 768, 'business', '2007-06-05 00:00:00', 0),
(3701, 133782, 'Elsevier Ltd', 'elsevier.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(3702, 133785, 'KeepItSafe New Zealand Limited', 'keepitsafe.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3703, 133787, 'Primary Health Care', 'healius.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3704, 133788, 'Unified National Networks', 'unn.com.bn', 'BN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3705, 133789, 'MORE ACTION TECHNOLOGY LIMITED', 'more-action.net', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3706, 13379, 'Disney Worldwide Services, Inc.', 'disney.com', 'US', 768, 'business', '1999-05-25 00:00:00', 0),
(3707, 133791, 'Teledirect Telecommerce', 'teledirectasia.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3708, 133792, 'AVANTE I.T. PTY LTD', 'avante-group.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3709, 133793, 'ABN Amro Clearing Sydney Pty Ltd', 'abnamroclearing.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3710, 133794, 'ABN Amro Clearing Sydney Pty Ltd', 'abnamroclearing.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3711, 133796, 'Subbid Sistem Jaringan dan Infrastruktur', 'kemendag.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3712, 133797, 'PT Rekajasa Akses', 'bitek.net.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(3713, 133798, 'PT. Smartfren Telecom, Tbk', 'smartfren.com', 'ID', 2816, 'isp', '0000-00-00 00:00:00', 0),
(3714, 133799, 'PT. GOMEDS NETWORK', 'gomeds.net.id', 'ID', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3715, 13380, 'Zix Corporation', 'zix.com', 'US', 4096, 'business', '1999-05-25 00:00:00', 0),
(3716, 133800, 'PT Biznet Gio Nusantara', 'biznetgio.com', 'ID', 13824, 'hosting', '0000-00-00 00:00:00', 0),
(3717, 133802, 'Universitas Pasundan Bandung', 'unpas.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(3718, 133803, 'PT Semesta Teknologi Informatika', 'sti-group.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3719, 133804, 'PT FANGBIAN ISKAN CORPORINDO', 'fic.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3720, 133805, 'Politeknik Manufaktur Negeri Bandung', 'polman-bandung.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3721, 133807, 'Badan Pertanahan Nasional', 'bpn.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3722, 133808, 'PT Jetcoms Netindo', 'jetcoms.net.id', 'ID', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3723, 133809, 'PT. Artorius Telemetri Sentosa', 'artorius.net.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(3724, 13381, 'CMET SACI', 'cmet.net', 'CL', 8192, 'isp', '1999-05-25 00:00:00', 0),
(3725, 133811, 'PT Inti Bangun Sejahtera, tbk', 'ibstower.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(3726, 133812, 'LCM NETWORKS', 'beritagar.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3727, 133814, 'PT Sumatera Global Mediatek', 'sumateranet.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(3728, 133815, 'PT Primacom Interbuana', 'primacom.com', 'ID', 10240, 'isp', '0000-00-00 00:00:00', 0),
(3729, 133816, 'Kementrian Lingkungan Hidup', 'menlhk.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3730, 133817, 'PT Inti Data Telematika', 'inti.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3731, 133819, 'PT CITRA INFOMEDIA', 'citrainfomedia.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(3732, 13382, 'Business Solutions Group, LLC', 'businesssolutionsgroup.net', 'US', 1024, 'business', '2014-03-31 00:00:00', 0),
(3733, 133822, 'PT Kereta Api Indonesia (Persero)', 'kai.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3734, 133823, 'PT Infokom Elektrindo', 'infokom.id', 'ID', 4864, 'isp', '0000-00-00 00:00:00', 0),
(3735, 133824, 'Universitas Islam Negeri Alauddin Makasar', 'uin-alauddin.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3736, 133825, 'Universitas Pattimura', 'unpatti.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3737, 133827, 'UNIVERSITAS ISLAM INDONESIA', 'uii.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(3738, 13383, 'Information Builders', 'informationbuilders.com', 'US', 256, 'business', '2014-07-21 00:00:00', 0),
(3739, 133832, 'Universitas Mercu Buana Yogyakarta', 'mercubuana-yogya.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3740, 133833, 'Bank UOB Indonesia', 'uob.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3741, 133834, 'Bank ICBC Indonesia', 'icbc.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3742, 133835, 'CV Xtra Prosolusindo', 'xofast.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(3743, 133838, 'PT Infotek Global Network', 'infotekglobal.net', 'ID', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3744, 133839, 'Dinas Komunikasi dan Informatika Tangerang Kota', 'tangerangkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3745, 133840, 'PT Jala Lintas Media', 'jlm.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(3746, 133841, 'INDONESIA BROADBAND ACCESS - ANYWHERE', 'idola.net.id', 'ID', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3747, 133842, 'PT BNI Life Insurance', 'bni-life.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(3748, 133843, 'PT Bank Rakyat Indonesia', 'bri.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(3749, 133844, 'Universitas Islam Negeri Suska Riau', 'uinsuska.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(3750, 133846, 'IMLONGHAO', 'imlonghao.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(3751, 133847, 'Anpple Tech Enterprise', 'hiero7.com', 'MY', 54784, 'isp', '0000-00-00 00:00:00', 0),
(3752, 133848, 'Internet Datacenter Network', 'ais.co.th', 'TH', 3584, 'isp', '0000-00-00 00:00:00', 0),
(3753, 133850, 'Airbnb, Inc.', 'airbnb.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3754, 133851, 'RIBBON COMMUNICATIONS AUSTRALIA PTY', 'ribboncommunications.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3755, 133852, 'DBS Bank (Hong Kong) Limited', 'dbs.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(3756, 133853, 'Century Yuasa Batteries Pty Ltd', 'cyb.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3757, 133854, 'X-press Technologies Limited.', 'xpress.ltd', 'BD', 4864, 'isp', '0000-00-00 00:00:00', 0),
(3758, 133857, 'Callaghan Innovation', 'callaghaninnovation.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3759, 133858, 'VWGROUP, AW Global Technology CO.,Ltd', '66.net', 'PH', 5632, 'business', '0000-00-00 00:00:00', 0),
(3760, 133859, 'Virtual Machine Technology Pty Ltd', 'vmtech.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3761, 133862, '1-Net Singapore Pte Ltd', '1-net.com.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3762, 133863, 'PROBAX PTY LTD', 'probax.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3763, 133864, 'Oper8 Pty Ltd', 'oper8.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3764, 133865, 'Beijing IQIYI Science & Technology Co., Ltd.', 'iqiyi.com', 'CN', 8448, 'business', '0000-00-00 00:00:00', 0),
(3765, 133866, 'U-Turn Technologies', 'None', 'BD', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(3766, 133868, 'ING Bank N.V', 'ing.nl', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3767, 133870, 'Brand Developers Limited', 'branddevelopers.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3768, 133872, 'EYGBS (India) Pvt Ltd', 'ey.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3769, 133873, 'CAMPAIGN MONITOR PTY LTD', 'campaignmonitor.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3770, 133874, 'MYNIC Berhad', 'mynic.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(3771, 133876, 'e-secure Pty Ltd', 'e-secure.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3772, 133878, 'UNICOM NEW ZEALAND LIMITED', 'unicomnz.com', 'NZ', 2304, 'isp', '0000-00-00 00:00:00', 0),
(3773, 13388, 'Egyptian Telephone', 'egyptian.net', 'US', 18432, 'business', '1999-05-26 00:00:00', 0),
(3774, 133880, 'The Thai Red Cross Society', 'redcross.or.th', 'TH', 2048, 'business', '0000-00-00 00:00:00', 0),
(3775, 133881, 'Retrac Business Solutions Pty Ltd', 'retrac.com.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(3776, 133882, 'PARAGON INTERNET GROUP LIMITED', 'paragon.net.uk', 'SG', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(3777, 133883, 'mGage India Pvt Limited', 'mgage.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3778, 133884, 'Airways Corporation of New Zealand', 'airways.co.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(3779, 133885, 'TransgridTelco', 'transgrid.com.au', 'AU', 5376, 'business', '0000-00-00 00:00:00', 0),
(3780, 133886, 'Sibasa Holdings Ltd.', 'sibasaholdings.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(3781, 133887, 'CyberHub Ltd', 'cyberhub.co.nz', 'NZ', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3782, 133888, 'Geo-Informatics and Space Technology Development', 'gistda.or.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(3783, 133889, 'Precision Computer (Malaysia) Sdn Bhd', 'server2u.net', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(3784, 13389, 'AZUKI, LLC', 'azukinet.com', 'US', 18176, 'business', '2002-06-24 00:00:00', 0),
(3785, 133890, 'Bangladesh Army', 'army.mil.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(3786, 133891, 'Fidessa ltd', 'fidessa.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(3787, 133894, 'Easy Connect- ISP', 'easyconnect.af', 'AF', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3788, 133895, 'Pentanet Pty Ltd', 'pentanet.com.au', 'AU', 256, 'isp', '0000-00-00 00:00:00', 0),
(3789, 133897, 'Palau Equipment Co. Inc.', 'palautelecoms.com', 'PW', 512, 'isp', '0000-00-00 00:00:00', 0),
(3790, 133898, 'FLIP TV PTY LIMITED', 'fliptv.com.au', 'AU', 5376, 'isp', '0000-00-00 00:00:00', 0),
(3791, 1339, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 3072, 'isp', '1994-11-23 00:00:00', 0),
(3792, 133900, 'Gilead Sciences, Inc.', 'gilead.com', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(3793, 133901, 'SURETEK PTY LTD', 'suretek.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3794, 133902, 'Electronic Arts', 'ea.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(3795, 133904, 'Swarovski Greater China Limited', 'swarovski.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3796, 133907, 'Mr. Danai Chudtong', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(3797, 133909, 'Siam E Business Limited Partnership', 'siamebu.com', 'TH', 2048, 'business', '0000-00-00 00:00:00', 0),
(3798, 13391, 'United Network for Organ Sharing', 'unos.org', 'US', 512, 'business', '1999-05-26 00:00:00', 0),
(3799, 133912, 'MediaCorp Pte Ltd', 'mediacorp.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3800, 133914, 'Coloured Lines Australia Pty Ltd', 'colouredlines.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3801, 133915, 'Organization: Powerco NZ Limited', 'powerco.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3802, 133918, 'Suria Data Centre Sdn. Bhd.', 'suriadatacentre.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(3803, 133919, 'University campus network, Rajamangala University of Technology Phra Nakhon', 'rit.ac.th', 'TH', 4096, 'education', '0000-00-00 00:00:00', 0),
(3804, 13392, 'Region 18 Education Service Center', 'edlink18.net', 'US', 8192, 'education', '2006-10-24 00:00:00', 0),
(3805, 133920, 'TSB Bank Limited', 'tsbbank.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(3806, 133923, 'Kantipur Publication Pvt. Ltd.', 'None', 'NP', 768, 'hosting', '0000-00-00 00:00:00', 0),
(3807, 133924, 'Covestro AG', 'covestro.de', 'DE', 2048, 'business', '0000-00-00 00:00:00', 0),
(3808, 133928, 'Unitec Institute of Technology', 'unitec.ac.nz', 'NZ', 3072, 'education', '0000-00-00 00:00:00', 0),
(3809, 133929, 'TWOWIN CO., LIMITED', 'fnetlink.com', 'HK', 5888, 'isp', '0000-00-00 00:00:00', 0),
(3810, 13393, 'KC Scout - Kansas City ITS Deployment', 'mo.gov', 'US', 256, 'business', '2005-07-01 00:00:00', 0),
(3811, 133930, 'Tesserent Pty Ltd', 'tesserent.com', 'AU', 3328, 'business', '0000-00-00 00:00:00', 0),
(3812, 133932, 'Chapal (Pvt.) Limited', 'chapal.com', 'PK', 2048, 'business', '0000-00-00 00:00:00', 0),
(3813, 133933, 'NetSat Private Limited', 'netsat.net.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3814, 133934, 'AUS IT SERVICES PTY LTD', 'aus-it.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3815, 133935, 'USGBORAL', 'usgboral.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3816, 133936, 'X86 Network Sdn Bhd', 'x86.com.my', 'MY', 2560, 'business', '0000-00-00 00:00:00', 0),
(3817, 133938, 'XeonBD', 'xeonbd.com', 'BD', 1280, 'business', '0000-00-00 00:00:00', 0),
(3818, 133940, 'CERTEGY EZI-PAY PTY LTD', 'certegy.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3819, 133942, 'Tableau Software', 'tableau.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3820, 133943, 'Integrated Solutions Group Queensland Pty Ltd', 'isgq.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3821, 133945, 'Md. Ahasan Kabir Choudhury t/a Gaibandha Online', 'bijoy.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(3822, 133947, 'Metropolitan Electricity Authority', 'mea.or.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3823, 133948, 'DONGFONG INC LIMITED', 'None', 'HK', 6400, 'hosting', '0000-00-00 00:00:00', 0),
(3824, 133950, 'Hoopla Hosting Limited', 'hooplahosting.co.nz', 'NZ', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3825, 133951, 'Omega Healthcare Management Services Private Limited', 'omegahms.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3826, 133952, 'Zhengzhou longling technology ltd.', 'lonlife.net', 'CN', 2816, 'business', '0000-00-00 00:00:00', 0),
(3827, 133953, 'Mega Target Communication Limited', 'megatarget.net', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3828, 133954, 'Exord Online', 'exordonline.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3829, 133955, 'World-Link International', 'w-l.com.hk', 'HK', 6656, 'business', '0000-00-00 00:00:00', 0),
(3830, 133956, 'Toptrader Co.,Ltd', 'trueinternet.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(3831, 133957, 'SOL-BD', 'sol-bd.com', 'BD', 1792, 'business', '0000-00-00 00:00:00', 0),
(3832, 133958, 'Special Ops Group Pty Ltd', 'opsaustralia.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3833, 133959, 'OWENTIS', 'owentis.com', 'SG', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3834, 13396, 'LANSING BOARD OF WATER AND LIGHT', 'lbwl.com', 'US', 512, 'business', '2007-11-12 00:00:00', 0),
(3835, 133961, 'MALDA NET', 'maldanet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3836, 133964, 'iBerry Wireless Pvt Ltd', 'iberrywireless.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3837, 133965, 'Nexgtech Net Solutions Pvt Ltd', 'nexgtechsolution.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3838, 133966, 'Cnergee Cloud Technology Solutions LLP', 'cnergee.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3839, 133968, 'Logon Broadband', 'logonnetworks.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3840, 133969, 'Arista Networks India Pvt Ltd', 'arista.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3841, 133970, 'Tycoon Computers Pvt. Ltd.', 'tycooncomputers.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3842, 133971, 'Rmax Broadband Pvt ltd', 'rmax.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3843, 133973, 'Net Connect Wifi Pvt. Ltd.', 'netconnectwifi.com', 'IN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(3844, 133974, 'Pinnacle Tele Services Pvt. Ltd.', 'pinnacleteleservices.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3845, 133975, 'Chemplast Sanmar Limited', 'sanmargroup.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3846, 133976, 'Japra Tele Link Private Limited', 'japratelelink.com', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(3847, 133977, 'CYBER CLOUD SHIELD BROADBAND SERVICES PRIVATE LIMITED', 'ccsbroadband.com', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3848, 133980, 'BPS COMMUNICATION AND SERVICES PRIVATE LIMITED', 'None', 'IN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(3849, 133981, 'SAI AKSHAY INTERNET SERVICES PRIVATE LIMITED', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3850, 133982, 'Excitel Broadband Private Limited', 'excitel.com', 'IN', 31488, 'isp', '0000-00-00 00:00:00', 0),
(3851, 133983, 'Shivraj Broadband Internet Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3852, 133984, 'National Commodity and Derivatives Exchange Limited', 'ncdex.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3853, 133985, 'Tractor and farm equipmemts Ltd', 'tafe.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3854, 133986, 'Nageshwar Wireless Technology Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3855, 133987, 'Pracharnama Media Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3856, 133988, 'Triple Link Pvt. Ltd.', 'triplelink.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3857, 133989, 'SBR Telecom Pvt. Ltd', 'sbrtelecom.com', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3858, 133990, 'Sarla Holdings Pvt.Ltd', 'pathways.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3859, 133992, 'Chhattisgarh Infotech and Biotech Promotion Society', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3860, 133994, 'NET ONAIR NETWORKS PVT LTD', 'noanpl.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3861, 133995, 'HDFC Securities Limited', 'hdfcsec.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3862, 133997, 'E and U Technology Services LLP', 'irinn.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3863, 133999, 'Somany Ceramics Limited', 'somanytiles.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3864, 134000, 'Gbps Networks Pvt. Ltd.', 'gbps.net.in', 'IN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(3865, 134001, 'Sanghvi Infotech Pvt Ltd', 'sanghviinfo.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3866, 134003, 'Centre For Cellular And Molecular Platforms', 'ccamp.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3867, 134004, 'Foxtel Telecommunications Pvt. Ltd.', 'foxtel.in', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3868, 134006, 'Sheng Li Telecom India Private Limited', 'shenglitelecom.in', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(3869, 134008, 'T10 Networks', 't10network.com', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(3870, 134009, 'NETCOM ENTERPRISES PVT LTD', 'netcombroadband.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(3871, 134012, 'Laxmi Internet Services Pvt Ltd', 'laxminetwork.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3872, 134014, 'NET 4 U SERVICES PVT LTD', 'net4uservices.in', 'IN', 4864, 'isp', '0000-00-00 00:00:00', 0),
(3873, 134015, 'Datanet Hosting Solutions Pvt. Ltd.', 'datanethosting.com', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3874, 134016, 'Velocity Internet India Private Ltd', 'velocityinternetservices.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3875, 134018, 'Data Wave It Solutions Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3876, 134019, 'AIRWAVES INTERNET PRIVATE LIMITED', 'airwavesinternet.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3877, 134020, 'SKYNET BROADBAND PVT LTD', 'skynetbroadband.com.au', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3878, 134021, 'Airgenie Communications Private Limited', 'airgenie.in', 'IN', 6656, 'isp', '0000-00-00 00:00:00', 0),
(3879, 134022, 'Genstar Network Solutions Pvt Ltd.', 'genstarnetworksolutions.com', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(3880, 134023, 'Aligarh Muslim University', 'amu.ac.in', 'IN', 1024, 'education', '0000-00-00 00:00:00', 0),
(3881, 134024, 'New Delhi Television Ltd', 'ndtv.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3882, 134025, 'Data Cloud Technologies', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(3883, 134026, 'Ultranet services private limited', 'ultranet.co.in', 'IN', 9472, 'isp', '0000-00-00 00:00:00', 0),
(3884, 134027, 'SAMSUNG DATA SYSTEMS INDIA PRIVATE LIMITED', 'samsung.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3885, 134028, 'Sunray infonet pvt ltd', 'None', 'IN', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(3886, 134029, 'Unique Identification Authority of India', 'uidai.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3887, 13403, 'ALAWEB Internet Services', 'covington.coop', 'US', 256, 'business', '1999-06-01 00:00:00', 0),
(3888, 134030, 'SKVISION MULTITRADE PRIVATE LIMITED', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3889, 134032, 'INFONET COMM ENTERPRISES', 'infonetcomm.com', 'IN', 5632, 'isp', '0000-00-00 00:00:00', 0),
(3890, 134033, 'HIREACH BROADBAND PRIVATE LTD', 'hireachbroadband.com', 'IN', 7680, 'isp', '0000-00-00 00:00:00', 0),
(3891, 134036, 'KPMG Global Services Private Limited', 'kpmg.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(3892, 13404, 'GoFIBER', 'gofiber.com', 'US', 768, 'business', '2014-05-19 00:00:00', 0),
(3893, 134040, 'Vayutel Technology Services Private Limited', 'vayutel.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3894, 134041, 'Ncore Creative Technologies Pvt.Ltd.', 'ncorecreative.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(3895, 134042, 'MAHA Mediacom LLP', 'mmcinternet.in', 'IN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(3896, 134043, 'SG IT Infotech Pvt. Ltd.', 'vayunet.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3897, 134047, 'Live Line Network Technology Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(3898, 134049, 'IVORY COMMUNICATIONS PVT. LTD.', 'icplsnp.in', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(3899, 13405, 'oc-net inc', 'oc-net.com', 'US', 512, 'business', '1999-06-02 00:00:00', 0),
(3900, 134050, 'KGLN Technologies Pvt Ltd', 'kgln.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3901, 134052, 'LANCEFIBERNET PVT LTD', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3902, 134053, 'ETHERNET XPRESS PVT. LTD.', 'ethernetxpress.com', 'IN', 6656, 'isp', '0000-00-00 00:00:00', 0),
(3903, 134054, 'raagav communications pvt ltd', 'raagavcom.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3904, 134055, 'Intermedia Cable Communication Pvt Ltd', 'iccnetwork.net', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3905, 134057, 'Hungama.com Pvt. Ltd.', 'hungama.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3906, 134058, 'BROBAN INTERNET SERVICES PVT LTD.', 'broban.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3907, 134059, 'Softearth Network Pvt Ltd', 'softearthnetwork.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3908, 13406, 'State College of Florida, Manatee-Sarasota', 'scf.edu', 'US', 256, 'education', '2009-02-12 00:00:00', 0),
(3909, 134060, 'Netscout Systems Software India Private Limited', 'netscout.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3910, 134061, 'MILAN INDUSTRIES PTY. LTD.', 'm-i.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3911, 134063, 'ACTIVENET PTY LTD', 'activenet.sk', 'AU', 1536, 'isp', '0000-00-00 00:00:00', 0),
(3912, 134064, 'The Chulabhorn Graduate Institute Campus Network Member of UniNet', 'inet.co.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(3913, 134065, 'Ensyst Pty Ltd', 'ensyst.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(3914, 134066, 'Lynuxtel Malaysia Sdn Bhd', 'lynuxtel.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(3915, 134067, 'Uniti Wireless Pty Ltd', 'unitiwireless.com', 'AU', 11776, 'isp', '0000-00-00 00:00:00', 0),
(3916, 134069, 'NTT MSC SDN. BHD.', 'ntt.com', 'MY', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3917, 134070, 'Legal Aid Commission of NSW', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3918, 134072, 'APJ IT Systems', 'None', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(3919, 134073, 'The Revenue Department', 'rd.go.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(3920, 134074, 'Golomt Bank', 'golomtbank.com', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(3921, 134075, 'PROBAX PTY LTD', 'probax.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3922, 134076, 'M2000CN', '2000cn.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3923, 134077, 'Magik Pivot Company Limited', 'magikpivot.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(3924, 134078, 'NETPLUZ HOLDINGS PRIVATE LIMITED', 'netpluz.asia', 'SG', 55040, 'isp', '0000-00-00 00:00:00', 0),
(3925, 134079, 'SECUREAX THAILAND', 'secureax.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(3926, 134081, 'RICEGROWERS LIMITED', 'sunrice.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3927, 134082, 'World Hub Communications (M) Sdn. Bhd.', 'worldhubcom.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(3928, 134084, 'Bani Networks LTD < Internet Service Provider >', 'baninetworks.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3929, 134086, 'Electronic Transactions Development Agency', 'thaicert.or.th', 'TH', 1280, 'business', '0000-00-00 00:00:00', 0),
(3930, 134087, 'Mundipharma IT Services GmbH', 'mundipharmaitservices.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3931, 134088, 'NGN Connection Sdn. Bhd.', 'n2nconnect.com', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(3932, 13409, 'PORTLAND INTERNETWORKS', 'pdx.net', 'US', 8192, 'business', '1999-06-02 00:00:00', 0),
(3933, 134090, 'X INTEGRATION PTY LTD', 'xi.com.au', 'AU', 7424, 'isp', '0000-00-00 00:00:00', 0),
(3934, 134093, 'BUILDINGCONNECT', 'buildingconnect.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3935, 134094, 'Serverfield Co., Ltd.', 'serverfield.com.tw', 'TW', 11264, 'hosting', '0000-00-00 00:00:00', 0),
(3936, 134095, 'National ITMX Company Limited', 'itmx.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3937, 134096, 'eHealth NSW', 'nsw.gov.au', 'AU', 9984, 'business', '0000-00-00 00:00:00', 0),
(3938, 134098, 'Licson Internet Service', 'licson.net', 'HK', 1792, 'business', '0000-00-00 00:00:00', 0),
(3939, 134099, 'CASS - NZ Central Government', 'cass.govt.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(3940, 1341, 'Rockwell Collins, Inc.', 'rockwellcollins.com', 'US', 136448, 'business', '1991-08-23 00:00:00', 0),
(3941, 13410, 'Microstrategy, Inc.', 'microstrategy.com', 'US', 1280, 'business', '1999-06-02 00:00:00', 0),
(3942, 134100, 'Express Data Co.,Ltd', 'expressdata.co.th', 'TH', 1280, 'business', '0000-00-00 00:00:00', 0),
(3943, 134101, 'Mediahub Australia Pty Ltd.', 'mediahubaustralia.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3944, 134102, 'Unlimited Internet Limited', 'unlimitedinternet.co.nz', 'NZ', 3072, 'isp', '0000-00-00 00:00:00', 0),
(3945, 134105, 'Shwe Than Lwin Media Co.,Ltd.', 'None', 'MM', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3946, 134106, 'Enjoy Network', 'enjoy.net.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(3947, 134107, 'University Malaysia Pahang', 'ump.edu.my', 'MY', 1024, 'education', '0000-00-00 00:00:00', 0),
(3948, 134109, 'IMS Health India Pvt Ltd', 'imshealth.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(3949, 134110, 'MiIT Limited', 'miit.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3950, 134111, 'Commonwealth Scientific and Industrial Research Organisation', 'csiro.au', 'AU', 70912, 'isp', '0000-00-00 00:00:00', 0),
(3951, 134112, 'Aria Sat LTD', 'ariasat.af', 'AF', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3952, 134113, 'Kazi Sazzad Hossain T/A Millennium Computers & Networking', 'None', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3953, 134115, 'THE TRUSTEES OF THE JESUIT FATHERS - ST IGNATIUS COLLEGE RIVERVIEW', 'riverview.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(3954, 134116, 'Md. Manzurul Haque Khan T/A THE NET HEADS', 'thenetheads.com', 'BD', 1792, 'isp', '0000-00-00 00:00:00', 0),
(3955, 134117, 'MING WAN ENTERPRISE', 'None', 'MY', 1792, 'business', '0000-00-00 00:00:00', 0),
(3956, 134118, 'Beca Corporate Holdings Limited', 'beca.com', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(3957, 134119, 'Cirrus Networks Pty Ltd', 'cirrusnetworks.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(3958, 13412, 'Vulcan Northwest, Inc.', 'vulcan.com', 'US', 1536, 'business', '1999-06-02 00:00:00', 0),
(3959, 134121, 'Rainbow network limited', 'rainbownetworkbd.com', 'HK', 30464, 'hosting', '0000-00-00 00:00:00', 0),
(3960, 134122, 'Le Passage to India Tours & Travels Pvt. Ltd.', 'lepassagetoindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(3961, 134123, 'Sanctuary Cove Communications Services Pty Ltd', 'scove.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3962, 134127, 'Mary Kay Asia Services Limited', 'mkcorp.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(3963, 134128, 'Mega Speed Net', 'megaspeednet.com', 'BD', 4096, 'isp', '0000-00-00 00:00:00', 0),
(3964, 134129, 'Littelfuse Phils., Inc', 'littelfuse.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(3965, 134131, 'Whakatane District Council', 'whakatane.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(3966, 134133, 'ClickView Pty. Limited', 'clickview.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3967, 134134, 'North Telecom', 'northtelecom.af', 'AF', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3968, 134137, 'True Internet Data Center Company Limited', 'trueidc.co.th', 'MM', 512, 'isp', '0000-00-00 00:00:00', 0),
(3969, 134139, 'Harbour ISP Pty LTD', 'harbourisp.com.au', 'AU', 4352, 'isp', '0000-00-00 00:00:00', 0),
(3970, 13414, 'Twitter Inc.', 'twitter.com', 'US', 41216, 'business', '2010-07-09 00:00:00', 0),
(3971, 134141, 'B2B Wholesale Pty Ltd', 'b2bwholesale.com.au', 'AU', 7680, 'isp', '0000-00-00 00:00:00', 0),
(3972, 134143, 'Professional Data Kinetics Pty Ltd', 'pdk.net.au', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(3973, 134145, 'TF GLOBAL MARKETS (AUST) PTY LTD', 'thinkforex.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3974, 134146, 'SAM ONLINE', 'sambd.com', 'BD', 2560, 'isp', '0000-00-00 00:00:00', 0),
(3975, 134147, 'TEAMWORK TECHNOLOGY PTY LTD', 'teammworktechnology.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3976, 134149, 'RED PIRANHA LIMITED', 'redpiranha.net', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(3977, 13415, 'FirstDigital Communications, LLC', 'firstdigital.com', 'US', 51200, 'isp', '1999-06-02 00:00:00', 0),
(3978, 134151, 'Steamships Ltd', 'steamships.com.pg', 'PG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3979, 134152, 'XMT Technologies Sdn Bhd', 'xmt.com.my', 'MY', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3980, 134153, 'MD Manir Hossen trading as Xplore Cyber & Net', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(3981, 134155, 'TANGIBLE TECHNOLOGY PTY LTD', 'tangible.tech', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(3982, 13416, 'R/Greenberg Associates', 'None', 'US', 512, 'hosting', '1999-06-02 00:00:00', 0),
(3983, 134160, 'Vine Networks Pty', 'vinenetworks.com.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(3984, 134161, 'Global Foundries Pte Ltd', 'globalfoundries.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(3985, 134162, 'ADVANCED WIRELESS NETWORK COMPANY LIMITED', 'ais.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(3986, 134163, 'ValuePRO Software Pty Ltd', 'valuepro.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3987, 134164, 'NSW Government Telecommunications Authority', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3988, 134166, 'Internet Data Center Service', 'totinternet.net', 'TH', 6656, 'isp', '0000-00-00 00:00:00', 0),
(3989, 134167, 'CBRE Pty Limited', 'cbre.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(3990, 134171, 'Lazada South East Asia Pte. Ltd.', 'lazada.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(3991, 134173, 'Nagarro Software Private Limited', 'nagarro.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(3992, 134175, 'SH2206-AP', 'None', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(3993, 134176, 'Rainbow network limited', 'rainbownetworkbd.com', 'HK', 8960, 'hosting', '0000-00-00 00:00:00', 0),
(3994, 134177, 'Rural Broadband Pvt. Ltd', 'airjaldi.net', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(3995, 134178, 'United Group Limited', 'ugllimited.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(3996, 134179, 'Real World Networks Pty Ltd', 'realworldnetworks.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(3997, 134180, 'Md. Shariful Islam T/A BRISK SYSTEMS', 'brisksys.com', 'BD', 9472, 'isp', '0000-00-00 00:00:00', 0),
(3998, 134181, 'Tas Communications Pty Ltd', 'tascom.net.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(3999, 134182, 'DHFL General Insurance limited', 'cocogeneralinsurance.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4000, 134183, 'Progress I.T. Pty Ltd', 'progressit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4001, 134186, 'Paradise Technologies Limited', 'paradisetec.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4002, 134188, 'NTT DATA Victorian Ticketing System Pty Ltd', 'nttdata.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4003, 134189, 'Alpha Dot Net Australia Pty Ltd', 'alpha.net.au', 'AU', 8192, 'isp', '0000-00-00 00:00:00', 0),
(4004, 134190, 'IPDC SOLUTIONS PTE LTD', 'ipdc.asia', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4005, 134196, 'ULan Network Limited', 'None', 'HK', 7680, 'hosting', '0000-00-00 00:00:00', 0),
(4006, 1342, 'Fujitsu Invia Finland IP-network', 'None', 'EU', 95232, 'hosting', '2002-09-23 07:53:17', 0),
(4007, 134201, 'Metaphor Digital Media', 'metaphornet.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4008, 134202, 'E-WORLD COMMUNICATION SDN BHD', 'eworld.com.my', 'MY', 2304, 'business', '0000-00-00 00:00:00', 0),
(4009, 134203, 'Nebulex Pty Ltd', 'nebulex.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4010, 134204, 'Business Network', 'businessnetworkinc.com', 'BD', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4011, 134214, 'AVALOQ SOURCING ASIA PACIFIC (SINGAPORE) PTE. LTD.', 'avaloq.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4012, 134217, 'Australian Support Pty Ltd', 'asit.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4013, 134218, 'Gaming Investments Pty Ltd', 'gaminginvestments.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4014, 134220, 'UFONE', 'ufone.co.nz', 'NZ', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4015, 134224, 'CLOUD SCALE LIMITED', 'cloudscale.co.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(4016, 134225, 'Hyundai Motor India Engineering Pvt Ltd', 'hyundai.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4017, 134226, 'NATION COMMUNICATION', 'nationbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4018, 134227, 'WAND FAUCET-controlled multi-vendor production OpenFlow network', 'wand.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4019, 134229, 'Noble Systems Australia Pty Limited', 'noblesys.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4020, 13423, 'GALVESTON ISD', 'gisd.org', 'US', 256, 'business', '2013-05-20 00:00:00', 0),
(4021, 134232, 'SACOFA Sdn. Bhd.', 'sacofa.com.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(4022, 134235, 'Subex Azure Limited', 'subex.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4023, 134236, 'Sheikh Mohammad Zulfiquer t/a Tetrasoft', 'tetrasoftbd.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4024, 134237, 'Ericsson Expertise Center', 'ericsson.com', 'MY', 768, 'business', '0000-00-00 00:00:00', 0),
(4025, 134238, 'CHINANET Jiangx province IDC network', 'gsta.com', 'CN', 84480, 'isp', '0000-00-00 00:00:00', 0),
(4026, 134239, 'SPARVA INCORPORATED', 'None', 'PH', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4027, 13424, 'Intercity', 'intercity.cl', 'CL', 2816, 'isp', '1999-06-02 00:00:00', 0),
(4028, 134240, 'Super Broadband Network Company Limited', 'ais.co.th', 'TH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4029, 134242, 'UTBox Pty Ltd', 'utbox.net', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4030, 134244, 'Orca Communications Ltd', 'orcacom.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(4031, 134245, 'Nano Systems Pty Limited', 'nano.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4032, 134246, 'WELCO INFOTECH PVT LIMITED', 'welcoinfotech.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4033, 134249, 'Margo Networks Pvt Ltd', 'margonetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4034, 134251, 'EMPLOYEES PROVIDENT FUND ORGANISATION', 'epfindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4035, 134252, 'Tellusys Info Pvt Ltd', 'tellusys.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4036, 134254, 'Shah Infinite Solutions Pvt. Ltd.', 'infinitesolutions.in', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4037, 134256, 'Net4U TechnologyPVT. LTD.', 'net4u.net.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4038, 134257, 'Hostaxis Network Private Limited', 'hostaxis.in', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4039, 134258, 'Bhwani Cable and Broadband Services', 'bhawanicable.com', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4040, 134259, 'Skyne', 'skynetdwarka.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4041, 13426, 'Juno Online Services, Inc.', 'juno.com', 'US', 768, 'business', '1999-06-03 00:00:00', 0),
(4042, 134260, 'ZERONE Networks pvt ltd', 'zeronenetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4043, 134261, 'Bigtree Entertainment Pvt. Ltd.', 'bigtree.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4044, 134262, 'GULBARGA MEGA SPEED PRIVATE LIMITED', 'megaspeed.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4045, 134264, 'DIGI STAR INFO SOLUTIONS PRIVATE LIMITED', 'None', 'IN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4046, 134265, 'Parim Infocomm Private Limited', 'parim.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4047, 134266, 'Sky Commodities India Pvt Ltd', 'skycommodities.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4048, 134267, 'Matrix Tech Labs', 'matrixtechlabs.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4049, 134269, 'Net Solutions', 'netsolutionsinc.com', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4050, 13427, 'Softcom Internet Communications, Inc.', 'softcom.net', 'US', 6144, 'isp', '1999-06-03 00:00:00', 0),
(4051, 134270, 'Planet Wi Fi Private Limited', 'planetwifi.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4052, 134271, 'JKM Infotech', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4053, 134273, 'D M Broadband', 'deskmedia.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4054, 134277, 'Mahindra And Mahindra Limited', 'mahindra.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4055, 134278, 'DNS Infonet Pvt Ltd', 'dnsinfonet.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4056, 134279, 'Spectra Innovations', 'spectraindia.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4057, 13428, 'Surf Air Wireless, LLC', 'surfairwireless.com', 'US', 18176, 'isp', '1999-06-03 00:00:00', 0),
(4058, 134280, 'Alwar Online Pvt. Ltd.', 'alwaronline.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4059, 134281, 'SugarBox Networks Pvt Ltd', 'sugarboxnetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4060, 134283, 'Kepler Internet Pvt Ltd', 'keplerinternetpvtltd.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4061, 134284, 'KPMG Global Delivery Center Private Limited', 'kpmg.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4062, 134285, 'Andhra Bank', 'andhrabank.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4063, 134286, 'NET FOR CHOICE', 'netforchoice.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(4064, 134287, 'HBS TELESOFT PRIVATE LIMITED', 'myhtpl.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4065, 13429, 'Medical University of South Carolina', 'musc.edu', 'US', 65536, 'education', '1999-06-03 00:00:00', 0),
(4066, 134290, 'Arrow Touch Wireless Internet Private Limited', 'None', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(4067, 134293, 'Kutch Telelink Private Limited', 'kutchtelelink.com', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(4068, 134294, 'R P World Telecom Pvt Ltd', 'None', 'IN', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(4069, 134295, 'MAKS COMMUNICATIONS PVT. LTD.', 'makscommunications.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4070, 134297, 'Mediant Broadband Pvt. Ltd.', 'mediantbroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4071, 134298, 'Conquersoft Communication Pvt. Ltd.', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4072, 1343, 'Cisco Systems Cloud Division', 'cisco.com', 'US', 512, 'isp', '1991-09-03 00:00:00', 0),
(4073, 134301, 'GOMTESH INFOTECH PRIVATE LIMITED', 'bsnl.co.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4074, 134302, 'Oxynet Telecommunications Private Limited', 'oxynet.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4075, 134303, 'Esconet Technologies Pvt. Ltd.', 'esc.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4076, 134304, 'S.v.c Cable Net Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4077, 134305, 'Sampath Venkateswara Communications Pvt Ltd.', 'svcpl.net.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4078, 134306, 'Mothersonsumi INfotech and Designs Ltd.', 'mind-infotech.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4079, 134307, 'Classicnet Broadband Network', 'classicnet.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4080, 134308, 'Clickian Network Pvt. Ltd.', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4081, 13431, 'Millennium Partners, L.P.', 'mlp.com', 'US', 2816, 'business', '1999-06-04 00:00:00', 0),
(4082, 134310, 'FUNDTECH INDIA PVT. LTD.', 'fundtech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4083, 134311, 'Trinn Techologies Pvt. Ltd.', 'trinn.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4084, 134312, 'Digi Win Infotainment Mumbai Pvt Ltd', 'digiwin.in', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(4085, 134315, 'Nextwise Internet And Broadcasting Pvt. Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4086, 134316, 'World Star Communication', 'None', 'IN', 13568, 'isp', '0000-00-00 00:00:00', 0),
(4087, 134319, 'Elyzium Technologies Pvt. Ltd.', 'elyzium.co.in', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(4088, 134320, 'Heritage Computers Pvt. Ltd.', 'heritagecpl.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4089, 134322, 'Tata Institute of Fundamental Research', 'tifr.res.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4090, 134324, 'GOLDY DIGINET PRIVATE LIMITED', 'gdpl.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4091, 134325, 'JETSPOTNETWORKS PVT LTD', 'jetspotnetworks.in', 'IN', 4864, 'isp', '0000-00-00 00:00:00', 0),
(4092, 134326, 'Airdesign Broadcast Media Pvt Ltd', 'airdesign.in', 'IN', 8448, 'isp', '0000-00-00 00:00:00', 0),
(4093, 134327, 'Futuristic IDC Pvt Ltd', 'futuristicidc.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4094, 134329, 'Shree rajrajeshwar communication pvt. ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4095, 13433, 'Cox Enterprises Inc', 'coxenterprises.com', 'US', 71680, 'business', '1999-06-04 00:00:00', 0),
(4096, 134330, 'AVNI INFOTECH', 'avnihost.com', 'IN', 3072, 'hosting', '0000-00-00 00:00:00', 0),
(4097, 134331, 'Smartlink Solutions Pvt. Ltd.', 'smartlinkindia.com', 'IN', 6912, 'isp', '0000-00-00 00:00:00', 0),
(4098, 134332, 'ACL MOBILE LIMITED', 'acl-mobile.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4099, 134333, 'SS BROADBAND SERVICES PVT LTD', 'None', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(4100, 134334, 'LOTUS BROADBAND PVT LTD', 'lotusbroadband.in', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(4101, 134337, 'R2 Net Solutions Pvt Ltd', 'r2net.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4102, 134338, 'Ntt Communications India Network Services Private Limited', 'nttcomindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4103, 13434, 'CORVEL CORPORATION', 'corvel.com', 'US', 1792, 'business', '1999-06-08 00:00:00', 0),
(4104, 134340, 'cloudsky superfast broadband and services Pvt Ltd', 'cloudskybroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4105, 134341, 'jdm broadband services pvt ltd', 'jdmbroadband.com', 'IN', 8448, 'isp', '0000-00-00 00:00:00', 0),
(4106, 134343, 'Om Sai Entertainment', 'None', 'IN', 3072, 'hosting', '0000-00-00 00:00:00', 0),
(4107, 134344, 'Fortune Marketing Pvt Ltd', 'fortune-it.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4108, 134346, 'Gainlot International Co. Ltd', 'gainlotintl.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4109, 134347, 'Base64 Pty Ltd', 'base64.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4110, 134349, 'Panduit Singapore Pte Ltd', 'panduit.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4111, 134352, 'ARIDE OCEAN INFOWAY PRIVATE LIMITED', 'aride.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4112, 134353, 'Netcocloud - The Quality Based Datacenter', 'netcocloud.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4113, 134355, 'V Logic Pty Ltd', 'vlogic.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4114, 134356, 'NBC Co.,Ltd', 'mnbctv.mn', 'MN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4115, 134357, 'Inspired Techs Pty Ltd', 'inspiredtechs.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4116, 134359, 'Wanna Internet Limited', 'wanna.net.nz', 'NZ', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4117, 134363, 'EZIT Solutions Pte Ltd', 'ezit.asia', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4118, 134366, 'Cloud Computing HK Limited', 'qingcloud.com', 'HK', 5632, 'hosting', '0000-00-00 00:00:00', 0),
(4119, 134367, 'GIBSON, ADAM GORDON T/A GIBZTECH', 'gibztech.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4120, 134369, 'Atos (Australia) Pty Ltd', 'atos.net', 'AU', 68608, 'business', '0000-00-00 00:00:00', 0),
(4121, 134371, 'CIRCLE NETWORK BANGLADESH', 'circlenetworkbd.net', 'BD', 4608, 'isp', '0000-00-00 00:00:00', 0),
(4122, 134372, 'L. EDWARDS & SON LIMITED t/a VisionLab', 'visionlab.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4123, 134375, 'Fusionnet Web Services Private Limited', 'fusionnet.in', 'IN', 9216, 'isp', '0000-00-00 00:00:00', 0),
(4124, 134376, 'Samoa IXP', 'csl.ws', 'WS', 256, 'isp', '0000-00-00 00:00:00', 0),
(4125, 134378, 'Alchemy Networks Limited', 'alchemynetworks.co.nz', 'NZ', 768, 'isp', '0000-00-00 00:00:00', 0),
(4126, 134379, 'TGGO COMPANY LIMITED', 'tggo.com.hk', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4127, 13438, 'Vivio Technologies', 'viviotech.net', 'US', 17152, 'hosting', '2005-07-01 00:00:00', 0),
(4128, 134381, 'MICHEL J. LHUILLIER FINANCIAL SERVICES (PAWNSHOPS), INC.', 'mlhuillier1.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(4129, 134382, 'Radisson Technologies', 'radisson-bd.net', 'BD', 4352, 'isp', '0000-00-00 00:00:00', 0),
(4130, 134383, 'Pabna University of Science and Technology', 'None', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(4131, 13439, 'SCI REMC', 'sciremc.com', 'US', 256, 'business', '2020-02-05 00:00:00', 0),
(4132, 134392, 'AusRegistry Anycast system', 'ausregistry.com.au', 'TR', 512, 'business', '0000-00-00 00:00:00', 0),
(4133, 13440, 'Operbes, S.A. de C.V.', 'izzi.mx', 'MX', 768, 'isp', '1999-06-08 00:00:00', 0),
(4134, 134403, 'Quantum Foundation', 'quantummethod.org.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4135, 134404, 'IBD Communication.', 'cityoninebd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4136, 134405, 'Data Services Pacific', 'dsp.nc', 'NC', 512, 'business', '0000-00-00 00:00:00', 0),
(4137, 134406, 'AUSTRALIANSUPER PTY LTD', 'australiansuper.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4138, 134407, 'MediaCorp Pte Ltd', 'mediacorp.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4139, 134408, 'Hillside (Australia New Media) Pty Ltd', 'hillsidenewmedia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4140, 134409, 'PublicDNS-Global AnyCast Network', 'publicdns.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4141, 13441, 'Bank of Nova Scotia', 'scotiabank.com', 'CA', 512, 'business', '1999-06-08 00:00:00', 0),
(4142, 134411, 'Manhattan Associates (India) Development Centre Pvt. Ltd.', 'manh.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4143, 134414, 'De La Salle-Greenhills', 'benilde.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(4144, 134416, 'De La Salle-Zobel', 'benilde.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(4145, 134417, 'Nanjing', 'chinatelecom.cn', 'CN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4146, 134418, 'SHAANXI province', 'gsta.com', 'CN', 35328, 'isp', '0000-00-00 00:00:00', 0),
(4147, 134419, 'Beihai', 'gsta.com', 'CN', 112640, 'isp', '0000-00-00 00:00:00', 0),
(4148, 134420, 'Chongqing Telecom', 'gsta.com', 'CN', 81920, 'isp', '0000-00-00 00:00:00', 0),
(4149, 134424, 'PAVE IT SOLUTIONS PTY LTD', 'paveits.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4150, 134426, 'Mahataa Information India Private Limited', 'google.com', 'IN', 12288, 'business', '0000-00-00 00:00:00', 0),
(4151, 134427, 'Managed IT Pty Ltd', 'managedit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4152, 134429, 'Evolution Networks Limited', 'en.net.nz', 'NZ', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4153, 13443, 'LinkedIn Corporation', 'linkedin.com', 'US', 3328, 'business', '2014-01-27 00:00:00', 0),
(4154, 134430, 'Quikr India Pvt. Ltd', 'quikr.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4155, 134431, 'News and Entertainment Network Corp', 'now-corp.com', 'PH', 2560, 'isp', '0000-00-00 00:00:00', 0),
(4156, 134436, 'Origin I.T. Limited', 'originit.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4157, 134437, 'The Sky Traders (Pvt) Ltd', 'theskytraders.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4158, 134438, 'Aira & Aiful Public Company Limited', 'trueinternet.co.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4159, 13444, 'TRS', 'transsss.com', 'US', 1280, 'business', '2020-03-02 00:00:00', 0),
(4160, 134441, 'Australian Pacific Data Centres Pty Ltd', 'apdatacentres.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4161, 134449, 'Dah Sing Bank, Limited', 'dahsing.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(4162, 13445, 'Cisco Webex LLC', 'webex.com', 'US', 197120, 'business', '1999-06-09 00:00:00', 0),
(4163, 134450, 'HostRoyale Technologies Pvt Ltd', 'hostroyale.com', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4164, 134451, 'NewMedia Express Pte Ltd', 'newmediaexpress.com', 'ID', 3584, 'hosting', '0000-00-00 00:00:00', 0),
(4165, 134452, 'Jasper Infotech Pvt Ltd.', 'snapdeal.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4166, 13446, 'Netzero,INC.', 'netzero.net', 'US', 58112, 'business', '1999-06-09 00:00:00', 0),
(4167, 134463, 'Karara Mining Limited', 'kararamining.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4168, 13447, 'VIP Tour Company, Inc.', 'ticketsnow.com', 'US', 1024, 'business', '2005-07-05 00:00:00', 0),
(4169, 13448, 'Forcepoint, LLC', 'forcepoint.com', 'US', 4864, 'isp', '2005-07-05 00:00:00', 0),
(4170, 13450, 'Touchnet Information Systems', 'touchnet.com', 'US', 1024, 'business', '2006-09-11 00:00:00', 0),
(4171, 134503, 'Flash Fibres', 'flashfibres.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4172, 134504, 'Everest Link Pvt. Ltd', 'everestlink.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(4173, 134509, '1-TO-ALL COMPANY LIMITED', '1-to-all.com', 'TH', 2048, 'business', '0000-00-00 00:00:00', 0),
(4174, 13451, 'Saddle Mountain Wireless Inc.', 'smwireless.net', 'US', 7168, 'business', '2005-07-05 00:00:00', 0),
(4175, 134512, 'HostPalace Web Solution PVT LTD', 'host-palace.com', 'IN', 3584, 'hosting', '0000-00-00 00:00:00', 0),
(4176, 134513, 'GIESECKE AND DEVRIENT INDIA PRIVATE LIMITED', 'gi-de.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4177, 134515, 'NOV Rig Solutions Pte Ltd', 'nov.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4178, 134518, 'RETN (Hong Kong) Limited', 'retn.net', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4179, 13452, 'Guggenheim Services LLC', 'guggenheimpartners.com', 'US', 512, 'business', '2012-02-08 00:00:00', 0),
(4180, 134520, 'GigsGigs  Network Services', 'techavenue.hk', 'HK', 6400, 'hosting', '0000-00-00 00:00:00', 0),
(4181, 134521, 'Dialpad, Inc.', 'dialpad.com', 'US', 1280, 'business', '0000-00-00 00:00:00', 0),
(4182, 134522, 'HostingInside LTD.', 'hostinginside.com', 'TW', 2304, 'hosting', '0000-00-00 00:00:00', 0),
(4183, 134523, 'NETWOO TELECOM (HK) LIMITED', 'netwoo.com.cn', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4184, 134524, 'LinkNet Communication International Limited', 'linknet.hk', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4185, 134525, 'Solomon Telekom Co Ltd', 'telekom.com.sb', 'SB', 768, 'isp', '0000-00-00 00:00:00', 0),
(4186, 134526, 'EVERY DAY TECHNOLOGY CO LIMITED', 'as134526.net', 'HK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4187, 134529, '1Asia Alliance Gateway Limited', 'None', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4188, 13453, 'DIVERSIFIED SYSTEMS RESOURCES, LTD', 'dsrglobal.com', 'US', 1536, 'business', '2019-01-16 00:00:00', 0),
(4189, 134530, 'ATT NBE Equinix Sydney', 'att.com', 'AU', 256, 'isp', '0000-00-00 00:00:00', 0),
(4190, 134531, 'ATT NBE Equinix Melbourne', 'att.com', 'AU', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4191, 134533, 'ATT NBE Equinix Hong Kong', 'att.com', 'HK', 256, 'isp', '0000-00-00 00:00:00', 0),
(4192, 134534, 'ATT NBE Equinix Singapore', 'att.com', 'SG', 256, 'isp', '0000-00-00 00:00:00', 0),
(4193, 134535, 'ATT NBE Equinix Amsterdam', 'att.com', 'NL', 512, 'isp', '0000-00-00 00:00:00', 0),
(4194, 13454, 'PENNSYLVANIA TURNPIKE COMMISSION', 'paturnpike.com', 'US', 512, 'business', '2007-05-08 00:00:00', 0),
(4195, 134540, 'Tata Teleservices (Maharashtra) Ltd', 'tatateleservices.com', 'IN', 55040, 'isp', '0000-00-00 00:00:00', 0),
(4196, 134542, 'China Unicom IP network', 'chinaunicom.cn', 'CN', 107008, 'isp', '0000-00-00 00:00:00', 0),
(4197, 134543, 'China Unicom Guangdong IP network', 'chinaunicom.cn', 'CN', 34304, 'isp', '0000-00-00 00:00:00', 0),
(4198, 134546, 'Maybank Singapore Limited', 'maybank.com.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4199, 134548, 'DXTL Tseung Kwan O Service', 'None', 'HK', 2372096, 'hosting', '0000-00-00 00:00:00', 0),
(4200, 134552, 'Geotel Bangladesh IT Ltd.', 'geotelit.net', 'BD', 4352, 'isp', '0000-00-00 00:00:00', 0),
(4201, 134553, 'i-Skill Dynamics Sdn Bhd', 'i-skill.com', 'MY', 1792, 'business', '0000-00-00 00:00:00', 0),
(4202, 134554, 'Starnet Communications Sdn Bhd', 'starnet.com.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(4203, 134555, 'Encoo Pty Ltd', 'encoo.com.au', 'AU', 3328, 'isp', '0000-00-00 00:00:00', 0),
(4204, 134556, 'BLACKNGREEN MOBILE SOLUTIONS Pvt Ltd.', 'blackngreen.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4205, 13456, 'City of Spokane', 'spokanecity.org', 'US', 4608, 'business', '2010-03-04 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(4206, 134562, 'DISCOVERY INTERNET', 'discoverynetbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4207, 134564, 'Wi-Fi First Limited', 'wifi-first.com', 'TH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4208, 134565, 'Philippine Communications Satellite Corp', 'philcomsat.com.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4209, 13457, 'Wolverine Power Supply', 'wpsci.com', 'US', 512, 'business', '2013-02-15 00:00:00', 0),
(4210, 134572, 'Bottola Cyber Net', 'btcnbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4211, 134573, 'Shopee Mobile Sdn Bhd', 'shopee.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(4212, 13458, 'Davidson Kempner Capital Management LLC', 'davidsonhomesllc.com', 'US', 1536, 'business', '2006-08-24 00:00:00', 0),
(4213, 134584, 'Diligent Board Services Australia Pty Ltd', 'diligent.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4214, 134585, 'Sheetal Broadband', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4215, 134589, 'BHP, 125 St. Georges Terrace, Perth, Australia', 'bhpbilliton.com', 'AU', 4608, 'business', '0000-00-00 00:00:00', 0),
(4216, 134592, 'Shopee (Thailand) Co., Ltd.', 'shopee.co.th', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(4217, 134594, 'AVNET ASIA PTE LTD', 'avnet.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4218, 134595, 'Velocity Internet', 'velocity.net.bd', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(4219, 134596, 'WICLOUD PVT LTD.', 'wicloud.pk', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4220, 134599, 'Digital Dot Net (DDN)', 'None', 'BD', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(4221, 13460, 'EarthCam, Inc.', 'earthcam.com', 'US', 768, 'business', '1999-06-14 00:00:00', 0),
(4222, 134600, 'Le Siam Internetwork Company Limited', 'lsiam.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(4223, 134601, 'Microlink Technology', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4224, 134602, 'shuiM Data Exchange Center', 'shuim.net', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(4225, 134603, 'Thoolei Co., Ltd.', 'thoolei.com', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(4226, 134605, 'Comserv PNG Ltd', 'comservpng.com', 'PG', 256, 'isp', '0000-00-00 00:00:00', 0),
(4227, 134608, '2GoTrade Limited', '2gotrade.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4228, 13461, 'The Options Clearing Corporation', 'theocc.com', 'US', 768, 'business', '2018-03-09 00:00:00', 0),
(4229, 134610, 'McKinsey & Company, Australia, Sydney POP', 'mckinsey.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4230, 134611, 'McKinsey & Company, Australia, Perth POP', 'mckinsey.com', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(4231, 134612, 'PT Atria Teknologi Indonesia', 'atriatek.co.id', 'ID', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4232, 134613, 'PT GTA Indonesia', 'kuoni.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4233, 134614, 'Universitas Hasanuddin', 'unhas.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4234, 134618, 'PT Rabik Bangun Nusantara', 'rbn.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4235, 13462, 'Institute of Electrical and Electronics Engineers', 'ieee.org', 'US', 66816, 'business', '1999-06-15 00:00:00', 0),
(4236, 134620, 'Pusinfolahta TNI', 'tnial.mil.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4237, 134621, 'PT Jurnalindo Aksara Grafika', 'biz.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4238, 134623, 'PT. DIGITAL NETWORK ANTANUSA', 'dna.net.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(4239, 134624, 'PT. FUJITSU INDONESIA', 'fujitsu.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4240, 134626, 'PT. Aristi Jasadata', 'aristi.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4241, 134627, 'Universitas Kristen Satya Wacana', 'uksw.edu', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4242, 134630, 'PT Palapa Global Nusantara', 'palapa.net.id', 'ID', 1536, 'business', '0000-00-00 00:00:00', 0),
(4243, 134631, 'PT Bhakti Wasantara Net', 'wasantara.net.id', 'ID', 8192, 'business', '0000-00-00 00:00:00', 0),
(4244, 134632, 'PT Lippo Malls Indonesia', 'lippomalls.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4245, 134633, 'Direktorat Jenderal Administrasi Hukum Umum', 'ahu.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4246, 134634, 'Sekretariat Daerah Kota Salatiga', 'salatiga.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4247, 134635, 'Dinas Perhubungan, Komunikasi dan Informatika Kabupaten Banyuwangi', 'banyuwangikab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4248, 134636, 'PT Bank DBS Indonesia', 'dbs.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4249, 134638, 'PT.Tangara Mitrakom', 'mitrakom.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4250, 134639, 'Pemerintah Provinsi Kepulauan Bangka Belitung', 'babelprov.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4251, 13464, 'Centerbridge Partners, L.P.', 'centerbridge.com', 'US', 1024, 'business', '2007-06-06 00:00:00', 0),
(4252, 134640, 'PT DCI Indonesia', 'dci-indonesia.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4253, 134641, 'PEMERINTAH KABUPATEN MAGETAN', 'magetankab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4254, 134642, 'Bank Shinhan Indonesia', 'shinhan.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4255, 134643, 'PT Jaya Kartha Solusindo', 'jks.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4256, 134644, 'PT Cakrawala Lintas Kepri', 'cakrawalanet.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4257, 134645, 'PT Midtrans', 'veritrans.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4258, 134648, 'PT Tidar Lintas Nusa', 'tidar.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4259, 134649, 'PT Jingdong Indonesia Pertama', 'jd.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4260, 13465, 'Haute-Vitesse.com', 'haute-vitesse.com', 'CA', 1280, 'business', '2020-02-07 00:00:00', 0),
(4261, 134650, 'Politeknik Negeri Batam', 'polibatam.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4262, 134651, 'PT Yetoya Solusi Indonesia', 'yetoya.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4263, 134652, 'PPM Manajemen', 'ppm-manajemen.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4264, 134653, 'Universitas Muhammadiyah Prof. DR. HAMKA', 'uhamka.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4265, 134655, 'PT. DUMAI MANDIRI NET', 'dumaimandirinet.id', 'ID', 2816, 'business', '0000-00-00 00:00:00', 0),
(4266, 134656, 'PT Cheil Jedang Indonesia', 'cj.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4267, 134658, 'PT JULIA MULTIMEDIA NUSANTARA', 'jnetwork.net.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(4268, 134659, 'Diskominfo DKI Jakarta', 'jakarta.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4269, 134660, 'Badan Pengelola Keuangan dan Aset Daerah Kota Batu', 'batukota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4270, 134661, 'SHINHAN INDO FINANCE', 'ptsif.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4271, 134663, 'NeuroTEN Pte Ltd', 'neuro10.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4272, 13467, 'Oklahoma Turnpike Authority', 'pikepass.com', 'US', 512, 'business', '2020-03-17 00:00:00', 0),
(4273, 134670, 'ACS Business Process Solutions Ltd', 'taro-scopes.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(4274, 134671, 'Xima Network', 'moack.net', 'KR', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4275, 134672, 'Aquoz Solutions Inc', 'aquozsolutions.com', 'PH', 3072, 'business', '0000-00-00 00:00:00', 0),
(4276, 134674, 'TATA SKY BROADBAND PRIVATE LIMITED', 'tataskybb.com', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(4277, 134676, 'Santonu Talukder t/a Xenial Broadband', 'xenialbb.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(4278, 134678, 'Port Stephens Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4279, 134679, 'Hillside (Australia New Media) Pty Ltd', 'hillsidenewmedia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4280, 13468, 'Kingston Online Services', 'kos.net', 'CA', 16896, 'isp', '2009-10-27 00:00:00', 0),
(4281, 134680, 'IPH Limited, Sydney', 'practiceinsight.io', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4282, 134682, 'KGI Securities (Thailand) Public Company Limited', 'kgi.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(4283, 134684, 'NetConn Services Ltd', 'netcsv.com', 'HK', 6656, 'business', '0000-00-00 00:00:00', 0),
(4284, 134686, 'Krungsri Securities Public Company Limited', 'krungsrisecurities.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(4285, 134687, 'TWIDC Limited', 'twidc.com.hk', 'HK', 9984, 'isp', '0000-00-00 00:00:00', 0),
(4286, 134688, 'YourFibre Pty Ltd', 'yourdc.com.au', 'AU', 4608, 'business', '0000-00-00 00:00:00', 0),
(4287, 134690, 'Chulachomklao Royal Military academy member of UniNet', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4288, 134691, 'Fastway Global Limited', 'fastway.org', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4289, 134692, 'IAG New Zealand', 'iag.co.nz', 'NZ', 3072, 'business', '0000-00-00 00:00:00', 0),
(4290, 134695, 'Mass Rapid Transit Authority of Thailand', 'mrta.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4291, 134697, 'Launtel', 'launtel.net.au', 'AU', 5120, 'isp', '0000-00-00 00:00:00', 0),
(4292, 134698, 'Chr. Hansen Malaysia Sdn Bhd', 'chr-hansen.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(4293, 1347, 'Inteliquent, inc.', 'inteliquent.com', 'US', 2304, 'isp', '1991-09-12 00:00:00', 0),
(4294, 13470, 'NAVAJO COUNTY - MIS', 'navajocountyaz.gov', 'US', 512, 'business', '2008-03-12 00:00:00', 0),
(4295, 134700, 'Sinoycloud Limited', 'None', 'HK', 9984, 'isp', '0000-00-00 00:00:00', 0),
(4296, 134702, 'NETSCOPE', 'netscopebd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4297, 134705, 'Itace International Limited', 'itace.cc', 'HK', 426240, 'hosting', '0000-00-00 00:00:00', 0),
(4298, 134707, 'RoyalCable Flash', 'royalcable.com.ph', 'PH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4299, 134708, 'KINGTEL COMMUNICATIONS LIMITED', 'kingtel.com.kh', 'KH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4300, 134709, 'ULTIMATE COMMUNICATION SOLUTIONS PTY. LTD.', 'ultimatecommunications.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4301, 13471, 'PFS Web', 'pfsweb.com', 'US', 1024, 'business', '2015-02-25 00:00:00', 0),
(4302, 134710, 'Three Lights Management and Consultancy Corp.', 'three-lights.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4303, 134712, 'Pipex Network', 'pipexbd.com', 'BD', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4304, 134714, 'Elite Telecom Public Company Limited', 'elitetech-group.com', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4305, 134715, 'Ministry of Information & Communications Thimphu, Bhutan', 'dit.gov.bt', 'BT', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4306, 134716, 'Savant Technologies Inc.', 'savant.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4307, 134718, 'OSD Internet Company Limited', 'osd.co.th', 'TH', 1280, 'business', '0000-00-00 00:00:00', 0),
(4308, 134721, 'KHAADI', 'khaadi.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(4309, 134722, 'Universiti Teknikal Malaysia Melaka', 'utem.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(4310, 134723, 'Evergreen Online Ltd.', 'eolbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4311, 134724, 'Hudson Global Resources (Aust) Pty Ltd', 'hudson.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4312, 134725, 'MAXSolutions Pty Ltd', 'maxsolutions.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4313, 134728, 'DENIZEN TECHNOLOGIES, INC.', 'denizentechs.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4314, 134729, 'JOINT POWER TECHNOLOGY LIMITED', 'thesolarsystems.net', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(4315, 134730, 'EDMI NZ Limited', 'edmi.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4316, 134732, 'Dot Internet', 'dotinternetbd.com', 'BD', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4317, 134733, 'CENTRALWEST NETWORKS PTY LTD', '2800.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4318, 134735, 'ADVANCED COMPUTING SOLUTIONS PTY LTD (T/A NORTH SYDNEY I.T)', 'nsit.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(4319, 134736, 'NTT Communications (Thailand) Co., Ltd. (Yangon Branch)', 'nttc.com.mm', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4320, 134737, 'Net-Cloud Telecom Private Limited', 'netcloud.pk', 'PK', 256, 'isp', '0000-00-00 00:00:00', 0),
(4321, 134739, 'AGB Communication Co.Ltd', 'agbcommunication.com', 'MM', 4608, 'isp', '0000-00-00 00:00:00', 0),
(4322, 13474, 'Banco de Galicia y Buenos Aires', 'bancogalicia.com', 'AR', 32768, 'business', '1999-06-16 00:00:00', 0),
(4323, 134740, 'Horizon & Associates', 'horizon.com.bd', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4324, 134743, 'Beam Internet', 'beaminternet.com.au', 'AU', 8704, 'isp', '0000-00-00 00:00:00', 0),
(4325, 134744, 'RJ Watson and S V Watson', 'countrynet.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4326, 134747, 'Peninsula Health', 'phcn.vic.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4327, 134748, 'Geoscience Australia', 'ga.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4328, 134749, 'SPEED TECH ONLINE', 'come2speed.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4329, 13475, 'UNIFY Financial Credit Union', 'unifyfcu.com', 'US', 256, 'business', '2012-09-24 00:00:00', 0),
(4330, 134750, 'STAR NETWORK', 'starnetworkbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(4331, 134753, 'West Kowloon Cultural District Authority', 'westkowloon.hk', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4332, 134754, 'Computer One Software Australia Pty Ltd', 'computerone.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4333, 134756, 'CHINANET Nanjing Jishan IDC network', 'gsta.com', 'CN', 59392, 'isp', '0000-00-00 00:00:00', 0),
(4334, 13476, 'Montana State University', 'montana.edu', 'US', 80640, 'education', '1999-06-16 00:00:00', 0),
(4335, 134761, 'CHINANET NINGXIA province ZHONGWEI IDC network', 'gsta.com', 'CN', 12288, 'isp', '0000-00-00 00:00:00', 0),
(4336, 134762, 'CHINANET Liaoning province Dalian MAN network', 'chinatelecom.cn', 'CN', 178176, 'isp', '0000-00-00 00:00:00', 0),
(4337, 134763, 'CHINANET Guangdong province network', 'gsta.com', 'CN', 121600, 'isp', '0000-00-00 00:00:00', 0),
(4338, 134764, 'CHINANET Guangdong province network', 'gsta.com', 'CN', 215040, 'isp', '0000-00-00 00:00:00', 0),
(4339, 134765, 'CHINANET Yunnan province IDC1 network', 'chinatelecom.cn', 'CN', 36352, 'isp', '0000-00-00 00:00:00', 0),
(4340, 134766, 'CHINANET Yunnan province IDC2 network', 'chinatelecom.cn', 'CN', 33280, 'isp', '0000-00-00 00:00:00', 0),
(4341, 134768, 'CHINANET SHAANXI province Cloud Base network', 'chinatelecom.cn', 'CN', 141824, 'isp', '0000-00-00 00:00:00', 0),
(4342, 134769, 'ChinaNet Jiangsu Changzhou Liyang IDC network', 'gsta.com', 'CN', 9728, 'isp', '0000-00-00 00:00:00', 0),
(4343, 134770, 'CHINANET Jiangsu province Suzhou taihu IDC network', 'chinatelecom.cn', 'CN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(4344, 134771, 'WENZHOU, ZHEJIANG Province, P.R.China.', 'chinatelecom.cn', 'CN', 55808, 'isp', '0000-00-00 00:00:00', 0),
(4345, 134772, 'CHINANET Guangdong province Dongguan MAN network', 'chinatelecom.cn', 'CN', 1882880, 'isp', '0000-00-00 00:00:00', 0),
(4346, 134774, 'CHINANET Guangdong province Shenzhen MAN network', 'gsta.com', 'CN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4347, 134775, 'CHINANET Guangdong province Zhusanjiao MAN network', 'chinatelecom.cn', 'CN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4348, 134778, 'Illawarra Retirement Trust', 'irt.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4349, 134780, 'Low Speed Network', 'lowspeedbd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4350, 134781, 'HI-SPEED BROADBAND NETWORK', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4351, 134783, 'Amalgamated Telecom Holdings Kiribati Ltd', 'athkl.com.ki', 'KI', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4352, 134784, 'NasdaqOMX Bangalore', 'nasdaqomx.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4353, 134785, 'PRESTIGE NETWORK LIMITED', 'pnetguard.net', 'WS', 2048, 'business', '0000-00-00 00:00:00', 0),
(4354, 134787, 'TEACHERS MUTUAL BANK LIMITED', 'tmbank.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4355, 134788, 'Parasat Cable TV, Inc', 'cable21.net', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4356, 134789, 'PRAMODANJALI TECHNOLOGIES PRIVATE LIMITED', 'pramotech.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4357, 134790, 'United International University', 'uiu.ac.bd', 'BD', 768, 'education', '0000-00-00 00:00:00', 0),
(4358, 134791, 'AUSTRALIAN COMPUTER SOLUTIONS PTY LTD', 'acs.net.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(4359, 134793, 'NTT Data Global Delivery Services Limited', 'nttdata.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4360, 134795, 'South Asia Universal Limited', 'southasiauniversal.hk', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(4361, 134796, 'NTT Data Global Delivery Services Limited', 'nttdata.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4362, 134797, 'Innet Technologies Sdn Bhd', 'innettech.com.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(4363, 134799, 'Shipco IT Pvt Ltd', 'shipco.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4364, 1348, 'California Department of Transportation', 'ca.gov', 'US', 49408, 'isp', '1991-09-12 00:00:00', 0),
(4365, 13480, 'Ongoing Operations, LLC', 'ongoingoperations.com', 'US', 7680, 'business', '2009-01-13 00:00:00', 0),
(4366, 134801, 'Synerzip Softech India Pvt Ltd', 'synerzip.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4367, 134802, 'Naic Cable TV Corp.', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(4368, 134803, 'Intellect Design Arena Limited', 'intellectdesign.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4369, 134804, 'ECTLINK', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4370, 134806, 'Sky View Online', 'skyviewonline.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4371, 134808, 'GLOBE VALLEY PTY LTD T/A ONSAVII', 'onsavii.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4372, 134809, 'ViewQwest Sdn. Bhd.', 'viewqwest.com', 'MY', 4352, 'isp', '0000-00-00 00:00:00', 0),
(4373, 134810, 'China Mobile Group JiLin communications corporation', 'chinamobile.com', 'CN', 777472, 'isp', '0000-00-00 00:00:00', 0),
(4374, 134811, 'Treasury Department', 'None', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(4375, 134812, 'Red Network Ltd', 'None', 'BD', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4376, 134813, 'Cyber Communication Bangladesh', 'cybercommunicationbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4377, 134814, 'Immunity networks and Technologies Pvt Ltd', 'immunitynetworks.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4378, 134817, 'Customer (Dusit Thani) request AS number for support BGP multihoming design(Two different Service Providers).', 'ntt.co.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4379, 134818, 'Epsom Girls Grammar School', 'eggs.school.nz', 'NZ', 256, 'education', '0000-00-00 00:00:00', 0),
(4380, 134819, 'GOVT OF INDIA', 'istrac.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4381, 13482, 'Zweig-DiMenna Associates, LLC.', 'zweig-dimenna.com', 'US', 2048, 'business', '1999-06-17 00:00:00', 0),
(4382, 134822, 'GOVT OF INDIA', 'istrac.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4383, 134823, 'Sky Digital Co., Ltd.', 'idc-tw.com', 'TW', 8448, 'hosting', '0000-00-00 00:00:00', 0),
(4384, 134824, 'OPTICAL LINK NETWORK', 'opticalbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4385, 134826, 'Softde\'but Co.,LTD.', 'softdebut.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(4386, 134827, 'EY Business Initiative Co., Ltd', 'ey.net', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(4387, 134829, 'PPIP Associated Communication Limited', 'ppipac.net', 'HK', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4388, 13483, 'Infor (US) Inc', 'infor.com', 'US', 8704, 'isp', '1999-06-17 00:00:00', 0),
(4389, 134830, 'Air-Stream Wireless Inc.', 'wisperconnect.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4390, 134832, 'Premier Technology Solutions Pty Ltd', 'premiertech.com.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(4391, 134834, 'IMS Health India Pvt Ltd', 'imshealth.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4392, 134835, 'Starry Network Limited', 'starry.com', 'HK', 11264, 'business', '0000-00-00 00:00:00', 0),
(4393, 134837, 'Dhaka Internet', 'dhakainternet.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4394, 134839, 'PropertyGuru Pte Ltd', 'propertyguru.com.sg', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(4395, 13484, '3D EXHIBITS INC', '3dexhibits.com', 'US', 256, 'business', '2017-07-18 00:00:00', 0),
(4396, 134840, 'Myanmar Country Co., Ltd.', 'myanmarcountry.net', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4397, 134841, 'Rana Javed Kabir t/a Interpid Broadband Communication Company Ltd.', 'intrepidbd.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4398, 134842, 'PGAS TELECOMMUNICATIONS INTERNATIONAL PTE. LTD', 'pgas-international.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(4399, 134844, 'ACCESS 4 PTY LTD', 'access4.com.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(4400, 134845, 'Wellington International Airport Limited', 'wellingtonairport.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4401, 134847, 'REDtone Data Centre Sdn. Bhd.', 'redtone.com', 'MY', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4402, 134849, 'Crystal Crop Protection Private Limited', 'crystalcrop.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4403, 13485, 'Grand Canyon University', 'gcu.edu', 'US', 53248, 'education', '2009-10-27 00:00:00', 0),
(4404, 134850, 'WAY 2 INTERNET PRIVATE LIMITED', 'way-2-internet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4405, 134852, 'AirZone internet Service Pvt. Ltd.', 'None', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(4406, 134853, 'BHIWANI COMMUNICATIONS PVT LTD', 'link4data.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4407, 134854, 'Robert Bosch engineering and business solutions private limited', 'bosch.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4408, 134855, 'ucom digital private limited', 'ucomdigital.com', 'IN', 5888, 'isp', '0000-00-00 00:00:00', 0),
(4409, 134856, 'Tri Infotech Pvt. Ltd', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4410, 134858, 'iForce Networks', 'iforcenetworks.co.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4411, 134859, 'IMPERIAL TECH SERVICES', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4412, 134861, 'BroadStar Net India Pvt.Ltd.', 'broadstarnet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4413, 134862, 'Ultimate Internet Services Private Limited', 'ultimate.net.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4414, 134863, 'SP INTERNET TECHNOLOGIES PRIVATE LTD', 'spit.co.in', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4415, 134866, 'Sscn Pvt Ltd', 'sscn.net.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4416, 134867, 'Sky Hifi internet services pvt ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4417, 134868, 'SHARKTEL INFOCOM PRIVATE LIMITED', 'sharktel.co', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4418, 134869, 'DHL BROADBAND NET P LIMITED', 'dhlbroadbandnet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4419, 13487, 'ULTRA PACKET LLC', 'ultrapacket.com', 'US', 14848, 'business', '2020-05-29 00:00:00', 0),
(4420, 134870, 'Broad Net India Private Limited', 'None', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(4421, 134871, 'LinkNet Broadband Pvt Ltd', 'linknetbroadband.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4422, 134872, 'Wi-Bro Solutions Pvt. Ltd', 'wibro.in', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(4423, 134873, 'ABS BROADBAND SERVICES PVT LTD', 'joister.net', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4424, 134874, 'Acme Diginet Corporation Pvt. Ltd.', 'digitalacme.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4425, 134875, 'ZPOINT KOTA', 'None', 'IN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4426, 134877, 'Sri Vari Network Private Limited', 'srivarigroups.com', 'IN', 6144, 'isp', '0000-00-00 00:00:00', 0),
(4427, 134878, 'GLORIOSA INFOTEL IT SERVICES INDIA PRIVATE LIMITED', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4428, 134880, 'Flix Broadband Services Private Limited', 'flixnetworks.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4429, 134881, 'JLINK INDIA', 'jlinkindia.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4430, 134883, 'Wsns Pvt. Ltd.', 'xnetbroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4431, 134884, 'ARICHWAL IT SERVICES PRIVATE LIMITED', 'aitspl.in', 'IN', 6144, 'isp', '0000-00-00 00:00:00', 0),
(4432, 134885, 'Global (India) Tele-Infra Pvt Ltd', 'gitipl.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(4433, 134886, 'Super Sonic Broadband Pvt Ltd', 'supersonicbb.net', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4434, 134887, 'Pyramid Infocom Pvt. Ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4435, 134888, 'Ganesha Internet Services India Private Limited', 'ganeshaisipl.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4436, 13489, 'EPM Telecomunicaciones S.A. E.S.P.', 'epm.net.co', 'CO', 2326528, 'isp', '1999-06-18 00:00:00', 0),
(4437, 134891, 'Everbiz Solutions Pvt Ltd', 'everbiz.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4438, 134892, 'TransMedia Technologies (AP) PVT LTD', 'transmedia.net.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4439, 134893, 'PrimeCrown Technologies Private Limited', 'primecrown.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4440, 134894, 'Emipro Technologies Pvt Ltd', 'emiprotechnologies.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4441, 134896, 'Avenue Ecommerce Ltd', 'dmartindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4442, 134897, 'SEVA NETWORKS PVT LTD', 'sevabroadband.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4443, 134899, 'Cityzone Infonet Pvt Ltd', 'cityzoneinfonet.com', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(4444, 13490, 'Buckeye Cablevision, Inc.', 'buckeyecablesystem.com', 'US', 238080, 'isp', '1999-06-18 00:00:00', 0),
(4445, 134900, 'Development Logics Solutions Pvt Ltd', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4446, 134901, 'Indian Institute Of Science Education And Research', 'iiserpune.ac.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(4447, 134903, 'Smart Wi5 Pvt. Ltd.', 'wi5net.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4448, 134905, 'iGEN Networks Pvt Ltd', 'igennetworks.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4449, 134906, 'Nanjil Internet Services Pvt Ltd', 'nanjilbroadband.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4450, 134907, 'Bharat VoIP Communications Pvt Ltd', 'bharatvoip.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4451, 134908, 'IKON BROADBAND PRIVATE LIMITED', 'ikonbroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4452, 134909, 'THE SOUTH INDIAN BANK LTD', 'sib.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4453, 13491, 'Florida State Board of Administration', 'sbafla.com', 'US', 512, 'business', '2007-04-04 00:00:00', 0),
(4454, 134910, 'iEnergizer IT Services Pvt. Ltd.', 'ienergizer.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4455, 134911, 'Sigaram Networks Pvt Ltd', 'sigaramnet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4456, 134913, 'JETWAY BROADBAND INDIA PVT LTD', 'jetwaybroadband.com', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4457, 134914, 'Ansh Net Sol Pvt. Ltd.', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4458, 134916, 'Soliton NetLink Pvt. Ltd.', 'solitonnetlink.in', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(4459, 134917, 'Ragsaa Communication pvt. ltd.', 'ragsaacommunication.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4460, 134918, 'Blue Net It Soltions Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4461, 134919, 'Green Energy', 'gtel.in', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(4462, 13492, 'American Health Network', 'ahni.com', 'US', 512, 'business', '2005-07-05 00:00:00', 0),
(4463, 134920, 'Thomson Reuters International Services Pvt Ltd', 'thomsonreuters.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4464, 134922, 'R G TECHNOSOLUTIONS PVT LTD', 'renubroadband.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4465, 134924, 'Aph Networks Private Limited', 'aphnetworks.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4466, 134926, 'Micro Hosting Private Limited', 'microhost.com', 'IN', 3584, 'hosting', '0000-00-00 00:00:00', 0),
(4467, 134927, 'Idea Cellular Limited', 'adityabirla.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4468, 134928, 'Spiderlink Networks Pvt Ltd', 'irinn.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(4469, 134929, 'ORANGE CITY INTERNET SERVICES PVT. LTD.', 'orangecityinternet.co.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4470, 134930, 'TAMANA WINET PVT LTD', 'tamanawinet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4471, 134931, 'One97 Communications Ltd', 'one97.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4472, 134933, 'Webline Broadband Pvt Ltd', 'weblinebroadband.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4473, 134934, 'Institute For Stem Cell Biology And Regenerative Medicine', 'instem.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4474, 134936, 'PlexBroadband Pvt Ltd', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4475, 134937, 'Speed Communicaion', 'sukaininfoway.com', 'IN', 6144, 'isp', '0000-00-00 00:00:00', 0),
(4476, 134938, 'CAMP Systems Pvt Ltd', 'campsystems.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4477, 134939, 'Lionet Solutions', 'lionet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4478, 13494, 'Morningstar, Inc.', 'morningstar.com', 'US', 256, 'business', '1999-06-21 00:00:00', 0),
(4479, 134941, 'INSTANT CABLE NETWORK PVT LTD', 'icnindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4480, 134942, 'Ashok Secure Broadband Network Pvt Ltd', 'abnetwork.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4481, 134943, 'RETICULE INFOTECH PVT.LTD', 'wiprabroadband.in', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4482, 134944, 'Jiffy Cable And Datacom Private Limited', 'jiffybroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4483, 134945, 'Blue Sky Broadband Pvt. Ltd.', 'blueskynetwork.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4484, 134946, 'Indophone Networks', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4485, 134949, 'ALLCOM NETWORKS PTY LTD', 'allcomnetworks.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4486, 13495, 'NTT DO BRASIL TELECOMUNICACOES LTDA.', 'ntt.com', 'BR', 8192, 'isp', '1999-11-18 00:00:00', 0),
(4487, 13496, 'Belcan Corporation', 'belcan.com', 'US', 1024, 'business', '2010-06-07 00:00:00', 0),
(4488, 134963, 'Alibaba.com Singapore E-Commerce Private Limited', 'alibaba-inc.com', 'SG', 23808, 'business', '0000-00-00 00:00:00', 0),
(4489, 134964, 'KONY INDIA PVT LTD', 'kony.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4490, 134966, 'Southern CableVision Inc.', 'southerncablevision.com.ph', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(4491, 134967, 'TopQuality Limited', 'tq.net.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4492, 134968, 'Mizanur Rahman t/a Maya Cyber World', 'mayacyberworld.com', 'BD', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4493, 134969, 'OPENTEXT', 'opentext.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4494, 134970, 'Tuhin Enterprise Bangladesh', 'None', 'BD', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4495, 134971, 'Md. Maniruzzaman Manir t/a Doly IT Corner', 'dolyitcorner.net', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4496, 134974, 'Oakleigh Networks', 'oakleighcapital.com', 'PH', 2816, 'business', '0000-00-00 00:00:00', 0),
(4497, 134975, 'RateGain Travel Technologies Private Limited', 'rategain.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4498, 134976, 'Myint & Associates Telecommunications Ltd', 'myintassociates.com', 'MM', 2048, 'business', '0000-00-00 00:00:00', 0),
(4499, 134979, 'New Eagle Ltd', 'None', 'HK', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4500, 13498, 'TSYS LOYALTY, INC.', 'tsys.com', 'US', 512, 'business', '2007-12-14 00:00:00', 0),
(4501, 134980, 'Interphone Pty Ltd', 'interphone.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4502, 134981, 'Uber Inc', 'uber.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4503, 134982, 'NINE ENTERTAINMENT CO. PTY LTD', 'nineforbrands.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4504, 134983, 'BDPEER', 'bdpeer.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4505, 134984, 'NextGen.Net Pty Ltd', 'nextgen.net', 'AU', 8704, 'business', '0000-00-00 00:00:00', 0),
(4506, 134985, 'Digital Accord Pty Ltd', 'accordhost.com.au', 'AU', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4507, 134986, 'Sundaram Home Finance Limited', 'sundaraminfotech.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4508, 134987, 'Xtime Asia Pacific Pty Ltd', 'xtime.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4509, 134988, 'Gateway Teleport Ltd.', 'gatewayteleport.com', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4510, 13499, 'CentralColo, LLC', 'centralcolo.com', 'US', 15104, 'business', '2014-12-09 00:00:00', 0),
(4511, 134990, 'CiTYCOM Network', 'citycomnetwork.com', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(4512, 134994, 'Wilson Parking Australia 1992 PTY LTD', 'wilsongroupau.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4513, 134995, 'I. ZONE PVT. LTD', 'yzone.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(4514, 134996, 'BSITC PHILS., INC.', 'None', 'PH', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(4515, 134998, 'NGT Networks Pte Ltd', 'ngtnetworks.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4516, 134999, 'Adelaide Airport Limited', 'aal.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4517, 1350, 'Sears Technology Services Incorporated', 'sears.com', 'US', 1536, 'business', '1991-09-12 00:00:00', 0),
(4518, 13500, 'NTT Security (US) Inc.', 'nttsecurity.com', 'US', 256, 'business', '1999-06-21 00:00:00', 0),
(4519, 135002, 'Singapore Exchange Limited', 'sgx.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4520, 135003, 'Multan Cable & Internet Services (Pvt) Ltd', 'mispl.pk', 'PK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4521, 135005, 'ATA TELECOM Co., Ltd', 'atatelecom.com', 'KH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4522, 135006, 'VERI2', 'veri2.com', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(4523, 135008, 'GOVERNMENT TECHNOLOGY AGENCY', 'tech.gov.sg', 'SG', 13312, 'business', '0000-00-00 00:00:00', 0),
(4524, 13501, 'OARnet', 'osc.edu', 'US', 1792, 'education', '1999-06-21 00:00:00', 0),
(4525, 135010, 'WINSPEED NETWORK (HK) LIMITED', '765.com.cn', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4526, 135012, 'Suan Dusit University', 'dusit.ac.th', 'TH', 768, 'education', '0000-00-00 00:00:00', 0),
(4527, 135014, 'Crosspoint Telecom PTE. LTD.', 'crosspoint-telecom.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4528, 135015, 'SPRITE NETWORKS PTY LTD', 'sprite.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4529, 135016, 'Reece Australia Pty LTD', 'reece.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4530, 135017, 'Data Center Network Limited', 'datacenterinc.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(4531, 135018, 'Manly Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4532, 135019, 'Amarnet System', 'amarnetsystem.com', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(4533, 135022, 'Recursion Technologies Ltd', 'r-cis.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(4534, 135023, 'Maximum Control Limited', 'maximumcontrol.nz', 'NZ', 2048, 'business', '0000-00-00 00:00:00', 0),
(4535, 135024, 'Wilson Parking Australia 1992 PTY LTD', 'wilsongroupau.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4536, 135025, 'Nexlogic Telecommunications Network, Inc.', 'nexlogic.ph', 'PH', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4537, 135026, 'ThinkDream Technology Limited', 'thinkdream.com', 'HK', 11264, 'hosting', '0000-00-00 00:00:00', 0),
(4538, 13503, 'Theorem', 'theorem.net', 'CA', 256, 'business', '2020-02-07 00:00:00', 0),
(4539, 135030, 'REAL STATION BROADBAND', 'realstationbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(4540, 135031, 'RI Networks Pvt. Ltd.', 'rinetworks.in', 'IN', 9472, 'isp', '0000-00-00 00:00:00', 0),
(4541, 135032, 'PRAN-RFL Group', 'prangroup.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4542, 135033, 'BodiSystems Co. Ltd', 'bodisystems.mn', 'MN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4543, 135034, 'Planet Communications Asia Public Company Limited', 'planetcomm.com', 'TH', 2048, 'business', '0000-00-00 00:00:00', 0),
(4544, 135035, 'PT. Orion Data Teknologi', 'vimaladata.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4545, 135036, 'UCPL - NextG Network Provider', 'unetcommunication.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4546, 135037, 'Techno Asia InfoTech Pvt. ltd', 'technoasiabd.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4547, 135038, 'Synesis IT Limited', 'synesisit.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4548, 135039, 'Code Valley Corp Pty Ltd', 'codevalley.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4549, 135040, 'Integrated Technology Solutions Limited', 'itslonline.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4550, 135043, 'DOEN Net Private Limited', 'doennet.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4551, 135044, 'MIENTERPRISE PTY LTD', 'miclub.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4552, 135045, 'MD Salauddin', 'unitynet.org', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4553, 135046, 'One IT Services Pty Ltd', 'oneitservices.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4554, 135047, 'NTT NEW ZEALAND LIMITED', 'dimensiondata.com', 'NZ', 1280, 'business', '0000-00-00 00:00:00', 0),
(4555, 135048, 'Singapore Pools (Private) Limited', 'sgpoolz.com.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4556, 13505, 'SANDATA Technologies Inc.', 'sandata.com', 'US', 1280, 'business', '1999-06-23 00:00:00', 0),
(4557, 135050, 'Acetek Systems Pty Ltd', 'acetek.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4558, 135051, 'Emersion Software Systems', 'emersion.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4559, 135054, 'Signature International', 'signature-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4560, 135055, 'Rafiqul Islam Rassel t/a Rafine Satelite', 'rafinsatellite.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4561, 135059, 'Lao Asia Pacific Satellite Co., Ltd.', 'laosatellite.com', 'LA', 512, 'isp', '0000-00-00 00:00:00', 0),
(4562, 13506, 'US Department of the Treasury', 'treasury.gov', 'US', 81920, 'business', '1999-06-23 00:00:00', 0),
(4563, 135060, 'Telair Pty Ltd', 'telair.com.au', 'AU', 4864, 'isp', '0000-00-00 00:00:00', 0),
(4564, 135061, 'China Unicom Guangdong IP network', 'chinaunicom.cn', 'CN', 34560, 'isp', '0000-00-00 00:00:00', 0),
(4565, 135062, 'FINE BRAVERY (HONG KONG) LIMITED', 'fbravery.com', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(4566, 135063, 'POP NIX COMPANY LIMITED', 'pop-nix.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4567, 135065, 'National Directorate of Information and Technology', 'None', 'TL', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(4568, 135066, 'Schroders Investment Management (Singapore) Limited', 'schroders.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4569, 135067, 'LOGICOM TECHNOLOGY CO.,LIMITED', 'logicom.com.hk', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(4570, 135069, 'Feenix Communications Limited', 'feenix.co.nz', 'NZ', 4352, 'isp', '0000-00-00 00:00:00', 0),
(4571, 13507, 'Sears Holdings Corporation', 'searshc.com', 'US', 2304, 'business', '1999-06-23 00:00:00', 0),
(4572, 135071, 'VIDEO ELEPHANT', 'videoelephantbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4573, 135074, 'Boromarajonani College of Nursing, Bangkok', 'trueinternet.co.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4574, 135076, 'INFOCOM LIMITED', 'infocomltd.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4575, 13508, 'Baker Bros. Advisors, LLC', 'rfa.com', 'US', 256, 'business', '2006-11-01 00:00:00', 0),
(4576, 135081, 'RP Global', 'None', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4577, 135082, 'Labvantage Solutions Pvt. Ltd.', 'labvantage.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4578, 135086, 'Axis Bank Limited', 'axisbank.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4579, 135088, 'Grid Technology Pty Ltd', 'gridtechnology.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4580, 13509, 'Xerium Technologies, Inc.', 'xerium.com', 'US', 256, 'business', '2007-06-06 00:00:00', 0),
(4581, 135090, 'Star Particle Board Mills Limited', 'psgbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4582, 135092, 'Ashraf Uddin t/a Dhaka tech', 'dhakatech.com', 'BD', 3328, 'isp', '0000-00-00 00:00:00', 0),
(4583, 135098, 'Bright Star Network', 'brightstarnetwork.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4584, 135099, 'AROWANA PTY. LTD. T/A CHOICE IT', 'yourhub.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4585, 1351, 'University of Vermont', 'uvm.edu', 'US', 66048, 'education', '1991-09-17 00:00:00', 0),
(4586, 13510, 'Baystate Health, Inc.', 'baystatehealth.com', 'US', 512, 'business', '2007-05-16 00:00:00', 0),
(4587, 135100, 'Maxnet Online Limited', 'maxnetonlinebd.com', 'BD', 1280, 'business', '0000-00-00 00:00:00', 0),
(4588, 135101, 'IFLIX Sdn. Bhd.', 'iflix.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(4589, 135104, 'Catholic Healthcare Ltd', 'chcs.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4590, 135105, 'ZEARA MANAGED SERVICES PTY LTD', 'zeara.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4591, 135106, 'CareTel Pty Ltd', 'caretel.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4592, 135107, 'CLOUD SERVERS AUSTRALIA PTY LTD', 'cloudserversaustralia.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4593, 135108, 'Enosys Solutions Pty Ltd', 'enosys.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4594, 13511, 'Univision Communications Inc.', 'univision.com', 'US', 2048, 'business', '2008-09-18 00:00:00', 0),
(4595, 135111, 'Asia Mega Link', 'asiamegalink.com', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(4596, 135112, 'Sharenet Limited', 'vpsnine.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4597, 135115, 'Wasiul Islam Mostazir t/a WIMS ONLINE', 'None', 'BD', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4598, 135118, 'The Corporation of the City of Adelaide', 'cityofadelaide.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4599, 13512, 'Monroe Telephone Co.', 'monroetel.com', 'US', 3072, 'business', '2007-06-06 00:00:00', 0),
(4600, 135121, 'Prospa Advance Pty Ltd', 'prospa.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4601, 135122, 'MILLAWAVE', 'millawave.net', 'PH', 768, 'business', '0000-00-00 00:00:00', 0),
(4602, 135123, 'Samba Bank Limited', 'samba.com.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4603, 135124, 'Green Surma Communications', 'greensurmacommunications.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(4604, 135125, 'Emdadul Huq Khan t/a Talmuri Computer System', 'talmuri.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4605, 135126, 'Occom Pty Ltd', 'occom.com.au', 'AU', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4606, 135127, 'XSTRA Group Pty Ltd', 'xstragroup.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4607, 13513, 'Alfred University', 'alfred.edu', 'US', 65536, 'education', '2018-01-03 00:00:00', 0),
(4608, 135130, 'Md. Wahid Murad T/A Anik Computer & Networking', 'aniknetwork.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4609, 135131, 'BROTHERS ONLINE', 'brothersonlineisp.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4610, 135132, 'Dreamscape Networks Inc.', 'dreamscapenetworks.com', 'PH', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4611, 135133, 'PI DATA CENTERS PRIVATE LIMITED', 'pidatacenters.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4612, 135134, 'Soon Keat Neo', 'soonkeat.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4613, 135137, 'OAS COMPUTERS PTY LIMITED', 'oas.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4614, 135139, 'Skylink Fibernet Private Limited', 'skylink.net.in', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(4615, 135140, 'Qun Ying Network Technology (Hong Kong) Co., Limited', 'None', 'HK', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(4616, 135141, 'Rajamangala University of Technology Lanna', 'uni.net.th', 'TH', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4617, 135142, 'Enigma Solutions Limited', 'enigma.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4618, 135146, 'PCCW IMS Ltd (PCCW Business Internet Access)', 'pccw.com', 'HK', 512, 'isp', '0000-00-00 00:00:00', 0),
(4619, 135148, 'AUTOMOTIVE HOLDINGS GROUP LIMITED', 'ahg.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4620, 135149, 'Myanmar Technology Gateway Co., Ltd', 'mtg.com.mm', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(4621, 13515, 'Palm Beach Atlantic University', 'pba.edu', 'US', 40960, 'education', '1999-06-25 00:00:00', 0),
(4622, 135150, 'Hillside (Australia New Media) Pty Ltd', 'hillsidenewmedia.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4623, 135152, 'Global Network Transit Limited', 'globalnetworkhk.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4624, 135153, 'Kassawin Pty Ltd', 'qbt.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4625, 135154, 'Genesis Energy Limited', 'genesisenergy.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4626, 135155, 'Md. Anowar Hossain t/a Taltola.net', 'taltola.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4627, 135157, 'Hilton Haulage Limited', 'hiltons.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4628, 135158, 'Softnet Limited', 'softnet.eu', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(4629, 13516, 'Cancer Treatment Centers of America, Inc.', 'cancercenter.com', 'US', 512, 'business', '2013-02-15 00:00:00', 0),
(4630, 135160, 'INTERMEDIA.NET AUSTRALIA PTY. LTD.', 'intermedia.net', 'AU', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4631, 135161, 'GMO-Z com NetDesign Holdings Co., Ltd.', 'gmo.jp', 'TH', 23040, 'hosting', '0000-00-00 00:00:00', 0),
(4632, 135162, 'eUP-University of the Philippines System', 'up.edu.ph', 'PH', 512, 'education', '0000-00-00 00:00:00', 0),
(4633, 135165, 'Laing O\'Rourke Australia Pty Ltd', 'laingorourke.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4634, 135166, 'Savills Management Services Limited', 'savills.asia', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(4635, 135168, 'CardGate.net Pty Ltd', 'cardgate.net', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4636, 13517, 'Baker & McKenzie', 'bakermckenzie.com', 'US', 1024, 'business', '1999-06-25 00:00:00', 0),
(4637, 135170, 'Servernet Services Pvt Ltd', 'servernetservices.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4638, 135171, 'Balaji Infra Ray Private Limited', 'balajiinfraray.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4639, 135172, 'EZEENET INTERNET SOLUTIONS PVT LTD', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4640, 135173, 'INDIA METEOROLOGICAL DEPARTMENT', 'imd.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4641, 135179, 'Pc Solutions Pvt. Ltd.', 'e-pspl.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4642, 13518, 'COMMUNICATIONS DESIGN ACQUISITION CORPORATION', 'ottcommunications.com', 'US', 1024, 'business', '2005-07-11 00:00:00', 0),
(4643, 135180, 'starlings wireless communications pvt ltd', 'starlingsgoa.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4644, 135181, 'KANGLA ENTERPRISES PRIVATE LIMITED', 'kanglaenterprises.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4645, 135182, 'MORADABAD INTERNET SERVICES PRIVATE LIMITED', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4646, 135183, 'YFI BROADBAND', 'yfi.co.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4647, 135184, 'TRUEiNET NETWORKS', 'trueinet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4648, 135185, 'ATOZ INFOLINK PVT. LTD.', 'atozinfolink.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4649, 135186, 'Light Air Transmission Pvt. Ltd.', 'xfinityinternet.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4650, 135187, 'Expeditive Infotech Private Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(4651, 135189, 'I connect broadband support and services', 'None', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4652, 135190, 'Ubercore Data Labs Private Limited', 'ubercore.company', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4653, 135191, 'HARKYAL TELE SERVICES PRIVATE LIMITED', 'irinn.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4654, 135192, 'Rv Broadband Services Pvt Ltd', 'rvbroadband.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4655, 135193, 'Gigatel Networks Private Limited', 'gigatelnetworks.com', 'IN', 5632, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(4656, 135194, 'Axa Technologies Shared Services Private Limited', 'axa-tech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4657, 135197, 'Multi Commodity Exchange Of India Ltd', 'mcxindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4658, 135198, 'Bombay Bullion Commmunication', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4659, 13520, 'Signode Industrial Group LLC', 'signodegroup.com', 'US', 256, 'business', '2015-01-09 00:00:00', 0),
(4660, 135201, 'siddhbali infotech pvt ltd.', 'None', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4661, 135202, 'Netfirre Communications Pvt Ltd', 'netfire.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4662, 135205, 'Aabasoft Technologies India Private Limited', 'aabasoft.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4663, 135206, 'Bluwaves Internet Services India P. Ltd', 'bluwaves.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4664, 135207, 'Cloudnet Communications Pvt Ltd', 'cloudnet-india.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(4665, 135208, 'Megahertz Internet Network Pvt. Ltd.', 'megahertz.net.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4666, 135209, 'infinity wireless services private limited', 'infinityinfotech.org', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4667, 135212, 'Digiway Net Pvt Ltd', 'digiwaynet.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4668, 135214, 'Spider Broadband Pvt. Ltd.', 'spiderbroadband.net', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4669, 135215, 'Mark Network Solutions India Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4670, 135216, 'Airway Communication Services India Pvt Ltd', 'airwaycommunication.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4671, 135217, 'Peak Air Pvt Ltd', 'peakair.in', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(4672, 135218, 'Gtel Communications Private Limited', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(4673, 135219, 'Sai Net Solutions', 'sainetsolutions.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4674, 13522, 'PUC PR CAMPUS CURITIBA', 'pucpr.br', 'BR', 4096, 'business', '2000-08-04 00:00:00', 0),
(4675, 135220, 'Yuva Networks', 'yuvanetworks.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4676, 135223, 'Netway Internet Pvt Ltd', 'netwayinternet.co.in', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(4677, 135224, 'EASY TELNET SERVICES PVT. LTD.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4678, 135225, 'SMART NET INDIA PVT LTD', 'smartnetisp.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4679, 135226, 'Jeecommunications', 'jeecommunications.com', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4680, 135227, 'Foxcell Communication Pvt Ltd', 'foxcell.net', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4681, 135228, 'vardha info tech private limited', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4682, 135229, 'Magica Net', 'magicanet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4683, 135232, 'IPNET COMMUNICATIONS', 'ipnetcommunications.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4684, 135234, 'SHERIE PLEXUS ISP PRIVATE LIMITED', 'fibronet.co.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4685, 135235, 'Mastek Infosystems O. Pvt. Ltd.', 'irinn.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4686, 135238, 'TransCentra FTS India Pvt Ltd', 'transcentra.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4687, 135239, 'Sonali Internet Services Pvt Ltd', 'sonaliinternetservices.com', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(4688, 13524, 'Arrow Electronics', 'arrow.com', 'US', 3840, 'business', '1999-06-28 00:00:00', 0),
(4689, 135241, 'Packenet IT And Telephony Solutions', 'packetnet.in', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(4690, 135242, 'Touchous Communication Pvt Ltd', 'touchousindia.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4691, 135243, 'Lalitpur Power Generation Company Limited', 'lpgcl.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4692, 135244, 'Kedia Internet Private Limited', 'k-net.co.in', 'IN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(4693, 135245, 'Bennett Coleman And Co Ltd', 'timesgroup.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4694, 135247, 'K Net Solutions Pvt Ltd', 'knet.co.in', 'IN', 4608, 'isp', '0000-00-00 00:00:00', 0),
(4695, 13525, 'The Computer Shop Netlink', 'tcsn.net', 'US', 2048, 'business', '1999-06-28 00:00:00', 0),
(4696, 135250, 'LINKIN COMMUCATION PVT LTD', 'linkincom.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4697, 135251, 'Microtel Internet Network Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4698, 135253, 'Mft Internet Private Limited', 'mftinternet.com', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(4699, 135255, 'Agrawal Technology Solutions', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4700, 135256, 'ONET DIGITAL NETWORKS PVT. LTD.', 'onet.net.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4701, 135257, 'DL GTPL Broadband Private Limited', 'dlgtpl.net', 'IN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(4702, 135259, 'SKYLINE INFONET PRIVATE LIMITED', 'None', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4703, 135260, '42 Communications Pvt. Ltd.', '42communications.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4704, 135261, 'Soft World Infonet', 'softworldinfonet.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4705, 135262, 'CredenceIS Computing Private Limited', 'faast.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4706, 135263, 'Pine Labs Pvt. Ltd.', 'pinelabs.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4707, 135264, 'Futurenet.com Pvt. Ltd.', 'futurenet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4708, 135266, 'AAKASH INTERNET SERVICES PRIVATE LIMITED', 'aakashisp.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4709, 135267, 'D NEX TECHNOLOGY PVT LTD', 'dnextechnology.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4710, 135269, 'Fast 4 Technologies', 'fastfortechnologies.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4711, 135270, 'NasdaqOMX', 'nasdaqomx.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4712, 135273, 'NTC ASIA LIMITED', 'neocomisp.com', 'HK', 4864, 'isp', '0000-00-00 00:00:00', 0),
(4713, 135275, 'EVERLIGHT RADIOLOGY LIMITED', 'everlightradiology.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4714, 135277, 'Freshtel Group SDN BHD', 'freshtel.my', 'MY', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4715, 135278, 'HOME BOX OFFICE (SINGAPORE) PTE LTD', 'hboasia.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4716, 135283, 'Trusted Source Pte Ltd', 'tspl.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4717, 135286, 'Star Digital MUDs TV Limited', 'emaxxtelecom.com.kh', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4718, 135287, 'The Council of the City of Sydney', 'nsw.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4719, 135288, 'Auckland Museum Trust Board', 'aucklandmuseum.com', 'NZ', 256, 'isp', '0000-00-00 00:00:00', 0),
(4720, 135289, 'JBS Australia Pty Ltd', 'jbssa.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4721, 135290, 'SAN-IDC', 'san-idc.net', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4722, 135291, 'APPTIO SINGAPORE PTE. LTD.', 'apptio.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4723, 135292, 'Macquarie Media Limited', 'macquariemedia.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4724, 135293, 'Ezlink Cloud Technology Co., Limted', 'ezlinkcloud.com', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(4725, 135294, 'Queensland Airports Limited', 'qldairports.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4726, 135295, 'Fast CDN', 'fastcdn.tech', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4727, 135297, 'BAMBORA ONLINE PTY LTD', 'bambora.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4728, 135298, 'Ankabut Internet Service Provider', 'ankabut.af', 'AF', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4729, 135299, 'TechProcess Payment Services Limited', 'techprocess.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4730, 13530, 'Dana Limited', 'dana.com', 'US', 9472, 'business', '1999-06-29 00:00:00', 0),
(4731, 135300, 'Myanmar Broadband Telecom Co., Ltd', 'mbt.com.mm', 'MM', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4732, 135301, 'iQ3 Pty Ltd.', 'iq3.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4733, 135303, 'N.I.T.V Streamz Pvt. Ltd', 'nettv.com.np', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(4734, 135304, 'VMWare Incorporation', 'vmware.com', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(4735, 135307, 'Golden TMH Telecom Co. Ltd', 'gtmh-telecom.com', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4736, 135310, 'Inspire Broadband Limited', 'inspirebroadband.net', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(4737, 135311, 'Golam Mohammad T/A 29Communication', '29com.net', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4738, 135313, 'Coca-Cola Amatil', 'ccamatil.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4739, 135317, 'BHP BILLITON IRON ORE PTY. LTD.', 'bhpbilliton.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4740, 135319, 'Wopop International Limited', 'cndns.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4741, 13532, 'Need To Know News, LLC', 'mni-news.com', 'US', 1024, 'business', '2010-03-02 00:00:00', 0),
(4742, 135320, 'Inventurus Knowledge Solutions Private Limited', 'ikshealth.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4743, 135321, 'Skynet Broadband Pty Ltd', 'skynetbroadband.com.au', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(4744, 135323, 'Talk To You Soon Pty Limited', 'ttys.com.au', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(4745, 135326, 'VOIPMONSTER PTY LTD T/A SCOOTNET', 'sprintnet.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4746, 135327, 'Cherry World Communication Pvt Ltd', 'cwc.com.np', 'NP', 2048, 'business', '0000-00-00 00:00:00', 0),
(4747, 135328, 'Tangelo Services', 'tangelo.com', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(4748, 135330, 'ADCDATA.COM', 'adcdata.com', 'HK', 7168, 'hosting', '0000-00-00 00:00:00', 0),
(4749, 135332, 'PEPPER GROUP PTY LIMITED', 'pepper.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4750, 135333, 'CAMKOM CABLE TV CO, LTD.', 'neocomisp.com', 'KH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4751, 135336, 'HEALTH METRICS PTY LTD', 'healthmetrics.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4752, 135337, 'Cloud Himalaya Pvt Ltd', 'cloudhimalaya.com', 'NP', 768, 'business', '0000-00-00 00:00:00', 0),
(4753, 135339, 'Fuad Muhammad Shorfuddin T/A Fissa Communication', 'None', 'BD', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4754, 13534, 'Ralls Technologies, LLC', 'rallstech.com', 'US', 8192, 'business', '2005-08-29 00:00:00', 0),
(4755, 135343, 'Cross Geminis Limited', 'serverrun.com', 'HK', 3328, 'hosting', '0000-00-00 00:00:00', 0),
(4756, 135344, 'Transactor Technologies Limited', 'transact.bm', 'NZ', 512, 'isp', '0000-00-00 00:00:00', 0),
(4757, 135345, 'NewMountainView Satellite Corporation', 'mountainview.com.ph', 'PH', 4864, 'isp', '0000-00-00 00:00:00', 0),
(4758, 135346, 'Bismillah Telecom Service', 'bismillahwireless.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(4759, 135347, 'Novum Networks (Operations) Pty Ltd', 'novumnetworks.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4760, 13535, 'Ning Interactive, Inc.', 'ning.com', 'US', 1280, 'business', '2007-06-06 00:00:00', 0),
(4761, 135350, 'Immanuel College', 'immanuel.sa.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(4762, 135351, 'SMSGlobal Pty Ltd', 'smsglobal.com', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(4763, 135352, 'The Signal Co. Wireless', 'thesignalco.com.au', 'AU', 3072, 'isp', '0000-00-00 00:00:00', 0),
(4764, 135353, 'MD SHIRAJUL HAIDER T/A Cue Club Technology', 'cueclub.com.bd', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(4765, 135354, 'NAVER BUSINESS PLATFORM ASIA PACIFIC PTE. LTD.', 'navercorp.com', 'SG', 201216, 'isp', '0000-00-00 00:00:00', 0),
(4766, 135356, 'CN CARE NETWORK LTD', 'cncarehk.com', 'HK', 5888, 'isp', '0000-00-00 00:00:00', 0),
(4767, 135357, 'Shenzhen Katherine Heng Technology Information Co., Ltd.', 'None', 'CN', 103680, 'hosting', '0000-00-00 00:00:00', 0),
(4768, 135358, 'MYOB Australia Pty Ltd', 'myob.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4769, 135359, 'TheTubes Pty Ltd', 'thetubes.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(4770, 13536, 'First Light Fiber', 'firstlight.net', 'US', 273408, 'isp', '1999-06-30 00:00:00', 0),
(4771, 135360, 'Argon Data Network', 'argon.sg', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(4772, 135363, 'Beijing Dunhuang Heguang Information Technology Co.,Lt.', 'dhgate.com', 'CN', 1792, 'business', '0000-00-00 00:00:00', 0),
(4773, 135365, 'Shanghai Youzu Information Technology Co. LTD', 'youzu.com', 'CN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4774, 135366, 'Zafra Cable TV Network Inc.', 'zafra-cable.tv', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4775, 135368, 'SCENTRE LIMITED', 'scentregroup.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4776, 135369, 'ENTERPRISE & BUSINESS DATE CENTRE (HK) LIMITED', 'ws990.com', 'HK', 3584, 'business', '0000-00-00 00:00:00', 0),
(4777, 13537, 'Mega Colocation, Inc.', 'megacolocationonline.com', 'US', 4096, 'business', '2008-09-18 00:00:00', 0),
(4778, 135370, 'PT Telematika Mitrakreasi', 'telematika-mitrakreasi.co.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(4779, 135371, 'Fortune Broadband', 'fortunemm.com', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4780, 135372, 'Eyeota Pte Ltd', 'eyeota.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4781, 135373, 'EFLY NETWORK LIMITED', 'efly.cc', 'HK', 12544, 'isp', '0000-00-00 00:00:00', 0),
(4782, 135375, 'Today Communication Co.,Ltd', 'today.com.kh', 'KH', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4783, 135376, 'Rahanet Internet Service Provider', 'rahanet.af', 'AF', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4784, 135377, 'UCloud (HK) Holdings Group Limited', 'ucloud.cn', 'HK', 89344, 'hosting', '0000-00-00 00:00:00', 0),
(4785, 135381, 'SiS Distribution (Thailand) Public Company Limited descr: (@Genesis Data Center)', 'violin.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(4786, 135384, 'Khyber Internet Services Provider Pvt. Ltd.', 'khyber.net.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(4787, 135385, 'Gough Group Limited', 'goughgroup.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4788, 135386, 'LinkChina Telecom Global Limited.', 'linkchina.hk', 'HK', 20480, 'hosting', '0000-00-00 00:00:00', 0),
(4789, 135387, 'Magna Hosting Ltd', 'magnahosting.net', 'TW', 3840, 'hosting', '0000-00-00 00:00:00', 0),
(4790, 13539, 'Bastyr University', 'bastyr.edu', 'US', 256, 'education', '2017-08-09 00:00:00', 0),
(4791, 135391, 'AOFEI DATA INTERNATIONAL COMPANY LIMITED', 'qq.com', 'HK', 29440, 'hosting', '0000-00-00 00:00:00', 0),
(4792, 135393, 'Kiwi VoIP', 'kiwivoip.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(4793, 135396, 'TAFE Queensland', 'tafeqld.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(4794, 135397, 'Cigniti Technologies Limited', 'cigniti.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4795, 135398, 'E-Tech Media Company Data Centre', 'asiaone.net', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(4796, 135399, 'Blackmores Ltd', 'blackmores.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4797, 13540, 'Liberty Mutual Group', 'libertymutual.com', 'US', 24320, 'business', '2019-02-22 00:00:00', 0),
(4798, 135400, 'Contact Energy Limited', 'contact-energy.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4799, 135401, 'SAP', 'sap.com', 'JP', 5632, 'business', '0000-00-00 00:00:00', 0),
(4800, 135404, 'THE WATCH TOWER BIBLE AND TRACT SOCIETY OF INDIA', 'jw.org', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4801, 135405, 'WELINK', 'None', 'MM', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(4802, 135406, 'BCD NETWORKS PTY LTD', 'bcdnetworks.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4803, 135407, 'Trans World Enterprise Services (Private) Limited', 'transworld-home.com', 'PK', 5376, 'isp', '0000-00-00 00:00:00', 0),
(4804, 135408, 'Hammer Technologies Pty Ltd', 'hammertech.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4805, 135409, 'Kacific Broadband Satellites Pte Ltd', 'kacific.com', 'SG', 18176, 'isp', '0000-00-00 00:00:00', 0),
(4806, 13541, 'Mentor Graphics Corporation', 'mentor.com', 'US', 198656, 'business', '1999-09-09 00:00:00', 0),
(4807, 135411, 'Red Grapes Pte Ltd', 'ssd-tech.com', 'SG', 512, 'isp', '0000-00-00 00:00:00', 0),
(4808, 135412, 'Singapore Network Information Centre', 'sgnic.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(4809, 135413, 'SSTN Technology', 'sstntechnology.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4810, 135415, 'RACQ Operations Pty Ltd', 'racq.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4811, 135416, 'Confidence Electric Ltd.', 'confidencegroup.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4812, 135418, 'Tee Lee Telehub Pte Ltd', 'telehub.com.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4813, 135419, 'Cableconnect Co.,Ltd', 'cableconnect.co.th', 'TH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4814, 13542, 'Fiserv, Inc.', 'fiserv.com', 'US', 256, 'business', '2012-11-28 00:00:00', 0),
(4815, 135420, 'Media Online', 'mediaonlinebd.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4816, 135421, 'SALKELD, MATTHEW T/A MATTHEW SALKELD CONSULTING', 'salkeld.org', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4817, 135422, 'SHASS INFORMATION & QUALITY ENGINEERING SERVICES PVT LTD', 'siqes.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(4818, 135423, 'Total Information Management Corporation', 'timcorp.net.ph', 'PH', 3072, 'business', '0000-00-00 00:00:00', 0),
(4819, 135424, 'Electronic Arts Inc. for KR', 'ea.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(4820, 135425, 'Caznet', 'caznet.com.au', 'AU', 3840, 'business', '0000-00-00 00:00:00', 0),
(4821, 135427, 'Myanmar Network Company Limited', 'myanmarnetwork.com.mm', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4822, 135428, 'Fire and Emergency New Zealand', 'fireandemergency.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4823, 13543, 'City of Cookeville', 'cookeville-tn.org', 'US', 1024, 'business', '2014-02-06 00:00:00', 0),
(4824, 135433, 'KBZ Gateway Company Ltd', 'kbzgateway.com', 'MM', 2048, 'business', '0000-00-00 00:00:00', 0),
(4825, 135437, 'New Generation Internet Services Limited', 'ngisl.net', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4826, 135438, 'MD SOFT TECHNOLOGY', 'mdsoftisp.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4827, 135439, 'PT ADNET MEDIA INDONESIA', 'adnetmedia.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4828, 135440, 'PELABUHAN INDONESIA IV', 'inaport4.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4829, 135441, 'PT. FASA CENTRA ARTAJAYA', 'fasapay.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4830, 135442, 'PT. ASDP INDONESIAFERRY (PERSERO)', 'indonesiaferry.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4831, 135444, 'PT Ikubaru Indonesia', 'ikubaru.co.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(4832, 135445, 'PT. Airpay International Indonesia', 'airpay.co.id', 'ID', 2304, 'business', '0000-00-00 00:00:00', 0),
(4833, 135446, 'PT Sumber Cipta Multiniaga', 'sumbercipta.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4834, 135447, 'PT. Bank Mega Tbk', 'bankmega.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4835, 135448, 'PT Bukalapak.com', 'bukalapak.com', 'ID', 4096, 'business', '0000-00-00 00:00:00', 0),
(4836, 135449, 'PT. Broadband Indonesia Pratama', 'bipnet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4837, 13545, 'Matthews International Capital Management, LLC', 'matthewsasia.com', 'US', 256, 'business', '2014-02-04 00:00:00', 0),
(4838, 135450, 'PT Berkah Solusi Teknologi Informasi', 'ptbsti.com', 'ID', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(4839, 135451, 'PT Media Alvina Sejati', 'mas.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4840, 135454, 'AXA Tech Indonesia', 'axa-tech.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4841, 135455, 'YAYASAN BADAN PENDIDIKAN KRISTEN PENABUR (YBPK)', 'bhomert.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4842, 135456, 'Kementerian Koperasi dan Usaha Kecil dan Menengah RI', 'depkop.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4843, 135457, 'BADAN SIBER DAN SANDI NEGARA (BSSN)', 'lemsaneg.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4844, 135459, 'PT.GLOBALRIAU DATA SOLUSI', 'ardatama.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4845, 13546, 'Innovative Interfaces, Inc.', 'iii.com', 'US', 1792, 'business', '2005-09-23 00:00:00', 0),
(4846, 135460, 'THE HONGKONG AND SHANGHAI BANKING CORPORATION LIMITED', 'hsbc.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4847, 135461, 'PT Pelabuhan Indonesia I (Persero)', 'pelindo1.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4848, 135462, 'PT Shopee International Indonesia', 'garena.com', 'ID', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4849, 135463, 'PDE Setda Kabupaten Sukoharjo', 'sukoharjokab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4850, 135464, 'Winet Media Persada', 'winetmedia.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4851, 135465, 'PT BINA TECHINDO SOLUTION', 'bts.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4852, 135466, 'PT Phinisi Global Data', 'phinisidata.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4853, 135467, 'PT. Bank Bukopin, Tbk', 'bukopin.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4854, 135468, 'PT. Wahana Internet Nusantara', 'bnet.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4855, 135469, 'Dinas Komunikasi, Informatika dan Statistik Provinsi Gorontalo', 'gorontaloprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4856, 13547, 'Porter Hospital', 'porterhealth.com', 'US', 256, 'business', '2007-06-06 00:00:00', 0),
(4857, 135471, 'PEMERINTAH KABUPATEN BOYOLALI', 'boyolali.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4858, 135472, 'Dinas Kominfo Kabupaten Sleman', 'slemankab.go.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(4859, 135473, 'BPJS Ketenagakerjaan', 'bpjsketenagakerjaan.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(4860, 135474, 'PT Hafiz Jaya Infotama', 'fiz.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4861, 135475, 'Pemerintah Kabupaten Banyuasin', 'banyuasinkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4862, 135476, 'PT. Bank Tabungan Pensiunan Nasional Tbk', 'btpn.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4863, 135477, 'PT. Java Digital Nusantara', 'nusantara.net.id', 'ID', 2304, 'isp', '0000-00-00 00:00:00', 0),
(4864, 135478, 'PT. Cyberindo Aditama', 'cbn.net.id', 'ID', 25600, 'isp', '0000-00-00 00:00:00', 0),
(4865, 135479, 'PT. XIRKA DAMA PERSADA', 'dnet.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4866, 13548, 'College of Charleston', 'cofc.edu', 'US', 65536, 'education', '2007-06-06 00:00:00', 0),
(4867, 135480, 'PT. Arjuna Global Teknologi Indonesia', 'agti.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4868, 135481, 'Universitas Negeri Makassar', 'unm.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4869, 135482, 'Yayasan Pendidikan Universitas Presiden', 'president.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(4870, 135483, 'PT. WISESA CONSULTING INDONESIA', 'wisesa-consulting.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4871, 135484, 'PT. Bentang Selaras Teknologi', 'best.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4872, 135485, 'PEMERINTAH KOTA KEDIRI', 'kedirikota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4873, 135487, 'UNTAR - YAYASAN TARUMANAGARA', 'tarumanagarafoundation.org', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(4874, 135488, 'PT OTHMAR MATRA MEDIA', 'othmarnetwork.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(4875, 135489, 'FENGYE NETWORKS LIMITED', 'fyzhuji.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(4876, 13549, 'Mercury Network Corporation', 'mercury.net', 'US', 16384, 'business', '1999-09-13 00:00:00', 0),
(4877, 135490, 'Business Automation Ltd.', 'batworld.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4878, 135494, 'Md. Shuzanur Rahman t/a Karsan Net', 'karsannet.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(4879, 135495, 'MYOB NZ Limited', 'myob.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4880, 135496, 'UNIVERSITI KEBANGSAAN MALAYSIA', 'ukm.my', 'MY', 768, 'education', '0000-00-00 00:00:00', 0),
(4881, 135497, 'Kinetic IT Pty. Ltd.', 'kineticit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4882, 135499, 'A truly world-class casino resort comes to Manila!', 'okadamanila.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4883, 1355, 'AbelsonTaylor, Inc.', 'abelsontaylor.com', 'US', 512, 'business', '2017-08-01 00:00:00', 0),
(4884, 135500, 'R Systems International Limited', 'rsystems.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4885, 135511, 'Cyberworld Tower', 'csloxinfo.net', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4886, 135512, 'BIZ-LYNX Technology Pty Ltd', 'biz-lynx.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4887, 135513, 'Spirit Telecom (Australia) Pty Ltd', 'voxcom.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(4888, 135514, 'United Technologies Corporation', 'utc.com', 'US', 768, 'business', '0000-00-00 00:00:00', 0),
(4889, 135516, 'Now IT Solutions Ply Ltd', 'nowitsolutions.com.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(4890, 135517, 'Pandora Technology', 'pandora.net', 'BD', 1792, 'isp', '0000-00-00 00:00:00', 0),
(4891, 13552, 'Cegep de Sainte-Foy', 'cegep-ste-foy.qc.ca', 'CA', 2048, 'business', '2008-12-08 00:00:00', 0),
(4892, 135520, 'SATAC Incorporated', 'satac.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(4893, 135521, 'ROBERT BOSCH (SOUTH EAST ASIA) PTE. LTD.', 'bosch-iot-cloud.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4894, 135523, 'Multinet Broadband', 'multinet.com.pk', 'PK', 5888, 'isp', '0000-00-00 00:00:00', 0),
(4895, 135524, 'university of dhaka', 'univdhaka.edu', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(4896, 135526, 'KM Holdings Pty Ltd', 'kordamentha.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4897, 135527, 'Kazi Mohammad Shoabe T/A Explore Online', 'exploreonlinebd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4898, 135528, 'Muban Chombueng Rajabhat University', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(4899, 135529, 'FPT MYANMAR COMPANY LIMITED', 'fpt.com.vn', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4900, 135530, 'Acronis Asia Pte. Ltd', 'acronis.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(4901, 135531, 'Global Integrated Communications Pte Ltd', 'gi-comms.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(4902, 13554, 'Tenaska Power Services, Co.', 'tenaska.com', 'US', 512, 'business', '2006-04-10 00:00:00', 0),
(4903, 135542, 'LIGHT CLOUD TECHNOLOGY', 'lightcloud.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(4904, 135543, 'Network Dynamics Pty Ltd', 'networkdynamics.com.au', 'AU', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(4905, 135545, 'Toshiba (Australia) Pty Ltd', 'toshiba.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4906, 135548, 'Hedgeserv (Australia) Pty. Ltd.', 'hedgeserv.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4907, 135549, 'NEW WORLD CATV, INC.', 'newworldcabletv.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(4908, 13555, 'Zayo Bandwidth', 'zayobandwidth.com', 'US', 10752, 'isp', '1999-09-13 00:00:00', 0),
(4909, 135551, 'Malaysian Communication and Multimedia Commission', 'cmc.gov.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(4910, 135552, 'Shinetown Telecommunication Limited', 'shinetown.com.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(4911, 135553, 'VC Telecoms Sdn. Bhd.', 'vcsb.com.my', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(4912, 135554, 'Link Line', 'linkline.xyz', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(4913, 135555, 'City Communications PTY LTD', 'citycomms.com.au', 'AU', 768, 'isp', '0000-00-00 00:00:00', 0),
(4914, 135556, 'Metrabyte One Company Limited', 'metrabyteone.co.th', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(4915, 135557, 'Seven Hills Cloud Technology Private Limited', '7hillscloud.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4916, 135559, 'ONiYN Pty Ltd', 'oniyn.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4917, 13556, 'IBASIS INC.', 'ibasis.com', 'US', 256, 'isp', '1999-09-13 00:00:00', 0),
(4918, 135562, 'Nevigate Global Network (Hong Kong) Limited', 'nevigate.net', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(4919, 135563, 'A&A DUKAAN FINANCIAL SERVICES PRIVATE LIMITED', 'bankbazaar.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4920, 135564, 'iPay Systems Ltd.', 'ipay.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4921, 135569, 'NTT Data Global Delivery Services Private Limited', 'nttdata.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4922, 13557, 'NetIn.com, Inc. Dallas Texas US', 'netin.com', 'US', 4096, 'business', '1999-09-13 00:00:00', 0),
(4923, 135572, 'ACT International Telecom Limited', 'actwan.net', 'HK', 3328, 'business', '0000-00-00 00:00:00', 0),
(4924, 135573, 'mediatti broadband communications', 'mediattimail.net', 'JP', 24576, 'isp', '0000-00-00 00:00:00', 0),
(4925, 135577, 'SAP', 'sap.com', 'CN', 3840, 'business', '0000-00-00 00:00:00', 0),
(4926, 135578, 'Muhammad Nasir t/a Dhaka Information Technology', 'ditbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(4927, 13558, 'Church Mutual Insurance Company', 'churchmutual.com', 'US', 256, 'business', '2012-10-29 00:00:00', 0),
(4928, 135581, 'ONL-HK', 'yyw818.com', 'HK', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(4929, 135582, 'Galaxy Cable Corp.', 'galaxycable.com.ph', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4930, 135583, 'ip2me Hosted Services', 'ip2me.com.au', 'AU', 512, 'hosting', '0000-00-00 00:00:00', 0),
(4931, 135584, 'Perfetti Van Melle Bangladesh Private Limited', 'pvmgrp.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(4932, 135585, 'Credit Corp Group Limited', 'creditcorp.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4933, 135586, 'INTERLINK COMMUNICATION PCL.', 'interlink.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(4934, 135588, 'Rajamangala University of Technology Tawan-ok (Chakrabongse Bhuvanarth Campus)', 'rit.ac.th', 'TH', 1024, 'education', '0000-00-00 00:00:00', 0),
(4935, 135590, 'Md. Aminur Rahman Khan T/A Seba Net', 'sebanetbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4936, 135592, 'Spectrum Brands, Inc.', 'spectrumbrands.com', 'US', 512, 'business', '0000-00-00 00:00:00', 0),
(4937, 135594, 'Kabayan Cable Tv Systems Inc.', 'kabayancablegroup.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(4938, 135595, 'SIRO Clinpharm Pvt. Ltd.', 'siroclinpharm.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4939, 135596, 'Hans Online Services', 'r8.com.tw', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4940, 135600, 'Whiz Communications Pte Ltd', 'whizcomms.com.sg', 'SG', 17920, 'isp', '0000-00-00 00:00:00', 0),
(4941, 135601, 'Tourism Australia', 'australia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4942, 135602, 'Wowway Labs Private Limited', 'findyogi.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(4943, 135604, 'Sharmin Akter Shilpi t/a M/S. Saiba International', 'saibabd.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4944, 135606, 'Warp Speed Computers Limited', 'warp.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(4945, 135607, 'Infinivan Incorporated', 'infinivan.com', 'PH', 13568, 'isp', '0000-00-00 00:00:00', 0),
(4946, 13561, 'Lafarge Canada Inc.', 'lafargenorthamerica.com', 'CA', 256, 'business', '2007-03-09 00:00:00', 0),
(4947, 135612, 'Hydro-Electric Corporation', 'hydro.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4948, 135615, 'D-NET SERVICE', 'None', 'BD', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(4949, 135617, 'Phuket Marriott Resort & Spa, Merlin Beach', 'uih.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(4950, 135620, '69 Praksa, Maueng, Samukprakarn,', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(4951, 135621, 'PCCW IMS Ltd (PCCW Business Internet Access)', 'pccw.com', 'HK', 256, 'isp', '0000-00-00 00:00:00', 0),
(4952, 135625, 'Fuji Xerox Australia Pty Ltd', 'fujixerox.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4953, 135626, 'Electra Limited', 'electra.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4954, 135627, 'Silverlining Networks Pty Ltd', 'silverliningnetworks.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4955, 135628, 'PC-Net', 'pcnetinc.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(4956, 135629, 'Ningxia West Cloud Data Technology Co.Ltd.', 'westcloudvalley.com', 'CN', 206336, 'isp', '0000-00-00 00:00:00', 0),
(4957, 135632, 'Cactus Network Solutions (CNS) Pvt Ltd', 'cactuspk.com', 'PK', 2048, 'business', '0000-00-00 00:00:00', 0),
(4958, 135634, 'Task Retail Technology Pty Ltd', 'taskretail.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4959, 135635, 'Tourism authority of Thailand', 'tourismthailand.org', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(4960, 135636, 'Rackh Lintas Asia, pt', 'rackh.co.id', 'ID', 2304, 'business', '0000-00-00 00:00:00', 0),
(4961, 135637, 'Haseeb Istiaqur Rahman t/a Professionals\' Systems', 'professionals.com.bd', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4962, 135639, 'John Holland PTY LTD', 'johnholland.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4963, 135642, 'VetNZ Limited', 'vetsouth.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(4964, 135643, 'Automated Technologies Inc', 'atiph.net', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(4965, 135644, 'Caspar Technologies', 'icubespro.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4966, 135645, 'Sureste Properties, Inc.', 'solairemanila.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(4967, 135646, 'Luginbash AS', 'lug.sh', 'US', 768, 'business', '0000-00-00 00:00:00', 0),
(4968, 135647, 'Airports Fiji Limited', 'afl.com.fj', 'FJ', 512, 'business', '0000-00-00 00:00:00', 0),
(4969, 13565, 'THE ORVIS COMPANY, INC.', 'orvis.com', 'US', 512, 'business', '1999-07-01 00:00:00', 0),
(4970, 135652, 'SONET GLOBAL TECHNOLOGY LIMITED', 'sonetglobal.net', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(4971, 135653, 'URSYS PTY. LTD.', 'ursys.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4972, 135654, 'Internet @ Home Limited', 'internetathome.net', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(4973, 135655, 'ERM Power Limited', 'ermpower.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4974, 13566, 'Upper Columbia Conference / SDA', 'uccsda.org', 'US', 512, 'business', '2018-04-19 00:00:00', 0),
(4975, 135661, 'Superior Connections private limited', 'scpl.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(4976, 135662, 'DELOITTE SERVICES PTY LTD', 'deloitte.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(4977, 135664, 'GLOBAL CLOUD EXCHANGE Co., Ltd.', 'neocomisp.com', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4978, 135666, 'Government Data Center (DITT/MoIC)', 'dit.gov.bt', 'BT', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4979, 135668, 'Patrick Stevedores Operations Pty Ltd', 'patrick.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4980, 13567, 'Kimberly-Clark Corporation', 'kcc.com', 'US', 74240, 'business', '1999-07-02 00:00:00', 0),
(4981, 135670, 'Thai Insurers Datanet Co., Ltd.', 'insure.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(4982, 135672, 'GRANGE RESOURCES (TASMANIA) PTY LTD', 'grangeresources.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(4983, 135673, 'Future.Net', 'None', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4984, 135675, 'Queensland Local Government Superannuation Board', 'lgiasuper.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(4985, 135676, 'Anwar Ahmed t/a W W W Computer', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4986, 135678, 'Airnet Broadband', 'myairnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4987, 135679, 'Suncity Broadband Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4988, 135681, 'Indian Commodity Exchange Ltd.', 'icexindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(4989, 135682, 'Advika Web Developments Hosting Pvt Ltd', 'awdhpl.com', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4990, 135683, 'Netncr Technology Pvt. Ltd.', 'netncr.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4991, 135685, 'INET FIBER PVT LTD', 'inetfiber.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(4992, 135686, 'Navyug Networks Info Private Limited', 'navyug.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(4993, 135688, 'Best IT Centre', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(4994, 135690, 'Shineplus Networks Private Limited', 'shineplusnetworks.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(4995, 135691, 'Cloudlasers Broadband', 'cloudlasers.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(4996, 135692, 'Global Ra Net Services Pvt. Ltd.', 'globalnet.online', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(4997, 135693, 'Touchnet Broadband Services Pvt. Ltd.', 'None', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(4998, 135695, 'Babel Media India Pvt. Ltd.', 'babelmedia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(4999, 135696, 'Winet Infratel Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5000, 135697, 'Tachyon Communications Pvt Ltd', 'mytachyon.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5001, 135699, 'Stn Infotech Pvt. Ltd.', 'irinn.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5002, 13570, 'Angelo, Gordon & Co., L.P.', 'angelogordon.com', 'US', 512, 'business', '2017-07-21 00:00:00', 0),
(5003, 135700, 'N R DATA SERVICE PVT LTD', 'None', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(5004, 135702, 'Atri Networks And Media Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5005, 135703, 'Aspire Broadband Private Limited', 'aspirebroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5006, 135705, 'Nas Broadband Pvt Ltd', 'nas.net.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5007, 135706, 'Ddc Broadband Pvt. Ltd.', 'ddcbroadband.com', 'IN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(5008, 135709, 'Ismantak Internet Services Pvt Ltd.', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5009, 135712, 'Euron Communications Pvt. Ltd.', 'euronetinfoocm.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5010, 135715, 'INet Services Pvt Ltd', 'inet-svr.net', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5011, 135716, 'Sat International Private Limited', 'sat.org.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5012, 135717, 'Cheree Infomedia Pvt. Ltd', 'chereeinfomedia.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5013, 135718, 'DISHAWAVES INFONET PVT. LTD', 'dishawaves.com', 'IN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(5014, 135719, 'Lm Energy And Software Private Limited', 'lmes.co.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5015, 13572, 'Lahey Clinic, Inc.', 'lahey.org', 'US', 4096, 'business', '2005-11-01 00:00:00', 0),
(5016, 135721, 'Network', 'networklimited.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5017, 135722, 'Teleglobal Communications Pvt Ltd', 'teleglobal.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5018, 135723, 'Prime Fibernet', 'primefiber.net', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5019, 135724, 'Allnet Broadband Network Pvt Ltd', 'allnet.co.in', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(5020, 135725, 'Navin Internet Services Pvt. Ltd.', 'navninternetservices.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5021, 135726, 'Vsj Internet Services Private Limited', 'vsjbroadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5022, 135727, 'ASPL Infoservices', 'asplinfoservices.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5023, 135728, 'Datagram Network India Pvt. Ltd.', 'datagram.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5024, 135729, 'Digital Telco Network India Pvt. Ltd.', 'dtnindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5025, 135730, 'Datta Meghe Institute Of Medical Sciences', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5026, 135732, 'United Bank Of India', 'unitedbankofindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5027, 135733, 'SPEARHEAD LIFESTYLE INDIA PRIVATE LIMITED', 'spearheadtelecom.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5028, 135735, 'Vilite Multimedia Private Limited', 'vilite.com', 'IN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(5029, 135737, 'Ekdant Communication Pvt Ltd', 'webridersinternet.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5030, 135738, 'Adn Broadband', 'adnbroadband.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5031, 135739, 'Inetwork Solutions Pvt Ltd', 'inetwork.solutions', 'IN', 4608, 'isp', '0000-00-00 00:00:00', 0),
(5032, 135740, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 256, 'business', '2006-11-29 00:00:00', 0),
(5033, 135743, 'Maxx1 Infoway Pvt Ltd', 'maxx1networks.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5034, 135744, 'SHREE BALAJI INFOWAY PRIVATE LIMITED', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5035, 135746, 'Cityline Networks Pvt Ltd', 'citylinenetworks.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5036, 135748, 'Radiant Network Technologies Pvt Ltd', 'radiantnetwork.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5037, 13575, 'Wisconsin Public Power, Inc.', 'wppisys.org', 'US', 256, 'business', '2005-11-01 00:00:00', 0),
(5038, 135750, 'Railtel Enterprise Limited', 'relindia.in', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(5039, 135751, 'Enstage Software Private Limited', 'wibmo.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5040, 135752, 'Evoke Digital Solutions', 'evokedigital.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5041, 135753, 'Airmax Internet Private Limited', 'airmaxnetwork.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5042, 135754, 'Golden Tiger Telecom Pvt Ltd', 'gttpl.com', 'IN', 1792, 'business', '0000-00-00 00:00:00', 0),
(5043, 135755, 'Fiberlink Communication Pvt. Ltd.', 'giftfiber.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5044, 135756, 'Vps Broadband And Telecommunications Pvt Ltd', 'skybbservices.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5045, 135757, 'Larsen and Toubro Limited, Constrcution', 'lntecc.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5046, 135758, 'Alacriy Net System Service Private Limited', 'alacriynetsystem.net', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(5047, 13576, 'SOUTH DAKOTA NETWORK', 'lakotanetwork.com', 'US', 131584, 'isp', '1999-07-08 00:00:00', 0),
(5048, 135760, 'Speednet Unique Network Pvt Ltd', 'speednetkolkata.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(5049, 135761, 'Userlinks Netcom Pvt. Ltd.', 'unpl.co.in', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5050, 135762, 'Clear Beam Communications Pvt. Ltd.', 'clearbeam.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5051, 135763, 'GAYATRI COMMUNICATIONS', 'gayatricommunication.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5052, 135764, 'National Dairy Development Board', 'nddb.org', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5053, 135766, 'Wandoor Multiventures Pvt Ltd', 'wandoor.co.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5054, 135767, 'AGS Transact Technologies Ltd', 'agsindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5055, 135768, 'Creative Broadband Services Pvt. Ltd.', 'creativebroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5056, 135769, 'Isro Satellite Centre', 'isac.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5057, 13577, 'LIVEOPS, INC.', 'liveops.com', 'US', 512, 'business', '2006-10-24 00:00:00', 0),
(5058, 135772, 'Powernet Communications Pvt.Ltd.', 'pcpli.com', 'IN', 5632, 'isp', '0000-00-00 00:00:00', 0),
(5059, 135773, 'Daksh Broadband Services Pvt Ltd', 'dakshbroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5060, 135774, 'Priya Infotechnology', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5061, 135775, 'Proline Datatech Services Pvt. Ltd.', 'vsnl.net', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(5062, 135776, 'Inxssinfo mkrt ser pvt ltd.', 'fahnet.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5063, 135777, 'Shreenortheast Connect And Services Pvt Ltd', 'neconnect.in', 'IN', 4864, 'isp', '0000-00-00 00:00:00', 0),
(5064, 135778, 'Wi-link Network Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5065, 135779, 'OASISGSSERVICES', 'oasisgsservices.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5066, 13578, 'MDAssociates, Inc.', 'mda.cloud', 'US', 2048, 'business', '2006-09-28 00:00:00', 0),
(5067, 135780, 'AirFiber Networks Pvt Ltd', 'airfiber.co.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5068, 135781, 'Vibhuti Networks Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5069, 135782, 'Nyak Technologies And Teleservices Pvt Ltd', 'n-tel.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5070, 135783, 'Comex Computer Pvt Ltd', 'comexcomputer.org', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5071, 135786, 'Guru Netcom Pvt Ltd', 'gurugroup.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5072, 135787, 'Technova Imaging Systems P Limited', 'technovaindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5073, 135788, 'Vedant Broadband', 'vedantbroadband.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5074, 135789, 'Denet Connect Services Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5075, 13579, 'INFOTEC Centro de Investigacion e Innovacion en Tecnologias de la Informacion y Comunicación', 'infotec.mx', 'MX', 133376, 'isp', '1999-07-08 00:00:00', 0),
(5076, 135791, 'Phonepe Private Limited', 'phonepe.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5077, 135792, 'Syswall Telecom Pvt. Ltd.', 'syswall.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5078, 135793, 'Alphanet Broadband Private Limited', 'alphanetbroadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5079, 135794, 'Route Mobile Limited', 'routemobile.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5080, 135795, 'Silicon Care Broadnet Pvt Ltd.', 'siliconcare.in', 'IN', 4352, 'isp', '0000-00-00 00:00:00', 0),
(5081, 135796, 'Worldnet Internet And Service Provider Private Limited', 'worldnetinternet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5082, 135797, 'Simsys Infotech Pvt. Ltd.', 'simsys.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5083, 135798, 'Crest Premedia Solutions Pvt. Ltd.', 'springernature.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5084, 1358, 'Hughes Network Systems, Inc.', 'hughes.com', 'US', 64768, 'isp', '1991-09-30 00:00:00', 0),
(5085, 13580, 'Southern Network Services, L.L.C.', 'southwan.com', 'US', 256, 'business', '2017-09-08 00:00:00', 0),
(5086, 135801, 'C32 Broadband Pvt. Ltd.', 'c32broadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5087, 135802, 'Swastik Network Solution', 'sarvadanet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5088, 135804, 'Johnson Telemarketers (P) LTD', 'jtel.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5089, 135805, 'Skp Business Consulting Llp', 'skpgroup.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5090, 135808, 'Fiberzone Communications Pvt Ltd', 'fiberzone.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5091, 135809, 'Sanjeevan Networks Services Pvt Ltd', 'mysanjeevan.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5092, 13581, 'SHI International Corp.', 'shi.com', 'US', 1536, 'business', '1999-07-08 00:00:00', 0),
(5093, 135810, 'Srk Network', 'speedglobal.co.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5094, 135811, 'Speedcom Internet Services Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5095, 135812, 'Agnity India Technologies Pvt. Ltd', 'agnity.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5096, 135813, 'Cirrostratus Networks Private Limited', 'rushme.space', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5097, 135814, 'Extreme Group', 'extreme-ix.org', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5098, 135815, 'Netrexo Communications Private Limited', 'netrexo.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5099, 135816, 'Netbiz Systems Pvt. Ltd.', 'netbiz.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5100, 135817, 'Esto Broadband Private Limited', 'estobroadband.in', 'IN', 8704, 'isp', '0000-00-00 00:00:00', 0),
(5101, 135818, 'Green Tech Net Com Pvt Ltd', 'gtncpl.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5102, 135820, 'S.k.netsol Pvt Ltd', 'sknetsol.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5103, 135821, 'Sonic Wireless Technologies', 'sonicindia.net', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5104, 135824, 'Gelexiy Cab Net', 'gelexiycabnet.net', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(5105, 135825, 'Pradeep Broadcast Private Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5106, 135826, 'Syntego Technologies India Private Limited', 'syntegotechnologies.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5107, 135828, 'Rbs Services India Private Limited', 'rbs.co.uk', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5108, 13583, 'ACCESS-TECHNOLOGY', 'access-k12.org', 'None', 256, 'business', '2008-09-29 00:00:00', 0),
(5109, 135831, 'Malang Solutions Pvt. Ltd.', 'malang.net.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5110, 135832, 'Mando Softtech India Pvt. Ltd.', 'halla.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5111, 135833, 'Rbs Services India Private Limited', 'rbs.co.uk', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5112, 135834, 'Multicraft Digital Technologies Private Limited', 'multicraft.in', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(5113, 135835, 'Sardar Vallabhbhai Patel National Police Academy', 'svpnpa.gov.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(5114, 135837, 'Arihant Communications', 'arihant-communications.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5115, 135839, 'Optical Broadband Communication Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5116, 135840, 'Zenmonics Software Pvt Ltd', 'zenmonics.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5117, 135841, 'Enhancelink Coreport Private Limited', 'wellmark.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5118, 135842, 'Dheera Net Services Pvt. Ltd.', 'dheeranet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5119, 135844, 'Lightyears Broadband Pvt Ltd', 'lightyearsbroadband.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(5120, 135845, 'Krishiinet Infocom Private Limited', 'krishiinet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5121, 135846, 'Joister Infomedia Pvt Ltd.', 'joister.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5122, 135847, 'Ioeaccess Communications Private Limited', 'accessioe.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5123, 135848, 'Digitax India Communications Pvt Ltd.', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5124, 135849, 'Clicknet Communication Pvt. Ltd.', 'clicknetcommunication.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5125, 13585, 'Power VT S.A.', 'powervt.com.ar', 'AR', 23808, 'isp', '1999-07-11 00:00:00', 0),
(5126, 135850, 'Net Sathi Networks Pvt. Ltd', 'netsathi.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5127, 135851, 'Excogitate Technologies Pvt Ltd', 'excogitatesoftware.com', 'IN', 1280, 'business', '0000-00-00 00:00:00', 0),
(5128, 135852, 'Galaxynet Connections Private Limited', 'galaxynet.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5129, 135853, 'Cyber Crazy', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5130, 135854, 'Ruhban Telecommunication Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5131, 135855, 'Applesoft Technologies', 'None', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5132, 135857, 'Espire Infolabs Pvt. Ltd.', 'espire.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5133, 135858, 'Visa Consolidated Support Services India Private Limited', 'visa.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5134, 135859, 'Realwire Express Network Private Limited', 'realwire.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5135, 135860, 'New Delhi Municipal Council', 'ndmc.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5136, 135861, 'Explore World Infranet Pvt Ltd', 'exploreworldinfranet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5137, 135862, 'IRG WIFI Service Pvt. Ltd.', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(5138, 135863, 'Catla IT and Engg.Co.Pvt.Ltd.', 'catlabroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5139, 135865, 'Goairnet Wireless Broadband Pvt. Ltd', 'goairnet.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5140, 135866, 'Lucky Airnet Pvt Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5141, 135868, 'A.b. Infotech', 'abinfotech.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5142, 135871, 'Ernst And Young Services Private Limited', 'ey.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5143, 135872, 'GTPL KCBPL BROADBAND PVT LTD', 'gtplkcbpl.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(5144, 135873, 'Jmd Internet And Services Pvt Ltd', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5145, 135874, 'Mlcinternet Pvt Ltd', 'mlcinternet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5146, 135875, 'Tiruppur Broadwave Private Limited', 'jvgcomputer.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5147, 135876, 'AT Broadband Pvt Ltd', 'atbroadband.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5148, 135877, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 512, 'business', '2006-11-29 00:00:00', 0),
(5149, 135878, 'MRY PTY LTD t/a Binary Elements', 'binaryelements.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5150, 135879, 'Hyundai Motor Company Australia Pty Ltd', 'hyundai.com.au', 'AU', 4096, 'business', '0000-00-00 00:00:00', 0),
(5151, 13588, 'Paychex Incorporated', 'paychex.com', 'US', 24576, 'business', '1999-07-12 00:00:00', 0),
(5152, 135880, 'Department of Culture and the Arts', 'slwa.wa.gov.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(5153, 135881, 'Md Abul Kashem t/a Spark Net', 'sparknetbd.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5154, 135882, 'Spark Online', 'sparkonlinebd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5155, 135884, 'MAGNET BRAINS SOFTWARE TECHNOLOGY PRIVATE LIMITED', 'formget.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5156, 135887, 'Telstra Corporation', 'telstra.com.au', 'AU', 458752, 'isp', '0000-00-00 00:00:00', 0),
(5157, 135888, 'Ordnance Networks Pty Ltd', 'ordnance.co', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5158, 135889, 'Virtual Bridge Limited', 'vbridge.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(5159, 135890, 'MLC LIMITED', 'mlcinsurance.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5160, 135892, 'Mentone Girls Grammar School', 'mentonegirls.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5161, 135893, 'La Trobe University', 'latrobe.edu.au', 'AU', 131328, 'education', '0000-00-00 00:00:00', 0),
(5162, 135894, 'SAGE SOFTWARE AUSTRALIA PTY LTD', 'sage.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5163, 135895, 'Centorrino Technologies Pty Ltd', 'ct.com.au', 'AU', 2304, 'business', '0000-00-00 00:00:00', 0),
(5164, 135897, 'MetLife Insurance Limited', 'metlife.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5165, 135898, 'Universal Communications Group Limited', 'ucg.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5166, 13590, 'Marcus Daly Memorial Hospital Corporation', 'mdmh.org', 'US', 256, 'business', '2017-08-14 00:00:00', 0),
(5167, 135900, 'HaNoi State data center', 'hanoi.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5168, 135902, 'Hahalolo Travel Social Network Joint Stock Company', 'hahalolo.com', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5169, 135904, 'VINID PAY JOINT STOCK COMPANY', 'vinid.net', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5170, 135905, 'VIETNAM POSTS AND TELECOMMUNICATIONS GROUP', 'vnpt.com.vn', 'VN', 54016, 'hosting', '0000-00-00 00:00:00', 0),
(5171, 135908, 'ECONET VIETNAM CORPORATION', 'econet.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5172, 135909, 'Information Technology Park - Vietnam National University Ho Chi Minh City', 'vnuhcm.edu.vn', 'VN', 1024, 'education', '0000-00-00 00:00:00', 0),
(5173, 13591, 'Mexico Red de Telecomunicaciones, S. de R.L. de C.V.', 'metrored.com.mx', 'MX', 528640, 'isp', '2001-01-03 00:00:00', 0),
(5174, 135911, 'VietNam maritime commercial joint stock bank', 'msb.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5175, 135912, 'VNETWORK Joint Stock Company', 'vnetwork.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(5176, 135913, 'MB Ages life insurance company limited', 'mbageas.life', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5177, 135915, 'TLSOFT', 'tlsoft.vn', 'VN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(5178, 135916, 'KIENPHONGITS', 'vnnic.vn', 'VN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5179, 135917, 'Cong ty TNHH Web Panda', 'tadu.vn', 'VN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5180, 135918, 'VIET DIGITAL TECHNOLOGY LIABILITY COMPANY', 'isvc.vn', 'VN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(5181, 135919, 'MB SHINSEI Finance Limited Liability Company', 'mcredit.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5182, 13592, 'Sidera Networks LLC', 'sidera.net', 'US', 1536, 'business', '2008-12-18 00:00:00', 0),
(5183, 135920, 'Ehost software company limited', 'ehost.com.vn', 'VN', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(5184, 135921, 'Maxserver Company Limited', 'maxserver.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5185, 135922, 'Clearsky Service Solutions Company Limited', 'clearsky.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5186, 135923, 'SCTV INFRASTRUCTURE BUSINESS INVESMENT COMPANY LIMITED', 'sctv-ibi.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5187, 135924, 'FWD Vietnam Life Insurance Company Limited', 'fwd.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5188, 135925, '16 Au Co, Tan Son Nhi Ward, Tan Phu District, Ho Chi Minh city (EVNSPC Building)', 'evnspc.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5189, 135926, 'Phu Nhuan Jewelry Joint Stock Company', 'pnj.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5190, 135927, 'Phu Quoc Petroleum Operating Company', 'phuquocpoc.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5191, 135929, 'International Education Corporation', 'ishcmc.edu.vn', 'VN', 1024, 'education', '0000-00-00 00:00:00', 0),
(5192, 135932, 'Viet Storage Technology Joint Stock Company', 'vndata.vn', 'VN', 4352, 'hosting', '0000-00-00 00:00:00', 0),
(5193, 135934, 'ICT Center - Dong Thap Department of Information and Communications', 'dongthap.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5194, 135935, 'Binh Minh Software Service Company Limited', 'ved.com.vn', 'VN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5195, 135936, 'LABO A&B Joint Stock Company', 'aipacific.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5196, 135937, 'Next Technology Investment and Development Company Limited', 'nexttech.asia', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5197, 135938, 'Home Credit Viet nam Finance Company Limited', 'homecredit.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5198, 135939, 'VNPT Electronic Payment Joint Stock Company', 'vnptepay.com.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5199, 135940, 'Nice Tech Center Vietnam Limited Company', 'nicevan.co.kr', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5200, 135942, 'Adsota Corporation', 'adsota.com', 'VN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5201, 135943, 'Truong Minh Thinh Online Trading And Service Co., Ltd', 'tmtsofts.com', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5202, 135944, 'VinhNam Commercial informatics service corporation', 'vinacis.com', 'VN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5203, 135945, 'VTC Online Joint Stock Company', 'go.vn', 'VN', 768, 'business', '0000-00-00 00:00:00', 0),
(5204, 135946, 'Long An Department of Information and Communications', 'longan.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5205, 135947, 'Shopee Company Limited', 'ved.com.vn', 'VN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5206, 135949, 'Cloudfone Viet Nam Joint Stock Company', 'cloudfone.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5207, 135951, 'Webico Company Limited', 'tino.org', 'VN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(5208, 135952, 'VPS Securities Joint Stock Company', 'vps.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5209, 135953, 'Vietnam Online Network Solution Joint Stock Compnay', 'bkhost.vn', 'VN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5210, 135955, 'Center Manage electronic information, Lam Dong Department of Information and Communications', 'lamdong.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5211, 135956, 'The Authority of Information Technology - Ministry of Health', 'ehealth.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5212, 135957, 'Thua Thien Hue Electronic Data and Digital Information Center', 'thuathienhue.gov.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5213, 135958, 'Teko Vietnam Technology Joint Stock Company', 'teko.vn', 'VN', 768, 'business', '0000-00-00 00:00:00', 0),
(5214, 135959, 'Onebim Vietnam Limited Company', 'vnnic.vn', 'VN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5215, 13596, 'Rymax Corp', 'rymaxinc.com', 'US', 256, 'business', '2005-11-02 00:00:00', 0),
(5216, 135961, 'Viet Nam Data Online Joint Stock Company', 'vdo.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5217, 135962, 'Dong Duong Securitites Incorporation', 'aisec.com.vn', 'VN', 256, 'business', '0000-00-00 00:00:00', 0),
(5218, 135963, 'Information Center - Ministry of Labour - Invalids and Social Affairs', 'molisa.gov.vn', 'VN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5219, 135964, 'RVC Rong Viet Trade Service Telecom Company Limited', 'rvc.net.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5220, 135967, 'Bach Kim Network solutions Join stock company', 'bkns.vn', 'VN', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(5221, 135969, 'Sen Do Technology Joint Stock Company', 'sendo.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5222, 13597, 'Creative Mobile Solutions, Inc.', 'cmsi.tv', 'US', 512, 'business', '2018-12-21 00:00:00', 0),
(5223, 135970, 'NPS Technology Co., ltd.', 'nps.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5224, 135971, 'PetroVietNam Securities Joint Stock Company', 'psi.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5225, 135972, 'Quang Nam Department of Information and Communications', 'qti.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5226, 135973, 'Bamboo Airways Company Limited', 'bambooairways.com', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5227, 135974, 'National Power Transmission Corporation', 'evn.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5228, 135977, 'Vietnam BDA technology and communication joint stock company', 'bda.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5229, 135978, 'Hanoi University of Industry', 'haui.edu.vn', 'VN', 512, 'education', '0000-00-00 00:00:00', 0),
(5230, 135979, 'SaoBacDau Technology Service JSC', 'saobacdau.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5231, 13598, 'DAIMLER TRUCKS OF NORTH AMERICA LLC', 'daimler.com', 'US', 65536, 'isp', '1999-07-14 00:00:00', 0),
(5232, 135980, 'Information and Communication Technology Center of Quang Ninh', 'quangninh.gov.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5233, 135981, 'VisualViet Company Limited', 'vnnic.vn', 'VN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5234, 135982, 'Hoi An South Development Ltd', 'hasd.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5235, 135985, 'BCALL Viet Nam Company Limited', 'vnnic.vn', 'VN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5236, 135986, 'Turbo Technology Solution Joint Stock Company', 'turbo.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5237, 135987, 'Reload Company Limited', 'indra.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5238, 135988, 'Sun Group Corporation', 'sungroup.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5239, 13599, 'Eisai Inc.', 'eisai.com', 'US', 256, 'business', '2015-10-27 00:00:00', 0),
(5240, 135991, 'Green Network Solutions LTD.', 'greennet.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5241, 135994, 'IDC Online Technology and Solutions Corporation', 'idconline.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5242, 135997, 'EVN Finance Joint Stock Company - Ho Chi Minh Branch', 'easycredit.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5243, 135998, 'International Distribution Corporation', 'idb.com.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(5244, 136000, 'Lightning Broadband Pty Ltd', 'lightningbroadband.com.au', 'AU', 3328, 'isp', '0000-00-00 00:00:00', 0),
(5245, 136001, 'Christie Spaces', 'christienetworks.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(5246, 136003, 'Internet Factory', 'internetfactorybd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5247, 136004, 'University of Rajshahi', 'ru.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(5248, 136005, 'RAMAN RESEARCH INSTITUTE', 'rri.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5249, 136007, 'Internet Service Provider', 'ispfo.co.id', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5250, 136008, 'Wilson Parking Australia 1992 PTY LTD', 'wilsongroupau.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5251, 136009, 'SpeedNet', 'speednetkhulna.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5252, 136012, 'Telenor Microfinance Bank Limited', 'telenorbank.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(5253, 136013, 'National Gallery of Australia', 'nga.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5254, 136014, 'SS Online', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5255, 136015, 'NETWORK SERVICE PROVIDERS LIMITED', 'nsp.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5256, 136016, 'Camberwell Anglican Girls Grammar School', 'cggs.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5257, 136019, 'AU IX Pty Limited', 'auix.com.au', 'AU', 10240, 'business', '0000-00-00 00:00:00', 0),
(5258, 136020, 'ContentKeeper Technologies', 'contentkeeper.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5259, 136022, 'Janani Technology', 'jananibd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5260, 136023, 'PTE Group Co., Ltd', 'ptegroup.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(5261, 136024, 'Nspire Technologies Limted', 'nspire.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(5262, 136026, 'XERCES IT PTY LTD t/a PSQ Group', 'psqgroup.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5263, 136027, 'Sheikh Shahnawaz Ahmed', 'ssalibd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5264, 136028, 'Advanced Science and Technology Institute', 'freepublicwifi.gov.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5265, 136030, 'Redtone Telecommunications Pakistan (Private) Limited', 'redtone.com.pk', 'PK', 3584, 'isp', '0000-00-00 00:00:00', 0),
(5266, 136032, 'NewMountainView Satellite Corporation', 'mountainview.com.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(5267, 136033, 'IAIR INFOCOM PRIVATE LIMITED', 'myiair.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5268, 136034, 'NTT Data Global Delivery Services Limited', 'nttdata.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5269, 136035, 'Department of Tourism', 'tourism.go.th', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(5270, 136036, 'WYS Group Pty Ltd', 'wyscom.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5271, 136037, 'COMMUNITY COMMUNICATIONS PTY LTD', 'comcoms.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5272, 136038, 'HDTIDC LIMITED', 'allcloud.cc', 'HK', 13056, 'hosting', '0000-00-00 00:00:00', 0),
(5273, 136039, 'NANO, Bhutan', 'nano.bt', 'BT', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5274, 13604, 'FLORIDA CABLE INC.', 'floridacable.com', 'US', 3072, 'business', '2012-07-03 00:00:00', 0),
(5275, 136040, 'Mitr Phol Sugar Corp., Ltd.', 'mitrphol.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(5276, 136044, 'Forsythes Information Technology Pty Ltd', 'forsythesit.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5277, 136047, 'Info Developers Pvt. Ltd.', 'infodev.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(5278, 136049, 'FIL Asia Holdings Pte Limited', 'fil.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(5279, 136052, 'PT Cloud Hosting Indonesia', 'cloudhost.id', 'ID', 3072, 'hosting', '0000-00-00 00:00:00', 0),
(5280, 136053, 'PT. INFINETWORKS GLOBAL', 'infinetworks.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5281, 136054, 'PT.COMTELINDO', 'comtelindo.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5282, 136055, 'PT Queen Network Nusantara', 'qnn.co.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(5283, 136056, 'PT. Sanghiang Perkasa', 'kalbenutritionals.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5284, 136058, 'UNIVERSITAS TRUNOJOYO MADURA', 'trunojoyo.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5285, 136059, 'Universitas Nusa Cendana', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5286, 136060, 'Dinas Informasi dan Pengolahan Data TNI AL (DISINFOLAHTAL)', 'tnial.mil.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5287, 136061, 'Badan Pengusahaan Batam', 'permana.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5288, 136062, 'PT. Jurnal Consulting Indonesia', 'jurnal.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5289, 136063, 'PDAM SURYA SEMBADA KOTA SURABAYA', 'pdam-sby.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5290, 136064, 'PT. WINUSA CIPTA TELEMATIKA', 'wintel.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5291, 136065, 'PT SOLUSI TRIMEGAH PERSADA', 'beenet.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5292, 136067, 'Kantor Pengolahan Data Telematika', 'bantulkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5293, 13607, 'Intuitive Surgical Operations, Inc.', 'intuitive.com', 'US', 3584, 'business', '2011-10-19 00:00:00', 0),
(5294, 136070, 'UNIVERSITAS SAM RATULANGI', 'unsrat.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5295, 136071, 'PPPPTK MATEMATIKA', 'p4tkmatematika.org', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5296, 136073, 'Lembaga Kebijakan Pengadaan Barang/Jasa Pemerintah', 'lkpp.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5297, 136074, 'PT. Sarana Cipta Komunikasi', 'saranaciptakomunikasi.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5298, 136075, 'PT Cinoxmedia Network Indonesia', 'cinox.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5299, 136076, 'PT Hesta Media Sinergi', 'hesta.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5300, 136077, 'Universitas Islam Negeri Mataram', 'iainmataram.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5301, 136078, 'PT. FOXLINE MEDIADATA INDONUSA', 'foxline.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5302, 136079, 'STMIK Amikom Yogyakarta', 'amikom.ac.id', 'ID', 768, 'education', '0000-00-00 00:00:00', 0),
(5303, 136081, 'PEMERINTAH KABUPATEN KEBUMEN', 'kebumenkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5304, 136082, 'PT. Frozbit Multimedia Indonesia', 'frozbit.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(5305, 136083, 'Dinas Komunikasi, Informatika dan Statistika Kota Magelang', 'magelangkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5306, 136084, 'PT. MAKMUR SUPRA NUSANTARA', 'e-intidata.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5307, 136085, 'Pemerintah Kabupaten Bojonegoro', 'bojonegorokab.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5308, 136086, 'PT PRADIPA SAPTA MEDIA', 'java.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5309, 136087, 'Kementerian Ketenagakerjaan RI', 'naker.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5310, 136088, 'PT. Araz Inti Line', 'zitline.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5311, 136090, 'Institut Agama Islam Negeri Raden Intan Lampung', 'radenintan.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5312, 136091, 'Dinas Komunikasi, Informatika, Statistik dan Persandian Provinsi Banten', 'bantenprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5313, 136092, 'PT DAYA AKSES NUSANTARA', 'nusaakses.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5314, 136093, 'PT Mitra Lintas Multimedia', 'faznet.co.id', 'ID', 4608, 'business', '0000-00-00 00:00:00', 0),
(5315, 136094, 'Markas Besar TNI Angkatan Darat', 'mabesad.mil.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5316, 136095, 'PT. Timerindo Perkasa International', 'time.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5317, 136096, 'PT. Terminal Teluk Lamong', 'teluklamong.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5318, 136097, 'PT. IDMARCO PERKASA INDONESIA', 'idmarco.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5319, 136098, 'Badan Kepegawaian Negara', 'bkn.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5320, 136099, 'Pusat Jantung Nasional Harapan Kita', 'pjnhk.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5321, 13610, 'Provo Craft & Novelty, Inc.', 'provocraft.com', 'US', 256, 'business', '2010-08-30 00:00:00', 0),
(5322, 136100, 'PT. BKVNET TELEMEDIA', 'bkvtelemedia.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5323, 136101, 'Pemerintah Kota Bandung', 'bandung.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5324, 136102, 'PT. Arupa Cloud Nusantara', 'arupa.id', 'ID', 1536, 'business', '0000-00-00 00:00:00', 0),
(5325, 136103, 'Universitas Semarang', 'usm.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(5326, 136104, 'IAIN Imam Bonjol Padang', 'iainimambonjol.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5327, 136105, 'CV. ANINDISA KOMPUTINDO PRATAMA', 'anindisa.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5328, 136106, 'PT. Mega Akses Persada', 'fiberstar.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5329, 136107, 'PT. Tujuh Ion Indonesia', '7ion.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5330, 136108, 'PT. Cyberindo Aditama', 'cbn.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(5331, 136109, 'PT IP NETWORK SOLUSINDO', 'ipnetsolusindo.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5332, 13611, 'U.S. Center For Disease Control and Prevention', 'cdc.gov', 'US', 71680, 'business', '1999-07-14 00:00:00', 0),
(5333, 136110, 'UNIVERSITAS 17 AGUSTUS 1945 BANYUWANGI', 'biz.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5334, 136111, 'Kementerian Sosial Republik Indonesia', 'kemsos.go.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5335, 136112, 'Universitas Teknologi Yogyakarta', 'uty.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(5336, 136115, 'STMIK Indonesia Padang', 'stmikindonesia.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5337, 136116, 'PT. ALIANSI TEKNOLOGI INDONESIA', 'polaris.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5338, 136117, 'PT Bank Pembangunan Daerah Jawa Barat & Banten', 'bankbjb.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5339, 136118, 'Universitas Mercubuana', 'mercubuana.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5340, 136119, 'PT Bali Towerindo Sentra, Tbk', 'balitower.co.id', 'ID', 6144, 'isp', '0000-00-00 00:00:00', 0),
(5341, 13612, 'Sysmex', 'sysmex.com', 'US', 1024, 'business', '2006-09-22 00:00:00', 0),
(5342, 136120, 'PT INTEGRA INDOLESTARI', 'iil.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5343, 136123, 'PT Telemarketing Indonesia', 'teleperformance.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5344, 136125, 'PT. ASTRA SEDAYA FINANCE', 'acc.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5345, 136126, 'PT. BLUE BIRD Tbk', 'bluebirdgroup.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5346, 136127, 'PT. Tujuh Akses Mentari Prima', '7akses.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5347, 136128, 'PT CITRA AKSES INDONUSA', 'citraindo.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5348, 136129, 'Kementerian Koordinator Bidang Kemaritiman RI', 'maritim.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5349, 136130, 'Pemerintah Kabupaten Tegal', 'tegalkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5350, 136131, 'PT Tiga Satu Cyber Network', 'tscn.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5351, 136132, 'Woollahra Municipal Council', 'nsw.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5352, 136133, 'SQUIXA PTY LIMITED', 'section.io', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(5353, 136134, 'Independent Univeristy, Bangladesh', 'iub.edu.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(5354, 136135, 'Haileybury', 'haileybury.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5355, 136136, 'Avant Mutual Group Limited', 'avant.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5356, 136137, 'Terabit Wave Company Limited', 'terabitwave.net', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(5357, 136138, 'Cybage Software Pvt. Ltd.', 'cybage.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5358, 13614, 'All West Communications, Inc.', 'awusa.net', 'US', 38912, 'isp', '1999-07-14 00:00:00', 0),
(5359, 136140, 'Bank of Western Australia Limited (Bankwest)', 'bankwest.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5360, 136141, 'Mohammad Kamrul Hasan t/a SK Traders', 'sktraderss.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5361, 136142, 'AUSTRALIAN RED CROSS SOCIETY', 'redcross.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5362, 136144, 'Inner Northern Group Training Ltd', 'intowork.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5363, 136145, 'Eastern Bank Limited', 'ebl-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5364, 136146, 'Beijing 3389 Network Technology Co., Ltd.', 'None', 'CN', 4864, 'hosting', '0000-00-00 00:00:00', 0),
(5365, 136147, 'Bank for Agriculture and Agricultural Co-operative', 'baac.or.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(5366, 136149, 'MediaCorp Pte Ltd', 'mediacorp.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5367, 13615, 'Heritage Valley Health System', 'heritagevalley.org', 'US', 256, 'business', '2008-09-18 00:00:00', 0),
(5368, 136151, 'Jatrabari Online', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5369, 136152, 'Australian Health & Nutrition Association', 'sanitarium.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5370, 136153, 'Nayara Energy Limited', 'nayaraenergy.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5371, 136154, 'Rockhampton City Council', 'rockhamptonregion.qld.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5372, 136156, 'MD Rehanur Rahman t/a M/S FNF Online', 'fnfinternet.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5373, 136157, 'AFFCO New Zealand Ltd', 'affco.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5374, 136158, 'UOB Asset Management (Thailand) Co., Ltd.', 'uobam.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(5375, 136160, 'Beijing Shijihulian Yuntong Network Technology Co., Ltd.', 'qq.com', 'CN', 5632, 'hosting', '0000-00-00 00:00:00', 0),
(5376, 136161, 'Harbourtel Pty Ltd', 'harbourtel.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5377, 136164, 'Islamic University of Technology (IUT)', 'iut-dhaka.edu', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(5378, 136165, 'X4B DDoS Protected Announcements', 'x4b.net', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(5379, 136166, 'ANGEL BROKING LIMITED', 'angelbroking.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5380, 136167, 'CHINA TELECOM (MACAU) COMPANY LIMITED', 'chinatelecom.com.mo', 'MO', 2560, 'isp', '0000-00-00 00:00:00', 0),
(5381, 136168, 'Campana MYTHIC Co. Ltd.', 'campanaworks.com', 'MM', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5382, 136169, 'DBS Bank Ltd', 'dbs.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(5383, 13617, 'Freudenberg IT LP', 'freudenberg-it.com', 'US', 1280, 'business', '2010-03-04 00:00:00', 0),
(5384, 136170, 'PT. EXABYTES NETWORK INDONESIA', 'exabytes.co.id', 'ID', 3328, 'hosting', '0000-00-00 00:00:00', 0),
(5385, 136171, 'Medha Hosting', 'medhahosting.com', 'IN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(5386, 136172, 'XL India Business Services Private Limited', 'xlcatlin.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5387, 136174, 'The Professional Communications Pvt Ltd', 'nova.net.pk', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5388, 136175, 'Serverhosh Internet Service', 'serverhosh.com', 'NL', 2304, 'business', '0000-00-00 00:00:00', 0),
(5389, 136176, 'Cyber Solutions BD', 'cybersolutionsbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5390, 136177, 'Yoma Bank Limited', 'yomabank.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(5391, 136178, 'FIL Japan Holdings K.K.', 'fil.com', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(5392, 136179, 'GMR Infrastructure Ltd', 'gmrgroup.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5393, 136180, 'Beijing Tiantexin Tech. Co., Ltd.', 'ipip.net', 'CN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5394, 136182, 'Bualuang-ventures-company-limited', 'bbl.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(5395, 136183, 'Williams Technology Pty Ltd', 'williamstech.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5396, 136184, 'YLINX', 'ylinx.com', 'PK', 1536, 'business', '0000-00-00 00:00:00', 0),
(5397, 136187, 'Nixon Controls Pty Ltd', 'nixonnetworks.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5398, 136188, 'NINGBO, ZHEJIANG Province, P.R.China.', 'chinatelecom.cn', 'CN', 143360, 'isp', '0000-00-00 00:00:00', 0),
(5399, 136189, 'Opera Software Technology (Beijing) Co., Ltd.', 'opera.com', 'CN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5400, 136190, 'JINHUA, ZHEJIANG Province, P.R.China.', 'chinatelecom.cn', 'CN', 102400, 'isp', '0000-00-00 00:00:00', 0),
(5401, 136191, 'YICHANG, Hubei Province, P.R.China.', 'chinatelecom.cn', 'CN', 16640, 'isp', '0000-00-00 00:00:00', 0),
(5402, 136192, 'Xiangyang, Hubei Province, P.R.China.', 'chinatelecom.cn', 'CN', 14336, 'isp', '0000-00-00 00:00:00', 0),
(5403, 136193, 'Jingzhou, Hubei Province, P.R.China.', 'chinatelecom.cn', 'CN', 5888, 'isp', '0000-00-00 00:00:00', 0),
(5404, 136194, 'Huangshi, Hubei Province, P.R.China.', 'chinatelecom.cn', 'CN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(5405, 136195, 'Qingdao, Shandong Province, P.R.China.', 'chinatelecom.cn', 'CN', 58112, 'isp', '0000-00-00 00:00:00', 0),
(5406, 136197, 'Xiong\'an, Hebei Province, P.R.China.', 'gsta.com', 'CN', 37376, 'isp', '0000-00-00 00:00:00', 0),
(5407, 136198, 'CHINANET Guangdong province Yuexi MAN network', 'chinatelecom.cn', 'CN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(5408, 136199, 'CHINANET Guangdong province Yuedong MAN network', 'chinatelecom.cn', 'CN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(5409, 13620, 'EMBLEMHEALTH SERVICES COMPANY, LLC', 'emblemhealth.com', 'US', 1024, 'business', '2012-09-24 00:00:00', 0),
(5410, 136200, 'CHINANET Guangdong province Foshan MAN network', 'chinatelecom.cn', 'CN', 1546496, 'isp', '0000-00-00 00:00:00', 0),
(5411, 136201, 'BG UNIFIED SOLUTIONS PTY LTD', 'bgunifiedsolutions.net', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5412, 136202, 'Freepoint Commodities Singapore Pte. Ltd.', 'freepoint.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(5413, 136203, 'AISH SOLUTIONS PTY LTD', 'aish.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5414, 136205, 'LINN IT Solution Co., Ltd', 'linncomputer.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(5415, 136206, 'Skynet Broadband Pty Ltd', 'skynetbroadband.com.au', 'AU', 256, 'isp', '0000-00-00 00:00:00', 0),
(5416, 136207, 'K B N Online', 'None', 'BD', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(5417, 136209, 'Korea Fast Networks', 'kfnetworks.com', 'KR', 7680, 'hosting', '0000-00-00 00:00:00', 0),
(5418, 13621, 'Reinsurance Group of America', 'rgare.com', 'US', 512, 'business', '1999-07-15 00:00:00', 0),
(5419, 136210, 'IT Spectrum Company Limited', 'itspectrum.com.mm', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(5420, 136211, 'Epyllion Knitwears Ltd.', 'epylliongroup.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5421, 136214, 'Creativa IT Mymensingh Bangladesh', 'creativa.asia', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(5422, 136215, 'SB NETWORK', 'sbnetworkbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5423, 136216, 'Channel Information Technology Support and Leasing Services Inc.', 'bposeats.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5424, 136217, 'MOON NET', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5425, 136218, 'TARGET AUSTRALIA PTY. LTD.', 'target.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5426, 136219, 'PRABHU BANK LIMITED', 'prabhubank.com', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(5427, 136221, 'Telekomunikasi Indonesia International PT', 'telin.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5428, 136223, 'China Merchants Securities (HK) Co., Ltd', 'cmschina.com.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(5429, 136224, 'City Online Ltd.', 'cityonlinebd.net', 'BD', 4096, 'isp', '0000-00-00 00:00:00', 0),
(5430, 136226, 'STANDARDS AUSTRALIA LIMITED', 'standards.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5431, 136230, 'Evergreen Internet', 'evergreeninternet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5432, 136232, 'Independent Commission Against Corruption', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5433, 136234, 'Media Net Pvt Ltd', 'medianet.mv', 'MV', 256, 'business', '0000-00-00 00:00:00', 0),
(5434, 136237, 'Shuangyu Communication Technology co.,Ltd.', 'syctnet.com', 'HK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5435, 136238, 'SatLink Pvt Ltd', 'satlinkonline.com', 'MV', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5436, 136239, 'CLICK PACIFIC LTD', 'clickpacific.com', 'PG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5437, 13624, 'Sierra Nevada Corporation', 'sncorp.com', 'US', 1536, 'business', '2008-09-04 00:00:00', 0),
(5438, 136241, 'Thomson Geer Services', 'tglaw.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5439, 136242, 'ONESCHOOL AUSTRALIA LTD', 'oneschoolglobal.com', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5440, 136244, 'Panay Broadband / Buenavista Cable TV Inc.', 'panaybroadband.com.ph', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(5441, 136245, 'Goodlife Operations PTY LTD', 'fitlg.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5442, 136246, 'Tomattos Technologies Ltd.', 'tomattos.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(5443, 136247, 'Victoria University', 'vu.edu.au', 'AU', 67840, 'education', '0000-00-00 00:00:00', 0),
(5444, 136248, 'Abdur Rahim Bishas t/a FAST NET BD', 'fastnetbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5445, 13625, 'CALGAH Computer Systems and Management Ltd', 'calgah.com', 'CA', 4096, 'business', '2006-06-23 00:00:00', 0),
(5446, 136251, 'EVERY DAY TECHNOLOGY CO. LIMITED', 'desen.hk', 'HK', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(5447, 136252, 'THE BANK OF BARODA LIMITED', 'bankofbaroda.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5448, 136254, 'Rivercity Solutions Pty Ltd', 'rivercity.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5449, 136255, 'Telecom International Myanmar Co., Ltd', 'irdmyanmar.gov.mm', 'MM', 10496, 'isp', '0000-00-00 00:00:00', 0),
(5450, 136257, 'New CNS Online', 'None', 'BD', 768, 'hosting', '0000-00-00 00:00:00', 0),
(5451, 136258, 'BrainStorm Network, Inc', 'oneprovider.com', 'CA', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5452, 136259, 'FAYSAL BANK LIMITED', 'faysalbank.com', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(5453, 13626, 'Walgreens Co', 'walgreens.com', 'US', 1792, 'business', '1999-07-16 00:00:00', 0),
(5454, 136260, 'IPOINTEAST INC.', 'ipointeast.net', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5455, 136261, 'Emerson Network Power (Singapore) Pte Ltd', 'vertivco.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5456, 136262, 'Asia Pacific Communication Limited', 'apclbd.net', 'BD', 3328, 'business', '0000-00-00 00:00:00', 0),
(5457, 136264, 'AGA ASSISTANCE AUSTRALIA PTY LTD', 'allianz-assistance.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5458, 136265, 'Splunk Inc.', 'splunk.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5459, 136266, 'Mohammad Abu Nayem T/A Automation System', 'as-bd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5460, 136267, 'Info Internet Service', 'infointernetservice.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5461, 136268, 'QSR Systems Ltd.', 'qsrsystems.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(5462, 136269, 'BPAC CLINICAL SOLUTIONS LP', 'southlink.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5463, 136271, 'IMS Health India Pvt Ltd', 'imshealth.com', 'IN', 2304, 'business', '0000-00-00 00:00:00', 0),
(5464, 136272, 'MOHAMMAD ANOWER HOSSAIN t/a SUN ONLINE', 'sunonlinebd.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5465, 136274, 'Cloud Servers Pvt Ltd', 'cloudservers.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(5466, 136276, 'Eirtel Services Ltd.', 'eirtelservices.com', 'BD', 3328, 'business', '0000-00-00 00:00:00', 0),
(5467, 136277, 'NGE PTY LTD', 'nge.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5468, 136279, 'Glo Internet Services Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5469, 13628, 'AMERISOURCEBERGEN', 'amerisourcebergen.com', 'US', 4864, 'business', '2005-09-21 00:00:00', 0),
(5470, 136282, 'Quick Net', 'quicknet.ro', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5471, 136283, 'Adani Enterprises Limited', 'adani.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5472, 136284, 'Paradise Telecom Pvt Ltd', 'paradisetele.com', 'IN', 5632, 'isp', '0000-00-00 00:00:00', 0),
(5473, 136285, 'Karunay Internet Pvt Ltd', 'karunay.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5474, 136286, 'Cybercity Extreme Broadband Pvt Ltd', 'ccebroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5475, 136287, 'Falconet Internet Pvt.ltd.', 'falconet.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5476, 136288, 'Sai Prasad Intenet Services Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5477, 13629, 'Deem, Inc.', 'deem.com', 'US', 1536, 'business', '2016-04-06 00:00:00', 0),
(5478, 136291, 'Madhya Pradesh State Electronics Development Corporation Ltd.', 'mpsedc.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5479, 136292, 'Netflix Durga Webtech Pvt Ltd', 'netflixdurga.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5480, 136294, 'Decibel Networks Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5481, 136295, 'Jadhav Broadband Private Limited', 'jbpl.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5482, 136297, 'Vision Hi-speed Technology Pvt.ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5483, 136298, 'Hyber Networking Private Limited', 'hybernetwork.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5484, 136299, 'Integral Biosciences Pvt. Ltd.', 'integralbiosciences.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5485, 13630, 'CSX Technology', 'csx.com', 'US', 2304, 'business', '1999-07-16 00:00:00', 0),
(5486, 136300, 'Tgn Networks Private Limited', 'tgnnetworks.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5487, 136301, 'Jetway Networks Private Limited', 'jetwaynetworks.in', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(5488, 136302, 'Airtech Internet Solutions Pvt. Ltd.', 'onefiber.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(5489, 136303, 'Sher Telelink Pvt Ltd', 'shertelelink.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5490, 136304, 'Institute Of Physics, Bhubaneswar', 'iopb.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5491, 136305, 'Netvision Awadh Networks Private Limited', 'mynetvision.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5492, 136306, 'Texes Connect Private Limited', 'texes.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5493, 136308, 'Deenet Services Pvt Ltd', 'deenetservices.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5494, 136309, 'Marutham Networks Private Limited', 'marutham.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5495, 13631, 'Citadel Investment Group, L.L.C.', 'citadel.com', 'US', 1536, 'business', '2005-12-06 00:00:00', 0),
(5496, 136311, 'Gayatri Telecom Pvt Ltd', 'gayatritelecom.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5497, 136312, 'Shriram Value Services Limited', 'shriramvalue.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5498, 136313, 'Solutions Infini Technologies India Pvt Ltd', 'solutionsinfini.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5499, 136314, 'SHAILDHAR TELECOM SERVICES PVT LTD', 'shaildhar-india.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5500, 136315, 'Maruti Interactive Network Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5501, 136317, 'Giga Beam Broadband Pvt.ltd', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5502, 136318, 'Inter Net Ly Private Limited', 'theisp.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5503, 136319, 'Acebrowse Private Ltd', 'acebrowse.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5504, 136320, 'World Vision Networks Private Limited', 'wvnpl.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5505, 136322, 'Gigacast Network Pvt Ltd', 'gigacastnetwork.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5506, 136323, 'Ngc Broadband Pvt. Ltd.', 'ngcbroadband.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5507, 136324, 'Idbi Bank Ltd', 'idbi.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5508, 136325, 'Lava International Limited', 'lavainternational.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5509, 136326, 'Varesha Air World Networks Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5510, 136327, 'Spd Broadband Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5511, 136328, 'S S Cablenet', 'mediantbroadband.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5512, 13633, 'OOCL (USA), Inc.', 'oocl.com', 'US', 1024, 'business', '1999-07-20 00:00:00', 0),
(5513, 136330, 'Vardaan Netservices Private Limited', 'netorious.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5514, 136331, 'Shrisai Enterprises', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5515, 136332, 'Adri Infocom Pvt Ltd', 'adricorp.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5516, 136333, 'Jvg Communication Pvt Ltd', 'jvgcommunication.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5517, 136334, 'Vortex Netsol Private Limited', 'vortexnetsol.com', 'IN', 14592, 'isp', '0000-00-00 00:00:00', 0),
(5518, 136335, 'Mtel Networks Private Limited', 'mtelnetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5519, 136336, 'Thamizhaga Internet Communications Private Limited', 'ticfiber.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5520, 136337, 'Ran Broadband Private Limited', 'ranbroadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5521, 136338, 'Trivoz Digital Networks Pvt Ltd', 'trivoz.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5522, 136339, 'AIRMAX', 'airmaxitalia.it', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5523, 136342, 'Winux Communications Pvt. Ltd.', 'winux.co.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(5524, 136343, 'Ceralink Communication Pvt Ltd', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5525, 136344, 'Bass Jokernet Private Limited', 'jokernet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5526, 136345, 'Z. K. Infonet', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5527, 136346, 'Fasttnet Broadband Services Pvt Ltd', 'fasttnet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5528, 136347, 'Rukku Networks Private Limited', 'rukkunetworks.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5529, 136349, 'Rainbow Internet Teleservices Private Limited', 'rainbownetcom.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5530, 13635, 'Fusion Media', 'fusionmedia.net', 'US', 3584, 'business', '2010-12-09 00:00:00', 0),
(5531, 136352, 'Autonetic Software Technologies Pvt Ltd', 'autonetic.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5532, 136353, 'Satpar Infotech Pvt Ltd', 'jkonnekt.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5533, 136354, 'Netzi Broadband Services Pvt Ltd', 'netzi.in', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5534, 136355, 'Suntech Sanchar Private Limited', 'suntechnologies.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5535, 136356, 'Purenet Telecom India Pvt. Ltd.', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5536, 136357, 'Siddiqui Global Services Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5537, 136358, 'Omsai Cable Systems India Pvt Ltd', 'omsai.network', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5538, 136359, 'Hansin It Services Pvt. Ltd.', 'hansinit.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5539, 13636, 'NEC Laboratories America, Inc.', 'nec-labs.com', 'US', 131072, 'business', '1999-07-20 00:00:00', 0),
(5540, 136360, 'Isolnet Network Solution Pvt Ltd', 'isolnet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5541, 136361, 'Click4net Internet Services P Ltd', 'click4net.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5542, 136362, 'Yes India Communications Pvt. Ltd', 'yesindiacommunications.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5543, 136363, 'Rocknet Internet Services Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(5544, 136364, 'Myguru Online India Pvt Ltd', 'myguruonline.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5545, 136365, 'Shri Samarth Broadband', 'irinn.in', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5546, 136366, 'Prompt Infracom Private Limited', 'None', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5547, 136368, 'Rathnaa Spectra Private Limited', 'rathnaaspectra.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5548, 136370, 'SAI NETWORKS', 'sai-networks.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5549, 136371, 'Airwir Technologies Private Limited', 'airwir.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5550, 136372, 'Ss Fiber Net Optical Communication Pvt. Ltd.', 'ssfibernet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5551, 136373, 'Allied It Infrastructure And Services Pvt Ltd', 'allieditservices.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(5552, 136374, 'Microtalk Communications Pvt Ltd', 'microtalk.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5553, 136375, 'Chl Technology', 'chltech.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5554, 136376, 'Udayatel Communications Private Limited', 'udayatel.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5555, 136377, 'Linkwave Technologies Pvt. Ltd', 'linkwave.co.in', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(5556, 136379, 'Istanaimpian Corporation Limited', 'istanaimpian.ltd', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(5557, 13638, 'Metalink Technologies, Inc.', 'metalink.net', 'US', 25600, 'business', '1999-07-20 00:00:00', 0),
(5558, 136380, 'Web Networks Pvt. Ltd.', 'webnet.com.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(5559, 136384, 'Optix Pakistan (Pvt.) Limited', 'optix.pk', 'PK', 26880, 'isp', '0000-00-00 00:00:00', 0),
(5560, 136385, 'DATCOM CLOUD PTY LTD', 'datcom.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5561, 136386, 'FULL SPECTRUM NETWORKS PTY. LTD.', 'fullspectrum.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5562, 136388, 'Efficient Chips', 'efficientchips.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5563, 13639, 'ING Financial Services, LLC', 'ing.com', 'US', 1024, 'business', '2009-10-27 00:00:00', 0),
(5564, 136391, 'MCCONAGHY GROUP PTY LTD', 'mcconaghygroup.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5565, 136392, 'ST. VINCENT\'S HOSPITAL (MELBOURNE) LIMITED', 'svhm.org.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(5566, 136393, 'Symphony Communication (Thailand) PCL.', 'symphony.net.th', 'TH', 10240, 'isp', '0000-00-00 00:00:00', 0),
(5567, 136395, 'Mahfujul Haque t/a Expert Online', 'expertonlinebd.net', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5568, 136397, 'Interpublic Australia Holdings Pty Ltd', 'interpublic.com', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(5569, 136398, 'Secure Agility PTY LTD', 'secureagility.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5570, 136399, 'Bambu Wireless Solutions Inc.', 'None', 'PH', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5571, 136400, 'Asia Consultancy Group', 'acgtelasia.com', 'AF', 768, 'business', '0000-00-00 00:00:00', 0),
(5572, 136404, 'BICOLANDIA CABLE TV INCORPORATED', 'bicolandiacabletv.net', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5573, 136405, 'Virtustream Cloud Services Australia Pty Limited', 'virtustream.com', 'AU', 2560, 'business', '0000-00-00 00:00:00', 0),
(5574, 136406, 'SPEED LINK', 'speedlinkbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5575, 136407, 'Virtustream Cloud Services Australia Pty Limited', 'virtustream.com', 'JP', 2560, 'business', '0000-00-00 00:00:00', 0),
(5576, 13641, 'PDM Net', 'pdmnet.net', 'US', 4864, 'isp', '1999-07-20 00:00:00', 0),
(5577, 136412, 'Titan System Integration Sdn Bhd', 'titansi.com.my', 'MY', 768, 'business', '0000-00-00 00:00:00', 0),
(5578, 136414, 'Amnesty International Australia', 'amnesty.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5579, 136416, 'Sorob IT LTD', 'sorobit.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5580, 136419, 'Sky Link Net', 'slnisp.com.bd', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(5581, 136423, 'Melbourne Grammar School', 'mgs.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5582, 136424, 'THE SIMPRO GROUP PTY LTD', 'simprogroup.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5583, 136425, 'Asianet Online Service', 'asianetonlinebd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5584, 136426, 'Dinesh Gopi Virwani', 'epicbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5585, 136427, 'MCB-ARIF HABIB SAVINGS AND INVESTMENTS LIMITED', 'mcbah.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(5586, 136429, 'Arifuzzaman Auni t/a BAS Network', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5587, 136431, 'Operational Systems Pty Ltd', 'opsys.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5588, 136433, 'BD Solution Online', 'bdsolutiononline.com', 'BD', 2048, 'business', '0000-00-00 00:00:00', 0),
(5589, 136434, 'Digital Communication', 'dcommbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5590, 136435, 'Muhammad Manzur Iqbal T/A SILICON NET', 'None', 'BD', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(5591, 136436, 'CIGNA LIFE INSURANCE NEW ZEALAND LIMITED', 'cigna.com', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(5592, 136437, 'TransUnion Global Technology Center LLP', 'transunion.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5593, 136438, 'Husnul Bari t/a Adda Network', 'addanetwork.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5594, 136439, 'Defence Science Technology Agency', 'dsta.gov.sg', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5595, 136440, 'Sungard Availability Services (India) Private Limited', 'sungardas.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5596, 136442, 'Ocean Wave Communication Co., Ltd', 'mowcn.com', 'MM', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5597, 136445, 'Md. Rafiqul islam', 'a-1dotnet.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5598, 136447, 'Four Kites India Private Ltd', 'fourkites.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5599, 136448, 'AIA Shared Services (Hong Kong) Ltd', 'aia.com', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(5600, 136449, 'AIT Internet Services Private Ltd', 'aitinternetservices.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5601, 13645, 'BroadbandONE, Inc.', '365datacenters.com', 'US', 161024, 'business', '1999-07-21 00:00:00', 0),
(5602, 136450, 'Kastech Computer Valley', 'kastechbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5603, 136454, 'Fiber-SAT ISP Ltd.', 'fiber-sat.net', 'AF', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5604, 136455, 'Texas Instruments, Inc', 'ti.com', 'US', 512, 'business', '0000-00-00 00:00:00', 0),
(5605, 136456, 'LANSOL NOMINEES PTY. LTD.', 'landers.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5606, 136457, 'THAIAIRASIA-CSL-TH', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(5607, 136461, 'Speed Online', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5608, 136462, 'Mootech Asia', 'mootech.asia', 'TW', 2048, 'business', '0000-00-00 00:00:00', 0),
(5609, 136463, 'WheroNet Limited', 'whero.net.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5610, 136464, 'Pacific Internet Pte Ltd', 'pacificinternet.com', 'SG', 256, 'isp', '0000-00-00 00:00:00', 0),
(5611, 136465, 'Dept. of Information Technology & Cyber Security', 'mofa.gov.mm', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(5612, 136468, 'NSONE INC.', 'ns1.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(5613, 136469, 'ShoreTel Australia PTY LTD', 'shoretel.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5614, 136471, 'Optiver Pty Ltd', 'optiver.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5615, 136474, 'Marga Global Telecom Limited', 'margaglobal.com', 'MM', 2048, 'business', '0000-00-00 00:00:00', 0),
(5616, 136475, 'Planetcast Media Services Limited', 'planetc.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5617, 136477, 'P.D.S. Server Network Pvt. Ltd.', 'pds.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(5618, 136478, 'Greyhound Australia Pty Ltd', 'greyhound.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5619, 136479, 'Cyber Telecom ISP', 'cts.af', 'AF', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5620, 136480, 'Myanmar Unilink Communication Company Limited', 'unilink.com.mm', 'MM', 6144, 'isp', '0000-00-00 00:00:00', 0),
(5621, 136481, 'Dreamlink Technologies Pvt. Ltd', 'dreamlink.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5622, 136482, 'Fair Net', 'fairnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5623, 136486, 'Datacom Sole Co., Ltd', 'datacom.la', 'LA', 1024, 'business', '0000-00-00 00:00:00', 0),
(5624, 136487, 'Outcomex Pty Ltd', 'outcomex.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5625, 136488, 'Health Care of New Zealand Limited', 'healthcarenz.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5626, 13649, 'Flexential Colorado Corp.', 'flexential.com', 'US', 632832, 'hosting', '1999-07-22 00:00:00', 0),
(5627, 136490, 'DATA PROCESSORS PTY LTD', 'dataprocessors.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5628, 136491, 'TIDALPORT INTERNATIONAL LIMITED', 'vocom.com', 'HK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5629, 136492, 'Experian Marketing Services (Malaysia) Sdn. Bhd.', 'experian.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(5630, 136493, 'Earth Network Technology (HongKong) Co., Limited', '9earth.com', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(5631, 136494, 'Smartcall Limited', 'smartcall.nz', 'NZ', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5632, 136497, 'Verifone Australia (HAPL) Pty Ltd', 'verifone.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5633, 136499, 'Tech Management Group Ltd', 'tmg.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5634, 13650, 'Axia Connect Ltd.', 'axia.com', 'CA', 256, 'isp', '2015-02-10 00:00:00', 0),
(5635, 136500, 'NorthCloud Limited', 'northcloud.co.nz', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(5636, 136503, 'Personal Collection Direct Selling, Inc.', 'pcdsi.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5637, 136507, 'Collaborative Corporate Services Management (2Cs)', 'inet.co.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(5638, 13651, 'BUCKLAND TELEPHONE COMPANY', 'ohiolink.net', 'US', 4096, 'business', '2006-06-15 00:00:00', 0),
(5639, 136512, 'AB Bank Limited', 'abbl.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5640, 136513, 'Corporate Technologies Incorporated', 'filinvestcity.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(5641, 136514, 'Rashedur Rahman t/a Onesky Communications Limited.', 'onesky.com.bd', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5642, 136515, 'Dasca Cable Services, Inc.', 'dascacable.com', 'PH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5643, 136516, 'Masud Rana t/a Unique Net', 'uniquenet-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5644, 136518, 'WA Government project', 'nec.com.au', 'AU', 81920, 'isp', '0000-00-00 00:00:00', 0),
(5645, 13652, 'HORIZON BLUE CROSS BLUE SHIELD OF NJ', 'horizonblue.com', 'US', 2304, 'business', '2016-05-18 00:00:00', 0),
(5646, 136520, 'Myklnet Solutions', 'myklnet.com', 'MY', 768, 'business', '0000-00-00 00:00:00', 0),
(5647, 136521, 'TAFE NSW', 'tafensw.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(5648, 136522, 'TAFE NSW', 'tafensw.edu.au', 'AU', 1280, 'education', '0000-00-00 00:00:00', 0),
(5649, 136523, 'COLODEE DIGITAL NETWORK CO.,LTD.', 'colodee.com', 'TH', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(5650, 136524, 'Zylex Computers Limited', 'zylex.nz', 'NZ', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5651, 136525, 'Wancom (Pvt) Ltd.', 'wancom.net.pk', 'PK', 92672, 'isp', '0000-00-00 00:00:00', 0),
(5652, 136527, 'CLOUDFOREST.ME', 'None', 'TH', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(5653, 136529, 'The Lido Group Pty Ltd', 'lido.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5654, 13653, 'California Insurance Guarantee Association', 'caiga.org', 'US', 512, 'business', '2012-11-29 00:00:00', 0),
(5655, 136530, 'Ultranet Communications', 'ultranet.com.np', 'NP', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5656, 136531, 'NetExpress Online', 'netexpressbd.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5657, 136533, 'MyISP Dot Com Sdn Bhd', 'myisp.com.my', 'MY', 2048, 'business', '0000-00-00 00:00:00', 0),
(5658, 136534, 'GUNGCHIL', 'gungchil.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5659, 136536, 'Ernst & Young Advisory Sdn Bhd', 'ey.net', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(5660, 136537, 'SQUAREPOINT OPERATIONS PRIVATE LIMITED', 'squarepoint-capital.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5661, 136538, 'AIS SUPER WiFi', 'ais.co.th', 'TH', 8192, 'isp', '0000-00-00 00:00:00', 0),
(5662, 136539, 'ZOOLOGICAL PARKS BOARD OF NSW', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5663, 13654, 'KC Web, Inc.', 'kcweb.net', 'US', 20480, 'isp', '2005-12-06 00:00:00', 0),
(5664, 136548, 'HKTA Limited', 'hktanet.com', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(5665, 136549, 'NetStrategy Pty Ltd', 'netstrategy.net', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5666, 13655, 'ReadyTalk', 'readytalk.com', 'US', 256, 'business', '2014-03-11 00:00:00', 0),
(5667, 136551, 'AIA COMPANY LIMITED (Thailand Branch)', 'aia.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(5668, 136552, 'Pacific Comnet (M) Sdn. Bhd.', 'pacificinternet.com', 'MY', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5669, 136553, '3i Network Pte Ltd', '3inetwork.net', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5670, 136556, 'M/S BD ONLINE SYSTEMS', 'bdonlinesystems.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5671, 136557, 'Host Universal Pty Ltd', 'hostuniversal.com.au', 'AU', 22272, 'hosting', '0000-00-00 00:00:00', 0),
(5672, 136558, 'Mux', 'muxtechnologies.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5673, 136562, 'Mohammad Ohid Ullah Bhuiyan t/a The Winner IT', 'winneritbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5674, 136563, 'Iranet Cyber Cafe', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5675, 136565, 'CyberWorld', 'cyberworld.co.th', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(5676, 136566, 'CyberWorld Data Center Co.,Ltd.', 'cyberworld.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(5677, 13657, 'E-Gate Communications Inc.', 'egate.net', 'CA', 74496, 'isp', '1999-07-23 00:00:00', 0),
(5678, 136571, 'Next Telecom Pty Ltd', 'nexttelecom.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5679, 136573, 'Sanjoy Saha t/a Zip Cyber Cafe & Technology', 'zipcyber.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5680, 136574, 'Zheye Networks', 'ijc.net', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(5681, 136575, 'SailPoint Technologies India Private Limited', 'sailpoint.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5682, 136577, 'Siptalk Pty Ltd', 'siptalk.com.au', 'AU', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5683, 136579, 'Fuji Xerox (Thailand) Co., Ltd.', 'fujixerox.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(5684, 13658, 'QUANTIL, INC', 'quantilnetworks.com', 'US', 3840, 'isp', '2017-09-14 00:00:00', 0),
(5685, 136580, 'OUR COMMUNITY BROADBAND PTY LTD', 'ourcommunitybroadband.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5686, 136581, 'Apple Wealth Securities', 'apple.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(5687, 136582, 'Babakaya Networking Services Company', 'bbkservices.org', 'AF', 256, 'business', '0000-00-00 00:00:00', 0),
(5688, 136584, 'VoIP Line Telecom Pty. Ltd.', 'voipline.net.au', 'GB', 512, 'business', '0000-00-00 00:00:00', 0),
(5689, 136585, 'LEIDOS AUSTRALIA PTY LIMITED', 'leidos.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5690, 136586, 'InComm Japan K.K.', 'incomm.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(5691, 136587, 'PNG DATACO LIMITED', 'pngdataco.com', 'PG', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5692, 136589, 'CATHOLIC EDUCATION OFFICE OF WA', 'cewa.edu.au', 'AU', 2048, 'education', '0000-00-00 00:00:00', 0),
(5693, 13659, 'InterTECH Corp', 'intertechcorp.com', 'US', 5888, 'business', '1999-07-26 00:00:00', 0),
(5694, 136590, 'OPENTEXT CORPORATION', 'opentext.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5695, 136592, 'Utah Knitting & Dyeing Limited', 'utahgroup.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5696, 136595, 'EXCELLENT SOFTWARE LIMITED', 'xls.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(5697, 136596, 'HSD', 'hsd.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5698, 136598, 'HN Telecom Limited', 'hntelecom.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5699, 13660, 'Blue Cross Blue Shield of North Dakota', 'bcbsnd.com', 'US', 2048, 'business', '2013-05-23 00:00:00', 0),
(5700, 136600, 'Beijing Fengniao Network Technology Co., Ltd', 'fncloud.net', 'CN', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(5701, 136601, 'GOVERNMENT TECHNOLOGY AGENCY', 'tech.gov.sg', 'SG', 5120, 'business', '0000-00-00 00:00:00', 0),
(5702, 136602, 'Bank Al Habib Limited', 'bankalhabib.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(5703, 136603, 'Tribe Broadband Pty Ltd', 'tribebroadband.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5704, 136604, 'Royal Automobile Club of Victoria Ltd', 'racv.com.au', 'AU', 4096, 'isp', '0000-00-00 00:00:00', 0),
(5705, 136606, 'Crystal Net Pte Ltd', 'crystalvoice.com.sg', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(5706, 136608, 'Wisper Connect', 'wisperconnect.net.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(5707, 136609, 'Forerunner Computer Systems Pty Ltd', 'forerunner.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5708, 136610, 'WideBand Communications(Pvt)Ltd', 'wideband.com.pk', 'PK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5709, 136612, 'QR', 'aurizon.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(5710, 136613, 'Ayeyarwady Bank', 'ayabank.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(5711, 136616, 'Manrex Pty Ltd ta Webstercare', 'webstercare.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5712, 136617, 'Fortune Telecom Company Limited', 'fortunemm.com', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5713, 136618, 'Bangladesh University of Engineering and Technology', 'buet.ac.bd', 'BD', 256, 'education', '0000-00-00 00:00:00', 0),
(5714, 13662, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 1536, 'isp', '1999-07-27 00:00:00', 0),
(5715, 136620, 'VMHaus Limited', 'vmhaus.com', 'GB', 2816, 'hosting', '0000-00-00 00:00:00', 0),
(5716, 136621, 'SBP Corporation Limited', 'sbp.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(5717, 136622, 'Equitas Small Finance Bank Ltd', 'equitasbank.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5718, 136623, 'AWD IT SOLUTIONS AUSTRALASIA PTY LTD', 'awd.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5719, 136624, 'Sakon Nakhon Rajabhat University', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(5720, 136625, 'OOKLA TELECOM PVT.LTD', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5721, 136626, 'Arp Infonet Pvt Ltd', 'arpinfonet.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5722, 136630, 'I Bus Networks And Infrastructure Pvt Ltd', 'ibusnetworks.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5723, 136632, 'Vajra Telecom Pvt Ltd', 'vajratelecom.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5724, 136633, 'Sanhati Infocom Services Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5725, 136634, 'Navkar Netsol Private Ltd', 'navkarnetsol.com', 'IN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(5726, 136635, 'G-max It Services Private Limited', 'gmaxconnect.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5727, 136636, 'Sharplink Wireless Solution Pvt Ltd', 'slnet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5728, 136637, 'Cify IT Services Pvt Ltd', 'cifyitservices.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5729, 136639, 'Scud Communication Pvt Ltd', 'scudcommunication.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(5730, 136642, 'Aerocast Networks Private Limited', 'aerocast.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5731, 136643, 'Net-raj Technology Pvt Ltd Opc', 'uninet.co.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5732, 136644, 'Unborn Networks Private Limited', 'unborn.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5733, 136645, 'Linkup Networks Pvt Ltd', 'linkupnetworks.in', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(5734, 136646, 'Shikhar Broadband Enterprises Pvt Ltd', 'instanet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5735, 136648, 'India International Exchange Ifsc Limited', 'indiainx.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5736, 136649, 'Sri Ram Broadband Services Pvt Ltd', 'irinn.in', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5737, 136651, 'Dronagiri Infotech Pvt Ltd', 'dronagirigroup.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5738, 136652, 'Bytel TraNet Private Limited', 'bytel.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5739, 136654, 'Krishna Broadband', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5740, 136655, 'Kiri Infotech Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5741, 136656, 'Jharkhand Agency For Promotion Of Information Technology', 'jharkhandmail.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5742, 136657, 'Mv Net Solutions Pvt. Ltd', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5743, 136659, 'Itec Department, Government Of Telangana', 'telangana.gov.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5744, 13666, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 2048, 'isp', '1999-07-27 00:00:00', 0),
(5745, 136664, 'D D Telecom Pvt. Ltd', 'irinn.in', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5746, 136665, 'Ell Innovations Pvt Ltd', 'ellinnovations.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5747, 136666, 'IL & FS Education And Technology Services Ltd', 'ilfsindia.com', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(5748, 136667, 'Space Applications Centre', 'isro.gov.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5749, 136669, 'Steel City Securities Limited', 'steelcitynettrade.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5750, 136670, 'Skyline Broadband Pvt. Ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5751, 136671, 'Osbnet Broadband Pvt Ltd', 'osbnet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5752, 136672, 'Galactica Infotel Private Limited', 'galactica.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5753, 136673, 'Redking India It Services Private Limited', 'redkingindiait.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5754, 136674, 'Dmp Internet Services Private Limited', 'None', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(5755, 136675, 'Avois Networks Private Liimited', 'None', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5756, 136676, 'KAD-SYSCON INFOTECH PRIVATE LIMITED', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(5757, 136677, 'Basak Telecom Private Limited', 'basaktelecom.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5758, 136679, 'Ge India Technology Center Pvt. Ltd.', 'ge.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5759, 136680, 'Bank Of Maharashtra', 'bankofmaharashtra.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5760, 136682, 'NETWIRE INTERNET SOLUTIONS PVT LTD', 'vertax.co.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5761, 136683, 'Bqe Kashmir', 'bqe.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5762, 136684, 'White Stallion Networks Pvt Ltd', 'getnet.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5763, 136685, 'Computer Age Management Services Pvt. Ltd.', 'camsonline.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(5764, 136688, 'Datamax Technologiespvt Ltd', 'datamaxtechnologies.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5765, 136690, 'Sath Technologies Pvt Ltd', 'sathtechnologies.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5766, 136692, 'Nomura Research Institute Financial Technologies India Pvt. Ltd', 'anshinsoft.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5767, 136696, 'Sifi Online Pvt Ltd', 'sifibroadband.in', 'IN', 4352, 'isp', '0000-00-00 00:00:00', 0),
(5768, 136697, 'In Broadband Private Limited', 'inbroadband.net', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5769, 136698, 'Devdarpan Broadband Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5770, 136699, 'Mediatech Communication Pvt.ltd.', 'mtcnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5771, 136700, 'Sefaro Networks Private Limited', 'sefaronetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5772, 136701, 'National Highways Authority Of India', 'nhai.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5773, 136702, 'Physical Research Laboratory', 'prl.res.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5774, 136704, 'Apex Broadband Network Pvt. Ltd.', 'apexbroadband.in', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5775, 136705, 'Webstar Broadband Private Limited', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5776, 136706, 'Dhanam Internet Services India Private Limited', 'dhanam.net.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(5777, 136707, 'The Kalupur Commercial Co-operative Bank Limited', 'kalupurbank.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5778, 136708, 'F2h Networks Pvt Ltd', 'f2hnetworks.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5779, 13671, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 512, 'isp', '1999-07-27 00:00:00', 0),
(5780, 136710, 'Srushti Broadband And Internet Services Pvt. Ltd.', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(5781, 136711, 'Softech Studio', 'softechstudio.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5782, 136712, 'Gps Connections Pvt Ltd', 'gpsconnection.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(5783, 136713, 'Xd Network', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5784, 136714, 'Stampede Communications Pvt. Ltd.', 'stampedecom.in', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(5785, 136715, 'Datasoft Comnet Pvt Ltd', 'datasoftcomnet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5786, 136716, 'APPLE BROADBAND SERVICES PVT. LTD', 'lsbroadband.com', 'IN', 3840, 'business', '0000-00-00 00:00:00', 0),
(5787, 136719, 'Anushree Digital Network Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5788, 13672, 'FAIRPOINT COMMUNICATIONS, INC.', 'fairpoint.com', 'US', 91392, 'isp', '2008-10-06 00:00:00', 0),
(5789, 136720, 'Airtechzone Services India Pvt Ltd', 'airtechzone.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5790, 136721, 'Pal Digital Networking Pvt. Ltd.', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5791, 136722, 'Sai Technix Pvt. Ltd.', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(5792, 136723, 'Kartik Network Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5793, 136724, 'Praction Networks Pvt Ltd', 'praction.in', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(5794, 136726, 'NATIXIS', 'natixis.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(5795, 13673, 'FAIRPOINT COMMUNICATIONS, INC.', 'fairpoint.com', 'US', 1280, 'isp', '2008-10-06 00:00:00', 0),
(5796, 136730, 'INTERMARKET SECURITIES LIMITED', 'imsecurities.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(5797, 136731, 'Invotec Solutions', 'invotec.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5798, 136732, 'Yellow Net & Cyber Cafe', 'yellownetbd.com', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5799, 136733, 'Racks Central Pte Ltd', 'rackscentral.com', 'SG', 1280, 'business', '0000-00-00 00:00:00', 0),
(5800, 136734, 'Smart Telecom Pvt. Ltd', 'smarttel.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5801, 136735, 'DataKnox Pty Limited', 'dataknox.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(5802, 136736, 'IBT CO LTD', 'imbkt.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(5803, 136737, 'Rajamangala University of Technology Krungtep', 'uni.net.th', 'TH', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5804, 136738, 'Dhaka Power Distribution Company Limited', 'dpdc.org.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5805, 136739, 'Bashistha Kebal Net Pvt. Ltd.', 'None', 'NP', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5806, 136741, 'Channel Wireless Pty Ltd', 'channelwireless.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5807, 136743, 'Internet Keeper Global (Group) Co., Limited', 'ik.com', 'HK', 23552, 'hosting', '0000-00-00 00:00:00', 0),
(5808, 136744, 'DREAM POWER TECHNOLOGY LIMITED', 'dreampower.hk', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(5809, 136745, 'Sheikh Sadeque Ali t/a DIGISOFT', 'digisoft.asia', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5810, 136746, 'XRCLOUD.NET INC.', 'xrcloud.net', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(5811, 136748, 'Etern Laos Communication Technology Sole Co .,Ltd', 'eternlaos.com', 'LA', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5812, 136749, 'KS IT SOLUTIONS SDN BHD', 'ks-itsolutions.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(5813, 136753, 'Anglican Schools Corporation', 'tasc.nsw.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(5814, 136757, 'Fourier Technologies Pty Ltd', 'fourier.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5815, 136758, 'ShenZhen Century-One Limited', 'centuryone.net', 'CN', 1280, 'business', '0000-00-00 00:00:00', 0),
(5816, 136759, 'Cosmopolitan Communications Limited', 'cosmocom.net', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(5817, 13676, 'Imagination, Inc.', 'imagination.com', 'US', 8960, 'isp', '1999-07-27 00:00:00', 0),
(5818, 136760, 'Creative Networks', 'creativenetworks.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5819, 136763, 'Unified Communication Private Limited', 'unicom.net.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5820, 136764, 'Fast CDN', 'fastcdn.tech', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(5821, 136765, 'Desh Online', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(5822, 136766, 'ROBLOX (SHENZHEN) DIGITAL SCIENCE AND TECHNOLOGY CO., LTD', 'roblox.com', 'CN', 512, 'isp', '0000-00-00 00:00:00', 0),
(5823, 136769, 'WingTecJapan G.K', 'wingtecjapan.com', 'JP', 768, 'business', '0000-00-00 00:00:00', 0),
(5824, 136770, 'Liquid Knowledge Group (LKG) Pty Ltd', 'lkgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5825, 136771, 'WILDERWIND PTY LTD', 'wilderwind.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5826, 136772, 'DASSAULT SYSTEMES AUSTRALIA PTY LTD', '3ds.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(5827, 136773, 'BDO Unibank Inc', 'bdo.com.ph', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(5828, 136774, 'Western Australian Electoral Commission', 'waec.wa.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5829, 136777, '247 Customer Philippiness inc', '247-inc.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5830, 136779, 'Schneider Electric Japan Ltd', 'schneider-electric.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(5831, 136780, 'MYANMAR INFORMATION HIGHWAY LIMITED', 'mih.com.mm', 'MM', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5832, 136781, 'Department of Alternative Energy Development and Efficiency', 'dede.go.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(5833, 136782, 'Kirin Networks', 'kirinnetworks.com', 'JP', 5632, 'hosting', '0000-00-00 00:00:00', 0),
(5834, 136783, 'Spectrum Life Company Limited', 'spectrumlife.net', 'MM', 768, 'business', '0000-00-00 00:00:00', 0),
(5835, 136784, 'Valve Networks Pty Ltd', 'valvenetworks.com.au', 'AU', 1280, 'isp', '0000-00-00 00:00:00', 0),
(5836, 136785, 'TOFFS TECHNOLOGIES PTE LTD', 'toffstech.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(5837, 136786, 'Information Beam Company Limited', 'informationbeam.net', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(5838, 136787, 'TEFINCOM S.A.', 'nordvpn.com', 'PA', 2816, 'isp', '0000-00-00 00:00:00', 0),
(5839, 136788, 'Pier Alpha Connect Pty Ltd', 'pieralphaconnect.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5840, 13679, 'Centros Culturales de Mexico, A.C.', 'up.edu.mx', 'MX', 768, 'education', '1999-07-27 00:00:00', 0),
(5841, 136792, 'Mimecast Australia Pty Ltd', 'mimecast.com', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(5842, 136794, 'Agricultural Development Bank Ltd', 'adbl.gov.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(5843, 136795, 'Nova Energy LTD', 'novaenergy.co.nz', 'NZ', 6144, 'isp', '0000-00-00 00:00:00', 0),
(5844, 136798, 'WUZHOUHULIAN INTERNATIONAL CO., LIMITED', 'wuzhouhulian.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(5845, 136800, 'ICIDC NETWORK', 'jvniu.com', 'HK', 412160, 'hosting', '0000-00-00 00:00:00', 0),
(5846, 136803, 'TELMARC CORPORATION', 'telmarccable.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(5847, 136804, 'Wireless Innovation Pty Ltd', 'wirelessinnovation.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5848, 136805, 'Next Generation Voice PTY LTD', 'ngvemail.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5849, 136806, 'Texas Instruments, Inc', 'ti.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(5850, 136808, 'One Bank Limited', 'onebank.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5851, 136810, 'SOUTHERN CROSS COMPUTER SYSTEMS PTY. LTD.', 'sxiq.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(5852, 136813, 'NCC Bank, Bangladesh', 'nccbank.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5853, 136814, 'BMC Software India Pvt. Ltd.', 'bmc.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5854, 136815, 'Md. Moniruzzaman (Rocky) trading as Jhenaidah Broadband & Cyber Point', 'jbcpbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5855, 136818, 'Netlogyx Technology Specialists Pty Ltd', 'netlogyx.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5856, 136819, 'Global Traffic Network Inc', 'trafficnet.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5857, 13682, 'Telgua', 'claro.com.gt', 'GT', 41472, 'isp', '1999-07-27 00:00:00', 0),
(5858, 136820, 'PT. LISAR INTERNATIONAL NETWORKING', 'apjii.or.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5859, 136821, 'PT TRIMEDIA SETIYA DATA', 'setiyadata.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5860, 136822, 'Politeknik Pertanian Negeri Payakumbuh', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5861, 136823, 'PT. Arka Data Primatama', 'arkatel.net', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5862, 136824, 'PT RACKH LINTAS ASIA', 'rackh.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5863, 136825, 'PT Indonesia Super Corridor', 'isc.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(5864, 136827, 'Universitas PGRI Semarang', 'upgris.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(5865, 136828, 'Universitas Bina Darma Palembang', 'binadarma.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5866, 136829, 'Dinas Kominfo Kota Pekalongan', 'pekalongankota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5867, 13683, 'Auto-Wares Inc', 'auto-wares.com', 'US', 256, 'business', '2005-12-06 00:00:00', 0),
(5868, 136830, 'PT ASURANSI JIWA MANULIFE INDONESIA', 'manulife-indonesia.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5869, 136831, 'DINAS KOMUNIKASI DAN INFORMATIKA KUTAI KARTANEGARA', 'kutaikartanegarakab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5870, 136832, 'PT. Docotel Teknologi', 'indonet.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5871, 136833, 'UNIVERSITAS MUHAMMADIYAH SEMARANG', 'unimus.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5872, 136834, 'POLITANI Pangkep', 'polipangkep.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5873, 136835, 'PT. GLobal Intermedia Nusantara', 'gi.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5874, 136836, 'PT Seameo Biotrop', 'biotrop.org', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5875, 136837, 'Universitas Muhammadiyah Palembang', 'um-palembang.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(5876, 136838, 'PT BIT TEKNOLOGI NUSANTARA', 'bit-teknologi.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5877, 136839, 'STMIK AKAKOM', 'akakom.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5878, 13684, 'Medtronic, Incorporated', 'medtronic.com', 'US', 67072, 'business', '1999-07-27 00:00:00', 0),
(5879, 136840, 'PT. Graha Lintas Nusantara', 'graha.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5880, 136841, 'PT MITRA TELEMEDIA MANUNGGAL', 'mtmbali.com', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5881, 136842, 'PEMERINTAH PROVINSI PAPUA', 'papua.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5882, 136843, 'Dinas Komunikasi dan Informatika Pemerintah Kota Semarang', 'semarangkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5883, 136844, 'PT. VERBIND INTERNET SOLUSINDO', 'verbind.co', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5884, 136845, 'PT Apik Media Inovasi', 'apik.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5885, 136847, 'PT. Alif Investama Teknologi Indonesia', 'aliftama.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(5886, 136849, 'Kantor Dispenda Kota Batam', 'metadata.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5887, 13685, 'Neways Worldwide Inc.', 'neways.com', 'US', 256, 'business', '2009-01-23 00:00:00', 0),
(5888, 136850, 'PT. RUMAH TEKNOLOGI', 'rumahteknologi.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5889, 136851, 'PT ARDETAMEDIA GLOBAL KOMPUTINDO', 'colo.co.id', 'ID', 768, 'hosting', '0000-00-00 00:00:00', 0),
(5890, 136852, 'PT Diginet Media', 'diginetmedia.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5891, 136853, 'Universitas Muhammadiyah Magelang', 'ummgl.ac.id', 'ID', 1024, 'education', '0000-00-00 00:00:00', 0),
(5892, 136854, 'PT. PALAPA RING BARAT', 'moratelindo.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5893, 136855, 'PT.PERSADA KARYA LESTARI MANDIRI', 'perkalesman.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5894, 136856, 'PT. Tower Bersama', 'bersama.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5895, 136857, 'PT. ASURANSI JIWA INHEALTH INDONESIA', 'mandiriinhealth.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5896, 136858, 'PT XL Planet', 'elevenia.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5897, 13686, 'AEG', 'aegworldwide.com', 'US', 256, 'business', '2012-04-26 00:00:00', 0),
(5898, 136861, 'PT. ARTAMEDIA CITRA TELEMATIKA INDONESIA', 'artamedianet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5899, 136862, 'DINAS KOMUNIKASI DAN INFORMATIKA KOTA SERANG', 'serangkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5900, 136864, 'PT Kalla Inti Karsa', 'kallaproperty.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5901, 136865, 'PT. GLOBAL MEDIA REMBANG', 'globalmedia.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5902, 136866, 'Institut Seni Indonesia Surakarta', 'isi-ska.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5903, 136867, 'PT. Teltranet Aplikasi Solusi (Telkomtelstra)', 'telkomtelstra.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5904, 136868, 'PT. Terasys Virtual', 'terasys.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5905, 136869, 'PT. LIMA MENARA BINTANG', '5mb.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5906, 136871, 'Institut Teknologi Nasional', 'itny.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5907, 136872, 'PT Global Digital Niaga', 'gdn-commerce.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5908, 136873, 'PT. MEGA ARTHA LINTAS DATA', 'megadata.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5909, 136874, 'PT. Garuda Media Telematika', 'garuda.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5910, 136875, 'PT Solusi Inforindo Prima', 'si-prima.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5911, 136876, 'PEMERINTAH KABUPATEN BANYUMAS', 'banyumaskab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5912, 136877, 'PT Visionet Data Internasional', 'visionet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5913, 136878, 'PT. InfoMedia Solusi Net', 'isolusinet.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5914, 136879, 'PT. Media Jaringan Indonesia', 'jarindo.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5915, 13688, 'Public Service Enterprise Group', 'pseg.com', 'US', 67840, 'business', '1999-07-27 00:00:00', 0),
(5916, 136880, 'PT. Sumatra Multimedia Solusi', 'smsnet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5917, 136881, 'PT Permodalan Nasional Madani', 'pnm.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5918, 136883, 'Universitas Nahdlatul Ulama Surabaya', 'unusa.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(5919, 136884, 'Dinas Komunikasi dan Informatika Provinsi jawa timur', 'jatimprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5920, 136885, 'PT BINTANG MATARAM TEKNOLOGI', 'bimatek.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(5921, 136886, 'INSTITUT AGAMA ISLAM NEGERI TULUNGAGUNG', 'iain-tulungagung.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(5922, 136887, 'PT METRASAT', 'metrasat.co.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(5923, 136888, 'PT Petro One Indonesia', 'petro1-indonesia.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(5924, 136889, 'DINAS KOMUNIKASI DAN INFORMATIKA KABUPATEN SIDOARJO', 'sidoarjokab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(5925, 136890, 'TAAL Tech', 'taaltech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5926, 136892, 'BGC Limited', 'rackspace.com', 'SG', 4096, 'hosting', '0000-00-00 00:00:00', 0),
(5927, 136894, 'TASEC Limited', 'tasec.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5928, 136895, 'YHA Ltd', 'yha.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5929, 136897, 'Enjoyvc Cloud Group Limited.', 'enjoyvc.com.hk', 'HK', 11008, 'isp', '0000-00-00 00:00:00', 0),
(5930, 136899, 'PhoenixNAP', 'phoenixnap.com', 'US', 512, 'isp', '0000-00-00 00:00:00', 0),
(5931, 13690, 'American Medical Response, Inc.', 'amr.net', 'US', 1792, 'business', '2005-12-07 00:00:00', 0),
(5932, 136900, 'IQ NET (NSW) PTY LTD', 'iqnet.com.au', 'AU', 2560, 'business', '0000-00-00 00:00:00', 0),
(5933, 136901, 'Bangladesh Telecommunication Regulatory Commission (BTRC)', 'btrc.gov.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(5934, 136902, 'Alegra Communication Private Limited', 'alegragoa.com', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(5935, 136903, 'Planet Information Technology Solution Ltd.', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(5936, 136904, 'Honeywell Pte Ltd', 'honeywell.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(5937, 136907, 'HUAWEI CLOUDS', 'huawei.com', 'HK', 123392, 'hosting', '0000-00-00 00:00:00', 0),
(5938, 136908, 'Sky Broadband Pvt. Ltd', 'skybroadband.com.np', 'NP', 2048, 'business', '0000-00-00 00:00:00', 0),
(5939, 136909, 'MJL Bangladesh Limited', 'mobilbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5940, 13691, 'Metropolitan Community College', 'mcckc.edu', 'US', 1280, 'education', '2005-12-07 00:00:00', 0),
(5941, 136910, 'MD. JAKIR HOSSAIN T/A Techno One Line', 'technoonbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5942, 136911, 'Asian University for Women', 'auw.edu.bd', 'BD', 256, 'education', '0000-00-00 00:00:00', 0),
(5943, 136912, 'THE COUNCIL OF THE KING\'S SCHOOL', 'kings.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(5944, 136913, 'Position Partners Pty Ltd', 'positionpartners.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5945, 136915, 'Outer Rim Entertainment', 'outerrimentertainment.com', 'US', 2048, 'business', '0000-00-00 00:00:00', 0),
(5946, 136917, 'IFRA NETWORK', 'ifranetwork.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5947, 136919, 'FACE24 Co.,Ltd', 'rogerquest.com', 'MM', 768, 'business', '0000-00-00 00:00:00', 0),
(5948, 13692, 'Douglas FastNet', 'douglasfast.net', 'US', 37120, 'isp', '2005-12-07 00:00:00', 0),
(5949, 136920, 'Gardamor, Lda', 'None', 'TL', 256, 'isp', '0000-00-00 00:00:00', 0),
(5950, 136921, 'Fiji National University', 'fnu.ac.fj', 'FJ', 256, 'education', '0000-00-00 00:00:00', 0),
(5951, 136924, 'SEVENTH-DAY ADVENTIST CHURCH (SPD) LIMITED', 'adventist.org', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5952, 136925, 'SCS Super Pty. Limited', 'catholicsuper.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5953, 136926, 'Knoah Solutions Pvt. Ltd.', 'knoah.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(5954, 13693, 'NTS Communications', 'ntscom.com', 'US', 59136, 'isp', '1999-07-27 00:00:00', 0),
(5955, 136931, 'CSL Limited', 'csl.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5956, 136932, 'Havells India Limited', 'havells.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(5957, 136933, 'Gigabitbank Global', 'gigabitbank.com', 'HK', 16640, 'hosting', '0000-00-00 00:00:00', 0),
(5958, 136934, 'Bank Of Ceylon', 'boc.lk', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(5959, 136935, 'System Resources Ltd.', 'srl.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5960, 136936, 'ArigBank LLC', 'arigbank.mn', 'MN', 256, 'business', '0000-00-00 00:00:00', 0),
(5961, 136937, 'Chittagong University of Engineering & Technology', 'cuet.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(5962, 13694, 'Xecunet, LLC.', 'xecu.net', 'US', 12288, 'business', '1999-07-27 00:00:00', 0),
(5963, 136940, 'ComSat Ltd', 'comsat.com', 'PG', 512, 'business', '0000-00-00 00:00:00', 0),
(5964, 136941, 'Unicom Multi System', 'unicommultisystem.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(5965, 136942, 'Elite Computer, LDA', 'elitedili.tl', 'TL', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5966, 136946, 'Weebo networks Pvt Ltd', 'weebo.co.in', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(5967, 136948, 'ICC-FENI', 'todayvisionbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(5968, 13695, 'American Electirc Power Co.', 'aep.com', 'US', 131328, 'business', '1999-07-27 00:00:00', 0),
(5969, 136950, 'Hong Kong FireLine Network LTD', 'fireline.com.hk', 'HK', 8704, 'hosting', '0000-00-00 00:00:00', 0),
(5970, 136951, 'Hospharm Pty Ltd', 'hps.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(5971, 136953, 'VOIP HQ LIMITED', 'voiphq.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5972, 136954, 'Shahin Enterprises Pty Ltd', 'peregrine.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5973, 136955, 'SHMJSWZXYXGS-CN', 'mujiworks.com', 'PH', 2560, 'business', '0000-00-00 00:00:00', 0),
(5974, 136956, 'Assistive Networks and technologies Pvt Ltd', 'assistivenetwork.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(5975, 136957, 'CME Asia Sdn. Bhd', 'cmeasia.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(5976, 136958, 'China Unicom Guangdong IP network', 'chinaunicom.cn', 'CN', 230656, 'isp', '0000-00-00 00:00:00', 0),
(5977, 136959, 'China Unicom Guangdong IP network', 'chinaunicom.cn', 'CN', 26112, 'isp', '0000-00-00 00:00:00', 0),
(5978, 136960, 'Crombie Lockwood (NZ) Limited', 'crombielockwood.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(5979, 136961, 'Apollo Global Corporation', 'apolloglobal.net', 'PH', 2304, 'business', '0000-00-00 00:00:00', 0),
(5980, 136962, 'Egixnet Networks Limited', 'egixnet.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(5981, 136963, 'QuintilesIMS', 'imshealth.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(5982, 136964, 'RAPIDNET SOLUTIONS LIMITED', 'rapidnetsol.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(5983, 136965, 'IT Live Ltd', 'itlive.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(5984, 136966, 'Bottle Communications Pty Ltd', 'bcomm.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(5985, 136968, 'SingAREN', 'singaren.net.sg', 'SG', 256, 'education', '0000-00-00 00:00:00', 0),
(5986, 136969, 'KK Networks (Pvt) Ltd.', 'kknetworks.com.pk', 'PK', 6144, 'isp', '0000-00-00 00:00:00', 0),
(5987, 13697, 'Saber Healthcare Group LLC', 'saberhealth.com', 'US', 256, 'business', '2013-05-28 00:00:00', 0),
(5988, 136970, 'YISU CLOUD LTD', 'yisu.com', 'HK', 8704, 'hosting', '0000-00-00 00:00:00', 0),
(5989, 136971, 'Wyndham City Council', 'wyndham.vic.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5990, 136972, 'Gigafy', 'gigafy.com.au', 'AU', 1536, 'isp', '0000-00-00 00:00:00', 0),
(5991, 136974, 'Technology Communications & Supplies (Private) Limited', 'tcs.com.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(5992, 136975, 'Global Technology', 'globalnet.com.mm', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(5993, 136976, 'WHITEHAVEN COAL LIMITED', 'whitehavencoal.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5994, 136977, 'Derivco Australia PTY LTD', 'derivco.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(5995, 136978, 'JNI SYSTEM SDN BHD', 'jnisystem.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(5996, 136979, 'SANIMA BANK LIMITED', 'sanimabank.com', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(5997, 13698, 'Shaw Industries Group, Inc.', 'shawfloors.com', 'US', 1536, 'business', '1999-07-28 00:00:00', 0),
(5998, 136980, 'THE CO-OPERATIVE BANK LIMITED', 'co-operativebank.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(5999, 136982, 'Integranet Network Services', 'integranet.ph', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6000, 136983, 'HILTI ASIA IT SERVICES SDN. BHD.', 'hilti.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(6001, 136985, 'Religare Broking Limited', 'religare.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6002, 136986, 'Cyber Net ISP', 'cnet.af', 'AF', 256, 'business', '0000-00-00 00:00:00', 0),
(6003, 136987, 'Vodafone India Services Private Ltd', 'vodafone.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6004, 136988, 'LEASEWEB AUSTRALIA PTY LIMITED', 'leaseweb.com', 'AU', 3840, 'hosting', '0000-00-00 00:00:00', 0),
(6005, 13699, 'SWF Associates in Podiatric Medicine & Surgery', 'anklefootfl.com', 'US', 256, 'business', '2012-07-03 00:00:00', 0),
(6006, 136990, 'Inland Revenue Department', 'ird.govt.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(6007, 136993, 'CLOUD VALLEY TECHNOLOGY LIMITED', 'yun-gu.com', 'HK', 6144, 'isp', '0000-00-00 00:00:00', 0),
(6008, 136994, 'Southern Phone Company Ltd', 'southernphone.com.au', 'AU', 21504, 'isp', '0000-00-00 00:00:00', 0),
(6009, 136998, 'POIPETINTERNET DOT COM', 'poipetinternet.com', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6010, 136999, 'SkyLink Broadband Internet', 'skylinkbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6011, 137, 'Consortium GARR', 'garr.it', 'IT', 2770944, 'isp', '2002-08-21 13:03:42', 0),
(6012, 13700, 'Millard Refrigerated Services, Inc', 'millardref.com', 'US', 256, 'business', '2011-01-19 00:00:00', 0),
(6013, 137001, 'OSOA Co.,LTD.', 'osoa.co.jp', 'JP', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6014, 137002, 'PT. FWD Life Indonesia', 'fwd.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6015, 137003, 'INSEAD', 'insead.edu', 'SG', 512, 'education', '0000-00-00 00:00:00', 0),
(6016, 137004, 'Netbeats Infoway Pvt. Ltd.', 'netbeats.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6017, 137005, 'Universiti Malaysia Kelantan', 'umk.edu.my', 'MY', 768, 'education', '0000-00-00 00:00:00', 0),
(6018, 137006, 'HAMBS Systems Ltd', 'hambs.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6019, 137008, '1120 Shimokuzawa Chuo-ku Sagamihara-shi Kanagawa-ken', 'gxs.com', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(6020, 13701, 'Benchmark Electronics Inc.', 'bench.com', 'US', 1280, 'business', '1999-07-29 00:00:00', 0),
(6021, 137011, 'Highland International Pvt Ltd', 'highland-international.com', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(6022, 137013, 'Manor IT Ltd', 'manor-it.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6023, 137014, 'Interwood Mobel Pvt Ltd', 'iwm.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6024, 137015, 'MOZ 2008 Corporation', 'mozilla.com', 'TW', 256, 'business', '0000-00-00 00:00:00', 0),
(6025, 137016, 'Enee Solutions Pty Ltd', 'enee.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6026, 137018, 'Blue Sky Cable Network', 'blueskycablenetwork.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6027, 137019, 'Indonesia NeuCentrIX', 'neucentrix.co.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(6028, 13702, 'Ingram Book Group', 'ingrambook.com', 'US', 1280, 'business', '1999-07-29 00:00:00', 0),
(6029, 137020, 'Fast Cyber Network', 'None', 'BD', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(6030, 137023, 'ASIAN CITY ONLINE BD LTD.', 'asiancitybd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6031, 137025, 'Port of Brisbane Pty Ltd', 'portbris.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6032, 137027, 'TI Infotech Pvt. Ltd.', 'tiinfotech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6033, 137028, 'Latte Solutions Limited', 'latte.net.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6034, 137029, 'Chittagong multi channel limited,', 'cmclbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6035, 137030, 'Jahirul Islam Kamal t/a IP LINK NETWORK', 'ip-linkisp.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6036, 137032, 'Iris Communications Pty Ltd', 'iriscommunications.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6037, 137033, 'RSM Network', 'rsmnetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6038, 137034, 'SA Online', 'saonlinebd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6039, 137036, 'The Bethanie Group Inc', 'bethanie.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6040, 137038, 'MD ZUBAIR ISLAM t/a ZUBAIR IT EXPERT', 'zubairitexpert.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6041, 137039, 'Zohak Technology (Z-Tech)', 'zohakvillage.com', 'AF', 512, 'business', '0000-00-00 00:00:00', 0),
(6042, 137040, 'Network Zone Solution Provider Ltd', 'networkzonesolution.com', 'AF', 1024, 'business', '0000-00-00 00:00:00', 0),
(6043, 137041, 'HiFiServer Technologies Datacenter (Server Group)', 'servergroup.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6044, 137042, 'Readiitel Pty Ltd', 'readiitel.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6045, 137044, 'VICTORIA AMATEUR TURF CLUB (INCORPORATING) THE MELBOURNE RACING', 'racing.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6046, 137045, 'Athoy Cyber Net', 'None', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(6047, 137047, 'TELECOMMUNICATION AND TECHNOLOGY MASTERS (PVT.) LIMITED', 'telcomaster.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6048, 137048, 'X-LINK LIMITED', 'xlinkbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6049, 137049, 'Mohammad Faizul Hamid t/a CloudWell Limited', 'cloudwell.co', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6050, 137050, 'strateq data centre sdn bhd', 'strateqgroup.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(6051, 137051, 'Gen2 Consulting Limited', 'gen2.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(6052, 137052, 'NZX Limited', 'nzx.com', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(6053, 137054, 'Thorn Australia T/A Radio Rentals', 'thorn.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6054, 137056, 'Tree Top Health Pvt. Ltd.', 'treetophospital.com', 'MV', 256, 'business', '0000-00-00 00:00:00', 0),
(6055, 137057, 'A.A. Company Pty Ltd', 'aaco.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6056, 137058, 'Aeronautical Radio of Thailand Ltd.', 'aerothai.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(6057, 137059, 'Easy Net', 'easynetwireless.net', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6058, 13706, 'CompleteWeb.Net LLC', 'completeweb.net', 'US', 9216, 'business', '1999-08-02 00:00:00', 0),
(6059, 137060, 'The Club Group Canberra Australia', 'clubgroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6060, 137061, 'Flex Ltd.', 'flex.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(6061, 137065, 'Adello Group AG', 'adello.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6062, 137067, 'Flashnet Enterprise', 'flashnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6063, 137070, 'Nationwide Towing & Transport Pty Ltd', '134tow.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6064, 137071, 'GO Markets Pty Ltd', 'gomarkets.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6065, 137073, 'THE TRUSTEES OF THE SYDNEY GRAMMAR SCHOOL', 'sydgrammar.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6066, 137074, 'Responsible Internet Sustainability Effort', 'rise.ph', 'PH', 768, 'business', '0000-00-00 00:00:00', 0),
(6067, 137077, 'VU Mobile Limited', 'vumobile.biz', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6068, 137079, 'Melbourne Internet Service Provider', 'melbourneisp.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6069, 137080, 'Firstlink Communications Pvt. Ltd.', 'firstlink.net.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6070, 137083, 'Mnk Infoway Private Limited', 'mnkinfoway.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6071, 137084, 'Sense Connect It Pvt Ltd', 'senseconnectit.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6072, 137085, 'Ani Broadband Service Pvt Ltd', 'anibroadbandservice.com', 'IN', 8448, 'isp', '0000-00-00 00:00:00', 0),
(6073, 137087, 'Sb Networks', 'sbnetworks.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6074, 137088, 'Shiva Broadband Services Pvt Ltd', 'sbsplhapur.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6075, 137092, 'Blue Eagle Infotech', 'blueeagleindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6076, 137093, 'Arjun Infotech', 'None', 'IN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(6077, 137095, 'Dm Lot Infotech Solutions Private Limited', 'dmlot.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6078, 137096, 'Rvr Fibernet Pvt Ltd', 'rvrfibernet.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6079, 137098, 'Delix Net Solution Pvt. Ltd', 'delix.in', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(6080, 137099, 'Dinhata Smartnet Internet Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6081, 13710, 'Systems & Methods, Inc.', 'smi-inc.com', 'US', 512, 'business', '1999-08-03 00:00:00', 0),
(6082, 137100, 'Netmax Broadband Services', 'None', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6083, 137101, 'RENU TECHNOLOGIES', 'renuonline.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6084, 137102, 'Hustel Telecom Pvt. Ltd.', 'hustel.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6085, 137104, 'India Post Payments Bank Limited', 'ippbonline.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6086, 137106, 'Orsang Infotech Private Limited', 'orsang.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6087, 137107, 'Jtm Internet Private Limited', 'jtminternet.com', 'IN', 2048, 'business', '0000-00-00 00:00:00', 0),
(6088, 137108, 'Bank Of India', 'bankofindia.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6089, 137109, 'Grace Teleinfra Pvt Ltd', 'graceteleinfra.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6090, 137110, 'Asknet Internet Service', 'None', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(6091, 137111, 'Ernst And Young Llp', 'ey.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6092, 137112, 'Shreyashi Infotech Pvt Ltd', 'shreyashiinfo.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6093, 137113, 'Simplex Broadband Pvt.ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6094, 137115, 'Indian Financial Technology And Allied Services', 'iftas.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6095, 137116, 'Shriju Computer Center', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6096, 137117, 'AIRWAVES INTERNET', 'airwavesinternet.com', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6097, 137118, 'Sparklink Net Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6098, 13712, 'Saint Marys University of Minnesota', 'smumn.edu', 'US', 16384, 'education', '1999-08-03 00:00:00', 0),
(6099, 137121, 'Oment Broadband Services Private Limited', 'omnetbroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6100, 137123, 'Maxcon Solution Pvt. Ltd.', 'maxconsolution.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6101, 137124, 'Jai Mata Di Telectronix Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6102, 137125, 'Netsat Communications Private Limited', 'netsat.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6103, 137126, 'Sandhu Infotech Pvt. Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6104, 137128, 'Bitsandbytes Isp Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6105, 137129, 'Angrow Netcomm Pvt. Ltd', 'angrow.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6106, 13713, 'Arcot Systems', 'arcot.com', 'US', 2816, 'business', '2010-12-09 00:00:00', 0),
(6107, 137130, 'Punjab National Bank', 'pnbindia.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6108, 137131, 'Dnet E Solutions Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6109, 137132, 'High Speed Broadband', 'myhsb.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6110, 137133, 'Billa Broadband Network Pvt Ltd', 'bbnl.ooo', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6111, 137134, 'Triple Play Broadband Services India Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6112, 137135, 'Pc Care Airway Infratel Private Limited', 'airwaybroadband.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6113, 137136, 'Indian Agricultural Statistics Research Institute', 'icar.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6114, 137138, 'S A Internet Solution Pvt Ltd', 'sanetwork.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6115, 137139, 'Cybernet Introtech Private Limited', 'None', 'IN', 2560, 'isp', '0000-00-00 00:00:00', 0),
(6116, 13714, 'Afilias, Inc.', 'afilias.info', 'US', 256, 'business', '2007-05-16 00:00:00', 0),
(6117, 137142, 'Rk Broadband Hifi Services Pvt Ltd', 'rkbroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6118, 137143, 'Minnal Digital Network Private Limited', 'minnaldigital.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6119, 137144, 'Passit Media And Communication Pvt. Ltd.', 'passitmedia.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6120, 137145, 'Light Wave Digital Network Private Limited', 'lightwaveindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6121, 137146, 'Achiever Communication And Services Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6122, 137147, 'Nextgen Compusoft Pvt. Ltd.', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6123, 137149, 'Nj Indiainvest Pvt. Ltd.', 'njgroup.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6124, 13715, 'Upsher-Smith Laboratories Inc.', 'upsher-smith.com', 'US', 256, 'business', '2013-05-17 00:00:00', 0),
(6125, 137150, 'Wingsnet Internet Pvt. Ltd.', 'wingsnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6126, 137151, 'Greenworld Netcast Private Limited', 'irinn.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6127, 137152, 'Ap Netcom Services', 'irinn.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6128, 137153, 'Optisky Fibernet Private Limited', 'skyfibernet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6129, 137154, 'Skyonline Technosystem Private Limited', 'skyonline.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6130, 137155, 'Devyani International Limited', 'dil-rjcorp.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6131, 137156, 'Blueberry Web - Solutions Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6132, 137158, 'A-net Communication India Pvt.ltd', 'airnetcom.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6133, 137159, 'Maruthi Cable And Data Private Limited', 'maruthibroadband.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6134, 13716, 'Alight Solutions LLC', 'alight.com', 'US', 4096, 'business', '1999-08-04 00:00:00', 0),
(6135, 137160, 'Unitel Media Pvt Ltd', 'unitelmedia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6136, 137162, 'Indrayani Communication Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6137, 137163, 'Quality Broadband Pvt Ltd', 'qualitynet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6138, 137165, 'Net9online Hathway Pvt. Ltd', 'net9online.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6139, 137166, 'DSCONNPT-AS', 'digitalsatellite.in', 'IN', 6400, 'isp', '2020-07-04 00:00:00', 0),
(6140, 137167, 'Cherri Technologies', 'cherritech.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6141, 137169, 'Speedmaxx Digital Networks Pvt Ltd', 'speedmaxx.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6142, 13717, 'Energizer Brands LLC', 'energizer.com', 'US', 12032, 'business', '1999-08-04 00:00:00', 0),
(6143, 137171, 'Tabnet Solutions Pvt. Ltd.', 'tabnet.solutions', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6144, 137172, 'Supersonic Isp Connectivity India Pvt Ltd', 'supersonicbroadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6145, 137173, 'Ipinfusion Software India Pvt Ltd', 'ipinfusion.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6146, 137174, 'Airwire Infocom Private Limited', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(6147, 137176, 'The Clearing Corporation Of India Limited', 'ccilindia.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6148, 137178, 'Invensys Netrworks Pvt. Ltd.', 'invensysnetworks.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6149, 13718, 'SOLUS ALTERNATIVE ASSET MANAGEMENT LP', 'soluslp.com', 'US', 256, 'business', '2007-07-30 00:00:00', 0),
(6150, 137180, 'Unified Voice Communication Private Ltd', 'unifiedvoice.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6151, 137181, 'Windsor Internet Private Limited', 'in.net', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(6152, 137182, 'BLUE WIRELESS PTE LTD', 'bluewireless.asia', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(6153, 137184, 'Suniway Group of Companies Inc.', 'suniway.net', 'PH', 2304, 'isp', '0000-00-00 00:00:00', 0),
(6154, 137187, 'WorldLink Communications', 'worldlink.com.np', 'NP', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6155, 137188, 'Australian Catholic University Limited', 'acu.edu.au', 'AU', 4096, 'education', '0000-00-00 00:00:00', 0),
(6156, 137189, 'Bornil Networks System Limited', 'bnslbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6157, 13719, 'ShoreTel Inc.', 'shoretel.com', 'US', 256, 'business', '2012-09-25 00:00:00', 0),
(6158, 137191, 'Couponz villa', 'couponzvilla.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6159, 137192, 'BIDFOOD AUSTRALIA LIMITED', 'bidfood.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6160, 137194, 'Zuora Inc', 'zuora.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(6161, 137195, 'Pak Wifi Private Limited', 'pakwifi.com.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(6162, 137196, 'Hong Kong Airlines Limited', 'hkairlines.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6163, 137197, 'Shoily Cyber Garden', 'shoily.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6164, 137198, 'Phranakorn Rajabhat University', 'pnru.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(6165, 137199, 'Emerge Internet', 'emergeinternet.com.au', 'AU', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6166, 13720, 'Daybreak Game Company LLC', 'daybreakgames.com', 'US', 20224, 'business', '1999-08-05 00:00:00', 0),
(6167, 137204, 'The Bend Motorsport Park', 'thebend.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6168, 137206, 'TRUE MONEY (CAMBODIA) PLC', 'truemoney.com.kh', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(6169, 137207, 'Joint Universities Computer Centre Limited', 'jucc.edu.hk', 'HK', 1024, 'education', '0000-00-00 00:00:00', 0),
(6170, 137208, 'Muhammad Monirul Hassan t/a ASIA INTEL Communications', 'asiaintel-bd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6171, 137209, 'Allied Net Link Technology Pvt Ltd', 'ant.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6172, 137210, 'Pathibhara Network Pvt. Ltd.', 'pathibharanet.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6173, 137211, 'Jumio India Pvt. Ltd.', 'jumio.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6174, 137214, 'TECH DATA ADVANCED SOLUTIONS (ANZ) LIMITED', 'atscloud247.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6175, 137215, 'M-MEDIA CO., LTD.', 'mmedia.com.kh', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6176, 137217, 'BLUE STAR GROUP (NEW ZEALAND) LIMITED', 'bluestargroup.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6177, 137218, 'Kuaiyun Information Technology CO.Ltd.', 'zzidc.com', 'CN', 2048, 'business', '0000-00-00 00:00:00', 0),
(6178, 13722, 'Default Route, LLC', 'defaultroute.net', 'US', 1280, 'business', '2009-10-27 00:00:00', 0),
(6179, 137220, 'Texas Instruments, Inc', 'ti.com', 'US', 768, 'business', '0000-00-00 00:00:00', 0),
(6180, 137221, 'Standard Group Limited', 'standard-group.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6181, 137222, 'iSeek Data Centre', 'nixonnetworks.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6182, 137225, 'Renault Nissan Technology & Business Centre India Private Limited', 'rntbci.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6183, 137231, 'ekit.com Pty Ltd', 'ekit.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6184, 137232, 'Veridian Solutions Pty. Ltd.', 'veridian.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6185, 137234, 'Country Road Group Pty Ltd', 'countryroad.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6186, 137236, 'TURBOTECH CO., LTD.', 'turbotech.com', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6187, 137239, 'Fil Products Service Television Incorporated', 'filprod-dgte.ph', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6188, 13724, 'Massachusetts Financial Services', 'mfs.com', 'US', 512, 'business', '2006-02-09 00:00:00', 0),
(6189, 137240, 'Proxus Communications Sdn Bhd', 'proxus.com.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(6190, 137241, 'PibulSongkramRajabhat University', 'uni.net.th', 'TH', 768, 'isp', '0000-00-00 00:00:00', 0),
(6191, 137242, 'CMC MARKETS ASIA PACIFIC PTY LTD', 'cmcmarkets.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6192, 137243, 'INGENIERIE DES SYSTEMES DES INFORMATIONS', 'isi.nc', 'NC', 256, 'business', '0000-00-00 00:00:00', 0),
(6193, 137244, 'HomeStart Finance', 'homestart.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6194, 137248, 'DOTS Solutions Co., Ltd.', 'dots.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6195, 137250, 'AUS-IP Services', 'ausip.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6196, 137252, 'Mohammad Shahajahan', 'progotiit.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6197, 137253, 'DCSG 7000 AMK PTE. LTD.', 'dcsg.sg', 'SG', 1280, 'business', '0000-00-00 00:00:00', 0),
(6198, 137254, 'SecureWorx Pty Ltd', 'secureworx.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6199, 137255, 'SKY NET ONLINE BD', 'skynetonlinebd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6200, 137257, 'Localhost Limited', 'localhost.net.nz', 'NZ', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6201, 137258, 'Shirazi Investments Pvt Ltd.', 'atlas.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6202, 13726, 'Atlanta Public Schools', 'atlantapublicschools.us', 'US', 4352, 'education', '2012-05-22 00:00:00', 0),
(6203, 137260, 'Bit Exchange Systems Limited', 'bit-exchange.net', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(6204, 137261, 'Nurzad Networks LLC', 'None', 'MN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6205, 137262, 'Smartlinx3 Limited', 'smartlinx3.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(6206, 137263, 'NETEASE HONG KONG LIMITED', 'netease.com', 'HK', 5888, 'business', '0000-00-00 00:00:00', 0),
(6207, 137265, 'MCB Islamic Bank', 'mcbislamicbank.com', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(6208, 137267, 'Sharp ICT', 'sharp.net.nz', 'NZ', 512, 'isp', '0000-00-00 00:00:00', 0),
(6209, 137268, 'CBRE Pty Limited', 'cbre.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6210, 137269, 'Novartis Singapore Pte Ltd', 'novartis.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(6211, 13727, 'NEXT DIMENSION INC', 'nextdimensioninc.com', 'CA', 2560, 'business', '2005-09-01 00:00:00', 0),
(6212, 137270, 'Md. Kamrul Hasan', 'pclbgd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6213, 137271, 'DURONTO ONLINE', 'durontoonline.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6214, 137272, 'PSiDEO (Singapore) Pte Ltd', 'psideo.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(6215, 137273, 'VIRTUAL NODE', 'virtualnode.io', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6216, 137274, 'Md. Zakir Hossain', 'ubonlinebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6217, 137275, 'Broadband Solutions Pvt. Ltd', 'broadbandsolutions.com.au', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(6218, 137276, 'Asia Bridge Telecom', 'asiabtelecom.com', 'AF', 768, 'isp', '0000-00-00 00:00:00', 0),
(6219, 137278, '1 Touch BD Online Ltd.', '1touchbdonline.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6220, 13728, 'D&P Communications, Inc.', 'd-pcommunications.com', 'US', 20736, 'business', '2010-06-25 00:00:00', 0),
(6221, 137280, 'Kingsoft cloud corporation limited', 'kingsoft.com', 'HK', 66816, 'hosting', '0000-00-00 00:00:00', 0),
(6222, 137281, 'DG Communications Co. Ltd.', 'wanconnect.biz', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(6223, 137285, 'PT. METISKA FARMA', 'metiska.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6224, 137286, 'PT. Arupa Cloud Nusantara', 'arupa.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6225, 137287, 'DINAS KOMUNIKASI DAN INFORMATIKA KAB. BEKASI', 'bekasikab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6226, 137288, 'PT UNGARAN SARI GARMENTS', 'usg.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6227, 137289, 'PT. SIGMA CIPTA CARAKA', 'telkomsigma.co.id', 'ID', 2304, 'business', '0000-00-00 00:00:00', 0),
(6228, 13729, 'Fidessa Corporation', 'fidessa.com', 'US', 2560, 'business', '2010-03-05 00:00:00', 0),
(6229, 137291, 'Diskominfo Kabupaten Trenggalek', 'trenggalekkab.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6230, 137292, 'PT. Intranusa Core Teknologi', 'intranusa.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6231, 137294, 'Pusat Hidrografi dan Oseanografi TNI Angkatan Laut', 'bnn.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6232, 137296, 'PT. IMAN TEKNOLOGI INFORMASI', 'xecureit.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6233, 137297, 'Universitas Muhammadiyah Kalimantan Timur', 'umkt.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6234, 137298, 'PT Pelangi Nusantara Multimedia', 'giradia.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6235, 137299, 'Universitas Malikussaleh', 'unimal.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6236, 13730, 'PAVLOV MEDIA INC', 'pavlovmedia.com', 'US', 768, 'isp', '1999-08-06 00:00:00', 0),
(6237, 137300, 'UIN AR-RANIRY', 'ar-raniry.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6238, 137301, 'POLTEKKES KEMENKES YOGYAKARTA', 'poltekkesjogja.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6239, 137302, 'DINAS KOMUNIKASI INFORMATIKA DAN STATISTIK PROVINSI RIAU', 'riau.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6240, 137304, 'Dinas Komunikasi Dan Informatika Prabumulih', 'kotaprabumulih.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6241, 137305, 'PT. INTI DUNIA SUKSES', 'i-saku.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6242, 137306, 'PT Solusi Prima Connectivist', 'connectivist.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6243, 137307, 'PT Nielsen Audience Measurment', 'nielsen.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6244, 137308, 'DISKOMINFO KLATEN', 'jarindo.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6245, 137309, 'PT ALTO Network', 'alto.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6246, 13731, 'Oneida Nation', 'oneidanation.org', 'US', 256, 'business', '2018-04-04 00:00:00', 0),
(6247, 137310, 'PT Shangkuriang Telekomunikasi Indonesia', 'shangtel.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6248, 137311, 'PT. KINEZ CREATIVE SOLUTIONS', 'kinez.co.id', 'ID', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6249, 137312, 'UNIVERSITAS TIDAR', 'untidar.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6250, 137313, 'Kementerian Koordinator Bidang Perekonomian', 'ekon.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6251, 137314, 'Politeknik Negeri Jember', 'polije.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6252, 137315, 'Politeknik Negeri Banyuwangi', 'poliwangi.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6253, 137316, 'PT. PANCA DUTA UTAMA', 'pdu.net.id', 'ID', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6254, 137318, 'DISKOMINFO KABUPATEN PATI', 'patikab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6255, 137319, 'Koordinasi Perguruan Tinggi Swasta (KOPERTIS) Wilayah X', 'kopertis10.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6256, 13732, 'Axispoint Inc', 'axispoint.com', 'US', 4096, 'business', '1999-08-09 00:00:00', 0),
(6257, 137320, 'PT. Internet Service Provider', 'ispfo.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6258, 137321, 'PT THE NIELSEN COMPANY INDONESIA', 'nielsen.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6259, 137322, 'PT. GLOBAL SARANA TELEMATIKA', 'gostnet.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6260, 137323, 'DINAS KOMINFO PEMDA PAPUA BARAT', 'pemprovpapuabarat.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6261, 137324, 'PT Metrocom Indonesia', 'ptmetro.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6262, 137325, 'PT Sanbe Farma', 'sanbe-farma.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6263, 137326, 'PT. GRAHAMEDIA INFORMASI', 'grahamedia.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6264, 137327, 'Universitas Hang Tuah', 'hangtuah.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(6265, 137329, 'PT. ARTHA LINTAS DATA MANDIRI', 'aldm.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6266, 13733, 'Centre for Addiction and Mental Health', 'camh.ca', 'CA', 256, 'business', '2010-07-15 00:00:00', 0),
(6267, 137330, 'PT Pisangmas Rayatama Perkasa', 'yahoo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6268, 137331, 'Cloud Teknologi Nusantara .CV', 'cloudteknologinusantara.co.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(6269, 137332, 'Universitas Komputer Indonesia', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6270, 137334, 'PT Phinisi Media Indonesia', 'phinisi.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6271, 137335, 'Dinas Komunikasi dan Informatika Banjarnegara', 'yahoo.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6272, 137336, 'PT. VISIONET INTERNASIONAL', 'ovo.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6273, 137339, 'Dinas Komunikasi dan Informatika Kabupaten Pinrang', 'pinrangkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6274, 13734, 'Bee Sky Consulting Inc.', 'beesky.com', 'US', 2048, 'business', '1999-08-09 00:00:00', 0),
(6275, 137340, 'Dinas Komunikasi dan Informatika Pemerintah Kota Depok', 'depok.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6276, 137341, 'PT. Sigra Adhi Sejahtera', 'soerabaianetworks.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6277, 137342, 'DISKOMINFO TANGERANG SELATAN', 'tangerangselatankota.go.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(6278, 137343, 'PT. KHAZANAH MEDIA NETWORK NUSANTARA', 'apjii.or.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6279, 137344, 'PT. TRANS NASIONAL TEKNOLOGI', 'transtekno.net', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6280, 137346, 'PT Cyber Network Indonesia', 'cni.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6281, 137347, 'Politeknik Ilmu Pelayaran Semarang', 'pip-semarang.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6282, 137349, 'PT. GEMILANG SARANA MANDIRI', 'gsmnet.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6283, 137351, 'PT. Djaya Sampoerna Net', 'djasanet.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6284, 137352, 'PT. Cloudata Indonesia', 'cloudata.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6285, 137353, 'DINAS KOMINFO KABUPATEN PAKPAK BHARAT', 'pakpakbharatkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6286, 137354, 'PT. Data Sinergitama Jaya', 'elitery.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6287, 137356, 'Universitas PGRI Yogyakarta', 'upy.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6288, 137357, 'PT BUKIT MAKMUR MANDIRI UTAMA', 'deltadunia.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6289, 137359, 'PT. SKYREACH', 'skyreach.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6290, 13736, 'Factual Data Corp', 'krollfactualdata.com', 'US', 768, 'business', '1999-08-09 00:00:00', 0),
(6291, 137360, 'Universitas Muhammadiyah Surabaya', 'um-surabaya.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6292, 137361, 'DISKOMINFO Kab. Magelang', 'magelangkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6293, 137362, 'Pemerintah Kota Surakarta', 'surakarta.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6294, 137363, 'PT. Quanta Tunas Abadi', 'higen.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6295, 137364, 'Badan Pendapatan Daerah Provinsi Riau', 'riau.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6296, 137365, 'PT DUTA VISUAL NUSANTARA TIVI TUJUH', 'trans7.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6297, 137366, 'PT iForte Solusi Infotek - NAP', 'iforte.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6298, 137368, 'Poltekkes Kemenkes Surakarta', 'poltekkes-solo.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6299, 137369, 'PT INTEGRAL DATA PRIMA', 'integraldp.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6300, 13737, 'Riverfront Internet Systems LLC', 'as13737.net', 'US', 2560, 'business', '2014-10-09 00:00:00', 0),
(6301, 137370, 'PT. Infomedia Global Nusantara', 'mediatara.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6302, 137371, 'Dinas Komunikasi dan Informatika Kota Medan', 'pemkomedan.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6303, 137372, 'Association Of Southeast Asian Nation', 'asean.org', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6304, 137373, 'PT. SUITEN INOVASI SUKSES', 'suiten.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(6305, 137374, 'Dinas Komunikasi, Informatika dan Statistik Provinsi Bali', 'baliprov.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6306, 137375, 'PT Internet Solusi Prima', 'isp.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6307, 137376, 'PT Tele Net', 'tele-net.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6308, 137378, 'PT. Perdana Teknologi Persada', 'ptp.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6309, 137379, 'Diskominfo Kota Bekasi', 'bekasikota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6310, 137380, 'PT MITRA VISIONER SOLUSINDO', 'mvnet.co.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6311, 137381, 'Dinas Komunikasi dan Informatika Kabupaten Grobogan', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6312, 137383, 'PT. Mandiri Sekuritas', 'mandirisekuritas.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6313, 137384, 'Universitas Muhammadiyah Purwokerto', 'ump.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6314, 137385, 'Saddam Hossain t/a Asian Network', 'asiannetworkbd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6315, 137386, 'Child Wisdom Limited', 'child-wisdom.com', 'HK', 6400, 'business', '0000-00-00 00:00:00', 0),
(6316, 137388, 'Openet Pty Ltd', 'openet.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6317, 137389, 'SHASS INFORMATION AND QUALITY ENGINEERING SERVICES', 'siqes.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6318, 13739, 'Datacenter IP, LLC', 'datacenter.ge', 'US', 29952, 'isp', '2014-03-05 00:00:00', 0),
(6319, 137390, 'Scott\'s Refrigerated Freightways PTY LTD', 'scottsrf.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6320, 137392, 'KTB Securities (Thailand) Company Limited', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(6321, 137394, 'Dhonburi Rajabhat University', 'dru.ac.th', 'TH', 256, 'education', '0000-00-00 00:00:00', 0),
(6322, 137395, 'Datacom Systems - Philippines', 'globalcenter.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6323, 137396, 'Md Zubayrul Hoque', 'bbarianet.co', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6324, 137397, 'Universiti Selangor', 'unisel.edu.my', 'MY', 256, 'education', '0000-00-00 00:00:00', 0),
(6325, 137399, 'KernWi-Fi Pty Ltd', 'kernwifi.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6326, 13740, 'Hypernet Communications, Inc.', 'hypernet.ca', 'US', 6400, 'business', '1999-08-10 00:00:00', 0),
(6327, 137400, 'Presbyterian Ladies\' College Sydney', 'plc.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6328, 137403, 'SALTSYNC', 'sync.net.bd', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6329, 137404, 'KCAT', 'mykcat.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6330, 137405, 'KERING ASIA PACIFIC LIMITED', 'kering.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6331, 137406, 'Airlive Communications Inc.', 'airlivecom.com', 'PH', 1280, 'business', '0000-00-00 00:00:00', 0),
(6332, 137409, 'GSL Networks Pty LTD', 'gslnetworks.com.au', 'AU', 9984, 'isp', '0000-00-00 00:00:00', 0),
(6333, 137415, 'Bangladesh Coast Guard Force', 'coastguard.gov.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6334, 137416, 'Netpark Communication', 'netparkbd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6335, 137417, 'Cambridge University Press is the publishing business of the University of Cambridge in UK', 'pldt.com.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(6336, 137418, 'Savant Technologies Inc.', 'savant.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(6337, 137419, 'Asif Chowdhury', 'themnet.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6338, 13742, 'CENCOM INC', 'cencominc.com', 'US', 8192, 'business', '2008-12-29 00:00:00', 0),
(6339, 137420, 'Savant Technologies Inc.', 'savant.ph', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(6340, 137421, 'Victoria Funds Management', 'vfmc.vic.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6341, 137422, 'Bupa Health Insurance (Thailand) Public Company Limited', 'truecorp.co.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(6342, 137425, 'INCOMIT SOLUTION', 'incomitbd.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6343, 137426, 'Simm IT Services', 'simmit.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6344, 137429, 'Stuartholme School', 'stuartholme.com', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6345, 13743, 'HOV Services, Inc.', 'hovservices.com', 'US', 1024, 'business', '2006-02-09 00:00:00', 0),
(6346, 137431, 'ZORRO RITZ PUBLIC COMPANY LIMITED', 'ritz.com.mm', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(6347, 137432, 'BKB Network', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6348, 137433, 'Seek Limited', 'seek.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6349, 137435, 'WINK COMMUNICATION', 'wink.net.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6350, 137437, 'Airbnb, Inc.', 'airbnb.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(6351, 13744, 'TYNDALE HOUSE PUBLISHERS', 'tyndale.com', 'US', 512, 'business', '2012-07-03 00:00:00', 0),
(6352, 137440, 'Advanced Bank of Asia Limited', 'ababank.com', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(6353, 137442, 'Cairns Airport Pty Ltd', 'cairnsairport.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6354, 137443, 'Anchnet Asia Limited', 'anchnet.com', 'HK', 228864, 'hosting', '0000-00-00 00:00:00', 0),
(6355, 137444, 'Upstra Communication Ltd.', 'upstra.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6356, 137445, 'PF LINK SYSTEMS', 'pf-link.com', 'JP', 9216, 'business', '0000-00-00 00:00:00', 0),
(6357, 137446, 'Highspeednet Data Services(Hongkong)Co.,Limited', 'None', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(6358, 137448, 'ASB BANK LIMITED', 'asb.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(6359, 137449, 'SKYNET CHOWMUHANI', 'skynetchowmuhani.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6360, 13745, 'Ventus Networks, LLC', 'ventusnetworks.com', 'US', 3584, 'business', '2008-01-09 00:00:00', 0),
(6361, 137453, 'Orange Communication', 'orangebd.online', 'BD', 4096, 'isp', '0000-00-00 00:00:00', 0),
(6362, 137454, 'Sayed Shahin Ahason', 'patriotisp.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6363, 137455, 'Sovereign Cloud Australia Pty Ltd', 'australiacloud.com.au', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(6364, 137456, 'BHP, MBFC Tower 2, Singapore', 'bhpbilliton.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(6365, 137457, 'BHP', 'bhpbilliton.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6366, 13746, 'AiTech', 'aitech.net', 'US', 1024, 'business', '2011-06-27 00:00:00', 0),
(6367, 137460, 'Biztactix Pty Ltd', 'biztactix.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6368, 137461, 'The Bank of Punjab', 'bop.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6369, 137462, 'Rakuten Mobile Network, Inc.', 'rakuten.com', 'JP', 512, 'isp', '0000-00-00 00:00:00', 0),
(6370, 137463, 'Sprint Networks', 'sprintnetworks.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6371, 137464, 'Tangail City Computers', 'citycomputers.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6372, 137465, 'Simplyfree Limited', 'simplyfree.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6373, 137467, 'Asif Husain Choudhury', 'toron.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6374, 137468, 'SPTEL PTE. LTD.', 'sptel.com', 'SG', 2048, 'business', '0000-00-00 00:00:00', 0),
(6375, 137469, 'Signify Limited', 'signify.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6376, 13747, 'DONEGAL MUTUAL INSURANCE', 'donegalgroup.com', 'US', 256, 'business', '2005-03-17 00:00:00', 0),
(6377, 137470, 'Iluka Resources Limited', 'iluka.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6378, 137472, 'Freightways Information Services Limited', 'freightways.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6379, 137473, 'LevelUP Solutions', 'levelup.solutions', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6380, 137475, 'Shah Net Internet Services Provider', 'shahnet.af', 'AF', 256, 'business', '0000-00-00 00:00:00', 0),
(6381, 137476, 'Cargill Asia Pacific Holdings Pte Ltd', 'cargill.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(6382, 137477, 'Villa Shipping and Trading Company Pvt. Ltd.', 'villa.com.mv', 'MV', 256, 'business', '0000-00-00 00:00:00', 0),
(6383, 137478, 'Cyber Net Cafe', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6384, 13748, 'Cold Spring Harbor Laboratory', 'cshl.edu', 'US', 65536, 'education', '2014-04-17 00:00:00', 0),
(6385, 137480, 'Planet Web', 'planetwebbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6386, 137483, 'RD Network', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6387, 137485, 'ATS Technology', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6388, 137487, 'Manila Electric Company', 'meralco.com.ph', 'PH', 1280, 'business', '0000-00-00 00:00:00', 0),
(6389, 137488, 'IceWarp Technologies Pvt. Ltd.', 'icewarp.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6390, 137490, 'Navice Consulting', 'navice.eu', 'NL', 256, 'business', '0000-00-00 00:00:00', 0),
(6391, 137491, 'PEEREX NETWORKS LTD./IIG', 'peerexnetworks.com', 'BD', 2304, 'business', '0000-00-00 00:00:00', 0),
(6392, 137492, 'Mohammad Didarul Kader', 'didarit.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6393, 137494, 'Majesco Software and Solutions India Pvt.Ltd.', 'majesco.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6394, 137495, 'Skyline Networks NZ Ltd', 'skyline-networks.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(6395, 137496, 'RS NETWORK', 'rsnetbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6396, 137498, 'NMS TECHNOLOGIES LTD', 'nms-bd.com', 'BD', 2560, 'isp', '0000-00-00 00:00:00', 0),
(6397, 137499, 'Data Network Services Provider Co.,Ltd', 'hdcambodia.com', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6398, 13750, 'Transaction Network Services, Inc.', 'tnsi.com', 'US', 10496, 'business', '1999-08-10 00:00:00', 0),
(6399, 137501, 'Aref R Bashir', 'dmoney.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6400, 137502, 'NOMINET UK', 'nic.uk', 'GB', 4608, 'business', '0000-00-00 00:00:00', 0),
(6401, 137504, 'Kimberly-Clark Corporation', 'kimberly-clark.com', 'US', 512, 'business', '0000-00-00 00:00:00', 0),
(6402, 137505, 'E-CELL BD', 'e-cellbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6403, 137506, 'CMC MARKETS ASIA PACIFIC PTY LTD', 'cmcmarkets.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6404, 137507, 'OpenText ( Philippines), Inc.', 'gxs.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(6405, 13751, 'Bridgepoint Education, Inc.', 'bridgepointeducation.com', 'US', 1024, 'education', '2006-07-10 00:00:00', 0),
(6406, 137510, 'JENEXUS HOLDING SDN BHD', 'jenexusholding.com', 'MY', 2560, 'isp', '0000-00-00 00:00:00', 0),
(6407, 137511, 'Civil Aviation Authority of Mongolia', 'mcaa.gov.mn', 'MN', 256, 'business', '0000-00-00 00:00:00', 0),
(6408, 137513, 'HBL Bank Pvt Ltd.', 'hbl.com', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(6409, 137514, 'ABROAD', 'abroad-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6410, 137515, 'Md. Raisul Islam', 'frcbd.xyz', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6411, 137518, 'ITIVITI Hong Kong Limited', 'itiviti.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6412, 137519, 'Healthcare Pharmaceuticals Ltd', 'hpl.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6413, 137521, 'Kath Codex Pvt. Ltd.', 'kathcodex.com', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(6414, 137522, 'Origin Energy Retail Limited', 'originbroadband.com.au', 'AU', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6415, 137525, 'NBN Co LTD', 'nbnco.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6416, 137526, 'Plusnet Inc', 'plus.net.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6417, 137529, 'Sydney Opera House Trust', 'sydneyoperahouse.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6418, 137530, 'TrishalNet', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6419, 137531, 'Airnet Communications', 'airnetcommunications.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6420, 137532, 'Md Golam Kibria', 'bhuiyantelecombd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6421, 137534, 'NORTHERN BEACHES BROADBAND', 'nbbn.com.au', 'AU', 512, 'isp', '0000-00-00 00:00:00', 0),
(6422, 137536, 'CERNER CORPORATION PTY LIMITED', 'cerner.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6423, 137537, 'iOne Co., Ltd', 'None', 'KH', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6424, 137538, 'APPLELINK-BD', 'applelinkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6425, 137539, 'China Unicom', 'chinaunicom.cn', 'CN', 65536, 'isp', '0000-00-00 00:00:00', 0),
(6426, 13754, 'TkFast Inc', 'tkfast.com', 'US', 768, 'business', '2007-03-09 00:00:00', 0),
(6427, 137540, 'Bangladesh Roads and Highways Department', 'rhd.gov.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6428, 137541, 'Sheikh Sazzad Hossain', 'royalnetbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6429, 137542, 'Sayem Online Communication', 'sayemonlinecommunication.net.bd', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6430, 137543, 'Mohammad Yousuf', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6431, 137544, 'Bullhorn International Inc.', 'bullhorn.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6432, 137546, 'Faculty of Engineering , Rajamangala University of', 'uni.net.th', 'TH', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6433, 137547, 'Zhengzhou Lulinke Information Technology CO.Ltd.,', 'lulinke.com', 'CN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6434, 137548, 'SR Communication', 'srcommunicationbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6435, 137549, 'NODE1 Pty Ltd', 'node1.com.au', 'AU', 11264, 'business', '0000-00-00 00:00:00', 0),
(6436, 13755, 'St. Petersburg College', 'spcollege.edu', 'US', 512, 'education', '1999-08-11 00:00:00', 0),
(6437, 137550, 'MD. Jahangir Chuwdhury', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6438, 137551, 'REDLINK TELECOM Co., Ltd', 'None', 'KH', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(6439, 137552, 'Symphysodon Limited', 'cian.net', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(6440, 137553, 'GLOBAL COMMUNICATION', 'gcsincorp.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6441, 137554, 'Dream.Net', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6442, 137555, 'Ozcare', 'ozcare.org.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6443, 137557, 'International gateway co., Ltd', 'intergateway.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6444, 137558, 'Castle Cole aka Spirit Telecom Canberra', 'wwwires.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6445, 137561, 'WAYLINK', 'waylink.com.pk', 'PK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6446, 137562, 'Sydney Airport Corporation Limited', 'sydneyairport.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6447, 137563, 'Flow Traders Asia Pte. Ltd.', 'flowtraders.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(6448, 137566, 'Supernap Thailand Company Limited', 'supernap.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6449, 137567, 'Campana Group Pte. Ltd.', 'campanaworks.com', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6450, 137568, 'SKY SYSTEMS LTD', 'sky-systems.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6451, 137570, 'Md Sohel Rana', 'None', 'BD', 768, 'hosting', '0000-00-00 00:00:00', 0),
(6452, 137572, 'AFTAB NAGAR ONLINE SERVICE (ANOS)', 'anosbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(6453, 137573, 'Credit Bureau (Cambodia) Co., Ltd', 'creditbureaucambodia.com', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(6454, 137575, 'SquareAlpha Pty Ltd', 'squarealpha.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6455, 137576, 'EasyCable Pty Ltd', 'easycable.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6456, 137577, 'Cloudware Enterprise Limited', 'cloudwaretech.net', 'PH', 5376, 'business', '0000-00-00 00:00:00', 0),
(6457, 137578, 'Space Walker', 'spacewalkerbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6458, 137579, 'BOL System', 'bolsys.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6459, 13758, 'SMG - Irving Convention Center', 'smgicc.com', 'US', 256, 'business', '2018-08-01 00:00:00', 0),
(6460, 137580, 'Everest Wireless Network pvt. ltd', 'ewnet.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(6461, 137584, 'Prefixnet', 'prefixnet.net', 'BD', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6462, 137585, 'Cyber Link Computer', 'clcbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6463, 137586, 'Nextech Infosys', 'None', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(6464, 137587, 'Vmo Broadband Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6465, 137588, 'Arkcom Telecommunications Pvt Ltd.', 'arkcomtele.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6466, 137589, 'Stizonet Broadband Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6467, 13759, 'Wilkes University', 'wilkes.edu', 'US', 65536, 'education', '2006-02-10 00:00:00', 0),
(6468, 137590, 'Ua E Governance In Pmu', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6469, 137591, 'ITECH HIVE PVT. LTD', 'itechhive.com', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(6470, 137593, 'Hifi Broadband Pvt. Ltd.', 'hifibroadband.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6471, 137594, 'Flashcom Network Private Limited', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(6472, 137596, 'LinkStar Technologies Pvt Ltd', 'linkstartech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6473, 137598, 'Skynet Zone Wifi Services Pvt. Ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6474, 13760, 'Uniti Fiber Holdings Inc.', 'uniti.com', 'US', 113920, 'isp', '2006-02-10 00:00:00', 0),
(6475, 137601, 'M. P. Commodities Private Ltd', 'uninternet.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6476, 137602, 'Comviva Technologies Limited', 'comviva.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6477, 137604, 'Sahjanand Telecom Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6478, 137605, 'Tata Technologies Ltd', 'tatatechnologies.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6479, 137606, 'Aarav Computers Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6480, 137607, 'Patel Wealth Advisors Private Limited', 'patelwealth.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6481, 137608, 'Speedster Communications Pvt. Ltd.', 'speedster.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6482, 137609, 'Dcs Internet Services Pvt Ltd', 'dcsindia.co', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6483, 137610, 'Streamax Broadband Services Pvt. Ltd.', 'streamaxbroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6484, 137611, 'Hexagon Capability Center India Pvt Ltd', 'hexagon.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6485, 137612, 'Chandra Digital Communications And Networks', 'cdcnetworks.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6486, 137614, 'Paytm E-commerce Private Limited', 'paytmmall.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6487, 137615, 'Aonedpn Communications Pvt. Ltd.', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6488, 137617, 'Indian Institute Of Management Ahmedabad', 'ernet.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(6489, 137619, 'Fastnet Broadband Services', 'fastnetbroadband.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6490, 13762, 'Hunter Douglas', 'hunterdouglas.com', 'US', 256, 'business', '1999-08-13 00:00:00', 0),
(6491, 137620, 'Pink Broadband Service Pvt Ltd', 'pinkbroadband.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6492, 137621, 'Servercake Webhosting India Pvt Ltd', 'servercake.in', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6493, 137622, 'Royal Connect Solutions Pvt Ltd', 'royalconnect.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6494, 137623, 'Bloodstone Technologies Pvt. Ltd.', 'bloodstonetechnologies.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6495, 137624, 'Ebenezar Communications Private Limited', 'ebenezar.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6496, 137625, 'Blue Vision Cable Network Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6497, 137626, 'Branmark Infomedia Pvt. Ltd.', 'branmark.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6498, 137627, 'Nextel Communications India Pvt Ltd', 'nextelindia.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6499, 137628, 'Unq Communication Private Limited', 'unqcommunication.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6500, 137630, 'Morbi Infocom Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6501, 137631, 'Divine Broadband Services Pvt. Ltd', 'divinebroadbandservices.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6502, 137632, 'Oil India Limited', 'oilindia.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6503, 137633, 'Gigaline Teleservices Opc Private Limited', 'gigalinetele.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6504, 137634, 'Netwin Systems And Software India Pvt Ltd', 'netwinindia.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6505, 137635, 'J.sky Media Pvt.ltd.', 'j.sky', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6506, 137636, 'Teligus Networks Private Limited', 'teligus.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6507, 137638, 'Ace Designers Ltd', 'acedesigners.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6508, 137639, 'Jasnet Networks Private Limited', 'jasnet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6509, 13764, 'Kwantlen Polytechnic University', 'kwantlen.ca', 'CA', 2048, 'education', '2014-05-20 00:00:00', 0),
(6510, 137640, 'Seveni Internet Services', 'seveni.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6511, 137641, 'Cosyn Limited', 'cosyn.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6512, 137642, 'Mesh Infranet Private Limited', 'meshinfranet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6513, 137646, 'Department of Governance Reforms', 'punjab.gov.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6514, 137648, 'Rhombus Communications Pvt Ltd', 'rhombuscommunications.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6515, 137649, 'Netvision Internet India Pvt Ltd', 'tnvt.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6516, 13765, 'Nedelco Inc.', 'nque.com', 'US', 8192, 'business', '1999-08-13 00:00:00', 0),
(6517, 137650, 'Micronet It Services Private Limited', 'micronet.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6518, 137651, 'Activline Telecom Pvt. Ltd.', 'activline.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6519, 137652, 'Tapee Infocom Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6520, 137653, 'Dstech Cyberspace Pvt Ltd', 'dstechcyberspace.com', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(6521, 137654, 'Netstra Communications Pvt Ltd', 'netstra.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6522, 137655, 'Angel Air Network Solutions Pvt. Ltd.', 'None', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6523, 137656, 'Kosmic Broadband Private Limited', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6524, 137658, 'Jinus Net Private Limited', 'jinusnet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6525, 137659, 'Jaipur Internet', 'robtex.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6526, 137660, 'Doonbroadband Private Limited', 'imsiglobal.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6527, 137661, 'Rajcomp Info Services Ltd.', 'rajasthan.gov.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6528, 137662, 'Idfc Bank Ltd', 'idfcbank.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6529, 137665, 'Kia Communications Pvt Ltd', 'gmx.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6530, 137666, 'Udaan Internet Services Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6531, 137667, 'Super Sonic Internet Pvt Ltd', 'supersonicinternet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6532, 137668, 'Sanavi Infotech Opc Pvt. Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6533, 13767, 'DataBank Holdings, Ltd.', 'databank.com', 'US', 39936, 'hosting', '2006-02-10 00:00:00', 0),
(6534, 137670, 'Canara Bank', 'canarabank.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6535, 137671, 'ITE&C DEPARTMENT, GOVERNMENT OF A.P.', 'ap.gov.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6536, 137672, 'Priveka Web Services Private Limited', 'privekawebservices.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6537, 137673, 'Godrej Industries Ltd', 'godrejindustries.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6538, 137674, 'Saavi Connecting Global Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6539, 137677, 'Surround Networks Pvt. Ltd.', 'surroundnet.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6540, 137678, 'Protoact Digital Network Pvt. Ltd.', 'protoactnetworks.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6541, 137679, 'Shree Net Online Services Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6542, 13768, 'Aptum Technologies', 'aptum.com', 'CA', 1312000, 'hosting', '2002-06-10 00:00:00', 0),
(6543, 137681, 'Alien Dns Pvt Ltd', 'alienbroadband.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6544, 137682, 'Telosy Telecom Pvt. Ltd.', 'telosytelecom.co.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6545, 137687, 'Luoyang, Henan Province, P.R.China.', 'chinatelecom.cn', 'CN', 30720, 'isp', '0000-00-00 00:00:00', 0),
(6546, 137689, 'IOT Jiangsu network, Chinatelecom, P.R.China.', 'chinatelecom.cn', 'CN', 70656, 'isp', '0000-00-00 00:00:00', 0),
(6547, 13769, 'DPS Holdings Inc.', 'dpsg.com', 'US', 256, 'business', '2017-09-08 00:00:00', 0),
(6548, 137690, 'Zaozhuang,Shandong Province, P.R.China.', 'chinatelecom.cn', 'CN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(6549, 137692, 'IOT Guangdong network, Chinatelecom, P.R.China.', 'chinatelecom.cn', 'CN', 17152, 'isp', '0000-00-00 00:00:00', 0),
(6550, 137693, 'CHINATELECOM Guangxi Nanning IDC networkdescr: Nanning , Guangxi Province, P.R.China.', 'nn.gx.cn', 'CN', 58112, 'isp', '0000-00-00 00:00:00', 0),
(6551, 137694, 'CHINATELECOM Xinjiang Kezhou MAN network', 'chinatelecom.cn', 'CN', 73728, 'isp', '0000-00-00 00:00:00', 0),
(6552, 137695, 'CHINATELECOM Xinjiang Wulumuqi MAN network', 'chinatelecom.cn', 'CN', 47104, 'isp', '0000-00-00 00:00:00', 0),
(6553, 137697, 'CHINATELECOM JiangSu YangZhou IDC networkdescr: YangZhou , Jiangsu Province, P.R.China.', 'gsta.com', 'CN', 69376, 'isp', '0000-00-00 00:00:00', 0),
(6554, 137698, 'Haerbing , Heilongjiang Province, P.R.China.', 'chinatelecom.cn', 'CN', 5376, 'isp', '0000-00-00 00:00:00', 0),
(6555, 137699, 'CHINATELECOM Jiangsu Suqian IDC network', 'chinatelecom.cn', 'CN', 16896, 'isp', '0000-00-00 00:00:00', 0),
(6556, 137702, 'Nanjing, Jiangsu Province, P.R.China.', 'chinatelecom.cn', 'CN', 101888, 'isp', '0000-00-00 00:00:00', 0),
(6557, 137703, 'Noakhali Broadband Network', 'noakhalibroadband.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6558, 137704, 'Abu Sayeem Siddique', 'imcplus.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6559, 137706, 'National University', 'nu.edu', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(6560, 137707, 'SLN', 'slnisp.com.bd', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6561, 13771, 'Digicel Cayman Limited', 'digicelgroup.com', 'KY', 2048, 'isp', '2017-08-10 00:00:00', 0),
(6562, 137710, 'Net God Information Technology (Beijing) Co., Ltd.', '360.net', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6563, 137715, 'GTJA Securities', 'gtjas.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6564, 13773, 'FIBERNETICS CORPORATION', 'fibernetics.ca', 'CA', 13056, 'isp', '1999-08-16 00:00:00', 0),
(6565, 137735, 'China Construction Bank', 'ccb.com', 'CN', 2304, 'business', '0000-00-00 00:00:00', 0),
(6566, 13774, 'Corpbanca', 'corpbanca.cl', 'CL', 512, 'business', '1999-08-16 00:00:00', 0),
(6567, 137745, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 1024, 'business', '2006-11-29 00:00:00', 0),
(6568, 137746, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 512, 'business', '2006-11-29 00:00:00', 0),
(6569, 13775, 'Mathbox Inc.', 'mathbox.net', 'US', 2048, 'business', '1999-08-16 00:00:00', 0),
(6570, 137753, 'Beijing Jingdong Shangke Information Technology Co. Ltd.', 'jd.com', 'CN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6571, 137758, 'Industrial and Commercial Bank of China Limited,ICBC', 'icbc.com.cn', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(6572, 137759, 'MTS SYSTEM (China) Co.,Ltd', 'mts.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(6573, 13776, 'QX.Net', 'qx.net', 'US', 34560, 'isp', '1999-08-16 00:00:00', 0),
(6574, 137761, 'ETIIR', 'etiir.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6575, 137762, 'Guosen youyun software system co. LTD.', 'inforchina.com.cn', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6576, 137764, 'Beijing Youkai Technology Co.Ltd', 'vjnet.cn', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6577, 137767, 'Shanghai General Motor Corporation Limited', 'shanghaigm.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(6578, 13778, 'Johnson & Johnson', 'jnj.com', 'US', 36864, 'isp', '1999-08-16 00:00:00', 0),
(6579, 137782, 'STATE GRID SHANGHAI MUNICIPAL ELECTRIC POWER COMPANY', 'aliyun.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6580, 137784, 'CACloud Services (Shanghai) Co., Ltd.', 'cacloud.net.cn', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(6581, 137787, 'Beijing Jingdong Shangke Information Technology Co. Ltd.', 'cnnic.cn', 'CN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6582, 13779, 'Basis Technology', 'basistech.com', 'US', 512, 'business', '1999-08-16 00:00:00', 0),
(6583, 137794, 'Dahe tianchi (Beijing) network co. LTD', 'tianchic.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(6584, 1378, 'Interbel Telephone Cooperative, Inc.', 'interbel.com', 'US', 4864, 'isp', '2009-07-27 00:00:00', 0),
(6585, 13780, 'THE NATIONAL FOOD LABORATORY', 'thenfl.com', 'US', 256, 'business', '2012-04-04 00:00:00', 0),
(6586, 137804, 'China Internet Exchange', 'cnix.com.cn', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6587, 137806, 'WMGS Consulting (Shenzhen) Co.Ltd', 'walmart.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6588, 137809, 'Paul Pereira', 'pe-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6589, 13781, 'Hopkinsville Electric System', 'hop-electric.com', 'US', 10240, 'isp', '1999-08-16 00:00:00', 0),
(6590, 137810, 'Md Obaid Ullah Khan', 'adelonline.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6591, 137811, 'BEE UNION (CAMBODIA) TELECOM CO., LTD', 'beeunion.net', 'KH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6592, 137813, 'LeanCloud', 'leancloud.cn', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(6593, 137814, 'E-BIT Systems Pty Ltd', 'ebitsystems.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6594, 137815, 'SUPER STAR ELECTRONICS LIMITED', 'ssgbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6595, 137816, 'Cloud Net Technologies Limited', 'cloudnettl.com', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(6596, 137817, 'Coronet Corporation Limited', 'coronetbdiig.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6597, 137818, 'Panay Telephone Corporation', 'pantelco.net', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(6598, 137819, 'Beeks Financial Cloud (Japan)', 'beeksfinancialcloud.com', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(6599, 13782, 'The First American Financial Corporation', 'firstam.com', 'US', 5120, 'business', '1999-08-16 00:00:00', 0),
(6600, 137822, 'IT CORPORATE PTY. LTD.', 'itma.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6601, 137823, 'cloudone', 'cloudone.com.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6602, 137824, 'View Net Technology', 'vnt.af', 'AF', 512, 'isp', '0000-00-00 00:00:00', 0),
(6603, 137825, 'UniCredit Business Integrated Solutions S.C.P.A Singapore Branch', 'uncredit.eu', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(6604, 137826, 'AST SYSTEM TECHNOLOGY COMPANY LIMITED', 'None', 'MM', 256, 'isp', '0000-00-00 00:00:00', 0),
(6605, 137827, 'Cygnal Technologies', 'cygnaltech.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(6606, 137828, 'Net Matrix', 'netmatrixbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6607, 137829, 'Askina Cable Network Private Limited', 'askinacable.net.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(6608, 13783, 'Radford University', 'radford.edu', 'US', 65536, 'education', '1999-08-16 00:00:00', 0),
(6609, 137831, 'SHOPEE SINGAPORE PRIVATE LIMITED', 'shopee.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(6610, 137834, 'Adel Online Technology', 'aotlbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6611, 137836, 'THE TATA POWER COMPANY LIMITED', 'tatapower.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6612, 137837, 'Children\'s Medical Research Institute', 'cmri.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6613, 137839, 'IMU Education Sdn. Bhd.', 'imu.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(6614, 137840, 'Equinix Australia Pty Ltd', 'equinix.com', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6615, 137841, 'SENSIA SERVICES PTY LTD', 'net360.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6616, 137842, 'MH ONLINE', 'mhonlinebd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6617, 137843, 'INTERSTELLAR', 'interstellarbd.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(6618, 137844, 'SIGMA HEALTHCARE LIMITED', 'sigmahealthcare.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6619, 137847, 'Crisp Wireless Pty Ltd', 'crispwireless.com.au', 'AU', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6620, 137849, 'TT Network Integration India Pvt Ltd', 'ttni.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6621, 13785, 'SHORE MEMORIAL HOSPITAL', 'shorememorial.org', 'US', 256, 'business', '2006-02-10 00:00:00', 0),
(6622, 137850, 'Mae Fah Luang University', 'mfu.ac.th', 'TH', 768, 'education', '0000-00-00 00:00:00', 0),
(6623, 137852, 'BIZCOM (NT) PTY. LTD.', 'bizcom.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6624, 137853, 'TELNET CO.,LTD', 'telnet.it', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6625, 137854, 'Reliant Techno Networking Pvt. Ltd.', 'reliant.net.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6626, 137856, 'Thai Network Information Center Foundation', 'thnic.co.th', 'TH', 1536, 'business', '0000-00-00 00:00:00', 0),
(6627, 137857, 'NYT Hong Kong Limited', 'nytimes.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(6628, 13786, 'Seabras 1 USA, LLC', 'seabornnetworks.com', 'US', 3072, 'business', '2018-08-24 00:00:00', 0),
(6629, 137861, 'Myanmar World Distribution Telecommunication Company Limited', 'mwdtechnologies.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(6630, 137862, 'Rainbow D Net', 'rainbowd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6631, 137863, 'TOYOTA MATERIAL HANDLING AUSTRALIA PTY LIMITED', 'tmha.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6632, 137864, 'Royal College of Pathologists of Australasia', 'rcpa.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6633, 137868, 'Star Internet Service', 'sisbdisp.com', 'BD', 1280, 'business', '0000-00-00 00:00:00', 0),
(6634, 13787, 'CenturyLink Communications, LLC', 'centurylink.com', 'US', 40448, 'isp', '2006-09-29 00:00:00', 0),
(6635, 137870, 'IHNetworks, LLC', 'ihnetworks.com', 'US', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6636, 137871, 'IT Net', 'itnetzone.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6637, 137872, 'China Mobile Hong Kong Company Limited', 'chinamobile.com', 'HK', 70912, 'isp', '0000-00-00 00:00:00', 0),
(6638, 137873, 'Parvez Ahmed', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6639, 137876, 'Tencent (Thailand) Company Limited', 'tencent.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(6640, 137877, 'LIGHT CLOUD (HK) LIMITED', 'lighthosting.com.hk', 'HK', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6641, 137878, 'GOLDENET', 'goldenet.net', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(6642, 13788, 'US Courts', 'uscourts.gov', 'US', 4608, 'business', '1999-08-18 00:00:00', 0),
(6643, 137880, 'Prime Network Pvt.ltd', 'prime.net.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(6644, 137881, 'LIVEWIRE IT PTY LTD', 'livewire.cloud', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6645, 137882, 'Huajuan Enterprise Network', 'betaidc.com', 'HK', 256, 'isp', '0000-00-00 00:00:00', 0),
(6646, 137883, 'SK Communication', 'skcommunication.net.bd', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6647, 137884, 'Gazipur Network System', 'gazipurns.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6648, 137885, 'Capital Nomura Securities PLC', 'uih.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(6649, 137887, 'The Hang Seng University of Hong Kong', 'hsu.edu.hk', 'HK', 512, 'education', '0000-00-00 00:00:00', 0),
(6650, 137888, 'Bee Connect Myanmar Co., Ltd.', 'beeconnectmyanmar.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(6651, 137889, 'GENIUS IT', 'geniusit.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6652, 13789, 'Internap Holding LLC', 'inap.com', 'US', 94208, 'isp', '1999-08-18 00:00:00', 0),
(6653, 137890, 'Walesi Ltd', 'walesi.com.fj', 'FJ', 256, 'business', '0000-00-00 00:00:00', 0),
(6654, 137891, 'Be The First', 'umgroups.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(6655, 137895, 'Fast Net Telecom', 'fastnetisp.com', 'AF', 256, 'isp', '0000-00-00 00:00:00', 0),
(6656, 137896, 'Hunter Water Corporation', 'hunterwater.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6657, 137898, 'SWANCAGE PTY. LIMITED', 'northern.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6658, 1379, 'Sybase 365, Inc', 'sybase.com', 'US', 2048, 'business', '2009-07-27 00:00:00', 0),
(6659, 13790, 'Internap Holding LLC', 'inap.com', 'US', 24576, 'isp', '1999-08-18 00:00:00', 0),
(6660, 137903, 'THE STAR ENTERTAINMENT QLD LIMITED', 'gccec.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6661, 137904, 'Black & Veatch (SEA) PTE LTD', 'bv.com', 'SG', 4096, 'business', '0000-00-00 00:00:00', 0),
(6662, 137905, 'Mangkone Technology Co. Ltd.', 'mangkone.com', 'LA', 512, 'isp', '0000-00-00 00:00:00', 0),
(6663, 137906, 'PMP Limited', 'pmplimited.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6664, 137907, 'PMP Limited', 'pmplimited.com.au', 'AU', 1536, 'business', '0000-00-00 00:00:00', 0),
(6665, 137909, 'Globius Servers', 'globius.org', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(6666, 13791, 'Internap Holding LLC', 'inap.com', 'US', 29440, 'isp', '1999-08-18 00:00:00', 0),
(6667, 137911, 'Prime Minister Office', 'pmo.gov.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6668, 137912, 'Global Broadband K.K', 'glbb.com', 'JP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6669, 137913, 'EDISON Global Networks Limited', 'edisongn.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(6670, 137915, 'Zero Technology Co. ,LIMITED', 'desen.hk', 'HK', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6671, 137916, 'EDL GROUP OPERATIONS PTY LTD', 'edl.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6672, 137919, 'BTS Building, 1000 Phahonyothin Rd., Chomphon, Chatuchak Bangkok 10900 Thailand', 'bts.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(6673, 13792, 'Internap Holding LLC', 'inap.com', 'US', 512, 'isp', '1999-08-18 00:00:00', 0),
(6674, 137922, 'IBOSS Inc.', 'iboss.com', 'US', 3840, 'isp', '0000-00-00 00:00:00', 0),
(6675, 137925, 'GIC-Bhutan Reinsurance Co. Ltd.', 'gicbhutanre.com', 'BT', 256, 'business', '0000-00-00 00:00:00', 0),
(6676, 137927, 'Automated System (HK) Ltd.', 'asl.com.hk', 'HK', 1792, 'business', '0000-00-00 00:00:00', 0),
(6677, 13793, 'T3 VoiceNet, LLC.', 't3voicenet.com', 'US', 4096, 'business', '2006-07-10 00:00:00', 0),
(6678, 137930, 'Doo Technology Limited', 'doo.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(6679, 137932, 'IPDC SOLUTIONS PTE LTD', 'ipdc.asia', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(6680, 137934, 'United Commercial Bank Limited', 'ucb.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6681, 137935, 'I Link Internet Service', 'ilinkinternetservice.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(6682, 137938, 'QBE Insurance Group Ltd', 'qbe.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6683, 137939, 'Mohammad Kabir Hossain', 'hazionlinebd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6684, 13794, 'Odynet inc', 'ody.ca', 'CA', 8192, 'isp', '2016-11-30 00:00:00', 0),
(6685, 137940, 'OnlineStack Global Networks', 'onlinestack.co.uk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6686, 137945, 'Nutrien LTD APAC AS', 'nutrien.com', 'AU', 3584, 'business', '0000-00-00 00:00:00', 0),
(6687, 137946, 'Xiamen Youtian Technology Co., Ltd.', 'youtiankeji.com', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(6688, 137947, 'Prime Bank Ltd', 'primebank.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6689, 137948, 'Diebold Nixdorf Singapore PTE. LTD.', 'dieboldnixdorf.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(6690, 13795, 'Smart Way Communications, LLC', 'thinksmartway.com', 'US', 256, 'business', '2020-02-14 00:00:00', 0),
(6691, 137950, 'Neerja Softwares Pvt Ltd', 'neerjasoftwares.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6692, 137951, 'Clayer Limited', 'clayer.net', 'HK', 410368, 'hosting', '0000-00-00 00:00:00', 0),
(6693, 137952, 'ANGKOR E & C (CAMBODIA) Co.,Ltd.', 'aenccambodia.com', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6694, 137956, 'Indian Institute of Technology Ropar', 'iitrpr.ac.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(6695, 137957, 'OMV NEW ZEALAND LIMITED', 'petrom.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(6696, 137959, 'Vision Technologies Ltd.', 'visiontechnologiesltd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6697, 13796, 'University of Connecticut', 'uconn.edu', 'US', 90112, 'education', '1999-08-19 00:00:00', 0),
(6698, 137961, 'MD. Mokhlesur Rahman', 'abuzzit.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6699, 137962, 'GREYPANEL PTE LTD', 'greypanel.com', 'SG', 1536, 'business', '0000-00-00 00:00:00', 0),
(6700, 137963, 'MT Microtel Technology Sdn Bhd', 'microteltechnology.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(6701, 137964, 'Nextgen Online', 'nextgenonlinebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6702, 137965, 'Public Record Office Victoria', 'prov.vic.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6703, 137967, 'Digicon Telecommunication Ltd', 'cg-bd.com', 'BD', 2304, 'isp', '0000-00-00 00:00:00', 0),
(6704, 137968, 'Pen10 Services Pty Ltd', 'penten.com', 'AU', 2048, 'business', '0000-00-00 00:00:00', 0),
(6705, 137969, 'HONG KONG BRIDGE INFO-TECH LIMITED', 'qq.com', 'HK', 12800, 'hosting', '0000-00-00 00:00:00', 0),
(6706, 13797, 'International Data Group, Inc.', 'idg.com', 'US', 2048, 'business', '2006-02-10 00:00:00', 0),
(6707, 137971, 'KOUKOUROU PTY LTD', 'fmgengineering.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6708, 137972, 'K G Information Systems Private Limited', 'kgisl.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6709, 137974, 'Bangabandhu Sheikh Mujibur Rahman Agricultural University', 'bsmrau.edu.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(6710, 137975, 'Stark Telecom', 'starktel.com', 'AF', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6711, 137976, 'MD Firozur Rahman', 'siamtrading.com.bd', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(6712, 137977, 'ONE TO ONE CONTACTS PUBLIC COMPANY LIMITED descr: Bangkok', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(6713, 137980, 'Unibit Pty Ltd', 'unibit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6714, 137981, 'Bank of Maldives Plc', 'bankofmaldives.com.mv', 'MV', 512, 'business', '0000-00-00 00:00:00', 0),
(6715, 137982, 'BOW LLC', 'None', 'MN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6716, 137983, 'Cheetech Information Technology Co., Ltd.', 'citcambodia.com', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6717, 137985, 'UNLIMITED BROADBAND NETWORK', 'ubnbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6718, 137987, 'Md. Shohidul Islam T/A SK Link', 'sklinkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6719, 137989, 'BigHub Co.,Ltd', 'bighub.com.kh', 'KH', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6720, 13799, '3form Inc.', '3-form.com', 'US', 256, 'business', '2005-09-22 00:00:00', 0),
(6721, 137990, 'SUNIWAY GROUP LIMITED', 'suniway.net', 'HK', 3328, 'isp', '0000-00-00 00:00:00', 0),
(6722, 137991, 'Lifeway Singapore Pte. Ltd.', 'lifewaysg.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(6723, 137992, 'Leidc Co., Limited', 'leidcsu.cn', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(6724, 137993, 'Kingviews Adamas Systems Limited', 'kingviews-hk.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6725, 137994, 'Bhutan National Bank limited', 'bnb.bt', 'BT', 256, 'isp', '0000-00-00 00:00:00', 0),
(6726, 137995, 'Shuangyu Communications Technology Co., Limited', 'syctnet.com', 'HK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6727, 137996, 'WIT Philippines, Inc.', 'philsat.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6728, 137997, 'Drik Picture Library Ltd.', 'drik.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6729, 137999, 'QUINTRON-SYSTEMS-LIMITED', 'hkisl.net', 'HK', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(6730, 138, 'DoD Network Information Center', 'mail.mil', 'US', 206848, 'isp', '1987-11-11 00:00:00', 0),
(6731, 1380, 'McVEAN Trading & Investments, LLC', 'mcvean.com', 'US', 256, 'business', '2009-07-27 00:00:00', 0),
(6732, 138001, 'Galaxy Net', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6733, 138002, 'Global Speech Networks Pty Ltd', 'gsn.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6734, 138003, 'Royal Police Cadet Academy', 'rpca.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(6735, 138005, 'LENOVO (AUSTRALIA & NEW ZEALAND) PTY LIMITED', 'lenovo.com', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(6736, 138007, 'LENOVO (AUSTRALIA & NEW ZEALAND) PTY LIMITED', 'lenovo.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(6737, 13801, 'Concord-Carlisle Regional School District', 'concordps.org', 'US', 256, 'education', '2012-01-05 00:00:00', 0),
(6738, 138011, 'Speedy Cloud International Co., Ltd', 'speedycloud.cn', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(6739, 138012, 'SEQURETEK IT SOLUTIONS PRIVATE LIMITED', 'sequretek.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6740, 138013, 'QUEST PAYMENT SYSTEMS PTY LTD', 'questpaymentsystems.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6741, 138014, 'Daulatpur Online', 'daulatpuronline.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(6742, 138017, 'Abbotsleigh School', 'abbotsleigh.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6743, 138019, 'Punjab Safe City Authority', 'psca.gop.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6744, 138022, 'Mohammad Mohiuddin', 'rawshanarainternet.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6745, 138023, 'Creation Online', 'creationonlinebd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6746, 138024, 'NETPLUS ONLINE', 'netplusbd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6747, 138025, 'RBC Cable', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(6748, 138028, 'BOILEAU BUSINESS SOLUTIONS PTY LTD', 'boileau.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6749, 138029, 'Shen Zhen Hu Lian Xian Feng Technology Co., Limited', 'idcicp.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6750, 13803, 'CRC Inc.', 'crc.net', 'US', 512, 'business', '1999-08-20 00:00:00', 0),
(6751, 138030, 'City Net Communication Co., Ltd.', 'citynet.live', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(6752, 138031, 'M/S. New Noman Traders', 'None', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(6753, 138033, 'BBIX, Inc', 'bbix.net', 'JP', 1024, 'business', '0000-00-00 00:00:00', 0),
(6754, 138034, 'ATEN Australia Pty Ltd', 'atenaustralia.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6755, 138035, 'BGP ASN for Novartis Hyderabad office internet peering with Bharti and Vodafone', 'novartis.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6756, 138039, 'Broadband Business Ideas (PVT.) Limited', 'bbi.net.pk', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6757, 13804, 'ATG Arrow Technology Group Limited Partnership', 'atg.net', 'CA', 1024, 'isp', '2017-08-10 00:00:00', 0),
(6758, 138040, 'DNSVAULT SDN BHD', 'dnsvault.net', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(6759, 138042, 'Runway Broadband', 'runwaybroadband.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6760, 138043, 'T Network', 'tnetwork.com.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6761, 138046, 'INSTITUT BISNIS DAN INFORMATIKA STIKOM SURABAYA', 'stikom.edu', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6762, 138047, 'PT. Grace Nexus Teknologi', 'nexus.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6763, 138048, 'PT. PARADIGMA MATRA INDONESIA', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6764, 13805, 'World Communications', 'wci.com', 'US', 2048, 'business', '1999-08-23 00:00:00', 0),
(6765, 138050, 'Dinas Komunikasi Provins Jawa Barat', 'jabarprov.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6766, 138051, 'PT Sentra Data Persada', 'sentradata.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6767, 138054, 'PT .Bank Common Wealth', 'commbank.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6768, 138055, 'BADAN INTELIJEN NEGARA', 'interlink.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6769, 138056, 'PT. JABARMAYA KRIYA SENTOSA', 'jabarmaya.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6770, 138058, 'Lembaga Layanan Pendidikan Tinggi Wilayah IV', 'lldikti4.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6771, 138059, 'PEMERINTAH KABUPATEN PURWOREJO', 'purworejokab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6772, 13806, 'NCR Corporation', 'ncr.com', 'US', 14592, 'business', '1999-08-23 00:00:00', 0),
(6773, 138060, 'PT Global Data Inspirasi', 'datains.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6774, 138061, 'PT MEISSA Berkah Teknologi', 'first-routes.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6775, 138062, 'PT. Awan Kilat Semesta', 'paas.id', 'ID', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6776, 138063, 'PT. Personel Alih Daya', 'persada.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6777, 138064, 'PT. Jinom Network Indonesia', 'jinom.net', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6778, 138065, 'PT Teknovatus Solusi Sejahtera', 'teknovatus.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6779, 138066, 'Universitas Negeri Manado', 'unima.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6780, 138068, 'PT. Super Sistem Ultima', 'supersistem.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6781, 138069, 'PT CITRAWEB DIGITAL MULTISOLUSI', 'citra.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6782, 13807, 'Great Plains Communications LLC', 'gpcom.com', 'US', 39424, 'isp', '2006-07-11 00:00:00', 0),
(6783, 138070, 'PT Jejaring Mitra Persada', 'jumper.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6784, 138072, 'PT Sumber Utama Fiber Indonesia', 'sufi.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6785, 138073, 'PT ELNUSA Tbk', 'elnusa.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6786, 138074, 'PT. Wowrack Cepat Teknologi Nusantara', 'wow.net.id', 'ID', 3072, 'hosting', '0000-00-00 00:00:00', 0),
(6787, 138076, 'PT Pos Indonesia (Persero)', 'posindonesia.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6788, 138077, 'PT Abhinawa Sumberdaya Asia', 'abhinawa.co.id', 'ID', 2816, 'business', '0000-00-00 00:00:00', 0),
(6789, 138078, 'Universitas Siliwangi', 'unsil.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6790, 138079, 'PT. Fiqran Solusindo Mediatama', 'fastama.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6791, 13808, 'Acculynk, Inc.', 'acculynk.com', 'US', 512, 'business', '2006-07-06 00:00:00', 0),
(6792, 138080, 'PT Global Media Inti Semesta', 'gmis.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6793, 138082, 'DINAS KOMINFO PASURUAN', 'pasuruankab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6794, 138083, 'PT. Supra Boga Lestari', 'ranchmarket.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6795, 138084, 'INSTITUT TEKNOLOGI NASIONAL MALANG', 'nusa.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6796, 138085, 'PT Sepulsa Teknologi Indonesia', 'sepulsa.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6797, 138086, 'MAHKAMAH KONSTITUSI RI', 'mkri.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6798, 138087, 'PT JAVA MEDIANET TEKHNOLOGI', 'javamedia.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6799, 138089, 'PT.Global Media Data Prima', 'gmdp.net.id', 'ID', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6800, 13809, 'University of Arkansas for Medical Sciences', 'uams.edu', 'US', 131072, 'education', '1999-08-23 00:00:00', 0),
(6801, 138090, 'PT. Wave Communication Indonesia', 'wavecomindo.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6802, 138091, 'PT Mitra Pajakku', 'pajakku.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6803, 138092, 'PT. Nebula  Surya Corpora', 'nebula.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6804, 138093, 'PT. LINTASMAYA MULTI MEDIA', 'lintasmaya.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6805, 138094, 'PT Vieda Prakarsa Indonesia', 'vp-indo.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6806, 138095, 'PEMERINTAH KABUPATEN NGAWI', 'ngawikab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6807, 138096, 'PT INFORMASI NUSANTARA TEKNOLOGI', 'intek.net.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6808, 138097, 'DINAS KOMUNIKASI DAN INFORMATIKA PROVINSI KEPULAUAN RIAU', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6809, 138098, 'PT Melon Indonesia', 'melon.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6810, 138099, 'PT Hexa Sarana Intermedia', 'sipajak.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6811, 13810, 'Afilias, Inc.', 'afilias.info', 'US', 256, 'business', '2007-05-16 00:00:00', 0),
(6812, 138100, 'PT. Mahameru Media Nusantara', 'm2n.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6813, 138101, 'PT. Nawakara Perkasa Nusantara', 'nawakara.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6814, 138102, 'PT Baraya Telematika Nusantara', 'baraya.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6815, 138104, 'PT Mandiri Tunas Finance', 'mtf.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6816, 138105, 'Kementerian Desa, Pembangunan Daerah Tertinggal dan Transmigrasi', 'kemendesa.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6817, 138106, 'PT Lintas Telematika Nusantara', 'ltn.net.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6818, 138107, 'PT Virtual Data Centra Indonesia', 'vdc.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6819, 138109, 'PT. Rasi Bintang Perkasa', 'rasibintang.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6820, 138112, 'PT. Megarap Mitra Solusi', 'mms.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6821, 138113, 'PT Amron Citinet', 'citinet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6822, 138114, 'Diskominfo Kabupaten Tangerang', 'tangerangkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6823, 138115, 'PT Deneva', 'deneva.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6824, 138116, 'PT. Media Tekno Nusantara', 'emtn.co.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6825, 138117, 'PT. Solusindo Basis Teknologi', 'sobat.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6826, 138118, 'PT Net Sentra Cyberindo', 'netsentra.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6827, 138119, 'PT Integra Kreasitama Solusindo', 'integrasia.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6828, 13812, 'Fisher Scientific', 'thermofisher.com', 'US', 1536, 'business', '1999-09-14 00:00:00', 0),
(6829, 138122, 'IAIN Langsa', 'iainlangsa.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6830, 138123, 'PT. ADEAKSA INDO JAYATAMA', 'dexanet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6831, 138124, 'Universitas Samudra', 'unsam.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6832, 138125, 'PT Mandiri Citra Informasi Teknologi', 'matrainfotek.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6833, 138126, 'PT. NEWTON CIPTA INFORMATIKA', 'newtonindonesia.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6834, 138127, 'PEMERINTAH KABUPATEN MADIUN', 'madiunkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6835, 138128, 'PT Solnet Indonesia', 'solnet.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6836, 138129, 'PT Sinergi Inti Andalan Prima', 'siapnetworks.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6837, 13813, 'BroadSoft, Inc.', 'broadsoft.com', 'US', 256, 'business', '2010-07-09 00:00:00', 0),
(6838, 138130, 'PT PHATRIA INTI PERSADA', 'phatriasulung.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6839, 138131, 'CV. NATANETWORK SOLUTION', 'natanetwork.com', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6840, 138132, 'PT. FASTEL SARANA INDONESIA', 'globe.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6841, 138134, 'PT Tunas Link Indonesia', 'tunaslink.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6842, 138135, 'Pemerintah Kabupaten Tanah Bumbu', 'tanahbumbukab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(6843, 138136, 'Universitas Mataram', 'unsam.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6844, 138138, 'PT. Cyberindo Aditama', 'cbn.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(6845, 138139, 'PT Jaringan Komunikasi Lintas Data', 'apjii.or.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(6846, 13814, 'RCB Bank', 'rcbbank.com', 'US', 512, 'business', '2014-11-24 00:00:00', 0),
(6847, 138141, 'PT. Waluya Istana Nusantara', 'waluya.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(6848, 138142, 'Institut Informatika & Bisnis Darmajaya', 'darmajaya.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6849, 138143, 'PT GERBANG AKSES INDONESIA', 'gerbangakses.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(6850, 138144, 'Institut Agama Islam Negeri Kediri', 'iainkediri.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(6851, 138145, 'Advanced Information Company Limited', 'cloudix.online', 'HK', 5120, 'business', '0000-00-00 00:00:00', 0),
(6852, 138146, 'Mohammad SAHIDUL ISLAM', 'northbengalonline.com.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6853, 138147, 'Philippine Cable Television Association, Inc.', 'pcta.org.ph', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6854, 138148, 'MULTI DOMAIN RESOURCES AND SERVICES', 'multidomain.com.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(6855, 138149, 'Match Net', 'matchnetbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6856, 138150, 'Salim Khan & Milon Raihan', 'shongzogbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6857, 138152, 'YISU CLOUD LTD', 'yisu.com', 'HK', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(6858, 138154, 'Thomson Reuters International Services Pvt Ltd', 'thomsonreuters.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6859, 138155, 'JAWAHARLAL NEHRU UNIVERSITY', 'jnu.ac.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(6860, 138156, 'CSNE Co., Ltd.', 'csne.co.th', 'TH', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(6861, 138158, 'Serge Pun & Associate (Myanmar) Ltd.', 'yomastrategic.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(6862, 13816, 'Vigilant Technologies', 'vigilant1.com', 'US', 1280, 'business', '2010-05-05 00:00:00', 0),
(6863, 138161, 'SBI Funds Management Private Limited', 'sbimf.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6864, 138162, 'Bayer Cropscience Limited', 'bayer.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6865, 138163, 'Bangladesh University of Professionals (BUP)', 'bup.edu.bd', 'BD', 512, 'education', '0000-00-00 00:00:00', 0),
(6866, 138165, 'Strategic Integrated Solutions P/L', 'strategicgroup.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6867, 138167, 'TrueNET', 'truenet.com', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(6868, 138168, 'MyanmarAPN', 'myanmarapn.com', 'MM', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6869, 138169, 'DP Technologies (Pvt) Ltd', 'dptec.lk', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(6870, 13817, 'Cantillon Capital Management, LLC', 'cantillon.com', 'US', 256, 'business', '2008-08-06 00:00:00', 0),
(6871, 138170, 'Md Omrul Islam', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6872, 138171, 'E-Village', 'evillagectg.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6873, 138172, 'Boom Info Tech (SMC-Pvt) Ltd', 'boominfotech.net', 'PK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(6874, 138173, 'Mortgage Choice Limited', 'mortgagechoice.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6875, 138176, 'Ameriprise India Pvt Ltd', 'ameriprise.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6876, 138177, 'NOMINET UK', 'nic.uk', 'GB', 768, 'business', '0000-00-00 00:00:00', 0),
(6877, 138178, 'Md. Mustak Ahmed t/a M/S M.S. Technology', 'mstechnologybd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6878, 138179, 'PACIFIC MOBILE TELECOM', 'pmt.pf', 'PF', 3072, 'isp', '0000-00-00 00:00:00', 0),
(6879, 138180, 'Ernst & Young Services Pty Ltd', 'ey.com', 'AU', 8704, 'business', '0000-00-00 00:00:00', 0),
(6880, 138183, 'Computer Mate', 'computermate.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6881, 138184, 'Activ ICT Networks PTY Ltd', 'activict.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6882, 138185, 'COSMIC NET PRIVATE LIMITED', 'cosmicnet.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6883, 138187, 'AYONE COMPUTERS LIMITED', 'loudnclear.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(6884, 138189, 'Securecom Ltd', 'securecom.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(6885, 13819, 'INDIGITAL TELECOM', 'indigital.net', 'US', 16384, 'business', '1999-09-14 00:00:00', 0),
(6886, 138192, 'Milon Molla', 'None', 'BD', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6887, 138195, 'MOACK.Co.LTD', 'moack.net', 'KR', 9728, 'hosting', '0000-00-00 00:00:00', 0),
(6888, 138196, 'YM Network Technology Limited', 'ymidc.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(6889, 138197, 'WINK NETWORK', 'winkbd.net', 'BD', 2816, 'isp', '0000-00-00 00:00:00', 0),
(6890, 138198, 'Bengal Broadband Limited', 'bbl.net.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6891, 138199, 'Transatel', 'transatel.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(6892, 1382, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 256, 'isp', '1994-11-23 00:00:00', 0),
(6893, 13820, 'Vacares LLC', 'vacares.com', 'US', 1280, 'business', '2019-08-21 00:00:00', 0),
(6894, 138201, 'Melbourne Girls Grammar School', 'mggs.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(6895, 138203, 'Sonali Bank Limited', 'sonalibank.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(6896, 138204, 'Sophon Broadband Networks co.,ltd', 'sbnnet.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(6897, 138205, 'Mohammad Mahbubur Rahman', 'rmnetbd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(6898, 138206, 'Bank First', 'bankfirst.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6899, 138207, 'ORACLE CUSTOMER MANAGEMENT SOLUTIONS PTY. LTD.', 'oraclecms.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6900, 138208, 'The Introvision', 'theintrovision.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6901, 138209, 'Programmed Maintenance Services Limited', 'programmed.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6902, 13821, 'AllianceBernstein L.P.', 'abglobal.com', 'US', 3072, 'business', '1999-08-23 00:00:00', 0),
(6903, 138212, 'SpaceNet Ltd.', 'spacenetbd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6904, 138213, 'LankaBangla Finance Limited', 'lankabangla.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6905, 138214, 'RAMPANT TECHNOLOGY PTY. LTD.', 'rampant.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6906, 138215, 'Royal Thai Police', 'royalthaipolice.go.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(6907, 138216, 'Burwood Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6908, 138218, 'ABOITIZ EQUITY VENTURES INC.', 'aboitiz.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(6909, 138219, 'MADINA', 'madinacast.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(6910, 13822, 'Milton Academy', 'milton.edu', 'US', 1024, 'education', '2007-06-07 00:00:00', 0),
(6911, 138220, 'Sasa Broadband Technologies Pvt. Ltd.', 'sasabroadband.com', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6912, 138221, 'Ynet Telecom Solutions', 'ynettelecom.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6913, 138223, 'Websupporters Technologies Private Limited', 'websupporters.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6914, 138225, 'One Eight Technologies Private Limited', 'oneeight.co.in', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(6915, 138227, 'Streamonn Internet Services Private Limited', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6916, 13823, 'Mesh.Net', 'mesh.net', 'US', 4608, 'business', '2006-04-17 00:00:00', 0),
(6917, 138231, 'Indian Institute Of Information Technology Allahabad', 'iiita.ac.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(6918, 138235, 'Airnetz Broadband Services Private Limited', 'airnetz.net.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6919, 138236, 'ATS NETWORK', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6920, 138237, 'Gobalstep Services Pvt Ltd', 'globalstep.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6921, 138239, 'Vaishnavi Online Internet Services Pvt. Ltd.', 'vaishnavionline.in', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6922, 138240, 'Net On Broadband Services Private Limited', 'neton.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6923, 138241, 'Compatible Network Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6924, 138242, 'Nandini Broadband Pvt. Ltd.', 'nandinibb.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6925, 138245, 'Xpress Net Solution', 'None', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(6926, 138246, 'Netclues Technologies Private Limited', 'netclues.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6927, 138247, 'Liquid Propulsion Systems Centre', 'lpsc.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6928, 138248, 'Ndimensionz Solutions Pvt Ltd', 'ndimensionz.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6929, 13825, 'Troy Cablevision, Inc.', 'troycable.net', 'US', 42752, 'isp', '2006-07-11 00:00:00', 0),
(6930, 138250, 'Medline Industries India Pvt Ltd', 'medline.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6931, 138251, 'Zinios Information Technology Pvt Ltd', 'ziniostech.com', 'IN', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(6932, 138252, 'Maahi Telecommunication Private Limited', 'maahitelecom.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6933, 138253, 'Valuemobi Media Pvt Ltd', 'vmobi.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6934, 138254, 'VINAYAKKRIPA INFOTECH SERVICES PVT. LTD.', 'vinayakinfotechservices.in', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6935, 138257, 'Gigatel Infocomm Pvt Ltd', 'gigatel.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6936, 138258, 'B-fi Networks Pvt. Ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6937, 138259, 'Manish Infocom Private Limited', 'manishinfocom.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6938, 138260, 'Shirsty Internet Services Pvt Ltd', 'shirstyservices.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6939, 138261, 'Speedyquick Network Private Limited', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6940, 138262, 'Space Broadband', 'mahattpl.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6941, 138263, 'Namoh Networks Udaipur Private Limited', 'namohnetworks.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(6942, 138264, 'Ablink Network Opc Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6943, 138267, 'Bsl Technologies Pvt. Ltd.', 'None', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(6944, 138269, 'Wizbyte Networks Private Limited', 'wizbytenetworks.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6945, 13827, 'Washington Post', 'washpost.com', 'US', 256, 'business', '2006-02-10 00:00:00', 0),
(6946, 138270, 'Home Credit India Finance Private Limited', 'homecredit.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6947, 138272, 'Hi5 Multimedia Services Pvt Ltd', 'hi5broadband.com', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(6948, 138274, 'Gigalo Communication Pvt. Ltd.', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(6949, 138275, 'Malik Cable And Broadband', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6950, 138276, 'Typhoon Communication Pvt. Ltd.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6951, 138277, 'Radinet Info Solutions Private Limited', 'radinet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6952, 138278, 'Nikita Broadband Pvt. Ltd.', 'nikitabroadband.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6953, 138279, 'Onepipe Telecom Pvt Ltd', 'onepipe.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6954, 13828, 'I-2000, Inc.', 'i-2000.com', 'US', 2304, 'business', '1999-08-24 00:00:00', 0),
(6955, 138280, 'Panav Network And Communications Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(6956, 138281, 'Hybrid Hash Pvt Ltd', 'None', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6957, 138282, 'Delhi Metro Rail Corporation Limited', 'dmrc.org', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6958, 138285, 'Mando Automotive India Private Limited', 'halla.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6959, 138287, 'Uzaina Business India Pvt Ltd', 'uzbinternet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6960, 138289, 'Smart Choice Wireless Network Pvt Ltd', 'smartfibernet.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6961, 13829, 'Pima County', 'pima.gov', 'US', 65536, 'business', '2013-05-20 00:00:00', 0),
(6962, 138290, 'Unigro Infranet Online Pvt. Ltd.', 'unigroinfranetonline.com', 'IN', 1792, 'isp', '0000-00-00 00:00:00', 0),
(6963, 138291, 'Mall And Mall Digiworld Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6964, 138292, 'Galaxy Digitech India Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6965, 138293, 'Spacetrade Internet Pvt Ltd', 'spacetradesolutions.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(6966, 138294, 'Sky Data Labs', 'skydatalabs.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6967, 138296, 'Juweriyah Networks Private Limited', 'juweriyahnetwork.com', 'IN', 7424, 'isp', '0000-00-00 00:00:00', 0),
(6968, 138297, 'Netlink Websolution Pvt. Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(6969, 138298, 'A2j Data Services Pvt. Ltd.', 'a2jdata.com', 'IN', 1536, 'business', '0000-00-00 00:00:00', 0),
(6970, 138299, 'R.S.G. SMART NETWORK', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(6971, 1383, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 512, 'isp', '1994-11-23 00:00:00', 0),
(6972, 13830, 'Nexril', 'nexril.net', 'US', 8704, 'business', '2017-08-10 00:00:00', 0),
(6973, 138300, 'Opticom Networks Private Limited', 'optinet.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6974, 138301, 'S B Multimedia Pvt. Ltd.', 'ibc24.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6975, 138302, 'Isparrow Digital India Pvt. Ltd.', 'isparrow.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6976, 138304, 'Decon Construction Company', 'deconhost.com', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(6977, 138309, 'Amar Broadband Pvt Ltd', 'amarbroadband.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6978, 13831, 'PogoZone', 'pogozone.com', 'US', 4608, 'isp', '1999-08-24 00:00:00', 0),
(6979, 138310, 'Jubilant Foodworks Limited', 'jublfood.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6980, 138311, 'Limerick Technologies Pvt. Ltd.', 'limerick.co.in', 'IN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(6981, 138312, 'Best telnet services private limited', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(6982, 138313, 'Am Broadband Private Limited', 'amnetworkingindia.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(6983, 138315, 'Countrylink Communiction Pvt Ltd', 'countrylink.in', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6984, 138316, 'Vinayaga Communications Pvt Ltd', 'vnetisp.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6985, 138317, 'Gaurav Communication Pvt Ltd', 'gauravcommunication.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(6986, 138318, 'The Visakhapatnam Cooperative Bank Ltd', 'vcbl.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6987, 138320, 'Shamsuzzaman Mamun', 'falconlink.net.bd', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(6988, 138322, 'Afghan Wireless', 'afghan-wireless.com', 'AF', 14080, 'isp', '0000-00-00 00:00:00', 0),
(6989, 138323, 'Opticomm Co Pty Ltd', 'opticomm.net.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(6990, 138324, 'JHELUM NETWORKS PVT LTD', 'jhelum.net', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(6991, 138325, 'Ether Link', 'etherlinkbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(6992, 138326, 'THE TRUSTEE FOR SENTELLA DISCRETIONARY TRUST & THE TRUSTEE FOR THE COX FAMILY TRUST', 'innessco.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(6993, 138327, 'Skava Systems Private Limited.', 'skava.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(6994, 138329, 'Kenstar Web Solutions Private Limited', 'kenstar.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(6995, 13833, 'Nos Communications', 'nos.com', 'US', 512, 'business', '1999-08-24 00:00:00', 0),
(6996, 138331, 'Fidessa Pty ltd', 'fidessa.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(6997, 138332, 'VOICE PRINT & DATA AUSTRALIA PTY LTD', 'voiceprintdata.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(6998, 138336, 'THE POTATO', 'the-potato.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(6999, 138337, 'CSC Australia Pty Ltd', 'csc.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7000, 138338, 'CTG.NET', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7001, 138339, 'SMARTSEL SDN BHD', 'smartsel.co', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(7002, 13834, 'AGL Resources Inc.', 'aglresources.com', 'US', 768, 'business', '1999-08-24 00:00:00', 0),
(7003, 138340, 'ESURFING TECHNOLOGY CO.LTD', 'esurfingkh.com', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7004, 138341, 'SHOPEE SINGAPORE PRIVATE LIMITED', 'shopee.com', 'SG', 3840, 'business', '0000-00-00 00:00:00', 0),
(7005, 138342, 'CSC Australia Pty Ltd', 'csc.com.au', 'AU', 768, 'business', '0000-00-00 00:00:00', 0),
(7006, 138343, 'Cyber Net Communications', 'cybernetcommunications.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7007, 138344, 'MSIG Insurance (Thailand) Co., Ltd., Installation Site MSIG Insurance (Thailand) Co., Ltd., Kwang, Khet , Province Bangkok', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7008, 138346, 'Sajid Trading Ltd.', 'stl-bd.net', 'BD', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7009, 138348, 'Antarctica New Zealand', 'antarcticanz.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7010, 138349, 'Sky Net Multi Services Pvt Ltd', 'snms.net.pk', 'PK', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7011, 138350, 'PRABHU DIGITAL PVT. LTD.', 'prabhutv.com.np', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(7012, 138352, 'D T Consulting Limited', 'takeshi.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7013, 138353, 'NIST INTERNATIONAL SCHOOL', 'nist.ac.th', 'TH', 256, 'education', '0000-00-00 00:00:00', 0),
(7014, 138354, 'LocalDC Pty Ltd', 'localdc.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7015, 138355, 'Warner Telecommunication LTD', 'warnertelecom.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7016, 138357, 'Alliance Broadband Bd Ltd.', 'alliancebb.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7017, 138359, 'DataKL Solutions Sdn Bhd', 'datakl.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(7018, 13836, 'Nasdaq, Inc.', 'nasdaq.com', 'US', 512, 'business', '1999-08-25 00:00:00', 0),
(7019, 138360, 'Southern Cross Medical Care Society', 'southerncross.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7020, 138361, 'Alliance Bank Malaysia Berhad', 'alliancefg.com', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(7021, 138362, 'Md. Mobarak Hossain', 'plexus.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7022, 138363, 'Royal Agricultural Society of NSW', 'rasnsw.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7023, 138364, 'UNIFY NETSOL PRIVATE LIMITED', 'unifynetsol.net', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7024, 138367, 'Transport for NSW', 'nsw.gov.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7025, 138368, 'INSTACOM Pvt. LTD', 'insta.com.pk', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7026, 138369, 'CERNET2 regional IX at Shenzhen University', 'cernet.edu.cn', 'CN', 6400, 'education', '0000-00-00 00:00:00', 0),
(7027, 13837, 'Point5 Managed Services, LLC', 'point5.net', 'US', 768, 'business', '2018-05-07 00:00:00', 0),
(7028, 138371, 'CERNET2 regional IX at Ocean University of China', 'cernet.edu.cn', 'CN', 23808, 'education', '0000-00-00 00:00:00', 0),
(7029, 138372, 'Janome Australia Pty Ltd', 'janome.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7030, 138379, 'Satellite Cable Network, Inc.', 'scni-pampanga.com', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7031, 13838, 'Emerson College', 'emerson.edu', 'US', 8192, 'education', '2006-02-10 00:00:00', 0),
(7032, 138380, 'VOLVO GROUP KOREA CO LTD, Construction Equipment Seoul', 'volvo.com', 'KR', 1024, 'business', '0000-00-00 00:00:00', 0),
(7033, 138382, 'Begum Rokeya University, Rangpur', 'brur.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(7034, 138383, 'Moustafa Ferdous', 'acnbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7035, 138384, 'Rakuten Mobile Network, Inc.', 'rakuten.com', 'JP', 195584, 'isp', '0000-00-00 00:00:00', 0),
(7036, 138385, 'Chittagong Data Communication', 'cdc-bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7037, 138386, 'Australian Turf Club Limited', 'australianturfclub.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7038, 138388, 'Pokhara Internet Pvt. Ltd.', 'pokharainternet.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7039, 138389, 'WTW Global Delivery and Solutions (India) Pvt. Ltd.', 'trinity-mumbai.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7040, 13839, 'Piper Jaffray Companies', 'pjc.com', 'US', 1536, 'business', '2005-07-15 00:00:00', 0),
(7041, 138390, 'Trinity Grammar School', 'trinity.nsw.edu.au', 'AU', 1024, 'education', '0000-00-00 00:00:00', 0),
(7042, 138392, 'Colleagues Technology CO. ,LIMITED', 'desen.hk', 'HK', 84480, 'hosting', '0000-00-00 00:00:00', 0),
(7043, 138394, 'Invesco Group Services, Inc.', 'invesco.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7044, 138397, 'Md. Shazzad Hossain', 'savarnetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7045, 138398, 'Prodigi Technology Services Limited', 'prodigi.nz', 'NZ', 1280, 'business', '0000-00-00 00:00:00', 0),
(7046, 138399, 'VADACOM LIMITED', 'vadacom.com', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(7047, 138400, 'Chu Hai College of Higher Education', 'chuhai.edu.hk', 'HK', 512, 'education', '0000-00-00 00:00:00', 0),
(7048, 138401, 'MM-VERUMLIB CO., LTD.', 'verumlib.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(7049, 138402, 'Netey Networks LLC', 'hostease.com', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(7050, 138403, 'Bismilla Enterprise', 'None', 'BD', 768, 'hosting', '0000-00-00 00:00:00', 0),
(7051, 138407, 'The Internet Data Center of Guizhou Mobile Communication Company Limited', 'chinamobile.com', 'CN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7052, 138411, 'Telnet Technoinfra Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7053, 138412, 'Golam Rabbani Chowdhury', 'asiancommunicationbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7054, 138414, 'Lone Star Cable Network LLC', 'lonestarcable.net', 'NZ', 768, 'business', '0000-00-00 00:00:00', 0),
(7055, 138415, 'HENGDA NETWORK LIMITED', 'None', 'HK', 16384, 'hosting', '0000-00-00 00:00:00', 0),
(7056, 138418, 'Tarik Hasan Turja', 'citylink.net.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7057, 138419, 'Pico (Singapore) Pte. Ltd.', 'pico.net', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(7058, 138421, 'China Unicom', 'chinaunicom.cn', 'CN', 36864, 'isp', '0000-00-00 00:00:00', 0),
(7059, 138422, 'ITC', 'csloxinfo.net', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7060, 138423, 'CMPak Limited', 'zong.com.pk', 'PK', 3840, 'isp', '0000-00-00 00:00:00', 0),
(7061, 138424, 'Federal Board of Revenue', 'fbr.gov.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(7062, 138425, 'R Systems International Limited', 'rsystems.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7063, 138427, 'Thailand Institute of Nuclear Technology (Public Organization)', 'tint.or.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7064, 13843, 'Phoenix American Inc.', 'phxa.com', 'US', 1024, 'business', '2001-10-18 00:00:00', 0),
(7065, 138431, 'Md Mazaher Hossain', 'speed2000bd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7066, 138432, 'JS Technology', 'jstbd.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(7067, 138433, 'GMO GlobalSign Pte Ltd', 'globalsign.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(7068, 138437, 'General Communication', 'gci.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7069, 138439, 'Jumio India Pvt. Ltd.', 'jumio.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7070, 13844, 'St. John\'s Riverside Hospital', 'riversidehealth.org', 'US', 256, 'business', '2014-01-27 00:00:00', 0),
(7071, 138443, 'Rupali Bank Limited', 'rupalibank.org', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7072, 138444, 'K-Electric Limited', 'ke.com.pk', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(7073, 138447, 'The College of Law Limited', 'collaw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7074, 138449, 'SIANG YU SCIENCE AND TECHNOLOGY LIMITED', 'vocom.com', 'HK', 1536, 'isp', '0000-00-00 00:00:00', 0),
(7075, 13845, 'Flexential Colorado Corp.', 'flexential.com', 'US', 3584, 'hosting', '1999-08-26 00:00:00', 0),
(7076, 138453, 'GCS (Private) Limited', 'gcspvt.com', 'PK', 1024, 'business', '0000-00-00 00:00:00', 0),
(7077, 138454, 'Bikrampur global network', 'bikrampurglobalnetwork.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(7078, 138455, 'Ballarat Health Services', 'grampianshealth.org.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7079, 138456, 'OceanBlue Cloud Technology Limited', 'oceanbluecloud.com', 'HK', 2816, 'business', '0000-00-00 00:00:00', 0),
(7080, 138458, 'NEC ASIA PACIFIC PTE LTD', 'nec.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(7081, 138459, 'NEC ASIA PACIFIC PTE LTD', 'nec.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(7082, 13846, 'Lavalife Corp.', 'lavalife.com', 'CA', 1280, 'business', '2006-07-11 00:00:00', 0),
(7083, 138460, 'AU IX Pty Limited', 'auix.com.au', 'AU', 4864, 'business', '0000-00-00 00:00:00', 0),
(7084, 138465, 'World Communication Internet Service', 'worldbd.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7085, 138466, 'DataMossa', 'datamossa.com', 'AU', 2816, 'business', '0000-00-00 00:00:00', 0),
(7086, 138467, 'Yahagi Network Solutions', 'yahagi.moe', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(7087, 138468, 'Wenona School Limited', 'wenona.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7088, 138469, 'Victorian Commission for Gambling and Liquor Regulation', 'vcglr.vic.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7089, 13847, 'RoadRunner', 'roadrunnerwireless.net', 'None', 512, 'business', '2004-12-22 00:00:00', 0),
(7090, 138470, 'Trust Bank Ltd', 'trustbank.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7091, 138471, 'Gangachara Online', 'gangacharaonline.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7092, 138472, 'Grasp Food (Pvt) Ltd.', 'grasp.group', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7093, 138473, 'Sabuj Bangla Online', 'sbonlinebd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7094, 138475, 'STORAGECRAFT INDO-PACIFIC PTY LTD', 'storagecraft.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7095, 138476, 'SKY LINK ISP', 'skylinkisp.org', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7096, 138477, 'Scotch College', 'scotch.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7097, 138481, 'Lear Corporation', 'lear.com', 'SG', 2048, 'business', '0000-00-00 00:00:00', 0),
(7098, 138482, 'SKYVIEW ONLINE LTD', 'skyviewonlineltd.com', 'BD', 1536, 'isp', '0000-00-00 00:00:00', 0),
(7099, 138484, 'Hays Specialist Recruitment (Australia) Pty Ltd', 'hays.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7100, 138485, 'PrimeCredit Limited', 'primecredit.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7101, 138487, 'FNF NETWORK', 'fnfnetwork.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(7102, 138488, 'Moonee Valley City Council', 'mvcc.vic.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7103, 138489, 'Mawlana Bhashani Science and Technology University', 'mbstu.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(7104, 138490, 'Alltel Pty Ltd', 'alltel.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7105, 138491, 'LR Telecom Ltd.', 'lrtelbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7106, 138492, 'Chittagong Focus Online', 'focusonlinectg.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(7107, 138493, 'Class Limited', 'class.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7108, 138494, 'Campana TARO Co., Ltd.', 'campanaworks.com', 'TH', 768, 'isp', '0000-00-00 00:00:00', 0),
(7109, 138495, 'Alisha Communication Link Pvt.Ltd', 'alishalink.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7110, 138496, 'Inspiro Relia, Inc', 'inspiro.com', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(7111, 138497, 'Web Solution', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7112, 138498, 'Allette Systems (Australia) Pty Ltd', 'allette.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7113, 138499, 'OPSM Pty Ltd', 'luxottica.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7114, 138500, 'FIBERTEL FIBERNET PVT. LTD', 'None', 'NP', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7115, 138501, 'Unified Core Limited', 'unifiedcoreltd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7116, 138502, 'Xtnda', 'xtnda.net', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7117, 138503, 'Snowy Hydro Limited', 'snowyhydro.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7118, 138504, 'Universiti Pertahanan Nasional Malaysia', 'upnm.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(7119, 138505, 'DNSBD', 'dnsbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7120, 138506, 'PNG Nambawan Trophy Ltd', 'pngnwtl.com', 'PG', 512, 'isp', '0000-00-00 00:00:00', 0),
(7121, 138509, 'RELATION CABLE NETWORK', 'rcnbdnet.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7122, 13851, 'SevenL Networks', 'sevenl.net', 'CA', 4096, 'business', '2006-02-10 00:00:00', 0),
(7123, 138511, 'Netier Pty Limited', 'netier.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7124, 138515, 'Excellence SOLUTIONS CO., LTD.', 'beetech.asia', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(7125, 138516, 'CommVerge Solutions Limited', 'commverge.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7126, 138517, 'MamaCloud IT Network & System Development', 'mamacloudtech.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7127, 138519, 'Excite Limited', 'excitepng.com', 'PG', 512, 'isp', '0000-00-00 00:00:00', 0),
(7128, 138520, 'Lalu Network Solutions Private Limited', 'lnspl.in', 'IN', 3328, 'isp', '0000-00-00 00:00:00', 0),
(7129, 138522, 'Kazi Rajib Ferdous t/a Chocolate Broadband', 'chocolatebroadband.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7130, 138523, 'Sylhet Communcation Systems Limited', 'scslbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7131, 138525, 'Miniport Pty Ltd', 'miniport.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7132, 138526, 'Direct Media Pvt. Ltd', 'directmedia.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(7133, 138527, 'ADC GROUP CO.,LIMITED', 'adcstack.com', 'HK', 9472, 'isp', '0000-00-00 00:00:00', 0),
(7134, 138528, 'EMPIRE TECH Co., Ltd.', 'empiretech.com.kh', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(7135, 138529, 'DATANET WIFI', 'datanetsrl.com.ar', 'BT', 256, 'business', '0000-00-00 00:00:00', 0),
(7136, 13853, 'ECTISP Ellis County Texas Internet Service Provider Inc.', 'ectisp.net', 'US', 8192, 'isp', '2006-07-14 00:00:00', 0),
(7137, 138532, 'PingAn Technology (HK) Limited', 'pingan.com', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(7138, 138534, 'Matrix BD', 'matrixbdisp.net', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(7139, 138536, 'Premium Connectivity Limited', 'pmcon.net', 'BD', 5120, 'isp', '0000-00-00 00:00:00', 0),
(7140, 138537, 'Barker College', 'barker.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7141, 138538, 'Ningbo Nanbian Tuoluo Xinxi Jishu Co., Ltd', 'vpsor.com', 'CN', 6144, 'hosting', '0000-00-00 00:00:00', 0),
(7142, 138539, 'Jewel Changi Airport Trustee Pte. Ltd.', 'jewelchangiairport.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(7143, 13854, 'The Johannesburg Stock Exchange (JSE Limited)', 'jse.co.za', 'ZA', 256, 'business', '1999-08-27 00:00:00', 0),
(7144, 138540, 'The Insular Life Assurance Company, Ltd.', 'insular.com.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7145, 138543, 'Cablevision Systems Corporation', 'cablevision.com', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7146, 138544, 'HK Online', 'hkonline.com.bd', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7147, 138545, 'Santiago Network Service LLC', 'rixcloud.io', 'CL', 768, 'business', '0000-00-00 00:00:00', 0),
(7148, 138546, 'Ncell Pty. Ltd.', 'axiata.com', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(7149, 138547, 'Ubon Ratchathani Rajabhat University', 'uni.net.th', 'TH', 256, 'isp', '0000-00-00 00:00:00', 0),
(7150, 138549, 'Net Cafe', 'netcafe-bd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(7151, 13855, 'The Municipal Communications Utility of the City of Cedar Falls, Iowa', 'cfunet.net', 'US', 24576, 'isp', '1999-08-27 00:00:00', 0),
(7152, 138550, 'Jagannath University', 'jnu.ac.bd', 'BD', 256, 'education', '0000-00-00 00:00:00', 0),
(7153, 138551, 'Skyinfo Online', 'skyinfoonline.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7154, 138552, 'RTB HOUSE PTE. LTD.', 'rtbhouse.com', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(7155, 138556, 'Armour Technologies Ltd.', 'armourtechnologies.net', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7156, 138557, 'NET CONNECT', 'netconnectbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7157, 138559, 'Bank of Queensland Ltd', 'boq.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7158, 138561, 'BroadBandZone', 'broadbandzone.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7159, 138562, 'Cre.Ative IT Pty. Ltd.', 'creativeit.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7160, 138563, 'LittleMan Pty Ltd', 'littleman.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7161, 138565, 'Vrednus Network Private Limited', 'vrednus.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7162, 138566, 'Dhaka University of Engineering & Technology, Gazipur', 'duet.ac.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(7163, 138567, 'The Computer Systems', 'None', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7164, 138568, 'Central Telecoms Pty Ltd', 'centraltelecoms.com.au', 'AU', 2304, 'isp', '0000-00-00 00:00:00', 0),
(7165, 138569, 'Tech2go Startegic IT Solutions', 'tech2go.ph', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7166, 13857, 'Online Northwest', 'onlinenw.com', 'US', 16128, 'isp', '1999-08-30 00:00:00', 0),
(7167, 138570, 'AresFlare Network Limited', 'aresflare.com', 'HK', 2304, 'isp', '0000-00-00 00:00:00', 0),
(7168, 138571, 'SUPERCLOUDS LIMITED', 'superclouds.net', 'HK', 13056, 'hosting', '0000-00-00 00:00:00', 0),
(7169, 138572, 'Four G Telecom Pty Ltd', 'fourgtelecom.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7170, 138573, 'University of Barisal', 'bu.ac.bd', 'BD', 256, 'education', '0000-00-00 00:00:00', 0),
(7171, 138574, 'Global Network', 'globalnetworkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7172, 138575, 'APPLE NET', 'applenetbd.com', 'BD', 1280, 'business', '0000-00-00 00:00:00', 0),
(7173, 138576, 'CodecCloud (HK) Limited', 'gaoshi.cloud', 'HK', 3072, 'isp', '0000-00-00 00:00:00', 0),
(7174, 138578, 'East West University', 'ewubd.edu', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(7175, 13858, 'TransCanada Pipelines Limited', 'transcanada.com', 'US', 256, 'business', '1999-08-30 00:00:00', 0),
(7176, 138581, 'Britto Network', 'brittonetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7177, 138582, 'Greeting\'s Online', 'greetingsonlinebd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7178, 138583, 'Imdex Limited', 'imdexlimited.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7179, 138587, 'Patuakhali Science and Technology University', 'pstu.ac.bd', 'BD', 256, 'education', '0000-00-00 00:00:00', 0),
(7180, 138588, 'Diebold Nixdorf Singapore PTE. LTD.', 'dieboldnixdorf.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7181, 138590, 'Prime Networks', 'prime.net.pk', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7182, 138592, 'PRIVATE DATA CLOUDS PTY LTD', 'pdclouds.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7183, 138593, 'Diebold Nixdorf Singapore PTE. LTD.', 'dieboldnixdorf.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7184, 138594, 'CoLoCity Ltd', 'colocity.com.bd', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7185, 138596, 'Valley International', 'valleyinternational.org', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7186, 13860, 'Lincoln Financial Group', 'lincolnfinancialfield.com', 'US', 18944, 'business', '1999-08-31 00:00:00', 0),
(7187, 138600, 'Achiever Broadband Internet', 'abibd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7188, 138601, 'Coloasia Limited', 'coloasiabd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7189, 138602, 'Stellar Digital Limited', 'bongobd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7190, 138605, 'NIC ASIA Bank', 'nicasiabank.com', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(7191, 138606, 'Suga Pte. Ltd', 'suga.vn', 'SG', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7192, 138607, 'HK HERBTECK CO.,LIMITED', 'herbtech.com.cn', 'CN', 2816, 'isp', '0000-00-00 00:00:00', 0),
(7193, 138608, 'Cloud Host Pte Ltd', 'cloudhost.asia', 'SG', 768, 'hosting', '0000-00-00 00:00:00', 0),
(7194, 138609, '113 CLOUD COMPUTING (HONG KONG) LIMITED', 'aenx.net', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(7195, 138611, 'Cloud Speed Technology Limited Co.', 'cloudtopspeed.com', 'TW', 2304, 'business', '0000-00-00 00:00:00', 0),
(7196, 138612, 'AMR NET', 'amrnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7197, 138613, 'CONNECT TEL PTY LTD', 'connecttel.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7198, 138614, 'FR Express', 'frexpress.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7199, 138615, 'Gardenia Cyber Communication', 'gccbdltd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7200, 138616, 'Sanuk Systems (Thailand) Co., Ltd', 'sanuksystems.com', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(7201, 138618, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 512, 'business', '2006-11-29 00:00:00', 0),
(7202, 138619, 'Net @ Home', 'netathomebd.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(7203, 13862, 'North Carolina State University', 'ncsu.edu', 'US', 256, 'education', '2018-10-01 00:00:00', 0),
(7204, 138620, 'Kriti Darshan Media Pvt. Ltd.', 'kritinet.com.np', 'NP', 1024, 'business', '0000-00-00 00:00:00', 0),
(7205, 138621, 'City Net Communication', 'citynet.live', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7206, 138622, 'Unique Communication Service', 'uniquecommunication.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7207, 138623, 'Winer Communication', 'None', 'BD', 768, 'hosting', '0000-00-00 00:00:00', 0),
(7208, 138624, 'NORTHERN STEVEDORING SERVICES PTY LTD', 'northernstevedoring.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7209, 138625, 'Dreams Network & Technology Pvt Ltd', 'dreamnw.com', 'PK', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7210, 138626, 'AVALOQ SOURCING ASIA PACIFIC (SINGAPORE) PTE. LTD.', 'avaloq.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7211, 138627, 'Cato Networks, Inc.', 'catonetworks.com', 'HK', 256, 'isp', '0000-00-00 00:00:00', 0),
(7212, 138629, 'NSM SOLUTION AND MAINTENANCE CO., LTD.', 'nsmsolution.com.kh', 'KH', 1024, 'business', '0000-00-00 00:00:00', 0),
(7213, 138633, 'Aperim Pty Ltd', 'aperim.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7214, 138634, 'MYNET SOLUTIONS COMPANY LIMITED', 'mynetsolutions.net', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(7215, 138636, 'Lakshmipur Online', 'lakshmipuronline.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7216, 138637, 'VOCPHONE PTY LTD', 'vocphone.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7217, 138638, 'Feni Easy Net', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7218, 138639, 'Kia Motors India Private Limited', 'kiamotorsindia.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7219, 138640, 'IJ Internet Services (PVT.) Limited', 'ijisp.com', 'PK', 512, 'isp', '0000-00-00 00:00:00', 0),
(7220, 138642, 'ITIVITI AUSTRALIA PTY LTD', 'itiviti.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7221, 138645, 'G3S Technologies Co., Limited', 'g3s.com.hk', 'HK', 2816, 'business', '0000-00-00 00:00:00', 0),
(7222, 138649, 'Sarker Net', 'sarkernet.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7223, 138651, 'Spider Net', 'spidernetctg.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7224, 138652, 'Super Godzilla Communications GK', 'supergodzilla.jp', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(7225, 138653, 'Decoy Gaming', 'decoygaming.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7226, 138654, 'Mitsubishi Motors Australia Limited', 'mmal.com.au', 'AU', 3840, 'isp', '0000-00-00 00:00:00', 0),
(7227, 138655, 'Trans World Enterprise Services (Private) Limited', 'transworld-home.com', 'PK', 2560, 'isp', '0000-00-00 00:00:00', 0),
(7228, 138657, 'MarchNet', 'marchnet.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7229, 138658, 'I Communication', 'icommunicationbd.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7230, 138659, 'Cyberlink Online', 'cyberlinkonline.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7231, 13866, 'Computer Country', 'ccountry.net', 'US', 8704, 'business', '1999-08-31 00:00:00', 0),
(7232, 138661, 'PERTHRADCLINIC LTD', 'perthradclinic.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7233, 138662, 'Grace Worldwide Pty Ltd', 'grace.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7234, 138665, 'GK Network', 'gk-network.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7235, 138666, 'MONOROM ADVANCED TECHNOLOGIES CO., LTD.', 'None', 'KH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7236, 138670, 'Ngern Tid Lor Company Limited', 'ngerntidlor.com', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(7237, 138671, 'SAHYOG OPTIC PVT. LTD.', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7238, 138675, 'Jagobd IT Solutions', 'jagobd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7239, 138677, 'ITEL7 PTY LTD', 'itel7.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7240, 138678, 'Grandbo Technology Development Corporation', 'grandbo.com.ph', 'PH', 1024, 'business', '0000-00-00 00:00:00', 0),
(7241, 13868, 'Peak Internet, LLC', 'peak.org', 'US', 49664, 'isp', '1999-08-31 00:00:00', 0),
(7242, 138680, 'COLLECTION HOUSE LIMITED', 'collectionhouse.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7243, 138681, 'AUSTRALIAN SECURITIES & INVESTMENTS COMMISSION (ASIC)', 'asic.gov.au', 'AU', 3072, 'business', '0000-00-00 00:00:00', 0),
(7244, 138682, 'REMOHAND TECHNICAL CO LTD', 'cambotech.com', 'KH', 768, 'business', '0000-00-00 00:00:00', 0),
(7245, 138683, 'Provet Pty Ltd', 'provet.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7246, 138684, 'ManauLinks Co.,Ltd.', 'manaulinks.com', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(7247, 138688, 'Bondhon Online Network', 'bondhonbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7248, 138689, 'CONCEPCION PAY-TV NETWORK, INC.', 'cablelink.com.ph', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7249, 13869, 'Team Worldwide', 'teamww.com', 'US', 256, 'business', '2020-03-02 00:00:00', 0),
(7250, 138691, 'Bangkok Airways Public Company Limited.', 'bangkokair.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7251, 138694, 'SyncIT Bangladesh', 'syncitbd.com', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7252, 138696, 'Solartis Technology Services Private Limited', 'solartis.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7253, 138697, 'Amader Net Ad Communication', 'anc.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7254, 138699, 'TIKTOK PTE. LTD.', 'bytedance.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(7255, 138701, 'Green Zone Online', 'greenzoneonline.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(7256, 138706, 'Fastx Broadband Private Limited', 'fastxbroadband.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7257, 138708, 'Hosting World Pvt Ltd', 'hostitsmart.in', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7258, 138709, 'Ocean Leasedline Wala Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7259, 13871, 'Telebyte NW', 'telebyte.com', 'US', 5120, 'business', '1999-08-31 00:00:00', 0),
(7260, 138710, 'Rajni Internet Service Pvt. Ltd.', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7261, 138711, 'Digital Info Systems', 'dinfosys.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7262, 138712, 'Nuozen Telecom Private Limited', 'nuozen.net', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(7263, 138714, 'Shree Lakshmi Devi Property Developers Pvt Ltd', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7264, 138716, 'Winmax Telecommunication India Private Limited', 'indiawinmax.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7265, 138717, 'Durgamba Broadband Network Private Limited', 'mygefo.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7266, 138718, 'Ekowebtech It Services Pvt Ltd', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7267, 138719, 'Connect Online', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7268, 138720, 'Sudhana Telecommunications Private Limited', 'stpl.network', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7269, 138726, 'Ozzy Infonet India Private Limited', 'onelinkbroadband.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7270, 138727, 'Center For E-governance', 'karnataka.gov.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7271, 138728, 'Kaizen Infosys', 'hostingduty.com', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7272, 138729, 'Speedobits Internet', 'speedobits.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7273, 138730, 'Sns Internet Services Private Limited', 'snsinternet.com', 'IN', 5120, 'isp', '0000-00-00 00:00:00', 0),
(7274, 138731, 'Kovai Fibernet Pvt Ltd', 'kovaifibernet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7275, 138733, 'Maxit Infocom Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7276, 138734, 'Bakliwal Telecom Services Pvt Ltd', 'bfibernet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7277, 138735, 'Prytel Network Private Limited', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7278, 138736, 'Magnuss Broadband Service Pvt Ltd', 'magnuss.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7279, 138737, 'Antarjal It Communication Pvt. Ltd.', 'aitcpl.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7280, 138738, 'speed net', 'speed-net.ch', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7281, 138739, 'Coimbatore Capital Ltd', 'coimbatorecapital.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7282, 138741, 'Mauli Shiv Cable Internet Services Private Limited', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7283, 138743, 'Dolphin Logic System Private Limited', 'dolphindls.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7284, 138745, 'Digiking Communications Pvt Ltd', 'digikingcommunications.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7285, 138746, 'Live Fibernet', 'livefibernet.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(7286, 138747, 'Arisglobal Software Pvt Ltd', 'arisglobal.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7287, 138749, 'Robustedge Software And Digital Networks Pvt. Ltd.', 'robustedge.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7288, 138750, 'Quick Link Broadband And Services Pvt. Ltd.', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7289, 138752, 'Starone Broadband Private Limited', 'staronebroadband.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7290, 138754, 'Kerala Vision Broad Band Private Limited', 'keralavisionisp.com', 'IN', 3072, 'isp', '0000-00-00 00:00:00', 0),
(7291, 138755, 'City Online Ap Private Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7292, 138756, 'Ramyaa Network Communication', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7293, 138758, 'Rocketwire Internet Solutions Pvt Ltd', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7294, 138759, 'Ameex Technologies Pvt. Ltd.', 'ameexusa.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7295, 13876, 'FiberLight, LLC', 'fiberlight.com', 'US', 17152, 'business', '2010-07-09 00:00:00', 0),
(7296, 138760, 'Bharat Computers', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7297, 138761, 'Inycb Network Private Limited', 'netguru.net.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7298, 138762, 'Sadaa Smartlinks Communication Private Limited', 'smartlinks.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7299, 138763, 'Praveen Telecom Pvt. Ltd.', 'None', 'IN', 2560, 'hosting', '0000-00-00 00:00:00', 0),
(7300, 138764, 'Chaitali Communications Opc Private Limited', 'chaitali.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7301, 138767, 'Laxweb Technologies Pvt. Ltd.', 'laxweb.net.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7302, 138768, 'Flixtel Communication Private Limited', 'flixtel.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7303, 138769, 'Easy Solutions Internet Services Pvt Ltd', 'easy4net.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7304, 13877, 'Wendy\'s International, Inc.', 'wendys.com', 'US', 4096, 'business', '1999-09-01 00:00:00', 0),
(7305, 138772, 'Mahrth Internet Service Private Limited', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7306, 138774, 'Skynet Internet', 'None', 'IN', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7307, 138775, 'Isobar Commerce India Private Limited', 'isobar.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7308, 138776, 'Gj2 Internet Private Limited', 'gj2internet.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7309, 138777, 'Karvy Innotech Limited', 'karvy.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7310, 138778, 'Skyrocket Network Solutions', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7311, 13878, 'UOL DIVEO S.A.', 'uoldiveo.com.br', 'BR', 86528, 'business', '2000-09-30 00:00:00', 0),
(7312, 138781, 'Shreepad Communication Pvt. Ltd.', 'shreepadcommunication.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7313, 138782, 'Swibi Airnet Broadband Services Pvt Ltd', 'trichyswibi.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7314, 138783, 'THREEJ Global Services Private Limited', '3jglobalservices.com', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(7315, 138784, 'Interglobe Enterprises Private Limited', 'interglobe.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7316, 138785, 'Infosys BPM Limited', 'infosys.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7317, 138786, 'Crystal Clear Broadband Services Pvt. Ltd.', 'yahoo.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7318, 138787, 'Speedking Infotech Pvt. Ltd.', 'speedking.in', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7319, 138788, 'Acushnet Communication Private Limited', 'None', 'IN', 768, 'hosting', '0000-00-00 00:00:00', 0),
(7320, 138789, 'Smartclick Internet Pvt Ltd', 'smartlinkbroadband.com', 'IN', 1280, 'isp', '0000-00-00 00:00:00', 0),
(7321, 138790, 'Sankrish Systems And Technologies Pvt Ltd', 'sankrishsystech.com', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7322, 138792, 'Om Jay Infotech', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7323, 138794, 'Deenet Internet Services Pvt Ltd', 'deenetservices.net', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7324, 138797, 'Coastal Broadband And Online Services Pvt. Ltd.', 'arpa-coastalbroadband.net', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7325, 138798, 'Mutiny Systems Private Limited', 'None', 'IN', 3840, 'isp', '0000-00-00 00:00:00', 0),
(7326, 13880, 'american century investments', 'americancentury.com', 'US', 7424, 'business', '1999-09-02 00:00:00', 0),
(7327, 138800, 'Peer Networks Private Limited', 'peer.net.in', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7328, 138801, 'Sg Broadband Internet Pvt.Ltd.', 'sgbroadband.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7329, 138802, 'PT Bukalapak.com', 'bukalapak.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7330, 138805, 'Dinas Komunikasi dan Informatika Kota Malang', 'malangkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7331, 138806, 'Dinas Komunikasi dan Informatika Kabupaten Kulon Progo', 'kulonprogokab.go.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7332, 138807, 'Pusat Litbang Perumahan dan Permukiman Badan Penelitian dan Pengembangan', 'pu.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7333, 138808, 'PT. Intech Esa Mandiri', 'intechmandiri.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7334, 138810, 'PT Global Media Pratama Solusindo', 'glosindo.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7335, 138811, 'PT Sakalaguna Semesta', 'sakalaguna.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7336, 138812, 'PT Global Kassa Sejahtera', 'gdn-commerce.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7337, 138813, 'Bank Indonesia', 'bi.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7338, 138814, 'PT Telemedia Prima Nusantara', 'telemedia.link', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7339, 138816, 'Pemerintah Kabupaten Banjar', 'banjarkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7340, 138817, 'PT ITS Tekno Sains', 'its.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7341, 138818, 'PT. Internet Ini Saja', 'inisaja.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7342, 13882, 'Talcott Resolution Life Insurance Company', 'talcottresolution.com', 'US', 8448, 'business', '1999-09-03 00:00:00', 0),
(7343, 138822, 'PT Jaya Komunikasi Indonesia', 'jkom-id.id', 'ID', 1536, 'business', '0000-00-00 00:00:00', 0),
(7344, 138823, 'PT. Trimitra Usaha Sejahtera', 'tus.co.id', 'ID', 2048, 'business', '0000-00-00 00:00:00', 0),
(7345, 138824, 'PT. Gemilang Jaya Elektrindo', 'jayaart.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7346, 138825, 'LPSE Kota Makassar', 'makassarkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7347, 138826, 'IDREN - Indonesia Research and Education Network', 'ub.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7348, 138828, 'PT TELIO INTI NUSA', 'telio.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7349, 138829, 'PT Capoeng Digital Nusantara', 'cdn.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7350, 13883, 'Contractors Register, Inc.', 'thebluebook.com', 'US', 256, 'business', '1999-09-03 00:00:00', 0),
(7351, 138830, 'PT JARGARIA TELEMATIKA INDONESIA', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7352, 138832, 'Dinas Komunikasi dan Informatika Kota Tebing Tinggi', 'tebingtinggikota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7353, 138833, 'PT Andi Internet Globalindo', 'ai-globalindo.web.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7354, 138835, 'DINAS KOMUNIKASI DAN INFORMATIKA KABUPATEN PACITAN', 'jarindo.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7355, 138836, 'Dinas Komunikasi dan Informatisa Kabupaten OKU', 'okukab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7356, 138837, 'PT. TRI DATU TELEKOMUNIKASI', 'tridatunetwork.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7357, 138838, 'PT NET Super Cepat', 'supercepat.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7358, 138839, 'PT Adidaya Infocom Lestari', 'infocom.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7359, 138840, 'PT. PARSAORAN GLOBAL DATATRANS - NAP', 'hspnet.net', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(7360, 138841, 'PT Media Andalan Nusa', 'nusa.net.id', 'ID', 7936, 'isp', '0000-00-00 00:00:00', 0),
(7361, 138842, 'PT Internetwork Komunikasi Indonesia', 'internetwork.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(7362, 138843, 'PT GLOBAL LINTAS SOLUSI', 'glsolusi.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7363, 138844, 'PT. PERTAMINA BINA MEDIKA', 'pertamedika.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7364, 138845, 'PT Akses Prima Indonesia', 'akses-prima.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7365, 138847, 'PT. AMBHARA DUTA SHANTI', 'adsnet.co.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(7366, 138848, 'Pemerintah Daerah Kabupaten Fakfak', 'fakfakkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7367, 138849, 'PT. Trimitra Media Internet', 'tryme.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7368, 138850, 'Pemerintah Kota Palembang', 'palembang.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7369, 138851, 'Pemerintah Kota Payakumbuh', 'payakumbuhkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7370, 138852, 'Dinas Komunikasi dan Informatika Kabupaten Badung', 'biz.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7371, 138853, 'PT LOTTE Data Communication Indonesia', 'lottedata.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7372, 138854, 'PT INTER MEDIALINK SOLUSI', 'ims.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7373, 138856, 'PT BANK BRIsyariah', 'brisyariah.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7374, 138858, 'PEMERINTAH DAERAH KABUPATEN JAYAPURA', 'pemdajayapura.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7375, 138859, 'Dinas Komunikasi dan Informatika Kabupaten Semarang', 'semarangkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7376, 13886, 'Cloud South', 'cloudsouth.com', 'US', 139264, 'hosting', '2012-06-12 00:00:00', 0),
(7377, 138860, 'PT. JAYA LINTAS INDONESIA', 'ayo.net.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7378, 138862, 'PT. DIGITAL NETWORK SETIAWAN', 'digital.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7379, 138863, 'PT BERNOFARM', 'bernofarm.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7380, 138864, 'UNIVERSITAS MUHAMMADIYAH KUDUS', 'umkudus.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7381, 138865, 'PT. PRIMA NUSANTARA TELEKOMUNIKASI', 'primantara.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7382, 138866, 'PT Mitra Media Data', 'mmd.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7383, 138868, 'CV. RUMAH CLOUD INDONESIA', 'rumahcloud.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7384, 13887, 'RoomsToGo.com, Inc.', 'roomstogo.com', 'US', 1024, 'business', '2012-12-17 00:00:00', 0),
(7385, 138870, 'Pemerintah Kabupaten Berau', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7386, 138871, 'PT. Trans Indonesia Superkoridor', 'supercorridor.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7387, 138873, 'PT GREEN NET INDONESIA', 'matrainfotek.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7388, 138874, 'PT Anugerah Pratama Indonesia', 'ap-indo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7389, 138875, 'PT Inetindo Terestrial Solusi', 'inetindo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7390, 138876, 'CV. Saranaindo', 'saranaindo.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7391, 138877, 'PT. SHEN SAMUDRA INTERKONEKSI', 'samudranetwork.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7392, 138878, 'Universitas Muhammadiyah Sidoarjo', 'umsida.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7393, 13888, 'Bear Creek Operations Inc', 'bco.com', 'US', 768, 'business', '1999-09-03 00:00:00', 0),
(7394, 138880, 'CV Dwi Tunggal Abadi', 'e-jambi.net', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7395, 138881, 'PT INDONESIA TRANS NETWORK', 'itn.net.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(7396, 138884, 'PT Centronet Data Indonesia', 'centro.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7397, 138885, 'PT Cyber Network Indonesia', 'cni.net.id', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(7398, 138886, 'PT Data Buana Nusantara', 'ptdbn.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7399, 138887, 'PT ADIZKA LINTAS DATA', 'adizka.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7400, 13889, 'Intex Solutions, Inc.', 'intex.com', 'US', 256, 'business', '1999-09-03 00:00:00', 0),
(7401, 138890, 'PT Acehlink Media', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7402, 138891, 'PT. Kayong Muara Teknoindo', 'pawanfiber.net', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(7403, 138892, 'Pemerintah Kota Padang', 'padang.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7404, 138893, 'PT PRIMA MULTI TERMINAL', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7405, 138894, 'PT ASLI Rancangan Indonesia', 'asliri.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7406, 138895, 'PT. Global Komunikasi Mandiri', 'globalkomunikasimandiri.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7407, 138896, 'PT. TIWU TELU ONLINE', 'tiwuteluonline.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7408, 138897, 'IAIN SYEKHNURJATI', 'syekhnurjati.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7409, 138898, 'PT Angkasa Pura Suport', 'angkasapura-supports.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7410, 138899, 'PT. Mega Akses Persada', 'fiberstar.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7411, 138901, 'Dinas Komunikasi dan Informatika Kabupaten Blitar', 'blitarkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7412, 138902, 'Emstret Holdings Ltd', 'emstret.com', 'PG', 512, 'business', '0000-00-00 00:00:00', 0),
(7413, 138903, 'KHILGAON DOT NET', 'khilgaon.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7414, 138904, 'Jessore University of Science and Technology', 'just.edu.bd', 'BD', 1024, 'education', '0000-00-00 00:00:00', 0),
(7415, 138906, 'Ministry of Culture', 'm-culture.go.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(7416, 138907, 'KHAN BANK LLC', 'khanbank.com', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(7417, 138908, 'Racing Australia Limited', 'racingaustralia.horse', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7418, 13891, '21ST CENTURY ONCOLOGY, INC.', '21co.com', 'US', 1024, 'business', '2006-04-10 00:00:00', 0),
(7419, 138911, 'Renaissance Phuket Resort & Spa', 'uih.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7420, 138912, 'Ghatail Online', 'ghatailonline.net', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(7421, 138915, 'Kaopu Cloud HK Limited', 'kaopucloud.com', 'HK', 6656, 'business', '0000-00-00 00:00:00', 0),
(7422, 138916, 'Personal Collection Direct Selling, Inc.', 'pcdsi.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7423, 138917, 'JUPITER ONLINE SERVICES', 'jupiteronlinebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7424, 13892, 'BI', 'biworldwide.com', 'US', 1024, 'business', '1999-09-03 00:00:00', 0),
(7425, 138921, 'EMPEROR INVESTMENT (MANAGEMENT) LIMITED', 'emperorgorup.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7426, 138922, 'Atulaya Healthcare Private Limited', 'atulaya.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7427, 138924, 'Berger Paints Bangladesh Ltd.', 'bergerbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7428, 138927, 'On Air Limited', 'onairl.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7429, 138928, 'Cellarmaster Wines Pty Ltd', 'cellarmasters.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7430, 13893, 'Enterprise Holdings, Inc.', 'enterpriseholdings.com', 'US', 3072, 'business', '1999-09-03 00:00:00', 0),
(7431, 138932, 'GRIDCLOUD NETWORK SDN BHD', 'dotgridcloud.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(7432, 138933, 'University of Computer Studies, Yangon', 'ucsy.edu.mm', 'MM', 256, 'education', '0000-00-00 00:00:00', 0),
(7433, 138934, 'SLT Network Co.,LTD', 'sltnetwork.com', 'LA', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7434, 138938, 'NORTHERN TRUST CORPORATION', 'northerntrust.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(7435, 13894, 'SECUREWEBS INC', 'secureredirect.com', 'US', 4096, 'business', '1999-09-08 00:00:00', 0),
(7436, 138940, 'NPC Media Pty Limited', 'fairfaxmedia.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7437, 138941, 'NPC Media Pty Limited', 'fairfaxmedia.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7438, 138943, 'Connectnet Services Limited', 'connectnet.co.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(7439, 138944, 'SNet And Electronics', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7440, 138945, 'BALLARAT AND QUEEN\'S ANGLICAN GRAMMAR SCHOOL', 'bgs.vic.edu.au', 'AU', 512, 'education', '0000-00-00 00:00:00', 0),
(7441, 13895, 'FiberConX', 'fiberconx.com', 'CA', 1024, 'business', '2013-03-28 00:00:00', 0),
(7442, 138950, 'Jiangsu Wuxi International IDC network', 'cndata.com', 'CN', 76544, 'isp', '0000-00-00 00:00:00', 0),
(7443, 138952, 'Endemol Shine Australia Pty Ltd', 'endemolshine.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7444, 138953, 'Top Network', 'topnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7445, 138956, 'Miriam College', 'mc.edu.ph', 'PH', 256, 'education', '0000-00-00 00:00:00', 0),
(7446, 138957, 'TiVo Tech Private Limited', 'tivo.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7447, 13896, 'FUZE INC', 'fuze.com', 'US', 7936, 'business', '2006-10-03 00:00:00', 0),
(7448, 138961, 'Paradise Cable Television Network', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7449, 138962, 'Bangkok Insurance Public Company Limited', 'bangkokinsurance.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7450, 138963, 'Lockhart Road Municipal Services Building', 'lcsd.gov.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(7451, 138964, 'Barahi Internet Technologies Pvt. Ltd.', 'barahinet.com.np', 'NP', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7452, 138965, 'Streamtech Systems Technologies Inc.', 'streamtech.com.ph', 'PH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7453, 138967, 'SineManage Network Service co.,Ltd', 'sinemanage.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7454, 138968, 'rainbow network limited', 'rainbownetworkbd.com', 'JP', 5120, 'hosting', '0000-00-00 00:00:00', 0),
(7455, 13897, 'Internet Brands Inc.', 'internetbrands.com', 'US', 2560, 'business', '1999-09-08 00:00:00', 0),
(7456, 138973, 'Campbell Technology Limited', 'campbell.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7457, 138974, 'MESH NETWORK', 'meshnetworkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7458, 138976, 'NEW ZEALAND PHARMACEUTICALS LIMITED', 'nzp.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7459, 138977, 'Kinetic IT Pty. Ltd.', 'kineticit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7460, 138978, 'Starch Works', 'membrey.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7461, 138979, 'AresFlare CO.,Ltd (Cambodia)', 'aresflare.com', 'KH', 256, 'isp', '0000-00-00 00:00:00', 0),
(7462, 13898, 'CollaborateMD, Inc.', 'collaboratemd.com', 'US', 256, 'business', '2009-02-27 00:00:00', 0),
(7463, 138981, 'M/S. SK Net City', 'None', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(7464, 138982, 'Hubei Jiangxia IDC', 'cndata.com', 'CN', 12288, 'isp', '0000-00-00 00:00:00', 0),
(7465, 138983, 'Round Network', 'roundnetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7466, 138985, 'CITS PVT (LTD)', 'cits.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(7467, 138988, 'Av-Comm Pty Ltd', 'avcomm.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7468, 138994, 'China International Business Limited', 'qq.com', 'HK', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7469, 138995, 'Antbox Network', 'antboxnetwork.com', 'HK', 6656, 'hosting', '0000-00-00 00:00:00', 0),
(7470, 138996, 'Uni Comms International Sdn Bhd', 'unicomms.com.my', 'MY', 1024, 'business', '0000-00-00 00:00:00', 0),
(7471, 138997, 'Eons Data Communications Limited', 'eons.cloud', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(7472, 138999, 'PPIN INTERNET CO., LTD.', 'poipetinternet.com', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(7473, 13900, 'Christian Broadcasting Network, Inc.', 'cbn.com', 'US', 9472, 'business', '2006-04-10 00:00:00', 0),
(7474, 139000, 'ViridianIT', 'viridianit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7475, 139002, 'Andor Information Technology Pty Ltd', 'andor.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7476, 139004, 'RL CAFE NET', 'rlcafenet.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7477, 139006, 'Zoho Corporation PTY LTD', 'zohocorp.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(7478, 139007, 'UNICOM InnerMongolia province network', 'hh.nm.cn', 'CN', 119552, 'isp', '0000-00-00 00:00:00', 0),
(7479, 139008, 'NEEF IT LIMITED', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7480, 13901, 'Afilias, Inc.', 'afilias.info', 'US', 256, 'business', '2007-05-16 00:00:00', 0),
(7481, 139011, 'Banque pour le Commerce Exterieur Lao Public', 'bcel.com.la', 'LA', 256, 'business', '0000-00-00 00:00:00', 0),
(7482, 139012, 'Link Technologies', 'linksolutions.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7483, 139013, 'Hi-Tech Online Services', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7484, 139014, 'Next Route Company Limited', 'next-route.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7485, 139016, 'EXONHOST', 'exonhost.com', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7486, 139018, 'Henan Luoyang IDC', 'cndata.com', 'CN', 11520, 'isp', '0000-00-00 00:00:00', 0),
(7487, 13902, 'mPlatform LLC', 'mplatform.com', 'US', 256, 'business', '2006-10-20 00:00:00', 0),
(7488, 139020, 'B & M SECURITY LIMITED', 'digitalcloud.net.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7489, 139021, 'West263 International Limited', 'hkdns.hk', 'HK', 20736, 'hosting', '0000-00-00 00:00:00', 0),
(7490, 139024, 'Iqra University', 'iqra.edu.pk', 'PK', 512, 'education', '0000-00-00 00:00:00', 0),
(7491, 139025, 'Optical Link Dot Com & Cyber Cafe', 'opticallink.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7492, 139026, 'Shadhinota Net', 'shadhinotabd.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7493, 139027, 'Renaissance Online and Cyber Cafe', 'renaissancebd.com', 'BD', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7494, 139028, 'Singapore Technologies Engineering Ltd', 'stengg.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(7495, 139029, 'AKNetworks', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7496, 139030, 'Cnet Communication', 'cnetcomm.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7497, 139032, 'Nations Trust Banks Plc', 'nationstrust.com', 'LK', 512, 'business', '0000-00-00 00:00:00', 0),
(7498, 139033, 'Voglu Internet Service', 'voglubd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7499, 139034, 'Sattelite Plus Incorporated', 'sattlink.net', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7500, 139035, 'GBLINK NETWORK SOLUTIONS PRIVATE LIMITED', 'gblink.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7501, 139037, 'QUIPTEK PACIFIC PTY LTD', 'quiptekpacific.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7502, 139038, 'Aftab Siddiqui', 'aftabsiddiqui.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(7503, 139039, 'JK Network', 'jknetworkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7504, 13904, 'Cherryland Services Inc', 'cherry.fr', 'US', 45056, 'isp', '1999-09-08 00:00:00', 0),
(7505, 139040, 'CANON BUSINESS PROCESS SERVICES PHILIPPINES,', 'canon.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7506, 139041, 'CAFE-7040', 'cafe7040.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7507, 139042, 'Speed Links', 'speedlinksbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7508, 139043, 'WellNetworks (Private) Limited', 'wellnetworks.com.pk', 'PK', 3840, 'isp', '0000-00-00 00:00:00', 0),
(7509, 139044, 'HUIONE PAY PLC.', 'huione.com', 'KH', 256, 'business', '0000-00-00 00:00:00', 0),
(7510, 139045, 'Axonstack Pty Ltd', 'axonstack.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7511, 139047, 'ROYAL FREEMASONS LTD', 'royalfreemasons.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7512, 139049, 'GIGACOMM PTY LTD', 'gigacomm.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7513, 139050, 'United Super Pty Ltd', 'cbussuper.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7514, 139051, 'AUNG GABAR COMPANY LIMITED', 'aunggabar.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(7515, 139052, 'Power Net', 'powernet.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7516, 139053, 'Jhongkar Engineers', 'jhongkar.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7517, 139054, 'Auckland Data Centre Limited', 'datacentre.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7518, 139055, 'AVANTEOS INVESTMENTS LIMITED', 'avanteos.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7519, 139056, 'FAST ONE (CAMBODIA) CO., LTD', 'fastone.asia', 'KH', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7520, 139057, 'Baishan Cloud', 'baishancloud.com', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(7521, 139060, 'CHAOJI SUPER HIGH INTERNET TECHNOLOGY CO., LTD.', 'chaojikh.com', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(7522, 139061, 'Societe Generale (China) Limited', 'societegenerale.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7523, 139062, 'Synamedia Asia Private Ltd', 'synamedia.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7524, 139066, 'NTT Data Global Delivery Services Limited', 'nttdata.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7525, 139067, 'Nayapay (Pvt.) Limited', 'nayapay.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(7526, 139068, 'Luxoft India LLP', 'luxoft.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7527, 139069, 'AUSCO MODULAR PTY LIMITED', 'ausco.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7528, 13907, 'NCR Corporation', 'ncr.com', 'US', 2560, 'business', '2010-09-16 00:00:00', 0),
(7529, 139070, 'Google Asia Pacific Pte. Ltd.', 'google.com', 'SG', 69632, 'business', '0000-00-00 00:00:00', 0),
(7530, 139071, 'MK Networks Co., Ltd.', 'knetmyanmar.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(7531, 139076, 'EnjoyVC Japan Corporation', 'enjoyvc.com', 'JP', 1536, 'business', '0000-00-00 00:00:00', 0),
(7532, 139082, 'Singha Estate Public Company Limited', 'singhaestate.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(7533, 139084, 'DIGITAL IMMORTALITY PTY LTD', 'futurebroadband.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(7534, 139086, 'OCEAN NETWORK LIMITED', 'yyw818.com', 'HK', 127232, 'hosting', '0000-00-00 00:00:00', 0),
(7535, 139087, 'Fast Web & Wireless Communications (Pvt.) Limited', 'fastweb.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(7536, 139088, 'TUFA Telecommunication (Pvt) Ltd.', 'tufatel.com', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(7537, 139089, 'MT Networks LLC', 'mtnetworks.mn', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(7538, 13909, 'Techie Hosting, Inc.', 'techiemedia.net', 'US', 16384, 'hosting', '2006-04-10 00:00:00', 0),
(7539, 139090, 'Wuxi Education Information Management Service Center', 'cnnic.cn', 'CN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7540, 139091, 'Shanghai MBN telecommunication technology Co., LTD.', 'link-net.com.cn', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7541, 13910, 'Register.com, Inc', 'register.com', 'US', 512, 'business', '1999-09-08 00:00:00', 0),
(7542, 13911, 'Tera-byte Dot Com Inc.', 'tera-byte.com', 'CA', 30976, 'hosting', '1999-09-08 00:00:00', 0),
(7543, 139110, 'Lenovo Mobile Communication Technology (Beijing) Ltd', 'lenovo.com', 'CN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7544, 139112, 'Shanghai Qnet Networking Technology Co.,Ltd', 'qnetdc.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7545, 13912, 'Commtouch Inc.', 'commtouch.com', 'US', 256, 'business', '1999-09-08 00:00:00', 0),
(7546, 13913, 'Affiliated Monitoring, Inc.', 'affiliated.com', 'US', 768, 'business', '2013-03-29 00:00:00', 0),
(7547, 139138, 'Gopay Information Technology Co.,Ltd', 'gopay.com.cn', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7548, 13914, 'CAMARA DE DIRIGENTES LOJISTAS DE BELO HORIZONTE', 'cdlbh.com.br', 'BR', 2048, 'business', '1999-11-18 00:00:00', 0),
(7549, 13915, 'Radiology Imaging Associates P.C.', 'riaco.com', 'US', 512, 'business', '2009-01-13 00:00:00', 0),
(7550, 13916, 'Proofpoint, Inc.', 'proofpoint.com', 'US', 8704, 'business', '2014-05-20 00:00:00', 0),
(7551, 13917, 'Corporate West Computer Systems, Inc.', 'corpwest.com', 'US', 4352, 'business', '1999-09-15 00:00:00', 0),
(7552, 139177, 'New Oriental Education & Technology Group Ltd.', 'neworiental.org', 'CN', 1024, 'education', '0000-00-00 00:00:00', 0),
(7553, 139178, 'Rural Credit Banks Funds Clearing Center', 'nongxinyin.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(7554, 139179, 'China Pacific Insurance (Group) Co.,Ltd.', 'cpic.com.cn', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7555, 13918, 'City of Tucson', 'tucsonaz.gov', 'US', 65536, 'business', '1999-09-15 00:00:00', 0),
(7556, 139182, 'ABC Life Insurance Co., Ltd', 'abchinalife.cn', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7557, 139183, 'Thomson Reuters (Beijing) Technology Development Co. Ltd', 'thomsonreuters.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(7558, 13919, 'ADS Alliance Data Systems, Inc.', 'alliancedata.com', 'US', 2304, 'business', '1999-09-15 00:00:00', 0),
(7559, 139190, 'Google Asia Pacific Pte. Ltd.', 'google.com', 'SG', 65536, 'business', '0000-00-00 00:00:00', 0),
(7560, 139191, 'KH77-NET CO., LTD', 'None', 'KH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7561, 139192, 'Zoom Online', 'zoomonlinebd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7562, 139195, 'Seans Media Pvt Ltd', 'seansmedia.com', 'IN', 6656, 'isp', '0000-00-00 00:00:00', 0),
(7563, 139196, 'IME Group Pvt. Ltd', 'imegroup.org', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(7564, 139197, 'Thunder Network', 'thundernetwork.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7565, 13920, 'SAFE AUTO INSURANCE COMPANY', 'safeauto.com', 'US', 256, 'business', '2020-03-02 00:00:00', 0),
(7566, 139200, 'Arthur D. Riley and Company Limited', 'adriley.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7567, 139201, 'Jiangxi Jiujiang IDC', 'chinatelecom.cn', 'CN', 18176, 'isp', '0000-00-00 00:00:00', 0),
(7568, 139202, 'Power Media', 'powermediabd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7569, 139203, 'Guizhou GuiAn IDC', 'chinatelecom.cn', 'CN', 8192, 'isp', '0000-00-00 00:00:00', 0),
(7570, 139204, 'Asia Pacific Network Information Centre', 'apnic.net', 'AU', 512, 'business', '2006-11-29 00:00:00', 0),
(7571, 139206, 'Pan Asia Majestic Eagle Ltd', 'apollo-towers.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(7572, 13921, 'Hecla Mining Company', 'hecla-mining.com', 'US', 256, 'business', '2014-09-17 00:00:00', 0),
(7573, 139211, 'Flex Ltd. STT (Tata) Colo, 226, Ambattur Red Hills Rd, Kallikuppam, Ambattur, Chennai, Tamil Nadu 600053 India', 'flex.com', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7574, 139213, 'Hillview Cable Systems, inc.', 'None', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(7575, 139214, 'Cloud4x Enterprise Systems Pty Ltd', 'cloud4x.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7576, 139215, 'Kuhok Limited', 'kuhok.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7577, 139217, 'Royal Capital Ltd', 'royalcapitalbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7578, 139218, 'Robinsons Land Corporation', 'robinsonsland.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7579, 139220, 'Sichuan Chuanxn IDC', 'chinatelecom.cn', 'CN', 14080, 'isp', '0000-00-00 00:00:00', 0),
(7580, 139221, 'AUVERA TECHNOLOGY GROUP PTY LTD', 'auvera.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7581, 139222, 'City of Wanneroo', 'wanneroo.wa.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7582, 139223, 'NTECH COMMUNICATION', 'ntech-bd.com', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(7583, 139224, 'Limpid ICT Solution Pvt. Ltd', 'lis.net.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(7584, 139225, 'Whatbox Inc.', 'whatbox.ca', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7585, 139227, 'Hello IT', 'helloitbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7586, 13923, 'IPCopper, Inc.', 'smcloud.com', 'US', 1024, 'business', '2010-04-16 00:00:00', 0),
(7587, 139230, 'HAMS Garments Ltd', 'hams.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7588, 139234, 'ALLSCRIPTS (INDIA) LLP', 'allscripts.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7589, 139235, 'Truxgo S. R.L. de C.V.', 'truxgo.com', 'MX', 1536, 'business', '0000-00-00 00:00:00', 0),
(7590, 139236, 'Local Government Engineering Department (LGED)', 'lged.gov.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7591, 139237, 'Nepal Police', 'nepalpolice.gov.np', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(7592, 139239, 'BograInfo.com', 'bograinfo.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7593, 139240, 'Starch Works', 'membrey.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7594, 139241, 'Avrotech Sdn Bhd', 'avrotech.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(7595, 139242, 'Cloudflare Sydney, LLC', 'cloudflare.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(7596, 139244, 'ICTOUCH PTY LTD', 'ictouch.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7597, 139245, '3Technology', '3technologybd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7598, 139246, 'Twin Towns Services Club Ltd', 'twintowns.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7599, 13925, 'Null Route Networks', 'nullroutenetworks.com', 'US', 1536, 'business', '2018-05-07 00:00:00', 0),
(7600, 139250, 'Mesiniaga Berhad', 'mesiniaga.com.my', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(7601, 139251, 'Jahangirnagar University', 'juniv.edu', 'BD', 512, 'education', '0000-00-00 00:00:00', 0),
(7602, 139253, 'FOIT Group PTY LTD', 'foit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7603, 139254, 'Why Network Solution', 'whyhosting.net', 'MY', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7604, 139255, 'U-NEXT Co.,Ltd.', 'unext.jp', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(7605, 139256, 'National Information Technology Center', 'nitc.gov.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(7606, 139257, 'dinCloud, LLC', 'dincloud.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7607, 13926, 'Strong Technology, LLC.', 'strongtechnology.net', 'US', 1536, 'hosting', '2009-12-22 00:00:00', 0),
(7608, 139261, 'Metrolink Business Group Pvt Ltd', 'metrolink.com.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(7609, 139262, 'HKIC Tech Limited', 'hkict.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7610, 139265, 'HONG KONG SPEED NETWORK TECHNOLOGY CO., LIMITED', 'qq.com', 'HK', 2048, 'hosting', '0000-00-00 00:00:00', 0),
(7611, 139266, 'Guangzhou Tiansui Information Technology Co., Ltd.', 'gztiansui.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(7612, 139267, 'Glexia, Inc.', 'glexia.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7613, 139268, 'Global Link Internet Limited', 'glinkinternet.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(7614, 139269, 'Samsung R&D Institute India-Bangalore Private Limited', 'samsung.com', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7615, 13927, 'KanOkla Communications, LLC', 'kanokla.com', 'US', 8192, 'business', '2010-11-02 00:00:00', 0),
(7616, 139270, 'ACCESS COMMUNICATION', 'accesscommunicationbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7617, 139271, 'Simpson Grierson Limited', 'simpsongrierson.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7618, 139272, 'EASTERN INSTITUTE OF TECHNOLOGY LIMITED', 'eit.ac.nz', 'NZ', 256, 'education', '0000-00-00 00:00:00', 0),
(7619, 139273, 'HENRY SCHEIN REGIONAL PTY LIMITED', 'henryschein.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7620, 139275, 'Watercare Services Limited', 'watercare.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(7621, 139276, 'Mohammed Rabin Reza', 'aflahcommunication.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7622, 139277, 'Solomon Islands Government ICT Support Department', 'sig.gov.sb', 'SB', 512, 'business', '0000-00-00 00:00:00', 0),
(7623, 139278, 'Data Edge Limited', 'data-edge.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7624, 13928, 'IT Right, Inc', 'itright.com', 'US', 512, 'business', '2010-07-09 00:00:00', 0),
(7625, 139280, 'WETUBE NETWORK', 'None', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7626, 139281, 'Equinix Korea LLC', 'equinix.com', 'KR', 256, 'isp', '0000-00-00 00:00:00', 0),
(7627, 139282, 'Novus Network', 'novusnetworkbd.com', 'BD', 1280, 'isp', '0000-00-00 00:00:00', 0),
(7628, 139283, 'Touch Online', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7629, 139284, 'OCTANE NETWORKS PTY LTD', 'octane.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7630, 139285, 'Wingel cooperation co.,Ltd', 'wingel.net', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(7631, 139287, 'The Data Exchange Network Limited', 'dataexchange.io', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7632, 139288, 'Twish Tech', 'twish.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7633, 139289, 'PFD Food Services Pty Ltd', 'pfdfoods.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7634, 139290, 'Coal Services Pty Ltd', 'coalservices.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7635, 139291, 'INFINITIUM HOLDINGS PTE. LTD.', 'infinitium.com', 'SG', 768, 'business', '0000-00-00 00:00:00', 0),
(7636, 139292, 'Jubilee Life Insurance', 'jubileelife.com', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(7637, 139293, 'UFO Network Limited', 'ufovps.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(7638, 139294, 'Skynet Broadband Network', 'skynetbn.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7639, 139296, 'Bangladesh Water Development Board', 'bwdb.gov.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7640, 139297, 'Lao International Technology Service Sole Co., Ltd', 'litsc.net', 'LA', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7641, 139298, 'Ruifeng HK branch', 'asiahybridcloud.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(7642, 139299, 'Akari Networks', 'akari.ink', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7643, 13930, 'The Children\'s Mercy Hospital', 'cmh.edu', 'US', 256, 'education', '2012-04-13 00:00:00', 0),
(7644, 139300, 'FiberNet Networks', 'fnet.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7645, 139301, 'Cloudcall Ltd', 'cloudcall.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7646, 139302, 'Ashiq Cable Network (Pvt.) Limited', 'acn.net.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(7647, 139303, 'Chandina Online', 'chandinaonline.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7648, 139304, 'NSW Business Chamber Limited', 'businessnsw.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7649, 139306, 'Lexel Systems Ltd', 'lexel.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7650, 13931, 'MASONIC CHARITY FOUNDATION OF NEW JERSEY', 'njmasonic.org', 'US', 256, 'business', '2013-03-29 00:00:00', 0),
(7651, 139310, 'Mackenzie Agricultural Technologies', 'matnet.co.nz', 'NZ', 512, 'isp', '0000-00-00 00:00:00', 0),
(7652, 139311, 'Virtual Network Pvt. Ltd', 'vnetwork.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(7653, 139313, 'AYUDHYA CAPITAL SERVICES COMPANY LIMITED', 'krungsri.com', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(7654, 139314, 'QQNETISP Co.,LTD', 'qqnetisp.com', 'KH', 512, 'business', '0000-00-00 00:00:00', 0),
(7655, 139319, 'BEE ONLINE', 'smartnetltd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7656, 13932, 'Washington Hospital Healthcare Sysem', 'whhs.com', 'US', 512, 'business', '2012-09-25 00:00:00', 0),
(7657, 139320, 'Phonon Communications Pvt Ltd', 'phonon.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7658, 139322, 'Rio Tinto IS&T', 'riotinto.com', 'AU', 256, 'isp', '0000-00-00 00:00:00', 0),
(7659, 139323, 'Rio Tinto IS&T', 'riotinto.com', 'CA', 1536, 'isp', '0000-00-00 00:00:00', 0),
(7660, 139324, 'Rio Tinto IS&T', 'riotinto.com', 'GB', 256, 'isp', '0000-00-00 00:00:00', 0),
(7661, 139325, 'IQ-TEL', 'iq-tel.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7662, 139327, 'HONG KONG EVERGRANDE ENTERPRISE GROUP CO., LIMITED', 'None', 'HK', 3584, 'isp', '0000-00-00 00:00:00', 0),
(7663, 13933, 'Anchor Packaging, Inc.', 'anchorpac.com', 'US', 768, 'business', '2010-12-13 00:00:00', 0),
(7664, 139330, 'SANREN DATA LIMITED', 'None', 'HK', 37376, 'hosting', '0000-00-00 00:00:00', 0),
(7665, 139331, 'DevelentCorp.', 'develentcorp.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7666, 139333, 'Global Agility Solutions, LLC', 'globalagilitysolutions.com', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7667, 139335, 'Sreejon Online.Com', 'None', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(7668, 139337, 'Ozhosting.com Pty Ltd', 'ozhosting.com', 'AU', 1792, 'hosting', '0000-00-00 00:00:00', 0),
(7669, 139338, 'Cyber Planet', 'cyberplanetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7670, 139339, 'PT CONNECTION IT CO., LTD', 'ptconnection.net', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(7671, 139340, 'HONG KONG GIGALINK NETWORK LIMITED', 'gigalinkhk.com', 'HK', 2560, 'business', '0000-00-00 00:00:00', 0),
(7672, 139342, 'Steinhoff Asia Pacific Limited', 'steinhoff.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7673, 139343, 'WENET', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7674, 139344, 'ACT Government InTACT Group', 'act.gov.au', 'AU', 97536, 'business', '0000-00-00 00:00:00', 0),
(7675, 139345, 'Hyve Managed Hosting Corp Inc', 'hyve.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(7676, 139349, 'Diebold Nixdorf Singapore PTE. LTD.', 'dieboldnixdorf.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(7677, 139351, 'AERO COMMUNICATIONS BROADBAND PVT. LTD', 'aeronet.com.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(7678, 139352, 'CBRE Pty Limited', 'cbre.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7679, 139357, 'VITERRA PTY LTD', 'viterra.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7680, 139360, 'emPOWER Data Services', 'blueapache.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7681, 139361, 'PT Anugerah General Netindo', 'agnetindo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7682, 139362, 'PT Tata Telemedia Nusantara', 'tatatelemedia.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7683, 139363, 'PT Amerta Indah Otsuka', 'aio.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7684, 139364, 'Pemerintah Kabupaten Gunungkidul', 'gunungkidulkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7685, 139365, 'PT PATRIA LINTAS JAYA', 'lintasjaya.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7686, 139366, 'PT Higo Fitur Indonesia', 'higo.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7687, 139367, 'Dinas Kominfo Kota Jambi', 'jambikota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7688, 139368, 'Dinas Komunikasi Dan Informatika Pemerintah Provinsi Kalimantan Selatan', 'samudranetwork.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7689, 139369, 'PT. UTARA NUSA MEDIA', 'utaramedia.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7690, 139370, 'PT. Panji Perkasa Indonesia', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7691, 139371, 'PT Bank Agris Tbk', 'bankagris.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7692, 139372, 'Institut Agama Islam Negeri Pekalongan', 'iainpekalongan.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7693, 139373, 'PT Akses Artha Media', 'aksesarmedia.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7694, 139375, 'Pemerintah Kabupaten Jombang', 'jombangkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7695, 139377, 'Universitas Sultan Ageng Tirtayasa', 'untirta.ac.id', 'ID', 512, 'education', '0000-00-00 00:00:00', 0),
(7696, 139378, 'PT. NEX Solusi Teknologi', 'nex.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7697, 139379, 'PT Theko Digital Solusindo', 'theko.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7698, 13938, 'SS&C Technologies, Inc.', 'ssctech.com', 'US', 5376, 'business', '1999-09-20 00:00:00', 0),
(7699, 139380, 'PT BOMM AKSES TEKNOLOGI', 'bommakses.net', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7700, 139382, 'PT Multi Teknologi Telematika', 'multiteknologi.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7701, 139384, 'Pemerintah Kota Mojokerto', 'mojokertokota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7702, 139385, 'PT. LANTIP TEKNOLOGI PRIMA', 'lantip.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7703, 139386, 'PT Nusantara Sejahtera Raya', 'cinema21.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7704, 139387, 'Pemerintah Kabupaten Gresik', 'gresikkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7705, 139389, 'PT. Marawa Transmisi Media', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7706, 139390, 'PT Langit Mandiri Sukses', 'lams.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7707, 139392, 'PT APLIKA KARYA SOLUSI BISNIS', 'aplikabisnis.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7708, 139393, 'PT KREASI MANDALA TEKNOLOGI', 'kmt.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7709, 139394, 'PT Patra Drilling Contractor', 'pertamina-pdc.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7710, 139395, 'CV. Inti Berkat', 'intiberkat.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7711, 139396, 'PT. Master Global Solusi', 'cni.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7712, 139397, 'PT. Multimedia Network Indonesia', 'multimedia.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7713, 139398, 'PT. Pusat Informasi Kredit', 'cni.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7714, 139399, 'PT Palapa Network Nusantara', 'palapanet.co.id', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7715, 13940, 'San Joaquin County Office of Education', 'sjcoe.net', 'US', 65536, 'education', '1999-09-20 00:00:00', 0),
(7716, 139400, 'PT. Rak Super Ninja', 'ninjaserver.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7717, 139401, 'PT PELANGI SURYA PERSADA', 'pelangisuryapersada.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7718, 139402, 'Pemerintah Kabupaten Pesisir Selatan', 'pesisirselatankab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7719, 139403, 'PEMERINTAH KOTA PEMATANGSIANTAR', 'pematangsiantarkota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7720, 139405, 'PT.MEDIA CIPTA TRIMETIKA', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7721, 139406, 'PT SOLUSI SURYA DESWATA', 'solusi-ict.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7722, 139408, 'PT Sanatel', 'sanatel.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7723, 139409, 'PT JERNIH MULTI KOMUNIKASI', 'jernih.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7724, 139414, 'Pemerintah Kabupaten Kudus', 'kuduskab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7725, 139415, 'PT Trinity Teknologi Nusantara', 'trinity.net.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(7726, 139417, 'PT Iweka Digital Solution', 'iweka.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7727, 139418, 'PT Gasatek Bintang Nusantara', 'gasatek.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7728, 13942, 'Commission Scolaire Marie-Victorin', 'csmv.qc.ca', 'CA', 1024, 'education', '2006-10-20 00:00:00', 0),
(7729, 139421, 'PT Dharma Sarana Solusindo', 'pandawa.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7730, 139422, 'Dinas Komunikasi dan Informatika Kota Balikpapan', 'balikpapan.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7731, 139423, 'PT Rajawali Sinergi Group', 'rajawalisinergi.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7732, 139424, 'PT. BIG NET INDONESIA', 'bignet.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7733, 139425, 'PT RESTU PANCA ALAM', 'beat.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7734, 139426, 'PT Rinjani Citra Solusi', 'ahmadan.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7735, 139427, 'PT Lintas Persada Optika', 'verd.net.id', 'ID', 1536, 'business', '0000-00-00 00:00:00', 0),
(7736, 139428, 'PT.LEXXA DATA INDONUSA', 'lexxadata.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7737, 139429, 'PT ARTATEL INDOKARYA', 'artatel.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7738, 13943, 'Y K Communications, LTD', 'ykc.com', 'US', 6400, 'isp', '1999-09-20 00:00:00', 0),
(7739, 139430, 'PT. Media Nusantara Dinamis', 'mncgroup.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7740, 139431, 'PT. Integrasi Jasa Nusantara', 'ijasa.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7741, 139432, 'Diskominfo Kab. Bogor', 'bogorkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7742, 139433, 'PT Sakaeng Solata Infrastruktur', 'sakaengsolata.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7743, 139434, 'PT Reliance Sekuritas Indonesia, Tbk', 'reliancesekuritas.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7744, 139435, 'PT SWADAYA TEKNO SOLUSI', 'swadaya.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7745, 139438, 'PT Pembangunan Sarana Telematika', 'p-sat.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7746, 139439, 'Corporate / Direct Member IDNIC', 'nap.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7747, 139440, 'PT Tiga Putra Pandawa', '3pp.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7748, 139441, 'Pemerintah Kabupaten Belitung Timur', 'belitungtimurkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7749, 139442, 'KEMENTERIAN HUKUM DAN HAK ASASI MANUSIA', 'kemenkumham.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7750, 139443, 'Institut Teknologi Nasional Yogyakarta', 'itny.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(7751, 139445, 'PT Adira Dinamika Multi Finance', 'adira.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7752, 139446, 'PT. Gonet Teknologi Indonesia', 'go-net.co.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(7753, 139447, 'PT Transportasi Jakarta', 'transjakarta.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7754, 139448, 'PT Raharja Sinergi Komunikasi', 'raharja-net.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7755, 139449, 'PT Lintas Data Multimedia', 'lintasdata.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7756, 13945, 'PRISM Technologies', 'prismtec.com', 'US', 1536, 'business', '2007-06-11 00:00:00', 0),
(7757, 139451, 'PT SARANA INTI MAKMUR BERSAMA', 'alfa.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7758, 139453, 'PT FASTRATA BUANA', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7759, 139454, 'PT. KERETA COMMUTER INDONESIA (KCI)', 'krl.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7760, 139455, 'PT Mikro Mulia Agung Sentosa', 'micromart.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7761, 139456, 'PT DEWAWEB', 'dewaweb.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(7762, 139457, 'PT Semut Data Indonesia', 'semutdata.co.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(7763, 139458, 'PT Matahari Putra Prima', 'hypermart.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(7764, 139459, 'Dinas Komunikasi dan Informatika Pemerintah Kota Probolinggo', 'probolinggokota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(7765, 139460, 'PT Maxindo Mitra Solusi', 'maxindo.net.id', 'ID', 2816, 'isp', '0000-00-00 00:00:00', 0),
(7766, 139461, 'Earth Zone Internet Service', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7767, 139462, 'CHINANET Guizhou Yilong IDC', 'public.gz.cn', 'CN', 7168, 'business', '0000-00-00 00:00:00', 0),
(7768, 139463, 'Itiviti India Pvt Ltd', 'itiviti.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7769, 139464, 'KMC Mag Solutions', 'kmc.solutions', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7770, 139465, 'MONASH CITY COUNCIL', 'monash.vic.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7771, 139467, 'Community Bank Bangladesh Limited', 'communitybankbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7772, 139468, 'DC Communications Inc.', 'dc-communications.jp', 'JP', 2048, 'business', '0000-00-00 00:00:00', 0),
(7773, 139470, 'OCX GROUP INC.', 'onechronos.com', 'JP', 512, 'business', '0000-00-00 00:00:00', 0),
(7774, 139471, 'HWA CENT TELECOMMUNICATIONS LIMITED', 'hwacentele.com', 'TW', 1280, 'business', '0000-00-00 00:00:00', 0),
(7775, 139473, 'Shebatel Network Ltd', 'shebatel.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7776, 139477, 'Trichy Internet Communication Pvt Ltd', 'ticpl.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7777, 139478, 'Bitwise Solutions Pvt. Ltd.', 'bitwiseglobal.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7778, 139479, 'Isyan Communications Pvt Ltd', 'isyanindia.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7779, 13948, 'Linamar Corporation', 'linamar.com', 'CA', 256, 'business', '2006-04-12 00:00:00', 0),
(7780, 139480, 'Tradebulls Securities Private Limited', 'tradebulls.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7781, 139483, 'Digitizer Access Netowrk Private Limited', 'digitalan.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7782, 139484, 'Sathya Web Services Private Limited', 'sathya.email', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7783, 139486, 'Vetal Hotel And Resort Pvt Ltd', 'hotelamonkargoa.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7784, 139488, 'Conjoinix Total Solutions Private Limited', 'conjoinix.com', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7785, 139490, 'Aspt Networks Pvt Ltd', 'maxnetworks.in', 'IN', 1024, 'business', '0000-00-00 00:00:00', 0),
(7786, 139495, 'Stromnet Communication Private Limited', 'stromnet.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7787, 139497, 'I-infolink Networks Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7788, 139498, 'Speedostar Telco Private Limited', 'speedostar.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7789, 1395, 'Advanced Networks & Services Inc.', 'verizonbusiness.com', 'US', 1792, 'isp', '1994-11-23 00:00:00', 0),
(7790, 13950, 'DLS Internet Services, Inc', 'dls.net', 'US', 768, 'business', '1999-09-21 00:00:00', 0),
(7791, 139501, 'National Crime Records Bureau', 'ncrb.nic.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7792, 139502, 'D\'Decor Home Fabrics Pvt Ltd', 'ddecor.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7793, 139504, 'Minet Communication', 'minet.in', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(7794, 139507, 'Apoxy Media Private Limited', 'apoxymedia.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7795, 139508, 'Wide Netcom India', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7796, 139509, 'Vno Networks Pvt Ltd', 'vnonetworks.com', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(7797, 13951, 'C7 Data Centers, Inc.', 'c7dc.com', 'US', 57344, 'isp', '1999-09-21 00:00:00', 0),
(7798, 139512, 'United India Insurance Co Ltd', 'uiic.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7799, 139513, 'Gighz It Solutions Private Limited', 'gighzbroadband.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7800, 139514, 'Jb Jain Broadband Solutions Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7801, 139516, 'Shiv Nadar Foundation', 'shivnadarfoundation.org', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7802, 139517, 'Softaid Computers', 'softaid.info', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7803, 13952, 'New College Institute', 'newcollegeinstitute.org', 'US', 256, 'education', '2017-12-27 00:00:00', 0),
(7804, 139520, 'Ang India Limited', 'angindia.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7805, 139521, 'Padmnet Broadband Service Pvt. Ltd.', 'padmnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7806, 139522, 'Mediakind India Pvt. Ltd.', 'mediakind.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7807, 139523, 'All Time Tele Infra Pvt Ltd', 'alltimeteleinfra.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7808, 139524, 'A C N Fiber Private Limited', 'acnfiber.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7809, 139525, 'Balaji Enterprises', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7810, 139526, 'Revolution Broadband Pvt.ltd.', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7811, 139527, 'H & R Block India Private Limited', 'hrblock.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7812, 139528, 'Ultron Broadband Private Limited', 'ultroncommunications.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7813, 139529, 'Fastcom Telelink Pvt. Ltd.', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7814, 13953, 'Sauk Valley Community College', 'svcc.edu', 'US', 4096, 'education', '2010-10-25 00:00:00', 0),
(7815, 139533, 'Onquee Networks Pvt Ltd', 'onquee.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7816, 139534, 'Indotel Global Internet Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7817, 139535, 'Raycom Fibers Private Limited', 'muftinternet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(7818, 139536, 'Libsys Limited', 'libsys.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7819, 139537, 'SFour Cablenet Pvt. Ltd.', 'None', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7820, 139538, 'Cable Network Broadband System', 'None', 'IN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7821, 139539, 'Aditya Birla Financial Shared Services Ltd.', 'adityabirla.com', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(7822, 13954, 'Staples, Inc', 'staples.com', 'US', 4352, 'business', '2013-10-16 00:00:00', 0),
(7823, 139540, 'Trl Krosaki Refractories Limited', 'trlkrosaki.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7824, 139541, 'City Infosol Pvt Ltd', 'cityinfosol.com', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7825, 139545, 'Kim Broadband Services Private Limited', 'kim.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7826, 139547, 'Vimitel Network Pvt Ltd', 'vimitel.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7827, 139549, 'Crisp Enterprises', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7828, 13955, 'Echostar Broadcasting Corporation', 'echostar.com', 'US', 768, 'hosting', '2011-01-24 00:00:00', 0),
(7829, 139550, 'Swami Samarth Broadband Service Private Limited', 'ssbs.net.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7830, 139551, 'Dbl Network Private Limited', 'dblnetwork.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7831, 139552, 'Iconnect', 'iconnectisp.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7832, 139553, 'Airicon Communication Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7833, 139554, 'Young Brain India', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7834, 139558, 'Ultrawave Internet Access Pvt Ltd', 'None', 'IN', 1536, 'isp', '0000-00-00 00:00:00', 0),
(7835, 139559, 'Prayag Broadband Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7836, 13956, '1-800-Dentist', '1800dentist.com', 'US', 512, 'business', '2016-02-24 00:00:00', 0),
(7837, 139562, 'Jolly Broadband Pvt Ltd', 'None', 'IN', 1024, 'isp', '0000-00-00 00:00:00', 0),
(7838, 139564, 'Broadway Communication Pvt Ltd', 'broadwaycommunication.net', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7839, 139565, 'Kord Broadband Services Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7840, 139569, 'Samsung Data Systems India Private Limited', 'samsung.com', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7841, 13957, 'Metropolitan Nashville Airport Authority', 'flynashville.com', 'US', 256, 'business', '2007-08-16 00:00:00', 0),
(7842, 139571, 'Shree Ganesh Traders And Services', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7843, 139572, 'Big Data Broadband Pvt. Ltd.', 'bdbpl.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7844, 139575, 'Netzy Internet Services Private Limited', 'netzy.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7845, 139577, 'Hispar Networks Pvt Ltd', 'hispar.net', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(7846, 139578, 'Saab Australia Pty Ltd', 'saabgroup.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7847, 139579, 'Mongolsat Networks LLC', 'mongolsat.mn', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(7848, 139581, 'Molonglo Group (Australia) Pty Ltd', 'molonglogroup.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7849, 139582, 'Ritam Pty Limited', 'ritam-inc.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7850, 139583, 'Silk Contract Logistics Pty Ltd.', 'silklogistics.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7851, 139584, 'China Telecom Jiangsu Nanjing MAN network', 'chinatelecom.cn', 'CN', 256, 'isp', '0000-00-00 00:00:00', 0),
(7852, 139588, 'Institute of Technology of Cambodia', 'itc.edu.kh', 'KH', 256, 'education', '0000-00-00 00:00:00', 0),
(7853, 139589, 'GTDev Network', 'gtdev.org', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(7854, 13959, 'Autophone of Laredo', 'autophone.net', 'US', 4096, 'business', '1999-09-23 00:00:00', 0),
(7855, 139590, 'Galaxy Cyber Cafe', 'gnetworkbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7856, 139592, 'Breeze Connect Pty Ltd', 'breezeconnect.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7857, 139595, 'HTIN HTIN NETWORK COMPANY LIMITED', 'htinhtinnetwork.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(7858, 139597, 'Wellcamp Business Park Pty Ltd', 'wagnerco.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7859, 139600, 'Green Computer & Mobile Care', 'green-net.online', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7860, 139601, 'M.R. Khan Joint Int Trade Center', 'kolbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7861, 139602, 'Micro Link', 'microlinkisp.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7862, 139603, 'Xenex Systems PTY LTD', 'xenexsystems.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7863, 139604, 'Arrow Net', 'arrownetsylhet.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7864, 139605, 'MCDS SOFTWARE (M) SDN BHD', 'mcds.com.my', 'MY', 1792, 'business', '0000-00-00 00:00:00', 0),
(7865, 139606, 'Internet Service Provider - Speedy Group Cloud Limited', 'speedy.com.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(7866, 139607, 'Tatts Group Limited (Tabcorp)', 'tattsgroup.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7867, 139609, 'Solomon Islands Submarine Cable Company', 'siscc.com.sb', 'SB', 512, 'isp', '0000-00-00 00:00:00', 0),
(7868, 139611, 'Beijing Suzi Technology Co. Ltd.', 'biss.com', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(7869, 139612, 'ContentKeeper Technologies', 'contentkeeper.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7870, 139614, 'BANGKO SENTRAL NG PILIPINAS', 'bsp.gov.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7871, 139615, 'Ameropa Australia Pty Ltd', 'impactfertaust.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7872, 139619, 'China Mobile International (Malaysia) Sdn.Bhd.', 'chinamobile.com', 'MY', 256, 'isp', '0000-00-00 00:00:00', 0),
(7873, 139622, 'QUE TEL BD', 'quetelbd.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7874, 139623, 'My Net Pty Ltd', 'mynet.net.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7875, 139626, '2GO Group, Inc.', '2go.com.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(7876, 139627, 'Tekworx Australia Pty Ltd', 'tekworx.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7877, 139628, 'Mega Truenet Communication Co., Ltd.', 'megatruenet.com', 'KH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7878, 139629, 'SUN POP Broadband', 'sunpopbroadband.com', 'BD', 1536, 'business', '0000-00-00 00:00:00', 0),
(7879, 13963, 'Skyview Networks', 'skyviewnetworks.com', 'US', 256, 'business', '2010-01-12 00:00:00', 0),
(7880, 139630, 'Telectronic Systems Inc.', 'wirbroadband.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7881, 139631, 'Lodestone Software Services Pvt. Ltd.', 'lodestonesoftware.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7882, 139632, 'Mirpur Net', 'mirpurnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7883, 139633, 'EXTRANET SYSTEMS PTY LTD', 'extranetsystems.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7884, 139635, 'Hubei Yunwutong Network Technology Co., Ltd.', 'qq.com', 'CN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7885, 139638, 'Antbox Networks Limited', 'antboxnetwork.com', 'HK', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7886, 139640, 'HK NEW CLOUD TECHNOLOGY LIMITED', 'newcloud.hk', 'HK', 40704, 'hosting', '0000-00-00 00:00:00', 0),
(7887, 139643, 'i Smart', 'ismart.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7888, 139646, 'HONG KONG Megalayer Technology Co.,Limited', 'megalayer.com', 'HK', 92416, 'hosting', '0000-00-00 00:00:00', 0),
(7889, 139647, 'Alpha Sattelite Network', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7890, 139648, 'CloudNX', 'cloudnx.cloud', 'KR', 512, 'business', '0000-00-00 00:00:00', 0),
(7891, 139650, 'Virtual Link LLC', 'virtual.mn', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(7892, 139651, 'KAYANAT TECHNOLOGY INTERNET SERVICES CO', 'kayanat.af', 'AF', 512, 'business', '0000-00-00 00:00:00', 0),
(7893, 139652, 'Fusion Net Ltd', 'fusionbd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7894, 139655, 'Singcash Pte. Ltd.', 'dash.com.sg', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(7895, 139656, 'ANZ National Bank', 'anz.com', 'NZ', 16384, 'isp', '0000-00-00 00:00:00', 0),
(7896, 139657, 'University of the Thai Chamber of Commerce', 'utcc.ac.th', 'TH', 2048, 'education', '0000-00-00 00:00:00', 0),
(7897, 139659, 'LUCIDACLOUD LIMITED', 'shuhost.com', 'HK', 6656, 'hosting', '0000-00-00 00:00:00', 0),
(7898, 139661, 'Toll Transport Pty Ltd.', 'toll.com.au', 'AU', 3328, 'business', '0000-00-00 00:00:00', 0),
(7899, 139664, 'Securiton Technologies', 'securiton.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7900, 139665, 'Catholic Church Insurance Limited', 'ccinsurance.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7901, 139666, 'City of Charles Sturt', 'charlessturt.sa.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7902, 139667, 'Ether Techonology Network', 'etnbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7903, 139668, 'Cefalo Bangladesh Ltd', 'cefalo.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7904, 139669, 'Youngones (CEPZ) Ltd.', 'youngonectg.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7905, 13967, 'Buyseasons, Inc.', 'buyseasons.com', 'US', 256, 'business', '2010-07-12 00:00:00', 0),
(7906, 139670, 'Shajalal Islami Bank Ltd.', 'sjiblbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7907, 139671, 'CHRISTIAN CONGREGATION OF JEHOVAH\'S WITNESSES (AUSTRALASIA) LIMITED', 'jw.org', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7908, 139674, 'Square InformatiX Ltd', 'squaregroup.com', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(7909, 139675, 'Freedom Online', 'freedomonlineltd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7910, 139678, 'Joydebpur Network', 'joydebpurnetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7911, 139679, 'Office of the Electoral Commission', 'oec.gov.ws', 'WS', 256, 'business', '0000-00-00 00:00:00', 0),
(7912, 13968, 'CALIFORNIA ISO', 'caiso.com', 'US', 2304, 'business', '1999-09-24 00:00:00', 0),
(7913, 139680, 'Rumel IT', 'None', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7914, 139681, 'Dynamic Computer Services Limited', 'dynamiccomputers.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7915, 139682, 'Arnold & Porter Kaye Scholer LLP', 'apks.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(7916, 139683, 'Gurukul Private Engineering Institute', 'gurukul.edu.bd', 'BD', 512, 'education', '0000-00-00 00:00:00', 0),
(7917, 139684, 'Icertis Solutions Pvt Ltd', 'icertis.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7918, 139686, 'Free Range Cloud Hosting Inc', 'freerangecloud.com', 'NZ', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7919, 139688, 'TIC TIMOR I.P.', 'tic.gov.tl', 'TL', 256, 'isp', '0000-00-00 00:00:00', 0),
(7920, 139689, 'Rahul Enterprise', 'rahulenterprise.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7921, 13969, 'PROFESSIONAL MEDICAL MANAGEMENT, INC.', 'promeddmebilling.com', 'US', 512, 'business', '2017-08-15 00:00:00', 0),
(7922, 139692, 'BICORE ONE NETWORK ENTERPRISE, INC.', 'bicoreone.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(7923, 139694, 'Kiwibank Limited', 'kiwibank.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7924, 139695, 'Kiwibank Limited', 'kiwibank.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7925, 139696, 'IDP Education Pty Ltd', 'idp.com', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7926, 139699, 'Brisbane Tech Services', 'miniport.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7927, 1397, 'ThinkTech, Inc', 'tdameritrade.com', 'US', 1536, 'business', '2009-07-27 00:00:00', 0),
(7928, 139701, 'Plasma Technologist Pvt Ltd', 'plazmatech.org', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(7929, 139703, 'Blujay Solutions India Pvt Ltd', 'blujaysolutions.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7930, 139705, 'Transaction Network Services', 'tnsi.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(7931, 139707, 'MALNAD INFOTECH PRIVATE LIMITED', 'malnadinfotech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(7932, 139708, 'GONI Communication', 'gonicommunication.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7933, 139709, 'EZSVS SINGAPORE(PTE.) LTD.', 'ezsvs.net', 'SG', 768, 'isp', '0000-00-00 00:00:00', 0),
(7934, 13971, 'HedgeServ Corporation', 'hedgeserv.com', 'US', 1792, 'business', '2007-03-12 00:00:00', 0),
(7935, 139711, 'KANBAWZA BANK LIMITED', 'kbzbank.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(7936, 139715, 'ADAPT IT AUSTRALASIA PROPRIETARY LIMITED', 'wisenet.co', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7937, 139716, 'B.M IT and Cyber Place', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7938, 139718, 'Tornado Networks (Pvt.) Limited', 'tornado.com.pk', 'PK', 512, 'isp', '0000-00-00 00:00:00', 0),
(7939, 139719, 'Yar Chang Company Limited', 'yarchang.net', 'MM', 1024, 'business', '0000-00-00 00:00:00', 0),
(7940, 13972, 'Wadsworth Center, NYS Department of Health', 'ny.gov', 'US', 4096, 'isp', '1999-09-28 00:00:00', 0),
(7941, 139721, 'HeFei', 'chinatelecom.cn', 'CN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(7942, 139722, 'Friends Cable Net', 'fcnetbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7943, 139723, 'Cloud Connect WA Pty Ltd', 'cloudconnect.tech', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7944, 139724, 'Tobacco Authority of Thailand', 'thaitobacco.or.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(7945, 139726, 'Guangdong Yunjie Communication Co., Ltd.', 'gdyunjie.com', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(7946, 139727, 'Harvest International Development (HK) Limited', 'networkcorehk.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7947, 139728, 'Planet Three Communication', 'planet3communication.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7948, 139729, 'Ana Victoria Lopez Mascardo', 'advertiseg.net', 'PH', 4608, 'business', '0000-00-00 00:00:00', 0),
(7949, 139730, 'FINEXUS INTERNATIONAL', 'finexusgroup.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(7950, 139731, 'Hatton National Bank PLC', 'hnb.net', 'LK', 256, 'business', '0000-00-00 00:00:00', 0),
(7951, 139734, 'Ningbo Rongxin Ansheng Machinery Co., Ltd.', 'rxmech.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7952, 139735, 'PACE IT', 'paceitbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7953, 139736, 'Apexhost Pty Ltd', 'apexhost.com.au', 'AU', 1280, 'hosting', '0000-00-00 00:00:00', 0),
(7954, 139737, 'Catholic Regional College Caroline Springs', 'crccs.catholic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(7955, 139739, 'Hsin Yi Pte Ltd', 'hsinyi-sg.com', 'SG', 1280, 'business', '0000-00-00 00:00:00', 0),
(7956, 13974, 'Saddlebrook Resorts, Inc.', 'saddlebrookresort.com', 'US', 1024, 'business', '2010-03-22 00:00:00', 0),
(7957, 139740, 'Mobis Parts Australia Pty Ltd', 'mobis.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7958, 139741, 'World Fiber Net Pvt. Ltd.', 'worldfibernet.net.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(7959, 139742, 'Peddie Institute Co., Ltd', 'peddie.institute', 'CN', 256, 'business', '0000-00-00 00:00:00', 0),
(7960, 139747, 'Children\'s Cancer Institute Australia', 'ccia.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7961, 139748, 'Hawkes Bay District Health Board', 'hbdhb.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(7962, 13975, 'NYCPM', 'nycpm.edu', 'US', 256, 'education', '2015-02-10 00:00:00', 0),
(7963, 139750, 'IDCServices.net Inc', 'idcservices.net', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(7964, 139752, 'Multinetwork Cable Television, Inc', 'multinetcabletv.com', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(7965, 139753, 'Valaya Alongkorn Rajabhat University Under The Royal Patronage,', 'rit.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(7966, 139755, 'BISMILLAH TELECOM', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7967, 139757, 'Talukder net', 'talukdernet.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7968, 139758, 'Shine Communication', 'shine.net.bd', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7969, 139759, 'FSM Telecommunications Corporation', 'fsmtc.fm', 'FM', 5120, 'isp', '0000-00-00 00:00:00', 0),
(7970, 13976, 'Topocean Consolidation Service (Los Angeles), Inc.', 'topocean.com', 'US', 256, 'business', '2007-12-17 00:00:00', 0),
(7971, 139760, 'NTT Australia Pty Ltd', 'global.ntt', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7972, 139761, 'Gigabit Fiber Sdn Bhd', 'gigabit-fiber.com', 'MY', 256, 'business', '0000-00-00 00:00:00', 0),
(7973, 139762, 'Solution', 'solution.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7974, 139763, 'Live Technologies Limited', 'live-technologies.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7975, 139764, 'Web X-Press', 'xpress.ltd', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(7976, 139766, 'Protocol Technologies Co.,Ltd t/a KNET', 'knet.com.mm', 'MM', 512, 'isp', '0000-00-00 00:00:00', 0),
(7977, 139768, 'COCHLEAR LIMITED', 'cochlear.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7978, 139769, 'Linkin Net', 'linkinnet.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7979, 13977, 'FAIRPOINT COMMUNICATIONS, INC.', 'fairpoint.com', 'US', 297472, 'isp', '2006-04-12 00:00:00', 0),
(7980, 139770, 'SADAT Telecom', 'sadattelecom.af', 'AF', 256, 'business', '0000-00-00 00:00:00', 0),
(7981, 139771, 'Alpha Network', 'alphanetwork.com.bd', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(7982, 139773, 'Netex Limited', 'netex.broker', 'HK', 1280, 'business', '0000-00-00 00:00:00', 0),
(7983, 139774, 'CERNET Center', 'cernet.edu.cn', 'CN', 256, 'education', '0000-00-00 00:00:00', 0),
(7984, 139776, 'Petroliam Nasional Berhad', 'petronas.com.my', 'MY', 65536, 'business', '0000-00-00 00:00:00', 0),
(7985, 139777, 'Water NSW', 'waternsw.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(7986, 139778, 'DALTRON', 'daltronpng.com', 'PG', 256, 'business', '0000-00-00 00:00:00', 0),
(7987, 139779, 'Cambo.Host Ltd', 'cambo.host', 'KH', 1024, 'hosting', '0000-00-00 00:00:00', 0),
(7988, 13978, 'Washington Health Benefit Exchange', 'wahbexchange.org', 'US', 256, 'business', '2014-03-27 00:00:00', 0),
(7989, 139780, 'Brother\'s ICT Connectivity', 'brothersict.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(7990, 139785, 'Melbourne Water Corporation', 'melbournewater.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(7991, 139786, 'Rainbow Network', 'rainbownetworkbd.com', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(7992, 139788, 'Kochar Infotech Limited', 'kochartech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7993, 13979, 'AT&T Services, Inc.', 'att.com', 'US', 97024, 'isp', '1999-09-28 00:00:00', 0),
(7994, 139792, 'Browser World IT', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(7995, 139793, 'Crystal International', 'crystalintbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(7996, 139794, 'Glovis India Anathapur Private Limited', 'gia.net.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(7997, 139797, 'HONGKONG-CLOUD-AP', 'mekongnet.com.kh', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(7998, 139798, 'LizardBear Tasking Inc', 'globe.com.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(7999, 139799, 'Beijing Dajia Internet Information Technology Co., Ltd.', 'kuaishou.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(8000, 13980, 'Twotrees Technologies, LLC', 'twotrees.net', 'US', 1536, 'business', '2006-04-13 00:00:00', 0),
(8001, 139804, 'RED PALM COMPANY LIMITED', 'mmredpalm.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(8002, 139805, 'Hong Kong Zeyond Technology  Limited', 'zeyond.com', 'HK', 6656, 'hosting', '0000-00-00 00:00:00', 0),
(8003, 139806, 'Master Net', 'masternetbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8004, 139807, 'Pioneer IT', 'pioneeritbd.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8005, 139808, 'Sony Cyber Net', 'sonycyber.net', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(8006, 139809, 'Swift Net', 'swiftnetbd.com', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(8007, 13981, 'Institute for Transfusion Medicine', 'itxm.org', 'US', 1024, 'business', '2007-06-11 00:00:00', 0),
(8008, 139811, 'ANLIAN NETWORK TECHNOLOGY CO., LIMITED', 'anlian.hk', 'HK', 3328, 'business', '0000-00-00 00:00:00', 0),
(8009, 139813, 'Smart Online', 'smartonlinebd.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8010, 139814, 'Speed 69.Net', 'speed69.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8011, 139815, 'Taylor\'s University Sdn Bhd', 'taylors.edu.my', 'MY', 512, 'education', '0000-00-00 00:00:00', 0),
(8012, 139817, 'HONG KONG GIGALINK NETWORK LIMITED', 'gigalinkhk.com', 'HK', 1536, 'business', '0000-00-00 00:00:00', 0),
(8013, 13982, 'National Industries for the Blind', 'nib.org', 'US', 256, 'business', '2012-06-12 00:00:00', 0),
(8014, 139822, 'GNE Company Limited', 'gne.com.sg', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(8015, 139823, 'Dhrubotech Limited', 'dhrubotech.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8016, 139826, 'MAA TELECOM B ONLINE', 'b-online.network', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8017, 139829, 'RigNet Pte Ltd', 'rig.net', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(8018, 13983, 'ALE Solutions Inc', 'alesolutions.com', 'US', 512, 'business', '2017-08-10 00:00:00', 0),
(8019, 139830, 'Payments Network Malaysia Sdn Bhd (PayNet)', 'paynet.my', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(8020, 139831, 'DITO TELECOMMUNITY CORP.', 'dito.ph', 'PH', 2304, 'business', '0000-00-00 00:00:00', 0),
(8021, 139832, 'Sylhet-Net Broadband', 'sylhetnetbroadband.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8022, 139834, 'Savar Net City', 'netcitybd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8023, 139835, 'Puspita Telecom', 'saruargroup.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8024, 139836, 'COMMRUN COMMUNICATION SERVICE (HONGKONG) CO., LIMITED', 'commrun.net', 'HK', 4096, 'business', '0000-00-00 00:00:00', 0),
(8025, 139837, 'SHINE SANSAR CABLE LLC', 'newsansarcatv.mn', 'MN', 512, 'business', '0000-00-00 00:00:00', 0),
(8026, 139838, 'WILLOW TECHNOLOGY CORPORATION PTY LTD', 'willowinc.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8027, 13984, 'SD Data Center', 'sddatacenter.com', 'US', 18432, 'business', '2006-09-20 00:00:00', 0),
(8028, 139841, 'STAR COMMUNICATION', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8029, 139843, 'Bayside Council', 'nsw.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8030, 139844, 'FIBER NANOTECH (Cambodia) Co.,Ltd', 'None', 'KH', 512, 'isp', '0000-00-00 00:00:00', 0),
(8031, 139845, 'CARLISLE HOMES PTY LTD', 'carlislehomes.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8032, 139848, 'SAFEGUARD HOME IMPROVEMENTS PTY LTD', 'safeguard.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8033, 139849, 'Royal Esprit Company Limited', 'royalespritmm.net', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(8034, 13985, 'NASCO', 'nasco.com', 'US', 256, 'business', '2010-04-23 00:00:00', 0),
(8035, 139850, 'Hi-Tec Enterprise', 'hitecenterprise.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8036, 139851, 'CHINA INTERNATIONAL CRANCLOUD CO., LIMITED', 'grandacom.cn', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8037, 139853, 'NOMINET UK', 'nic.uk', 'GB', 1280, 'business', '0000-00-00 00:00:00', 0),
(8038, 139854, 'Digi Net', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8039, 139856, 'Brac Bank Limited', 'bracbank.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8040, 139857, 'Tiger Global Network & Communication', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8041, 139858, 'ALIFA CYBER CAFE', 'alifanet.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8042, 13986, 'ECSIS.NET', 'ecsis.net', 'US', 8448, 'business', '1999-09-28 00:00:00', 0),
(8043, 139863, 'VIP.com', 'vip.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8044, 139864, 'National Investment And Infrastructure Fund Limited', 'niifindia.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8045, 139865, 'Bitroot Systems Limited', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8046, 139867, 'TaskUs is a BPO company.', 'pldt.com.ph', 'PH', 256, 'isp', '0000-00-00 00:00:00', 0),
(8047, 139869, 'Lucidity IT Pty Ltd', 'lucidityit.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8048, 139870, 'BlueNet Communication JV Ltd.', 'bluenetbd.com', 'BD', 768, 'isp', '0000-00-00 00:00:00', 0),
(8049, 139871, 'Y Net Public Co. Ltd.', 'ynetmm.com', 'MM', 256, 'business', '0000-00-00 00:00:00', 0),
(8050, 139872, 'Rapid Technology', 'rapid.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8051, 139875, 'Noakhali Internet Exchange', 'nixbd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8052, 139876, 'COSCO SHIPPING LINES (NEW ZEALAND) LIMITED', 'cosco.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8053, 139879, 'Galaxy Broadband', 'galaxy.net.pk', 'PK', 27136, 'isp', '0000-00-00 00:00:00', 0),
(8054, 139881, 'BDM Internet', 'bdminternet.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8055, 139883, 'SPTEL PTE. LTD.', 'sptel.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(8056, 139884, 'Apeiron Global Pvt. Ltd.', 'apeiron.global', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(8057, 139885, 'Fushanj Telecom ISP', 'fushanj.net', 'AF', 256, 'isp', '0000-00-00 00:00:00', 0),
(8058, 139887, 'ChinaNet Shandong Yantai IDC network', 'sdinfo.net', 'CN', 6656, 'business', '0000-00-00 00:00:00', 0),
(8059, 139889, 'Department of Fisheries', 'fisheries.go.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(8060, 13989, 'Sony Interactive Entertainment America LLC', 'playstation.com', 'US', 256, 'business', '2005-05-10 00:00:00', 0),
(8061, 139891, 'OneWiFi & Infrastructure', 'onewifi.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8062, 139892, 'Metropolitan Waterworks Authority', 'mwa.co.th', 'TH', 256, 'business', '0000-00-00 00:00:00', 0),
(8063, 139895, 'Air Liquide Industrial Services Pte Ltd', 'airliquide.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(8064, 139896, 'Kim Chuan Telecommunications Complex', 'flextronics.com', 'SG', 1536, 'business', '0000-00-00 00:00:00', 0),
(8065, 139897, 'TECH99', 'tech99.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8066, 1399, 'ThinkTech, Inc', 'tdameritrade.com', 'US', 4864, 'business', '2009-07-27 00:00:00', 0),
(8067, 13990, 'County of Orange', 'orangeburgcounty.org', 'US', 15104, 'business', '1999-09-29 00:00:00', 0),
(8068, 139900, 'RELIANCE CATV AND ENTERTAINMENT SERVICES', 'apluszure.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(8069, 139901, 'Apple Communication Ltd.', 'apple-communications.net', 'BD', 1024, 'business', '0000-00-00 00:00:00', 0),
(8070, 139902, 'SURKHET CABLE NET T.V. PVT. LTD.', 'None', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(8071, 139903, 'RETN Telecoms Ltd.', 'retn.net', 'TW', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8072, 139904, 'Kloud Technologies Limited', 'kloud.com.bd', 'BD', 1280, 'business', '0000-00-00 00:00:00', 0),
(8073, 139906, 'Rural Wireless Limited', 'ruralwireless.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(8074, 139909, 'COLLECTIVE GATEWAY', 'collectivegateway.net.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8075, 139910, 'Origin Energy Services Ltd', 'originenergy.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8076, 139911, 'DELUXE ENTERTAINMENT SERVICES INDIA PRIVATE LIMITED', 'bydeluxe.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8077, 139914, 'WPP Hong Kong', 'wpp.com', 'HK', 1024, 'business', '0000-00-00 00:00:00', 0),
(8078, 139915, 'Ashanet bd', 'ashanetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8079, 139917, 'Aquinas College', 'aquinas.edu', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(8080, 139919, 'RDC Online', 'rdconlinebd.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8081, 13992, 'SailPoint Technologies, Inc.', 'sailpoint.com', 'US', 256, 'business', '2017-11-08 00:00:00', 0),
(8082, 139922, 'Simple Media Network Private Limited', 'simtv.com.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(8083, 139924, 'Pipex Communication', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8084, 139925, 'SharkNet Telecom Pvt. Ltd.', 'sharknets.net', 'PK', 512, 'isp', '0000-00-00 00:00:00', 0),
(8085, 139927, 'Galaxy Net', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8086, 139928, 'Third Wave Technologies Ltd', 'twtinc.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8087, 139929, 'Chicago Trading Company (CTC) Limited', 'chicagotrading.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8088, 13993, 'MOTIVE,  INC.', 'motive.com', 'US', 5120, 'business', '1999-09-29 00:00:00', 0),
(8089, 139930, 'Mylan Laboratories Ltd', 'mylan.in', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8090, 139932, 'DINAS KOMUNIKASI DAN INFORMATIKA KABUPATEN KARAWANG', 'karawangkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8091, 139937, 'PT Kuantum Bhinneka Wishaka', 'kuantum.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8092, 139939, 'Institut Seni Budaya Indonesia Bandung', 'isbi.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8093, 13994, 'Owensboro Municipal Utilities', 'omu.org', 'US', 5120, 'business', '1999-09-29 00:00:00', 0),
(8094, 139940, 'Dinas Komunikasi dan Informatika Kabupaten Sampang', 'sampangkab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8095, 139941, 'RIYAD NETWORK', 'riyadnetwork.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8096, 139942, 'Dinas Komunikasi dan Informasi Kabupaten Batang', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8097, 139943, 'Dinas Komunikasi dan Informatika Kabupaten Garut', 'garutkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8098, 139945, 'Pemerintah Kabupaten Purbalingga', 'purbalinggakab.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8099, 139946, 'PT. Teknologi Bumi Nusantara', 'nicemedia.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8100, 139947, 'PT Sumber Teknologi Sejahtera', 'sts.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8101, 139948, 'Dinas Komunikasi dan Informatika Kota Banjarbaru', 'banjarbarukota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8102, 139949, 'PT. Bintang Kejora Teknologi', 'kejora.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8103, 13995, 'Personnel Decisions Research Institutes, Inc.', 'pdri.com', 'US', 256, 'business', '2012-09-25 00:00:00', 0),
(8104, 139951, 'PT Alfatih Indo Teknologi', 'alfatindo.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8105, 139952, 'PT Trisari Data Indonusa', 'tridata.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8106, 139953, 'PT.GLOBAL INTERNET DATA', 'g-internetdata.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8107, 139955, 'PT DATA PRIMA SOLUSINDO', 'dataprime.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8108, 139956, 'CV. NATANETWORK SOLUTION', 'natanetwork.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8109, 139957, 'Dinas Komunikasi Informatika dan Statistik Provinsi Lampung', 'lampungprov.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8110, 139958, 'PT Fakta Jabbar Industri', 'fakta-ji.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8111, 13996, 'Dish Network Corporation', 'dish.com', 'US', 3584, 'business', '1999-09-29 00:00:00', 0),
(8112, 139960, 'Politeknik Negeri Samarinda', 'polnes.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8113, 139961, 'PT Wizzy Smart Technology', 'wizzytech.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8114, 139962, 'PT.Bestcamp Prima Data', 'bestcamp.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8115, 139963, 'PT.MURNI MAKMUR ABADI', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8116, 139964, 'PT. Edmasan Citra Telekomindo', 'citrasan.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8117, 139965, 'PT Mitra Jaringan Nusantara', 'mitranusa.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8118, 139966, 'PT. QAULI AMALI INTEGRA', 'qauliamali.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8119, 139967, 'PT. Yasmin Amanah Media', 'yam.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8120, 139968, 'Kementerian Riset dan Teknologi / Badan Riset dan Inovasi Nasional', 'ristekbrin.go.id', 'ID', 1280, 'business', '0000-00-00 00:00:00', 0),
(8121, 13997, 'Rapid Displays, Inc', 'rapiddisplays.com', 'US', 512, 'business', '2012-09-25 00:00:00', 0),
(8122, 139971, 'PT. Medialink Intercontinental', 'mdl.net.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(8123, 139972, 'PT. Putra Lebak Banten', 'plb.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8124, 139973, 'Pemerintah Kabupaten Muara Enim', 'muaraenimkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8125, 139977, 'PT PRISMA MEDIA NUSANTARA', 'prisma.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8126, 139978, 'PT Jaringan Rtrwnet Nusantara', 'rtrw.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8127, 139979, 'PT. Enseval Putera Megatrading, Tbk', 'enseval.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8128, 13998, 'UT Southwestern Medical Center at Dallas', 'utsouthwestern.edu', 'US', 85504, 'education', '1999-10-01 00:00:00', 0),
(8129, 139980, 'Dinas Komunikasi Informasi Kota Tasikmalaya', 'tasikmalayakota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8130, 139981, 'PT. Menaksopal Link Nusantara', 'menaksopal.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8131, 139982, 'PT Buana Visualnet Sentra', 'bvs.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8132, 139984, 'PT Indomedia Solusi net', 'inmeet.net', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8133, 139985, 'Dinas Komunikasi dan Informatika Kab. Hulu Sungai Tengah', 'hulusungaitengahkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8134, 139986, 'PT. HENAN PUTIHRAI SEKURITAS', 'henanputihrai.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8135, 139988, 'PT. GARUDA PRIMA INTERNETINDO', 'fly.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8136, 139989, 'CV Atha Media Prima', 'athamedia.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8137, 13999, 'Mega Cable, S.A. de C.V.', 'megacable.com.mx', 'MX', 1926144, 'isp', '1999-10-01 00:00:00', 0),
(8138, 139993, 'PT. FORIT ASTA SOLUSINDO', 'sekolahan.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8139, 139995, 'PT. Akashia Thuba Jaya', 'akashiathubajaya.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8140, 139996, 'DINAS KOMUNIKASI DAN INFORMATIKA KABUPATEN TABANAN', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8141, 139997, 'PT Wortel', 'wortel.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8142, 14, 'Columbia University', 'columbia.edu', 'US', 208896, 'education', '0000-00-00 00:00:00', 0),
(8143, 140, 'DoD Network Information Center', 'mail.mil', 'US', 65536, 'isp', '1987-12-03 00:00:00', 0),
(8144, 140001, 'SEKRETARIAT BADAN LITBANG DAN INOVASI KEMENTRIAN LINGKUNGAN HIDUP DAN KEHUTANAN', 'menlhk.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8145, 140002, 'KANTOR KESEHATAN PELABUHAN KELAS II SEMARANG', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8146, 140004, 'DINAS KOMUNIKASI INFORMATIKA DAN STATISTIK KOTA BLITAR', 'blitarkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8147, 140006, 'RSUP DR KARIADI', 'rskariadi.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8148, 140007, 'PT. DANKOM MITRA ABADI', 'dankom.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8149, 140008, 'PT Inti Media Teknologi', 'intimediateknologi.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8150, 140009, 'PT. Riau Satu Net', 'r1net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8151, 14001, 'Vision Net Ltd', 'vision.net', 'US', 18176, 'isp', '1999-10-01 00:00:00', 0),
(8152, 140010, 'INSTITUT AGAMA ISLAM NEGERI PURWOKERTO', 'iainpurwokerto.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8153, 140011, 'PT. KRISNA BERKAT INVESTINDO', 'krisnainvestindo.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8154, 140012, 'PT Dewata Solusi Tehnologi', 'dewatanet.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8155, 140013, 'PT Global Media Visual', 'mola.tv', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8156, 140014, 'KEMENTERIAN PARIWISATA DAN EKONOMI KREATIF', 'kemenparekraf.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8157, 140015, 'Politeknik Negeri Indramayu', 'polindra.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8158, 140018, 'PT. CYBER TEKNOLOGI PUTRAWAN', 'cybertek.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8159, 140019, 'Universitas Advent Indonesia', 'unai.edu', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8160, 14002, 'RAILINC', 'railinc.com', 'US', 256, 'business', '1999-10-01 00:00:00', 0),
(8161, 140020, 'PT. Klik Indomaret Sukses', 'idmsukses.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8162, 140021, 'PT Brankas Teknologi Indonesia', 'cbn.net.id', 'ID', 512, 'isp', '0000-00-00 00:00:00', 0),
(8163, 140023, 'Dinas Komunikasi dan Informatika Kota Madiun', 'madiunkota.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8164, 140024, 'PT Pelabuhan Indonesia III (Persero)', 'pelindo.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8165, 140025, 'INSTITUT AGAMA ISLAM NEGERI (IAIN) PONOROGO', 'iainponorogo.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8166, 140026, 'PT. KUPANG INTERMEDIA', 'timornet.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8167, 140027, 'PT. Ruang Siber Indonesia', 'ruangsiber.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8168, 140028, 'PT Brahmayasa Sejahtera Abadi', 'brahmayasa.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8169, 140029, 'PUSAT LITBANG SUMBER DAYA AIR', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8170, 14003, 'Vanguard Health Management, Inc.', 'vanguardhealth.com', 'US', 512, 'business', '2008-12-18 00:00:00', 0),
(8171, 140030, 'DINAS KOMUNIKASI DAN INFORMATIKA KABUPATEN PEKALONGAN', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8172, 140031, 'PT Mandala Lintas Nusa', 'nusa.net.id', 'ID', 1024, 'isp', '0000-00-00 00:00:00', 0),
(8173, 140032, 'United Overseas Bank (Thai) Public Company Limited', 'uih.co.th', 'TH', 512, 'isp', '0000-00-00 00:00:00', 0),
(8174, 140033, 'Indian Institute of Technology Bhilai', 'iitbhilai.ac.in', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(8175, 140037, 'A R ENTERPRISE', 'blink2link.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8176, 140040, 'SHILMANDI ONLINE', 'shilmandionline.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8177, 140041, 'The Geelong College', 'geelongcollege.vic.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(8178, 140042, 'Zhipinshang (Hongkong) Electron Communication Technology Limited', 'izec.vip', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8179, 140045, 'MultiCity Broad Band Pvt Ltd', 'None', 'PK', 512, 'isp', '0000-00-00 00:00:00', 0),
(8180, 140047, 'QBE Insurance Group Ltd', 'qbe.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8181, 14005, 'Data-Tech', 'datatech-usa.com', 'US', 1024, 'business', '2007-01-09 00:00:00', 0),
(8182, 140050, 'Next Geekers Pvt. Ltd.', 'nextgeekers.com.np', 'NP', 256, 'business', '0000-00-00 00:00:00', 0),
(8183, 140052, 'Behenobe Trade Services Pte. Ltd.', 'behenobe.net', 'SG', 1536, 'business', '0000-00-00 00:00:00', 0),
(8184, 140054, 'Friends BroadBand Network', 'fbn.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8185, 140058, 'YOTTABYTE COMMUNICATIONS GROUP LIMITED', 'yottaglobal.net', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8186, 14006, 'RAFFERTY CAPITAL MARKETS', 'raffertyholdings.com', 'US', 1024, 'business', '2007-06-12 00:00:00', 0),
(8187, 140060, 'GEODIS AUSTRALIA PTY LTD', 'geodis.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8188, 140061, 'Qinghai Telecom', 'xn.qh.cn', 'CN', 516096, 'isp', '0000-00-00 00:00:00', 0),
(8189, 140062, 'Vision 6 Pty Ltd', 'vision6.com', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(8190, 140063, 'Time Technology', 'timetechbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8191, 140064, 'ISAAC REGIONAL COUNCIL', 'isaac.qld.gov.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8192, 140065, 'CiFi Pty Ltd', 'cifi.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8193, 140066, 'MOEL TRADING CO. LTD.', 'moeltrading.com', 'KI', 512, 'isp', '0000-00-00 00:00:00', 0),
(8194, 140068, '360 Internet Inc', 'internet.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8195, 140069, 'Dream Touch Online', 'dreamtouch.online', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8196, 14007, 'Skyway West', 'skywaywest.com', 'CA', 26368, 'isp', '1999-10-05 00:00:00', 0),
(8197, 140070, 'Adelaide Oval SMA Ltd', 'adelaideoval.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8198, 140071, 'The Smart Network', 'smartnetwork.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8199, 140072, 'Fiberworld Communication Pvt.ltd', 'fiberworld.net.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(8200, 140073, 'Digital Synapse', 'digitalsynapsebd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8201, 140074, 'RBWiFi', 'rbwifi.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8202, 140076, 'Mir Internet Service', 'mirinternetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8203, 140077, 'C Net Broadband', 'None', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8204, 14008, 'Rogers Communications Canada Inc.', 'rogers.com', 'CA', 8192, 'isp', '2007-06-12 00:00:00', 0),
(8205, 140080, 'A1 Cyberlink BD', 'a1cyberlinkbd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(8206, 140082, 'Sniperhill Internet Services LLC', 'dhitelecom.com', 'AF', 256, 'isp', '0000-00-00 00:00:00', 0),
(8207, 140083, 'China Telecom', 'chinatelecom.cn', 'CN', 9472, 'isp', '0000-00-00 00:00:00', 0),
(8208, 140084, 'Sinthia Telecom', 'sinthiaisp.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8209, 140085, 'NET EXPRESS', 'netexpress.info', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8210, 140087, 'Jannat Mir Internet Service', 'jannatmirinternetservice.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8211, 140089, 'Turners Automotive Group Limited', 'turnersautogroup.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8212, 140090, 'HK Net', 'hknetbd.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8213, 140091, 'SHWE MAHAR MAE KHONG INDUSTRIAL COMPANY LIMITED', 'smktelecom.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(8214, 140092, 'UNIVERSITI TEKNIKAL MARA SDN. BHD.', 'unikl.edu.my', 'MY', 256, 'education', '0000-00-00 00:00:00', 0),
(8215, 140093, 'Virtual Communications', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8216, 140094, 'RapidValue IT Services Private Limited', 'rapidvaluesolutions.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8217, 140096, 'Jinx Co. Limited', 'betaidc.com', 'HK', 2304, 'isp', '0000-00-00 00:00:00', 0),
(8218, 140097, 'BLUESCOPE STEEL LIMITED', 'bluescopesteel.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8219, 140099, 'Rising Sun Pictures', 'rsp.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8220, 1401, 'DSW Information Technology LLC.', 'dswinc.com', 'US', 768, 'business', '2009-07-28 00:00:00', 0),
(8221, 14010, 'Jack Henry & Associates, Inc.', 'jackhenry.com', 'US', 18432, 'business', '1999-10-05 00:00:00', 0),
(8222, 140100, 'MAC WIFI NETWORKS (PRIVATE) LIMITED', 'macwifinetworks.net', 'PK', 512, 'isp', '0000-00-00 00:00:00', 0),
(8223, 140103, 'Invention Technologies Limited', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8224, 140107, 'CITIS CLOUD GROUP LIMITED', 'zoneidc.com', 'HK', 57856, 'hosting', '0000-00-00 00:00:00', 0),
(8225, 140108, 'Airson Broadband', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8226, 14011, 'Design Data Systems, Inc.', 'designdata.com', 'US', 1536, 'business', '2014-05-27 00:00:00', 0),
(8227, 140110, 'Vikram Sarabhai Space Centre', 'vssc.gov.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8228, 140112, 'Commonbee Broadband Pvt Ltd', 'commonbeenetwork.com', 'IN', 768, 'isp', '0000-00-00 00:00:00', 0),
(8229, 140115, 'Smart Logic It Solutions', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8230, 140116, 'Jet Fiber', 'None', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(8231, 140118, 'Indian Institute Of Technology Banaras Hindu University', 'iitbhu.ac.in', 'IN', 512, 'education', '0000-00-00 00:00:00', 0),
(8232, 140119, 'Tollot Network Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8233, 14012, 'Private National Mortgage Acceptance Company LLC', 'pnmac.com', 'US', 768, 'business', '2010-01-12 00:00:00', 0),
(8234, 140121, 'Hcin Networks Pvt Ltd', 'hicomindia.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8235, 140122, 'Omnet Infratech Pvt Ltd', 'omnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8236, 140123, 'Iconwave Technologies Private Limited', 'iconwavetech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8237, 140125, 'St Broadband Cable Servise Pvt Ltd', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8238, 140127, 'Internetwala It Services Pvt Ltd', 'internetwala.co.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8239, 14013, 'EPSON America (Factory Automation/Robotics)', 'epson.com', 'US', 2304, 'business', '2005-05-11 00:00:00', 0),
(8240, 140131, 'Digiscope Networks Private Limited', 'ascope.in', 'IN', 256, 'isp', '0000-00-00 00:00:00', 0),
(8241, 140133, 'Myworld Internet Services Pvt Ltd', 'mwis.in', 'IN', 768, 'business', '0000-00-00 00:00:00', 0),
(8242, 140134, 'Ajwa Kaif Pvt Ltd', 'ajwakaif.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8243, 140136, 'Lan Stack Networks Private Limited', 'lanstack.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8244, 140137, 'Starplanet Technovision Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8245, 14014, 'Canadian National Railway', 'cn.ca', 'CA', 66560, 'business', '1999-10-05 00:00:00', 0),
(8246, 140141, 'Sapient Consulting Ltd.', 'sapient.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8247, 140143, 'Vishva Infratel Pvt. Ltd.', 'vishvainfratel.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8248, 140144, 'Vcitynet(Opc) Pvt Ltd.', 'vcitynet.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8249, 14015, 'Immunomedics, Inc.', 'immunomedics.com', 'US', 512, 'business', '2018-08-02 00:00:00', 0),
(8250, 140155, 'The Pinnacle Group Inc', 'thepinnaclegroup.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8251, 140157, 'Wave Network Solutions', 'wavenetworks.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8252, 140158, 'Net Access Internet India Pvt Ltd', 'netaccessinternet.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8253, 140162, 'Broadridge Financial Solutions India Pvt Ltd', 'broadridge.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8254, 140163, 'V-Connect Systems And Services Pvt. Ltd.', 'v-connect.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8255, 140164, 'ConnectSpacelink Infomedia Pvt Ltd', 'connectspacelink.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8256, 140166, 'Rythym Broadband Pvt Ltd', 'rythym.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8257, 140167, 'Anl Network Pvt Ltd', 'anlnetwork.in', 'IN', 512, 'isp', '0000-00-00 00:00:00', 0),
(8258, 140168, 'Bijis Internet Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8259, 140169, 'Yuvi Communications Pvt. Ltd.', 'yuvicommunications.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8260, 14017, 'Burlington Northern Sante Fe Railway Corp', 'bnsf.com', 'US', 131072, 'business', '1999-10-05 00:00:00', 0),
(8261, 140170, 'Office Of The Registrar General India', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8262, 140171, 'Reis Network Solutions', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8263, 140172, 'Air Access Net Private Limited', 'None', 'IN', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8264, 140173, 'Kavya Internet Services Pvt. Ltd.', 'kavyainternetservices.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8265, 140174, 'MITHRIL TELECOMMUNICATIONS PVT. LTD.', 'mithriltelecom.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8266, 140186, 'Amt Media Tech', 'ajaxmediatech.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8267, 140198, 'Kk Arun Network Private Limited', 'None', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8268, 14020, 'Longwood Gardens Inc.', 'longwoodgardens.org', 'US', 512, 'business', '2006-11-07 00:00:00', 0),
(8269, 14021, 'Pennsylvania State Employees Credit Union', 'psecu.com', 'US', 1024, 'business', '1999-10-05 00:00:00', 0),
(8270, 140210, 'ConnectX', 'connectx.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(8271, 140211, 'City of Marion', 'marion.sa.gov.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8272, 140216, 'Bandhon Enterprise', 'bandhon.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8273, 140218, 'Yotta Infrastructure solutions LLP', 'yotta.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(8274, 14022, 'Backbone Communications, Inc.', 'backbonecommunications.com', 'US', 8192, 'business', '1999-10-05 00:00:00', 0),
(8275, 140220, 'Sky Network Television Ltd', 'skytv.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8276, 140223, 'METROLINK,LDA.', 'metrolink.tl', 'TL', 512, 'business', '0000-00-00 00:00:00', 0),
(8277, 140224, 'White-Sand Cloud Computing(HK) Co., LIMITED', 'wscloudx.com', 'HK', 1536, 'hosting', '0000-00-00 00:00:00', 0),
(8278, 140225, 'Data Future Communication', 'datafuture-communication.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8279, 140226, 'Little Boys. Net', 'littleboys.com.bd', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(8280, 140227, 'Hong Kong Communications International Co., Limited', 'udc.hk', 'HK', 2048, 'business', '0000-00-00 00:00:00', 0),
(8281, 140229, 'Alvi Online', 'alvionline.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8282, 14023, 'Minnesota Wild', 'wild.com', 'US', 256, 'business', '2006-09-11 00:00:00', 0),
(8283, 140230, 'ARCELORMITTAL NIPPON STEEL INDIA LIMITED', 'essarsteel.co.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8284, 140240, 'LeeWrangler Hong Kong Limited', 'kontoorbrands.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8285, 140241, 'M.H Broad Band', 'mhbroadband.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8286, 140242, 'INDHUANDMAHADEV BROADBAND PVT LIMITED', 'imbroadbandmpl.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8287, 140243, 'CMD Cable Vision, Inc', 'None', 'PH', 512, 'isp', '0000-00-00 00:00:00', 0),
(8288, 140244, 'Brian Blevins', 'None', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(8289, 14026, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 3584, 'business', '2008-09-04 00:00:00', 0),
(8290, 14027, 'Beacon Wireless', 'beaconwireless.ca', 'CA', 2048, 'isp', '2018-04-04 00:00:00', 0),
(8291, 140287, 'OK Network and Communications', 'okay.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8292, 140288, 'Toa Online', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8293, 1403, 'EBOX', 'ebox.ca', 'CA', 247808, 'isp', '2009-07-28 00:00:00', 0),
(8294, 140304, 'ASIAPAY (HK) LIMITED', 'asiapay.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8295, 140307, 'High Tech IT & Communication', 'hightechitbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8296, 140308, 'CHINATELECOM Guangdong province Zhuhai 5G network', 'chinatelecom.cn', 'CN', 4096, 'isp', '0000-00-00 00:00:00', 0),
(8297, 140310, 'CHINATELECOM Guangdong province Dongguan 5G network', 'chinatelecom.cn', 'CN', 20480, 'isp', '0000-00-00 00:00:00', 0),
(8298, 140312, 'CHINATELECOM Guangdong province Zhanjiang 5G network', 'chinatelecom.cn', 'CN', 2304, 'isp', '0000-00-00 00:00:00', 0),
(8299, 140313, 'CHINATELECOM Guangdong province Zhaoqing 5G network', 'chinatelecom.cn', 'CN', 10240, 'isp', '0000-00-00 00:00:00', 0),
(8300, 140314, 'CHINATELECOM Guangdong province Shantou 5G network', 'chinatelecom.cn', 'CN', 3584, 'isp', '0000-00-00 00:00:00', 0),
(8301, 140315, 'CHINATELECOM Guangdong province Jieyang 5G network', 'chinatelecom.cn', 'CN', 2048, 'isp', '0000-00-00 00:00:00', 0),
(8302, 140316, 'CHINATELECOM Guangdong province Chaozhou 5G network', 'chinatelecom.cn', 'CN', 12032, 'isp', '0000-00-00 00:00:00', 0),
(8303, 140317, 'CHINATELECOM Guangdong province Shaoguan 5G network', 'chinatelecom.cn', 'CN', 26112, 'isp', '0000-00-00 00:00:00', 0),
(8304, 14032, 'Foot Locker Corporate Services, Inc', 'footlocker.com', 'US', 256, 'business', '2020-05-29 00:00:00', 0),
(8305, 140325, 'NEXION Networks Pty Ltd', 'nexionnetworks.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8306, 140326, 'Symphony Communication Public Company Limited for TC', 'violin.co.th', 'TH', 1024, 'business', '0000-00-00 00:00:00', 0),
(8307, 140327, 'Advent One', 'adventone.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8308, 14034, 'Swire Coca-Cola, USA', 'swirecc.com', 'US', 256, 'business', '2011-02-16 00:00:00', 0),
(8309, 140345, 'CHINATELECOM Yunnan province Shengji 5G network', 'chinatelecom.cn', 'CN', 4352, 'isp', '0000-00-00 00:00:00', 0),
(8310, 14035, 'KATTEN MUCHIN ROSENMAN LLP', 'kattenlaw.com', 'US', 256, 'business', '2014-02-18 00:00:00', 0),
(8311, 14037, '6G Networks Inc', '6gg.biz', 'US', 8448, 'business', '2007-06-12 00:00:00', 0),
(8312, 14038, 'Drake University', 'drake.edu', 'US', 8704, 'education', '2019-02-08 00:00:00', 0),
(8313, 140380, 'Fastnet', 'fastnetbd.org', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8314, 140382, 'Way South Internet & Phone', 'wsip.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8315, 140384, 'PT BITNIAGA CIPTA GEMILANG', 'bitniaga.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8316, 140385, 'PT Inti Tech Indonesia', 'intitech.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8317, 140386, 'PUSAT PENGELOLAAN DANA PEMBIAYAAN PERUMAHAN (PPDPP)', 'ppdpp.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8318, 140387, 'PT. Multi Terminal Indonesia', 'ipclogistic.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8319, 140389, 'PT Dewa Bisnis Digital', 'dewabiz.com', 'ID', 1024, 'business', '0000-00-00 00:00:00', 0),
(8320, 140390, 'PT BUROQ SARANA INFORMATIKA', 'buroqnet.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8321, 140392, 'PT Java United Services', 'javaunited.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8322, 140394, 'DIREKTORAT JENDERAL KEKAYAAN INTELEKTUAL KEMENTERIAN HUKUM DAN HAM REPUBLIK INDONESIA', 'dgip.go.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8323, 140395, 'PT RADNET DIGITAL INDONESIA', 'radnet-digital.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8324, 140396, 'PT. PANDU PALAPA TELEMATIKA', 'papatel.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8325, 140397, 'PT. Starcom Technology Indonesia', 'starcomindo.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8326, 140398, 'Dinas Komunikasi Dan Informatika Kabupaten Natuna', 'natunakab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8327, 140399, 'PT Parsaoran Global Datatrans', 'hspnet.net', 'ID', 256, 'isp', '0000-00-00 00:00:00', 0),
(8328, 140401, 'PT Proxi Jaringan Nusantara', 'proxinet.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8329, 140402, 'PT. ALGA JAYA SOLUSI', 'algajayasolusi.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8330, 140403, 'PT. Graha Fatta', 'grahafatta.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8331, 140404, 'PT TERABYTE INDONESIA', 'terabyte.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8332, 140405, 'PT. Cybertechtonic Pratama', 'cbtp.co.id', 'ID', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8333, 140406, 'Pemerintah Kabupaten Bolaang Mongondow', 'bolmongkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8334, 140407, 'KitaNet', 'kitanet.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8335, 140409, 'PT Berlian Sistem Informasi', 'bsi.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8336, 14041, 'University Corporation for Atmospheric Research', 'ucar.edu', 'US', 262656, 'education', '1999-10-07 00:00:00', 0),
(8337, 140410, 'Politeknik Negeri Lampung', 'polinela.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8338, 140411, 'UNIVERSITAS PARAMADINA', 'paramadina.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8339, 140413, 'PT. GAYUH MEDIA INFORMATIKA', 'gayuh.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8340, 140415, 'PT JASAMARGA TOLLROAD OPERATOR', 'jmto.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8341, 140416, 'PT TRANS TELEKOMUNIKASI INDONESIA', 'transtelekom.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8342, 140417, 'PT Indotechno Digital Komputasi', 'indotechno.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8343, 14042, 'Comcast Cable Communications Management, LLC', 'comcast.com', 'US', 1792, 'isp', '2007-06-12 00:00:00', 0),
(8344, 140421, 'PT APLIKA DATA NUSANTARA', 'aplikadata.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8345, 140422, 'PT. Sintesa Kreasi Yudha', 'syknetwork.web.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8346, 140423, 'PT Chandra Media Nusantara', 'cmedia.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8347, 140424, 'DINAS KOMUNIKASI INFORMATIKA STATISTIK DAN PERSANDIAN PROVINSI SULAWESI SELATAN', 'sulselprov.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8348, 140426, 'Pemerintah Kabupaten Klungkung', 'klungkungkab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8349, 140427, 'PT Perkebunan Nusantara IV (PTPN IV)', 'ptpn4.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8350, 140428, 'PT Pancaran Samudera Transport', 'pancaran-group.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8351, 140429, 'PT. MEDIA DISTRIBUSI PRIMA', 'urbanaccess.net', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8352, 14043, 'ScanSource, Inc.', 'scansource.com', 'US', 2560, 'business', '1999-10-08 00:00:00', 0),
(8353, 140430, 'PT Zoom Infotek Telesindo', 'tokozoom.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8354, 140431, 'Dinas Komunikasi dan Informatika Kabupaten Wonogiri', 'wonogirikab.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8355, 140435, 'CV. E-Smart B', 'buanternet.com', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8356, 140436, 'DINAS KOMUNIKASI DAN INFORMATIKA PEMERINTAH KOTA TANJUNGBALAI', 'tanjungbalaikota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8357, 140442, 'PT Nusantara Teknologi Semesta', 'nusateknologi.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8358, 140443, 'PT Herza Digital Indonesia', 'herza.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8359, 140446, 'PT Kingpolah Network Solutions', 'kingpolahnetwork.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8360, 14045, 'Change Healthcare', 'changehealthcare.com', 'US', 28672, 'business', '2016-10-12 00:00:00', 0),
(8361, 140452, 'PT Jaya Media Expres', 'apjii.or.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8362, 140453, 'PT Cirebon Energi Prasarana', 'cirebonpower.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8363, 140454, 'PT Persada Nayaka Infotama', 'persadanayakainfotama.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8364, 140455, 'Dinas Komunikasi dan Informatika Kota Samarinda', 'samarindakota.go.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8365, 140456, 'PT Era Awan Digital', 'eranyacloud.com', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8366, 140459, 'PT Mikrotik Indonesia Streaky', 'apjii.or.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8367, 14046, 'KC ONLINE, LLC', 'kconlineinc.com', 'US', 4096, 'business', '1999-10-08 00:00:00', 0),
(8368, 140460, 'PT Nitnet Media Teknologi', 'nmt.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8369, 140461, 'PT Sky Network Solution', 'sns.net.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8370, 140462, 'PT Mandala Desa Warnana', 'mandesa.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8371, 140463, 'Sekolah Tinggi Teknologi Kedirgantaraan Yogyakarta', 'sttkd.ac.id', 'ID', 256, 'education', '0000-00-00 00:00:00', 0),
(8372, 140464, 'PT Widara Media Informasi', 'wmi.net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8373, 140465, 'PT Andalas Global Network', 'anetindo.id', 'ID', 768, 'business', '0000-00-00 00:00:00', 0),
(8374, 140467, 'PT Kreatif Global Solusindo', 'creative.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8375, 140469, 'PT Wahyu Adidaya Network', 'wahyuadidaya.co.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8376, 14047, 'Ferris MFG Corp', 'ferrispolymem.com', 'US', 256, 'business', '2006-11-20 00:00:00', 0),
(8377, 140475, 'PT Citra Celebas Multimedia', 'primahome.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8378, 140476, 'PT Ardi Jaya Solusindo', 'ajs.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8379, 14048, 'The University of Memphis', 'memphis.edu', 'US', 65536, 'education', '1999-10-11 00:00:00', 0),
(8380, 140481, 'PT Tonggak Teknologi Netikom', 't2net.id', 'ID', 512, 'business', '0000-00-00 00:00:00', 0),
(8381, 14049, 'Golden Gate University', 'ggu.edu', 'US', 768, 'education', '1999-10-11 00:00:00', 0),
(8382, 1405, 'LION APPAREL', 'lionapparel.com', 'US', 256, 'business', '2009-07-28 00:00:00', 0),
(8383, 140502, 'Bahanno', 'bahanno.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8384, 14051, 'Consolidated Communications, Inc.', 'consolidated.com', 'US', 155392, 'isp', '1999-10-11 00:00:00', 0),
(8385, 14052, 'Stephens, Inc.', 'stephens.com', 'US', 1024, 'business', '2010-05-05 00:00:00', 0),
(8386, 140523, 'Manikgonj Network', 'manikgonjnetwork.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8387, 140524, 'People N Tech Limited', 'piit.us', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8388, 140526, 'The Bank of Khyber', 'bok.com.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(8389, 140539, 'Mirpur DOHS Digital Network', 'mirpurdohsdigitalnetwork.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8390, 140541, 'Optima', 'optimabd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8391, 140544, 'INNOVATIVE TECHNOLOGY & ENGINEERING', 'itebd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(8392, 140545, 'Pathcom Technologies Pvt Ltd', 'pathcomtech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8393, 140546, 'United Enterprises & CO Ltd.', 'united.com.bd', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8394, 140548, 'Reserve Bank of New Zealand', 'rbnz.govt.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8395, 14055, 'Dougherty Financial Group LLC', 'doughertymarkets.com', 'US', 256, 'business', '2010-04-16 00:00:00', 0),
(8396, 140552, 'Co-operative Bank Public Company Limited', 'cbbank.com.mm', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(8397, 140553, 'CHINATELECOM XINJIANG province Shengji 5G network', 'chinatelecom.cn', 'CN', 32768, 'isp', '0000-00-00 00:00:00', 0),
(8398, 14056, 'SEI Investments', 'seic.com', 'US', 768, 'business', '1999-10-13 00:00:00', 0),
(8399, 14057, 'TENNESSEE FARMERS MUTUAL INSURANCE COMPANY', 'fbitn.com', 'US', 512, 'business', '2006-10-04 00:00:00', 0),
(8400, 140570, 'Hong Kong Beecloud System Technology Services Limited', 'beecloudsystem.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8401, 140572, 'National Institute of Metrology (Thailand)', 'nimt.or.th', 'TH', 768, 'business', '0000-00-00 00:00:00', 0),
(8402, 140575, 'National Statistical Office', 'nso.go.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(8403, 140577, 'Ahrefs Pte Ltd', 'ahrefs.com', 'SG', 512, 'business', '0000-00-00 00:00:00', 0),
(8404, 140578, 'BNP Paribas India Solutions Pvt. Ltd', 'bnpparibas.com', 'SG', 256, 'business', '0000-00-00 00:00:00', 0),
(8405, 14058, 'PointClick Technologies, LLC', 'pointclick.net', 'US', 1536, 'business', '2010-05-10 00:00:00', 0),
(8406, 140581, 'Aqura Technologies', 'aqura.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8407, 140583, 'OPTITEL PTY LTD', 'optitel.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8408, 140585, 'Fiber Net', 'fibernetcumilla.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8409, 140586, 'Velo Technologies SDN BHD', 'velo-technologies.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(8410, 140587, 'Western Health', 'westernhealth.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8411, 14059, 'Weblications, LLC', 'weblications.com', 'US', 512, 'business', '1999-10-13 00:00:00', 0),
(8412, 140591, 'HK TESUCH GLOBAL CO., LIMITED', 'zhtd.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8413, 140592, 'GOVERNMENT TECHNOLOGY AGENCY', 'tech.gov.sg', 'SG', 1024, 'business', '0000-00-00 00:00:00', 0),
(8414, 140594, 'New Pakistan Cable Network (Firm)', 'pakistaninternet.com.pk', 'PK', 512, 'business', '0000-00-00 00:00:00', 0),
(8415, 140596, 'SHENZHEN TUTENG NETWORK CO.,LTD', 'mytoten.com', 'CN', 768, 'business', '0000-00-00 00:00:00', 0),
(8416, 140598, 'Wi-Sky Queensland Pty Ltd', 'wi-sky.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8417, 140599, 'COMFAC CORPORATION', 'comfactechoptions.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(8418, 1406, 'Motorola Inc', 'motorola.com', 'US', 3584, 'business', '2009-07-28 00:00:00', 0),
(8419, 14060, 'Brookdale Senior Living Inc', 'brookdale.com', 'US', 1280, 'business', '2017-08-10 00:00:00', 0),
(8420, 140601, 'POWERSCHOOL INDIA PRIVATE LIMITED', 'powerschool.com', 'IN', 256, 'education', '0000-00-00 00:00:00', 0),
(8421, 140603, 'CEA Technologies PTY LTD', 'cea.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8422, 140607, 'Sign In (PVT) LTD', 'signin.com.pk', 'PK', 2560, 'isp', '0000-00-00 00:00:00', 0),
(8423, 140608, 'SMART MULTIMEDIA (PRIVATE) LIMITED', 'smartmultinet.com', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(8424, 14061, 'DigitalOcean, LLC', 'digitalocean.com', 'US', 2328832, 'hosting', '2012-09-25 00:00:00', 0),
(8425, 140611, 'RED ONLINE', 'redonlinebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8426, 140612, 'DESH COMMUNICATIONS', 'deshcomm.net', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8427, 140614, 'ASIA-ISP CO., LIMITED', 'asia-isp.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8428, 140616, 'ZN IT Solution', 'znit.net.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8429, 140617, 'THAN PHYO THU MINING COMPANY LIMITED', 'thanphyothu.com', 'MM', 512, 'business', '0000-00-00 00:00:00', 0),
(8430, 140618, 'Silpakorn University', 'su.ac.th', 'TH', 1792, 'education', '0000-00-00 00:00:00', 0),
(8431, 140619, 'JSLINK INTERNATIONAL CORPORATION', 'hkjs.com', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(8432, 14062, 'AKQA, Inc.', 'akqa.com', 'US', 1024, 'business', '2011-12-07 00:00:00', 0),
(8433, 140621, 'KFIN TECHNOLOGIES PRIVATE LIMITED', 'karvy.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8434, 140623, 'The Scots College', 'tsc.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(8435, 140624, 'New Digital Cable Network Internet', 'digitalcablenetwork.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8436, 140626, 'Kaliganj Online Service', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8437, 140629, 'ANZENNA SOLUTIONS', 'anzenna.net', 'HK', 768, 'business', '0000-00-00 00:00:00', 0),
(8438, 140630, 'JSLINK INTERNATIONAL CORPORATION', 'hkjs.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8439, 140631, 'Global Digital Management Solutions Co Ltd', 'global-dms.com', 'LA', 512, 'business', '0000-00-00 00:00:00', 0),
(8440, 140635, '3C Link Technology Sole Co., Ltd.', 'None', 'LA', 512, 'isp', '0000-00-00 00:00:00', 0),
(8441, 140637, 'Macquarie Telecom Group Pty Ltd', 'macquarietelecom.com', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8442, 140639, 'Pymble Ladies\' College', 'pymblelc.nsw.edu.au', 'AU', 256, 'education', '0000-00-00 00:00:00', 0),
(8443, 14064, 'NRECA', 'nreca.org', 'US', 256, 'business', '2007-09-25 00:00:00', 0),
(8444, 140640, 'INTERPACKET NETWORKS', 'interpacket.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8445, 140641, 'YOTTA NETWORK SERVICES PRIVATE LIMITED', 'yotta.com', 'IN', 2560, 'business', '0000-00-00 00:00:00', 0),
(8446, 140643, 'Netbright', 'netbright.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8447, 140644, 'Skylark Network', 'skylarkbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8448, 140645, 'GAAISHING INDUSTRIAL HOLDINGS LIMITED', 'gaaishing.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8449, 140647, 'CHINATELECOM Guizhou province Shengji 5G network', 'chinatelecom.cn', 'CN', 29440, 'isp', '0000-00-00 00:00:00', 0),
(8450, 14065, 'Charter Communications Inc', 'charter.com', 'US', 20736, 'isp', '1999-10-14 00:00:00', 0),
(8451, 140659, 'Vonet technology Co., Ltd.', 'vonet.net', 'KH', 768, 'business', '0000-00-00 00:00:00', 0),
(8452, 14066, 'Telmetrics Inc.', 'telmetrics.com', 'CA', 1024, 'business', '2006-08-22 00:00:00', 0),
(8453, 140660, 'Satit Pattana School', 'satitpattana.ac.th', 'TH', 512, 'education', '0000-00-00 00:00:00', 0),
(8454, 140662, 'AEON Thana Sinsap (Thailand) Public Company Limited', 'uih.co.th', 'TH', 768, 'isp', '0000-00-00 00:00:00', 0),
(8455, 140664, 'Cogent Broadband', 'cogentbroadband.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8456, 140667, 'Zaara Communication', 'zaaracommunication.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8457, 140668, 'Faster Communication', 'fconlinectg.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8458, 140669, 'Best Communication', 'bestcommunication.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8459, 14067, '4 Over, Inc.', '4over.com', 'US', 256, 'business', '2006-08-10 00:00:00', 0),
(8460, 140670, 'pact it solutions', 'pactict.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8461, 140671, 'Arriga International Limited', 'arriga.hk', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8462, 140672, 'LUTHERAN CHURCH OF AUSTRALIA INC', 'lca.org.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8463, 140673, 'Alvi Enterprise', 'alvienterprise.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8464, 14068, 'Playboy', 'playboy.com', 'US', 256, 'business', '1999-10-14 00:00:00', 0),
(8465, 140680, 'NRG Automation Ltd', 'nrga.co.nz', 'NZ', 512, 'business', '0000-00-00 00:00:00', 0),
(8466, 140681, 'AADVANCE INFOTECH', 'aadvanceinfotech.com', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8467, 140682, 'ASIAN DATA PLEDGE', 'asiandatapledge.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8468, 140685, 'CHAPMAN TRIPP HOLDINGS LIMITED', 'chapmantripp.com', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8469, 140691, 'Net Online', 'netonlinebd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8470, 140693, 'The Walt Disney Company (HK) Ltd', 'disney.com', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8471, 140699, 'Royal Thai Army', 'weloverta.org', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(8472, 1407, 'Quotemedia', 'quotemedia.com', 'US', 256, 'business', '2009-07-28 00:00:00', 0),
(8473, 14070, 'Valley Health System', 'valleyhealth.com', 'US', 1280, 'business', '2007-06-13 00:00:00', 0),
(8474, 140702, 'Amtac Professional Services Pty Ltd', 'amtac.net', 'AU', 1280, 'business', '0000-00-00 00:00:00', 0),
(8475, 140705, 'Grasp Pharmaceuticals Ltd.', 'grasppharma.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8476, 14071, 'PQ Corporation', 'pqcorp.com', 'US', 256, 'business', '2006-08-09 00:00:00', 0),
(8477, 140710, 'NKH SOLUTION SDN BHD', 'nkhsolution.com', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(8478, 140711, 'Deshnet Broadband', 'deshnetbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8479, 140712, 'COX LINK IT', 'coxlinkit.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8480, 140713, 'OZ MINERALS LTD', 'ozminerals.com', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8481, 140714, 'Agilenaas Network Technology (Shanghai) Co,.Ltd', 'agilenaas.com', 'CN', 512, 'business', '0000-00-00 00:00:00', 0),
(8482, 140715, 'KF Network Limited Corp.', 'kfglobal.ph', 'PH', 256, 'business', '0000-00-00 00:00:00', 0),
(8483, 14072, 'Government of the District of Columbia', 'dc.gov', 'US', 5632, 'business', '1999-10-14 00:00:00', 0),
(8484, 140723, 'Huawei Technologies India Pvt Ltd.,', 'huaweihcc.com', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8485, 140724, 'RACT PTY LTD', 'ract.com.au', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8486, 14073, 'Next Jump, Inc.', 'nextjump.com', 'US', 1536, 'business', '2007-04-05 00:00:00', 0),
(8487, 140730, 'UNIVERSAL CUSTOMISED NETWORKING TECHNICAL SOLUTIONS PTY LTD', 'ucnts.com.au', 'AU', 256, 'business', '0000-00-00 00:00:00', 0),
(8488, 140732, 'THE INFINITY BROADBAND (PVT) LIMITED', 'infinitybroadband.net', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(8489, 140733, 'Wujidun Network Limited', 'None', 'HK', 768, 'hosting', '0000-00-00 00:00:00', 0),
(8490, 140734, 'Watch Tower Bible and Tract Society of the Philippines', 'jw.org', 'PH', 512, 'business', '0000-00-00 00:00:00', 0),
(8491, 140736, 'Edge Data Centres Pty Ltd', 'leadingedgedc.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8492, 140739, 'USDC TECHNOLOGY JSC', 'usdc.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8493, 14074, 'Colgate-Palmolive Co.', 'colgate.com', 'US', 3072, 'business', '1999-10-14 00:00:00', 0),
(8494, 140740, 'HA CUONG TRADING INVESTMENT COMPANY LIMITED', 'hacuong.net', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8495, 140742, 'Asia Soft Co., Ltd', 'dzogame.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8496, 140744, 'Hanoi Technology and Equipment Joint Stock Company', 'abbank.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8497, 140746, 'MCT Technology Solution Joint Stock Company', 'aohoa.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8498, 140748, 'Vinh Long Department of Information and Communications', 'vinhlong.gov.vn', 'VN', 512, 'business', '0000-00-00 00:00:00', 0),
(8499, 14076, 'Secure Network USA, LLC', 'securenetinc.com', 'US', 768, 'business', '2012-11-29 00:00:00', 0),
(8500, 14078, 'Voicenetpulse Telecom Inc.', 'voicenetpulse.ca', 'CA', 1792, 'isp', '2017-07-19 00:00:00', 0),
(8501, 14080, 'Telmex Colombia S.A.', 'telmexla.net.co', 'CO', 821760, 'isp', '1999-10-15 00:00:00', 0),
(8502, 140840, 'Wired Networks Ltd', 'wired.net.nz', 'NZ', 1024, 'business', '0000-00-00 00:00:00', 0),
(8503, 140847, 'Update Technology', 'updatetechbd.com', 'BD', 768, 'business', '0000-00-00 00:00:00', 0),
(8504, 14085, 'LEARN', 'tx-learn.net', 'US', 768, 'business', '2007-06-13 00:00:00', 0),
(8505, 140851, 'Ryman Healthcare Limited', 'rymanhealthcare.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8506, 14086, 'Montreal Internet Exchange Inc.', 'umontreal.ca', 'CA', 256, 'business', '2014-04-07 00:00:00', 0),
(8507, 140864, 'R. N. Link', 'rnlink.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8508, 140865, 'Masud It', 'masudit.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8509, 140866, 'TRUE PACKET SDN BHD', 'true-packet.net', 'MY', 512, 'business', '0000-00-00 00:00:00', 0),
(8510, 140868, 'Ayao Takata', 'svrop.net', 'JP', 256, 'business', '0000-00-00 00:00:00', 0),
(8511, 140869, 'Gigabox Private Limited', 'gigabox.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8512, 140871, 'Zeta FZ-LLC', 'zeta.in', 'IN', 256, 'business', '0000-00-00 00:00:00', 0),
(8513, 140874, 'Rapidweb Networks Limited', 'rapidweb.co.nz', 'NZ', 256, 'business', '0000-00-00 00:00:00', 0),
(8514, 140876, 'Splash Internet Pty Ltd', 'splashinternet.org', 'AU', 1024, 'business', '0000-00-00 00:00:00', 0),
(8515, 140877, 'Roza Network BD', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8516, 140879, 'Crescent Network Service', 'cns.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8517, 14088, 'Westmoreland Intermediate Unit', 'wiu7.org', 'US', 3072, 'business', '1999-10-19 00:00:00', 0),
(8518, 140885, 'FADEDSERVERS PTY LTD', 'fadedservers.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8519, 140886, 'UNICOM Guangxi province network', 'chinaunicom.cn', 'CN', 7168, 'isp', '0000-00-00 00:00:00', 0),
(8520, 140888, 'MTN.COM', 'mtn.com', 'BD', 512, 'isp', '0000-00-00 00:00:00', 0),
(8521, 14089, 'CanNet Internet Services, Inc.', 'cannet.com', 'US', 3840, 'business', '1999-10-19 00:00:00', 0),
(8522, 140890, 'McDonald\'s Corporation', 'mcd.com', 'US', 256, 'business', '0000-00-00 00:00:00', 0),
(8523, 140898, 'Net City', 'netcity1.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8524, 1409, 'Catapulsion LLC', 'catapulsion.net', 'US', 256, 'business', '2014-02-18 00:00:00', 0),
(8525, 14090, 'NORTH DAKOTA TELEPHONE COMPANY', 'gondtc.com', 'US', 30464, 'isp', '1999-10-19 00:00:00', 0),
(8526, 140900, 'Getlinks (SMC-Private) Limited', 'getlinks.net.pk', 'PK', 256, 'business', '0000-00-00 00:00:00', 0),
(8527, 140901, 'Web Rangers.net', 'webrangers.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8528, 140902, 'Infatica Pte. Ltd', 'king-servers.com', 'SG', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8529, 140905, 'Keepit A/S', 'keepit.com', 'DK', 256, 'business', '0000-00-00 00:00:00', 0),
(8530, 140906, 'MAYA SOFT', 'mayasoftbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8531, 14091, 'DSM Technology Consultants', 'dsm.net', 'US', 4352, 'business', '1999-10-19 00:00:00', 0),
(8532, 140916, 'Marium Network', 'mariumnetwork.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8533, 140917, 'ERA TRADERS', 'eratraders.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8534, 14092, 'AMERIPRISE FINANCIAL SERVICES, INC.', 'ameriprise.com', 'US', 512, 'business', '2018-05-16 00:00:00', 0),
(8535, 140923, 'Global Link', 'globallinkbd.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8536, 140927, 'SKY MOVIE PHILIPPINES CATV', 'None', 'PH', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8537, 140930, 'Pabna Cable Vision Dot Net', 'pabnacablevision.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8538, 140933, 'GEEK INSIDE NETWORKS', 'geekinside.io', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8539, 14094, 'Big Lots Stores, Inc.', 'biglotscorporate.com', 'US', 512, 'business', '2008-12-19 00:00:00', 0),
(8540, 140940, 'PT Bank Kesejahteraan Ekonomi', 'bankbke.co.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8541, 140941, 'Full Time Hosting', 'fulltimehosting.net', 'PK', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8542, 140944, 'ChangXin Group China Corporation Limited', 'cxgrp.com', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8543, 140947, 'SnTHostings', 'snthostings.com', 'IN', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8544, 140948, 'Neo Link Pvt. Ltd.', 'neolink.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(8545, 140949, 'Diginet', 'diginetbd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8546, 14095, 'Hugh Chatham Memorial Hospital, Inc.', 'hughchatham.org', 'US', 256, 'business', '2008-06-10 00:00:00', 0),
(8547, 140950, 'SYNC ONLINE', 'synconlinebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8548, 140954, 'CENTURY LINK NETWORK', 'centurylinknetworkbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8549, 140956, 'ONEIRIC GROUP PTY LTD', 'oneiric.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8550, 14096, 'First Rate, Inc.', 'firstrate.com', 'US', 256, 'business', '2010-10-14 00:00:00', 0),
(8551, 140962, 'IDEA TEC LTD', 'None', 'BD', 512, 'hosting', '0000-00-00 00:00:00', 0),
(8552, 140963, 'Transcom Limited', 'transcombd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8553, 140966, 'Pals Network Pvt. Ltd', 'palsnet.com.np', 'NP', 512, 'isp', '0000-00-00 00:00:00', 0),
(8554, 140967, 'Steele Technology PTY LTD', 'steelenet.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8555, 140980, 'Nalta Vision', 'naltavision.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8556, 140981, 'HIGH RANGE INTERNET SERVICE', 'highrangebd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8557, 140982, 'Opicle Technologies Private Limited', 'opicle.org', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8558, 140983, 'Dhipaya Insurance Public Co. Ltd.', 'dhipaya.co.th', 'TH', 512, 'business', '0000-00-00 00:00:00', 0),
(8559, 140986, 'M.C. Broadband', 'mcbroadbandbd.com', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8560, 140989, 'Broad Band Nepal Pvt. Ltd.', 'broadbandnepal.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(8561, 14099, 'On-Call Solutions', 'oncallsolutions.ca', 'CA', 256, 'business', '2015-01-28 00:00:00', 0),
(8562, 140990, 'IS Services Limited', 'is-services.com.hk', 'HK', 256, 'business', '0000-00-00 00:00:00', 0),
(8563, 140991, 'SUPEREIGHT NETWORKS PVT. LTD.', 'supereight.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(8564, 140992, 'GEO NET', 'geobd.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8565, 140993, 'Beacon Link', 'beaconlink.net', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8566, 140994, 'Gigawave Communications', 'gigawave.com.au', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8567, 140995, 'The 1 Web Solution', 'onewebbd.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8568, 140999, 'SEQUELWP PTY LTD', 'sequelwp.com', 'AU', 512, 'business', '0000-00-00 00:00:00', 0),
(8569, 1410, 'SMITH BAGLEY INC', 'smith.co', 'US', 4096, 'business', '2009-07-30 00:00:00', 0),
(8570, 14100, 'GARBER MANAGEMENT GROUP, INC.', 'garberauto.com', 'US', 256, 'business', '2014-07-28 00:00:00', 0),
(8571, 141001, 'Flinty Network', 'rixcloud.io', 'HK', 512, 'business', '0000-00-00 00:00:00', 0),
(8572, 141003, 'Jony Cable Network', 'None', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8573, 141004, 'QTIME BUSINESSES PRIVATE LIMITED', 'qtime.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8574, 141010, 'SAM ONLINE', 'sambd.com', 'BD', 256, 'isp', '0000-00-00 00:00:00', 0),
(8575, 141012, 'Payswiff Solutions Ltd.', 'payswiff.com.bd', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8576, 141014, 'Balaji Teleworks Development Pvt Ltd', 'fabnet.in', 'IN', 512, 'business', '0000-00-00 00:00:00', 0),
(8577, 14102, 'Transvision Reseau Inc.', 'transvision.net', 'CA', 20992, 'isp', '1999-10-20 00:00:00', 0),
(8578, 141024, 'Big Marshyangdi Net Pvt. Ltd.', 'bigmarsyangdi.net', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(8579, 14103, 'ACD.net', 'acd.net', 'US', 51712, 'isp', '1999-10-20 00:00:00', 0),
(8580, 141032, 'Nepalink Communication Pvt. Ltd.', 'nepalink.com.np', 'NP', 512, 'business', '0000-00-00 00:00:00', 0),
(8581, 141033, 'Pranta Enterprise', 'None', 'BD', 256, 'hosting', '0000-00-00 00:00:00', 0),
(8582, 141038, 'Chauddagram Broadband', 'chauddagrambroadband.net', 'BD', 256, 'business', '0000-00-00 00:00:00', 0),
(8583, 14104, 'University of Texas System', 'utsystem.edu', 'US', 34816, 'education', '1999-10-20 00:00:00', 0),
(8584, 14105, 'Secure IP', 'secureip.io', 'US', 512, 'business', '2009-05-15 00:00:00', 0),
(8585, 141051, 'Tikomdik Dinas Pendidikan Provinsi Jawa Barat', 'tikomdik-disdikjabar.id', 'ID', 256, 'business', '0000-00-00 00:00:00', 0),
(8586, 14106, 'Taylor Electric Cooperative Inc', 'taylorelectric.coop', 'US', 2048, 'business', '2018-08-02 00:00:00', 0),
(8587, 14107, 'Preferred Connections, Inc. NW', 'preferredglobal.net', 'US', 8192, 'business', '1999-10-20 00:00:00', 0),
(8588, 14109, 'Sigma Aldrich Corporation', 'sigmaaldrich.com', 'US', 1536, 'business', '2020-05-11 00:00:00', 0),
(8589, 1411, 'Christopher Newport University', 'cnu.edu', 'US', 34048, 'education', '2009-07-30 00:00:00', 0),
(8590, 14110, 'Genesys Telecommunications Laboratories,Inc.', 'genesys.com', 'US', 3584, 'business', '1999-10-20 00:00:00', 0),
(8591, 14112, 'SecureNet Information Services', 'securenet.net', 'CA', 8192, 'isp', '1999-10-22 00:00:00', 0),
(8592, 14115, 'ABSA (Amalgamated Banks of South Africa)', 'absa.africa', 'ZA', 10752, 'business', '1999-10-22 00:00:00', 0),
(8593, 141154, 'Ifosource Broadband Internet', 'ifosource.com', 'BD', 512, 'business', '0000-00-00 00:00:00', 0),
(8594, 14116, 'InternetNamesForBusiness.com', 'internetnamesforbusiness.com', 'US', 19456, 'hosting', '2001-04-09 00:00:00', 0),
(8595, 14117, 'Telefonica del Sur S.A.', 'telsur.net', 'CL', 480256, 'isp', '1999-10-22 00:00:00', 0),
(8596, 14118, 'FortisBC Inc.', 'fortisbc.com', 'CA', 256, 'business', '2018-08-03 00:00:00', 0),
(8597, 14119, 'PENN NATIONAL GAMING', 'pngaming.com', 'US', 256, 'business', '2007-06-14 00:00:00', 0),
(8598, 1412, 'Gravity Interactive, Inc.', 'gravityus.com', 'US', 1024, 'business', '2009-07-30 00:00:00', 0),
(8599, 14120, 'oneZero Financial Systems, LLC', 'onezero.com', 'US', 3328, 'business', '2011-06-06 00:00:00', 0),
(8600, 14121, 'CIBC World Markets', 'cibc.com', 'US', 512, 'business', '1999-10-25 00:00:00', 0),
(8601, 14123, 'Midnight Proxies LLC', 'midnightproxies.com', 'US', 512, 'business', '2020-02-10 00:00:00', 0),
(8602, 14124, 'GeekWerx LLC', 'geekwerx.net', 'US', 4096, 'business', '2008-12-19 00:00:00', 0),
(8603, 14125, 'Oswald Companies', 'oswaldcompanies.com', 'US', 256, 'business', '2010-12-13 00:00:00', 0),
(8604, 14126, 'VoiceStar', 'voicestar.com', 'US', 4096, 'business', '2007-06-14 00:00:00', 0),
(8605, 14127, 'Iland Internet Solutions Corporation', 'iland.com', 'US', 38400, 'business', '1999-10-25 00:00:00', 0),
(8606, 14128, 'National University', 'nu.edu', 'US', 256, 'education', '2010-02-01 00:00:00', 0),
(8607, 14131, 'DataYard', 'datayard.us', 'US', 16384, 'isp', '1999-10-25 00:00:00', 0),
(8608, 14135, 'Navisite, Inc.', 'navisite.com', 'US', 103424, 'business', '1999-10-25 00:00:00', 0),
(8609, 14136, 'PC Connection, Inc.', 'connection.com', 'US', 512, 'business', '1999-10-25 00:00:00', 0),
(8610, 14137, 'America Internet & Communications', 'americainter.net', 'US', 1280, 'business', '2014-07-21 00:00:00', 0),
(8611, 14139, 'Maxor Pharmacies', 'maxor.com', 'US', 768, 'business', '2007-06-14 00:00:00', 0),
(8612, 1414, 'Genuine Parts Company', 'genuinepartscompany.com', 'US', 1536, 'business', '2009-07-30 00:00:00', 0),
(8613, 14140, 'Auburn Essential Services', 'auburnessentialservices.net', 'US', 9216, 'isp', '2005-03-08 00:00:00', 0),
(8614, 14142, 'Bank of Botetourt, Inc.', 'bankofbotetourt.com', 'US', 256, 'business', '2007-04-05 00:00:00', 0),
(8615, 14143, 'Rock Solid Internet & Telephone', 'getrsi.com', 'US', 2048, 'business', '2014-09-24 00:00:00', 0),
(8616, 14144, 'Admin on Demand, LLC', 'aod.net', 'US', 1792, 'business', '2018-06-08 00:00:00', 0),
(8617, 14145, 'REGIONS FINANCIAL CORPORATION', 'regions.com', 'US', 2816, 'business', '2012-03-30 00:00:00', 0),
(8618, 14147, 'Bank-Fund Staff Federal Credit Union', 'bfsfcu.org', 'US', 256, 'business', '2018-08-03 00:00:00', 0),
(8619, 14148, 'Ex Libris (USA) Inc', 'exlibrisgroup.com', 'US', 5120, 'business', '1999-10-27 00:00:00', 0),
(8620, 14149, 'Icon Health & Fitness Inc', 'iconfitness.com', 'US', 768, 'business', '1999-10-27 00:00:00', 0),
(8621, 1415, 'Christus Health', 'christushealth.org', 'US', 8704, 'business', '2009-07-30 00:00:00', 0),
(8622, 14150, 'Societe de Services Dentaires (A.C.D.Q.) inc', 'servicesdentaires.ca', 'CA', 256, 'business', '2020-03-03 00:00:00', 0),
(8623, 14151, 'Investment Company Institute', 'ici.org', 'US', 256, 'business', '1999-10-27 00:00:00', 0),
(8624, 14152, 'Netpulse Services', 'netpulse-services.com', 'CA', 1024, 'business', '2007-04-05 00:00:00', 0),
(8625, 14153, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 10240, 'isp', '2007-06-14 00:00:00', 0),
(8626, 14155, 'Rural Telephone Service Co, Inc.', 'ruraltelephone.com', 'US', 48128, 'isp', '1999-10-29 00:00:00', 0),
(8627, 14157, 'GENWORTH FINANCIAL, Inc.', 'genworth.com', 'US', 4096, 'business', '2017-09-11 00:00:00', 0),
(8628, 14159, 'NetNet', 'netnet.net', 'US', 5120, 'isp', '2007-04-27 00:00:00', 0),
(8629, 1416, 'Chicago Public Schools', 'cps.edu', 'US', 5120, 'education', '2009-07-31 00:00:00', 0),
(8630, 14160, 'Premium Hosting, Inc.', 'premiumhosting.net', 'US', 1536, 'hosting', '2007-11-12 00:00:00', 0),
(8631, 14161, 'Land O\'Lakes, Inc.', 'landolakesinc.com', 'US', 4096, 'business', '1999-10-29 00:00:00', 0),
(8632, 14163, 'Shearman & Sterling', 'shearman.com', 'US', 1280, 'business', '1999-10-29 00:00:00', 0),
(8633, 14164, 'Bluegrass Cellular Inc.', 'bluegrasscellular.com', 'US', 78080, 'isp', '2005-05-11 00:00:00', 0),
(8634, 14165, 'Fastline Publications, LLC', 'fastline.com', 'US', 256, 'business', '2010-06-07 00:00:00', 0),
(8635, 14166, 'Softcom Inc.', 'softcom.com', 'CA', 1536, 'business', '1999-11-01 00:00:00', 0),
(8636, 14167, 'Multi-Ad Services, Inc.', 'multiad.com', 'US', 256, 'business', '1999-11-02 00:00:00', 0),
(8637, 14169, 'Virginia Military Institute', 'vmi.edu', 'US', 65536, 'education', '2017-07-14 00:00:00', 0),
(8638, 14170, 'Digital River, Inc.', 'digitalriver.com', 'US', 1024, 'business', '2006-08-22 00:00:00', 0),
(8639, 14173, 'PHOTOBUCKET.COM, INC.', 'photobucket.com', 'US', 2560, 'business', '2005-11-14 00:00:00', 0),
(8640, 14174, 'North Central Kansas Community Network Co.', 'nckcn.com', 'US', 10496, 'isp', '1999-11-02 00:00:00', 0),
(8641, 14175, 'HAWORTH', 'haworth.com', 'US', 256, 'business', '1999-11-02 00:00:00', 0),
(8642, 14176, 'Rhoann Enterprises Ltd.', 'webhostcanada.com', 'CA', 256, 'hosting', '2015-03-18 00:00:00', 0),
(8643, 14178, 'Megacable Comunicaciones de Mexico, S.A. de C.V.', 'mcmtelecom.com.mx', 'MX', 60416, 'business', '1999-11-02 00:00:00', 0),
(8644, 14182, 'LexisNexis Risk Data Management Inc.', 'lexisnexis.com', 'US', 4352, 'business', '1999-11-03 00:00:00', 0),
(8645, 14183, 'University of Arkansas at Little Rock', 'ualr.edu', 'US', 65536, 'education', '1999-11-04 00:00:00', 0),
(8646, 14187, 'BT LATAM COLOMBIA S.A.', 'bt.com', 'CO', 28928, 'isp', '1999-11-04 00:00:00', 0),
(8647, 14188, 'Ashland Fiber Network', 'ashlandfiber.net', 'US', 10240, 'isp', '1999-11-04 00:00:00', 0),
(8648, 14189, 'Witt-Kieffer', 'wittkieffer.com', 'US', 256, 'business', '2006-08-23 00:00:00', 0),
(8649, 1419, 'Selerity Financial, Inc.', 'seleritycorp.com', 'US', 256, 'business', '2009-07-31 00:00:00', 0),
(8650, 14190, 'Best Buy Canada Ltd.', 'bestbuycanadaltd.ca', 'CA', 1024, 'business', '2018-03-14 00:00:00', 0),
(8651, 14192, 'Carthage College', 'carthage.edu', 'US', 1280, 'education', '2006-08-23 00:00:00', 0),
(8652, 14193, 'KONGE TECH CORP', 'telnel.com', 'US', 5120, 'business', '2010-12-13 00:00:00', 0),
(8653, 14195, 'Contego Solutions LLC', 'contego.net', 'US', 768, 'business', '2006-08-23 00:00:00', 0),
(8654, 14196, 'Oath Holdings Inc.', 'oath.com', 'US', 768, 'business', '2006-07-13 00:00:00', 0),
(8655, 14198, 'New Dawn Technologies', 'journaltechnologies.com', 'US', 256, 'business', '2014-02-20 00:00:00', 0),
(8656, 14199, 'Scholastic Inc.', 'scholastic.com', 'US', 256, 'business', '2007-03-13 00:00:00', 0),
(8657, 1420, 'STL OFFICE SOLUTIONS, INC.', 'stloffice.com', 'US', 1024, 'business', '2009-07-31 00:00:00', 0),
(8658, 14200, 'Marshall University', 'marshall.edu', 'US', 18944, 'education', '2006-11-10 00:00:00', 0),
(8659, 14201, 'TeleTech Holdings, Inc', 'teletech.com', 'US', 9472, 'business', '1999-11-08 00:00:00', 0),
(8660, 14203, 'Juniper Networks, Inc.', 'juniper.net', 'US', 5120, 'business', '1999-11-09 00:00:00', 0),
(8661, 14204, 'TAVOLA CONECTIVIDADE LTDA.', 'tavola.com.br', 'BR', 6144, 'business', '1999-11-18 00:00:00', 0),
(8662, 14205, 'WAN Communications, Inc.', 'wanc.com', 'US', 4096, 'business', '1999-11-09 00:00:00', 0),
(8663, 14206, 'Motility Software Solutions, LLC', 'motilitysoftware.com', 'US', 8192, 'business', '2017-08-10 00:00:00', 0),
(8664, 14207, 'CSG Systems Inc.', 'csgsystems.com', 'US', 512, 'business', '2018-12-21 00:00:00', 0),
(8665, 14209, 'University of Tennessee at Chattanooga', 'utc.edu', 'US', 33280, 'education', '1999-11-09 00:00:00', 0),
(8666, 1421, 'WANSecurity, Inc.', 'wansec.com', 'US', 27392, 'isp', '2009-07-31 00:00:00', 0),
(8667, 14210, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 18944, 'isp', '2007-06-15 00:00:00', 0),
(8668, 14211, 'Gotham Web Services, Inc.', 'gothamweb.com', 'US', 4096, 'business', '2006-08-03 00:00:00', 0),
(8669, 14212, 'Santa Cruz County Office of Education', 'santacruz.k12.ca.us', 'US', 8448, 'education', '1999-11-09 00:00:00', 0),
(8670, 14214, 'Minacs Inc', 'minacs.com', 'CA', 2304, 'business', '2005-10-17 00:00:00', 0),
(8671, 14215, 'Sabre GLBL Inc.', 'sabre.com', 'US', 1024, 'business', '2010-03-24 00:00:00', 0),
(8672, 14216, 'IShip.com', 'iship.com', 'US', 256, 'business', '1999-11-10 00:00:00', 0),
(8673, 14218, 'Tremblant Capital Group', 'tremblantcapital.com', 'US', 256, 'business', '2006-07-21 00:00:00', 0),
(8674, 1422, 'Media6degrees', 'media6degrees.com', 'US', 768, 'business', '2009-07-31 00:00:00', 0),
(8675, 14220, 'Zoom Broadband', 'izoom4u.com', 'US', 2048, 'business', '2007-03-13 00:00:00', 0),
(8676, 14221, 'University of Washington', 'washington.edu', 'US', 2048, 'education', '2007-07-16 00:00:00', 0),
(8677, 14222, 'Navy Federal Credit Union', 'navyfederal.org', 'US', 2048, 'business', '2010-04-19 00:00:00', 0),
(8678, 14223, 'New York State Department of Health', 'ny.gov', 'US', 65792, 'isp', '1999-11-11 00:00:00', 0),
(8679, 14224, 'Tampnet Inc', 'tampnet.com', 'US', 1024, 'business', '2010-03-05 00:00:00', 0),
(8680, 14226, 'Stifel Nicolaus and Company  Incorporated', 'stifel.com', 'US', 768, 'business', '1999-11-11 00:00:00', 0),
(8681, 14228, 'New Dulcina Agridata LLC', 'ndagri.com', 'US', 1024, 'business', '2013-11-19 00:00:00', 0),
(8682, 1423, 'Carson Communications, LLC', 'rainbowtel.com', 'US', 8448, 'business', '2009-08-03 00:00:00', 0),
(8683, 14230, 'Involta', 'involta.com', 'US', 175616, 'business', '2006-08-25 00:00:00', 0),
(8684, 14232, 'Cooperativa Telefónica Pinamar Ltda.', 'telpin.com.ar', 'AR', 18432, 'isp', '1999-11-15 00:00:00', 0),
(8685, 14233, 'Ancestry.com., Inc.', 'ancestry.com', 'US', 768, 'business', '1999-11-15 00:00:00', 0),
(8686, 14234, 'ZONAMERICA', 'zonamerica.com', 'UY', 7168, 'isp', '1999-11-15 00:00:00', 0),
(8687, 14235, 'State of New Mexico', 'state.nm.us', 'US', 65536, 'business', '1999-11-15 00:00:00', 0),
(8688, 14237, 'Beamspeed LLC', 'beamspeed.com', 'US', 10752, 'isp', '2007-06-15 00:00:00', 0),
(8689, 14238, 'Innovative Networks LLC', 'in-networks.com', 'US', 2560, 'business', '2009-10-28 00:00:00', 0),
(8690, 14239, 'Rich Products Corporation', 'rich.com', 'US', 768, 'business', '2017-08-15 00:00:00', 0),
(8691, 14240, 'Microsemi Storage Solutions Ltd', 'microsemi.com', 'CA', 12288, 'business', '1999-11-15 00:00:00', 0),
(8692, 14241, 'Oakland Schools', 'oakland.k12.mi.us', 'US', 65792, 'education', '2007-06-15 00:00:00', 0),
(8693, 14242, 'City of Chandler', 'chandleraz.gov', 'US', 2048, 'business', '2014-05-27 00:00:00', 0),
(8694, 14243, 'CGS', 'cgstogo.com', 'US', 1024, 'business', '2007-06-15 00:00:00', 0),
(8695, 14244, 'NSI Hosting', 'nsihosting.com', 'US', 18944, 'hosting', '2006-08-25 00:00:00', 0),
(8696, 14246, 'Thales Communications Inc.', 'thalesdsi.com', 'US', 256, 'business', '2012-11-29 00:00:00', 0),
(8697, 14249, 'Internet Engine, S.A. de C.V.', 'mpsnet.net.mx', 'MX', 4864, 'business', '1999-11-16 00:00:00', 0),
(8698, 14251, 'Multiple Lising Service of Long Island, Inc.', 'mlsli.com', 'US', 512, 'business', '1999-11-16 00:00:00', 0),
(8699, 14252, 'School Specialty, Inc.', 'schoolspecialty.com', 'US', 512, 'education', '1999-11-16 00:00:00', 0),
(8700, 14253, 'Agio LLC', 'agioit.com', 'US', 256, 'business', '2017-07-31 00:00:00', 0),
(8701, 14255, 'University of San Diego', 'sandiego.edu', 'US', 1536, 'education', '2006-08-28 00:00:00', 0),
(8702, 14257, 'The Iserv Company, LLC', 'iserv.net', 'US', 512, 'isp', '1999-11-16 00:00:00', 0),
(8703, 14259, 'Gtd Internet S.A.', 'gtdinternet.com', 'CL', 401152, 'isp', '2001-05-16 00:00:00', 0),
(8704, 1426, 'Lightwave Networking, LLC', 'lightwave.net', 'US', 1024, 'business', '2009-08-03 00:00:00', 0),
(8705, 14262, 'CALUMET COUNTY', 'calumetcounty.org', 'US', 256, 'business', '2018-03-07 00:00:00', 0),
(8706, 14263, 'South Dakota State Government', 'state.sd.us', 'US', 33024, 'business', '1999-11-17 00:00:00', 0),
(8707, 14265, 'TPx Communications', 'tpx.com', 'US', 638464, 'isp', '1999-11-17 00:00:00', 0),
(8708, 14267, 'PTC', 'ptc.com', 'US', 2048, 'business', '2019-11-07 00:00:00', 0),
(8709, 14268, 'Northern Computer Solutions Ltd.', 'ncsl.ca', 'CA', 1024, 'business', '2009-06-19 00:00:00', 0),
(8710, 1427, 'Alion Science and Technology Corporation', 'alionscience.com', 'US', 1024, 'business', '2009-08-03 00:00:00', 0),
(8711, 14270, 'EAGLE.CA', 'eagle.ca', 'CA', 2048, 'business', '2006-08-28 00:00:00', 0),
(8712, 14272, 'MCPc Inc.', 'mcpc.com', 'US', 512, 'business', '2014-01-21 00:00:00', 0),
(8713, 14277, 'GiGstreem', 'gigstreem.com', 'US', 2560, 'business', '2017-08-15 00:00:00', 0),
(8714, 14278, 'Black Box Network Services', 'blackbox.com', 'US', 768, 'business', '1999-11-19 00:00:00', 0),
(8715, 14279, 'HD Supply, Inc.', 'hdsupply.com', 'US', 1280, 'business', '2006-08-29 00:00:00', 0),
(8716, 1428, 'DRW Holdings, LLC', 'drwtrading.com', 'US', 256, 'business', '2009-08-03 00:00:00', 0),
(8717, 14280, 'NetNation Communications Inc', 'netnation.com', 'CA', 16640, 'hosting', '1999-11-22 00:00:00', 0),
(8718, 14282, 'PERSIS TELECOM', 'persistelecom.com.br', 'BR', 6144, 'business', '2000-03-22 00:00:00', 0),
(8719, 14283, 'blueone.net', 'blueone.net', 'US', 3584, 'business', '2012-04-11 00:00:00', 0),
(8720, 14287, 'Triad Telecom, Inc.', 'triadtelecom.com', 'US', 4352, 'business', '2006-08-29 00:00:00', 0),
(8721, 14288, 'MPInet', 'mpinet.com', 'US', 72192, 'isp', '1999-11-24 00:00:00', 0),
(8722, 14289, 'COREFIRST BANK & TRUST', 'cbtks.com', 'US', 256, 'business', '2006-08-10 00:00:00', 0),
(8723, 14290, 'Answering Service for Directors', 'myasd.com', 'US', 256, 'business', '2010-12-13 00:00:00', 0),
(8724, 14291, 'Antietam Broadband', 'antietambroadband.com', 'US', 46592, 'isp', '2002-03-12 00:00:00', 0),
(8725, 14292, 'CSC Consular Services Inc.', 'csc.com', 'US', 1024, 'business', '2010-02-26 00:00:00', 0),
(8726, 14293, 'SHOPPERTRAK RCT CORPORATION', 'shoppertrak.com', 'US', 512, 'business', '2017-08-15 00:00:00', 0),
(8727, 14297, 'ACI Worldwide, Inc.', 'aciworldwide.com', 'US', 32768, 'business', '1999-11-22 00:00:00', 0),
(8728, 14298, 'Environmental Protection Agency', 'epa.gov', 'US', 262144, 'business', '1999-11-23 00:00:00', 0),
(8729, 14299, 'Automatic Data Processing, Inc.', 'adp.com', 'US', 24832, 'business', '1999-11-24 00:00:00', 0),
(8730, 1430, 'Board of Bar Overseers', 'mass.gov', 'US', 256, 'isp', '2009-08-04 00:00:00', 0),
(8731, 14301, 'Everest Global Services', 'everestnational.com', 'US', 1024, 'business', '2007-10-15 00:00:00', 0),
(8732, 14303, 'City of Memphis', 'cityofmemphis.org', 'US', 1024, 'business', '2007-10-15 00:00:00', 0),
(8733, 14305, 'Accuray Incorporated', 'accuray.com', 'US', 256, 'business', '2007-10-15 00:00:00', 0),
(8734, 14306, 'GlaxoSmithKline', 'gsk.com', 'US', 1536, 'business', '1999-11-24 00:00:00', 0);
INSERT INTO `blocked_asns` (`id`, `asn`, `isp`, `domain`, `country`, `num_ips`, `type`, `allocated`, `blocked`) VALUES
(8735, 14307, 'ROCK SERVICES, INC.', 'rock-services.net', 'US', 2048, 'business', '2006-08-29 00:00:00', 0),
(8736, 14308, 'City of Longmont', 'longmontcolorado.gov', 'US', 256, 'isp', '2007-06-15 00:00:00', 0),
(8737, 14310, 'Safra National Bank Of New York', 'safra.com', 'US', 256, 'business', '2019-03-26 00:00:00', 0),
(8738, 14311, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 1280, 'isp', '2001-12-18 00:00:00', 0),
(8739, 14312, '1-800 Contacts, Inc.', '1800contacts.com', 'US', 1280, 'business', '1999-11-24 00:00:00', 0),
(8740, 14313, 'zColo', 'corexchange.com', 'US', 5120, 'hosting', '2006-07-24 00:00:00', 0),
(8741, 14315, '1GSERVERS, LLC', '1gservers.com', 'US', 2560, 'business', '2019-02-22 00:00:00', 0),
(8742, 14317, 'Advanced Computer Connections, Inc.', 'windcastbroadband.com', 'US', 4096, 'business', '1999-11-24 00:00:00', 0),
(8743, 14319, 'Furman University', 'furman.edu', 'US', 65792, 'education', '2010-12-22 00:00:00', 0),
(8744, 1432, 'Albion College', 'albion.edu', 'US', 49152, 'education', '2009-08-04 00:00:00', 0),
(8745, 14320, 'Meredith Corp.', 'meredith.com', 'US', 512, 'business', '1999-11-24 00:00:00', 0),
(8746, 14321, 'Servicio Uniteller, Inc.', 'uniteller.com', 'US', 256, 'business', '1999-11-24 00:00:00', 0),
(8747, 14325, 'OSHEAN, Inc.', 'oshean.org', 'US', 57856, 'business', '1999-11-24 00:00:00', 0),
(8748, 14327, 'Portland General Electric Company', 'portlandgeneral.com', 'US', 12288, 'business', '2013-08-16 00:00:00', 0),
(8749, 14328, 'R.R. Donnelley and Sons, Co.', 'rrd.com', 'US', 12032, 'business', '1999-11-29 00:00:00', 0),
(8750, 14329, 'OPEN ACCESS TECHNOLOGY INTERNATIONAL, INC.', 'oati.com', 'US', 8192, 'business', '1999-11-29 00:00:00', 0),
(8751, 14330, 'Digital Insight Corporation', 'digitalinsight.com', 'US', 3840, 'business', '1999-11-30 00:00:00', 0),
(8752, 14332, 'Connexity, Inc.', 'connexity.com', 'US', 1536, 'business', '2005-05-12 00:00:00', 0),
(8753, 14333, 'On-Ramp Indiana, Inc.', 'ori.net', 'US', 21248, 'isp', '1999-11-30 00:00:00', 0),
(8754, 14334, 'Renaissance Learning Inc.', 'renaissance.com', 'US', 2048, 'business', '2010-05-10 00:00:00', 0),
(8755, 14335, 'VC3, Inc.', 'vc3.com', 'US', 8192, 'business', '1999-11-30 00:00:00', 0),
(8756, 14336, 'eHealth Saskatchewan', 'ehealthsask.ca', 'CA', 2048, 'business', '2018-01-03 00:00:00', 0),
(8757, 14337, 'CVM, INC', 'cvm.com', 'US', 512, 'business', '2010-12-13 00:00:00', 0),
(8758, 14339, 'SADESA S.A.', 'sadesa.com', 'AR', 512, 'business', '1999-11-30 00:00:00', 0),
(8759, 14340, 'Salesforce.com, Inc.', 'salesforce.com', 'US', 766976, 'isp', '1999-11-30 00:00:00', 0),
(8760, 14343, 'i2 Technologies Inc.', 'i2.com', 'US', 15104, 'business', '1999-11-30 00:00:00', 0),
(8761, 14344, 'RoundTower Technologies LLC', 'roundtower.com', 'US', 256, 'business', '2017-08-15 00:00:00', 0),
(8762, 14345, 'AMERIPRISE FINANCIAL SERVICES, INC.', 'ameriprise.com', 'US', 512, 'business', '2018-05-16 00:00:00', 0),
(8763, 14346, 'Agencia Estado Ltda', 'ae.com.br', 'BR', 8192, 'business', '2000-02-18 00:00:00', 0),
(8764, 14348, 'University of Rhode Island', 'uri.edu', 'US', 65536, 'education', '1999-12-01 00:00:00', 0),
(8765, 14349, 'Evergy Services, Inc.', 'evergy.com', 'US', 7168, 'business', '1999-12-01 00:00:00', 0),
(8766, 1435, 'New WT Miami, LLC', 'eastendcap.com', 'US', 3072, 'business', '2018-09-07 00:00:00', 0),
(8767, 14350, 'STROZ FRIEDBERG LLC', 'strozfriedberg.com', 'US', 512, 'business', '2009-10-28 00:00:00', 0),
(8768, 14351, 'Southwestern University', 'southwestern.edu', 'US', 65792, 'education', '1999-12-01 00:00:00', 0),
(8769, 14352, 'ERP Suites', 'erpsuites.com', 'US', 1792, 'business', '2007-06-18 00:00:00', 0),
(8770, 14354, 'Region 9 Education Service Center', 'esc9.net', 'US', 1024, 'education', '2007-06-18 00:00:00', 0),
(8771, 14355, 'Interstate Warehousing, Inc.', 'tippmanngroup.com', 'US', 256, 'business', '2012-06-12 00:00:00', 0),
(8772, 1436, 'Meridian Health System', 'meridianhealth.com', 'US', 1024, 'business', '2009-08-04 00:00:00', 0),
(8773, 14360, 'Alvarez & Marsal Holdings, LLC', 'alvarezandmarsal.com', 'US', 1024, 'business', '2020-05-06 00:00:00', 0),
(8774, 14361, 'HopOne Internet Corporation', 'hopone.net', 'US', 137472, 'hosting', '1999-12-02 00:00:00', 0),
(8775, 14363, 'MTC Communications, Inc.', 'mtccomm.net', 'US', 11520, 'isp', '1999-12-03 00:00:00', 0),
(8776, 14365, 'Adobe Systems Inc.', 'adobe.com', 'US', 133632, 'business', '2010-10-12 00:00:00', 0),
(8777, 14366, 'Rogers Communications Canada Inc.', 'rogers.com', 'CA', 73728, 'isp', '1999-12-03 00:00:00', 0),
(8778, 14368, 'Brazos Internet', 'brazostel.com', 'US', 4864, 'business', '2008-12-22 00:00:00', 0),
(8779, 14369, 'Nmax', 'nmax.net', 'US', 5120, 'isp', '1999-12-03 00:00:00', 0),
(8780, 1437, 'Visonex LLC', 'visonex.com', 'US', 512, 'business', '2009-08-04 00:00:00', 0),
(8781, 14371, 'Paul Bunyan Communications', 'paulbunyan.net', 'US', 36352, 'isp', '1999-12-03 00:00:00', 0),
(8782, 14372, 'Pegasystems Inc.', 'pega.com', 'US', 768, 'business', '2016-03-10 00:00:00', 0),
(8783, 14373, 'University of Texas Medical Branch', 'utmb.edu', 'US', 65536, 'education', '1999-12-03 00:00:00', 0),
(8784, 14374, 'Agri-Valley Services Corporation', 'avci.net', 'US', 12288, 'isp', '1999-12-03 00:00:00', 0),
(8785, 14376, 'FIS Securities Finance LLC', 'sungard.com', 'US', 512, 'business', '2019-09-16 00:00:00', 0),
(8786, 14378, 'Compliance Information Systems, Inc.', 'everitest.net', 'US', 1024, 'business', '2006-11-02 00:00:00', 0),
(8787, 14379, 'Northern Trust Company', 'northerntrust.com', 'US', 6144, 'business', '1999-12-05 00:00:00', 0),
(8788, 1438, 'PIONEER STATE MUTUAL INSURANCE CO.', 'psmic.com', 'US', 512, 'business', '2009-08-05 00:00:00', 0),
(8789, 14380, 'Opus Interactive', 'opusinteractive.com', 'US', 27392, 'business', '1999-12-05 00:00:00', 0),
(8790, 14381, 'Caterpillar, Inc.', 'caterpillar.com', 'US', 132608, 'business', '1999-12-05 00:00:00', 0),
(8791, 14382, 'Education Service Center', 'esc13.net', 'US', 2304, 'education', '2007-06-18 00:00:00', 0),
(8792, 14383, 'M3COM of Virginia, Inc', 'm3comva.com', 'US', 30464, 'business', '2005-05-12 00:00:00', 0),
(8793, 14384, 'HOST DESIGNS, LLC', 'hostdesigns.com', 'US', 256, 'hosting', '2005-11-21 00:00:00', 0),
(8794, 14385, 'OraMetrix, Inc.', 'amazonaws.com', 'US', 512, 'business', '2005-05-12 00:00:00', 0),
(8795, 14386, 'Com-graphics, Inc.', 'cgichicago.com', 'US', 256, 'business', '2005-05-12 00:00:00', 0),
(8796, 14387, 'SwitchWorks Technologies Inc.', 'switchworks.com', 'CA', 6144, 'business', '2005-05-12 00:00:00', 0),
(8797, 14388, 'Bronco Wine Co.', 'broncowine.com', 'US', 1280, 'business', '2010-03-05 00:00:00', 0),
(8798, 14389, 'Cash Express, LLC', 'cashtn.com', 'US', 1024, 'business', '2006-10-20 00:00:00', 0),
(8799, 1439, 'Spring Branch Independent School District', 'springbranchisd.com', 'US', 512, 'education', '2009-08-05 00:00:00', 0),
(8800, 14390, 'Coretel America, Inc.', 'coretel.net', 'US', 81920, 'business', '1999-12-06 00:00:00', 0),
(8801, 14391, 'Automatic Data Processing, Inc.', 'adp.com', 'US', 1280, 'business', '2013-02-28 00:00:00', 0),
(8802, 14395, 'Federal Home Loan Bank Of Atlanta', 'fhlbatl.com', 'US', 256, 'business', '1999-12-06 00:00:00', 0),
(8803, 14396, 'IBASIS INC.', 'ibasis.com', 'US', 256, 'isp', '1999-12-06 00:00:00', 0),
(8804, 14397, '1st Class Hosting, LLC', '1stclasshosting.com', 'US', 3584, 'hosting', '2017-07-18 00:00:00', 0),
(8805, 14398, 'Autodesk, Inc.', 'autodesk.com', 'US', 76032, 'business', '1999-12-07 00:00:00', 0),
(8806, 1440, 'Alford Media Services, Inc.', 'alfordmedia.com', 'US', 256, 'business', '2009-08-05 00:00:00', 0),
(8807, 14403, 'Jet Jet Internet LLC', 'ejetmail.net', 'US', 1024, 'business', '2018-12-27 00:00:00', 0),
(8808, 14408, 'Empire International, Ltd.', 'empire-int.com', 'US', 2816, 'business', '2006-10-04 00:00:00', 0),
(8809, 14409, 'Myers Computer Service, Inc.', 'customcomputer.com', 'US', 512, 'business', '2010-12-14 00:00:00', 0),
(8810, 1441, '360 Communications, INC', 'threesixtycomm.net', 'US', 9216, 'business', '2017-08-11 00:00:00', 0),
(8811, 14410, 'Hye Tech Network & Security Solutions, LLC', 'hyetechnetworks.com', 'US', 5120, 'business', '2010-12-22 00:00:00', 0),
(8812, 14411, 'CHF International', 'chfinternational.org', 'US', 256, 'business', '2007-06-18 00:00:00', 0),
(8813, 14413, 'LinkedIn Corporation', 'linkedin.com', 'US', 6400, 'business', '2007-01-03 00:00:00', 0),
(8814, 14414, 'Telit IoT Platforms, LLC', 'telit.com', 'US', 2048, 'business', '1999-12-08 00:00:00', 0),
(8815, 14415, 'Host Collective, Inc.', 'hostcollective.com', 'US', 10240, 'hosting', '2007-06-19 00:00:00', 0),
(8816, 14416, 'Internet de Nuevo Laredo, S.A de C.V.', 'ventuslogistics.com', 'US', 8192, 'business', '1999-12-08 00:00:00', 0),
(8817, 14417, 'Landstar System Inc', 'landstar.com', 'US', 1280, 'business', '1999-12-08 00:00:00', 0),
(8818, 14418, 'Depository Trust & Clearing Corporation', 'dtcc.com', 'US', 2048, 'business', '1999-12-08 00:00:00', 0),
(8819, 14419, 'HAAS OUTDOORS, Inc.', 'mossyoak.com', 'US', 512, 'business', '2006-10-20 00:00:00', 0),
(8820, 1442, 'SureHosting Internet Solutions, Inc.', 'surehosting.com', 'US', 3072, 'hosting', '2009-08-05 00:00:00', 0),
(8821, 14420, 'CORPORACION NACIONAL DE TELECOMUNICACIONES - CNT EP', 'cnt.gob.ec', 'EC', 4096, 'isp', '1999-12-09 00:00:00', 0),
(8822, 14421, 'Theravance Biopharma US, Inc', 'theravance.com', 'US', 256, 'business', '1999-12-09 00:00:00', 0),
(8823, 14423, 'NOVA CASUALTY COMPANY', 'novacasualty.com', 'US', 256, 'business', '2007-04-06 00:00:00', 0),
(8824, 14424, 'A.N. Deringer, Inc.', 'anderinger.com', 'US', 768, 'business', '2006-09-06 00:00:00', 0),
(8825, 14425, 'Mendocino Community Network', 'mcn.org', 'US', 512, 'business', '1999-12-09 00:00:00', 0),
(8826, 14426, 'Grant MacEwan University', 'macewan.ca', 'CA', 8704, 'education', '2007-06-19 00:00:00', 0),
(8827, 14428, 'Pomeroy', 'pomeroy.com', 'US', 512, 'business', '2011-08-01 00:00:00', 0),
(8828, 1443, 'CooperVision, Inc.', 'coopervision.com', 'US', 1280, 'business', '2009-08-05 00:00:00', 0),
(8829, 14430, 'BalsamWest FiberNET, LLC', 'balsamwest.net', 'US', 9728, 'isp', '2011-01-26 00:00:00', 0),
(8830, 14431, 'Umpqua Community College', 'umpqua.edu', 'US', 512, 'education', '2011-12-06 00:00:00', 0),
(8831, 14432, 'NTRC-Grenada', 'grex.gd', 'GD', 256, 'business', '2013-12-10 00:00:00', 0),
(8832, 14433, 'State University of New York - Oswego', 'oswego.edu', 'US', 65536, 'education', '1999-12-10 00:00:00', 0),
(8833, 14434, 'VI POWERNET, LLC', 'vipowernet.net', 'VI', 51200, 'isp', '2013-05-02 00:00:00', 0),
(8834, 14437, 'C&S WHOLESALE GROCERS INC.', 'cswg.com', 'US', 16384, 'business', '1999-12-13 00:00:00', 0),
(8835, 14438, 'USA CHOICE INTERNET SERVICES,', 'usachoice.net', 'US', 9216, 'business', '1999-12-13 00:00:00', 0),
(8836, 14439, 'Security First Bank', 'security1stbank.com', 'US', 512, 'business', '2007-08-27 00:00:00', 0),
(8837, 1444, 'Virtual Care Provider, Inc.', 'vcpi.com', 'US', 1792, 'business', '2009-08-05 00:00:00', 0),
(8838, 14440, 'Citon Computer Corp', 'citon.com', 'US', 512, 'business', '2010-10-12 00:00:00', 0),
(8839, 14441, 'Network Solutions, LLC', 'networksolutions.com', 'US', 256, 'hosting', '2002-07-18 00:00:00', 0),
(8840, 14442, 'Media-Hosts Inc.', 'media-hosts.com', 'CA', 2048, 'hosting', '2010-06-28 00:00:00', 0),
(8841, 14443, 'Broadridge Financial Solutions, Inc.', 'broadridge.com', 'US', 65536, 'business', '1999-12-14 00:00:00', 0),
(8842, 14444, 'IRESS Market Technology Canada LP', 'iress.ca', 'CA', 512, 'business', '2007-04-09 00:00:00', 0),
(8843, 14446, 'Central Newspapers Technologies Inc.', 'gannett.com', 'US', 16896, 'business', '1999-12-14 00:00:00', 0),
(8844, 14448, 'High Point University', 'highpoint.edu', 'US', 512, 'education', '2018-09-05 00:00:00', 0),
(8845, 14449, 'Dynamic Signal, Inc.', 'dynamicsignal.com', 'US', 256, 'business', '2017-10-20 00:00:00', 0),
(8846, 1445, 'Milliman, Inc.', 'milliman.com', 'US', 512, 'business', '2009-08-05 00:00:00', 0),
(8847, 14450, 'GEICO', 'geico.com', 'US', 768, 'business', '1999-12-14 00:00:00', 0),
(8848, 14451, 'GEICO', 'geico.com', 'US', 512, 'business', '1999-12-14 00:00:00', 0),
(8849, 14452, 'CMA, Inc.', 'cma.com.br', 'US', 1024, 'business', '2013-04-30 00:00:00', 0),
(8850, 14453, 'ADVANCED KNOWLEDGE NETWORKS', 'akn.ca', 'CA', 29440, 'isp', '1999-12-14 00:00:00', 0),
(8851, 14454, 'BAE Systems Applied Intelligence US Corp.', 'usa.net', 'US', 73984, 'business', '1999-12-14 00:00:00', 0),
(8852, 14455, 'Sungard Availability Network Solutions, Inc.', 'sungardas.com', 'US', 256, 'isp', '1999-12-15 00:00:00', 0),
(8853, 14456, 'Peterborough Utilities Commission', 'peterborough.ca', 'CA', 512, 'business', '1999-12-15 00:00:00', 0),
(8854, 14457, 'Radins Telecomunicações', 'radins.net.br', 'BR', 3072, 'business', '2013-04-22 00:00:00', 0),
(8855, 14458, 'World Kitchen, LLC', 'worldkitchen.com', 'US', 512, 'business', '1999-12-15 00:00:00', 0),
(8856, 14459, 'Entertainment Partners', 'ep.com', 'US', 512, 'business', '2007-06-19 00:00:00', 0),
(8857, 1446, 'Tutor Perini Corporation', 'tutorperini.com', 'US', 512, 'business', '2016-07-29 00:00:00', 0),
(8858, 14460, 'Horizon Media, Inc.', 'horizonmedia.com', 'US', 512, 'business', '2011-07-28 00:00:00', 0),
(8859, 14461, 'NET SOLUTIONS', 'netsolutionsinc.com', 'US', 256, 'isp', '1999-12-16 00:00:00', 0),
(8860, 14462, 'ION Geophysical Corporation', 'iongeo.com', 'US', 256, 'business', '2009-10-28 00:00:00', 0),
(8861, 14463, 'TDKOM INFORMATICA LTDA.', 'tdkom.com.br', 'BR', 5376, 'business', '2000-01-26 00:00:00', 0),
(8862, 14464, 'Rhode Island Network for Educ. Technology', 'oshean.org', 'US', 99072, 'business', '1999-12-16 00:00:00', 0),
(8863, 14465, 'HITN', 'hitn.org', 'US', 1024, 'business', '2006-09-28 00:00:00', 0),
(8864, 14466, 'Ariba Inc', 'ariba.com', 'US', 256, 'business', '1999-12-16 00:00:00', 0),
(8865, 14467, 'KUA.net', 'kua.net', 'US', 1792, 'business', '1999-12-16 00:00:00', 0),
(8866, 14469, 'Swishmail', 'swishmail.com', 'US', 1280, 'business', '2006-11-02 00:00:00', 0),
(8867, 1447, 'Chipotle Mexican Grill, INC', 'chipotle.com', 'US', 768, 'business', '2012-04-23 00:00:00', 0),
(8868, 14471, 'Automated Media, Inc.', 'automed5.com', 'US', 256, 'business', '2010-10-14 00:00:00', 0),
(8869, 14472, 'Rogers Communications Canada Inc.', 'rogers.com', 'CA', 13312, 'isp', '2001-07-28 00:00:00', 0),
(8870, 14473, 'Inside The Internet, Inc', 'i3web.com', 'US', 768, 'business', '2007-04-09 00:00:00', 0),
(8871, 14476, 'HONDA CANADA INC.', 'honda.ca', 'CA', 512, 'business', '2006-10-24 00:00:00', 0),
(8872, 14477, 'FINGER LAKES TECHNOLOGIES GROUP, INC.', 'fltg.com', 'US', 19200, 'isp', '2007-06-20 00:00:00', 0),
(8873, 14478, 'Irdeto Silicon Valley, Inc.', 'irdeto.com', 'US', 1280, 'business', '1999-12-20 00:00:00', 0),
(8874, 1448, 'United Cooperative Services', 'united-cs.com', 'US', 32768, 'business', '2020-01-08 00:00:00', 0),
(8875, 14480, 'County of Orangeburg', 'orangeburgcounty.org', 'US', 2048, 'business', '2014-05-28 00:00:00', 0),
(8876, 14483, 'Ruane, Cunniff & Goldfarb Inc', 'ruanecunniff.com', 'US', 256, 'business', '2013-12-09 00:00:00', 0),
(8877, 14486, 'Occidental College', 'oxy.edu', 'US', 65536, 'education', '1999-12-21 00:00:00', 0),
(8878, 14487, 'Wind River Internet', 'windriverinternet.com', 'US', 1792, 'business', '2013-10-02 00:00:00', 0),
(8879, 14488, 'City of Williamstown', 'wtownky.org', 'US', 2816, 'isp', '2014-07-21 00:00:00', 0),
(8880, 1449, 'PayPal, Inc.', 'paypal.com', 'US', 2304, 'business', '2015-03-17 00:00:00', 0),
(8881, 14491, 'Fidelity and Guaranty Life Business Services', 'fglife.com', 'US', 256, 'business', '1999-12-22 00:00:00', 0),
(8882, 14492, 'DataPipe, Inc.', 'datapipe.com', 'US', 142336, 'isp', '1999-12-22 00:00:00', 0),
(8883, 14495, 'Nasdaq, Inc.', 'nasdaq.com', 'US', 14592, 'business', '1999-12-22 00:00:00', 0),
(8884, 14498, 'Dynetics, Inc.', 'dynetics.com', 'US', 2048, 'business', '2006-11-02 00:00:00', 0),
(8885, 145, 'MCI Communications Corporation', 'verizonbusiness.com', 'US', 2048, 'isp', '1996-04-16 00:00:00', 0),
(8886, 14500, 'Galaxy Broadband Communications Inc.', 'galaxybroadband.ca', 'CA', 10240, 'isp', '2010-05-06 00:00:00', 0),
(8887, 14501, 'Enterprise Business Partners, LLC', 'enterprisecommunity.com', 'US', 512, 'business', '2012-08-24 00:00:00', 0),
(8888, 14503, 'Stowers Resource Management Inc', 'stowers.org', 'US', 256, 'business', '2018-07-18 00:00:00', 0),
(8889, 14505, 'ISLC, Inc.', 'islc.net', 'US', 4096, 'business', '1999-12-23 00:00:00', 0),
(8890, 14506, 'Oracle Corporation', 'oracle.com', 'US', 193536, 'business', '2017-01-30 00:00:00', 0),
(8891, 14507, 'Tastefully Simple', 'tastefullysimple.com', 'US', 256, 'business', '2008-06-10 00:00:00', 0),
(8892, 14509, 'AMC Theatres', 'amctheatres.com', 'US', 1280, 'business', '2008-07-21 00:00:00', 0),
(8893, 1451, 'Headquarters, USAISC', 'mail.mil', 'US', 78336, 'isp', '2004-05-12 00:00:00', 0),
(8894, 14511, 'Polar Communications', 'polarcomm.com', 'US', 12288, 'isp', '1999-12-27 00:00:00', 0),
(8895, 14512, 'Bentley University', 'bentley.edu', 'US', 65536, 'education', '2005-05-13 00:00:00', 0),
(8896, 14513, 'Des Moines Area Community College', 'dmacc.edu', 'US', 65536, 'education', '2008-12-08 00:00:00', 0),
(8897, 14514, 'Paul, Hastings, Janofsky & Walker LLP', 'paulhastings.com', 'US', 256, 'business', '1999-12-28 00:00:00', 0),
(8898, 14515, 'Sage Intacct Inc', 'intacct.com', 'US', 256, 'business', '2017-09-14 00:00:00', 0),
(8899, 14518, 'Sanford Burnham Prebys Medical Discovery Institute', 'sanfordburnham.org', 'US', 256, 'business', '2008-12-22 00:00:00', 0),
(8900, 14519, 'Applied Innovations Corporation', 'appliedi.net', 'US', 15360, 'business', '2006-10-24 00:00:00', 0),
(8901, 1452, 'Headquarters, USAISC', 'mail.mil', 'US', 427008, 'isp', '2004-05-12 00:00:00', 0),
(8902, 14521, 'Pacific Life Insurance Company', 'pacificlife.com', 'US', 1536, 'business', '1999-12-28 00:00:00', 0),
(8903, 14522, 'Satnet', 'satnet.net', 'EC', 615936, 'isp', '1999-12-28 00:00:00', 0),
(8904, 14524, 'SERCO NA', 'serco-na.com', 'US', 1024, 'business', '2007-03-14 00:00:00', 0),
(8905, 14525, 'Stellar Technologies Inc.', 'stellar-technologies.com', 'US', 1536, 'business', '2019-01-14 00:00:00', 0),
(8906, 14526, 'TekLinks, Inc.', 'teklinks.com', 'US', 2048, 'isp', '2006-09-12 00:00:00', 0),
(8907, 14527, 'Cabela\'s Inc.', 'cabelas.com', 'US', 1536, 'business', '1999-12-29 00:00:00', 0),
(8908, 14528, 'SHOTSPOTTER, INC.', 'shotspotter.com', 'US', 512, 'business', '2018-12-07 00:00:00', 0),
(8909, 14529, 'Saint Joseph\'s University', 'sju.edu', 'US', 65536, 'education', '2011-06-20 00:00:00', 0),
(8910, 1453, 'Headquarters, USAISC', 'mail.mil', 'US', 67072, 'isp', '2004-05-12 00:00:00', 0),
(8911, 14531, 'Lockheed Martin Corporation', 'lmco.com', 'US', 256, 'business', '2005-05-16 00:00:00', 0),
(8912, 14532, 'CBOSS INC', 'platesonline.net', 'US', 1024, 'business', '1999-12-30 00:00:00', 0),
(8913, 14533, 'The Union Hospital of Cecil County, Inc.', 'uhcc.com', 'US', 512, 'business', '2014-02-13 00:00:00', 0),
(8914, 14534, 'UNONET CORP', 'myunonet.com', 'PR', 256, 'business', '2017-08-16 00:00:00', 0),
(8915, 14536, 'sol.net Network Services', 'sol.net', 'US', 4608, 'business', '1999-12-30 00:00:00', 0),
(8916, 14537, 'Continent 8 LLC', 'continent8.com', 'US', 41216, 'hosting', '2017-07-20 00:00:00', 0),
(8917, 14538, 'Harrisonburg Electric Commission', 'hbgelec.com', 'US', 256, 'business', '2007-03-15 00:00:00', 0),
(8918, 14539, 'Vantage Labs LLC', 'vantage.com', 'US', 1024, 'business', '2010-06-21 00:00:00', 0),
(8919, 14543, 'SRT Communications, Inc.', 'srt.com', 'US', 33792, 'isp', '2000-01-03 00:00:00', 0),
(8920, 14545, 'AMERICAN DRIVING RECORDS, INC.', 'sambasafety.com', 'US', 768, 'business', '2000-01-04 00:00:00', 0),
(8921, 14549, 'ITC Global', 'itcglobal.com', 'US', 1024, 'business', '2006-10-24 00:00:00', 0),
(8922, 14550, 'Middlebury College', 'middlebury.edu', 'US', 65536, 'education', '2000-01-05 00:00:00', 0),
(8923, 14551, 'MCI Communications Services, Inc. d/b/a Verizon Business', 'verizonbusiness.com', 'US', 153088, 'isp', '2000-01-05 00:00:00', 0),
(8924, 14552, 'Affiliated Computer Services, Inc.', 'apservices.com', 'US', 13056, 'business', '2008-12-22 00:00:00', 0),
(8925, 14554, 'FirstHop', 'firsthop.net', 'US', 9472, 'business', '2011-02-04 00:00:00', 0),
(8926, 14556, 'Pilot Travel Centers, LLC', 'pilotflyingj.com', 'US', 1280, 'business', '2005-10-17 00:00:00', 0),
(8927, 14558, 'AMERIPRISE FINANCIAL SERVICES, INC.', 'ameriprise.com', 'US', 512, 'business', '2017-08-16 00:00:00', 0),
(8928, 14559, 'Ballard Rural Telephone Cooperative Corporation Inc.', 'brtc.net', 'US', 8192, 'business', '2007-03-15 00:00:00', 0),
(8929, 14561, 'Associated Banc-Corp', 'associatedbank.com', 'US', 1536, 'business', '2005-05-17 00:00:00', 0),
(8930, 14564, 'Alpine Funds', 'alpinefunds.com', 'US', 256, 'business', '2009-10-28 00:00:00', 0),
(8931, 14565, 'Red Rock Telecommunications, LLC', 'redrocktelecom.com', 'US', 256, 'business', '2018-08-06 00:00:00', 0),
(8932, 14566, 'Conduent Business Services, LLC', 'conduent.com', 'US', 10496, 'business', '2015-03-17 00:00:00', 0),
(8933, 14567, 'Springs Hosting', 'springshosting.com', 'US', 5120, 'hosting', '2010-12-14 00:00:00', 0),
(8934, 14568, 'North American Van Lines', 'northamerican.com', 'US', 768, 'business', '2000-01-06 00:00:00', 0),
(8935, 14569, 'Intellipop, LLC', 'intellipop.co', 'US', 2304, 'isp', '2018-01-25 00:00:00', 0),
(8936, 1457, 'Headquarters, USAISC', 'mail.mil', 'US', 18432, 'isp', '2004-05-12 00:00:00', 0),
(8937, 14570, 'I Am A Bad Actor, LLC', 'ansible.org', 'US', 256, 'business', '2020-06-05 00:00:00', 0),
(8938, 14571, 'OI MÓVEL S.A. - Em Recuperação Judicial', 'None', 'BR', 135424, 'hosting', '2000-01-13 00:00:00', 0),
(8939, 14572, 'Mother Frances Hospital Regional Health Care Center', 'trimofran.org', 'US', 2304, 'business', '2014-12-30 00:00:00', 0),
(8940, 14574, 'RTC COMMUNICATIONS', 'rtccom.com', 'US', 10240, 'business', '2000-01-06 00:00:00', 0),
(8941, 14575, 'Springer Nature  America, INC', 'springernature.com', 'US', 256, 'business', '2010-06-21 00:00:00', 0),
(8942, 14576, 'Hosting Solution Ltd.', 'king-servers.com', 'US', 11264, 'hosting', '2013-10-17 00:00:00', 0),
(8943, 14579, 'Edward D. Jones & Co., L.P.', 'edwardjones.com', 'US', 65536, 'business', '2000-01-07 00:00:00', 0),
(8944, 1458, 'Headquarters, USAISC', 'mail.mil', 'US', 65792, 'isp', '2004-05-12 00:00:00', 0),
(8945, 14580, 'Regeneration Technologies, Inc.', 'regenerationtech.org', 'US', 256, 'business', '2007-06-21 00:00:00', 0),
(8946, 14582, 'Dickinson Financial Corporation', 'dfckc.com', 'US', 256, 'business', '2013-07-08 00:00:00', 0),
(8947, 14583, 'Virginia Information Technologies Agency (VITA)', 'virginia.gov', 'US', 1024, 'business', '2005-09-22 00:00:00', 0),
(8948, 14584, 'Baker & Taylor, Inc.', 'baker-taylor.com', 'US', 256, 'business', '2000-01-07 00:00:00', 0),
(8949, 14585, 'CIFNet, Inc.', 'cifnet.net', 'US', 2048, 'business', '2000-01-07 00:00:00', 0),
(8950, 14586, 'Nuclearfallout Enterprises, Inc.', 'nfoservers.com', 'US', 4864, 'business', '2015-04-09 00:00:00', 0),
(8951, 14588, 'Activision Publishing, Inc.', 'activision.com', 'US', 1024, 'business', '2014-10-10 00:00:00', 0),
(8952, 14589, 'Digital West Networks, Inc.', 'digitalwest.com', 'US', 12544, 'business', '2000-01-07 00:00:00', 0),
(8953, 14590, 'Desert Schools Federal Credit Union', 'desertschools.org', 'US', 768, 'education', '2000-01-07 00:00:00', 0),
(8954, 14591, 'Standard Process Inc.', 'standardprocess.com', 'US', 512, 'business', '2019-02-26 00:00:00', 0),
(8955, 14593, 'Space Exploration Technologies Corporation', 'spacex.com', 'US', 256, 'business', '2018-09-05 00:00:00', 0),
(8956, 14594, 'ConfluentASP', 'confluentasp.com', 'US', 1024, 'business', '2000-01-10 00:00:00', 0),
(8957, 14597, 'Trans-System inc.', 'trans-system.com', 'US', 256, 'business', '2017-11-09 00:00:00', 0),
(8958, 14598, 'York College of Pennsylvania', 'ycp.edu', 'US', 256, 'education', '2010-07-09 00:00:00', 0),
(8959, 14599, 'Besser Company', 'besser.com', 'US', 256, 'business', '2005-10-18 00:00:00', 0),
(8960, 1460, 'Headquarters, USAISC', 'mail.mil', 'US', 65536, 'isp', '2004-05-12 00:00:00', 0),
(8961, 14600, 'MX Logic, Inc.', 'mxlogic.com', 'US', 1536, 'business', '2005-12-05 00:00:00', 0),
(8962, 14601, 'Anchorage Advisors, LLC', 'anchoragecap.com', 'US', 768, 'business', '2005-11-03 00:00:00', 0),
(8963, 14602, 'Teliax, Inc.', 'teliax.com', 'US', 2560, 'business', '2007-06-21 00:00:00', 0),
(8964, 14603, 'Ability Network Inc.', 'abilitynetwork.com', 'US', 6144, 'business', '2007-06-21 00:00:00', 0),
(8965, 14605, 'Advanced Technical Solutions, LLC', 'atsnetworking.com', 'US', 1024, 'business', '2005-11-03 00:00:00', 0),
(8966, 14607, 'OTA Management LLC', 'otallc.com', 'US', 65536, 'business', '2000-01-11 00:00:00', 0),
(8967, 14609, 'Equinix, Inc.', 'equinix.com', 'US', 7168, 'isp', '2000-01-12 00:00:00', 0),
(8968, 1461, 'Headquarters, USAISC', 'mail.mil', 'US', 5120, 'isp', '2004-05-12 00:00:00', 0),
(8969, 14610, 'Integral Development Corp.', 'integral.com', 'US', 1536, 'business', '2005-10-18 00:00:00', 0),
(8970, 14611, 'HARPER COLLINS PUBLISHERS INC.', 'harpercollins.com', 'US', 768, 'business', '2007-06-21 00:00:00', 0),
(8971, 14613, 'TOCICI LLC', 'tocici.com', 'US', 2048, 'business', '2010-06-02 00:00:00', 0),
(8972, 14614, 'Starkey Laboratories, Inc.', 'starkey.com', 'US', 768, 'business', '2007-03-15 00:00:00', 0),
(8973, 14615, 'Comporium, Inc', 'comporium.com', 'US', 169728, 'isp', '2007-04-10 00:00:00', 0),
(8974, 14616, 'IBASIS INC.', 'ibasis.com', 'US', 3072, 'isp', '2000-01-12 00:00:00', 0),
(8975, 14617, 'Select Medical Corporation', 'selectmedical.com', 'US', 512, 'business', '2017-08-17 00:00:00', 0),
(8976, 14618, 'Amazon.com, Inc.', 'amazon.com', 'US', 16180224, 'business', '2005-11-04 00:00:00', 0),
(8977, 1462, 'Headquarters, USAISC', 'mail.mil', 'US', 143872, 'isp', '2004-05-12 00:00:00', 0),
(8978, 14622, 'EXPRESSJET AIRLINES, INC.', 'expressjet.com', 'US', 256, 'business', '2012-10-30 00:00:00', 0),
(8979, 14623, 'Lubbock Christian University', 'lcu.edu', 'US', 256, 'education', '2006-11-20 00:00:00', 0),
(8980, 14625, 'PGA Tour', 'pgatour.com', 'US', 1280, 'business', '2007-06-22 00:00:00', 0),
(8981, 14626, 'Columbia/HCA Healthcare, Inc.', 'hcahealthcare.com', 'US', 7168, 'business', '2000-01-18 00:00:00', 0),
(8982, 14627, 'Vitalwerks Internet Solutions, LLC', 'vitalwerks.com', 'US', 768, 'business', '2005-11-04 00:00:00', 0),
(8983, 14628, 'Sacramento Municipal Utility District', 'smud.org', 'US', 6656, 'business', '2000-01-19 00:00:00', 0),
(8984, 1463, 'Headquarters, USAISC', 'mail.mil', 'US', 71168, 'isp', '2004-05-12 00:00:00', 0),
(8985, 14630, 'Invesco Group Services, Inc.', 'invesco.com', 'US', 8192, 'business', '2016-08-19 00:00:00', 0),
(8986, 14631, 'Empire Paper Company', 'empirepaper.com', 'US', 256, 'business', '2005-08-30 00:00:00', 0),
(8987, 14632, 'Brown Advisory', 'brownadvisory.com', 'US', 1024, 'business', '2010-10-15 00:00:00', 0),
(8988, 14633, 'Global Data Link, Inc', 'globaldatalink.com', 'US', 2304, 'business', '2009-03-16 00:00:00', 0),
(8989, 14634, 'SpinnNet', 'spinn.net', 'US', 8192, 'business', '2000-01-19 00:00:00', 0),
(8990, 14635, 'Vermont Student Assistance Corporation', 'vsac.org', 'US', 768, 'business', '2005-10-18 00:00:00', 0),
(8991, 14636, 'Internap Holding LLC', 'inap.com', 'US', 6912, 'isp', '2000-01-19 00:00:00', 0),
(8992, 14637, 'STATER BROS MARKETS', 'staterbros.com', 'US', 256, 'business', '2007-06-22 00:00:00', 0),
(8993, 14638, 'Liberty Cablevision of Puerto Rico', 'libertypr.com', 'US', 337664, 'isp', '2005-11-04 00:00:00', 0),
(8994, 14639, 'Allegiance Healthcare Corporation', 'allegiance.net', 'US', 2816, 'business', '2000-01-19 00:00:00', 0),
(8995, 1464, 'Headquarters, USAISC', 'mail.mil', 'US', 251904, 'isp', '2004-05-12 00:00:00', 0),
(8996, 14640, 'Q-Wireless, LLC', 'qwirelessbb.com', 'US', 10240, 'business', '2012-09-10 00:00:00', 0),
(8997, 14642, 'Morewave Communication Inc.', 'morewave.com', 'CA', 4864, 'business', '2005-11-04 00:00:00', 0),
(8998, 14643, 'Acosta Sales & Marketing', 'acosta.com', 'US', 768, 'business', '2018-06-08 00:00:00', 0),
(8999, 14645, 'CJIS-Consortium-20th-Court Administration', 'cjis20.org', 'US', 1024, 'business', '2008-12-22 00:00:00', 0),
(9000, 14646, 'Franklin Covey Co.', 'franklincovey.com', 'US', 256, 'business', '2010-08-23 00:00:00', 0),
(9001, 14648, 'Rand Financial Services, Inc.', 'randfinancial.com', 'US', 256, 'business', '2000-01-20 00:00:00', 0),
(9002, 14649, 'Contengent Online Systems Inc', 'contengent.com', 'US', 1536, 'business', '2017-07-18 00:00:00', 0),
(9003, 14650, 'Núcleo de Inf. e Coord. do Ponto BR - NIC.BR', 'registro.br', 'BR', 512, 'business', '2000-02-23 00:00:00', 0),
(9004, 14651, 'RSL COM Canada Inc.', 'navigata.ca', 'CA', 6656, 'business', '2000-01-20 00:00:00', 0),
(9005, 14652, 'COSTAR GROUP', 'costargroup.com', 'US', 3072, 'business', '2000-01-20 00:00:00', 0),
(9006, 14653, 'Pulsar360 Inc', 'pulsar360.com', 'US', 4096, 'business', '2005-08-30 00:00:00', 0),
(9007, 14654, 'Wayport, Inc.', 'wayport.net', 'US', 975104, 'business', '2000-01-21 00:00:00', 0),
(9008, 14655, 'Hampton University', 'hamptonu.edu', 'US', 65536, 'education', '2009-10-29 00:00:00', 0),
(9009, 14656, 'CENTRIC HEALTH RESOURCES', 'centrichealthresources.com', 'US', 256, 'business', '2013-04-01 00:00:00', 0),
(9010, 14657, 'Crown Equipment Corporation', 'crown.com', 'US', 512, 'business', '2018-08-06 00:00:00', 0),
(9011, 14658, 'NEBUTEL, INC.', 'nebutel.com', 'US', 512, 'business', '2000-01-24 00:00:00', 0),
(9012, 14659, 'ZiD Internet', 'zid.com', 'CA', 768, 'business', '2006-09-13 00:00:00', 0),
(9013, 1466, 'Headquarters, USAISC', 'mail.mil', 'US', 65792, 'isp', '2004-05-12 00:00:00', 0),
(9014, 14660, 'Elevated Computing LLC', 'elevatedcomputing.com', 'US', 256, 'business', '2014-02-07 00:00:00', 0),
(9015, 14661, 'Laurentian University', 'laurentian.ca', 'CA', 49408, 'education', '2000-01-24 00:00:00', 0),
(9016, 14662, 'Cornerstone Systems Inc.', 'csihome.com', 'US', 256, 'business', '2006-05-01 00:00:00', 0),
(9017, 14663, 'TELUS Communications Inc.', 'telus.com', 'CA', 126976, 'isp', '2000-01-24 00:00:00', 0),
(9018, 14665, 'Porch.com', 'porch.com', 'US', 256, 'business', '2018-12-07 00:00:00', 0),
(9019, 14666, 'SpiritBank', 'spiritbank.com', 'US', 256, 'business', '2005-11-04 00:00:00', 0),
(9020, 14669, 'Convergeone Unified Technology Solutions, Inc.', 'convergeone.com', 'US', 20736, 'business', '2000-01-24 00:00:00', 0),
(9021, 1467, 'Headquarters, USAISC', 'mail.mil', 'US', 210176, 'isp', '2004-05-12 00:00:00', 0),
(9022, 14671, 'FairPoint Communications', 'fairpoint.com', 'US', 17920, 'isp', '2000-01-24 00:00:00', 0),
(9023, 14672, 'Carroll-Net, Inc.', 'carroll.com', 'US', 5376, 'business', '2000-01-24 00:00:00', 0),
(9024, 14677, 'City of Tacoma', 'cityoftacoma.org', 'US', 72192, 'isp', '2000-01-26 00:00:00', 0),
(9025, 14678, 'Oath Holdings Inc.', 'oath.com', 'US', 256, 'business', '2005-06-27 00:00:00', 0),
(9026, 1468, 'Headquarters, USAISC', 'mail.mil', 'US', 135424, 'isp', '2004-05-12 00:00:00', 0),
(9027, 14681, 'Jayco, Inc', 'jayco.com', 'US', 512, 'business', '2014-03-27 00:00:00', 0),
(9028, 14683, 'Wilshire Associates Incorporated', 'wilshire.com', 'US', 256, 'business', '2010-12-14 00:00:00', 0),
(9029, 14686, 'Double Dog Communications', 'doubledogwireless.net', 'US', 4096, 'business', '2000-01-26 00:00:00', 0),
(9030, 14687, 'National Life Insurance Company', 'nationallife.com', 'US', 256, 'business', '2000-01-26 00:00:00', 0),
(9031, 14688, 'GlobalView Software Inc.', 'marketview.com', 'US', 256, 'business', '2018-11-07 00:00:00', 0),
(9032, 14689, 'Enfusion LTD. LLC', 'enfusionsystems.com', 'US', 2816, 'business', '2010-12-14 00:00:00', 0),
(9033, 14690, 'Peoria Unified School District', '