<?php
if (posix_getpwuid(posix_geteuid())['name'] == 'streamera') {
    if ($argc) {
        if (isrunning()) {
            $rConfig = parse_ini_string(file_get_contents('/home/streamera/config/config.ini'));
            if (!isset($rConfig['is_lb']) || !$rConfig['is_lb']) {
                $rPort = (intval(explode(';', explode(' ', trim(explode('listen ', file_get_contents('/home/streamera/bin/nginx/conf/ports/http.conf'))[1]))[0])[0]) ?: 80);
            }

            require str_replace('\\', '/', dirname($argv[0])) . '/../www/init.php';
            $rUpdate = $gitRelease->getUpdate(streamera_VERSION);

            if (is_array($rUpdate) && $rUpdate['version'] && (0 < version_compare($rUpdate['version'], streamera_VERSION) || version_compare($rUpdate['version'], streamera_VERSION) == 0)) {
                echo 'Update is available!' . "\n";
                $updatedChanges = array();
                foreach (array_reverse($rUpdate['changelog']) as $rItem) {
                    if (!($rItem['version'] == streamera_VERSION)) {
                        $updatedChanges[] = $rItem;
                    } else {
                        break;
                    }
                }
                $rUpdate['changelog'] = $updatedChanges;
                $db->query('UPDATE `settings` SET `update_data` = ?;', json_encode($rUpdate));
            } else {
                $db->query('UPDATE `settings` SET `update_data` = NULL;');
            }
        }
    } else {
        exit(0);
    }
} else {
    exit('Please run as STREAMERA!' . "\n");
}
function isrunning() {
    $rNginx = 0;
    exec('ps -fp $(pgrep -u streamera)', $rOutput, $rReturnVar);
    foreach ($rOutput as $rProcess) {
        $rSplit = explode(' ', preg_replace('!\\s+!', ' ', trim($rProcess)));
        if ($rSplit[8] == 'nginx:' && $rSplit[9] == 'master') {
            $rNginx++;
        }
    }
    return 0 < $rNginx;
}
